#ifndef __EXT_DEV_REGIST_H__
#define __EXT_DEV_REGIST_H__

#if (APP_OS_TYPE == APP_OS_LINUX)

#include "ext_regist.h"
#include "softap_api.h"

typedef struct TAG_PCS_USB_INFO
{
    char cPrompt;      // prompt after reciving data
    int32_t iBaudrate; // baudrate
    char cDatabit;     // data bits, 5, 6, 7, 8
    char cDebug;       // debug mode, 0: none, 1: debug
    char cEcho;        // echo mode, 0: none, 1: echo
    char cFctl;        // flow control, 0: none, 1: hardware, 2: software
    char cTty;         // tty: 0, 1, 2, 3, 4, 5, 6, 7
    char cParity;      // parity 0: none, 1: odd, 2: even
    char cStopbit;     // stop bits, 1, 2
    int32_t iReserved; // reserved, must be zero
}T_PCS_USB_INFO, *PT_PCS_USB_INFO;

typedef enum{
    AUTO_MODE,
    SET_MODE
}USB_PORT_MODE;

void vFnSetUsbInfo(int32_t iFdCom, const PT_PCS_USB_INFO ptPortInfo, USB_PORT_MODE usbPortMode);
extern T_PCS_USB_INFO s_tUsbInfo;

#endif

#endif /*__EXT_DEV_REGIST_H__*/
