/**
 * @file ext_ftp_func.c
 * @brief zte_ftpչatעἰʵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef CONFIG_MIN_8M_VERSION
/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "ext_regist.h"
#include "at_utils.h"
#include "softap_api.h"
#include "ext_ftp_func.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/*
 $MYFTPOPEN=<channel>,<destination_ip/url>,<username>,<password>,<mode>,<Tout>,<FTPtype>
*/
static int ext_ftpopen_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct zteftp_open_reqmsg  *reqmsg = malloc(sizeof(struct zteftp_open_reqmsg));
	assert(reqmsg);
	char *p[7] = {
		&reqmsg->channel,
		reqmsg->destination,
		reqmsg->username,
		reqmsg->password,
		&reqmsg->mode,
		&reqmsg->tout,
		&reqmsg->ftptype
	};
	memset(reqmsg, 0x00, sizeof(struct zteftp_open_reqmsg));
	parse_param2("%d,%s,%s,%s,%d,%d,%d", at_paras, p);
	at_print(AT_NORMAL, "ext_ftpopen_req %d,%s,%s,%s,%d,%d,%d\n", reqmsg->channel,
	         reqmsg->destination,
	         reqmsg->username,
	         reqmsg->password,
	         reqmsg->mode,
	         reqmsg->tout,
	         reqmsg->ftptype);
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct zteftp_open_reqmsg);
	return AT_CONTINUE;
}
/*
  <CR><LF>OK<CR><LF>
  <CR><LF>ERROR:<err><CR><LF>
*/
static int ext_ftpopen_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_open_rspmsg *rspmsg = (struct zteftp_open_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	at_print(AT_NORMAL, "result %d\n", rspmsg->result);
	if (rspmsg->result < 0) {
		sprintf(at_str, "\r\nERROR: %d\r\n", rspmsg->err);
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
/*
  at$MYFTPOPEN?
*/
static int ext_ftpstate_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	return AT_CONTINUE;
}
/*
  <CR><LF>$MYFTPOPEN:<connect_status>
  <CR><LF>OK<CR><LF>
*/
static int ext_ftpstate_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_query_rspmsg *rspmsg = (struct zteftp_query_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	sprintf(at_str, "\r\n$MYFTPOPEN: %d\r\nOK\r\n", rspmsg->connect_status);

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}

/*
  at$MYFTPOPEN=?

  <CR><LF>OK<CR><LF>
*/
static int ext_ftpstate_confirm(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	char *at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	sprintf(at_str, "\r\nOK\r\n");

	*res_msg = at_str;
	*res_msglen = strlen(at_str);
	return AT_END;
}

/*
  at$MYFTPCLOSE
*/
static int ext_ftpclose_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	return AT_CONTINUE;
}
/*
  <CR><LF>OK<CR><LF>
  <CR><LF>ERROR:<err><CR><LF>
*/
static int ext_ftpclose_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_close_rspmsg *rspmsg = (struct zteftp_close_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	if (rspmsg->result < 0) {
		sprintf(at_str, "\r\nERROR\r\n");
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}

/*
  at$MYFTPSIZE=<File_Name>
*/
static int ext_ftpsize_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct zteftp_size_reqmsg  *reqmsg = malloc(sizeof(struct zteftp_size_reqmsg));
	assert(reqmsg);
	char *p[5] = {reqmsg->file_name};
	memset(reqmsg, 0x00, sizeof(struct zteftp_size_reqmsg));
	parse_param2("%s", at_paras, p);
	at_print(AT_NORMAL, "ext_ftpsize_req %s", reqmsg->file_name);
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct zteftp_size_reqmsg);
	return AT_CONTINUE;
}
/*
  <CR><LF>$MYFTPSIZE:<file_lenth>
  <CR><LF>OK<CR><LF>

  <CR><LF>ERROR:<err><CR><LF>

  <CR><LF>$MYURLFTP:<status><CR><LF>
*/
static int ext_ftpsize_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_size_rspmsg *rspmsg = (struct zteftp_size_rspmsg*)rsp_msg;
	int offset = 0;
	char *at_str = malloc(64);
	assert(at_str);
	memset(at_str, 0x00, 64);

	if (rspmsg->file_lenth < 0) {
		offset += sprintf(at_str, "\r\nERROR\r\n");
	} else {
		offset += sprintf(at_str, "\r\n$MYFTPSIZE: %d\r\nOK\r\n", rspmsg->file_lenth);
#if 0
		offset += sprintf(at_str + offset, "\r\n$MYURCFTP:1\r\n");/*ӶϿ*/
#endif
	}

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}

/*
  at$MYFTPSIZE=<File_Name>[,<data_offset>,<data_lenth>]
*/
static int ext_ftpget_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct zteftp_get_reqmsg  *reqmsg = malloc(sizeof(struct zteftp_get_reqmsg));
	assert(reqmsg);
	char *p[5] = {reqmsg->file_name, &reqmsg->data_offset, &reqmsg->data_lenth};
	memset(reqmsg, 0x00, sizeof(struct zteftp_get_reqmsg));
	parse_param2("%s,%d,%d", at_paras, p);
	at_print(AT_NORMAL, "ext_ftpget_req %s,%d,%d", reqmsg->file_name, reqmsg->data_offset, reqmsg->data_lenth);
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct zteftp_get_reqmsg);
	return AT_CONTINUE;
}
/*
  <CR><LF>CONNECT<CR><LF>
  <CR><LF><file_content>
  <CR><LF>OK<CR><LF>

  <CR><LF>ERROR<CR><LF>

  <CR><LF>CONNECT<CR><LF>
  <CR><LF><file_content>
  <CR><LF>ERROR<CR><LF>
*/
static int ext_ftpget_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_get_rspmsg *rspmsg = (struct zteftp_get_rspmsg*)rsp_msg;
	char *at_str = NULL;
	int offset = 0;

	if (rspmsg->result < 0) {
		at_str = malloc(64);
		assert(at_str);
		memset(at_str, 0x00, 64);
		offset += sprintf(at_str, "\r\nERROR\r\n");
	} else {
		at_str = malloc(64 + rspmsg->data_lenth);
		assert(at_str);
		memset(at_str, 0x00, 64 + rspmsg->data_lenth);
#if 1
		offset += sprintf(at_str, "\r\nCONNECT");
#else
		offset += sprintf(at_str, "\r\nCONNECT\r\n");
		/*ͨpassthrough*/
		//offset += sprintf(at_str+offset, "%s",rspmsg->file_content);
		memcpy(at_str + offset, rspmsg->file_content, rspmsg->data_lenth);
		offset += rspmsg->data_lenth;
		offset += sprintf(at_str + offset, "\r\nOK\r\n");
#endif
	}

	*ret = at_str;
	*retlen = offset;//strlen(at_str);

	return AT_END;
}
/*
  at$MYFTPSIZE=<File_Name>,<data_lenth>,<EOF>
*/
static int ext_ftpput_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct zteftp_put_reqmsg  *reqmsg = malloc(sizeof(struct zteftp_put_reqmsg));
	assert(reqmsg);
	char *p[5] = {reqmsg->file_name, &reqmsg->data_lenth, &reqmsg->eof};
	memset(reqmsg, 0x00, sizeof(struct zteftp_put_reqmsg));
	parse_param2("%s,%d,%d", at_paras, p);
	at_print(AT_NORMAL, "ext_ftpput_req %s,%d,%d\n", reqmsg->file_name, reqmsg->data_lenth, reqmsg->eof);
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct zteftp_put_reqmsg);
	return AT_CONTINUE;
}
/*
  <CR><LF>CONNECT<CR><LF>
  <CR><LF><file_content>
  <CR><LF>OK<CR><LF>

  <CR><LF>ERROR<CR><LF>
*/
static int ext_ftpput_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_put_rspmsg *rspmsg = (struct zteftp_put_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	assert(at_str);

	memset(at_str, 0x00, 32);
	if (rspmsg->ret < 0) {
		sprintf(at_str, "\r\nERROR\r\n");
	} else if (rspmsg->ret == 0) {
		sprintf(at_str, "\r\nCONNECT\r\n");
	} else if (rspmsg->ret == 1) {
		sprintf(at_str, "\r\nOK\r\n");
	}

	*ret = at_str;
	*retlen = strlen(at_str);

	return AT_END;
}

/*
  at+FTPFOTA
*/
static int ext_ftpfota_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct zteftp_fota_reqmsg  *reqmsg = malloc(sizeof(struct zteftp_fota_reqmsg));
	assert(reqmsg);
	char *p[7] = {
		&reqmsg->channel,
		reqmsg->destination,
		reqmsg->file_name,
		reqmsg->username,
		reqmsg->password
	};
	memset(reqmsg, 0x00, sizeof(struct zteftp_fota_reqmsg));
	parse_param2("%d,%s,%s,%s,%s", at_paras, p);
	at_print(AT_NORMAL, "ftp_fota_reqmsg %d,%s,%s,%s,%s\n", reqmsg->channel,
	         reqmsg->destination,
	         reqmsg->file_name,
	         reqmsg->username,
	         reqmsg->password
	        );
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct zteftp_fota_reqmsg);
	return AT_CONTINUE;
}
/*
  <CR><LF>OK<CR><LF>
  <CR><LF>ERROR<CR><LF>
*/
static int ext_ftpfota_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_fota_rspmsg *rspmsg = (struct zteftp_fota_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	if (rspmsg->result < 0) {
		sprintf(at_str, "\r\nERROR\r\n");
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/**
 * @brief עftpչat
 * @param
 * @return
 * @retval
 */
int ext_ftp_regist(void)
{
//#ifdef GUODIAN
	if (g_customer_type == CUSTOMER_GUODIAN) {
		register_serv_func2("MYFTPOPEN=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPOPEN_REQ, MSG_CMD_FTPOPEN_RSP, ext_ftpopen_req,	ext_ftpopen_rsp);
		register_serv_func2("MYFTPOPEN?", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPSTATE_REQ, MSG_CMD_FTPSTATE_RSP, ext_ftpstate_req,	ext_ftpstate_rsp);
		register_serv_func2("MYFTPOPEN=?", MODULE_ID_SOCKET_PROXY, 0, 0, ext_ftpstate_confirm,	NULL);
		register_serv_func2("MYFTPCLOSE", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPCLOSE_REQ, MSG_CMD_FTPCLOSE_RSP, ext_ftpclose_req,	ext_ftpclose_rsp);
		register_serv_func2("MYFTPSIZE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPSIZE_REQ, MSG_CMD_FTPSIZE_RSP, ext_ftpsize_req,	ext_ftpsize_rsp);
		register_serv_func2("MYFTPGET=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPGET_REQ, MSG_CMD_FTPGET_RSP, ext_ftpget_req,	ext_ftpget_rsp);
		register_serv_func2("MYFTPPUT=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPPUT_REQ, MSG_CMD_FTPPUT_RSP, ext_ftpput_req,	ext_ftpput_rsp);

		register_serv_func2("FOTAFTP=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPFOTA_REQ, MSG_CMD_FTPFOTA_RSP, ext_ftpfota_req, ext_ftpfota_rsp);
	} else if (g_customer_type == CUSTOMER_NANDIAN) {

		register_serv_func2("MYFTPOPEN=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPOPEN_REQ, MSG_CMD_FTPOPEN_RSP, ext_ftpopen_req,	ext_ftpopen_rsp);
		register_serv_func2("MYFTPOPEN?", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPSTATE_REQ, MSG_CMD_FTPSTATE_RSP, ext_ftpstate_req, ext_ftpstate_rsp);
		register_serv_func2("MYFTPOPEN=?", MODULE_ID_SOCKET_PROXY, 0, 0, ext_ftpstate_confirm,	NULL);
		register_serv_func2("MYFTPCLOSE", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPCLOSE_REQ, MSG_CMD_FTPCLOSE_RSP, ext_ftpclose_req, ext_ftpclose_rsp);
		register_serv_func2("MYFTPSIZE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPSIZE_REQ, MSG_CMD_FTPSIZE_RSP, ext_ftpsize_req,	ext_ftpsize_rsp);
		register_serv_func2("MYFTPGET=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPGET_REQ, MSG_CMD_FTPGET_RSP, ext_ftpget_req,	ext_ftpget_rsp);
		register_serv_func2("MYFTPPUT=", MODULE_ID_SOCKET_PROXY, MSG_CMD_FTPPUT_REQ, MSG_CMD_FTPPUT_RSP, ext_ftpput_req,	ext_ftpput_rsp);
	}
//#endif
	return 0;

}
#endif
