/**
 * @file ext_ftp_func.h
 * @brief ṩzte_ftpⲿϢϢṹ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __EXT_FTP_FUNC_H__
#define __EXT_FTP_FUNC_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "message.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define MAX_FILE_NAME_LENTH 64
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/* zte_ftpģϢݽṹ*/
struct zteftp_open_reqmsg {
	unsigned int channel; /* ftpڵchannel.0~3*/
	char destination[256];/*ftpվip/url : port*/
	char username[256];/*¼û*/
	char password[256];/*¼*/
	unsigned int  mode;/*0ʾFTPģʽ1ʾFTPģʽ*/
	unsigned int  tout;/*5~180s,FTPݿгʱãλsĬΪ30s*/
	unsigned int  ftptype;/*0ʾģʽ(Ĭ);1ʾıģʽ*/
};
/* zte_ftpģӦϢݽṹ*/
struct zteftp_open_rspmsg {
	int result;/*0ʾOK-1ʾERROR*/
	int err;/**/
};

/* ״̬ѯӦϢݽṹ*/
struct zteftp_query_rspmsg {
	int  connect_status;/*1ʾӳɹ0ʾʧ*/
};

/* zte_ftpģرӦϢݽṹ*/
struct zteftp_close_rspmsg {
	int result;/*0ʾرOK-1ʾرERROR*/
};

/* zte_ftpģȡFTPӦļĳϢݽṹ*/
struct zteftp_size_reqmsg {
	char file_name[MAX_FILE_NAME_LENTH];
};
struct zteftp_size_rspmsg {
	int file_lenth;
};

/* zte_ftpģعϢݽṹ*/
struct zteftp_get_reqmsg {
	char file_name[MAX_FILE_NAME_LENTH];/*Ҫصļ*/
	int data_offset;/*ļݵƫ*/
	int data_lenth;/*ζȡݵĳ*/
};
struct zteftp_get_rspmsg {
	int result;
	int data_lenth;/*ζȡݵĳ*/
	unsigned char file_content[1];/*ftp*/
};

/* zte_ftpģϴϢݽṹ*/
struct zteftp_put_reqmsg {
	char file_name[MAX_FILE_NAME_LENTH];/*Ҫصļ.·*/
	unsigned int data_lenth;/*ÿϴݵĳ*/
	unsigned int eof;/* ϴļ־λ.λΪ0,ʾΪգΪ1ʾݣõַ*/
	unsigned char file_content[1];/*ftp*/
};
struct zteftp_put_rspmsg {
	int ret;

	/*ϢϢһ.putӦϢʱ޸.ͨsocketӦò㷢Ϣʱʹ*/
	char file_name[MAX_FILE_NAME_LENTH];/*Ҫصļ.·.*/
	unsigned int data_lenth;/*ÿϴݵĳ*/
	unsigned int eof;/* ϴļ־λ*/
};

/*ftp fota*/
struct zteftp_fota_reqmsg {
	unsigned int channel; /* ftpڵchannel.0~3*/
	char destination[256];/*ftpվip/url : port*/
	char file_name[MAX_FILE_NAME_LENTH];/*fotaְļ*/
	char username[256];/*¼û*/
	char password[256];/*¼*/
};
struct zteftp_fota_rspmsg {
	int result;/*0ʾOK-1ʾERROR*/
};

#if CONFIG_EXIT_DATAMODE
struct zteftp_exit_reqmsg {
	int mode;/*0ʾ͸ģʽ-1ʾ͸ģʽ͸ģʽʱҪϱӦϢ͸ģʽͨϢϱ*/
};
/* zte_ftpģģʽϢݽṹ.յ"+++"ʱģʽ*/
struct zteftp_exit_rspmsg {
	int result;/*0ʾ˳OK-1ʾ˳ERROR*/
};
#endif

#endif
