/*******************************************************************************
* ״̬Ϣѯ,Ҫ״̬ѯɲԵȣAPLINUXʹ
* ֵ֧Ĺ:
* ѯл
* ѯùģʽл
* ѯTELNET״̬
* ѯSALESTAT״̬

* й״̬ѯ򿪹õ󣬿ڴļAT
**********************************************************************************/

#if (APP_OS_TYPE == APP_OS_LINUX)
#include "ext_regist.h"
#include "softap_api.h"
#include "at_utils.h"
#include "zxic_errno.h"
#include "nv_api.h"
#include "at_context.h"
#include "syncnv.h"
#include <fcntl.h>
#include <sys/ioctl.h>
#include "RONvParam_AMT.h"
#include "ref_nv_def.h"
#include <linux/input.h>
#include "NvParam_drv.h"
#include "libcpnv.h"

static int32_t cardSlotFlag = 0;

//========================================================================================================//
//ʵ
//========================================================================================================//
#define USB_HOTPLUG_FILE_NAME              "/sys/dwc_usb/usbconfig/hotplug"
#define AP_WORK_LOCK "ap_work_lock"

int writefile(char*path, char*buf, unsigned len)
{
    FILE *fp;
    int rtv;
    if((fp=fopen(path,"w"))==NULL)
    {
        return -1;
    }
    rtv = fwrite(buf,len,1, fp);
    fclose(fp);
    return rtv;
}

int zlanenableGet_req(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	char enable_flag[2] = {0};

	sc_cfg_get("LanEnable", enable_flag, sizeof(enable_flag));
    at_print(AT_DEBUG,"zlanenableGet_req:LanEnable = %s\n", enable_flag);
	
	*res_msg = at_query_result_build("ZLANENABLE",enable_flag);
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

static void sc_cfg_set_ufi_state(void)
{
    sc_cfg_set("LanEnable","1");	        
    sc_cfg_set("usblan", "usblan0");
    sc_cfg_set("need_jilian", "0");
    sc_cfg_set("need_init_modem","yes");
    //sc_cfg_set("cid_reserved","12");
}
int zlanenableSet_req(int at_fd,char * at_paras,void * * res_msg,int * res_msglen)
{
    char*  at_str = NULL;
    int32_t iLanEnable = 0;
    int32_t iOldLanEnable = 0;
    char strCfgGetItem[AT_CMD_MAX] = {0};

    if(at_paras==NULL)
		softap_assert("zlanenableSet_req:at_paras is null");
	
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &iLanEnable, &at_str);
    at_print(AT_DEBUG,"zlanenableSet_rsq:iLanEnable == %d\n", iLanEnable);

	if(!(0 == iLanEnable || 1 == iLanEnable
        || 2 == iLanEnable|| 3 == iLanEnable)) // szLanEnableֻ01ֵ
    {
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	
	sc_cfg_get("LanEnable", strCfgGetItem, sizeof(strCfgGetItem));
	
	if(0==strcmp(strCfgGetItem,""))
	{	
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

    iOldLanEnable = atoi(strCfgGetItem);

	if(iOldLanEnable != iLanEnable)
	{
        if(iLanEnable == 0)
        {
            sc_cfg_set("LanEnable","0");
	        sc_cfg_set("usblan", "");
            sc_cfg_set("need_jilian", "1");
            sc_cfg_set("need_init_modem","no");
            sc_cfg_set("boot_prj","mdl"); 
            //sc_cfg_set("cid_reserved","3");
        }
        else if(iLanEnable == 1)
        {
            sc_cfg_set_ufi_state();
            
            sc_cfg_set("boot_prj","mifi"); 
        }
        else if(iLanEnable == 2)
        {
            sc_cfg_set_ufi_state();
            
            sc_cfg_set("boot_prj","cpe"); 
        }
        else if(iLanEnable == 3)
        {
            sc_cfg_set_ufi_state();
            
            sc_cfg_set("boot_prj","evb"); 
        }
	   
	//  sc_cfg_save();
	}

	*res_msg = at_query_result_build("ZLANENABLE",at_paras);
	*res_msglen = strlen(*res_msg);
	
	//ģʽлϢ
	ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_MAIN_CTRL, MSG_CMD_RESTART_REQUEST, 0, NULL,0);

	return AT_END;
}

int zmode_req_rcv_act(char *at_paras,int at_fd,struct at_context *context)
{
    char* err_str = NULL;    
    int32_t iUsbMode = 0;
	
    at_print(AT_DEBUG, "at_str = %s\n", at_paras);  

    get_at_cmd_param_int(at_paras, &iUsbMode, &at_paras);
    at_print(AT_DEBUG, "iUsbMode == %d\n", iUsbMode);
    switch(iUsbMode)
	{
		case 0:
		{
			nv_set_item(NV_RO,"usb_modetype", "user",1);
			break;
		}
		case 1:
		{
			nv_set_item(NV_RO,"usb_modetype", "debug",1);
			break;
		}
		case 2:
		{
			nv_set_item(NV_RO,"usb_modetype", "factory",1);
			break;
		}
		case 3:
		{
			nv_set_item(NV_RO,"usb_modetype", "amt",1);
			break;
		}
		default:
		{			
			err_str = at_err_build(ATERR_PARAM_INVALID);
			at_write(context->at_channel->at_fd, err_str, strlen(err_str));
			free(err_str);
			return AT_END;
		}
	}
	nv_commit(NV_RO);
	
    context->app_param = (void*)malloc(sizeof(iUsbMode)+1);
    if(context->app_param == NULL){softap_assert("");return AT_END;}
	memset(context->app_param, 0, sizeof(iUsbMode)+1);
	sprintf(context->app_param, "%d", iUsbMode);
	
    return AT_CONTINUE;
}

int zmodeGet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    int32_t setResult = 0;
	char strCfgGetItem[AT_CMD_MAX] = {0};
	int tmp = -1;

    nv_get_item(NV_RO, "usb_modetype", strCfgGetItem, sizeof(strCfgGetItem));
    at_print(AT_DEBUG,"zmodeGet_req:strCfgGetItem = %s\n", strCfgGetItem);  
	 
	if(!strcmp(strCfgGetItem,"user"))
	{
		*res_msg = at_query_result_build("ZMODE","0");
	}
	else if(!strcmp(strCfgGetItem,"debug"))
	{
		*res_msg = at_query_result_build("ZMODE","1");
	}
	else if(!strcmp(strCfgGetItem,"factory"))
	{
		*res_msg = at_query_result_build("ZMODE","2");
	}
	else if(!strcmp(strCfgGetItem,"amt"))
	{
		*res_msg = at_query_result_build("ZMODE","3");
	}
	else
	{
		*res_msg = at_err_build(ATERR_PROC_FAILED);
	}
   	*res_msglen = strlen(*res_msg);
	
   return AT_END;
}

int plugoutSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	int32_t iPlutout = 0;
    char*  at_str = NULL;
	
    if(at_paras==NULL)
		softap_assert("zmodeSet_req:at_paras is null");
	
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &iPlutout, &at_str);
    at_print(AT_DEBUG,"zmodeSet_rsq:iUsbMode == %d\n", iPlutout);

	switch(iPlutout)
	{
		case 0:
		{
			writefile(USB_HOTPLUG_FILE_NAME,"0",1);
			break;
		}
		case 1:
		{
			writefile(USB_HOTPLUG_FILE_NAME,"1",1);
			break;
		}
		default:
		{			
			*res_msg = at_err_build(ATERR_PARAM_INVALID);
			*res_msglen = strlen(*res_msg);
			return AT_END;
		}
	}
	
	*res_msg = at_ok_build();	
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int znetcardtypeSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    int32_t iNetcardType = 0;    
	int32_t iResult = 0;
	char*  at_str = NULL;
	
    if(at_paras==NULL)
		softap_assert("znetcardtypeSet_req:at_paras is null");
	
	at_str = at_paras;
	at_print(AT_DEBUG,"znetcardtypeSet_rsq: come in.\n");
	get_at_cmd_param_int(at_str, &iNetcardType, &at_str);
	at_print(AT_DEBUG,"znetcardtypeSet_rsq:iNetcardType == %d\n", iNetcardType);

	switch(iNetcardType)
	{
		case 0:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_ndis",1);
			break;
		}
		case 1:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_ecm",1);
			break;
		}
		case 2:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_mbim",1);
			break;
		}
		case 3:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_rndis",1);
			break;
		}
		default:
		{
			*res_msg = at_err_build(ATERR_PARAM_INVALID);	
			*res_msglen = strlen(*res_msg);
			return AT_END;
		}
	}
	nv_commit(NV_RO);

	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int znetcardtypeGet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    int32_t setResult = 0;
	char strCfgGetItem[AT_CMD_MAX] = {0};
	int tmp = -1;

    nv_get_item(NV_RO, "forcenetcard_type", strCfgGetItem, sizeof(strCfgGetItem));
    at_print(AT_DEBUG,"znetcardtypeGet_req:strCfgGetItem = %s\n", strCfgGetItem);  
	 
	if(!strcmp(strCfgGetItem,"force_ndis"))
	{
		*res_msg = at_query_result_build("CARDTYPE","force_ndis");
	}
	else if(!strcmp(strCfgGetItem,"force_ecm"))
	{
		*res_msg = at_query_result_build("CARDTYPE","force_ecm");
	}
	else if(!strcmp(strCfgGetItem,"force_mbim"))
	{
		*res_msg = at_query_result_build("CARDTYPE","force_mbim");
	}
	else if(!strcmp(strCfgGetItem,"force_rndis"))
	{
		*res_msg = at_query_result_build("CARDTYPE","force_rndis");
	}
	else
	{
		*res_msg = at_err_build(ATERR_PROC_FAILED);
	}
   	*res_msglen = strlen(*res_msg);
	
   return AT_END;
}

int zusbmodeSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	int32_t iUsbMode = 0;
    char*  at_str = NULL;
	
    if(at_paras==NULL)
		softap_assert("zusbmodeSet_req:at_paras is null");
	
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &iUsbMode, &at_str);
    at_print(AT_DEBUG,"zusbmodeSet_req:iUsbMode == %d\n", iUsbMode);

	switch(iUsbMode)
	{
		case 0:
		{
			nv_set_item(NV_RO,"usb_modetype", "user",1);
			break;
		}
		case 1:
		{
			nv_set_item(NV_RO,"usb_modetype", "debug",1);
			break;
		}
		case 2:
		{
			nv_set_item(NV_RO,"usb_modetype", "factory",1);
			break;
		}
		case 3:
		{
			nv_set_item(NV_RO,"usb_modetype", "amt",1);
			break;
		}
		default:
		{			
			*res_msg = at_err_build(ATERR_PARAM_INVALID);
			*res_msglen = strlen(*res_msg);
			return AT_END;
		}
	}
	nv_commit(NV_RO);
	
	*res_msg = at_ok_build();	
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int znvset_req_func(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char *strch = at_paras;
	char *p[4] = {0};
    char nv_name[NV_NAME_LEN] = {0};
	char nv_value[1024] = {0};
	int i = 0;
	if(at_paras == NULL)
	{
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	for(i=0; i < 4; i++)
	{
    	strch = strchr(strch, '"');
		p[i] = strch;
		if(strch == NULL)
		{
			*res_msg = at_err_build(ATERR_PARAM_INVALID);
			*res_msglen = strlen(*res_msg);
			return AT_END;
		}
		strch++;
	}
	memcpy(nv_name, p[0]+1, (int)(p[1]-p[0]-1));
	memcpy(nv_value,p[2]+1,	(int)(p[3]-p[2]-1));
	
	sc_cfg_set(nv_name, nv_value);
	sc_cfg_save();
	
	at_print(AT_DEBUG,"znvset_req_func name=%s value=%s\n", nv_name, nv_value);
	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);
	return AT_END;
}

int znvget_req_func(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char *strch = at_paras;
    char nv_name[NV_NAME_LEN] = {0};
	char nv_value[1024] = {0};
	char *p[2] = {0};
	int i = 0;
	if(at_paras == NULL)
	{
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	for(i=0; i < 2; i++)
	{
    	strch = strchr(strch, '"');
		p[i] = strch;
		if(strch == NULL)
		{
			*res_msg = at_err_build(ATERR_PARAM_INVALID);
			*res_msglen = strlen(*res_msg);
			return AT_END;
		}
		strch++;
	}
    memcpy(nv_name, p[0]+1, (int)(p[1]-p[0]-1));
	sc_cfg_get(nv_name, nv_value, sizeof(nv_value));
	strch = malloc(strlen(nv_name)+strlen(nv_value)+32);
	if(strch == NULL) {softap_assert("");return AT_END;}
	sprintf(strch,"\"%s\",\"%s\"",nv_name, nv_value);
	*res_msg = at_query_result_build("znvget",strch);
	*res_msglen = strlen(*res_msg);
	free(strch);
	strch = NULL;
	return AT_END;
}

/* ͨAT ڽshell*/
int ext_atshell_req(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{	
	char* cmd = NULL;
	char *at_str = NULL;
	int len = strlen(at_paras)+1;
	cmd = malloc(len);
	if(cmd == NULL){softap_assert("");return AT_END;}
    memset(cmd,0,len);
	memcpy(cmd, at_paras, len-1);
	soft_system(cmd);
	at_str = at_ok_build();
	*res_msg = at_str;
	*res_msglen = strlen(at_str);
	free(cmd);
    return AT_END;
}

int ext_pcfc_set_func(char *at_paras,int at_fd,struct at_context *context)
{	
	int flag = 0;
	void *p[1] = {&flag};
	int ret = 0;
	char* rspStr = NULL;
	char strCfgGetItem[AT_CMD_MAX] = {0};
	int iOldLanEnable = 0;
	int iLanEnable = 0;
	UINT8 phoneModeStatus = 0;
    UINT32  retCode = CPNV_ERROR;
	
	ret = parse_param("%d", at_paras, p);
	if (ret != AT_PARSE_OK)  // cov M
    {   
		return AT_END;
    }
    
	retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR,&phoneModeStatus,sizeof(UINT8));
    if(retCode == CPNV_ERROR)
    {
        // todo: cov m
    }   
	sc_cfg_get("LanEnable", strCfgGetItem, sizeof(strCfgGetItem));
	if(0==strcmp(strCfgGetItem,""))
	{	
		rspStr = at_err_build(ATERR_PROC_FAILED);
		at_write(context->at_channel->at_fd, rspStr, strlen(rspStr));
    	free(rspStr);
		return AT_END;
	}
	iOldLanEnable = atoi(strCfgGetItem);

	if ((1 <= flag)&&(3 >= flag)){
		phoneModeStatus = (0x1 | phoneModeStatus);	 // һλ1ʾǴmodem汾
		sc_cfg_set("version_mode","1");                 //version_mode==1 phonemode==0 Ϊmodem汾
		ret = cpnv_NvItemWrite(ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR,&phoneModeStatus,sizeof(UINT8));
		if(ret == CPNV_ERROR){softap_assert("");}
		ret = cpnv_NvramFlush();
		if(ret == CPNV_ERROR){softap_assert("");}
		
		iLanEnable = 0;
		//sc_cfg_set("cid_reserved","15");
		sc_cfg_set("cid_reserved","255");
		if(iOldLanEnable != iLanEnable)
		{
			sc_cfg_set("LanEnable","0");
	        sc_cfg_set("usblan", "");
            sc_cfg_set("need_jilian", "1");
            sc_cfg_set("need_init_modem","no");
			sc_cfg_set("boot_prj","mdl"); 
               
			//sc_cfg_save();
		}
		sc_cfg_save();
		return AT_CONTINUE;
	}
	else 
	{
		//rspStr = at_err_build(ATERR_PARAM_INVALID);
		//at_write(context->at_channel->at_fd, rspStr, strlen(rspStr));
    	//free(rspStr);
		//return AT_END;
		return AT_CONTINUE;
	}
}

int ext_is_usermode(void)
{
	char strCfgGetItem[16] = {0};

	nv_get_item(NV_RO, "usb_modetype", strCfgGetItem, sizeof(strCfgGetItem));
	return !strcmp(strCfgGetItem,"user");
}

#ifndef CONFIG_MIN_8M_VERSION
int ztelnetSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    char*  at_str = NULL;
	int32_t user_cmd = 0;
	char enable_flag[AT_CMD_MAX] = {0};
	
	sc_cfg_get("telnetd_enable", enable_flag, sizeof(enable_flag));

    if(at_paras==NULL)
		softap_assert("ztelnetSet_req:at_paras is null");
	
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &user_cmd, &at_str);
    at_print(AT_DEBUG,"zlanenableSet_rsq:user_cmd == %d\n", user_cmd);
	
	switch(user_cmd)
	{
	case 0:
		if (0 == strcmp(enable_flag, "y"))
		{
			system("killall -9 telnetd");
			sc_cfg_set("telnetd_enable", "n");
			//sc_cfg_save();
		}
		*res_msg = at_query_result_build("ZTELNET","0");
		break;
	case 1:
		if (0 == strcmp(enable_flag, "n"))
		{
			system("/usr/sbin/telnetd -p 4719");
			sc_cfg_set("telnetd_enable", "y");
			//sc_cfg_save();
		}
		system("adbd &");
		*res_msg = at_query_result_build("ZTELNET","1");
		break;
	default:
		at_print(AT_DEBUG,"lnetSet_rsp:: invaild user_cmd == %d\n", user_cmd);
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
	}
	
	*res_msglen = strlen(*res_msg);

    return AT_END;
}

int ztelnetGet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char enable_flag[2] = {0};

	sc_cfg_get("telnetd_enable", enable_flag, sizeof(enable_flag));
	if (0 == strcmp(enable_flag, "y"))
	{
		*res_msg = at_query_result_build("ZTELNET","1");
	}
	else if (0 == strcmp(enable_flag, "n"))
	{
		*res_msg = at_query_result_build("ZTELNET","0");
	}
	else
	{	
		*res_msg = at_err_build(ATERR_PROC_FAILED);
	}
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int zppptatusGet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    int32_t state = 0;
    char pdpState[AT_CMD_MAX] = {0};

    sc_cfg_get("ppp_pdpstate", pdpState, sizeof(pdpState));
    if(strcmp(pdpState, "working") == 0)
    {        
		*res_msg = at_query_result_build("ZPPPSTATUS","1");        
    }
	else
	{
		*res_msg = at_query_result_build("ZPPPSTATUS","0");        
	}
	*res_msglen = strlen(*res_msg);

    return AT_END;
}

int salestatSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	int32_t iEnable = 0;
	char *at_str = NULL;
	
    if(at_paras==NULL)
		softap_assert("salestatSet_req:at_paras is null");
	
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &iEnable, &at_str);
    at_print(AT_DEBUG,"salestatSet_rsq:str_saleType == %d\n", iEnable);

	if(0 == iEnable)
    {
		sc_cfg_set("sale_stat_on","no");

	}
	else if(1 == iEnable)
	{
		sc_cfg_set("sale_stat_on","yes");
	}
	else
	{
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);
        return AT_END;
    }

	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);

    return AT_END;
}

int salestatGet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    char salestatState[AT_CMD_MAX] 	= {0};
	
    sc_cfg_get("sale_stat_on", salestatState, sizeof(salestatState));
//	at_print(AT_DEBUG,"salestatGet_req ret salestatState= %s.\n",salestatState);	
	
	if (0 == strcmp(salestatState, "yes"))
	{
		*res_msg = at_query_result_build("SALESTAT","1");
	}
	else if(0 == strcmp(salestatState, "no"))
	{	
		*res_msg = at_query_result_build("SALESTAT","0");
	}
	else
	{
		*res_msg = at_err_build(ATERR_PROC_FAILED);
	}	
		
	*res_msglen = strlen(*res_msg);	

    return AT_END;
}

int zerrSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    int32_t err = 0;    
	int32_t iResult = 0;
	char*  at_str = NULL;
	
    if(at_paras==NULL)
		softap_assert("zerrSet_req:at_paras is null");
	
	at_str = at_paras;
    get_at_cmd_param_int(at_str, &err, &at_str); 

	//at_print(1,"[ERR]zerrSet_req:err = %d\n",err);

	zxic_err_track(err);

	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int zautorspSet_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char channel_value[50] = {0};
    
	if(at_paras==NULL){
		softap_assert("zautorspSet_req:at_paras is null");
		return AT_END;
	}
	if(strstr(at_paras, "all") != NULL)
	{
		sc_cfg_set("autorspchannel_list", "all");
	}
	else if(strstr(at_paras, "none") != NULL)
	{
		sc_cfg_set("autorspchannel_list", "none");
	}
	else
	{	
    	char *pchar = strchr(at_paras,'\0');
		if(pchar == NULL)
			softap_assert("");
		
		memset(channel_value, 0, sizeof(channel_value));
		if((pchar-at_paras) > 0 && (pchar-at_paras)< sizeof(channel_value))
		memcpy(channel_value, at_paras, (int)(pchar-at_paras));
		sc_cfg_set("autorspchannel_list",channel_value);
	}
	sc_cfg_save();
#ifdef MULTI_CPU
	sync_appointed_nv(NEAR_PS, "autorspchannel_list");
#endif
	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);
	return AT_END;
}


//AT+ZISSENDAUTO=1ʾat_fdͨϱ0ʾر
int modAutoInd_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	struct at_channel_info * at_channel = at_context_find_chn_by_fd(at_fd);
	if(at_channel){
	if('1' == at_paras[0])
	{
		at_channel->attribution &= 0xFE;	
	}
	else if('0' == at_paras[0])
	{
		at_channel->attribution |= (1<<CH_AUTOIND);	
	}
	}
	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);
	
	return AT_END;
}

int ext_softap_info_req(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
	char *at_str = NULL;
	char lan_enable[NV_NAME_LEN] = {0};
	char need_init_modem[NV_NAME_LEN] = {0};
	char cid_reserved[NV_NAME_LEN] = {0};
	
	at_str = malloc(AT_CMD_MAX); 
	if(at_str == NULL)
	{
		softap_assert("");
		return AT_END;
	}
	memset(at_str, 0, AT_CMD_MAX);
	sc_cfg_get("LanEnable", lan_enable, sizeof(lan_enable));
	sc_cfg_get("need_init_modem", need_init_modem, sizeof(need_init_modem));
	sc_cfg_get("cid_reserved", cid_reserved, sizeof(cid_reserved));

	sprintf(at_str+strlen(at_str), "\r\nLanEnable=%s\r\n", lan_enable);
	sprintf(at_str+strlen(at_str), "\r\nneed_init_modem=%s\r\n", need_init_modem);
	sprintf(at_str+strlen(at_str), "\r\cid_reserved=%s\r\n", cid_reserved);
	sprintf(at_str+strlen(at_str), "\r\nOK\r\n");

	*res_msg = at_str;
    *res_msglen = strlen(at_str);
    return AT_END;	
}


/*
 * Function: int redirect_console(int redirect)
 * Param: int redirect
 * 1: to redirect
 * 0: reset to console
 * Return value:
 * 0: success; -1: error.
 */
int redirect_console(int redirect)
{
#if (APP_OS_TYPE == APP_OS_LINUX)

    int fp = 0;
    int ret = 0;
    char rd_name[128] = {0};
    
    if(redirect)
        strcpy(rd_name, "/dev/ttyGS0");
    else
        strcpy(rd_name, "/dev/console");
    
    fp = open(rd_name, O_RDWR);
    if(fp < 0)
    {
        printf("Open %s(fp=%d) failed!\n", rd_name, fp);
        return -1;
    }	
    printf("tty_redirect:fd=%d\n", fp);
    
    ret = ioctl(fp, TIOCCONS);	
    printf("tty_redirect:ret=%d\n", ret);
    
    close(fp);	
	
	fp = open("/dev/console", O_RDWR);
	if(fp < 0)
	{
		return -1;
	}
	dup2(fp, 1);
	close(fp);
	
    return 0;
#endif	
}


/* LOGATͨ */
int ext_log_stdout_req(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
	char *at_str = NULL;
	int opt = 0;
	void *p[1] = {&opt}; 
	
	parse_param2("%d", at_paras, p);

	if (1 != strlen(at_paras) || opt < 0 || opt > 1)
	{
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

	redirect_console(opt);

	at_str = at_ok_build();

	*res_msg = at_str;
	*res_msglen = strlen(at_str);
    return AT_END;	
}


/* ͨչⲿMCUҪϱ*/
int zindcmd_set_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	if (strlen(at_paras)>= NV_MAX_VAL_LEN)
    {
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
    }
    else
    {	
    	if(strlen(at_paras) == 0)
			sc_cfg_set("customIndCmdList","");
		else			
			sc_cfg_set("customIndCmdList",at_paras);	
        sc_cfg_save();             
		*res_msg = at_ok_build();
        
    }	
	
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int ext_worklock_set_func(char *at_paras, void ** res_msg)
{
	int i = 0;
    unsigned long result = 0;  // cov M
	//жϲǷʮ
	for(;i<strlen(at_paras);i++)
	{
		if(isxdigit(at_paras[i]) == 0)
		{
			goto ERROR_PROC;
		}
	}
	errno = 0;
	result = strtoul(at_paras,0,16);//16Ƶַתɳ
	if (errno == ERANGE)// kw ERRNO.NOT_CHECKED
	{
		at_print(AT_ERR, "strtoul errno %d: %s\n", errno, strerror(errno));
	}
	if(result == 0)//ͷ
	{
		if(set_wake_unlock(AP_WORK_LOCK) == 0)//ͷɹok
			return AT_END;
		else
		{
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			return AT_END;
		}
	}
	else if(result>0 && result<0xFFFF)//óʱ
	{
		//óʱĽӿ
		if(set_wake_lock_timeout(AP_WORK_LOCK,result) == 0)//óʱɹok
			return AT_END;
		else
		{
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			return AT_END;
		}
	}
	else if(result == 0xFFFF)//ͨ
	{
		if(set_wake_lock(AP_WORK_LOCK) == 0)//ɹok
			return AT_END;
		else
		{
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			return AT_END;
		}
	}
ERROR_PROC:
	//ЧĲֵش
	*res_msg = at_err_build(ATERR_PARAM_INVALID);
	return AT_END;
}


//#ifdef _ENABLE_AUTOTEST
#define KPD_PATH 						"/dev/event0"

#define LED_WAN_RED_BRIGHTNESS			"/sys/class/leds/modem_r_led/brightness"
#define LED_WAN_RED_BLINKTIMEON			"/sys/class/leds/modem_r_led/delay_on"

#define LED_WAN_BLUE_BRIGHTNESS			"/sys/class/leds/modem_b_led/brightness"
#define LED_WAN_BLUE_BLINKTIMEON		"/sys/class/leds/modem_b_led/delay_on"

#define LED_WAN_GREEN_BRIGHTNESS        "/sys/class/leds/modem_g_led/brightness"
#define LED_WAN_GREEN_BLINKTIMEON		"/sys/class/leds/modem_g_led/delay_on"

#define LED_BATTERY_GREEN_BRIGHTNESS	"/sys/class/leds/battery_g_led/brightness"
#define LED_BATTERY_GREEN_BLINKTIMEON	"/sys/class/leds/battery_g_led/delay_on"

#define LED_BATTERY_RED_BRIGHTNESS		"/sys/class/leds/battery_r_led/brightness"
#define LED_BATTERY_RED_BLINKTIMEON		"/sys/class/leds/battery_r_led/delay_on"

#define LED_SMS_BLUE_BRIGHTNESS		    "/sys/class/leds/sms_led/brightness"
#define LED_SMS_BLUE_BLINKTIMEON		"/sys/class/leds/sms_led/delay_on"

#define LED_LAN_BLUE_BRIGHTNESS		    "/sys/class/leds/wifi_led/brightness"
#define LED_LAN_BLUE_BLINKTIMEON		"/sys/class/leds/wifi_led/delay_on"

static int readfile(const char *path, char * buf,  int  len)
{
	FILE  *fp = NULL;
	int cnt = -1;;

	if (NULL == path  || NULL == buf) 
		return -1;

	if ( (fp = fopen (path, "rb")) == NULL) {
		at_print(AT_ERR, "%s can not be open\n", path);
		cnt = -1;
		goto err;
	}

	cnt = fread (buf, 1, len, fp);
	if (cnt < 0) {
		at_print(AT_ERR, "%s read failed \n", path);
		cnt = -1;
		goto err;
	}
err:	
	if (fp != NULL)
		fclose(fp);
	return cnt;
}

static int autotest_led_get(char *fileled, char *fileact)
{
	int ledstat_i = 0;
	char ledstat_s[4] = {0};

	if (access(fileact, F_OK) == 0){
		ledstat_i = 2;
	} else {
		readfile(fileled, ledstat_s, sizeof(ledstat_s) - 1);
		ledstat_i = atoi(ledstat_s);
	}

	return ledstat_i;
}

/*
AT+KEYEVENT=<code>,<value>
code: 116 POWER; 117 WPS; 118 RESET;
value: 0 up; 1 down; 2 long press;

AT+TKEYEVENT=116,1
OK
AT+TKEYEVENT=116,0
OK
AT+TKEYEVENT=117,1
OK
sleep:4
AT+TKEYEVENT=117,2
OK
+TKEYEVENT: WPS ACTIVED
AT+TKEYEVENT=117,0
OK
*/
int autotest_keyset_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	autotest_key_rspmsg param = {0};
	CHAR *p[2] = {&param.code, &param.value};
	int fd = -1;	
	struct input_event event = {0};
	unsigned char *buf = NULL;

	parse_param2("%d,%d", at_paras, p);
	at_print(AT_NORMAL, "autotest_keyset_req key code:%d,value:%d\n",param.code,param.value);

	buf = malloc(sizeof(struct input_event)); 
	if(buf == NULL) {
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

	fd = open(KPD_PATH, O_WRONLY|O_SYNC);
	if (fd == -1) {
		free(buf);
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	
	event.type = 1; //EV_KEY
	event.code = (unsigned short)param.code;
	event.value = param.value;
	memcpy(buf, &event, sizeof(struct input_event));//klocwork
	if (write(fd, /*&event*/buf, sizeof(struct input_event)) != sizeof(struct input_event)) {
		close(fd);
		free(buf);
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	event.type = 0; //EV_SYN
	event.code = 0;
	event.value = 0;
	memcpy(buf, &event, sizeof(struct input_event));//klocwork
	if (write(fd, /*&event*/buf, sizeof(struct input_event)) != sizeof(struct input_event)) {
		close(fd);
		free(buf);
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	close(fd);
	free(buf);
	
	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);
	return AT_END;
#if 0
	autotest_key_rspmsg *param = malloc(sizeof(autotest_key_rspmsg));
	assert(param);
	CHAR *p[2] = {&param->code,&param->value};

	memset(param, 0, sizeof(autotest_key_rspmsg));
	parse_param2("%d,%d", at_paras, p);
	at_print(AT_NORMAL, "autotest_keyset_req key code:%d,value:%d\n",param->code,param->value);

	*res_msg = param;
	*res_msglen = sizeof(autotest_key_rspmsg);
	return AT_END_AND_MSG;
#endif
}
/*
AT+TCPUSTATUS?
+TCPUSTATUS: 0.0% USR  9.0% SYS  0.0% NIC 90.9% IDLE  0.0% IO  0.0% IRQ  0.0% SIRQ
OK
*/
int autotest_cpuget_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char *tmp_str = NULL;
	
	tmp_str = malloc(AT_CMD_MAX); 
	if (tmp_str != NULL) {
		char *cpu_ptr = NULL;
		char *cpu_end = NULL;
		system("top -n 1 > /tmp/cputop");
		memset(tmp_str, 0, AT_CMD_MAX);
		readfile("/tmp/cputop", tmp_str, AT_CMD_MAX - 1);
		tmp_str[AT_CMD_MAX - 1] = '\0';
		if ((cpu_ptr = strstr(tmp_str, "CPU:  ")) != NULL &&
			(cpu_end = strstr(tmp_str, "\nLoad average:")) != NULL) {
			cpu_ptr += strlen("CPU:  ");
			*cpu_end = 0;
			*res_msg = at_query_result_build("TCPUSTATUS",cpu_ptr);
		} else {
			*res_msg = at_err_build(ATERR_PROC_FAILED);
		}
		
		free(tmp_str);
	} else {
		*res_msg = at_err_build(ATERR_MEM_LESS);
	}
	if(*res_msg)
	*res_msglen = strlen(*res_msg);
	return AT_END;
}

/*+TLEDSTATUS: <tpye>,<stat>,<color>;...
tpye: 0 battery; 1 network; 2 sms; 3 wifi
stat: 0 off; 1 on; 2 blink 
color: 0 null/off; 1 red; 2 green; 3 blue;

AT+TLEDSTATUS?
+TLEDSTATUS: 0,1,2;1,0,0;2,0,0;3,0,0
OK
*/
int autotest_ledget_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char led_str[36] = {0};
	int ledstat = 0;
	int ledcolor = 0;
	int len = 0;
	//char *net_led = LED_WAN_BLUE_BRIGHTNESS;
	//char *net_act = LED_WAN_BLUE_BLINKTIMEON;
	int net_color = 3;
	char cus_type[20] = {0};
	
	sc_cfg_get("customer_type",cus_type,sizeof(cus_type));
	/*
	if(0 == strcmp(cus_type, "sdk_min")) {
		net_led = LED_WAN_GREEN_BRIGHTNESS;
		net_act = LED_WAN_GREEN_BLINKTIMEON;
		net_color = 2;
	}
	*/
	//battery
	ledstat = autotest_led_get(LED_BATTERY_GREEN_BRIGHTNESS, LED_BATTERY_GREEN_BLINKTIMEON);
	if (ledstat) {
		ledcolor = 2;
	} else {
		ledstat = autotest_led_get(LED_BATTERY_RED_BRIGHTNESS, LED_BATTERY_RED_BLINKTIMEON);
		if (ledstat) {
			ledcolor = 1;
		}
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "0,%d,%d;", ledstat, ledcolor);

	//network
	ledcolor = 0;
	//ledstat = autotest_led_get(net_led, net_act);
	if(0 == strcmp(cus_type, "sdk_min")) {
		ledstat = autotest_led_get(LED_WAN_GREEN_BRIGHTNESS, LED_WAN_GREEN_BLINKTIMEON);
		net_color = 2;
	}// kw OVERWRITE_CONST_CHAR
	else
	{
		ledstat = autotest_led_get(LED_WAN_BLUE_BRIGHTNESS, LED_WAN_BLUE_BLINKTIMEON);
	}
	if (ledstat) {
		ledcolor = net_color;
	} else {
		ledstat = autotest_led_get(LED_WAN_RED_BRIGHTNESS, LED_WAN_RED_BLINKTIMEON);
		if (ledstat) {
			ledcolor = 1;
		}
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "1,%d,%d;", ledstat, ledcolor);

	//sms
	ledcolor = 0;
	ledstat = autotest_led_get(LED_SMS_BLUE_BRIGHTNESS, LED_SMS_BLUE_BLINKTIMEON);
	if (ledstat) {
		ledcolor = net_color;
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "2,%d,%d;", ledstat, ledcolor);

	//wifi
	ledcolor = 0;
	ledstat = autotest_led_get(LED_LAN_BLUE_BRIGHTNESS, LED_LAN_BLUE_BLINKTIMEON);
	if (ledstat) {
		ledcolor = net_color;
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "3,%d,%d", ledstat, ledcolor);

	*res_msg = at_query_result_build("TLEDSTATUS",led_str);
	//*res_msg = at_err_build(ATERR_PROC_FAILED);

	*res_msglen = strlen(*res_msg);
	return AT_END;
}


#define LED_SIGNAL1_BLUE_BRIGHTNESS		"/sys/class/leds/4g_1_led/brightness"
#define LED_SIGNAL1_BLUE_BLINKTIMEON	"/sys/class/leds/4g_1_led/delay_on"

#define LED_SIGNAL2_BLUE_BRIGHTNESS		"/sys/class/leds/4g_2_led/brightness"
#define LED_SIGNAL2_BLUE_BLINKTIMEON	"/sys/class/leds/4g_2_led/delay_on"

#define LED_SIGNAL3_BLUE_BRIGHTNESS		"/sys/class/leds/4g_3_led/brightness"
#define LED_SIGNAL3_BLUE_BLINKTIMEON	"/sys/class/leds/4g_3_led/delay_on"

#define LED_SIGNAL4_BLUE_BRIGHTNESS		"/sys/class/leds/4g_4_led/brightness"
#define LED_SIGNAL4_BLUE_BLINKTIMEON	"/sys/class/leds/4g_4_led/delay_on"

#define LED_SIGNAL5_BLUE_BRIGHTNESS		"/sys/class/leds/4g_5_led/brightness"
#define LED_SIGNAL5_BLUE_BLINKTIMEON	"/sys/class/leds/4g_5_led/delay_on"

#define LED_WPS_BLUE_BRIGHTNESS		"/sys/class/leds/wps_led/brightness"
#define LED_WPS_BLUE_BLINKTIMEON	"/sys/class/leds/wps_led/delay_on"

#define LED_RJ11_BLUE_BRIGHTNESS	"/sys/class/leds/rj11_led/brightness"
#define LED_RJ11_BLUE_BLINKTIMEON	"/sys/class/leds/rj11_led/delay_on"


/*
cpe switch
+TLEDSTATUS: <tpye>,<stat>,<color>;...
tpye: 0 signal; 1 network; 2 wps; 3 wifi; 4 rj11
stat: 0 off; 1 on; 2 blink (signal 1 1led, 2 2led, 3 3led, 4 4led, 5 5led, 12 1led blink)
color: 0 null/off; 1 red; 2 green; 3 blue;

AT+TLEDSTATUS?
+TLEDSTATUS: 0,1,2;1,0,0;2,0,0;3,0,0
OK
*/
int autotest_ledget_cpesw_req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char led_str[36] = {0};
	int ledstat = 0;
	int ledcolor = 0;
	int len = 0;
	
	//signal
	ledcolor = 0;
	if ((ledstat = autotest_led_get(LED_SIGNAL5_BLUE_BRIGHTNESS, LED_SIGNAL5_BLUE_BLINKTIMEON)) > 0) {
		ledstat = 5;
		ledcolor = 3;
	} else if ((ledstat = autotest_led_get(LED_SIGNAL4_BLUE_BRIGHTNESS, LED_SIGNAL4_BLUE_BLINKTIMEON)) > 0) {
		ledstat = 4;
		ledcolor = 3;
	} else if ((ledstat = autotest_led_get(LED_SIGNAL3_BLUE_BRIGHTNESS, LED_SIGNAL3_BLUE_BLINKTIMEON)) > 0) {
		ledstat = 3;
		ledcolor = 3;
	} else if ((ledstat = autotest_led_get(LED_SIGNAL2_BLUE_BRIGHTNESS, LED_SIGNAL2_BLUE_BLINKTIMEON)) > 0) {
		ledstat = 2;
		ledcolor = 3;
	} else if ((ledstat = autotest_led_get(LED_SIGNAL1_BLUE_BRIGHTNESS, LED_SIGNAL1_BLUE_BLINKTIMEON)) > 0) {
		if (ledstat == 2)
			ledstat = 12;
		else
			ledstat = 1;
		ledcolor = 3;
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "0,%d,%d;", ledstat, ledcolor);

	//network
	ledcolor = 0;
	ledstat = autotest_led_get(LED_WAN_BLUE_BRIGHTNESS, LED_WAN_BLUE_BLINKTIMEON);
	if (ledstat) {
		ledcolor = 3;
	} else {
		ledstat = autotest_led_get(LED_WAN_RED_BRIGHTNESS, LED_WAN_RED_BLINKTIMEON);
		if (ledstat) {
			ledcolor = 1;
		}
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "1,%d,%d;", ledstat, ledcolor);

	//wps
	ledcolor = 0;
	ledstat = autotest_led_get(LED_WPS_BLUE_BRIGHTNESS, LED_WPS_BLUE_BLINKTIMEON);
	if (ledstat) {
		ledcolor = 3;
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "2,%d,%d;", ledstat, ledcolor);

	//wifi
	ledcolor = 0;
	ledstat = autotest_led_get(LED_LAN_BLUE_BRIGHTNESS, LED_LAN_BLUE_BLINKTIMEON);
	if (ledstat) {
		ledcolor = 3;
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "3,%d,%d;", ledstat, ledcolor);

	//rj11
	ledcolor = 0;
	ledstat = autotest_led_get(LED_RJ11_BLUE_BRIGHTNESS, LED_RJ11_BLUE_BLINKTIMEON);
	if (ledstat) {
		ledcolor = 3;
	}
	len = strlen(led_str);
	snprintf(led_str + len, sizeof(led_str) - len, "4,%d,%d", ledstat, ledcolor);

	*res_msg = at_query_result_build("TLEDSTATUS", led_str);
	*res_msglen = strlen(*res_msg);
	return AT_END;
}

#endif

extern UINT8 Sim_Inserted;

int zCardSwitch_Set_Req(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	int32_t simCardFlag = 0;
	unsigned long   retCode = CPNV_ERROR;
	int32_t	SimInserted = 0;
	int ret = 0;

	char *p[] = {
		&simCardFlag,
		&cardSlotFlag,
	};
	
	ret = parse_param("%d,%d", at_paras, p);
	if (ret != AT_PARSE_OK)  // cov M
	{
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

	at_print(AT_DEBUG,"zCardSwitch_Set_Req:simCardFlag == %d\n", simCardFlag);
	
	if(simCardFlag < 0 || simCardFlag > 6)  //0 = UICC_CARD, 1 = VSIM_CARD, 2 = UICC_VSIM_AUTO, 3 = UICC_ESIM_CARD,4 = CLOUD_CARD,5 =SOFTSIM_CARD
	{
		*res_msg = at_err_build(ATERR_PARAM_INVALID);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	
	#ifdef USE_DSDS_VSIM
	if (simCardFlag == 0)
	{
		simCardFlag = 0;
	}
	else if (simCardFlag == 1)
	{
		simCardFlag = 4;
	}
	else if (simCardFlag == 2)
	{
		simCardFlag = 5;
	}
	else if (simCardFlag == 3)
	{
		simCardFlag = 1;
	}
	#endif
	
	at_print(AT_DEBUG,"zCardSwitch_Set_Req:simCardFlag transform == %d\n", simCardFlag);
		
	if(1 == cardSlotFlag)
	{
		retCode = cpnv_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(uicc1PreSwitch), (unsigned char *)(&simCardFlag), DRV_SYS_NV_ITEM_SIZE(uicc1PreSwitch));
	}
	else 
	{
		retCode = cpnv_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(uiccPreSwitch), (unsigned char *)(&simCardFlag), DRV_SYS_NV_ITEM_SIZE(uiccPreSwitch));
	}
	
	if (CPNV_OK == retCode)
	{
		retCode= cpnv_NvramFlush();
	}
	
	if (retCode == CPNV_OK)
	{
		*res_msg = at_ok_build();
	}
	else
	{
		*res_msg = at_err_build(retCode); 	
	}
	*res_msglen = strlen(*res_msg);
	return AT_END;
}

int zCardSwitch_Get_Req(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	int32_t simCard0Flag = 0;
	int32_t simCard1Flag = 0;
	int32_t simCard0PreFlag = 0;
	int32_t simCard1PreFlag = 0;
	
	unsigned long retCode = CPNV_ERROR;
	char tmp[100];

	if (cardSlotFlag == 1)
	{
		retCode = cpnv_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uicc1modeSwitch), (unsigned char *)(&simCard1Flag), DRV_SYS_NV_ITEM_SIZE(uicc1modeSwitch));
		retCode = cpnv_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uicc1PreSwitch), (unsigned char *)(&simCard1PreFlag), DRV_SYS_NV_ITEM_SIZE(uicc1PreSwitch));
	}
	
	retCode = cpnv_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uiccmodeSwitch), (unsigned char *)(&simCard0Flag), DRV_SYS_NV_ITEM_SIZE(uiccmodeSwitch));
	retCode = cpnv_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uiccPreSwitch), (unsigned char *)(&simCard0PreFlag), DRV_SYS_NV_ITEM_SIZE(uiccPreSwitch));

	#ifdef USE_DSDS_VSIM

	if (cardSlotFlag == 1)
	{
		if (simCard1Flag == 0)
		{
			simCard1Flag = 0;
		}
		else if (simCard1Flag == 4)
		{
			simCard1Flag = 1;
		}
		else if (simCard1Flag == 5)
		{
			simCard1Flag = 2;
		}
		else if (simCard1Flag == 1)
		{
			simCard1Flag = 3;
		}

		if (simCard1PreFlag == 0)
		{
			simCard1PreFlag = 0;
		}
		else if (simCard1PreFlag == 4)
		{
			simCard1PreFlag = 1;
		}
		else if (simCard1PreFlag == 5)
		{
			simCard1PreFlag = 2;
		}
		else if (simCard1PreFlag == 1)
		{
			simCard1PreFlag = 3;
		}
	}

		if (simCard0Flag == 0)
		{
			simCard0Flag = 0;
		}
		else if (simCard0Flag == 4)
		{
			simCard0Flag = 1;
		}
		else if (simCard0Flag == 5)
		{
			simCard0Flag = 2;
		}
		else if (simCard0Flag == 1)
		{
			simCard0Flag = 3;
		}

		if (simCard0PreFlag == 0)
		{
			simCard0PreFlag = 0;
		}
		else if (simCard0PreFlag == 4)
		{
			simCard0PreFlag = 1;
		}
		else if (simCard0PreFlag == 5)
		{
			simCard0PreFlag = 2;
		}
		else if (simCard0PreFlag == 1)
		{
			simCard0PreFlag = 3;
		}

	#endif
	
	if (CPNV_ERROR == retCode) 
	{
		*res_msg = at_err_build(retCode); 
	}
	else
	{
		if (cardSlotFlag == 1)
		{
			snprintf(tmp,sizeof(tmp),"%d,%d,%d,%d,%d",simCard0PreFlag, simCard0Flag, simCard1PreFlag, simCard1Flag, cardSlotFlag);
		}
		else
		{
			snprintf(tmp,sizeof(tmp),"%d,%d",simCard0PreFlag, simCard0Flag);
		}
		
		*res_msg = at_query_result_build("ZCARDSWITCH", tmp);
	}
	
	*res_msglen = strlen(*res_msg);
	return AT_END;
}

int  ext_normal_regist(void)
{
	char mmi_nv_value[32] = {0};
	//жϿͻ
	if(!ext_is_usermode())
	{
	    char needInit[20] = {0};
	    sc_cfg_get("customer_type",needInit,sizeof(needInit));
		if(0 != strcmp(needInit, "v3modem"))
		{
			register_serv_func2("znvset=",0,0,0,znvset_req_func,NULL);
			register_serv_func2("znvget=",0,0,0,znvget_req_func,NULL);
		}
		
		//USBģʽл
		register_serv_func2("ZUSBMODE=",0,0,0,zusbmodeSet_req,NULL);		
		
		//atִshellĲҪ˫
		register_serv_func2("shell=",0,0,0,ext_atshell_req,NULL);
	}
	//ģʽл
	register_serv_func2("zlanenable?",0,0,0,zlanenableGet_req,NULL);
	register_serv_func2("zlanenable=",0,0,0,zlanenableSet_req,NULL);
#ifndef CONFIG_MIN_8M_VERSION
	if(!ext_is_usermode())
	{
		//telnet	
		register_serv_func2("ztelnet?",0,0,0,ztelnetGet_req,NULL);
		register_serv_func2("ztelnet=",0,0,0,ztelnetSet_req,NULL);
	}
	register_serv_func2("zpppstatus?",0,0,0,zppptatusGet_req,NULL);	

	//SALESTAT
	register_serv_func2("salestat=",0,0,0,salestatSet_req,NULL);	
	register_serv_func2("salestat?",0,0,0,salestatGet_req,NULL);		
	//CP֪ͨAP
	register_serv_func2("CPERR=",0,0,0, zerrSet_req,NULL);
	register_serv_func2("zautorspset=",0,0,0,zautorspSet_req,NULL);

	//ýոչͨϱ
	register_serv_func2("ZISSENDAUTO=",0,0,0,modAutoInd_act_func,NULL); 

	//ȡƽ̨Ϣ
	register_serv_func2("ZSOFTAPINFO",0,0,0,ext_softap_info_req,NULL);
	//LOGAT
	register_serv_func2("ZSETOUT=",0,0,0,ext_log_stdout_req,NULL);

	//ⲿMCUҪϱ ʾAT+ZNEEDIND=+CREG+CSQ
	register_serv_func2("ZNEEDIND=",0,0,0,zindcmd_set_func,NULL);

	//ⲿͷ
	register_serv_func("ZWORKLOCK=", 0, ext_worklock_set_func);
#endif

	register_serv_func2("ZCARDSWITCH=",0,0,0,zCardSwitch_Set_Req,NULL);
	register_serv_func2("ZCARDSWITCH?",0,0,0,zCardSwitch_Get_Req,NULL);

	//register_fwd_func("zmode=",zmode_req_rcv_act,NULL,NULL);
	register_serv_func2("zmode?",0,0,0,zmodeGet_req,NULL);
	register_serv_func2("plugout=",0,0,0,plugoutSet_req,NULL);	
	
	//л
	register_serv_func2("znetcardtype=",0,0,0,znetcardtypeSet_req,NULL);
	
	register_serv_func2("znetcardtype?",0,0,0,znetcardtypeGet_req,NULL);


	register_fwd_func("PCFC=",ext_pcfc_set_func,NULL,NULL);

#ifndef CONFIG_MIN_8M_VERSION//def _ENABLE_AUTOTEST
    //Զ ---KEYEVENT=phone
	//register_serv_func2("TKEYEVENT=",MODULE_ID_MMI, MSG_CMD_AUTOTEST_KEY_REQ, 0, autotest_keyset_req, NULL);
	register_serv_func2("TKEYEVENT=",0,0,0,autotest_keyset_req,NULL);
	register_serv_func2("TCPUSTATUS?",0,0,0,autotest_cpuget_req,NULL);
	sc_cfg_get("mmi_led_plan", mmi_nv_value, sizeof(mmi_nv_value));
	if (0 == strcmp(mmi_nv_value, "yaoyuan")) {
		register_serv_func2("TLEDSTATUS?",0,0,0,autotest_ledget_cpesw_req,NULL);
	} else {
		register_serv_func2("TLEDSTATUS?",0,0,0,autotest_ledget_req,NULL);
	}
#endif
	return 0;
}

#endif
