#ifndef CONFIG_MIN_8M_VERSION
#include "softap_api.h"
#include "ext_socket_func.h"
#include <math.h>
#include "at_com.h"

struct netsrv_msg netsrv = {0};

//IPַʽ
int check_ipaddr_legal(char* ipaddr)
{
	char* pointer_tmp_start = NULL;
	char* pointer_tmp_end = NULL;
	char str_tmp[64] = {0};
	int ipaddr_len = strlen(ipaddr);
	int num = 0;
	int i = 0;

	pointer_tmp_end = strchr(ipaddr, '.');
	if (pointer_tmp_end == NULL) {
		return 0;
	}
	if((int)(pointer_tmp_end - ipaddr) < sizeof(str_tmp))
		snprintf(str_tmp,(int)(pointer_tmp_end - ipaddr)+1,"%s",ipaddr);
	//strncpy(str_tmp, ipaddr, (int)(pointer_tmp_end - ipaddr));
	num = atoi(str_tmp);

	if (num < 0 || num > 255) {
		return 0;
	}
	for (i = 0; i < 2; i++) {
		pointer_tmp_start = pointer_tmp_end + 1;
		if (pointer_tmp_start >= ipaddr + ipaddr_len) {
			return 0;
		}
		pointer_tmp_end = strchr(pointer_tmp_start, '.');
		if (pointer_tmp_end == NULL) {
			return 0;
		}
		memset(str_tmp, 0, sizeof(str_tmp));
		if((int)(pointer_tmp_end - pointer_tmp_start) < sizeof(str_tmp))
			snprintf(str_tmp,(int)(pointer_tmp_end - pointer_tmp_start)+1,"%s",pointer_tmp_start);
		//strncpy(str_tmp, pointer_tmp_start, (int)(pointer_tmp_end - pointer_tmp_start));
		num = atoi(str_tmp);
		if (num < 0 || num > 255) {
			return 0;
		}
	}
	pointer_tmp_start = pointer_tmp_end + 1;
	if (pointer_tmp_start >= ipaddr + ipaddr_len) {
		return 0;
	}
	pointer_tmp_end = ipaddr + ipaddr_len;
	memset(str_tmp, 0, sizeof(str_tmp));
	if((int)(ipaddr + ipaddr_len - pointer_tmp_start) < sizeof(str_tmp))
		snprintf(str_tmp,(int)(ipaddr + ipaddr_len - pointer_tmp_start)+1,"%s",pointer_tmp_start);
	//strncpy(str_tmp, pointer_tmp_start, (int)(ipaddr + ipaddr_len - pointer_tmp_start));
	num = atoi(str_tmp);
	if (num < 0 || num > 255) {
		return 0;
	}
	return 1;
}

//========================================================================================================//
//socketʵ
//========================================================================================================//
/*
 at+mynetsrv=1,2,2,0,"192.168.30.201:5100
*/
int ext_netsrv_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct netsrv_msg  *srv = malloc(sizeof(struct netsrv_msg));
	assert(srv);
	char * pos_colon = NULL;
	char * port = NULL;
	char *at_str = NULL;
	char *p[5] = {&srv->ch_id, &srv->socketid, &srv->conn_type, &srv->viewMode, srv->ipport};
    char *c = NULL;
    char ipport[128];
	memset(srv, 0x00, sizeof(struct netsrv_msg));
	if(5 != parse_param2("%d,%d,%d,%d,%s", at_paras, p)){
        goto error;
    }
	//
	memcpy(ipport, srv->ipport, sizeof(ipport));
    pos_colon = strchr(ipport, ':');    
	port = pos_colon + 1;
	if ((srv->socketid < 0 || srv->socketid >= 6)
	    || (srv->viewMode != 0 && srv->viewMode != 1)
	    || (srv->conn_type < 0 || srv->conn_type > 2)
	    || (srv->ch_id < 0 || srv->ch_id >= 6)
	    || pos_colon == NULL
	    || (atoi(port) < 0 || atoi(port) > 65535)) {
		goto error;
	}
    *pos_colon = '\0';
    c = ipport;
	//ֽѭǷĸbreak
	while (*c) {
		if (isalpha(*c))
			break;
		c++;
	}
	if (!*c) {
        if (check_ipaddr_legal(ipport) == 0) {
			goto error;
		}
    }
	netsrv = *srv;//Ϊѯ
	*res_msg = srv;
	*res_msglen = sizeof(struct netsrv_msg);
	return AT_CONTINUE;

error:
    free(srv);
	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);
	sprintf(at_str, "\r\nERROR: 980\r\n");
	*res_msg = at_str;
	*res_msglen = strlen(at_str);
	return AT_END;
}
int ext_netsrv_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	if (msg->ret < 0) {
		sprintf(at_str, "\r\nERROR: %d\r\n", msg->err);
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_netopen_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct comm_reqmsg *reqmsg = malloc(sizeof(struct comm_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
    char *p[1] = {&reqmsg->socketid};
	memset(reqmsg, 0x00, sizeof(struct comm_reqmsg));
	if(1 != parse_param2("%d", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct comm_reqmsg);
	return AT_CONTINUE;
}
int ext_netopen_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = malloc(64);
	assert(at_str);
	char param[10] = {0};
	int offset = 0;
	memset(at_str, 0x00, 64);

	if (msg->ret < 0) {
		sprintf(at_str, "\r\nERROR: %d\r\n", msg->err);
	} else {
		if (msg->remote_mss) {
			offset += sprintf(at_str + offset, "\r\n$MYNETOPEN: %d,%d\r\n", msg->socketid, msg->remote_mss);
		} else {
			offset += sprintf(at_str + offset, "\r\n$MYNETOPEN: %d\r\n", msg->socketid);
		}
		offset += sprintf(at_str + offset, "\r\nOK\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;

}
int ext_netread_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct comm_reqmsg *reqmsg = malloc(sizeof(struct comm_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
	char *p[2] = {&reqmsg->socketid, &reqmsg->len};
	memset(reqmsg, 0x00, sizeof(struct comm_reqmsg));
	if(2 != parse_param2("%d,%d", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct comm_reqmsg);
	return AT_CONTINUE;

}
int ext_netread_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = NULL;
	int offset = 0;

	if (msg->ret < 0) {
		at_str = malloc(32);
		assert(at_str);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR: %d\r\n", msg->err);
		offset = strlen(at_str);
	} else if (msg->len == 0) {
		at_str = malloc(64);
		assert(at_str);
		memset(at_str, 0x00, 64);
		sprintf(at_str, "\r\n$MYNETREAD: %d,0\r\n\r\nOK\r\n", msg->socketid);
		offset = strlen(at_str);
	} else {
		int viewmode = msg->viewmode;
		char *data = ((char *)rsp_msg + sizeof(struct comm_rspmsg));
		if (viewmode == 0) { //hexģʽ
			int i = 0;
			at_str = malloc(64 + msg->len);
			assert(at_str);
			memset(at_str, 0x00, 64 + msg->len);
			offset += sprintf(at_str + offset, "\r\n$MYNETREAD: %d,%d\r\n", msg->socketid, msg->len);
			memcpy(at_str + offset, data, msg->len);
			offset += msg->len;
			offset += sprintf(at_str + offset, "\r\nOK\r\n");
		} else { //textģʽ
			//int i = 0;
			at_str = malloc(64 + msg->len * 2);
			assert(at_str);
			memset(at_str, 0x00, 64 + msg->len * 2);
			offset += sprintf(at_str + offset, "\r\n$MYNETREAD: %d,%d\r\n", msg->socketid, msg->len);
			memcpy(at_str + offset, data, msg->len);
			offset += msg->len;
			offset += sprintf(at_str + offset, "\r\nOK\r\n");
		}
	}
	*ret = at_str;
	*retlen = offset;
	return AT_END;

}

int ext_sendbuf_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct comm_reqmsg *reqmsg = malloc(sizeof(struct comm_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
	char *p[2] = {&reqmsg->socketid, &reqmsg->len};
	memset(reqmsg, 0x00, sizeof(struct comm_reqmsg));
	if(2 != parse_param2("%d,%d", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct comm_reqmsg);
	return AT_CONTINUE;

}
int ext_sendbuf_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->ret < 0) {
		at_str = malloc(32);
		assert(at_str);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR: %d\r\n", msg->err);
	} else {
		at_str = malloc(64);
		assert(at_str);
		memset(at_str, 0x00, 64);
		sprintf(at_str, "\r\n$MYNETWRITE: %d,%d\r\n", msg->socketid, msg->len);
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}

int ext_netwrite_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	if (msg->ret < 0) {
		sprintf(at_str, "\r\nERROR:%d\r\n", msg->err);
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;

}

int ext_netclose_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct comm_reqmsg *reqmsg = malloc(sizeof(struct comm_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
    char *p[1] = {&reqmsg->socketid};
	memset(reqmsg, 0x00, sizeof(struct comm_reqmsg));
	if(1 != parse_param2("%d", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct comm_reqmsg);
	return AT_CONTINUE;

}
int ext_netclose_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->ret < 0) {
		at_str = malloc(32);
		assert(at_str);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR: %d\r\n", msg->err);
	} else {
		at_str = malloc(64);
		assert(at_str);
		memset(at_str, 0x00, 64);
		sprintf(at_str, "\r\n$MYNETCLOSE: %d\r\n\r\nOK\r\n", msg->socketid);
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
/*
 at+mynetping="192.168.30.201",5,40
*/
int ext_netping_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct netping_reqmsg  *ping = malloc(sizeof(struct netping_reqmsg));
	assert(ping);
	char *p[3] = {&ping->remote_ip, &ping->try_count, &ping->packet_size};
	memset(ping, 0x00, sizeof(struct netping_reqmsg));
	parse_param2("%s,%d,%d", at_paras, p);
	ping->try_count = ping->try_count == 0 ? 4 : ping->try_count;
	ping->packet_size = ping->packet_size == 0 ? 32 : ping->packet_size;
	*res_msg = ping;
	*res_msglen = sizeof(struct netping_reqmsg);
	return AT_CONTINUE;
}
int ext_netping_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct netping_rspmsg *msg = (struct netping_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->ret < 0) {
		at_str = malloc(32);
		assert(at_str);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR:%d\r\n", msg->err);
	} else {
		at_str = malloc(64);
		assert(at_str);
		memset(at_str, 0x00, 64);
		snprintf(at_str, 64,"\r\n$MYNETPING:%d,%d,\"%s\"\r\n",
		        msg->total_recv, msg->echo_rep_ttl, msg->round_trip_sta);
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_netaccept_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct netaccept_reqmsg *reqmsg = malloc(sizeof(struct netaccept_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
	memset(reqmsg, 0x00, sizeof(struct netaccept_reqmsg));
	char *p[3] = {&reqmsg->socketid, &reqmsg->action, &reqmsg->transportMode};
	char *p1[2] = {&reqmsg->socketid, &reqmsg->action};
	if (g_customer_type == CUSTOMER_GUODIAN){
		if(3 != parse_param2("%d,%d,%d", at_paras, p)){
            free(reqmsg);
        	at_str = malloc(32);
			assert(at_str);
        	memset(at_str, 0x00, 32);
        	sprintf(at_str, "\r\nERROR: 980\r\n");
        	*res_msg = at_str;
        	*res_msglen = strlen(at_str);
        	return AT_END;
        }
    }
	else if (g_customer_type == CUSTOMER_NANDIAN){
		if(2 != parse_param2("%d,%d", at_paras, p1)){
            free(reqmsg);
        	at_str = malloc(32);
			assert(at_str);
        	memset(at_str, 0x00, 32);
        	sprintf(at_str, "\r\nERROR: 980\r\n");
        	*res_msg = at_str;
        	*res_msglen = strlen(at_str);
        	return AT_END;
        }
    }

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct netaccept_reqmsg);
	return AT_CONTINUE;

}
int ext_netaccept_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct netaccept_rspmsg *msg = (struct netaccept_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->ret < 0) {
		at_str = malloc(32);
		assert(at_str);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR: %d\r\n", msg->err);
	} else {
		at_str = malloc(32);
		assert(at_str);
		memset(at_str, 0x00, 32);
		if (msg->transportMode == NON_TRANSPARENT_MODE) {
			sprintf(at_str, "\r\nOK\r\n");
		} else {
			sprintf(at_str, "\r\nCONNECT\r\n");
		}
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_netcreate_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct netcreate_msg  *netcreate = malloc(sizeof(struct netcreate_msg));
	assert(netcreate);
    char *at_str = NULL;
	char *p[6] = {&netcreate->ch_id, &netcreate->mode, &netcreate->socketid, netcreate->remote_ip, &netcreate->remote_port, &netcreate->local_port};
	memset(netcreate, 0x00, sizeof(struct netcreate_msg));
	if(5 > parse_param2("%d,%d,%d,%s,%d,%d", at_paras, p)){
        free(netcreate);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }
	*res_msg = netcreate;
	*res_msglen = sizeof(struct netcreate_msg);
	return AT_CONTINUE;
}
int ext_netcreate_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct netcreate_rspmsg *msg = (struct netcreate_rspmsg*)rsp_msg;
	char *at_str = malloc(64);
	assert(at_str);
	char param[10] = {0};
	int offset = 0;

	memset(at_str, 0x00, 64);

	if (msg->ret < 0) {
		sprintf(at_str, "\r\nERROR:%d\r\n", msg->err);
	} else {
		if (msg->mode == CONN_TYPE_TCP_S) {
			sprintf(at_str, "\r\nOK\r\n");
		} else {
			sprintf(at_str, "\r\nCONNECT\r\n");
		}
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;

}

int ext_neturc_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct neturc_reqmsg *reqmsg = malloc(sizeof(struct neturc_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
	memset(reqmsg, 0x00, sizeof(struct neturc_reqmsg));
	char *p[1] = {&reqmsg->on_off};
	if(1 != parse_param2("%d", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct neturc_reqmsg);
	return AT_CONTINUE;

}
int ext_neturc_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);
	if (msg->ret < 0) {
		sprintf(at_str, "\r\nERROR\r\n");
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_ipfilter_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct ipfilter_reqmsg *reqmsg = malloc(sizeof(struct ipfilter_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
	memset(reqmsg, 0x00, sizeof(struct ipfilter_reqmsg));
	char *p[4] = {&reqmsg->id, &reqmsg->action, reqmsg->ip_address, reqmsg->net_mask};
	if(2 > parse_param2("%d,%d,%s,%s", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }
	//ipfilter = *reqmsg;
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct ipfilter_reqmsg);
	return AT_CONTINUE;

}
int ext_ipfilter_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct comm_rspmsg *msg = (struct comm_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);
	if (msg->ret < 0) {
		sprintf(at_str, "\r\nERROR: %d\r\n", msg->err);
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_netack_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct comm_reqmsg *reqmsg = malloc(sizeof(struct comm_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
	memset(reqmsg, 0x00, sizeof(struct comm_reqmsg));
	char *p[1] = {&reqmsg->socketid};
	if(1 != parse_param2("%d", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct comm_reqmsg);
	return AT_CONTINUE;

}
int ext_netack_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct netack_rspmsg *msg = (struct netack_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	if (msg->ret < 0) {
		snprintf(at_str, 32,"\r\nERROR: %d\r\n", msg->err);
	} else {
		snprintf(at_str, 32,"\r\n$MYNETACK: %d,%d,%d\r\n\r\nOK\r\n", msg->socketid, msg->unacked_datalen, msg->rest_bufferlen);
	}

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_type_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	*res_msg = NULL;
	*res_msglen = 0;
	return AT_CONTINUE;

}
int ext_type_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct type_rspmsg *msg = (struct type_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);
	if (g_customer_type == CUSTOMER_GUODIAN)
		snprintf(at_str, 32,"\r\n$MYTYPE:%.2x,%.2x,%.2x\r\n\r\nOK\r\n", msg->mode, msg->network_type, msg->extended_feature);
	else if (g_customer_type == CUSTOMER_NANDIAN)
		snprintf(at_str, 32,"\r\n$MYMODEM: %.2x,%.4x\r\n\r\nOK\r\n", msg->mode, msg->network_type);
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_netact_query_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	*res_msg = NULL;
	*res_msglen = 0;
	return AT_CONTINUE;

}

int ext_netact_query_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct netact_query_rspmsg *msg = (struct netact_query_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(64);
	assert(at_str);
	memset(at_str, 0x00, 64);

	snprintf(at_str, 64,"\r\n$MYNETACT: %d,%d,\"%s\"\r\n\r\nOK\r\n", msg->channel, msg->status, msg->ip);

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}

int ext_netact_equal_query_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	char *at_str = NULL;

	at_str = malloc(64);
	assert(at_str);
	memset(at_str, 0, 64);
	sprintf((char*)at_str, "\r\n$MYNETACT: (0-1),(0-5)\r\nOK\r\n");
	*res_msg = at_str;
	*res_msglen = strlen(*res_msg);
	return AT_END;

}

int ext_neturc_query_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	*res_msg = NULL;
	*res_msglen = 0;
	return AT_CONTINUE;

}
int ext_neturc_query_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct neturc_query_rspmsg *msg = (struct neturc_query_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	sprintf(at_str, "\r\n$MYNETURC: %d\r\nOK\r\n", msg->on_off);

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_ipfilter_query_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	*res_msg = NULL;
	*res_msglen = 0;
	return AT_CONTINUE;

}
int ext_ipfilter_query_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct ipfilter_query_rspmsg *msg = (struct ipfilter_query_rspmsg*)rsp_msg;
	char *at_str = NULL;
	int i,j = 0;
	int offset = 0;

	at_str = malloc(32 + IP_FILTER_NUM*sizeof(struct ipfilter_query_rspmsg));
	assert(at_str);
	memset(at_str, 0x00, 32 + IP_FILTER_NUM*sizeof(struct ipfilter_query_rspmsg));

	for (i = 0; i < IP_FILTER_NUM; i++) {
        for(j = 0; j < msg->num; j++) {
            if(i == msg->ipfilter_info[j].id){
                break;
            }
        }
        if(j == msg->num){
            offset += sprintf(at_str + offset, "\r\n$MYIPFILTER: %d,\"\",\"\"", i);
        }else{
		    offset += sprintf(at_str + offset, "\r\n$MYIPFILTER: %d,\"%s\",\"%s\"", msg->ipfilter_info[j].id, msg->ipfilter_info[j].ip_address, msg->ipfilter_info[j].net_mask);
        }
	}
	offset += sprintf(at_str + offset, "\r\nOK\r\n");

	*ret = at_str;
	*retlen = offset;
	return AT_END;
}
int ext_netsrv_query_rsp(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	char *at_str = NULL;
	int offset = 0;

	at_str = malloc(32 + sizeof(netsrv));
	assert(at_str);
	memset(at_str, 0, 32 + sizeof(netsrv));
	offset += snprintf(at_str, 32 + sizeof(netsrv),"\r\n$MYNETSRV: %d,%d,%d,%d,\"%s\"", netsrv.ch_id, netsrv.socketid, netsrv.conn_type, netsrv.viewMode, netsrv.ipport);
	offset += snprintf(at_str + offset,32 + sizeof(netsrv)-offset, "\r\nOK\r\n");
	*res_msg = at_str;
	*res_msglen = offset;
	return AT_END;

}
int ext_ipfilter_equal_query_rsp(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	char *at_str = NULL;
	int offset = 0;

	at_str = malloc(64);
	assert(at_str);
	memset(at_str, 0, 64);
	offset += sprintf(at_str, "\r\n$MYIPFILTER: (0-4),(0-2),\"\",\"\"");
	offset += sprintf(at_str + offset, "\r\nOK\r\n");
	*res_msg = at_str;
	*res_msglen = offset;
	return AT_END;

}
int ext_netopen_query_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	*res_msg = NULL;
	*res_msglen = 0;
	return AT_CONTINUE;

}
int ext_netopen_query_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct netopen_query_rspmsg *msg = (struct netopen_query_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->ret == -1) {
		at_str = malloc(32);
		assert(at_str);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR\r\n");
	} else {
		at_str = malloc(32 + sizeof(struct netopen_query_rspmsg));
		assert(at_str);
		memset(at_str, 0x00, 32 + sizeof(struct netopen_query_rspmsg));

		snprintf(at_str,32 + sizeof(struct netopen_query_rspmsg), "\r\n$MYNETOPEN: %d,\"%s\",%d,\"%s\",\"%s\",\"%s\",%d,\"%s\",%d\r\nOK\r\n",
		        msg->socket_id, msg->local_ip, msg->local_port, msg->gate, msg->dns1, msg->dns2, msg->type, msg->dest_ip, msg->dest_prot);
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_ok_rsp(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	char *at_str = NULL;

	at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0, 32);
	sprintf((char*)at_str, "\r\nOK\r\n");
	*res_msg = at_str;
	*res_msglen = strlen(*res_msg);
	return AT_END;

}

char * csq_format(char *at_str)
{
	int rssi = 0, ber = 0, act = 0;
	char *at_new = malloc(strlen(at_str) + 1);
	assert(at_new);
	void *p[3] = {&rssi, &ber, &act};
	char str_tmp[64] = {0};
	char *pchrstart = NULL;

	pchrstart = at_str + 1;

	char *pchrend = strstr(pchrstart, "\r\n");
	if(pchrend && (pchrend - pchrstart) < sizeof(str_tmp))
		snprintf(str_tmp,(pchrend - pchrstart)+1, "%s",pchrstart);
	//strncpy(str_tmp, pchrstart, (int)(pchrend - pchrstart));

	//if (at_new == NULL)
	//	softap_assert("");

	parse_param2("%d,%d,%d", str_tmp, p);

	if (act == 5 || act == 15) { //W TD
		if (rssi == 199) {
			rssi = rssi - 100;
		} else {
			rssi = floor((((rssi - 100 - 116) * (100.0 / 91.0) + 127.4) * 31) / 100 + 0.1);
		}
	} else if (act == 17) { //LTE
		if (rssi == 199) {
			rssi = rssi - 100;
		} else {
			rssi = floor((((rssi - 100 - 141) * (100.0 / 97.0) + 145.3) * 31) / 100 + 0.1);
		}
	}


	memset(at_new, 0, strlen(at_str) + 1);
	sprintf(at_new, ": %ld,%ld", rssi, ber);
	printf("csq_format at_new = %s\n", at_new);
	return at_new;
}

char * xreg_format(char *at_str)
{
	char *at_new = malloc(strlen(at_str) + 1);
	assert(at_new);
	char str_tmp[64] = {0};
	char *pchrstart = NULL;
	int offset = 0;

	//if (at_new == NULL)
	//	softap_assert("");
	memset(at_new, 0, strlen(at_str) + 1);

	pchrstart = at_str + 2;
	char *pchrend = strstr(pchrstart, "\r\n");
	if (pchrend == NULL){
		softap_assert("");
		return at_new;
	}
	if (strstr(pchrstart, "OK") == NULL) {
		memcpy(at_new, at_str, pchrend - at_str);
	} else if (strchr(pchrstart, '(') != NULL) {
		memcpy(at_new, at_str, pchrend - at_str);
	} else {
		int  n = 0;
		int  stat = 0;
		char cereg_stat[20] = {0};

		offset += sprintf(at_new, ": %d", 0);

		get_at_cmd_param_int(pchrstart, &n, &pchrstart);

		move_to_next_param(pchrstart, &pchrstart);

		get_at_cmd_param_int(pchrstart, &stat, &pchrstart);

		sc_cfg_get("cereg_stat", cereg_stat, sizeof(cereg_stat));
		if (stat != 1 && stat != 5 && (1 == atoi(cereg_stat) || 5 == atoi(cereg_stat))) {
			offset += sprintf(at_new + offset, ",%d", 1);
		} else {
			offset += sprintf(at_new + offset, ",%d", stat);
		}

		//滹в
		if (!is_at_cmd_end(pchrstart)) {
			strncpy(at_new + offset, pchrstart - 1, (int)(pchrend - pchrstart + 1));
		}
	}

	//printf("xreg_format at_new = %s\n", at_new);
	return at_new;
}

char * cgatt_format(char *at_str)
{
	char *at_new = malloc(strlen(at_str) + 1);
	assert(at_new);
	//if (at_new == NULL)
	//	softap_assert("");

	memset(at_new, 0, strlen(at_str) + 1);
	sprintf(at_new, ": %d", 1);

	printf("cgatt_format at_new = %s\n", at_new);
	return at_new;
}

char * cgsn_format(char *at_str)
{
	char *at_new = malloc(strlen(at_str) + 3);
	assert(at_new);
	char str_tmp[32] = {0};
	char *pchrstart = NULL;

	pchrstart = at_str + 2;

	char *pchrend = strstr(pchrstart, "\r\n");
	if(pchrend && (pchrend - pchrstart) < sizeof(str_tmp))
		snprintf(str_tmp,(pchrend - pchrstart)+1, "%s",pchrstart);
	//strncpy(str_tmp, pchrstart, (int)(pchrend - pchrstart));
	//if (at_new == NULL)
	//	softap_assert("");

	memset(at_new, 0, strlen(at_str) + 1);
	sprintf(at_new, ": \"%s\"", str_tmp);

	printf("cgsn_format at_new = %s\n", at_new);
	return at_new;
}

#ifdef AT_QUECTEL
//========================================================================================================//
//quectel socketʵ
//========================================================================================================//
/*
 at+qiopen=1,0,"TCP","192.168.30.201",5100,0,0
*/
int ext_qiopen_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct quectel_qiopen_msg  *qiopen = malloc(sizeof(struct quectel_qiopen_msg));
	char *p[7] = {&qiopen->context_id, &qiopen->connect_id, qiopen->service_type, qiopen->ip_addr, qiopen->remote_port, qiopen->local_port, qiopen->access_mode};
	memset(qiopen, 0x00, sizeof(struct quectel_qiopen_msg));
	parse_param2("%d,%d,%s,%s,%d,%d,%d", at_paras, p);
	*res_msg = qiopen;
	*res_msglen = sizeof(struct quectel_qiopen_msg);
	return AT_CONTINUE;
}
int ext_qiopen_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct quectel_comm_rspmsg *msg = (struct quectel_comm_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	memset(at_str, 0x00, 32);

	if (msg->access_mode == BUFFER_ACCESS_MODE || msg->access_mode == DIRECT_PUSH_MODE) {
		sprintf(at_str, "\r\nOK\r\n+QIOPEN: %d,%d\r\n", msg->connect_id, msg->err);
	} else if (msg->access_mode == TRANSPARENT_ACCESS_MODE) {
		if (msg->ret < 0) {
			sprintf(at_str, "\r\nERROR\r\n");
		} else {
			sprintf(at_str, "\r\nCONNECT\r\n");
		}
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_qiclose_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct quectel_qiclose_reqmsg *reqmsg = malloc(sizeof(struct quectel_qiclose_reqmsg));
	char *p[2] = {&reqmsg->connect_id, &reqmsg->timeout};
	memset(reqmsg, 0x00, sizeof(struct quectel_qiclose_reqmsg));
	parse_param2("%d,%d", at_paras, p);

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qiclose_reqmsg);
	return AT_CONTINUE;
}
int ext_qiclose_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct quectel_comm_rspmsg *msg = (struct quectel_comm_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	memset(at_str, 0x00, 32);

	if (msg->ret < 0) {
		sprintf(at_str, "\r\nERROR\r\n");
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;

}
int ext_qistate_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct quectel_qistate_reqmsg *reqmsg = malloc(sizeof(struct quectel_qistate_reqmsg));
	char *p[2] = {&reqmsg->query_type, &reqmsg->query_id};
	memset(reqmsg, 0x00, sizeof(struct quectel_qistate_reqmsg));
	parse_param2("%d,%d", at_paras, p);

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qistate_reqmsg);
	return AT_CONTINUE;

}
int ext_qistate_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct quectel_qistate_rspmsg *msg = (struct quectel_qistate_rspmsg*)rsp_msg;
	char *at_str = NULL;
	int offset = 0;
	int i = 0;

	if (msg->num == 0) {
		at_str = malloc(32);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR\r\n");
		offset = strlen(at_str);
	} else if (msg->query_type == QUERY_CONNECTION_STATUS_BY_CONNECTID) {
		at_str = malloc(64 + sizeof(struct quectel_sock_info));
		memset(at_str, 0x00, 64 + sizeof(struct quectel_sock_info));
		offset += sprintf(at_str, "\r\n+QISTATE:\n");
		offset += sprintf(at_str + offset, "%d,%d,%s,%d,%d,%d,%d,%d,%d,%d\r\n",
		                  msg->query_status_info[0].connect_id,
		                  msg->query_status_info[0].service_type,
		                  msg->query_status_info[0].ip_addr,
		                  msg->query_status_info[0].remote_port,
		                  msg->query_status_info[0].local_port,
		                  msg->query_status_info[0].socket_state,
		                  msg->query_status_info[0].context_id,
		                  msg->query_status_info[0].server_id,
		                  msg->query_status_info[0].access_mode,
		                  msg->query_status_info[0].at_port);
	} else {
		at_str = malloc(64 + msg->num * sizeof(struct quectel_sock_info));
		memset(at_str, 0x00, 64 + msg->num * sizeof(struct quectel_sock_info));
		offset += sprintf(at_str, "\r\nList of(+QISTATE:\n");
		for (i = 0; i < msg->num; i++) {
			offset += sprintf(at_str + offset, "%d,%d,%s,%d,%d,%d,%d,%d,%d,%d\r\n",
			                  msg->query_status_info[i].connect_id,
			                  msg->query_status_info[i].service_type,
			                  msg->query_status_info[i].ip_addr,
			                  msg->query_status_info[i].remote_port,
			                  msg->query_status_info[i].local_port,
			                  msg->query_status_info[i].socket_state,
			                  msg->query_status_info[i].context_id,
			                  msg->query_status_info[i].server_id,
			                  msg->query_status_info[i].access_mode,
			                  msg->query_status_info[i].at_port);
		}
		offset += sprintf(at_str + offset, ")\n");
	}
	*ret = at_str;
	*retlen = offset;
	return AT_END;

}
int ext_qisend_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	int ret = 0;
	struct quectel_qisend_reqmsg *reqmsg = malloc(sizeof(struct quectel_qisend_reqmsg));
	char *p[4] = {&reqmsg->connect_id, &reqmsg->len, reqmsg->ip_addr, &reqmsg->remote_port};
	memset(reqmsg, 0x00, sizeof(struct quectel_qisend_reqmsg));
	ret = parse_param2("%d,%d,%s,%d", at_paras, p);
	if (ret == 1) {
		reqmsg->send_type = CHANGEABLE_LENGTH;
	} else if (ret == 2) {
		if (reqmsg->len == 0) {
			reqmsg->send_type = QUERY_DATA_INFO;
		} else {
			reqmsg->send_type = FIXED_LENGTH;
		}
	} else if (ret == 4) {
		reqmsg->send_type = UDP_DATA;
	}

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qisend_reqmsg);
	return AT_CONTINUE;

}
int ext_qisend_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct quectel_qisend_rspmsg *msg = (struct quectel_qisend_rspmsg*)rsp_msg;
	char *at_str = NULL;
	int offset = 0;

	at_str = malloc(32);
	memset(at_str, 0x00, 32);

	if (msg->send_type == QUERY_DATA_INFO) {
		if (msg->ret == CONNECTION_EXIST) {
			offset += sprintf(at_str, "\r\n+QISEND:\n");
			offset += sprintf(at_str + offset, "%d,%d,%d\r\n", msg->total_send_length, msg->ackedbytes, msg->unackedbytes);
			offset += sprintf(at_str + offset, "\r\nOK\r\n");
		} else if (msg->ret == CONNECTION_NOT_EXIST) {
			sprintf(at_str, "\r\nERROR\r\n");
		}
	} else {
		if (msg->ret == READY_TO_SEND) {
			sprintf(at_str, "\r\nSEND OK\r\n");
		} else if (msg->ret == SEND_OK) {
			sprintf(at_str, "\r\n");
		} else if (msg->ret == SEND_FAIL) {
			sprintf(at_str, "\r\nSEND FAIL\r\n");
		} else if (msg->ret == SEND_ERROR || msg->ret == CONNECTION_NOT_EXIST) {
			sprintf(at_str, "\r\nERROR\r\n");
		}
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}

int ext_qisendex_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct quectel_qisendex_reqmsg *reqmsg = malloc(sizeof(struct quectel_qisendex_reqmsg));
	char *p[2] = {&reqmsg->connect_id, reqmsg->hex_data};
	memset(reqmsg, 0x00, sizeof(struct quectel_qisendex_reqmsg));
	parse_param2("%d,%s", at_paras, p);

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qisendex_reqmsg);
	return AT_CONTINUE;

}
int ext_qisendex_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct quectel_comm_rspmsg *msg = (struct quectel_comm_rspmsg*)rsp_msg;
	char *at_str = NULL;

	at_str = malloc(32);
	memset(at_str, 0x00, 32);

	if (msg->ret == SEND_OK) {
		sprintf(at_str, "\r\nSEND OK\r\n");
	} else if (msg->ret == SEND_FAIL) {
		sprintf(at_str, "\r\nSEND FAIL\r\n");
	} else if (msg->ret == SEND_ERROR) {
		sprintf(at_str, "\r\nERROR\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;

}
int ext_qird_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	int ret = 0;
	struct quectel_qird_reqmsg *reqmsg = malloc(sizeof(struct quectel_qird_reqmsg));
	char *p[2] = {&reqmsg->connect_id, &reqmsg->len};
	memset(reqmsg, 0x00, sizeof(struct quectel_qird_reqmsg));

	ret = parse_param2("%d,%d", at_paras, p);
	if (ret == 1) {
		reqmsg->read_type = CHANGEABLE_LENGTH;
	} else if (ret == 2) {
		if (reqmsg->len == 0) {
			reqmsg->read_type = QUERY_DATA_INFO;
		} else {
			reqmsg->read_type = FIXED_LENGTH;
		}
	}

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qird_reqmsg);
	return AT_CONTINUE;

}
int ext_qird_rsp(void *rsp_msg, void**ret, int *retlen)
{
	int offset = 0;
	struct quectel_qird_rspmsg *msg = (struct quectel_qird_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->read_type == QUERY_DATA_INFO) {
		if (msg->ret == CONNECTION_EXIST) {
			at_str = malloc(32);
			memset(at_str, 0x00, 32);
			offset += sprintf(at_str, "\r\n+QIRD:\n");
			offset += sprintf(at_str + offset, "%d,%d,%d\r\n", msg->total_rcv_length, msg->have_read_length, msg->unread_length);
			offset += sprintf(at_str + offset, "\r\nOK\r\n");
		} else if (msg->ret == CONNECTION_NOT_EXIST) {
			sprintf(at_str, "\r\nERROR\r\n");
		}
	} else {
		if (msg->service_type == TCP || msg->service_type == UDP || msg->service_type == TCP_LISTENER) {
			if (msg->ret == READ_OK) {
				at_str = malloc(32 + msg->read_actual_length);
				memset(at_str, 0x00, 32 + msg->read_actual_length);
				offset += sprintf(at_str, "\r\n+QIRD:%d\r\n", msg->read_actual_length);
				memcpy(at_str + offset, msg->data, msg->read_actual_length);
				offset += msg->read_actual_length;
				offset += sprintf(at_str + offset, "\r\nOK\r\n");
			} else if (msg->ret == NODATA_READ) {
				at_str = malloc(32);
				memset(at_str, 0x00, 32);
				offset += sprintf(at_str, "\r\n+QIRD:0\n");
				offset += sprintf(at_str + offset, "\r\nOK\r\n");
			} else if (msg->ret == CONNECTION_NOT_EXIST) {
				sprintf(at_str, "\r\nERROR\r\n");
			}
		} else if (msg->service_type == UDP_SERVICE) {
			if (msg->ret == READ_OK) {
				at_str = malloc(32 + msg->read_actual_length);
				memset(at_str, 0x00, 32 + msg->read_actual_length);
				offset += sprintf(at_str, "\r\n+QIRD:%d,%s,%d\r\n", msg->read_actual_length, msg->remote_ipaddr, msg->remote_port);
				memcpy(at_str + offset, msg->data, msg->read_actual_length);
				offset += msg->read_actual_length;
				offset += sprintf(at_str + offset, "\r\nOK\r\n");
			} else if (msg->ret == NODATA_READ) {
				at_str = malloc(32);
				memset(at_str, 0x00, 32);
				offset += sprintf(at_str, "\r\n+QIRD:0\n");
				offset += sprintf(at_str + offset, "\r\nOK\r\n");
			} else if (msg->ret == CONNECTION_NOT_EXIST) {
				sprintf(at_str, "\r\nERROR\r\n");
			}
		}
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_qiswtmd_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct quectel_qiswtmd_reqmsg  *reqmsg = malloc(sizeof(struct quectel_qiswtmd_reqmsg));
	char *p[2] = {&reqmsg->connect_id, &reqmsg->access_mode};
	memset(reqmsg, 0x00, sizeof(struct quectel_qiswtmd_reqmsg));
	parse_param2("%d,%d", at_paras, p);
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qiswtmd_reqmsg);
	return AT_CONTINUE;
}
int ext_qiswtmd_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct quectel_qiswtmd_rspmsg *msg = (struct quectel_qiswtmd_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	memset(at_str, 0x00, 32);

	if (msg->ret == SW_SUCC) {
		if (msg->access_mode == BUFFER_ACCESS_MODE || msg->access_mode == DIRECT_PUSH_MODE) {
			sprintf(at_str, "\r\nOK\r\n");
		} else if (msg->access_mode == BUFFER_ACCESS_MODE || msg->access_mode == DIRECT_PUSH_MODE) {
			sprintf(at_str, "\r\nCONNECT\r\n");
		}
	} else if (msg->ret == SW_FAIL) {
		sprintf(at_str, "\r\nERROR\r\n");
	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
ext_qidnscfg_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	int ret = 0;
	struct quectel_qidnscfg_reqmsg *reqmsg = malloc(sizeof(struct quectel_qidnscfg_reqmsg));
	char *p[3] = {&reqmsg->context_id, reqmsg->pri_dns_addr, reqmsg->sec_dns_addr};
	memset(reqmsg, 0x00, sizeof(struct quectel_qidnscfg_reqmsg));

	ret = parse_param2("%d,%d", at_paras, p);
	if (ret == 1) {
		reqmsg->action_type = DNS_QUERY;
	} else if (ret == 2) {
		reqmsg->action_type = DNS_CFG_NO_SECDNSADDR;
	} else if (ret == 3) {
		reqmsg->action_type = DNS_CFG_WITH_SECDNSADDR;
	}

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qird_reqmsg);
	return AT_CONTINUE;

}
int ext_qidnscfg_rsp(void *rsp_msg, void**ret, int *retlen)
{
	int offset = 0;
	struct quectel_qidnscfg_rspmsg *msg = (struct quectel_qidnscfg_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->action_type == DNS_CFG_WITH_SECDNSADDR || msg->action_type == DNS_CFG_NO_SECDNSADDR) {
		if (msg->ret == DNS_ACTION_SUCC) {
			sprintf(at_str, "\r\nOK\r\n");
		} else if (msg->ret == DNS_ACTION_FAIL) {
			sprintf(at_str, "\r\nERROR\r\n");
		}
	} else if (msg->action_type == DNS_QUERY) {
		if (msg->ret == DNS_ACTION_SUCC) {
			at_str = malloc(32 + sizeof(msg->pri_dns_addr) + sizeof(msg->sec_dns_addr));
			memset(at_str, 0x00, 32 + sizeof(msg->pri_dns_addr) + sizeof(msg->sec_dns_addr));
			offset += sprintf(at_str, "\r\n+QIDNSCFG:%d,%s,%s\r\n", msg->context_id, msg->pri_dns_addr, msg->sec_dns_addr);
			offset += sprintf(at_str + offset, "\r\nOK\r\n");
		} else if (msg->ret == DNS_ACTION_FAIL) {
			sprintf(at_str, "\r\nERROR\r\n");
		}

	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
ext_qidnsgip_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	int ret = 0;
	struct quectel_qidnsgip_reqmsg *reqmsg = malloc(sizeof(struct quectel_qidnsgip_reqmsg));
	char *p[2] = {&reqmsg->context_id, reqmsg->host_name};
	memset(reqmsg, 0x00, sizeof(struct quectel_qidnsgip_reqmsg));

	ret = parse_param2("%d,%s", at_paras, p);

	*res_msg = reqmsg;
	*res_msglen = sizeof(struct quectel_qidnsgip_reqmsg);
	return AT_CONTINUE;

}
int ext_qidnsgip_rsp(void *rsp_msg, void**ret, int *retlen)
{
	int offset = 0;
	struct quectel_qidnscfg_rspmsg *msg = (struct quectel_qidnscfg_rspmsg*)rsp_msg;
	char *at_str = NULL;

	if (msg->action_type == DNS_CFG_WITH_SECDNSADDR || msg->action_type == DNS_CFG_NO_SECDNSADDR) {
		if (msg->ret == DNS_ACTION_SUCC) {
			sprintf(at_str, "\r\nOK\r\n");
		} else if (msg->ret == DNS_ACTION_FAIL) {
			sprintf(at_str, "\r\nERROR\r\n");
		}
	} else if (msg->action_type == DNS_QUERY) {
		if (msg->ret == DNS_ACTION_SUCC) {
			at_str = malloc(32 + sizeof(msg->pri_dns_addr) + sizeof(msg->sec_dns_addr));
			memset(at_str, 0x00, 32 + sizeof(msg->pri_dns_addr) + sizeof(msg->sec_dns_addr));
			offset += sprintf(at_str, "\r\n+QIDNSCFG:%d,%s,%s\r\n", msg->context_id, msg->pri_dns_addr, msg->sec_dns_addr);
			offset += sprintf(at_str + offset, "\r\nOK\r\n");
		} else if (msg->ret == DNS_ACTION_FAIL) {
			sprintf(at_str, "\r\nERROR\r\n");
		}

	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
int ext_qigeterror_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	*res_msg = NULL;
	*res_msglen = 0;
	return AT_CONTINUE;
}
int ext_qigeterror_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct quectel_qigeterror_rspmsg *msg = (struct quectel_qigeterror_rspmsg*)rsp_msg;
	int offset = 0;
	char *at_str = malloc(64);
	memset(at_str, 0x00, 64);

	offset += sprintf(at_str, "\r\n+QIGETERROR:%d,%s\r\n", msg->err, msg->errcode_description);
	offset += sprintf(at_str + offset, "\r\nOK\r\n");

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;

}
int ext_qping_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct qping_reqmsg  *ping = malloc(sizeof(struct qping_reqmsg));
	char *p[4] = {&ping->context, ping->remote_ip, &ping->timeout, &ping->ping_num};
	memset(ping, 0x00, sizeof(struct netping_reqmsg));
	parse_param2("%d,%s,%d,%d", at_paras, p);
	ping->timeout = ping->timeout == 0 ? 4 : ping->timeout;
	ping->ping_num = ping->ping_num == 0 ? 4 : ping->ping_num;
	*res_msg = ping;
	*res_msglen = sizeof(struct qping_reqmsg);
	return AT_CONTINUE;
}
int ext_qping_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct qping_rspmsg *msg = (struct qping_rspmsg*)rsp_msg;
	char *at_str = NULL;
	int offset = 0;
	int i = 0;

	if (msg->ret < 0) {
		at_str = malloc(32);
		memset(at_str, 0x00, 32);
		sprintf(at_str, "\r\nERROR\r\n");
	} else {
		at_str = malloc(32 + sizeof(struct qping_rspmsg));
		memset(at_str, 0x00, 32 + sizeof(struct qping_rspmsg));
		offset += sprintf(at_str + offset, "\r\nOK\r\n");
		for (i = 0; i < msg->ping_num; i++) {
			if (msg->each_ping_result[i].result == 0) {
				offset += sprintf(at_str + offset, "\r\n$QPING:\r\n%d,%s,%d,%d,%d\r\n",
				                  msg->each_ping_result[i].result,
				                  msg->each_ping_result[i].remote_ip,
				                  msg->each_ping_result[i].ping_len,
				                  msg->each_ping_result[i].response_time,
				                  msg->each_ping_result[i].ttl);
			} else {
				offset += sprintf(at_str + offset, "\r\n$QPING:\r\n%d\r\n", msg->each_ping_result[i].result);
			}
		}
		if (msg->finresult == 0) {
			offset += sprintf(at_str + offset, "\r\n$QPING:\r\n%d,%d,%d,%d,%d,%d,%d\r\n",
			                  msg->finresult, msg->sent, msg->rcvd, msg->lost, msg->min, msg->max, msg->avg);
		} else {
			offset += sprintf(at_str + offset, "\r\n$QPING:\r\n%d\r\n", msg->finresult);
		}

	}
	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}
#endif

/*
  at$MYSOCKETLED=<ONOFF>
*/
static int ext_socketled_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
	struct zteftp_socketled_reqmsg  *reqmsg = malloc(sizeof(struct zteftp_socketled_reqmsg));
	assert(reqmsg);
    char *at_str = NULL;
	char *p[1] = {&reqmsg->iswitch};
	memset(reqmsg, 0x00, sizeof(struct zteftp_socketled_reqmsg));
	if(1 != parse_param2("%d", at_paras, p)){
        free(reqmsg);
    	at_str = malloc(32);
		assert(at_str);
    	memset(at_str, 0x00, 32);
    	sprintf(at_str, "\r\nERROR: 980\r\n");
    	*res_msg = at_str;
    	*res_msglen = strlen(at_str);
    	return AT_END;
    }
	//at_print(AT_NORMAL,"ftp_socketled_reqmsg %d\n", reqmsg->iswitch);
	*res_msg = reqmsg;
	*res_msglen = sizeof(struct zteftp_socketled_reqmsg);
	return AT_CONTINUE;
}
/*
  <CR><LF>OK<CR><LF>
  <CR><LF>ERROR<CR><LF>
*/
static int ext_socketled_rsp(void *rsp_msg, void**ret, int *retlen)
{
	struct zteftp_socketled_rspmsg *rspmsg = (struct zteftp_socketled_rspmsg*)rsp_msg;
	char *at_str = malloc(32);
	assert(at_str);
	memset(at_str, 0x00, 32);

	if (rspmsg->result < 0) {
		sprintf(at_str, "\r\nERROR\r\n");
	} else {
		sprintf(at_str, "\r\nOK\r\n");
	}

	*ret = at_str;
	*retlen = strlen(at_str);
	return AT_END;
}

int ext_enpwrsave_set_func(char *at_paras, void ** res_msg)
{
	int enpwrsave = 0;
	void *p[] = {&enpwrsave};
	int ret = 0;
	char *at_str = NULL;
	at_str = malloc(16);
	assert(at_str);
	memset(at_str,0,16);

	ret = parse_param("%d",at_paras, p);
	if(ret != AT_PARSE_OK)
	{
		sprintf(at_str,"\r\nERROR: 980\r\n");
		*res_msg = at_str;
		return AT_END;
	}
	
	if(0 == enpwrsave)	//ģʽ
	{
		set_wake_lock(AP_LOCK);
		g_ap_lock = 0;
	}
	else if(1 == enpwrsave) //ģʽ
	{
		set_wake_unlock(AP_LOCK);
		g_ap_lock = 1;
	}
	else
	{
		sprintf(at_str,"\r\nERROR: 980\r\n");
		*res_msg = at_str;
		return AT_END;
	}
	
	sprintf(at_str,"\r\nOK\r\n");
	*res_msg = at_str;
	return AT_END;	

}

int ext_enpwrsave_query_func(char *at_paras, void ** res_msg)
{	
	char *at_str = NULL;
	at_str = malloc(32);
	assert(at_str);
	memset(at_str,0,32);

	sprintf(at_str,"\r\n+ENPWRSAVE: %d\r\nOK\r\n",g_ap_lock);
	*res_msg = at_str;
	return AT_END;	
}


int  ext_socket_regist(void)
{
	if (g_customer_type == CUSTOMER_GUODIAN) {
		//SOCKETշ
		register_serv_func2("MYNETSRV=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETSRV_REQ, MSG_CMD_NETSRV_RSP, ext_netsrv_req,	ext_netsrv_rsp);
		register_serv_func2("MYNETOPEN=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETOPEN_REQ, MSG_CMD_NETOPEN_RSP, ext_netopen_req, ext_netopen_rsp);
		register_serv_func2("MYNETREAD=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETREAD_REQ, MSG_CMD_NETREAD_RSP, ext_netread_req, ext_netread_rsp);
		register_serv_func2("MYNETWRITE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_SENDBUF_REQ, MSG_CMD_SENDBUF_RSP, ext_sendbuf_req, ext_sendbuf_rsp);
		register_serv_func2("MYNETCLOSE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETCLOSE_REQ, MSG_CMD_NETCLOSE_RSP, ext_netclose_req, ext_netclose_rsp);
		register_serv_func2("MYNETPING=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETPING_REQ, MSG_CMD_NETPING_RSP, ext_netping_req, ext_netping_rsp);
		register_serv_func2("MYNETACCEPT=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACCEPT_REQ, MSG_CMD_NETACCEPT_RSP, ext_netaccept_req, ext_netaccept_rsp);
		register_serv_func2("MYNETCREATE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETCREATE_REQ, MSG_CMD_NETCREATE_RSP, ext_netcreate_req, ext_netcreate_rsp);
		register_serv_func2("MYNETURC=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETURC_REQ, MSG_CMD_NETURC_RSP, ext_neturc_req, ext_neturc_rsp);
		register_serv_func2("MYIPFILTER=", MODULE_ID_SOCKET_PROXY, MSG_CMD_IPFILTER_REQ, MSG_CMD_IPFILTER_RSP, ext_ipfilter_req, ext_ipfilter_rsp);
		register_serv_func2("MYNETACK=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACK_REQ, MSG_CMD_NETACK_RSP, ext_netack_req, ext_netack_rsp);
		register_serv_func2("MYSOCKETLED=", MODULE_ID_SOCKET_PROXY, MSG_CMD_SOCKETLED_REQ, MSG_CMD_SOCKETLED_RSP, ext_socketled_req,	ext_socketled_rsp);
		register_serv_func2("MYTYPE?", MODULE_ID_SOCKET_PROXY, MSG_CMD_TYPE_REQ, MSG_CMD_TYPE_RSP, ext_type_req, ext_type_rsp);
		register_serv_func2("MYNETACT?", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACT_QUERY_REQ, MSG_CMD_NETACT_QUERY_RSP, ext_netact_query_req, ext_netact_query_rsp);
		register_serv_func2("MYNETURC?", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETURC_QUERY_REQ, MSG_CMD_NETURC_QUERY_RSP, ext_neturc_query_req, ext_neturc_query_rsp);
		register_serv_func2("MYNETACT=?", 0, 0, 0, ext_netact_equal_query_req, NULL);
		register_serv_func2("MYIPFILTER?", MODULE_ID_SOCKET_PROXY, MSG_CMD_IPFILTER_QUERY_REQ, MSG_CMD_IPFILTER_QUERY_RSP, ext_ipfilter_query_req, ext_ipfilter_query_rsp);
		register_serv_func2("MYIPFILTER=?", 0, 0, 0, ext_ipfilter_equal_query_rsp, NULL);
		register_serv_func2("MYNETSRV?", 0, 0, 0, ext_netsrv_query_rsp, NULL);
		register_serv_func2("MYNETSRV=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETOPEN?", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETOPEN_QUERY_REQ, MSG_CMD_NETOPEN_QUERY_RSP, ext_netopen_query_req, ext_netopen_query_rsp);
		register_serv_func2("MYNETOPEN=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETREAD=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETWRITE=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETCLOSE?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETCLOSE=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETACCEPT?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETACCEPT=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETCREATE?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETCREATE=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func("ENPWRSAVE=",0,ext_enpwrsave_set_func);
		register_serv_func("ENPWRSAVE?",0,ext_enpwrsave_query_func);

		register_formatInform_func("+CSQ", csq_format);
		register_formatInform_func("+CREG", xreg_format);
		register_formatInform_func("+CGREG", xreg_format);
		register_formatInform_func("+CEREG", xreg_format);
		register_formatInform_func("+CGATT", cgatt_format);
		register_formatInform_func("+CGSN", cgsn_format);
	} else if (g_customer_type == CUSTOMER_NANDIAN) {
		register_serv_func2("MYNETACT?", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACT_QUERY_REQ, MSG_CMD_NETACT_QUERY_RSP, ext_netact_query_req, ext_netact_query_rsp);
		register_serv_func2("MYNETACT=?", 0, 0, 0, ext_netact_equal_query_req, NULL);
		register_serv_func2("MYIPFILTER=", MODULE_ID_SOCKET_PROXY, MSG_CMD_IPFILTER_REQ, MSG_CMD_IPFILTER_RSP, ext_ipfilter_req, ext_ipfilter_rsp);
		register_serv_func2("MYIPFILTER?", MODULE_ID_SOCKET_PROXY, MSG_CMD_IPFILTER_QUERY_REQ, MSG_CMD_IPFILTER_QUERY_RSP, ext_ipfilter_query_req, ext_ipfilter_query_rsp);
		register_serv_func2("MYIPFILTER=?", 0, 0, 0, ext_ipfilter_equal_query_rsp, NULL);
		register_serv_func2("MYNETSRV=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETSRV_REQ, MSG_CMD_NETSRV_RSP, ext_netsrv_req,	ext_netsrv_rsp);
		register_serv_func2("MYNETSRV?", 0, 0, 0, ext_netsrv_query_rsp, NULL);
		register_serv_func2("MYNETSRV=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETOPEN=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETOPEN_REQ, MSG_CMD_NETOPEN_RSP, ext_netopen_req, ext_netopen_rsp);
		register_serv_func2("MYNETOPEN?", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETOPEN_QUERY_REQ, MSG_CMD_NETOPEN_QUERY_RSP, ext_netopen_query_req, ext_netopen_query_rsp);
		register_serv_func2("MYNETOPEN=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETREAD=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETREAD_REQ, MSG_CMD_NETREAD_RSP, ext_netread_req, ext_netread_rsp);
		register_serv_func2("MYNETREAD=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETWRITE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_SENDBUF_REQ, MSG_CMD_SENDBUF_RSP, ext_sendbuf_req, ext_sendbuf_rsp);
		register_serv_func2("MYNETWRITE=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETCLOSE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETCLOSE_REQ, MSG_CMD_NETCLOSE_RSP, ext_netclose_req, ext_netclose_rsp);
		register_serv_func2("MYNETCLOSE?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETCLOSE=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETACK=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACK_REQ, MSG_CMD_NETACK_RSP, ext_netack_req, ext_netack_rsp);
		register_serv_func2("MYNETACCEPT=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACCEPT_REQ, MSG_CMD_NETACCEPT_RSP, ext_netaccept_req, ext_netaccept_rsp);
		register_serv_func2("MYNETACCEPT?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETACCEPT=?", 0, 0, 0, ext_ok_rsp, NULL);
		register_serv_func2("MYNETURC=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETURC_REQ, MSG_CMD_NETURC_RSP, ext_neturc_req, ext_neturc_rsp);
		register_serv_func2("MYNETURC?", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETURC_QUERY_REQ, MSG_CMD_NETURC_QUERY_RSP, ext_neturc_query_req, ext_neturc_query_rsp);
		register_serv_func2("MYMODEM?", MODULE_ID_SOCKET_PROXY, MSG_CMD_TYPE_REQ, MSG_CMD_TYPE_RSP, ext_type_req, ext_type_rsp);
		register_serv_func("ENPWRSAVE=",0,ext_enpwrsave_set_func);
		register_serv_func("ENPWRSAVE?",0,ext_enpwrsave_query_func);

		register_formatInform_func("+CSQ", csq_format);
		register_formatInform_func("+CGATT", cgatt_format);
		register_formatInform_func("+CGSN", cgsn_format);

	}

#ifdef AT_QUECTEL
	register_serv_func2("QIOPEN=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QIOPEN_REQ, MSG_CMD_QIOPEN_RSP, ext_qiopen_req,	ext_qiopen_rsp);
	register_serv_func2("QICLOSE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QICLOSE_REQ, MSG_CMD_QICLOSE_RSP, ext_qiclose_req, ext_qiclose_rsp);
	register_serv_func2("QISTATE=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QISTATE_REQ, MSG_CMD_QISTATE_RSP, ext_qistate_req, ext_qistate_rsp);
	register_serv_func2("QISEND=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QISEND_REQ, MSG_CMD_QISEND_RSP, ext_qisend_req, ext_qisend_rsp);
	register_serv_func2("QIRD=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QIRD_REQ, MSG_CMD_QIRD_RSP, ext_qird_req, ext_qird_rsp);
	register_serv_func2("QISENDEX=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QISENDEX_REQ, MSG_CMD_QISENDEX_RSP, ext_qisendex_req, ext_qisendex_rsp);
	register_serv_func2("QISWTMD=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QISWTMD_REQ, MSG_CMD_QISWTMD_RSP, ext_qiswtmd_req, ext_qiswtmd_rsp);
	register_serv_func2("QIDNSCFG=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QIDNSCFG_REQ, MSG_CMD_QIDNSCFG_RSP, ext_qidnscfg_req, ext_qidnscfg_rsp);
	register_serv_func2("QIDNSGIP=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QIDNSGIP_REQ, MSG_CMD_QIDNSGIP_RSP, ext_qidnsgip_req, ext_qidnsgip_rsp);
	register_serv_func2("QIGETERROR=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QIGETERROR_REQ, MSG_CMD_QIGETERROR_RSP, ext_qigeterror_req, ext_qigeterror_rsp);
	register_serv_func2("QPING=", MODULE_ID_SOCKET_PROXY, MSG_CMD_QPING_REQ, MSG_CMD_QPING_RSP, ext_qping_req, ext_qping_rsp);
#endif

	return 0;
}

#endif
