/**
 * 
 * @file      ext_amt_func.c
 * @brief     
 *            This file is part of FTM.
 *            AMTģAT
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2018/04/28  1.0      liu.xin        Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include "ext_regist.h"
#include "drv_msg.h"

#include "at_com.h"
#include <unistd.h>
#include <sys/syscall.h> 
#include "RONvParam_AMT.h"
#include "ref_nv_def.h"
#include "nv_api.h"
#include "amtnv.h"
#include <linux/soc/zte/efuse/efuse_zx.h>
#include <linux/soc/zte/otp/otp_zx.h>
#include "NvParam_drv.h"
#include "libkey.h"

//mdlûģʽзģʽȨ
static int auth_device_key_result = 0;

#define GET_LCD_INFO   378
#define GET_WIFI_INFO  379
#define GET_FLASH_INFO 380
#define GET_CPU_INFO   381
#define GET_DDR_INFO   382
//CP
typedef unsigned char  BYTE;

#define DC_MacLen               (BYTE)12
#define DC_ImeiLen              (BYTE)8
#define MSN_MAX_NVINFO_LEN      20
#define MSINFO_MAX_NVINFO_LEN   200
#define MDMVERSION_MAX_LEN      64
#define bInside(data, up, down) (((data) <= (up) && (data) >= (down)) || \
                                                  ((data) >= (up) && (data) <= (down)))
typedef unsigned long u32_t;
	
#ifndef SMEMCPY
#define SMEMCPY(dst,src,len)            memcpy(dst,src,len)
#endif

/**
 * @brief ZMDMVERSIONӦϢṹ
 * @param result   AT_RSP_OK/AT_RSP_ERR
 * @param mdmVer  modem汾
 */
typedef struct
{
    char mdmVer[MDMVERSION_MAX_LEN]; 
    int result;
}AT_MDMVERSION_RSP_INFO;

//static char mdmVer[MDMVERSION_MAX_LEN] = {0};//ڼ¼ZGMR ظ

struct flash_ddr_info{
    char manu[32];
    char model[32];
    char size[32];
    char other[32];
};

struct lcd_info
{
    char manu[32];
    char ic[32];
    char resolution[32];
};

struct wifi_info
{
    char manu[32];
    char ic[32];
};
struct cpu_info{
    char manu[32];
    char model[32];
};

/* Data structure for MD5 (Message-Digest) computation */
typedef struct {
  u32_t i[2];               /* number of _bits_ handled mod 2^64 */
  u32_t buf[4];             /* scratch buffer */
  unsigned char in[64];     /* input buffer */
  unsigned char digest[16]; /* actual digest after md5_final call */
} md5_ctx;


extern void at_context_chn_info_mod(char *at_paras);

/*
 ***********************************************************************
 **  Message-digest routines:                                         **
 **  To form the message digest for a message M                       **
 **    (1) Initialize a context buffer ctx using md5_init             **
 **    (2) Call md5_update on ctx and M                               **
 **    (3) Call md5_final on ctx                                      **
 **  The message digest is now in ctx->digest[0...15]                 **
 ***********************************************************************
 */

/* forward declaration */
static void transform(u32_t *buf, u32_t *in);

static unsigned char PADDING[64] = {
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* F, G, H and I are basic MD5 functions */
#define F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z)))

/* ROTATE_LEFT rotates x left n bits */
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4 */
/* Rotation is separate from addition to prevent recomputation */
#define FF(a, b, c, d, x, s, ac) \
  {(a) += F ((b), (c), (d)) + (x) + (u32_t)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define GG(a, b, c, d, x, s, ac) \
  {(a) += G ((b), (c), (d)) + (x) + (u32_t)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define HH(a, b, c, d, x, s, ac) \
  {(a) += H ((b), (c), (d)) + (x) + (u32_t)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define II(a, b, c, d, x, s, ac) \
  {(a) += I ((b), (c), (d)) + (x) + (u32_t)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }

#ifdef __STDC__
#define UL(x) x##UL
#else
#ifdef WIN32
#define UL(x) x##UL
#else
#define UL(x) x
#endif
#endif

/* The routine md5_init initializes the message-digest context
   mdContext. All fields are set to zero.
 */
void md5_init(md5_ctx *ctx)
{
	ctx->i[0] = ctx->i[1] = (u32_t)0;

  /* Load magic initialization constants. */
    ctx->buf[0] = (u32_t)0x67452301UL;
    ctx->buf[1] = (u32_t)0xefcdab89UL;
    ctx->buf[2] = (u32_t)0x98badcfeUL;
    ctx->buf[3] = (u32_t)0x10325476UL;
}

/* The routine md5_update updates the message-digest context to
   account for the presence of each of the characters buf[0..inLen-1]
   in the message whose digest is being computed.
 */

void md5_update(md5_ctx *ctx, unsigned char *buf, unsigned int len)
{
  u32_t in[16];
  int mdi;
  unsigned int i, ii;

#if 0
  ppp_trace(LOG_INFO, "MD5Update: %u:%.*H\n", len, MIN(len, 20) * 2, buf);
  ppp_trace(LOG_INFO, "MD5Update: %u:%s\n", len, buf);
#endif

  /* compute number of bytes mod 64 */
  mdi = (int)((ctx->i[0] >> 3) & 0x3F);

  /* update number of bits */
  if ((ctx->i[0] + ((u32_t)len << 3)) < ctx->i[0]) {
    ctx->i[1]++;
  }
  ctx->i[0] += ((u32_t)len << 3);
  ctx->i[1] += ((u32_t)len >> 29);

  while (len--) {
    /* add new character to buffer, increment mdi */
    ctx->in[mdi++] = *buf++;

    /* transform if necessary */
    if (mdi == 0x40) {
      for (i = 0, ii = 0; i < 16; i++, ii += 4) {
        in[i] = (((u32_t)ctx->in[ii+3]) << 24) |
                (((u32_t)ctx->in[ii+2]) << 16) |
                (((u32_t)ctx->in[ii+1]) << 8)  |
                ((u32_t)ctx->in[ii]);
      }
      transform (ctx->buf, in);
      mdi = 0;
    }
  }
}

/* The routine md5_final terminates the message-digest computation and
   ends with the desired message digest in ctx->digest[0...15].
 */

void md5_final(unsigned char hash[], md5_ctx *ctx)
{
  u32_t in[16];
  int mdi;
  unsigned int i, ii;
  unsigned int pad_len;

  /* save number of bits */
  in[14] = ctx->i[0];
  in[15] = ctx->i[1];

  /* compute number of bytes mod 64 */
  mdi = (int)((ctx->i[0] >> 3) & 0x3F);

  /* pad out to 56 mod 64 */
  pad_len = (mdi < 56) ? (56 - mdi) : (120 - mdi);
  md5_update (ctx, PADDING, pad_len);

  /* append length in bits and transform */
  for (i = 0, ii = 0; i < 14; i++, ii += 4) {
    in[i] = (((u32_t)ctx->in[ii+3]) << 24) |
            (((u32_t)ctx->in[ii+2]) << 16) |
            (((u32_t)ctx->in[ii+1]) << 8)  |
            ((u32_t)ctx->in[ii]);
  }
  transform (ctx->buf, in);

  /* store buffer in digest */
  for (i = 0, ii = 0; i < 4; i++, ii += 4) {
    ctx->digest[ii]   = (unsigned char)(ctx->buf[i] & 0xFF);
    ctx->digest[ii+1] =
      (unsigned char)((ctx->buf[i] >> 8)  & 0xFF);
    ctx->digest[ii+2] =
      (unsigned char)((ctx->buf[i] >> 16) & 0xFF);
    ctx->digest[ii+3] =
      (unsigned char)((ctx->buf[i] >> 24) & 0xFF);
  }
  SMEMCPY(hash, ctx->digest, 16);
}

/* Basic MD5 step. Transforms buf based on in.
 */
static void transform (u32_t *buf, u32_t *in)
{
  u32_t a = buf[0], b = buf[1], c = buf[2], d = buf[3];

  /* Round 1 */
  #define S11 7
  #define S12 12
  #define S13 17
  #define S14 22
  FF ( a, b, c, d, in[ 0], S11, UL(3614090360)); /* 1 */
  FF ( d, a, b, c, in[ 1], S12, UL(3905402710)); /* 2 */
  FF ( c, d, a, b, in[ 2], S13, UL( 606105819)); /* 3 */
  FF ( b, c, d, a, in[ 3], S14, UL(3250441966)); /* 4 */
  FF ( a, b, c, d, in[ 4], S11, UL(4118548399)); /* 5 */
  FF ( d, a, b, c, in[ 5], S12, UL(1200080426)); /* 6 */
  FF ( c, d, a, b, in[ 6], S13, UL(2821735955)); /* 7 */
  FF ( b, c, d, a, in[ 7], S14, UL(4249261313)); /* 8 */
  FF ( a, b, c, d, in[ 8], S11, UL(1770035416)); /* 9 */
  FF ( d, a, b, c, in[ 9], S12, UL(2336552879)); /* 10 */
  FF ( c, d, a, b, in[10], S13, UL(4294925233)); /* 11 */
  FF ( b, c, d, a, in[11], S14, UL(2304563134)); /* 12 */
  FF ( a, b, c, d, in[12], S11, UL(1804603682)); /* 13 */
  FF ( d, a, b, c, in[13], S12, UL(4254626195)); /* 14 */
  FF ( c, d, a, b, in[14], S13, UL(2792965006)); /* 15 */
  FF ( b, c, d, a, in[15], S14, UL(1236535329)); /* 16 */

  /* Round 2 */
  #define S21 5
  #define S22 9
  #define S23 14
  #define S24 20
  GG ( a, b, c, d, in[ 1], S21, UL(4129170786)); /* 17 */
  GG ( d, a, b, c, in[ 6], S22, UL(3225465664)); /* 18 */
  GG ( c, d, a, b, in[11], S23, UL( 643717713)); /* 19 */
  GG ( b, c, d, a, in[ 0], S24, UL(3921069994)); /* 20 */
  GG ( a, b, c, d, in[ 5], S21, UL(3593408605)); /* 21 */
  GG ( d, a, b, c, in[10], S22, UL(  38016083)); /* 22 */
  GG ( c, d, a, b, in[15], S23, UL(3634488961)); /* 23 */
  GG ( b, c, d, a, in[ 4], S24, UL(3889429448)); /* 24 */
  GG ( a, b, c, d, in[ 9], S21, UL( 568446438)); /* 25 */
  GG ( d, a, b, c, in[14], S22, UL(3275163606)); /* 26 */
  GG ( c, d, a, b, in[ 3], S23, UL(4107603335)); /* 27 */
  GG ( b, c, d, a, in[ 8], S24, UL(1163531501)); /* 28 */
  GG ( a, b, c, d, in[13], S21, UL(2850285829)); /* 29 */
  GG ( d, a, b, c, in[ 2], S22, UL(4243563512)); /* 30 */
  GG ( c, d, a, b, in[ 7], S23, UL(1735328473)); /* 31 */
  GG ( b, c, d, a, in[12], S24, UL(2368359562)); /* 32 */

  /* Round 3 */
  #define S31 4
  #define S32 11
  #define S33 16
  #define S34 23
  HH ( a, b, c, d, in[ 5], S31, UL(4294588738)); /* 33 */
  HH ( d, a, b, c, in[ 8], S32, UL(2272392833)); /* 34 */
  HH ( c, d, a, b, in[11], S33, UL(1839030562)); /* 35 */
  HH ( b, c, d, a, in[14], S34, UL(4259657740)); /* 36 */
  HH ( a, b, c, d, in[ 1], S31, UL(2763975236)); /* 37 */
  HH ( d, a, b, c, in[ 4], S32, UL(1272893353)); /* 38 */
  HH ( c, d, a, b, in[ 7], S33, UL(4139469664)); /* 39 */
  HH ( b, c, d, a, in[10], S34, UL(3200236656)); /* 40 */
  HH ( a, b, c, d, in[13], S31, UL( 681279174)); /* 41 */
  HH ( d, a, b, c, in[ 0], S32, UL(3936430074)); /* 42 */
  HH ( c, d, a, b, in[ 3], S33, UL(3572445317)); /* 43 */
  HH ( b, c, d, a, in[ 6], S34, UL(  76029189)); /* 44 */
  HH ( a, b, c, d, in[ 9], S31, UL(3654602809)); /* 45 */
  HH ( d, a, b, c, in[12], S32, UL(3873151461)); /* 46 */
  HH ( c, d, a, b, in[15], S33, UL( 530742520)); /* 47 */
  HH ( b, c, d, a, in[ 2], S34, UL(3299628645)); /* 48 */

  /* Round 4 */
  #define S41 6
  #define S42 10
  #define S43 15
  #define S44 21
  II ( a, b, c, d, in[ 0], S41, UL(4096336452)); /* 49 */
  II ( d, a, b, c, in[ 7], S42, UL(1126891415)); /* 50 */
  II ( c, d, a, b, in[14], S43, UL(2878612391)); /* 51 */
  II ( b, c, d, a, in[ 5], S44, UL(4237533241)); /* 52 */
  II ( a, b, c, d, in[12], S41, UL(1700485571)); /* 53 */
  II ( d, a, b, c, in[ 3], S42, UL(2399980690)); /* 54 */
  II ( c, d, a, b, in[10], S43, UL(4293915773)); /* 55 */
  II ( b, c, d, a, in[ 1], S44, UL(2240044497)); /* 56 */
  II ( a, b, c, d, in[ 8], S41, UL(1873313359)); /* 57 */
  II ( d, a, b, c, in[15], S42, UL(4264355552)); /* 58 */
  II ( c, d, a, b, in[ 6], S43, UL(2734768916)); /* 59 */
  II ( b, c, d, a, in[13], S44, UL(1309151649)); /* 60 */
  II ( a, b, c, d, in[ 4], S41, UL(4149444226)); /* 61 */
  II ( d, a, b, c, in[11], S42, UL(3174756917)); /* 62 */
  II ( c, d, a, b, in[ 2], S43, UL( 718787259)); /* 63 */
  II ( b, c, d, a, in[ 9], S44, UL(3951481745)); /* 64 */

  buf[0] += a;
  buf[1] += b;
  buf[2] += c;
  buf[3] += d;
}

static int is_mac_valid(char*macStr)
{
    int Macindex = 0;
	for (; (macStr[Macindex] != '\0') && (Macindex < OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE); Macindex++)
    {
        char chmac = macStr[Macindex];
        if (!(bInside(chmac, '0', '9') || bInside(chmac, 'a', 'f') || bInside(chmac, 'A', 'F')))
        {
            at_print(AT_DEBUG,"mac is not hex str\r");
            return FALSE;
        }
	}
    return TRUE;
}
static char Ascii2BCD(char iAscii)
{
    char iBCD;

    if ( bInside(iAscii, '0', '9'))
    {
        iBCD = iAscii - '0';

    }
    else if (bInside(iAscii, 'a', 'f'))
    {
        iBCD = iAscii - 'a' + 0x0a;

    }
    else if (bInside(iAscii, 'A', 'F'))
    {
        iBCD = iAscii - 'A' + 0x0a;
    }
    else
    {
        return -1;
    }

    return iBCD;

}

static char BCD2Ascii(char iBCD)
{
    char iAscii;

    if (bInside(iBCD, 0x00, 0x09))
    {
        iAscii = (unsigned char)(iBCD + '0');
    }
    else if (bInside(iBCD, 0x0a, 0x0f))
    {
        iAscii = (unsigned char)((iBCD - 0x0a) + 'A');
    }
    else
    {
        return -1;
    }
    return iAscii;
}

static int IsImeiStrValid(char* imeiStr)
{
    int i = 0;
    for (; i < 15; ++i)
    {
        if (imeiStr[i] < '0' || imeiStr[i] > '9')
        {
            return FALSE;
        }
    }
    return TRUE;
}

static long Char2Int(char chr)
{
    long value = 0;
    value =  (chr - '0');
    return value;
}

static char Int2Char(long value)
{
    char ch = '0'+value;
    return ch;
}

static unsigned long DC_Writeimei(char * imeistr)
{
    int     Imeiindex =0,checkindex=0;
    BYTE    abImei[DC_ImeiLen]={0};
    BYTE    Index1=0,Index2=0;
    
    for(Imeiindex=0;imeistr[Imeiindex]!='\0';Imeiindex+=2)
    {    
        at_print(AT_DEBUG,"Imeiindex= %d\r\n",Imeiindex);
        at_print(AT_DEBUG,"imeistr[%d]= %c\r\n",Imeiindex,imeistr[Imeiindex]);

        Index1=Char2Int((char)imeistr[Imeiindex]);      
        at_print(AT_DEBUG,"Index1= %d\r",Index1);
        
        if((imeistr[Imeiindex+1])!='\0')
        {
        
            Index2= Char2Int((char)imeistr[Imeiindex+1]);
            at_print(AT_DEBUG,"Index2= %d, Index2<<4 =%x , (Index2<<4)&Index1 = %x\r\n",Index2,Index2<<4,(Index2<<4)|Index1);

            abImei[Imeiindex/2]=(Index2<<4)|Index1;
            at_print(AT_DEBUG,"abImei[%d]= %x\r\n",Imeiindex/2,abImei[Imeiindex/2]);
        }
        else
        {
            abImei[Imeiindex/2]=0xF0|Index1;
            at_print(AT_DEBUG,"abImei[%d]= %x\r\n",Imeiindex/2,abImei[Imeiindex/2]);
            break;
        }
    }
    for(checkindex=0;checkindex<8;checkindex++)
    {
        at_print(AT_DEBUG,"abImei[%d] = %x\r\n",checkindex,abImei[checkindex]);
    }

    if(CPNV_ERROR == amt_nvro_write(OS_FLASH_AMT_COMM_RO_IMEI_ADDRESS, sizeof(abImei), abImei))
    {
        at_print(AT_ERR,"Write amt imei failed\r\n");
        return  -1;
    }

    return 0;
}


/**************************************************************************
* : DC_WriteMacAddr
* : ASCIIתBCD룬 MACַд뵽NV
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static unsigned long DC_WriteMacAddr(char *macstr)
{
    unsigned long   Macindex = 0;
    unsigned char   abMac[OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE] = {0};
    unsigned char   Index1 = 0;
    unsigned char   Index2 = 0;

	if(!is_mac_valid(macstr))
	{
	     at_print(AT_DEBUG,"mac is not hex str\r");
         return -1;
	}

    /*ASCIIתBCD*/
    for (Macindex = 0; macstr[Macindex] != '\0' && (Macindex < OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE); Macindex += 2)
    {
        Index1 = (unsigned char)Ascii2BCD((char)macstr[Macindex]);
        Index2 = (unsigned char)Ascii2BCD((char)macstr[Macindex + 1]);
        abMac[Macindex/2]=(Index1<<4)|Index2;
    }
    
    if (CPNV_ERROR == amt_nvro_write(OS_FLASH_AMT_COMM_RO_WIFIMAC_ADDRESS, OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE, abMac))
    {
        at_print(AT_DEBUG,"Write amt mac failed\r");
        return  -1;
    }

    return  0;
}

/**************************************************************************
* : DC_WriteMac2Addr
* : ASCIIתBCD룬 MACַд뵽NV
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static unsigned long DC_WriteMac2Addr(char *macstr)
{
    unsigned long   Macindex = 0;
    unsigned char   abMac[OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE] = {0};
    unsigned char   Index1 = 0;
    unsigned char   Index2 = 0;
	
	if(!is_mac_valid(macstr))
	{
	     at_print(AT_DEBUG,"mac is not hex str\r");
         return -1;
	}

    /*ASCIIתBCD*/
    for (Macindex = 0; macstr[Macindex] != '\0' && (Macindex < OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE); Macindex += 2)
    {
        Index1 = (unsigned char)Ascii2BCD((char)macstr[Macindex]);
        Index2 = (unsigned char)Ascii2BCD((char)macstr[Macindex + 1]);
		abMac[Macindex/2]=(Index1<<4)|Index2;
    }
    
    if (CPNV_ERROR== amt_nvro_write(OS_FLASH_AMT_COMM_RO_WIFIMAC2_ADDRESS, OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE, abMac))
    {
        at_print(AT_DEBUG,"Write amt mac failed\r");
        return -1;
    }

    return 0;
}

/**************************************************************************
* : DC_WriteRJ45MacAddr
* : ASCIIתBCD룬 MACַд뵽NV
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
unsigned long DC_WriteRJ45MacAddr(char *macstr)
{
    unsigned long   Macindex = 0;
    unsigned char   abMac[OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE] = {0};
    unsigned char   Index1 = 0;
    unsigned char   Index2 = 0;

	if(!is_mac_valid(macstr))
	{
	     at_print(AT_DEBUG,"mac is not hex str\r");
         return -1;
	}

    /*ASCIIתBCD*/
    for (Macindex = 0; macstr[Macindex] != '\0' && (Macindex < OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE); Macindex += 2)
    {
        Index1 = (unsigned char)Ascii2BCD((char)macstr[Macindex]);
        Index2 = (unsigned char)Ascii2BCD((char)macstr[Macindex + 1]);
        abMac[Macindex/2]=(Index1<<4)|Index2;
    }

    if (CPNV_ERROR== amt_nvro_write(OS_FLASH_AMT_COMM_RO_ETHMAC_ADDRESS, OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE, abMac))
    {
        at_print(AT_DEBUG,"Write amt ethmac failed\r");
        return -1;
    }

    return 0;
}


/**************************************************************************
* : DC_WriteMacAddr
* : ASCIIתBCD룬 USB MACַд뵽NV
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static unsigned long DC_WriteUSBMacAddr(char *macstr)
{
    unsigned long   Macindex = 0;
    unsigned char   abMac[OS_FLASH_AMT_COMM_RO_USBMAC_SIZE] = {0};
    unsigned char   Index1 = 0;
    unsigned char   Index2 = 0;

	if(!is_mac_valid(macstr))
	{
	     at_print(AT_DEBUG,"mac is not hex str\r");
         return -1;
	}

    /*ASCIIתBCD*/
    for (Macindex = 0; macstr[Macindex] != '\0' && (Macindex < OS_FLASH_AMT_COMM_RO_USBMAC_SIZE); Macindex += 2)
    {
        Index1 = (unsigned char)Ascii2BCD((char)macstr[Macindex]);
        Index2 = (unsigned char)Ascii2BCD((char)macstr[Macindex + 1]);
        abMac[Macindex/2]=(Index1<<4)|Index2;
    }
    
    if (CPNV_ERROR == amt_nvro_write(OS_FLASH_AMT_COMM_RO_USBMAC_ADDRESS, OS_FLASH_AMT_COMM_RO_USBMAC_SIZE, abMac))
    {
        at_print(AT_DEBUG,"Write amt usb mac failed\r");
        return  -1;
    }

    return  0;
}

/**************************************************************************
* : DC_WriteMacAddr
* : ASCIIתBCD룬 GMACַд뵽NV
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
static unsigned long DC_WriteGmacAddr(char *macstr)
{
    unsigned long   Macindex = 0;
    unsigned char   abMac[OS_FLASH_AMT_COMM_RO_GMAC_SIZE] = {0};
    unsigned char   Index1 = 0;
    unsigned char   Index2 = 0;

	if(!is_mac_valid(macstr))
	{
	     at_print(AT_DEBUG,"mac is not hex str\r");
         return -1;
	}

    /*ASCIIתBCD*/
    for (Macindex = 0; macstr[Macindex] != '\0' && (Macindex < OS_FLASH_AMT_COMM_RO_GMAC_SIZE); Macindex += 2)
    {
        Index1 = (unsigned char)Ascii2BCD((char)macstr[Macindex]);
        Index2 = (unsigned char)Ascii2BCD((char)macstr[Macindex + 1]);
        abMac[Macindex/2]=(Index1<<4)|Index2;
    }

    if (CPNV_ERROR == amt_nvro_write(OS_FLASH_AMT_COMM_RO_GMAC_ADDRESS, OS_FLASH_AMT_COMM_RO_GMAC_SIZE, abMac))
    {
        at_print(AT_DEBUG,"Write amt Gmac failed\r");
        return  -1;
    }

    return  0;
}


static int rkeydc_act_func(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
    int retCode = -1;
    //char pStr[8] = {0};
    char *at_str = NULL;
    struct flash_ddr_info flashInfo = {{0}};
    struct flash_ddr_info ddrInfo = {{0}};
    struct cpu_info cpuInfo = {{0}};
    struct wifi_info wifiInfo = {{0}};
    struct lcd_info lcdInfo = {{0}};
    
    at_print(AT_ERR,"rkeydc_act_func: \n");
    at_str = malloc(64);
	if(at_str == NULL)
		return AT_END;
    memset(at_str,0,64);
    if(strstr(at_paras, "DDR"))
    {
        retCode = syscall(GET_DDR_INFO,ddrInfo.manu,ddrInfo.size,ddrInfo.model);
        if(retCode < 0)
        {
            at_print(AT_ERR,"rkeydc_act_func: syscall GET_DDR_INFO failed \n");
			free(at_str);
            return AT_END;
        }
        at_print(AT_ERR,"rkeydc_act_func: ddrInfo.manu = %s,size = %s,model =%s\n",ddrInfo.manu,ddrInfo.size,ddrInfo.model);
        snprintf((char*)at_str,64,"\r\n%s?NA?NA?%s?%s\r\n",ddrInfo.manu,ddrInfo.size,ddrInfo.model);
        *res_msg = at_str;
        *res_msglen = strlen(*res_msg);
    }
    else if(strstr(at_paras, "FLASH"))
    {
        retCode = syscall(GET_FLASH_INFO,flashInfo.manu,flashInfo.model,flashInfo.size);
        if(retCode < 0)
        {
            at_print(AT_ERR,"rkeydc_act_func: syscall GET_FLASH_INFO failed \n");
			free(at_str);
            return AT_END;
        }
        at_print(AT_ERR,"rkeydc_act_func: flashInfo.manu = %s,model = %s,size =%s\n",flashInfo.manu,flashInfo.model,flashInfo.size);
        snprintf((char*)at_str,64,"\r\n%s?%s?NA?%s?NA\r\n",flashInfo.manu,flashInfo.model,flashInfo.size);
        *res_msg = at_str;
        *res_msglen = strlen(*res_msg);
    }
    else if(strstr(at_paras, "LCD"))
    {   
        retCode = syscall(GET_LCD_INFO,lcdInfo.manu,lcdInfo.ic,lcdInfo.resolution);
        if(retCode < 0)
        {
            at_print(AT_ERR,"rkeydc_act_func: syscall GET_LCD_INFO failed \n");
		    free(at_str);
            return AT_END;
        }
        at_print(AT_ERR,"rkeydc_act_func: lcdInfo.manu = %s,ic = %s,resolution =%s\n",lcdInfo.manu,lcdInfo.ic,lcdInfo.resolution);
        snprintf((char*)at_str,64,"\r\n%s?%s?NA?NA?%s\r\n",lcdInfo.manu,lcdInfo.ic,lcdInfo.resolution);
        *res_msg = at_str;
        *res_msglen = strlen(*res_msg);
    }
    else if(strstr(at_paras, "WIFI"))
    {   
        retCode = syscall(GET_WIFI_INFO,wifiInfo.manu,wifiInfo.ic);
        if(retCode < 0)
        {
            at_print(AT_ERR,"rkeydc_act_func: syscall GET_WIFI_INFO failed \n");
			free(at_str);
            return AT_END;
        }
        at_print(AT_ERR,"rkeydc_act_func: wifiInfo.manu = %s,ic = %s\n",wifiInfo.manu,wifiInfo.ic);
        snprintf((char*)at_str,64,"\r\n%s?%s?NA?NA?NA\r\n",wifiInfo.manu,wifiInfo.ic);
        *res_msg = at_str;
        *res_msglen = strlen(*res_msg);
    }
    else if(strstr(at_paras, "CPU"))
    {   
        retCode = syscall(GET_CPU_INFO,cpuInfo.manu,cpuInfo.model);
        if(retCode < 0)
        {
            at_print(AT_ERR,"rkeydc_act_func: syscall GET_CPU_INFO failed \n");
			free(at_str);
            return AT_END;
        }
        at_print(AT_ERR,"rkeydc_act_func: cpuInfo.manu = %s,model =%s\n",cpuInfo.manu,cpuInfo.model);
        snprintf((char*)at_str,64,"\r\n%s?%s?NA?NA?NA\r\n",cpuInfo.manu,cpuInfo.model);
        *res_msg = at_str;
        *res_msglen = strlen(*res_msg);
    }
	else
	{
	    free(at_str);
	}
    
    return AT_END;
    
}

int poweroff_act_func(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
    system("poweroff");
    // add by houweifeng for zhangwei 20200707, systemһִͬ
    *res_msg = at_ok_build();
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

/**************************************************************************
* : chip_platform_read_act_func
* : return chip platform 1:7520V3 2:7100
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int chip_platform_read_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    char TmpChipPlatform[32]    ={0};
    snprintf((char *)TmpChipPlatform, 32,"1");
    *res_msg = at_query_result_build("PLATFORM",TmpChipPlatform);
    *res_msglen = strlen(*res_msg);
       
    return AT_END;
}

/**************************************************************************
* : imeiRead_act_func
* : imei
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int imeiRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode =  -1;
    char TmpImei[DC_ImeiLen]= {0}; //imeiֵ
    int abImeiindex = 0,imeistrindex = 0;
    static char imeistr[2*DC_ImeiLen] = {0};
    char *at_str = NULL;
    
    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_IMEI_ADDRESS, (unsigned char *)TmpImei, OS_FLASH_AMT_COMM_RO_IMEI_SIZE);
    at_print(AT_DEBUG,"retCode = %d\r\n",retCode );
    if(CPNV_ERROR == retCode )
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
        return AT_END;  
    }
    
    for (abImeiindex=0; abImeiindex<DC_ImeiLen-1; abImeiindex++,imeistrindex+=2)
    {
        imeistr[imeistrindex] = Int2Char(TmpImei[abImeiindex]&0x0F);
        imeistr[imeistrindex+1] = Int2Char((TmpImei[abImeiindex]&0xF0)>>4);
    }
    
    imeistr[2*DC_ImeiLen-2]=Int2Char(TmpImei[DC_ImeiLen-1]&0x0F);
    imeistr[2*DC_ImeiLen-1] = '\0';

    //*res_msg = at_query_result_build(NULL,imeistr);
    at_str = malloc(32);
	if(at_str)
	{
	    sprintf(at_str,"\r\n%s\r\nOK\r\n",imeistr);
	    *res_msg = at_str;
	    *res_msglen = strlen(*res_msg);
	}
    return AT_END;
}


/**************************************************************************
* : imeiWrite_act_func
* : дimei
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int imeiWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    //long retCode = -1;
    char *at_str = NULL; 
    char Imeistr[2*DC_ImeiLen]= {0};

    
    at_str = at_paras;  
    
    at_print(AT_DEBUG,"imeiWrite_act_func = %s.\n", at_str);

    //if ((strstr((const char *)at_str,"\r")-(char *)at_str)!= (2*DC_ImeiLen-1) || !IsImeiStrValid(at_str))
    if (strlen(at_paras) != (2*DC_ImeiLen-1) || !IsImeiStrValid(at_str))
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
        *res_msglen = strlen(*res_msg);     
    }
    else
    {
        if (-1 ==DC_Writeimei((char *)at_str))
        {
            *res_msg = at_err_build(ATERR_PROC_FAILED);
            *res_msglen = strlen(*res_msg);     
            return AT_END;  
        }
        
        memcpy(Imeistr,at_str,2*DC_ImeiLen-1);
        Imeistr[2*DC_ImeiLen-1] = '\0';
        *res_msg = at_query_result_build("MODIMEI",Imeistr);
        *res_msglen = strlen(*res_msg);
    }

    return AT_END;  
}

/**************************************************************************
* : ssidRead_act_func
* : ȡSSID
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int ssidRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode = CPNV_ERROR;
    char TmpSSID[ZPS_REF_MSINFO_MAX_SSID_LEN+1]={0};
    
    retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_SSID_BASE_ADDR, (unsigned char*)TmpSSID, ZPS_REF_MSINFO_MAX_SSID_LEN);
	TmpSSID[ZPS_REF_MSINFO_MAX_SSID_LEN] = '\0';
	if(CPNV_ERROR == retCode)
    {
         at_print(AT_ERR,"cpnv_NvItemRead ssid fail !\n");
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
         return AT_END; 
    }
    //strcpy(TmpSSID, (const char*)cfg_get("zssid"));

    *res_msg = at_query_result_build("SSID",TmpSSID);
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

/**************************************************************************
* : ssidWrite_act_func
* : дSSID
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: SSIDŸıʱatserverϱctrmctrmSSIDдNV
**************************************************************************/
int ssidWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode = CPNV_ERROR;
    char *at_str = NULL; 

    at_print(AT_ERR,"at_paras=%s\n",at_paras);
    
    at_str = at_paras;  

    retCode = cpnv_NvItemWrite(ZPS_REF_MSINFO_SSID_BASE_ADDR, (unsigned char*)at_str, strlen(at_str));
    at_print(AT_ERR,"at_str=%s\n",at_str);
    at_print(AT_ERR,"retCode=%d\n",retCode);

    if(CPNV_ERROR == retCode)
    {
        at_print(AT_ERR,"cpnv_NvItemWrite ssid fail !\n");
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
        return AT_END;  
    }
    else
    {
        at_print(AT_ERR,"cpnv_NvItemWrite ssid success !\n");
    }

    sc_cfg_set("zssid",at_str);    

    retCode = cpnv_NvramFlush();
    
    if (retCode == CPNV_OK)
    {
        *res_msg = at_query_result_build("SSID",at_str);
    }
    else
    {   
        at_print(AT_ERR,"cpnv_NvramFlush ssid fail !\n");
        *res_msg = at_err_build(ATERR_PROC_FAILED);
    }
    *res_msglen = strlen(*res_msg);

    return AT_END;

}


/**************************************************************************
* : versionTypeSet_act_func
* : ð汾ͣAMT汾/汾
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: AT+ZVERSIONTYPE=0Ϊ汾AT+ZVERSIONTYPE=1ΪAMT汾
**************************************************************************/
int versionTypeSet_act_func(int at_fd, char * at_paras,void **res_msg, int * res_msglen)
{
    long    retCode =  -1;
    char   *at_str  = NULL; 
    int     ntype   = -1;   
    
    at_print(AT_ERR,"at_paras=%s\n", at_paras);
    at_str = at_paras;  

    unsigned char bootmode[] = {0x54, 0x4D};
	unsigned char atmode[] = {0x41, 0x54};
    get_at_cmd_param_int(at_str, &ntype, (const char **)&at_str);
    
    if(!is_at_cmd_end(at_str))
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID); 
        *res_msglen = strlen(*res_msg);
        return AT_END;
    }   

    if(ntype == 1)
    {
        retCode = amt_set_bootmode(bootmode);
    }
    else if(ntype == 0)
    {
        memset(bootmode, 0xFF, 2);
        retCode = amt_set_bootmode(bootmode);
    }
	else if(ntype == 2)
	{
		retCode = amt_set_amt_atmode(bootmode,atmode);
    }
    else
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID); 
        *res_msglen = strlen(*res_msg);
        return AT_END;
    }
    if (retCode == 0)
    {
        if (ntype == 0)
        {
            *res_msg = at_query_result_build("versionType","0");
        }
        else if(ntype == 1)
        {
            *res_msg = at_query_result_build("versionType","1");
        }
		else if(ntype == 2)
        {
            *res_msg = at_query_result_build("versionType","2");
        }
    }
    else
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED); 
    }  
    
    *res_msglen = strlen(*res_msg);
    
    return AT_END;
}

/**************************************************************************
* : macRead_act_func
* : MACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: NVMACַΪBCD룬ҪתASCII
**************************************************************************/
int macRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode = CPNV_ERROR;
    char TmpMacAddr[Comm_DEV_MSINFO_MAX_WIFIMAC_Area_Len] = {0};//imeiֵ
    char str[13];
    unsigned long abMacindex = 0;
    static char macstr[2 * AT_CMD_MAX - 1] = {0};

    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_WIFIMAC_ADDRESS, (unsigned char *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE);
    at_print(AT_DEBUG,"retCode = %d\r\n",retCode );
    if(CPNV_ERROR == retCode )
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
        return AT_END;  
    }
    
    /* MACַתBCDתΪAscii  */
    memset(str, 0, 13);

    for (abMacindex = 0; abMacindex< 12; abMacindex += 2)
    {
        str[abMacindex] = ((TmpMacAddr[abMacindex/2]) >> 4) & 0x0F;
        str[abMacindex+1] = TmpMacAddr[abMacindex/2] & 0x0F;

        macstr[abMacindex] = BCD2Ascii(str[abMacindex]);
        macstr[abMacindex+1] = BCD2Ascii(str[abMacindex+1]);
    }

    *res_msg = at_query_result_build("MAC",macstr);
    *res_msglen = strlen(*res_msg);

    return AT_END;

}

/**************************************************************************
* : macWrite_act_func
* : дMACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int macWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    //long retCode = CPNV_ERROR;
    char *at_str = NULL; 

    //zOss_ASSERT(at_paras!=NULL);
    at_str = at_paras;  

    if (strlen(at_str) != DC_MacLen)
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
    }
    else
    {
        if (-1 == DC_WriteMacAddr((char *)at_str))
        {                
            *res_msg = at_err_build(ATERR_PROC_FAILED);
        }
        else
        {
            //*res_msg = at_query_result_build("MAC",at_str);
            *res_msg = at_ok_build();
        }
    }   
    
    *res_msglen = strlen(*res_msg);

    return AT_END;
}

/**************************************************************************
* : wifikeyRead_act_func
* : ȡWifiKeyֵ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int wifikeyRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode = CPNV_ERROR;
    char TmpWifiKey[ZPS_REF_MSINFO_MAX_NEWWIFIKEY_LEN+1]={0};
    
    retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_NEWWIFIKEY_BASE_ADDR, (unsigned char *)TmpWifiKey, ZPS_REF_MSINFO_MAX_NEWWIFIKEY_LEN);
	TmpWifiKey[ZPS_REF_MSINFO_MAX_NEWWIFIKEY_LEN] = '\0';
	//zOss_ASSERT(retCode!=ZOSS_ERROR); 
    if(CPNV_ERROR == retCode)
    {
         at_print(AT_ERR,"cpnv_NvItemRead wifikey fail !\n");
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
         return AT_END; 
    }
    //strcpy(TmpWifiKey, (const char*)cfg_get("zwifikey"));

    *res_msg = at_query_result_build("WIFIKEY",TmpWifiKey);
    *res_msglen = strlen(*res_msg);

    return AT_END;
}

/**************************************************************************
* : wifikeyWrite_act_func
* : дWIFI KEYֵ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int wifikeyWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    char *at_str = NULL;
    //char *pStrValue = NULL;
    unsigned long retCode = CPNV_ERROR;

    //zOss_ASSERT(at_paras!=NULL);
    at_str = at_paras;  
    if(strlen(at_str)> ZPS_REF_MSINFO_MAX_NEWWIFIKEY_LEN)
    {       
        *res_msg = at_err_build(ATERR_PARAM_INVALID);       
        *res_msglen = strlen(*res_msg);     
        return AT_END;
    }

    retCode = cpnv_NvItemWrite(ZPS_REF_MSINFO_NEWWIFIKEY_BASE_ADDR, (unsigned char *)at_str, strlen(at_str));
    //sc_cfg_set("zwifikey",at_str);
    
    if (retCode == CPNV_OK)
    {
        retCode = cpnv_NvramFlush();

        if (retCode == CPNV_OK)
        {
            *res_msg = at_query_result_build("WIFIKEY",at_str);
        }
        else
        {
            *res_msg = at_err_build(ATERR_PROC_FAILED);
        }
       
    }
    else
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);
    }

    *res_msglen = strlen(*res_msg);
    return AT_END;
}

/**************************************************************************
* : rj45MacAddrRead_act_func
* : MACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: NVMACַΪBCD룬ҪתASCII
**************************************************************************/
int rj45MacAddrRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned long   retCode = CPNV_ERROR;
    char            TmpMacAddr[OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE] = {0};
    char            str[13];
    long            abMacindex = 0;
    static char     macstr[2 * OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE - 1] = {0};
    
    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_ETHMAC_ADDRESS, (unsigned char *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE);
    at_print(AT_DEBUG,"retCode = %d\r\n",retCode );
    if(CPNV_ERROR == retCode )
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg); 
        return AT_END;  
    }

    /* MACַתBCDתΪAscii  */
    memset(str, 0, 13);

    for (abMacindex = 0; abMacindex< 12; abMacindex += 2)
    {
        str[abMacindex] = ((TmpMacAddr[abMacindex/2]) >> 4) & 0x0F;
        str[abMacindex+1] = TmpMacAddr[abMacindex/2] & 0x0F;

        macstr[abMacindex] = BCD2Ascii(str[abMacindex]);
        macstr[abMacindex+1] = BCD2Ascii(str[abMacindex+1]);
    }

    /* MACַת*/
    *res_msg = at_query_result_build("ETHMAC",macstr);
    *res_msglen = strlen(*res_msg);

    return AT_END;
}

/**************************************************************************
* : rj45MacAddWrite_act_func
* : дMACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: NVMACַΪBCD룬ҪתASCII
**************************************************************************/
int rj45MacAddWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    //long retCode = CPNV_ERROR;
    char *at_str = NULL; 

    //zOss_ASSERT(at_paras!=NULL);
    at_str = at_paras;  

    if (strlen(at_str)!= DC_MacLen)
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
    }
    else
    {
        if (-1 == DC_WriteRJ45MacAddr((char *)at_str))
        {                
            *res_msg = at_err_build(ATERR_PROC_FAILED);
        }
        else
        {
            *res_msg = at_query_result_build("ETHMAC",at_str);
        }
    }   
    
    *res_msglen = strlen(*res_msg);

    return AT_END;
}

/**************************************************************************
* : mac2Read_act_func
* : MACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: NVMACַΪBCD룬ҪתASCII
**************************************************************************/
int mac2Read_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned long   retCode = CPNV_ERROR;
    char            TmpMacAddr[OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE] = {0};//imeiֵ
    char            str[13];
    long            abMacindex = 0;
    static char     macstr[2 * OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE - 1] = {0};

    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_WIFIMAC2_ADDRESS, (UINT8 *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE);
    
    if (CPNV_ERROR == retCode )
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
        return AT_END;
    }

    /* MACַתBCDתΪAscii  */
    memset(str, 0, 13);

    for (abMacindex = 0; abMacindex< 12; abMacindex += 2)
    {
        str[abMacindex] = ((TmpMacAddr[abMacindex/2]) >> 4) & 0x0F;
        str[abMacindex+1] = TmpMacAddr[abMacindex/2] & 0x0F;

        macstr[abMacindex] = BCD2Ascii(str[abMacindex]);
        macstr[abMacindex+1] = BCD2Ascii(str[abMacindex+1]);
    }

    /* MACַת*/
    *res_msg = at_query_result_build("MAC2",macstr);
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

/**************************************************************************
* : mac2Write_act_func
* : дMACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int mac2Write_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    //long     retCode = CPNV_ERROR;
    char     *at_str = NULL; 

    //zOss_ASSERT(at_paras!=NULL);
    at_str = at_paras;  

    if (strlen(at_str)!= DC_MacLen)
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
    }
    else
    {
        if (-1 == DC_WriteMac2Addr((char *)at_str))
        {                
            *res_msg = at_err_build(ATERR_PROC_FAILED);
        }
        else
        {
            *res_msg = at_query_result_build("MAC2",at_str);
        }
    }   
    
    *res_msglen = strlen(*res_msg);

    return AT_END;
}

/**************************************************************************
* : usbmacRead_act_func
* : USB MACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: NVMACַΪBCD룬ҪתASCII
**************************************************************************/
int usbmacRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned long   retCode = CPNV_ERROR;
    char            TmpMacAddr[OS_FLASH_AMT_COMM_RO_USBMAC_SIZE] = {0};//imeiֵ
    char            str[13];
    long            abMacindex = 0;
    static char     macstr[2 * OS_FLASH_AMT_COMM_RO_USBMAC_SIZE - 1] = {0};

    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_USBMAC_ADDRESS, (UINT8 *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_USBMAC_SIZE);
    
    if (CPNV_ERROR == retCode )
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
        return AT_END;
    }

    /* MACַתBCDתΪAscii  */
    memset(str, 0, 13);

    for (abMacindex = 0; abMacindex< 12; abMacindex += 2)
    {
        str[abMacindex] = ((TmpMacAddr[abMacindex/2]) >> 4) & 0x0F;
        str[abMacindex+1] = TmpMacAddr[abMacindex/2] & 0x0F;

        macstr[abMacindex] = BCD2Ascii(str[abMacindex]);
        macstr[abMacindex+1] = BCD2Ascii(str[abMacindex+1]);
    }

    /* MACַת*/
    *res_msg = at_query_result_build("USBMAC",macstr);
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

/**************************************************************************
* : usbmacWrite_act_func
* : дUSB MACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int usbmacWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    //long retCode = CPNV_ERROR;
    char *at_str = NULL; 

    //zOss_ASSERT(at_paras!=NULL);
    at_str = at_paras;  

    if (strlen(at_str)!= DC_MacLen)
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
    }
    else
    {
        if (-1 == DC_WriteUSBMacAddr((char *)at_str))
        {                
            *res_msg = at_err_build(ATERR_PROC_FAILED);
        }
        else
        {
            *res_msg = at_query_result_build("USBMAC",at_str);
        }
    }   
    
    *res_msglen = strlen(*res_msg);

    return AT_END;

}

/**************************************************************************
* : gmacRead_act_func
* : GMACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: NVMACַΪBCD룬ҪתASCII
**************************************************************************/

int gmacRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned long   retCode = CPNV_ERROR;
    char            TmpMacAddr[OS_FLASH_AMT_COMM_RO_GMAC_SIZE] = {0};//imeiֵ
    char            str[13];
    long            abMacindex = 0;
    static char     macstr[2 * OS_FLASH_AMT_COMM_RO_GMAC_SIZE - 1] = {0};

    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_GMAC_ADDRESS, (UINT8 *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_GMAC_SIZE);
    
    if (CPNV_ERROR == retCode )
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);     
        return AT_END;
    }

    /* MACַתBCDתΪAscii  */
    memset(str, 0, 13);

    for (abMacindex = 0; abMacindex< 12; abMacindex += 2)
    {
        str[abMacindex] = ((TmpMacAddr[abMacindex/2]) >> 4) & 0x0F;
        str[abMacindex+1] = TmpMacAddr[abMacindex/2] & 0x0F;

        macstr[abMacindex] = BCD2Ascii(str[abMacindex]);
        macstr[abMacindex+1] = BCD2Ascii(str[abMacindex+1]);
    }

    /* MACַת*/
    *res_msg = at_query_result_build("GMAC",macstr);
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

/**************************************************************************
* : gmacWrite_act_func
* : дGMACַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int gmacWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    //long retCode = CPNV_ERROR;
    char *at_str = NULL; 

    //zOss_ASSERT(at_paras!=NULL);
    at_str = at_paras;  

    if (strlen(at_str)!= DC_MacLen)
    {
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
    }
    else
    {
        if (-1 == DC_WriteGmacAddr((char *)at_str))
        {                
            *res_msg = at_err_build(ATERR_PROC_FAILED);
        }
        else
        {
            *res_msg = at_query_result_build("GMAC",at_str);
        }
    }   
    
    *res_msglen = strlen(*res_msg);

    return AT_END;
   
}

/**************************************************************************
* : batdetRead_act_func
* : ȡBATDETֵ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int batdetRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode        = CPNV_ERROR;
    char TmpBatdet[32]  = {0};
    int  nv_value       =  0;
        
    retCode = cpnv_NvItemRead(DRV_PERI_NV_ADDR, (unsigned char *)&nv_value, 1);
    
    at_print(AT_DEBUG, "batdetRead_act_func:nv_value = %d\n", nv_value);
    
    snprintf((char *)TmpBatdet, 32, "%d", nv_value);
	if(retCode != CPNV_ERROR)
	{
    	*res_msg = at_query_result_build("BATDET", TmpBatdet);
    	*res_msglen = strlen(*res_msg);
	}
	else
	{
		*res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);
	}
    return AT_END;
}

/**************************************************************************
* : batdetWrite_act_func
* : дBATDETֵ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵:
**************************************************************************/
int batdetWrite_act_func(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
	char          *at_str         = NULL;
    //char          *pStrValue      = NULL;
    //char           TmpBatdet[32]  = {0};
    unsigned long  retCode        = CPNV_ERROR;
    int            nv_value       = -1;
        
    at_str = at_paras;  
    at_print(AT_DEBUG, "batdetWrite_act_func:at_str = %s\n", at_str);
             
    get_at_cmd_param_int(at_str, &nv_value, (const char **)&at_str);
         
    at_print(AT_DEBUG,"batdetWrite_act_func:at_str = %s\n", at_str);
    at_print(AT_DEBUG,"batdetWrite_act_func:nv_value = %d\n", nv_value);
         
    if(!(0 == nv_value || 1 == nv_value)) // szLanEnableֻ01ֵ
    {
    	*res_msg = at_err_build(ATERR_PARAM_INVALID);
        *res_msglen = strlen(*res_msg);
        return AT_END;
    }
    
    retCode =amt_set_batdet_flag(nv_value);   
    
    if (retCode == CPNV_OK)
    {
    	if(nv_value == 1)
        {
        	*res_msg = at_query_result_build("BATDET","1");
        }
        else
        {
            *res_msg = at_query_result_build("BATDET","0");
        }
	}
    else
    {
    	*res_msg = at_err_build(ATERR_PROC_FAILED);
    }
                
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

int msnRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode = CPNV_ERROR;
    char TmpMSN[MSN_MAX_NVINFO_LEN+1]= {0};
     
    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_MSerialNum_ADDRESS, (UINT8 *)TmpMSN, MSN_MAX_NVINFO_LEN);
	TmpMSN[MSN_MAX_NVINFO_LEN] = '\0';
    if(retCode != CPNV_ERROR)
    {
        *res_msg = at_query_result_build("MSN",TmpMSN);
        *res_msglen = strlen(*res_msg);
    }
    else
    {   
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);
    }
    return AT_END;
}

int msnWrite_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode = CPNV_ERROR;
    char *at_str = NULL; 

    if(NULL !=at_paras)
    {
        at_str = at_paras; 
        at_print(AT_DEBUG,"msnWrite_act_func = %s.\n", at_str);
        if((strlen(at_str) >= 12) && (strlen(at_str) <= 20))
        {
            retCode = amt_nvro_write(OS_FLASH_AMT_COMM_RO_MSerialNum_ADDRESS, MSN_MAX_NVINFO_LEN, (unsigned char *)at_str);
            if(retCode != CPNV_ERROR)
            {
                *res_msg = at_ok_build();
                *res_msglen = strlen(*res_msg);
                return AT_END;
            }
        }
    }
    *res_msg = at_err_build(ATERR_PROC_FAILED);
    *res_msglen = strlen(*res_msg);
    return AT_END;
    
}

int testInfoRead_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    unsigned int retCode = CPNV_ERROR;
    char TmpTestInfo[MSINFO_MAX_NVINFO_LEN+1] = {0};
     
    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_TestInfo_ADDRESS, (UINT8 *)TmpTestInfo, MSINFO_MAX_NVINFO_LEN);
	TmpTestInfo[MSINFO_MAX_NVINFO_LEN] = '\0';
    if(retCode != CPNV_ERROR)
    {
        *res_msg = at_query_result_build("RTESTINFO",TmpTestInfo);
        *res_msglen = strlen(*res_msg);
    }
    else
    {   
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);
    }
    return AT_END;
}

int closeAutoInd_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    if('1' == at_paras[0])
    {
        at_context_chn_info_mod("none");
        *res_msg = at_ok_build();
        *res_msglen = strlen(*res_msg);
    }
    else
    {   
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);
    }
    return AT_END;
}



int zphone_mode_query_req_act(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    UINT32  retCode = CPNV_ERROR;
    UINT8   TmpPhoneMode = 0;
    char *pPtr = NULL;

    pPtr = malloc(256);
    if(pPtr == NULL)
	{
		softap_assert("");
		return AT_END;
	}
    memset(pPtr, 0x00, 256);
    
    retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR, &TmpPhoneMode, sizeof(UINT8));
    if(retCode == CPNV_ERROR){softap_assert("");}

    if( 1 == (TmpPhoneMode & 0x1)) //һλ1  modem汾
    {
        snprintf((char *)pPtr, 64,"\r\n+PHONEMODE: %d", 0);
    }
    else if (0 == (TmpPhoneMode & 0x1)) //һλ 0 汾
    {
        snprintf((char *)pPtr, 64,"\r\n+PHONEMODE: %d", 1);  
    }

    strcat((char *)pPtr,"\r\n\r\nOK\r\n");
    

    *res_msg = pPtr;
    *res_msglen = strlen(pPtr);
    
    return AT_END;
}

int zphone_mode_set_req_act(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    UINT8 phoneModeStatus = 0;
    UINT32 retCode = CPNV_ERROR;

    retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR,&phoneModeStatus,sizeof(UINT8));
	if(retCode == CPNV_ERROR)
	{
	    softap_assert("");
	}

    //汾
    if('1' == at_paras[0])
    {
        phoneModeStatus = (0xfe & phoneModeStatus);    // һλ0ʾ汾
        sc_cfg_set("version_mode","0");
    }
    //modem汾
    else if('0' == at_paras[0])
    {
        phoneModeStatus = (0x1 | phoneModeStatus);   // һλ1ʾǴmodem汾
        sc_cfg_set("version_mode","1");                 //version_mode==1 phonemode==0 Ϊmodem汾
    }
    else
    {       
        *res_msg = at_err_build(ATERR_PARAM_INVALID);
        *res_msglen = strlen(*res_msg);
        return AT_END;
    }
    retCode = cpnv_NvItemWrite(ZPS_REF_MSINFO_VERSIONMODE_BASE_ADDR,&phoneModeStatus,sizeof(UINT8));
    if(retCode == CPNV_ERROR){softap_assert("");}
    retCode = cpnv_NvramFlush();
    if(retCode == CPNV_ERROR){softap_assert("");}

    *res_msg = at_ok_build();   
    *res_msglen = strlen(*res_msg);
    return AT_END;    
}

/**************************************************************************
* : zsoftreset_act_func
* : 
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: 
**************************************************************************/
int zsoftreset_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    //char *pPtr = NULL; 
    
    //zOss_SysSoftReset(SYS_RESET_TO_NORMAL);  
    ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_MAIN_CTRL, MSG_CMD_RESTART_REQUEST, 0, NULL,0);

    *res_msg = at_query_result_build("ZSOFTRESET", "");
    *res_msglen = strlen(*res_msg);
    
    return AT_END;  
}

int ext_ramdump_func(char *at_paras, void ** res_msg)
{
    assert(0);
    return AT_END;
}

int zmodeSet_act_func_check_mode(char *at_paras, void ** res_msg, int *res_msglen)
{
    int   iUsbMode = -1;
    char* at_str = NULL;
    
    
    if(at_paras==NULL)
        softap_assert("zmodeSet_act_func:at_paras is null");
    
    at_str = at_paras;
    get_at_cmd_param_int(at_str, &iUsbMode, (const char **)&at_str);
    at_print(AT_DEBUG,"zmodeSet_act_func:iUsbMode == %d\n", iUsbMode);
    
	char strCfgGetItem[AT_CMD_MAX] = {0};
	nv_get_item(NV_RO, "usb_modetype", strCfgGetItem, sizeof(strCfgGetItem));
    at_print(AT_ERR,"current usb mode type = %s\n", strCfgGetItem); 

    //ûģʽеûģʽҪȨ
/*	if((strcmp(strCfgGetItem,"user")== 0)&&(iUsbMode != 0))
	{
	 	if(auth_device_key_result != 1 && auth_device_key_init_value() != 1)
	    {
	    	at_print(AT_ERR,"auth_device_key_result=%d,device key verify fail!\n", auth_device_key_result);
	        *res_msg = at_err_build(ATERR_NOT_ALLOWED);
            *res_msglen = strlen(*res_msg);

			iUsbMode = -1;
	    }
	}*/

	return iUsbMode;
}


int zmodeSet_act_func(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
    int   iUsbMode = 0;
    UINT8 bootmode[] = {0x54,0x4D};
    long  retCode = -1;

    at_print(AT_DEBUG,"ext_amt_func.c:zmodeSet_act_func\n");

	iUsbMode = zmodeSet_act_func_check_mode(at_paras, res_msg, res_msglen);
	if(iUsbMode < 0)
	{
		return AT_END;
	}

    switch(iUsbMode)
    {
        case 0: //user mode
        {   
            nv_set_item(NV_RO, "usb_modetype", "user", 1);
            bootmode[1] =0x00;
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        case 1://debug mode
        {
            nv_set_item(NV_RO, "usb_modetype", "debug", 1);
            bootmode[1] =0x01;
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        case 2://factory mode
        {
            nv_set_item(NV_RO, "usb_modetype", "factory", 1);
            bootmode[1] =0x02;
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        case 3://amt mode
        {
            //nv_set_item(NV_RO, "usb_modetype", "amt", 1);
            retCode = amt_set_bootmode(bootmode);
            break;
        }
        default:
        {
            *res_msg = at_err_build(ATERR_PARAM_INVALID);
            *res_msglen = strlen(*res_msg);
            return AT_END;
        }
    }

    nv_commit(NV_RO);
#ifdef USE_CAP_SUPPORT	
    if((iUsbMode>= 0) && (iUsbMode<= 3)){
		iUsbMode += 3;
		ipc_send_message2(MODULE_ID_HOTPLUG, MODULE_ID_USBHOTPLUG, MSG_CMD_DRV_USB_CHANGE, 
			sizeof(iUsbMode), &iUsbMode, 0);
    }
#endif	
    at_print(AT_DEBUG,"zmodeSet_act_func:retCode == %d\n", retCode);
    if (retCode == 0)
    {
        *res_msg = at_ok_build();   
    }
    else
    {       
        *res_msg = at_err_build(ATERR_PROC_FAILED); 
    }  
    *res_msglen = strlen(*res_msg);
    return AT_END;
}


#define SHA256_ROTL(a,b) (((a>>(32-b))&(0x7fffffff>>(31-b)))|(a<<b))
#define SHA256_SR(a,b) ((a>>b)&(0x7fffffff>>(b-1)))
#define SHA256_Ch(x,y,z) ((x&y)^((~x)&z))
#define SHA256_Maj(x,y,z) ((x&y)^(x&z)^(y&z))
#define SHA256_E0(x) (SHA256_ROTL(x,30)^SHA256_ROTL(x,19)^SHA256_ROTL(x,10))
#define SHA256_E1(x) (SHA256_ROTL(x,26)^SHA256_ROTL(x,21)^SHA256_ROTL(x,7))
#define SHA256_O0(x) (SHA256_ROTL(x,25)^SHA256_ROTL(x,14)^SHA256_SR(x,3))
#define SHA256_O1(x) (SHA256_ROTL(x,15)^SHA256_ROTL(x,13)^SHA256_SR(x,10))


/**
 * @brief SHA-256
 * @param[in,out] str     ҪSHA-256 hashֵָ
 * @param[in,out] length  
 * @param[in,out] sha256  ڱSHA-256ָ
 * @return ɹsha256ʧܷ0
 * @note
 * @see 
 */

unsigned char* StrSHA256(const unsigned char* str, long long length, unsigned char* sha256)
{
    /*
    ַSHA-256
    ˵
    str         ַָ
    length      ַ
    sha256         ڱSHA-256ַָ
    ֵΪsha256
    */
    unsigned char *pp, *ppend;
    long l, i, W[64], T1, T2, A, B, C, D, E, F, G, H, H0, H1, H2, H3, H4, H5, H6, H7;
    H0 = 0x6a09e667, H1 = 0xbb67ae85, H2 = 0x3c6ef372, H3 = 0xa54ff53a;
    H4 = 0x510e527f, H5 = 0x9b05688c, H6 = 0x1f83d9ab, H7 = 0x5be0cd19;
    long K[64] = {
        0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
        0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
        0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
        0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
        0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
        0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
        0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
        0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2,
    };
    l = length + ((length % 64 >= 56) ? (128 - length % 64) : (64 - length % 64));
    if (!(pp = (unsigned char*)malloc((unsigned long)l))) return 0;
    for (i = 0; i < length; pp[i + 3 - 2 * (i % 4)] = str[i], i++);
    for (pp[i + 3 - 2 * (i % 4)] = 128, i++; i < l; pp[i + 3 - 2 * (i % 4)] = 0, i++);
    *((long*)(pp + l - 4)) = length << 3;
    *((long*)(pp + l - 8)) = length >> 29;
    for (ppend = pp + l; pp < ppend; pp += 64){
        for (i = 0; i < 16; W[i] = ((long*)pp)[i], i++);
        for (i = 16; i < 64; W[i] = (SHA256_O1(W[i - 2]) + W[i - 7] + SHA256_O0(W[i - 15]) + W[i - 16]), i++);
        A = H0, B = H1, C = H2, D = H3, E = H4, F = H5, G = H6, H = H7;
        for (i = 0; i < 64; i++){
            T1 = H + SHA256_E1(E) + SHA256_Ch(E, F, G) + K[i] + W[i];
            T2 = SHA256_E0(A) + SHA256_Maj(A, B, C);
            H = G, G = F, F = E, E = D + T1, D = C, C = B, B = A, A = T1 + T2;
        }
        H0 += A, H1 += B, H2 += C, H3 += D, H4 += E, H5 += F, H6 += G, H7 += H;
    }
    free(pp - l);
    memcpy(sha256,&H0,sizeof(H0));
	memcpy(sha256 + sizeof(H0),&H1,sizeof(H1));
	memcpy(sha256 + sizeof(H0) + sizeof(H1),&H2,sizeof(H2));
	memcpy(sha256 + sizeof(H0) + sizeof(H1) + sizeof(H2),&H3,sizeof(H3));
	memcpy(sha256 + sizeof(H0) + sizeof(H1) + sizeof(H2) + sizeof(H3),&H4,sizeof(H4));
	memcpy(sha256 + sizeof(H0) + sizeof(H1) + sizeof(H2) + sizeof(H3) + sizeof(H4),&H5,sizeof(H5));
	memcpy(sha256 + sizeof(H0) + sizeof(H1) + sizeof(H2) + sizeof(H3) + sizeof(H4) + sizeof(H5),&H6,sizeof(H6));
	memcpy(sha256 + sizeof(H0) + sizeof(H1) + sizeof(H2) + sizeof(H3) + sizeof(H4) + sizeof(H5) + sizeof(H6),&H7,sizeof(H7));
    return sha256;
}

static int IsEnhancedSecurity()
{
    #define CMDLINE_MAX_SIZE   (4*1024)
    int cmdline_fd = -1;
	char*cmdline_buf = malloc(CMDLINE_MAX_SIZE);
	char*temp = NULL;
	int ret_size = 0;
	if(cmdline_buf == NULL)
	{
	    at_print(AT_ERR,"malloc cmdline_buf fail.\n");
		return -1;
	}
	memset(cmdline_buf,0,CMDLINE_MAX_SIZE);
    //cmdlineеEnhancedSecurityǷ
	cmdline_fd = open("/proc/cmdline", O_RDONLY);
	if (cmdline_fd < 0) {
		at_print(AT_ERR,"open %s fail.\n","/proc/cmdline");
		free(cmdline_buf);
		return -1;
	}
	ret_size = read(cmdline_fd, cmdline_buf, CMDLINE_MAX_SIZE - 1);
	if(ret_size <= 0)
	{
		at_print(AT_ERR,"read /proc/cmdline fail.\n");
		close(cmdline_fd);
		free(cmdline_buf);
		return -1;
	}
	close(cmdline_fd);
    temp = strstr(cmdline_buf,"EnhancedSecurity=");
	if(temp == NULL)
	{
    	at_print(AT_ERR,"can not find EnhancedSecurity=\n");
		free(cmdline_buf);
		return -1;
	}
	temp = temp + strlen("EnhancedSecurity=");
	if(temp == NULL)
	{
    	at_print(AT_ERR,"temp = NULL\n");
		free(cmdline_buf);
		return -1;
	}
	if(*temp == '0')
	{
	    free(cmdline_buf);
		return 0;
	}
	else if(*temp == '1')
	{
	    at_print(AT_ERR,"EnhancedSecurity=1\n");
		free(cmdline_buf);
		return 1;
	}
	else
	{
	    free(cmdline_buf);
		return -1;
	}
}


int write_security_info(int at_fd, char *at_paras, void **res_msg, int *res_msglen)
{
    UINT32 pubKeyHash[4] = {0};
    UINT32 secureFlag = 0xFF;
    T_ZDrvEfuse_Secure efuseInfo = {{0}};
    char strValue[16];
    char strLog[256] = {0};
    md5_ctx stStc;
    int i;
	int efuse_fd = -1;

	UINT32 pubKeyHash_otp[8] = {0};
	UINT32 secureFlag_otp = 0x00;
	T_ZDrvOtp_Secure otpInfo = {{0}};
	int otp_fd = -1;
	int is_Enhanced_Security = -1;

	is_Enhanced_Security = IsEnhancedSecurity();
	at_print(AT_ERR,"is_Enhanced_Security = %d.\n",is_Enhanced_Security);
	if(is_Enhanced_Security == -1)
	{
		at_print(AT_ERR,"IsEnhancedSecurity() fail.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
   
    /*************************ȡԿhash**************************/
    // ȡԿ
	efuse_fd = open("/dev/efuse", O_RDWR);
	if (efuse_fd < 0) {
		at_print(AT_ERR,"open %s fail.\n","/dev/efuse");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

	at_print(AT_ERR,"open %s success.\n","/dev/efuse");

	if(ioctl(efuse_fd , EFUSE_GET_DATA, &efuseInfo)!= 0)
	{
	    at_print(AT_ERR,"ioctl: EFUSE_GET_DATA fail.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		close(efuse_fd);
		return AT_END;
	}
	at_print(AT_ERR, "security flag in efuse: %08X\n", efuseInfo.secureFlag);

	//жefuseĹԿǷϷȫ0ֱ˳
	for (i = 0; i < sizeof(efuseInfo.pubKeyRsaE)/sizeof(UINT32); i++)
    {
    	if(efuseInfo.pubKeyRsaE[i] != 0)
    	{
    		break;
		}
	}
	if(i == sizeof(efuseInfo.pubKeyRsaE)/sizeof(UINT32))
	{
		at_print(AT_ERR,"efuse pubkey E is all zero.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		close(efuse_fd);
		return AT_END;
	}

	for (i = 0; i < sizeof(efuseInfo.pubKeyRsaN)/sizeof(UINT32); i++)
    {
    	if(efuseInfo.pubKeyRsaN[i] != 0)
    	{
    		break;
		}
	}
	if(i == sizeof(efuseInfo.pubKeyRsaN)/sizeof(UINT32))
	{
		at_print(AT_ERR,"efuse pubkey N is all zero.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		close(efuse_fd);
		return AT_END;
	}


	   // ӡԿ
		#if 0
		strLog[0] = '\0';
		for (i = 0; i < 16; i++)
		{
			sprintf(strValue, "%08lX", efuseInfo.pubKeyRsaE[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "efuse Pubkey E1: %s\n", strLog);

		memset(strLog, 0, sizeof(strLog));
		for (i = 16; i < 32; i++)
		{
			sprintf(strValue, "%08lX", efuseInfo.pubKeyRsaE[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "efuse Pubkey E2: %s\n", strLog);
		
        memset(strLog, 0, sizeof(strLog));
	    for (i = 0; i < 16; i++)
		{
			sprintf(strValue, "%08lX", efuseInfo.pubKeyRsaN[i]);
			strcat(strLog, strValue);
		}
	
		at_print(AT_ERR, "efuse Pubkey N1: %s\n", strLog);
	
		memset(strLog, 0, sizeof(strLog));
		for (i = 16; i < 32; i++)
		{
			sprintf(strValue, "%08lX", efuseInfo.pubKeyRsaN[i]);
			strcat(strLog, strValue);
		}
	
		at_print(AT_ERR, "efuse Pubkey N2: %s\n", strLog);
		#endif
	
	
    // 㹫Կhashֵ
    md5_init(&stStc);
    md5_update(&stStc, (unsigned char *)efuseInfo.pubKeyRsaE, sizeof(efuseInfo.pubKeyRsaE));
    md5_update(&stStc, (unsigned char *)efuseInfo.pubKeyRsaN, sizeof(efuseInfo.pubKeyRsaN));
    md5_final((UINT8 *)pubKeyHash, &stStc);

    // ӡԿhash
    strLog[0] = '\0';
    for (i = 0; i < sizeof(pubKeyHash)/sizeof(UINT32); i++)
    {
        pubKeyHash[i] = ((pubKeyHash[i] & 0xff000000) >> 24)
                        | ((pubKeyHash[i] & 0x00ff0000) >>	8)
                        | ((pubKeyHash[i] & 0x0000ff00) <<	8)
                        | ((pubKeyHash[i] & 0x000000ff) << 24) ;

        sprintf(strValue, "%08lX", pubKeyHash[i]);
        strcat(strLog, strValue);
    }

    at_print(AT_ERR, "efuse Public key hash: %s\n", strLog);
	
	/*************************ȫϢдefuse**************************/
	if (memcmp(efuseInfo.pubKeyHash, pubKeyHash, sizeof(pubKeyHash)) != 0)
	{
		// Կhashֵдefuse
		if (ioctl(efuse_fd , EFUSE_SET_PUB_KEY_HASH, pubKeyHash) != 0)
		{
	    	at_print(AT_ERR, "Write public key hash to efuse fail!\n");
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			*res_msglen = strlen(*res_msg);
			close(efuse_fd);
			return AT_END;
		}
		else
		{
			at_print(AT_ERR, "Write public key hash to efuse success!\n");
		}
    }
	else
	{
		at_print(AT_ERR, "efuse Public key's hash value already exists!\n");
	}

    /*************************ждĹԿhashֵǷȷ**************************/
	// efuseȡ
    memset(&efuseInfo, 0, sizeof(efuseInfo));
    if(ioctl(efuse_fd , EFUSE_GET_DATA, &efuseInfo)!= 0)
    {
        at_print(AT_ERR,"ioctl: EFUSE_GET_DATA fail.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		close(efuse_fd);
		return AT_END;
    }
	if (memcmp(efuseInfo.pubKeyHash, pubKeyHash, sizeof(pubKeyHash)) != 0)
    {
        at_print(AT_ERR, "efuse Public key hash is not consistent!\n");
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);
		close(efuse_fd);
        return AT_END;
    }
	
	if(is_Enhanced_Security == 1)
	{
		/*************************ȡԿhash**************************/
	    // ȡԿ
		otp_fd = open("/dev/otp", O_RDWR);
		if (otp_fd < 0) {
			at_print(AT_ERR,"open %s fail.\n","/dev/otp");
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			*res_msglen = strlen(*res_msg);
			close(efuse_fd);
			return AT_END;
		}
		at_print(AT_ERR,"open %s success.\n","/dev/otp");

		if(ioctl(otp_fd , OTP_GET_DATA, &otpInfo)!= 0)
		{
		    at_print(AT_ERR,"ioctl: OTP_GET_DATA fail.\n");
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			*res_msglen = strlen(*res_msg);
			close(otp_fd);
			close(efuse_fd);
			return AT_END;
		}
	
		at_print(AT_ERR, "security flag in otp: %08X\n", otpInfo.secureFlag);

		// ӡԿ
		#if 0
		strLog[0] = '\0';
		for (i = 0; i < 16; i++)
		{
			sprintf(strValue, "%08lX", otpInfo.pubKey[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "OTP Public key1: %s\n", strLog);

		memset(strLog, 0, sizeof(strLog));
		for (i = 16; i < 32; i++)
		{
			sprintf(strValue, "%08lX", otpInfo.pubKey[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "OTP Public key2: %s\n", strLog);

		memset(strLog, 0, sizeof(strLog));
		for (i = 32; i < 48; i++)
		{
			sprintf(strValue, "%08lX", otpInfo.pubKey[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "OTP Public key3: %s\n", strLog);

		memset(strLog, 0, sizeof(strLog));
		for (i = 48; i < 64; i++)
		{
			sprintf(strValue, "%08lX", otpInfo.pubKey[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "OTP Public key4: %s\n", strLog);

		memset(strLog, 0, sizeof(strLog));
		for (i = 64; i < 80; i++)
		{
			sprintf(strValue, "%08lX", otpInfo.pubKey[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "OTP Public key5: %s\n", strLog);

		memset(strLog, 0, sizeof(strLog));
		for (i = 80; i < sizeof(otpInfo.pubKey)/sizeof(UINT32); i++)
		{
			sprintf(strValue, "%08lX", otpInfo.pubKey[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "OTP Public key6: %s\n", strLog);
		#endif
		//㹫Կhashֵ
	    StrSHA256((const unsigned char*)otpInfo.pubKey, sizeof(otpInfo.pubKey), (unsigned char*)pubKeyHash_otp);
	    // ӡԿhash
		memset(strLog, 0, sizeof(strLog));
		for (i = 0; i < sizeof(pubKeyHash_otp)/sizeof(UINT32); i++)
		{
			sprintf(strValue, "%08lX", pubKeyHash_otp[i]);
			strcat(strLog, strValue);
		}

		at_print(AT_ERR, "OTP Public key hash: %s\n", strLog);

		/*************************ȫϢдotp**************************/
		
		if (memcmp(otpInfo.pubKeyHash, pubKeyHash_otp, sizeof(pubKeyHash_otp)) != 0)
		{
			// Կhashֵдotp
			if (ioctl(otp_fd , OTP_SET_PUB_KEY_HASH, pubKeyHash_otp) != 0)
			{
		    	at_print(AT_ERR, "Write public key hash to otp fail!\n");
				*res_msg = at_err_build(ATERR_PROC_FAILED);
				*res_msglen = strlen(*res_msg);
				close(otp_fd);
				close(efuse_fd);
				return AT_END;
			}
			else
			{
				at_print(AT_ERR, "Write public key hash to otp success!\n");
			}
	    }
		else
		{
			at_print(AT_ERR, "Public key's hash value in otp already exists!\n");
		}

		/*************************ждĹԿhashֵǷȷ**************************/
	    // otpȡ
		memset(&otpInfo, 0, sizeof(otpInfo));
	    if(ioctl(otp_fd , OTP_GET_DATA, &otpInfo)!= 0)
		{
			at_print(AT_ERR,"ioctl: OTP_GET_DATA fail.\n");
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			*res_msglen = strlen(*res_msg);
			close(otp_fd);
			close(efuse_fd);
			return AT_END;
		}
		 //֤ǰ湫Կhashֵдɹˣд밲ȫboot flag
		if (memcmp(otpInfo.pubKeyHash, pubKeyHash_otp, sizeof(pubKeyHash_otp)) != 0)
	    {
	        at_print(AT_ERR, "Public key hash in otp is not consistent!\n");
	        *res_msg = at_err_build(ATERR_PROC_FAILED);
	        *res_msglen = strlen(*res_msg);
			close(otp_fd);
			close(efuse_fd);
	        return AT_END;
	    }
		
		/*otpInfo.secureFlagһֽǰȫʹܱ־*/
		
	    if ((otpInfo.secureFlag&0xff) != secureFlag_otp)
	    {
	        // ʹܱʶλдotp
	        if (ioctl(otp_fd , OTP_SET_SECURE_EN, &secureFlag_otp) != 0)
	        {
	            at_print(AT_ERR, "Write security flag to otp fail!\n");
	            *res_msg = at_err_build(ATERR_PROC_FAILED);
	            *res_msglen = strlen(*res_msg);
				close(otp_fd);
				close(efuse_fd);
	            return AT_END;
	        }
	        else
	        {
	            at_print(AT_ERR, "Write security flag to otp success!\n");
	        }
	    }
		else
	    {
	        at_print(AT_ERR, "Secure flag in otp already exists!\n");
	    }
		
	    /*************************ждsecure flagǷȷ**************************/
	    // otpȡ
	    memset(&otpInfo, 0, sizeof(otpInfo));
	    if(ioctl(otp_fd , OTP_GET_DATA, &otpInfo)!= 0)
	    {
	        at_print(AT_ERR,"ioctl: OTP_GET_DATA fail.\n");
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			*res_msglen = strlen(*res_msg);
			close(otp_fd);
			close(efuse_fd);
			return AT_END;
	    }

		close(otp_fd);

		if ((otpInfo.secureFlag&0xff) != secureFlag_otp)
	    {
	        at_print(AT_ERR, "Security flag(%#08X) in otp is not consistent!\n", otpInfo.secureFlag);
	        *res_msg = at_err_build(ATERR_PROC_FAILED);
	        *res_msglen = strlen(*res_msg);
			close(efuse_fd);
		    return AT_END;
	    }
	}
	
	//дefuseȫflag
    /*efuseInfo.secureFlagǰ3ֽchip flag,һֽǰȫʹܱ־*/
	
    if ((efuseInfo.secureFlag&0xff) != secureFlag)
    {
        // ʹܱʶλдefuse
        if (ioctl(efuse_fd , EFUSE_SET_SECURE_EN, &secureFlag) != 0)
        {
            at_print(AT_ERR, "Write security flag to efuse fail!\n");
            *res_msg = at_err_build(ATERR_PROC_FAILED);
            *res_msglen = strlen(*res_msg);
			close(efuse_fd);
            return AT_END;
        }
        else
        {
            at_print(AT_ERR, "Write security flag to efuse success!\n");
        }
    }
    else
    {
        at_print(AT_ERR, "Secure flag in efuse already exists!\n");
    }
	
    /*************************ждϢǷȷ**************************/
    // efuseȡ
    memset(&efuseInfo, 0, sizeof(efuseInfo));
    if(ioctl(efuse_fd , EFUSE_GET_DATA, &efuseInfo)!= 0)
    {
        at_print(AT_ERR,"ioctl: EFUSE_GET_DATA fail.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		close(efuse_fd);
		return AT_END;
    }

	close(efuse_fd);

    if ((efuseInfo.secureFlag&0xff) != secureFlag)
    {
        at_print(AT_ERR, "Security flag(%#08X) in efuse is not consistent!\n", efuseInfo.secureFlag);
        *res_msg = at_err_build(ATERR_PROC_FAILED);
        *res_msglen = strlen(*res_msg);
		return AT_END;
    }
	
	*res_msg = at_query_result_build("write security infomation", NULL);
    *res_msglen = strlen(*res_msg);
	return AT_END;
}

int read_security_info(int at_fd, char *at_paras, void **res_msg, int *res_msglen)
{
    char strValue[16];
    char strLog[256] = {0};
    int i;
	int ret = 0;
	T_ZDrvEfuse_Secure efuseInfo = {{0}};
	int efuse_fd = -1;
    
	T_ZDrvOtp_Secure otpInfo = {{0}};
	int otp_fd = -1;
    int is_Enhanced_Security = -1;

	is_Enhanced_Security = IsEnhancedSecurity();
	at_print(AT_ERR,"is_Enhanced_Security = %d.\n",is_Enhanced_Security);
	if(is_Enhanced_Security == -1)
	{
		at_print(AT_ERR,"IsEnhancedSecurity() fail.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}
	
    efuse_fd = open("/dev/efuse", O_RDWR);
	if (efuse_fd < 0) 
	{
		at_print(AT_ERR,"open %s fail.\n","/dev/efuse");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

	at_print(AT_ERR,"open %s success.\n","/dev/efuse");

	 // efuseȡ
    if(ioctl(efuse_fd , EFUSE_GET_DATA, &efuseInfo)!= 0)
    {
        at_print(AT_ERR,"ioctl: EFUSE_GET_DATA fail.\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
		*res_msglen = strlen(*res_msg);
		close(efuse_fd);
		return AT_END;
    }
	else
	{	
	    at_print(AT_ERR,"ioctl: EFUSE_GET_DATA success.\n");
		strLog[0] = '\0';
		sprintf(strValue, "%02X,", efuseInfo.secureFlag&0xFF);
		strcat(strLog, strValue);
    	for (i = 0; i < sizeof(efuseInfo.pubKeyHash)/sizeof(UINT32); i++)
    	{
    	    sprintf(strValue, "%08lX", efuseInfo.pubKeyHash[i]);
        	strcat(strLog, strValue);
    	}
		at_print(AT_ERR, "Secure Flag,Public key hash: %s\n", strLog);
		close(efuse_fd);
		if(is_Enhanced_Security == 0)
		{
			*res_msg = at_query_result_build("read security information", strLog);
            *res_msglen = strlen(*res_msg);
		    return AT_END;
		}
	} 

	if(is_Enhanced_Security == 1)
    {
		otp_fd = open("/dev/otp", O_RDWR);
		if (otp_fd < 0) 
		{
			at_print(AT_ERR,"open %s fail.\n","/dev/otp");
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			*res_msglen = strlen(*res_msg);
			return AT_END;
		}

		at_print(AT_ERR,"open %s success.\n","/dev/otp");

		 // otpȡ
	    if(ioctl(otp_fd , OTP_GET_DATA, &otpInfo)!= 0)
	    {
	        at_print(AT_ERR,"ioctl: OTP_GET_DATA fail.\n");
			*res_msg = at_err_build(ATERR_PROC_FAILED);
			*res_msglen = strlen(*res_msg);
			close(otp_fd);
			return AT_END;
	    }
		else
		{		
			memset(strLog, 0, sizeof(strLog));
			sprintf(strValue, "%02X,", efuseInfo.secureFlag&0xFF);
			strcat(strLog, strValue);
	    	for (i = 0; i < sizeof(otpInfo.pubKeyHash)/sizeof(UINT32); i++)
	    	{
	    	    sprintf(strValue, "%08lX", otpInfo.pubKeyHash[i]);
	        	strcat(strLog, strValue);
	    	}
			at_print(AT_ERR, "Secure Flag,Public key hash: %s\n", strLog);
			*res_msg = at_query_result_build("read security information", strLog);
	        *res_msglen = strlen(*res_msg);
			close(otp_fd);
		    return AT_END;
		} 
    }
	
}

#ifdef USE_NVRO_BACKUP
int backup_nvro_func(int at_fd, char *at_paras, void **res_msg, int *res_msglen)
{
    unsigned int ret = CPNV_ERROR;
	
	ret = cpnv_NvroBackup();
    if (CPNV_ERROR== ret)
    {
        at_print(AT_ERR,"nvro backup failed\n");
        *res_msg = at_err_build(ATERR_PROC_FAILED);
	}
	else
	{
		at_print(AT_ERR, "nvro backup success\n");
		*res_msg = at_ok_build();
	}

	*res_msglen = strlen(*res_msg);
	return AT_END;
}
#endif



/*
int auth_device_key(int at_fd, char *at_paras,void ** res_msg, int *res_msglen)
{
	char *at_str = NULL; 
	
	at_print(AT_ERR,"at_paras=%s\n",at_paras);
		
	at_str = at_paras;	
	char seed[] = SEED;
	auth_device_key_result = verify_device_key(at_str,strlen(at_str),seed,strlen(seed));
	at_print(AT_ERR,"auth_device_key_result=%d\n",auth_device_key_result);
	
	if (auth_device_key_result == 1)
	{
		*res_msg = at_ok_build();
	}
	else
	{	
		at_print(AT_ERR,"verify device key fail !\n");
		*res_msg = at_err_build(ATERR_PROC_FAILED);
	}
	*res_msglen = strlen(*res_msg);
	
	return AT_END;
}
*/

int ext_amt_regist(void)
{
	if(!ext_is_usermode())
	{
		register_serv_func2("MODIMEI=",0,0,0,imeiWrite_act_func,NULL);
		register_serv_func2("PHONEMODE=",0,0,0,zphone_mode_set_req_act, 0);
		register_serv_func("ramdump",0,ext_ramdump_func);
		// д밲ȫϢ
		register_serv_func2("WSCYINFO",0,0,0,write_security_info,NULL);
	}
    register_serv_func2("RKEYDC=",0,0,0,rkeydc_act_func,NULL);
    register_serv_func2("ZPOWEROFF",0,0,0,poweroff_act_func,NULL);
    register_serv_func2("PLATFORM?",0,0,0,chip_platform_read_act_func,NULL);
    register_serv_func2("READIMEI",0,0,0,imeiRead_act_func,NULL);
    register_serv_func2("READIMEI?",0,0,0,imeiRead_act_func,NULL);
    register_serv_func2("SSID?",0,0,0,ssidRead_act_func,NULL);
    register_serv_func2("SSID=",0,0,0,ssidWrite_act_func,NULL);
    register_serv_func2("ZVERSIONTYPE=",0,0,0,versionTypeSet_act_func,NULL);
    register_serv_func2("MAC?",0,0,0,macRead_act_func,NULL);
    register_serv_func2("MAC=",0,0,0,macWrite_act_func,NULL);
    register_serv_func2("WIFIKEY?",0,0,0,wifikeyRead_act_func,NULL);
    register_serv_func2("WIFIKEY=",0,0,0,wifikeyWrite_act_func,NULL);
    register_serv_func2("ETHMAC?",0,0,0,rj45MacAddrRead_act_func,NULL);
    register_serv_func2("ETHMAC=",0,0,0,rj45MacAddWrite_act_func,NULL); 
    register_serv_func2("MAC2?",0,0,0,mac2Read_act_func,NULL);
    register_serv_func2("MAC2=",0,0,0,mac2Write_act_func,NULL);
    register_serv_func2("USBMAC?",0,0,0,usbmacRead_act_func,NULL);
    register_serv_func2("USBMAC=",0,0,0,usbmacWrite_act_func,NULL); 
    register_serv_func2("GMAC?",0,0,0,gmacRead_act_func,NULL);
    register_serv_func2("GMAC=",0,0,0,gmacWrite_act_func,NULL); 
    register_serv_func2("BATDET?",0,0,0,batdetRead_act_func,NULL); 
    register_serv_func2("BATDET=",0,0,0,batdetWrite_act_func,NULL); 
    register_serv_func2("MSN?",0,0,0,msnRead_act_func,NULL);
    register_serv_func2("MSN=",0,0,0,msnWrite_act_func,NULL);
    register_serv_func2("RTESTINFO",0,0,0,testInfoRead_act_func,NULL);
    register_serv_func2("ZAMTMODE=",0,0,0,closeAutoInd_act_func,NULL);
    
    //л汾ʹmodem汾
    register_serv_func2("PHONEMODE?",0,0,0,zphone_mode_query_req_act, 0);
    
    register_serv_func2("ZSOFTRESET",0,0,0,zsoftreset_act_func,NULL);
    
    register_serv_func2("zmode=",0,0,0,zmodeSet_act_func,NULL); 
	//mdlûģʽзģʽȨAT+ZAUTH=KEY
	//register_serv_func2("ZAUTH=",0,0,0,auth_device_key,NULL);
    register_serv_func2("RSCYINFO",0,0,0,read_security_info,NULL);
	
	#ifdef USE_NVRO_BACKUP
	register_serv_func2("NVROBACKUP",0,0,0,backup_nvro_func,NULL);
	#endif
	
    return 0;
}
