/***********************************************************************
* Copyright (C) 2015, Sanechips Corporation.
*
* File Name: 	 7520_3x3_keypad.c
* File Mark:  	 None
* Description:   None
* Others:
* Version:  	v1.0
* Author:    	zhaoyu
* Date:     	2015-11-30
*
* History 1:  	Primary edition
*     Date:
* 	 Version:
*     Author:
*     Modification:
* History 2: 
**********************************************************************/
/*include area*/
#include <linux/module.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/input.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/slab.h>
#include <linux/platform_device.h>
#include <linux/io.h>
#include <mach/pcu.h>

#include <linux/input/zx297520v2_keypad_4x4.h>
#include <linux/clk.h>
#include <mach/gpio.h>
#include <linux/irq.h>

/*define area*/
#define KEYPAD_DBG(fmt, args...)	printk(fmt , ## args)
#define DBG_ENTER() KEYPAD_DBG("%s Enter.\n", __FUNCTION__)
#define DBG_EXIT() KEYPAD_DBG("%s Exit.\n", __FUNCTION__)

#define INT_POSEDGE     (0x2)       /* 10: raise edge */

/*global & static variable area*/
static void __iomem* KEY_BASE_ADDR_VIR;
static void __iomem* RM_MOD_RST1_REG_VIR;
//static void __iomem* RM_MOD_CLKEN2_REG_VIR;
//static void __iomem* PIN_MUX_CTRLREG13_REG_VIR;


static void zx297520v2_key_param_init(unsigned interval,unsigned debounce,unsigned inten)
{
	DBG_ENTER();
	if (!(KEY_BASE_ADDR_VIR))
		return;
	T_KeyType *ptKey = (T_KeyType*)KEY_BASE_ADDR_VIR;

	ptKey->INTERVAL.Bit.interval = interval;
	ptKey->DEBOUNCE.Bit.debounce = debounce;

	ptKey->Int_En.Bit.int_en     = inten;
	ptKey->Cfg_Upt.Bit.cfg_upt   = 1;

	DBG_EXIT();
}


static unsigned zx297520v2_key_index_read(void)
{
	if (!(KEY_BASE_ADDR_VIR))
		return 0;
	T_KeyType *ptKey = (T_KeyType*)KEY_BASE_ADDR_VIR;

	return ptKey->Key_Index.val;
}

static unsigned zx297520v2_key_state_read(unsigned KeyStat[])
{
	if (!(KEY_BASE_ADDR_VIR))
		return 0;
    T_KeyType *ptKey = (T_KeyType*)KEY_BASE_ADDR_VIR;

    KeyStat[0] = ptKey->keystate[0];
	KeyStat[1] = ptKey->keystate[1];
	KeyStat[2] = ptKey->keystate[2];
	return 0;
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief λkey
 *
 * :
 *     - key_resetڽӿں, 书:
 *      -  λkey
 *
 * :
 *
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void zx297520v2_key_reset(void)
{
	DBG_ENTER();
	unsigned reg = 0;
	if (!(RM_MOD_RST1_REG_VIR))
		return;

	reg = __raw_readl(RM_MOD_RST1_REG_VIR);
	//rm Key apb sw reset
	HAL_BIT_CLR(reg, RM_MODRST1_KEY_SWWRST_POS);
	//rm Key work sw reset
	HAL_BIT_CLR(reg, RM_MODRST1_KEY_SWPRST_POS);
	__raw_writel(reg, RM_MOD_RST1_REG_VIR);

	reg = __raw_readl(RM_MOD_RST1_REG_VIR);
	//rm Key apb sw unreset
	HAL_BIT_SET(reg, RM_MODRST1_KEY_SWPRST_POS);
	//rm Key work sw unreset
	HAL_BIT_SET(reg, RM_MODRST1_KEY_SWWRST_POS);
	__raw_writel(reg, RM_MOD_RST1_REG_VIR);

	DBG_EXIT();
}


#if 0

/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʹkey߼ʱ
 *
 * :
 *     - key_clkenڽӿں, 书:
 *      -  ʹkey߼ʱ
 *
 * :
 *
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void key_clken(bool clken)
{
	DBG_ENTER();
	unsigned reg = 0;
	if (!(RM_MOD_CLKEN2_REG_VIR))
	return;

	reg = __raw_readl(RM_MOD_CLKEN2_REG_VIR);
	if(clken == 1)
	{
		//rm key apb clk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_PCLKEN_POS);
		//rm key work clk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_WCLKEN_POS);
	}
	else
	{
		//rm key work clk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_WCLKEN_POS);
		//rm key apb clk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_PCLKEN_POS);
	}
	__raw_writel(reg, RM_MOD_CLKEN2_REG_VIR);

	DBG_EXIT();
}


/**-------------------------------------------------------------------------------------------------------------------@n
 * @brief ʹkeyԶſ
 *
 * :
 *     - key_auto_clkenڽӿں, 书:
 *      -  ʹkeyԶſ
 *
 * :
 *
 *
 *   ֵ: 
 *
 * ˵:
 *     -
 *
 *--------------------------------------------------------------------------------------------------------------------*/
static void key_auto_clken(bool clken)
{
	DBG_ENTER();
	unsigned reg = 0;
	if (!(RM_MOD_CLKEN2_REG_VIR))
	return;

	reg = __raw_readl(RM_MOD_CLKEN2_REG_VIR);
	if(clken == 1)
	{
		//rm key work autoclk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_WCLK_AUTOGEN_POS);
		//rm key apb autoclk en
		HAL_BIT_SET(reg, RM_MODCLKEN2_KEY_PCLK_AUTOGEN_POS);
	}
	else
	{
		//rm key work autoclk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_WCLK_AUTOGEN_POS);
		//rm key apb autoclk disable
		HAL_BIT_CLR(reg, RM_MODCLKEN2_KEY_PCLK_AUTOGEN_POS);
	}
	__raw_writel(reg, RM_MOD_CLKEN2_REG_VIR);

	DBG_EXIT();
}
#endif

/**-------------------------------------------------------------------------------------------------------------------@n

 *--------------------------------------------------------------------------------------------------------------------*/
static void zx297520v2_key_pin_config(void)
{
	DBG_ENTER();
	#if 0
	unsigned udData = 0;
	unsigned reg = 0;
	if (!(PIN_MUX_CTRLREG13_REG_VIR))
	return;

    /*20~23 kbr_2; 19~16 kbr_1; 15~12 kbr_0
     // //11~8 kbc_2; 7~4 kbc_1; 3~0 kbc_0*/
    udData=0x111111;

	reg = __raw_readl(PIN_MUX_CTRLREG13_REG_VIR);
    HAL_FINS(reg, KEY_PINMUX_CTRL, udData);
	__raw_writel(reg, PIN_MUX_CTRLREG13_REG_VIR);
	#endif
/*pin config*/
    zx29_gpio_config(70,GPIO70_KEY_COL0);/*GPIO70:0 /key_col[0]*/
    zx29_gpio_config(71,GPIO71_KEY_COL1);/*GPIO71:0 /key_col[1]*/
    zx29_gpio_config(72,GPIO72_KEY_COL2);/*GPIO72:0 /key_col[2]*/
    zx29_gpio_config(73,GPIO73_KEY_COL3);/*GPIO73:0 /key_col[3]*/
    zx29_gpio_config(74,GPIO74_KEY_ROW0);/*GPIO74:0 /key_row[0]*/
	zx29_gpio_config(75,GPIO75_KEY_ROW1);/*GPIO75:0 /key_row[1]*/
    zx29_gpio_config(76,GPIO76_KEY_ROW2);/*GPIO76:0 /key_row[2]*/
    zx29_gpio_config(77,GPIO77_KEY_ROW3);/*GPIO77:0 /key_row[3]*/

/*end of pin config*/
	DBG_EXIT();
}



/***sys driver layer***/

/* Initializing the kp Module */
static int zx297520v2_4x4_keypad_initialize(struct zx297520v2_4x4_kpd *keypad)
{
	DBG_ENTER();
	int error= 0;

	KEY_BASE_ADDR_VIR = ioremap(KEY_BASE_ADDR, 0x4);

	RM_MOD_RST1_REG_VIR = ioremap(RM_MOD_RST1_REG, 0x4);
#if 0
	RM_MOD_CLKEN2_REG_VIR = ioremap(RM_MOD_CLKEN2_REG, 0x4);
#endif
	//PIN_MUX_CTRLREG13_REG_VIR = ioremap(PIN_MUX_CTRLREG13_REG, 0x4);

	zx297520v2_key_reset();
    zx297520v2_key_pin_config();
   // key_clken(1);
	zx297520v2_key_param_init(KEY_SCAN_INTERVAL, KEY_DEBOUNCE_TIME, KEY_INTERRUPUT_EN);

	KEYPAD_DBG("------------------>>keypad register read begin<<----------------\n");
	KEYPAD_DBG("KEY_INTERVAL = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_INTERVAL));
	KEYPAD_DBG("KEY_DEBOUNCE = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_DEBOUNCE));
	KEYPAD_DBG("KEY_INT_EN = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_INT_EN));
	KEYPAD_DBG("KEY_CFG_UPT = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_CFG_UPT));
	KEYPAD_DBG("KEY_INDEX = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_INDEX));
	KEYPAD_DBG("KEY_STATE1 = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_STATE1));
	KEYPAD_DBG("KEY_STATE2 = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_STATE2));
	KEYPAD_DBG("KEY_STATE3 = %08x\n",__raw_readl(KEY_BASE_ADDR_VIR + KEY_STATE3));
	//KEYPAD_DBG("PIN_MUX_CTRLREG13_REG = %08x\n",__raw_readl(PIN_MUX_CTRLREG13_REG_VIR));
	KEYPAD_DBG("------------------>>keypad register read end<<----------------\n");
	DBG_EXIT();
	return error;
}

/*interrupt primary handler*/
static irqreturn_t zx297520v2_4x4_keypad_irq_primary_handler(int irq, void *dev_id)
{
	disable_irq_nosync(irq);
	pcu_int_clear(irq);

	return IRQ_WAKE_THREAD;
}

/*interrupt handle thread*/
static irqreturn_t zx297520v2_4x4_keypad_interrupt(int irq, void *dev_id)
{
	DBG_ENTER();
	unsigned int dwkindex = 0;
	int temp = 0;
	unsigned int key1 = 0x03;
	unsigned int key2 = 0xFFFFFFFF;
	static unsigned keycode = KEY_RESERVED;
	int release = 0;
	int i = 0;
	struct zx297520v2_4x4_kpd *keypad = dev_id;

	dwkindex = zx297520v2_key_index_read();
	KEYPAD_DBG("[%s] zx297520v2_4x4_keypad key index = %08x\n", __FUNCTION__, dwkindex);
	if(0 != (dwkindex & 0x7f0000))
	{
	    temp = (dwkindex & 0x7f0000)>>16;
        if (1 == temp)
        {
            key1 =(dwkindex & 0x7f);
		}
		else if (2 == temp)
		{
			key1 = (dwkindex & 0x7f);
			key2 = ((dwkindex >> 8) & (0x7f));
		}
		else
		{
            ;
		}

		/*for (i = 0; i < (sizeof(keypad->key_map)/sizeof(keypad->key_map[0])); i++)
		{
			if (key1 == keypad->key_map[i][0])
			{
				keycode = keypad->key_map[i][1];
				break;
			}
		}*/
		i = (key1 / KPD_TOTAL_ROW) * KPD_MAX_ROW + (key1 % KPD_TOTAL_ROW) \
			- KPD_START_COLUMN - KPD_START_ROW;
		keycode = keypad->key_map[i];
		input_report_key(keypad->input, keycode, !release);
		input_sync(keypad->input);
		KEYPAD_DBG("[%s] report pressed key code = %08x, i = %d\n", __FUNCTION__, keycode, i);
	}
	else
	{
		input_report_key(keypad->input, keycode, release);
		input_sync(keypad->input);
		KEYPAD_DBG("[%s] report released key = %d\n", __FUNCTION__, keycode);
	}
	enable_irq(irq);

	DBG_EXIT();
	return IRQ_HANDLED;
}


/*probe*/
static int zx297520v2_4x4_keypad_probe(struct platform_device *pdev)
{
	DBG_ENTER();
	struct zx297520v2_4x4_kpd *keypad;
	struct zx297520v2_4x4_keypad_platform_data *pdata = dev_get_platdata(&pdev->dev);
	struct input_dev *key_dev;
	int error = 0;
	struct clk *pclk=NULL;
	struct clk *wclk=NULL;

	if (!pdata->key_map) {
		return -EINVAL;
	}

	keypad = kzalloc(sizeof(struct zx297520v2_4x4_kpd), GFP_KERNEL);
	if (!keypad) {
		return -ENOMEM;
	}

	key_dev = input_allocate_device();
	if (!key_dev) {
		error = -1;
		goto fail0;
	}
	/*set the clk*/
	pclk = clk_get_sys("zx29_kpd.0","work_clk");
	if (IS_ERR(pclk))
		panic("failed to get kpd wclk.");
	clk_prepare_enable(pclk);

	wclk = clk_get_sys("zx29_kpd.0","apb_clk");
	if (IS_ERR(pclk))
		panic("failed to get kpd pclk.");
	//clk_set_rate(wclk,32000);
	clk_prepare_enable(wclk);

	keypad->input = key_dev;
	keypad->irq = pdata->irq;
	memcpy(keypad->key_map, pdata->key_map, sizeof(keypad->key_map));

	__set_bit(EV_REP, key_dev->evbit);
	__set_bit(EV_KEY, key_dev->evbit);
	key_dev->name = pdev->name;

	error = input_register_device(keypad->input);
	if (error < 0) {
		goto fail1;
	}
    zx29_gpio_set_inttype(keypad->irq, IRQ_TYPE_EDGE_RISING);
    pcu_clr_irq_pending(keypad->irq);
	//error = request_irq(keypad->irq, zx297520_3x3_keypad_interrupt, 0, pdev->name, keypad);
	error = request_threaded_irq(keypad->irq, zx297520v2_4x4_keypad_irq_primary_handler, zx297520v2_4x4_keypad_interrupt, IRQF_TRIGGER_HIGH | IRQF_NO_THREAD, pdev->name, keypad);
	if (error < 0) {
		goto fail2;
	}
    printk("probe keypad: irq:%d\n", keypad->irq);
	error = zx297520v2_4x4_keypad_initialize(keypad);
	if (error < 0) {
		goto fail3;
	}

	platform_set_drvdata(pdev, keypad);
	goto end;

fail3:
	free_irq(keypad->irq, keypad);
fail2:
	input_unregister_device(keypad->input);
fail1:
	input_free_device(key_dev);
fail0:
	kfree(keypad);
end:
	DBG_EXIT();
	return error;
}

/*remove*/
static int zx297520v2_4x4_keypad_remove(struct platform_device *pdev)
{
	DBG_ENTER();
	struct zx297520v2_4x4_kpd *keypad = platform_get_drvdata(pdev);

	free_irq(keypad->irq, keypad);

	input_unregister_device(keypad->input);

	input_free_device(keypad->input);

	kfree(keypad);

	DBG_EXIT();
	return 0;
}

/*resume*/
static int zx297520v2_4x4_keypad_resume(struct platform_device *pdev)
{
	return 0;
}

/*suspend*/
static int zx297520v2_4x4_keypad_suspend(struct platform_device *pdev, pm_message_t state)
{
	return 0;
}


/**/
static struct platform_driver zx297520v2_4x4_keypad_driver =
{
	.probe	= zx297520v2_4x4_keypad_probe,
	.remove	= zx297520v2_4x4_keypad_remove,
	.driver	=
	{
		.name	=	"zx297520v2_keypad",
		.owner  =	THIS_MODULE,
	},
	.resume	= zx297520v2_4x4_keypad_resume,
	.suspend	= zx297520v2_4x4_keypad_suspend,
};

static int __init zx297520v2_4x4_keypad_init(void)
{
	return platform_driver_register(&zx297520v2_4x4_keypad_driver);
}

static void __exit zx297520v2_4x4_keypad_exit(void)
{
	platform_driver_unregister(&zx297520v2_4x4_keypad_driver);
}

module_init(zx297520v2_4x4_keypad_init);
module_exit(zx297520v2_4x4_keypad_exit);

MODULE_AUTHOR("Sanechips");
MODULE_DESCRIPTION("Sanechips-7520_3x3_keypad Driver");
MODULE_LICENSE("GPL");


