/* drivers/input/touchscreen/cst716_ts.c 
* 
* TouchScreen driver. 
* 
* Copyright (c) 
* 
* This software is licensed under the terms of the GNU General Public 
* License version 2, as published by the Free Software Foundation, and 
* may be copied, distributed, and modified under those terms. 
* 
* This program is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
* GNU General Public License for more details. 
* 
*/ 
#include <linux/i2c.h> 
#include <linux/input.h> 
#include <linux/delay.h> 
#include <linux/slab.h> 
#include <linux/interrupt.h> 
#include <mach/irqs.h> 
#include <linux/kernel.h> 
#include <linux/semaphore.h> 
#include <linux/mutex.h> 
#include <linux/platform_device.h>
#include <linux/module.h> 
#include <linux/gpio.h> 
#include <linux/syscalls.h> 
#include <linux/unistd.h> 
#include <linux/uaccess.h> 
#include <linux/fs.h> 
#include <linux/string.h> 
#include <linux/timer.h> 
#include <linux/of.h> 
#include <linux/of_gpio.h> 
#include <linux/irq.h>
#include <linux/input/touchscreen.h> 
#include <linux/input/cst716_ts.h> 

extern enum touchscreen_type touchscreen_detected_type;
	  
int cst716_read_touchdata(struct ts_data *data) 
{ 
	struct ts_event *event = data->events; 
	u8 readbuf[POINT_READ_BUF] = { 0 };
	int ret = -1; 
	int i; 

	ret = tp_i2c_read(data->client, readbuf, 1, readbuf, POINT_READ_BUF);
	if (ret < 0) { 
		dev_err(&data->client->dev, "%s read touchdata failed.\n", 
		__func__); 
		return ret; 
	} 

	data->touch_points = readbuf[HYN_TOUCH_POINT_NUM] & 0x0F;

	if (data->touch_points > CFG_MAX_TOUCH_POINTS) { 
		dev_err(&data->input_dev->dev, 
		"touchscreen reports %d points, %d are supported\n", 
		data->touch_points, CFG_MAX_TOUCH_POINTS); 
		data->touch_points = CFG_MAX_TOUCH_POINTS; 
	}

	for (i = 0; i < CFG_MAX_TOUCH_POINTS; i++) { 
		event[i].x =
		(s16) (readbuf[HYN_TOUCH_X_H_POS + HYN_TOUCH_STEP * i] & 0x0F) <<
		8 | (s16) readbuf[HYN_TOUCH_X_L_POS + HYN_TOUCH_STEP * i];
		event[i].y =
		(s16) (readbuf[HYN_TOUCH_Y_H_POS + HYN_TOUCH_STEP * i] & 0x0F) <<
		8 | (s16) readbuf[HYN_TOUCH_Y_L_POS + HYN_TOUCH_STEP * i];
		event[i].event =
		readbuf[HYN_TOUCH_EVENT_POS + HYN_TOUCH_STEP * i] >> 6;
		event[i].id =
		(readbuf[HYN_TOUCH_ID_POS + HYN_TOUCH_STEP * i]) >> 4;

		event[i].pressure =
		(readbuf[HYN_TOUCH_XY_POS + HYN_TOUCH_STEP * i]);

		if ((event[i].event == 0 || event[i].event == 2) && (data->touch_points == 0))
		break;
	} 

	return 0; 
} 

static struct touchscreen_operations cst716_operations =
{
	cst716_read_touchdata,
};

int cst716_id_detect(struct i2c_client *client)
{
	int ret = 0 ;
	u8 chip_vendor_id = 0;
	u8 ctpm_vendor_id = 0;
	
	/* allow touch panel controller to boot, before querying it */ 
	msleep(150); 
	client->addr = CST716_I2C_SLAVE_ADDR;
	ret = tp_read(client, TP_REG_CHIP_VENDOR_ID, 1, &chip_vendor_id);

	if(ret < 0)
	{
      		printk("[TP] cst716 TP_REG_CHIP_VENDOR_ID 0x%x failed\n",client->addr);
     		return -EINVAL;
	}
	
	ret = tp_read(client, TP_REG_CTPM_VENDOR_ID, 1, &ctpm_vendor_id);

	if(ret < 0)
	{
      		printk("[TP] cst716 TP_REG_CTPM_VENDOR_ID 0x%x failed\n",client->addr);
     		return -EINVAL;
	}

	if((chip_vendor_id == 0x36) &&(ctpm_vendor_id == 0x01))
	{
		touchscreen_detected_type = TOUCHSCREEN_CST716; 
	}
	else
	{
		return -EINVAL;
	}

	touchscreen_set_operations(TOUCHSCREEN_CST716, &cst716_operations);
  
	return 0;
}

static struct touchscreen_register cst716_id_register = 
{
	cst716_id_detect
};

static int cst716_ts_driver_init()
{
	touchscreen_register(TOUCHSCREEN_CST716, &cst716_id_register);
	return 0;
}

subsys_initcall(cst716_ts_driver_init);

