/* drivers/input/touchscreen/ft6x06_ts.c 
* 
* FocalTech ft6x06 TouchScreen driver. 
* 
* Copyright (c) 2010 Focal tech Ltd. 
* 
* This software is licensed under the terms of the GNU General Public 
* License version 2, as published by the Free Software Foundation, and 
* may be copied, distributed, and modified under those terms. 
* 
* This program is distributed in the hope that it will be useful, 
* but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
* GNU General Public License for more details. 
* 
*/ 
#include <linux/i2c.h> 
#include <linux/input.h> 
#include <linux/delay.h> 
#include <linux/slab.h> 
#include <linux/interrupt.h> 
#include <mach/irqs.h> 
#include <linux/kernel.h> 
#include <linux/semaphore.h> 
#include <linux/mutex.h> 
#include <linux/platform_device.h>
#include <linux/module.h> 
#include <linux/gpio.h> 
#include <linux/syscalls.h> 
#include <linux/unistd.h> 
#include <linux/uaccess.h> 
#include <linux/fs.h> 
#include <linux/string.h> 
#include <linux/timer.h> 
#include <linux/of.h> 
#include <linux/of_gpio.h> 
#include <linux/irq.h>
#include <linux/input/touchscreen.h> 
#include <linux/input/ft6x06_ts.h> 

extern enum touchscreen_type touchscreen_detected_type;

int ft6x06_read_touchdata(struct ts_data *data) 
{ 
	struct ts_event *event = data->events; 
	struct ft6x06_packet buf = {0}; 
	int ret = -1; 
	int i; 
	ret = tp_read(data->client, 0, sizeof(buf), &buf); 
	if (ret < 0) { 
		dev_err(&data->client->dev, "%s read touchdata failed.\n", 
		__func__); 
		printk("[TP]ft6x06_read_touchdata tp_read failed!\n");

		return ret; 
	} 

	dev_dbg(&data->input_dev->dev, "detected %d touch events\n", buf.touches); 

	data->touch_points = buf.touches; 
	if (data->touch_points > CFG_MAX_TOUCH_POINTS) { 
		dev_err(&data->input_dev->dev, 
		"touchscreen reports %d points, %d are supported\n", 
		data->touch_points, CFG_MAX_TOUCH_POINTS); 
		data->touch_points = CFG_MAX_TOUCH_POINTS; 
	} 

	for (i = 0; i < CFG_MAX_TOUCH_POINTS; i++) { 
		event[i].x = ((buf.points[i].xhi & 0xf) << 8); 
		event[i].x |= buf.points[i].xlo; 
		event[i].y = ((buf.points[i].yhi & 0xf) << 8); 
		event[i].y |= buf.points[i].ylo; 
		event[i].event = buf.points[i].event >> 6; 
		event[i].id = buf.points[i].id >> 4; 
		event[i].pressure = FT_PRESS; 
		//printk("[TP]ft6x06_read_touchdata x= 0x%x, y = 0x%x!\n",event[i].x,event[i].y);
	} 
	
	return 0; 
} 

static struct touchscreen_operations ft6x06_operations =
{
	ft6x06_read_touchdata,
};

int ft6x06_id_detect(struct i2c_client *client)
{
	int ret = 0 ;
	u8 chip_vendor_id = 0;
	u8 ctpm_vendor_id = 0;
	/* allow touch panel controller to boot, before querying it */ 
	msleep(150); 
	
	client->addr = FT_I2C_SLAVE_ADDR;
	ret = tp_read(client, TP_REG_CHIP_VENDOR_ID, 1, &chip_vendor_id);
	if(ret < 0)
	{
  		client->addr = 0xA7;
		printk("[TP] ft6x06_id_detect TP_REG_CHIP_VENDOR_ID 0x%x failed\n",client->addr);
	}
	
	ret = tp_read(client, TP_REG_CHIP_VENDOR_ID, 1, &chip_vendor_id);
	if(ret < 0)
	{
		printk("[TP] ft6x06_id_detect TP_REG_CHIP_VENDOR_ID 0x%x failed\n",client->addr);
     		return -EINVAL;
	}

	ret = tp_read(client, TP_REG_CTPM_VENDOR_ID, 1, &ctpm_vendor_id);
	if(ret < 0)
	{
		printk("[TP] ft6x06_id_detect TP_REG_CTPM_VENDOR_ID 0x%x failed\n",client->addr);
     		return -EINVAL;
	}
	
	if((chip_vendor_id == 0x64) &&(ctpm_vendor_id == 0x23))
	{
		touchscreen_detected_type = TOUCHSCREEN_FT6X06;
	}
	else
	{
		return -EINVAL;
	}
	
	touchscreen_set_operations(TOUCHSCREEN_FT6X06, &ft6x06_operations);

	return 0;
}

static struct touchscreen_register ft6x06_id_register = 
{
	ft6x06_id_detect
};

static int  ft6x06_ts_driver_init()
{
	touchscreen_register(TOUCHSCREEN_FT6X06, &ft6x06_id_register);
	return 0;
}

subsys_initcall(ft6x06_ts_driver_init);

