
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/cdev.h>
#include <linux/semaphore.h>

// #include <linux/fs.h>
#include <linux/ioport.h>
// #include <linux/serial_reg.h>
#include <linux/poll.h>
#include <linux/delay.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
// #include <linux/spinlock.h>
#include <linux/list.h>
#include <linux/slab.h>
#include <linux/sched.h>
// #include <linux/kthread.h>
#include <asm/io.h>

#include <linux/vmalloc.h>
#include <linux/soc/zte/rpm/rpmsg.h>
// #include <linux/syscalls.h>

// #include "debuginfo.h"
#include "pub_debug_info.h"
#include "ringbuf.h"
#include "ZspTrace.h"
#include <linux/proc_fs.h>
#include <asm/barrier.h>
#include <asm/cache.h>
#include <asm/cacheflush.h>
#include <linux/seq_file.h>
#include <linux/ktime.h>
#include <linux/time.h>


#if defined(_USE_ZXIC_DEBUG_INFO)
/*******************************************************************************
 *                                   宏定义                                     *
 *******************************************************************************/
#define DEBUG_INFO_MAX_ID_LEN       (16+3)
#define DEBUG_INFO_MAX_DATA_LEN     (128)
#define DEBUG_INFO_MAX_TIME_LEN     (0)//(20+3)
#define DEBUG_INFO_MAX_DATE_LEN     (19+3)
#define DEBUG_INFO_MAX_TOTAL_LEN    (DEBUG_INFO_MAX_ID_LEN + DEBUG_INFO_MAX_DATA_LEN + DEBUG_INFO_MAX_TIME_LEN)

/*******************************************************************************
 *                                结构体定义                                     *
 *******************************************************************************/

/*******************************************************************************
 *                                  全局变量                                     *
 *******************************************************************************/
static int g_init_flag = 0;
volatile UINT32 *g_debug_write_cnt;
volatile UINT32 *g_debug_full_cnt;
UINT8 *g_debug_buffer_start;
UINT8 *g_debug_buffer_write;
UINT8 *g_debug_buffer_end;
static DEFINE_SPINLOCK(debug_info_lock);
extern unsigned long long zx_comptimer_curvalue(void);

/*******************************************************************************
 *                              内部函数定义                                     *
 *******************************************************************************/
static int sc_debug_info_read_to_user(char *buf, unsigned short count);
static int sc_debug_info_record_from_user(const char *info, unsigned short count);
static ssize_t debug_info_read(struct file *fp, char __user *buf, size_t count, loff_t *pos);
static ssize_t debug_info_write(struct file *fp, const char __user *buf, size_t count, loff_t *pos);
static int debug_info_open(struct inode *ip, struct file *fp);
static long debug_info_ioctl(struct file *fp, unsigned int cmd, unsigned long arg);
static int debug_info_release(struct inode *ip, struct file *fp);

static const struct file_operations debug_info_fops = {
    .owner = THIS_MODULE,
    .read = debug_info_read,
    .write = debug_info_write,
    .open = debug_info_open,
    .unlocked_ioctl = debug_info_ioctl,
    .release = debug_info_release,
};

static struct miscdevice debug_info_device = {
    .minor = MISC_DYNAMIC_MINOR,
    .name = "debug_info",
    .fops = &debug_info_fops,
};

static ssize_t debug_info_read(struct file *fp, char __user *buf, size_t count, loff_t *pos)
{
    return -1;
}

static ssize_t debug_info_write(struct file *fp, const char __user *buf, size_t count, loff_t *pos)
{
    int wr_len = sc_debug_info_record_from_user(buf, count);

    return wr_len;
}

static int debug_info_open(struct inode *ip, struct file *fp)
{
    return 0;
}

static long debug_info_ioctl(struct file *fp, unsigned int cmd, unsigned long arg)
{
    return 0;
}

static int debug_info_release(struct inode *ip, struct file *fp)
{
    return 0;
}

static int sc_debug_info_read_to_user(char *buf, unsigned short count)
{
    return -1;
}

static int sc_debug_info_record_from_user(const char *info, unsigned short count)
{
    unsigned int cnt = 0;
    int spacelen;
    struct tm tm;
    unsigned long time;
    char buffer[DEBUG_INFO_MAX_TOTAL_LEN];
    unsigned long flags;
    UINT8 *tmp_write_addr = buffer;
    int msg_len =  0;
    
    if (g_init_flag == 0)
    {
        printk("debug_info not init.\n");
        return -EINVAL;
    }
    time = get_seconds();
    time_to_tm((time_t)time, 0, &tm);
    cnt = snprintf((char *)tmp_write_addr, DEBUG_INFO_MAX_DATE_LEN, "[%ld-%02d-%02d %d:%02d:%02d]", tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec);
    tmp_write_addr += cnt;
    msg_len = cnt; 
    spin_lock_irqsave(&debug_info_lock, flags);
    spacelen = g_debug_buffer_end - g_debug_buffer_write;
    if (spacelen < msg_len + count)
    {
        memset(g_debug_buffer_write,'\0',spacelen);
        g_debug_buffer_write = g_debug_buffer_start;
        *g_debug_full_cnt  += 1;
        *g_debug_write_cnt = 0;
    }

    memcpy(g_debug_buffer_write, buffer, msg_len);
    memcpy(g_debug_buffer_write + msg_len, info, count);
    msg_len += count;
    g_debug_buffer_write += msg_len;
    *g_debug_write_cnt   += msg_len;

    spin_unlock_irqrestore(&debug_info_lock, flags);

    return cnt;
}

int sc_debug_info_vrecord(char *id, const char *format, va_list args)
{
    unsigned int cnt = 0;
    int len;
    int spacelen;
    int msg_len = 0;
    struct tm tm;
    unsigned long time;
    unsigned long flags;
    char buffer[DEBUG_INFO_MAX_TOTAL_LEN];
    UINT8 *tmp_write_addr = buffer;

    time = get_seconds();
    time_to_tm((time_t)time, 0, &tm);
    cnt = snprintf((char *)tmp_write_addr, DEBUG_INFO_MAX_DATE_LEN, "[%ld-%02d-%02d %d:%02d:%02d]", tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec);
    tmp_write_addr += cnt;
    msg_len = cnt; 
    len = snprintf(tmp_write_addr, DEBUG_INFO_MAX_ID_LEN, "[%s]",id);
    tmp_write_addr += len;
    msg_len += len;
    msg_len += vsnprintf(tmp_write_addr, DEBUG_INFO_MAX_DATA_LEN, format, args);

    spin_lock_irqsave(&debug_info_lock, flags);
    spacelen = g_debug_buffer_end - g_debug_buffer_write;
    if (spacelen < msg_len)
    {
        memset(g_debug_buffer_write,'\0',spacelen);
        g_debug_buffer_write = g_debug_buffer_start;
        *g_debug_full_cnt  += 1;
        *g_debug_write_cnt = 0;
    }

    memcpy(g_debug_buffer_write, buffer, msg_len);
    g_debug_buffer_write += msg_len;
    *g_debug_write_cnt   += msg_len;

    spin_unlock_irqrestore(&debug_info_lock, flags);
    
    return msg_len;
}

int sc_debug_info_record(char *id, const char *format, ...)
{
    va_list args;
    int r;
    
    if (g_init_flag == 0)
    {
        printk("debug_info not init.\n");
        return -EINVAL;
    }
    
    va_start(args, format);
    r = sc_debug_info_vrecord(id, format, args);
    va_end(args);

    return r;
}
EXPORT_SYMBOL(sc_debug_info_record);

void  early_debug_info_init(void)
{
    g_debug_write_cnt    = ( UINT32 *)ioremap(PS_DEBUG_INFO_LEN_ADDR_PA, PS_DEBUG_INFO_LEN_SIZE);  //early_ioremap
    *g_debug_write_cnt   = 0;
    g_debug_full_cnt     = (volatile UINT32 *)((char *)g_debug_write_cnt + 4);
    *g_debug_full_cnt    = 0;
 
    g_debug_buffer_start = (unsigned long)ioremap(PS_DEBUG_INFO_ADDR_PA, PS_DEBUG_INFO_SIZE);
    g_debug_buffer_end   = (UINT8 *)g_debug_buffer_start + PS_DEBUG_INFO_SIZE;
    g_debug_buffer_write = g_debug_buffer_start;

    g_init_flag = 1;
    //printk("ap early_debug_info_init  success \n");
}

UINT32 debug_info_init(VOID)  
{
    int ret = 0;  

    ret = misc_register(&debug_info_device);
    if (ret)
    {
        printk("debug_info_device init.\n");
        return -EINVAL;
    }

    printk("ap debug_info_device init success \n");
    return ret;
}

static void __exit debug_info_exit(void)
{
    misc_deregister(&debug_info_device);
}

module_init(debug_info_init);
module_exit(debug_info_exit);


#endif   /*  _USE_ZXIC_DEBUG_INFO */

