/**
 * 
 * @file      logcat_drv_printk.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatprintk豸
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/ioport.h>
#include <linux/serial_reg.h>
#include <linux/poll.h>
#include <linux/delay.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
#include <linux/spinlock.h>
#include <linux/list.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/kthread.h>
#include <asm/io.h>
#include "logcat_drv.h"


#define TOOL_AGENT_BASE_ADDR          (0x22400000)

//AP KERNEL buff
#define ZCAT_KERNEL_TO_CP_BASE_ADDR   (0x22900000)
#define ZCAT_KERNEL_TO_CP_SIZE        (0x4000)

#define ZCAT_CP_TO_KERNEL_BASE_ADDR   (TOOL_AGENT_BASE_ADDR+0x50C000)
#define ZCAT_CP_TO_KERNEL_SIZE        (0x4000)

//AP APP buff
#define ZCAT_APP_TO_CP_BASE_ADDR      (0x22910000)
#define ZCAT_APP_TO_CP_SIZE           (0x4000)

#define ZCAT_CP_TO_APP_BASE_ADDR      (TOOL_AGENT_BASE_ADDR+0x51C000)
#define ZCAT_CP_TO_APP_SIZE           (0x4000)



#define SYMBOL_VALUE ZCAT_IPC_ESTABLISHED


UINT8 LEVER_FOR_PRINTK[MODULE_NUMBER_MAX] = {0};
EXPORT_SYMBOL(LEVER_FOR_PRINTK);
    
UINT8 LEVER_FOR_PRINTF[MODULE_NUMBER_MAX] = {0};
EXPORT_SYMBOL(LEVER_FOR_PRINTF);

static const char logcatk_shortname[] = "logcat_printk";

T_RINGBUFFER* KERNEL_BUFF=NULL;
EXPORT_SYMBOL(KERNEL_BUFF);

T_RINGBUFFER* APP_BUFF=NULL;
EXPORT_SYMBOL(APP_BUFF);

T_RINGBUFFER* CP_TO_KERNEL_BUFF = NULL;
T_RINGBUFFER* CP_TO_APP_BUFF = NULL;

char P_KERNEL[1024*16]; 
char P_APP[1024*16]; 

struct kernel_dev {
    wait_queue_head_t read_wq;
    struct completion write_done;
};

static wait_queue_head_t kernelqueue;
static struct kernel_dev _kernel_dev;
static int enable_kernellog = 1;
//EXPORT_SYMBOL(enable_kernellog);

typedef struct
{
    unsigned short type;
    UINT8 operation;
    UINT8 reserved;
}T_ZCAT_DIAG_CONFIG_REQ;

typedef enum
{
    DISABLE_LOGGING = 0,
    ENABLE_LOGGING,
    GET_MASK,
    SET_MASK,
    DIAG_LAST_OPERATION
        
}T_ZCAT_DIAG_CONFIG_OPERATION_TYPE;

typedef struct
{
    char* data;
    int data_len;
}T_IOCTL_PARA;

extern UINT32 WriteRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len);
extern T_RINGBUFFER *CreateRingBuffer(UINT8 *buf, UINT32 bufSize);
extern BOOL IsRingBufferValid(T_RINGBUFFER *ringBuf);

static int logcatk_open(struct inode *ip, struct file *fp);
static int logcatk_release(struct inode *ip, struct file *fp);
static ssize_t logcatk_read(struct file *fp, char __user *buf,size_t count, loff_t *pos);
static ssize_t logcatk_write(struct file *fp, const char __user *buf,size_t count, loff_t *pos);
static long logcatk_ioctl(struct file *fp, unsigned int cmd, unsigned long arg);


static const struct file_operations logcatk_fops = {
    .owner = THIS_MODULE,
    .read = logcatk_read,
    .write = logcatk_write,
    .open = logcatk_open,
    .unlocked_ioctl = logcatk_ioctl,
    .release = logcatk_release,
};

static struct miscdevice logcatk_device = {
    .minor = MISC_DYNAMIC_MINOR,
    .name = logcatk_shortname,
    .fops = &logcatk_fops,
};

void sleep_milli_sec(nmillisec)
{
    do{
    long timeout = (nmillisec)*HZ/1000;
    while(timeout>0)
    {
        timeout = schedule_timeout(timeout);
    }
    }while(0);
}
EXPORT_SYMBOL(sleep_milli_sec);
#ifdef CONFIG_SYSTEM_RECOVERY
/**************************************************************************
* : IsRingBufferIsValid
* : жϻǷЧ
* ˵: (IN)
                ringBuf:λ
*   ֵ:
* ˵: ǷTRUE,񷵻FALSE
**************************************************************************/
BOOL IsRingBufferValid(T_RINGBUFFER *ringBuf)
{
    return (ringBuf != NULL && ringBuf->symbol == SYMBOL_VALUE);
}

/**************************************************************************
* : CreateRingBuffer
* : ҪĻ
* ˵: (IN)
                buf:ַ
                bufSize: С
*   ֵ: ɹָ򻺳ṹָ룬򷵻NULL
* ˵: bufΪNULLַָһڴΪ
**************************************************************************/
T_RINGBUFFER *CreateRingBuffer(UINT8 *buf, UINT32 bufSize)
{
    T_RINGBUFFER *ringBuf = NULL;

    if (bufSize <= sizeof(T_RINGBUFFER))
    {
        return NULL;
    }

    ringBuf = (T_RINGBUFFER *)buf;
    

    ringBuf->capacity   = bufSize - sizeof(T_RINGBUFFER);
    ringBuf->readPoint  = 0;
    ringBuf->writePoint = 0;
    ringBuf->symbol     = SYMBOL_VALUE;

    return ringBuf;
}
EXPORT_SYMBOL(CreateRingBuffer);

/**************************************************************************
* : WriteRingBuffer
* : д뻷λ
* ˵: (IN)
                ringBuf:λ
                buf:ָ
                len:
*   ֵ: д볤
* ˵:
**************************************************************************/
UINT32 WriteRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len)
{
    UINT32 writeLen = 0;
    UINT32 writePoint = ringBuf->writePoint;
    UINT32 readPoint = ringBuf->readPoint;

    /* ж */
    //pr_info("logcat---WriteRingBuffer\n");
    if (!IsRingBufferValid(ringBuf) || buf == NULL || len == 0)
    {
        return 0;
    }

    if (writePoint >= readPoint)
    {
        if (ringBuf->capacity - writePoint > len)
        {
            copy_from_user(ringBuf->buf + writePoint, buf, len);
            ringBuf->writePoint += len;
            writeLen = len;
        }
        else if ((ringBuf->capacity - writePoint + readPoint - 1) >= len)
        {
            UINT32 copyLen = ringBuf->capacity - writePoint;
            copy_from_user(ringBuf->buf + writePoint, buf, copyLen);

            copyLen = len - copyLen;

            if (copyLen > 0)
            {
                copy_from_user(ringBuf->buf, buf + (len - copyLen), copyLen);
            }

            ringBuf->writePoint = copyLen;
            writeLen = len;
        }
    }
    else
    {
        if (readPoint - writePoint - 1 >= len)
        {
            copy_from_user(ringBuf->buf + writePoint, buf, len);
            ringBuf->writePoint += len;
            writeLen = len;
        }
    }

    return writeLen;
}

EXPORT_SYMBOL(WriteRingBuffer);
#endif
/**************************************************************************
* : CreateRingBuffer
* : ҪĻ
* ˵: (IN)
                buf:ַ
                bufSize: С
*   ֵ: ɹָ򻺳ṹָ룬򷵻NULL
* ˵: bufΪNULLַָһڴΪ
**************************************************************************/
T_RINGBUFFER *CreateRingBufferNew(UINT8 *buf, UINT32 bufSize)
{
    T_RINGBUFFER *ringBuf = NULL;

    if (bufSize <= sizeof(T_RINGBUFFER))
    {
        return NULL;
    }

    ringBuf = (T_RINGBUFFER *)buf;
    

    ringBuf->capacity   = bufSize - sizeof(T_RINGBUFFER);
    ringBuf->readPoint  = 0;
    ringBuf->writePoint = 0;
    ringBuf->symbol     = 0xA0A0A0A0;

    return ringBuf;
}
EXPORT_SYMBOL(CreateRingBufferNew);
/**************************************************************************
* : ReadRingBuffer
* : ȡһλλ
* ˵: (IN)
                ringBuf:λ
                buf:ָ
                len:
*   ֵ: ضȡ
* ˵:
**************************************************************************/
UINT32 ReadRingBuffer_AP(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len)
{
    UINT32 readLen = 0;
    UINT32 writePoint = ringBuf->writePoint;
    UINT32 readPoint = ringBuf->readPoint;

    /*  */
    if (!IsRingBufferValid(ringBuf) || buf == NULL || len == 0)
    {
        return 0;
    }

    if (writePoint > readPoint)
    {
        readLen = writePoint - readPoint;
        readLen = (readLen >= len) ? len : readLen;

        copy_to_user(buf, ringBuf->buf + readPoint, readLen);
        ringBuf->readPoint += readLen;
    }
    else if (writePoint < readPoint)
    {
        readLen = ringBuf->capacity - readPoint + writePoint;
        readLen = (readLen >= len) ? len : readLen;

        if (ringBuf->capacity - readPoint >= readLen)
        {
            copy_to_user(buf, ringBuf->buf + readPoint, readLen);
            ringBuf->readPoint = (ringBuf->readPoint + readLen) % ringBuf->capacity;
        }
        else
        {
            UINT32 copyLen = ringBuf->capacity - readPoint;
            copy_to_user(buf, ringBuf->buf + readPoint, copyLen);

            copyLen = readLen - copyLen;
            copy_to_user(buf + (readLen - copyLen), ringBuf->buf, copyLen);

            ringBuf->readPoint = copyLen;
        }
    }

    return readLen;
}
EXPORT_SYMBOL(ReadRingBuffer_AP);

static ssize_t logcatk_read(struct file *fp, char __user *buf,size_t count, loff_t *pos)
{
    UINT8 *kernelbuf = NULL;
    UINT32 kernelbufLen = 0;
    int ret = -1;

    if(buf ==NULL)
    return -1;
    /*kernelbuf = kzalloc(count*sizeof(UINT8),GFP_KERNEL);
    if(kernelbuf == NULL)
    return -1;*/
    ret = wait_for_completion_interruptible(&_kernel_dev.write_done);
    if(ret < 0)
    {
       // kfree(kernelbuf);
        return ret;
    }
    kernelbufLen = ReadRingBuffer_AP(KERNEL_BUFF, buf, count);
    //copy_to_user(buf, kernelbuf, kernelbufLen);
    //kfree(kernelbuf);
    return kernelbufLen;
}

static ssize_t logcatk_write(struct file *fp, const char __user *buf,size_t count, loff_t *pos)
{
    return 0;
}

static int logcatk_open(struct inode *ip, struct file *fp)
{
    //fp->private_data =_kernel_dev;
    return 0;
}

static long logcatk_ioctl(struct file *fp, unsigned int cmd, unsigned long arg)
{
    T_ZCAT_DIAG_CONFIG_REQ aprule = {0};
    int copy_ret = -1;
    void __user* ubuf = (void __user*)arg;

    copy_ret = copy_from_user(&aprule, ubuf, sizeof(T_ZCAT_DIAG_CONFIG_REQ));
    if(aprule.operation == DISABLE_LOGGING)
        enable_kernellog = 0;
    else if(aprule.operation == ENABLE_LOGGING)
        enable_kernellog = 1;
    return 0;
}
static int logcatk_release(struct inode *ip, struct file *fp)
{
    return 0;
}


void readringbuf_for_printk()
{
#if 0
    if(enable_kernellog == 1)
    {
        memset(LEVER_FOR_PRINTK, 1, sizeof(UINT8)*MODULE_NUMBER_MAX);
        wake_up_interruptible(&kernelqueue);
        
    }
    else
    {
        memset(LEVER_FOR_PRINTK, 0, sizeof(UINT8)*MODULE_NUMBER_MAX);
    }
    #endif
    complete(&_kernel_dev.write_done);
}
EXPORT_SYMBOL(readringbuf_for_printk);

static int __init logcatk_init(void)
{

    struct kernel_dev *dev;
    int ret = misc_register(&logcatk_device);
    printk("logcat_printk init\n");
    
    if (ret)
    {
        printk(KERN_ERR "logcatk driver failed to initialize\n");
        return -1;
    }
    KERNEL_BUFF = CreateRingBuffer(P_KERNEL, 16*1024);
    APP_BUFF = CreateRingBuffer(P_APP, 16*1024);
    dev = kzalloc(sizeof(*dev), GFP_KERNEL);
    if (!dev)
        return -ENOMEM;
    //init_waitqueue_head(&dev->read_wq);
    init_completion(&_kernel_dev.write_done);
    //_kernel_dev = dev;
    //kernelqueue=_kernel_dev->read_wq;
    kfree(dev);
    return 0;
}



static void __exit logcatk_exit(void)
{
    misc_deregister(&logcatk_device);
}

module_init(logcatk_init);
module_exit(logcatk_exit);

MODULE_AUTHOR("jinkai");
MODULE_DESCRIPTION("zCat logcat_printk driver");
MODULE_LICENSE("GPL");


