#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/slab.h>

//#include <linux/printk.h>
#include <linux/jiffies.h>
#include "mmc_xlog.h"

#include <mach/highspeed_debug.h>

/******************* usb log start **********************************/
static struct xlog *xlog_mmc0_buf;
static int xlog_mmc0_buf_idx, xlog_mmc0_round_cnt;
static struct xlog *xlog_mmc1_buf;
static int xlog_mmc1_buf_idx, xlog_mmc1_round_cnt;

static struct xlog *xlog_mmc0_key_buf;
static int xlog_mmc0_key_buf_idx, xlog_mmc0_key_round_cnt;
static struct xlog *xlog_mmc1_key_buf;
static int xlog_mmc1_key_buf_idx, xlog_mmc1_key_round_cnt;

struct xlog * xlog_pickup_buf(u8 mmc_idx)
{
	static struct xlog * log;
	unsigned long flags;

	local_irq_save(flags);
	if (mmc_idx == 0){
		log = & xlog_mmc0_buf[xlog_mmc0_buf_idx];
		xlog_mmc0_buf_idx++;
		if (xlog_mmc0_buf_idx >= XLOG_MMC0_BUF_LEN) {
			xlog_mmc0_buf_idx -= XLOG_MMC0_BUF_LEN;
			xlog_mmc0_round_cnt++;
		}
	} else {
		log = & xlog_mmc1_buf[xlog_mmc1_buf_idx];
		//if (xlog_mmc1_buf_idx == (XLOG_MMC1_BUF_LEN-2))
		//	return log;
		xlog_mmc1_buf_idx++;
		if (xlog_mmc1_buf_idx >= XLOG_MMC1_BUF_LEN) {
			xlog_mmc1_buf_idx -= XLOG_MMC1_BUF_LEN;
			xlog_mmc1_round_cnt++;
		}
	}
	local_irq_restore(flags);

	return log;
}

struct xlog * xlog_get_key_buf(u8 mmc_idx)
{
	static struct xlog * log;

	if (mmc_idx == 0){
		log = & xlog_mmc0_key_buf[xlog_mmc0_key_buf_idx];
		xlog_mmc0_key_buf_idx++;
		xlog_mmc0_key_buf_idx %= XLOG_MMC0_KEY_BUF_LEN;
		if (xlog_mmc0_key_buf_idx == 1)
			xlog_mmc0_key_round_cnt++;
	} else {
		log = & xlog_mmc1_key_buf[xlog_mmc1_key_buf_idx];
		//if (xlog_mmc1_key_buf_idx == (XLOG_MMC1_KEY_BUF_LEN-2))
		//	return log;
		xlog_mmc1_key_buf_idx++;
		xlog_mmc1_key_buf_idx %= XLOG_MMC1_KEY_BUF_LEN;
		if (xlog_mmc1_key_buf_idx == 1)
			xlog_mmc1_key_round_cnt++;
	}

	return log;
}

void xlog_mmc_cmd(u8 mmc_idx, u8 opcode, u32 arg, u32 blkCntSz, u32 cmdf)
{
	struct xlog * log;
/*
	if (opcode == 13)
		return ;
*/
#ifndef XLOG_MMC_ENABLE
	return ;
#endif

#ifndef XLOG_MMC_TF_CARD_SUPPORT
	if (mmc_idx == XLOG_MMC_TF_CARD_INDEX)
		return ;
#endif

#ifndef XLOG_MMC_WIFI_SUPPORT
	if (mmc_idx == XLOG_MMC_WIFI_INDEX)
		return ;
#endif

	log = xlog_pickup_buf(mmc_idx);

	log->type = XLOG_TYPE_TF_CMD;
	log->_jiffies = jiffies;

//	log->u.tf_c.mmc_idx = mmc_idx;
	log->opcode = opcode;
	log->u.tf_c.arg = arg;
	log->u.tf_c.blkcs = blkCntSz;		/* data block count and size */
	log->u.tf_c.cmdf = cmdf;			/* CMD reg flag */

}

void xlog_mmc_cmd_printk(struct xlog * log)
{
	xlog_tf_printk_cmd();
}

void xlog_mmc_reg(u8 mmc_idx)
{
	struct xlog * log;

#ifndef XLOG_MMC_ENABLE
	return ;
#endif

	log = xlog_pickup_buf(mmc_idx);

	log->type = XLOG_TYPE_TF_REG;
	log->_jiffies = jiffies;

	log->u.tf_r.p = 0;
	log->u.tf_r.flags = 0;
}

void xlog_mmc_reg_printk(struct xlog * log)
{
}

void xlog_mmc_status(u8 mmc_idx, u8 opcode, enum xlog_tf_status_type type, s32 err, u32 param1, u32 param2)
{
	struct xlog * log;
/*
	if (opcode == 13)
		return ;
*/
#ifndef XLOG_MMC_ENABLE
	return ;
#endif

#ifndef XLOG_MMC_TF_CARD_SUPPORT
	if (mmc_idx == XLOG_MMC_TF_CARD_INDEX)
		return ;
#endif

#ifndef XLOG_MMC_WIFI_SUPPORT
	if (mmc_idx == XLOG_MMC_WIFI_INDEX)
		return ;
#endif

	log = xlog_pickup_buf(mmc_idx);

	log->type = XLOG_TYPE_TF_STATUS;
	log->_jiffies = jiffies;

//	log->u.tf_s.mmc_idx = mmc_idx;
	log->opcode = opcode;
	log->u.tf_s.type = type;
	log->u.tf_s.err = err;
	log->u.tf_s.param1 = param1;
	log->u.tf_s.param2 = param2;

}

void xlog_mmc_status_printk(struct xlog * log)
{
	switch(log->u.tf_s.type){
		case XLOG_TF_STATUS_CMD_COMPLETE:
			xlog_tf_printk_status("CMD_COMPLETE, err=%d, p1=%08x, p2=%08x",
					log->u.tf_s.err, log->u.tf_s.param1, log->u.tf_s.param2);
			break;
		case XLOG_TF_STATUS_DATA_COMPLETE:
			xlog_tf_printk_status("DATA_COMPLETE, err=%d, p1=%08x, p2=%08x",
					log->u.tf_s.err, log->u.tf_s.param1, log->u.tf_s.param2);
			break;
		default:
			break;
	}
}

void xlog_mmc_log_save(u8 mmc_idx, u8 opcode, union xlog_content *xcontent, u32 is_key)
{
	struct xlog *log, *log_key;
	int i;

#ifndef XLOG_MMC_ENABLE
	return ;
#endif

#ifndef XLOG_MMC_TF_CARD_SUPPORT
	if (mmc_idx == XLOG_MMC_TF_CARD_INDEX)
		return ;
#endif

#ifndef XLOG_MMC_WIFI_SUPPORT
	if (mmc_idx == XLOG_MMC_WIFI_INDEX)
		return ;
#endif

	log = xlog_pickup_buf(mmc_idx);
	log->type = XLOG_TYPE_TF_LOG;
	log->_jiffies = jiffies;
	log->opcode = opcode;

	for (i = 0; i < ARRAY_SIZE(xcontent->cap); i++)
		log->u.cap[i] = xcontent->cap[i];

	if (is_key) {
		log_key = xlog_get_key_buf(mmc_idx);
		log_key->type = XLOG_TYPE_TF_LOG;
		log_key->_jiffies = log->_jiffies;
		log_key->opcode = opcode;

		for (i = 0; i < ARRAY_SIZE(xcontent->cap); i++)
			log_key->u.cap[i] = xcontent->cap[i];
	}

	return;
}

void xlog_mmc_log_printk(struct xlog * log)
{
	if (log->opcode < 64)
		xlog_tf_printk_log_op();
	else
		xlog_tf_printk_log();

	return;
}

void xlog_reset(u8 mmc_idx)
{

	if (mmc_idx == 0){
		xlog_mmc0_buf_idx = 0;
		mmc_printk("xlog_mmc0_round_cnt=%d", xlog_mmc0_round_cnt);
	} else {
		xlog_mmc1_buf_idx = 0;
		mmc_printk("xlog_mmc1_round_cnt=%d", xlog_mmc1_round_cnt);
	}
}

void xlog_print_all(u8 mmc_idx)
{
	struct xlog *buf, *log;
	int i, a, rnd_cnt, log_cnt;

	if (mmc_idx == 0){
		a = xlog_mmc0_buf_idx;
		buf = xlog_mmc0_buf;
		rnd_cnt = xlog_mmc0_round_cnt;
		log_cnt = (rnd_cnt > 0) ? XLOG_MMC0_BUF_LEN : a;
	} else {
		a = xlog_mmc1_buf_idx;
		buf = xlog_mmc1_buf;
		rnd_cnt = xlog_mmc1_round_cnt;
		log_cnt = (rnd_cnt > 0) ? XLOG_MMC1_BUF_LEN : a;
	}

	mmc_printk("MMC%d log count: %d rounds + %d\n", mmc_idx, rnd_cnt, a);

	for (i = 0; i < log_cnt; i++){
		log = &buf[i];
		if (i == a)
			mmc_printk("\n");
		mmc_printk("[%d/%d]", i, a);
		switch(log->type){
			case XLOG_TYPE_TF_CMD:
				xlog_mmc_cmd_printk(log);
				break;
			case XLOG_TYPE_TF_REG:
				xlog_mmc_reg_printk(log);
				break;
			case XLOG_TYPE_TF_LOG:
				xlog_mmc_log_printk(log);
				break;
			case XLOG_TYPE_TF_STATUS:
				xlog_mmc_status_printk(log);
				break;
			case XLOG_TYPE_TF_EXCEPTION:
				break;
			default:
				mmc_printk("[%d], type=%d, cap=%04x %04x %04x %04x", i, log->type, log->u.cap[0], log->u.cap[1], log->u.cap[2], log->u.cap[3]);
				break;
		}
	}

	if (mmc_idx == 0){
		a = xlog_mmc0_key_buf_idx;
		buf = xlog_mmc0_key_buf;
		rnd_cnt = xlog_mmc0_key_round_cnt - 1;
		log_cnt = (rnd_cnt > 0) ? XLOG_MMC0_KEY_BUF_LEN : a;
	} else {
		a = xlog_mmc1_key_buf_idx;
		buf = xlog_mmc1_key_buf;
		rnd_cnt = xlog_mmc1_key_round_cnt - 1;
		log_cnt = (rnd_cnt > 0) ? XLOG_MMC1_KEY_BUF_LEN : a;
	}

	mmc_printk("MMC%d keylog count: %d rounds + %d\n", mmc_idx, rnd_cnt, a);

	for (i = 0; i < log_cnt; i++){
		log = &buf[i];
		mmc_printk("[%d/%d]", i, a);
		switch(log->type){
			case XLOG_TYPE_TF_LOG:
				xlog_mmc_log_printk(log);
				break;
			default:
				mmc_printk("[%d], type=%d, cap=%04x %04x %04x %04x", i, log->type, log->u.cap[0], log->u.cap[1], log->u.cap[2], log->u.cap[3]);
				break;
		}
	}

}

int xlog_mmc_probe(int mmc_idx)
{
	if (mmc_idx == 0) {
		xlog_mmc0_buf = kmalloc(sizeof(struct xlog) * (XLOG_MMC0_BUF_LEN + XLOG_MMC0_KEY_BUF_LEN), GFP_KERNEL);
		if (xlog_mmc0_buf == NULL)
			return -ENOMEM;
		xlog_mmc0_key_buf = xlog_mmc0_buf + XLOG_MMC0_BUF_LEN;
	} else if (mmc_idx == 1) {
		xlog_mmc1_buf = kmalloc(sizeof(struct xlog) * (XLOG_MMC1_BUF_LEN + XLOG_MMC1_KEY_BUF_LEN), GFP_KERNEL);
		if (xlog_mmc1_buf == NULL)
			return -ENOMEM;
		xlog_mmc1_key_buf = xlog_mmc1_buf + XLOG_MMC1_BUF_LEN;
	}

	return 0;
}
/******************* usb log end **********************************/
