/*
 * Synopsys DesignWare Multimedia Card Interface driver
 *
 * Copyright (C) 2009 NXP Semiconductors
 * Copyright (C) 2009, 2010 Imagination Technologies Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/io.h>
#include <linux/irq.h>
#include <linux/platform_device.h>
#include <linux/slab.h>
#include <linux/delay.h>
#include <linux/device.h>
#include <linux/gpio.h>
#include <linux/mmc/host.h>
#include <linux/mmc/mmc.h>
//#include <linux/mmc/dw_mmc.h>
#include <linux/of.h>

#include <mach/zx29_mmc.h>
#include "dw_mmc.h"
#include "dw_mmc-pltfm.h"
#include <linux/interrupt.h>
#include <linux/clk.h>
#include <linux/clockchips.h>
#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
#include <mach/clk.h>
#include <linux/clk/zx29-clk.h>
#endif
#ifdef CONFIG_ARCH_ZX297510
#include <mach/clock.h>
#endif
#include <mach/iomap.h>
#include <mach/gpio.h>
//youchen@2024-06-20 add for lynq nv config begin
#include <lynq/lynq_ap_nv_cfg.h>
//youchen@2024-06-20 add for lynq nv config end

struct dw_mci *dw_mci_host_ptr[2];
volatile u8   mmc0_data1_flag = 0xff;
/* Started by AICoder, pid:u6c95fe12ad564314e1a081cb0286316caa77330 */
#define CONFIG_GPIO_FUNC(pin, config, pd_pu) \
do { \
    rc = zx29_gpio_config(pin, config); \
    if (rc) { \
        printk("mmc gpio" #pin " config err !rc = %d\n",  rc); \
    } \    
    zx29_gpio_pd_pu_set(pin, pd_pu); \
} while (0)

#define CONFIG_GPIO_GPIO(pin, config, pd_pu) \
	do { \
		rc = zx29_gpio_config(pin, config); \
		if (rc) { \
			printk("mmc gpio" #pin " config err !rc = %d\n",  rc); \
		} \
		zx29_gpio_set_direction(pin, GPIO_IN);\
		zx29_gpio_pd_pu_set(pin, pd_pu); \
	} while (0)

/* Ended by AICoder, pid:u6c95fe12ad564314e1a081cb0286316caa77330 */

static void dw_mci_rockchip_prepare_command(struct dw_mci *host, u32 *cmdr)
{
	*cmdr |= SDMMC_CMD_USE_HOLD_REG;
}

static const struct dw_mci_drv_data rockchip_drv_data = {
	.prepare_command	= dw_mci_rockchip_prepare_command,
};

#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
static void dw_mci_set_host(struct dw_mci*host, u8 val)
{
   u32 clkreg = 0;

	if(val)
	{
		clkreg = ioread32(ZX_SOC_SYS_BASE + 0x54);
		dsb();
		clkreg |=0x01;
		iowrite32(clkreg, ZX_SOC_SYS_BASE + 0x54);
	}
}
#endif

#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
#define MMC_ACLK "ahb_clk"
#endif
#ifdef CONFIG_ARCH_ZX297510
#define MMC_ACLK "apb_clk"
#endif
#define MMC_WCLK "work_clk"
#define MMC_CDCLK "cdet_clk"


static uint32_t dw_regoffset;
static ssize_t dw_regoffset_show(struct device *_dev,
			      struct device_attribute *attr, char *buf)
{
	struct dw_mci *host = dev_get_drvdata(_dev);

	return snprintf(buf, 16, "0x%08x\n", dw_regoffset);
}

static ssize_t dw_regoffset_store(struct device *_dev,
			       struct device_attribute *attr,
			       const char *buf, size_t count)
{
	struct dw_mci *host = dev_get_drvdata(_dev);

	 dw_regoffset = simple_strtoul(buf, NULL, 16);

	return count;
}

DEVICE_ATTR(dw_regoffset, S_IRUGO | S_IWUSR, dw_regoffset_show, dw_regoffset_store);

static ssize_t dw_regvalue_show(struct device *_dev,
			     struct device_attribute *attr, char *buf)
{
	struct dw_mci *host = dev_get_drvdata(_dev);
	uint32_t val;
	
	if(!host)
		return -EINVAL;

	val = __raw_readl(host->regs+dw_regoffset);

  	return snprintf(buf, 48, "Regoffset@0x%08x = 0x%08x\n", dw_regoffset, val);
}

static ssize_t dw_regvalue_store(struct device *_dev,
			      struct device_attribute *attr,
			      const char *buf, size_t count)
{
	struct dw_mci *host = dev_get_drvdata(_dev);
	uint32_t val = simple_strtoul(buf, NULL, 16);
	
	if(!host)
		return -EINVAL;

	__raw_writel(val, host->regs+dw_regoffset);

	return count;
}

DEVICE_ATTR(dw_regvalue, S_IRUGO | S_IWUSR, dw_regvalue_show, dw_regvalue_store);
void sd_io_config(u32 sd_index,bool active_flag)
{
	int rc = 0;

	struct dw_mci_board *brd;


	if((dw_mci_host_ptr[sd_index] != NULL)&&(sd_index == 0)){
		brd= dw_mci_host_ptr[sd_index]->pdata;

		if (dw_mci_host_ptr[sd_index]->quirks & DW_MCI_QUIRK_SDIO) {
			
			if(mmc0_data1_flag != active_flag){
				
				irq_set_irq_wake(brd->data1_irq,active_flag);
				mmc0_data1_flag = active_flag;
			}
		}
	}
	printk("%s, set active_flag=%d\n", __func__,active_flag);
	
	if(active_flag){
		if(sd_index == 0) {

			CONFIG_GPIO_FUNC(ZX29_GPIO_66, GPIO66_EMMC_CLK, IO_CFG_PULL_DOWN);			
			CONFIG_GPIO_FUNC(ZX29_GPIO_67, GPIO67_EMMC_CMD, IO_CFG_PULL_UP);		
			CONFIG_GPIO_FUNC(ZX29_GPIO_68, GPIO68_EMMC_DATA0, IO_CFG_PULL_UP);			
			CONFIG_GPIO_FUNC(ZX29_GPIO_69, GPIO69_EMMC_DATA1, IO_CFG_PULL_UP);			
			CONFIG_GPIO_FUNC(ZX29_GPIO_70, GPIO70_EMMC_DATA2, IO_CFG_PULL_UP); 					
			CONFIG_GPIO_FUNC(ZX29_GPIO_71, GPIO71_EMMC_DATA3, IO_CFG_PULL_UP); 
		}
		else if(sd_index == 1) {
			CONFIG_GPIO_FUNC(ZX29_GPIO_72, GPIO72_SD1_HOST_SDCLK, IO_CFG_PULL_DOWN);			
			CONFIG_GPIO_FUNC(ZX29_GPIO_73, GPIO73_SD1_CMD, IO_CFG_PULL_UP);			
			CONFIG_GPIO_FUNC(ZX29_GPIO_74, GPIO74_SD1_DATA0, IO_CFG_PULL_UP);			
			CONFIG_GPIO_FUNC(ZX29_GPIO_75, GPIO75_SD1_DATA1, IO_CFG_PULL_UP);
			CONFIG_GPIO_FUNC(ZX29_GPIO_76, GPIO76_SD1_DATA2, IO_CFG_PULL_UP);		
			CONFIG_GPIO_FUNC(ZX29_GPIO_77, GPIO77_SD1_DATA3, IO_CFG_PULL_UP);			
		}
		else
			printk("%s index error %d\n",__func__,sd_index);
	}
	else{
		if(sd_index == 0) {

			CONFIG_GPIO_GPIO(ZX29_GPIO_66, GPIO66_GPIO66, IO_CFG_PULL_DOWN);		
			CONFIG_GPIO_GPIO(ZX29_GPIO_67, GPIO67_GPIO67, IO_CFG_PULL_DOWN); 			
			CONFIG_GPIO_GPIO(ZX29_GPIO_68, GPIO68_GPIO68, IO_CFG_PULL_DOWN); 			
			CONFIG_GPIO_GPIO(ZX29_GPIO_69, GPIO69_GPIO69, IO_CFG_PULL_DOWN); 		
			CONFIG_GPIO_GPIO(ZX29_GPIO_70, GPIO70_GPIO70, IO_CFG_PULL_DOWN); 			
			CONFIG_GPIO_GPIO(ZX29_GPIO_71, GPIO71_GPIO71, IO_CFG_PULL_DOWN); 
		}
		else if(sd_index == 1) {
			CONFIG_GPIO_GPIO(ZX29_GPIO_72, GPIO72_GPIO72, IO_CFG_PULL_DOWN);		
			CONFIG_GPIO_GPIO(ZX29_GPIO_73, GPIO73_GPIO73, IO_CFG_PULL_DOWN);
			CONFIG_GPIO_GPIO(ZX29_GPIO_74, GPIO74_GPIO74, IO_CFG_PULL_DOWN);
			CONFIG_GPIO_GPIO(ZX29_GPIO_75, GPIO75_GPIO75, IO_CFG_PULL_DOWN); 		
			CONFIG_GPIO_GPIO(ZX29_GPIO_76, GPIO76_GPIO76, IO_CFG_PULL_DOWN);		
			CONFIG_GPIO_GPIO(ZX29_GPIO_77, GPIO77_GPIO77, IO_CFG_PULL_DOWN);					
		}
		else
			printk("%s index error %d\n",__func__,sd_index);

	}

}



int dw_mci_pltfm_register(struct platform_device *pdev,
			  const struct dw_mci_drv_data *drv_data)
{
	struct dw_mci *host;
	struct resource	*regs;
#ifdef CONFIG_ARCH_ZX297510
	struct resource *dmaChannel;
#endif
	struct clk *sdmmc_wclk;
	struct clk *sdmmc_aclk;
#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
	struct clk *sdmmc_cdclk;
#endif
	int rc = 0;

	host = devm_kzalloc(&pdev->dev, sizeof(struct dw_mci), GFP_KERNEL);
	if (!host)
		return -ENOMEM;

	regs = platform_get_resource(pdev, IORESOURCE_MEM, 0);
	if (!regs) {
		pr_err("%s: Failed to get_resource\n", __func__);
		return -ENXIO;
	}

	host->irq = platform_get_irq(pdev, 0);
	if (host->irq < 0) {
		pr_err("%s: Failed, invalid irq %u\n", __func__, host->irq);
		return host->irq;
	}
#ifdef CONFIG_MMC_ZX29_EDMAC
	  dmaChannel = platform_get_resource(pdev, IORESOURCE_DMA, 0);
     if (!dmaChannel){
		dev_err(&pdev->dev, "Unable to get zx29 dma resource\n");
	}
#endif

	host->drv_data = drv_data;
	host->dev = &pdev->dev;
	host->irq_flags = IRQF_TRIGGER_HIGH;
	host->pdata = pdev->dev.platform_data;
	host->host_id = pdev->id;
	dw_mci_host_ptr[host->host_id] = host;

	sdmmc_aclk = clk_get(&pdev->dev, MMC_ACLK);

	if (( NULL == sdmmc_aclk) || IS_ERR(sdmmc_aclk)) {
		pr_err("%s: Failed to get " MMC_ACLK ", %ld\n", __func__, ( NULL == sdmmc_aclk) ? 0l : PTR_ERR(sdmmc_aclk));
		return -ENXIO;
	}

	sdmmc_wclk = clk_get(&pdev->dev, MMC_WCLK);

	if (( NULL == sdmmc_wclk) || IS_ERR(sdmmc_wclk)) {
		pr_err("%s: Failed to get " MMC_WCLK ", %ld\n", __func__, ( NULL == sdmmc_wclk) ? 0l : PTR_ERR(sdmmc_wclk));
		return -ENXIO;
	}

#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
	sdmmc_cdclk = clk_get(&pdev->dev, MMC_CDCLK);
	if (( NULL == sdmmc_cdclk) || IS_ERR(sdmmc_cdclk)) {
		pr_err("%s: Failed to get " MMC_CDCLK ", %ld\n", __func__, ( NULL == sdmmc_cdclk) ? 0l : PTR_ERR(sdmmc_cdclk));
		return -ENXIO;
	}
#endif

	rc = clk_enable(sdmmc_aclk);
	if (rc) {
		pr_err("%s: Failed to enable sdmmc_aclk\n", __func__);
		return rc;
	}

	clk_set_rate(sdmmc_wclk, host->pdata->bus_hz);
	rc = clk_enable(sdmmc_wclk);
	if (rc) {
		pr_err("%s: Failed to enable sdmmc_wclk %u hz\n", __func__, host->pdata->bus_hz);
		return rc;
	}
	host->bus_hz = clk_get_rate(sdmmc_wclk);

#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
	rc = clk_enable(sdmmc_cdclk);
	if (rc) {
		pr_err("%s: Failed to enable sdmmc_cdclk\n", __func__);
		return rc;
	}
#endif

#ifdef CONFIG_ARCH_ZX297510
    host->pdata->init(0, NULL, NULL);
    host->channel_id_tx= dmaChannel->start;/*qihongfang add for dma channel*/
    host->channel_id_rx= dmaChannel->end;/*qihongfang add for dma channel*/
    host->sdmmc_addr = regs->start;
	host->regs = ioremap(regs->start, resource_size(regs));
#endif
#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
	host->regs = (void __iomem *)regs->start;
	if (IS_ERR(host->regs))
		return PTR_ERR(host->regs);

	if(host->host_id != 0) {
		dw_mci_set_host(host, true);
	}
#endif
	if(host->pdata->quirks & DW_MCI_QUIRK_AUTO_GATE) {
		int rv = clk_set_auto_gate(sdmmc_wclk, true);
		if (rv)
			pr_err("%s: Failed to enable auto gate of sdmmc_wclk\n", __func__);

		rv = clk_set_auto_gate(sdmmc_aclk, true);
		if (rv)
			pr_err("%s: Failed to enable auto gate of sdmmc_aclk\n", __func__);
	}else{
		int rv = clk_set_auto_gate(sdmmc_wclk, false);
		if (rv)
			pr_err("%s: Failed to disable auto gate of sdmmc_wclk\n", __func__);

		rv = clk_set_auto_gate(sdmmc_aclk, false);
		if (rv)
			pr_err("%s: Failed to disable auto gate of sdmmc_aclk\n", __func__);
	}


	platform_set_drvdata(pdev, host);

	pr_info("%s: host%u step 1 finish, reg addr %p\n", __func__, host->host_id, host->regs);
	
#if defined CONFIG_ARCH_ZX297520V3
	if(host->host_id == 0) {
			
#if ((defined CONFIG_AIC8800)||(defined CONFIG_AIC8800D80L))
		 sd_io_config(host->host_id,0);
#else
		rc=gpio_request(ZX29_GPIO_66,"sd0_clk");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_66, GPIO66_EMMC_CLK);
		rc=gpio_request(ZX29_GPIO_67,"sd0_cmd");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_67, GPIO67_EMMC_CMD);
		rc=gpio_request(ZX29_GPIO_68,"sd0_data0");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_68, GPIO68_EMMC_DATA0);
		rc=gpio_request(ZX29_GPIO_69,"sd0_data1");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_69, GPIO69_EMMC_DATA1);
		rc=gpio_request(ZX29_GPIO_70,"sd0_data2");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_70, GPIO70_EMMC_DATA2);
		rc=gpio_request(ZX29_GPIO_71,"sd0_data3");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_71, GPIO71_EMMC_DATA3);
#endif
	}
	else if(host->host_id == 1) {
		rc=gpio_request(ZX29_GPIO_72,"sd1_clk");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_72, GPIO72_SD1_HOST_SDCLK);
		rc=gpio_request(ZX29_GPIO_73,"sd1_cmd");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_73, GPIO73_SD1_CMD);
		rc=gpio_request(ZX29_GPIO_74,"sd1_data0");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_74, GPIO74_SD1_DATA0);
		rc=gpio_request(ZX29_GPIO_75,"sd1_data1");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_75, GPIO75_SD1_DATA1);
		rc=gpio_request(ZX29_GPIO_76,"sd1_data2");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_76, GPIO76_SD1_DATA2);
		rc=gpio_request(ZX29_GPIO_77,"sd1_data3");
		if(rc)
			BUG();
		zx29_gpio_config(ZX29_GPIO_77, GPIO77_SD1_DATA3);
#ifdef _USE_VEHICLE_DC_REF
		rc=gpio_request(ZX29_GPIO_85,"emmc_vcc_en");
		if(rc)
			printk("mmc: Get emmc VCC en gpio fail\n");
		
		zx29_gpio_config(ZX29_GPIO_85, GPIO85_GPIO85);
		zx29_gpio_output_data(ZX29_GPIO_85,GPIO_HIGH);
#endif
		
	}
#endif

	rc = device_create_file(&pdev->dev, &dev_attr_dw_regoffset);
	if (rc)
		dev_warn(host->dev,
			 "Unable to create sysfs attributes\n");

	rc = device_create_file(&pdev->dev, &dev_attr_dw_regvalue);
	if (rc)
		dev_warn(host->dev,
			 "Unable to create sysfs attributes\n");

	return dw_mci_probe(host);
}
EXPORT_SYMBOL_GPL(dw_mci_pltfm_register);

#ifdef CONFIG_PM_SLEEP
/*
 * TODO: we should probably disable the clock to the card in the suspend path.
 */
static int dw_mci_pltfm_suspend(struct device *dev)
{
	struct dw_mci *host = dev_get_drvdata(dev);
	
	if(!host)
		return -EINVAL;
	return dw_mci_suspend(host);
}

static int dw_mci_pltfm_resume(struct device *dev)
{
	struct dw_mci *host = dev_get_drvdata(dev);
	
	if(!host)
		return -EINVAL;
	return dw_mci_resume(host);
}
#else
#define dw_mci_pltfm_suspend	NULL
#define dw_mci_pltfm_resume	NULL
#endif /* CONFIG_PM_SLEEP */

SIMPLE_DEV_PM_OPS(dw_mci_pltfm_pmops, dw_mci_pltfm_suspend, dw_mci_pltfm_resume);
EXPORT_SYMBOL_GPL(dw_mci_pltfm_pmops);
#if 0
static const struct of_device_id dw_mci_pltfm_match[] = {
	{ .compatible = "snps,dw-mshc", },
	{ .compatible = "rockchip,rk2928-dw-mshc",
		.data = &rockchip_drv_data },
	{},
};
MODULE_DEVICE_TABLE(of, dw_mci_pltfm_match);
#endif
static int dw_mci_pltfm_probe(struct platform_device *pdev)
{
	const struct dw_mci_drv_data *drv_data = NULL;
#if 0
	const struct of_device_id *match;

	if (pdev->dev.of_node) {
		match = of_match_node(dw_mci_pltfm_match, pdev->dev.of_node);
		drv_data = match->data;
	}
#endif

#ifdef _USE_VEHICLE_DC
	//youchen@2024-06-20 add for lynq nv config
	if((0 == pdev->id && get_mmc0_enable() == 1) || (1 == pdev->id && get_mmc1_enable() == 1)){
		return dw_mci_pltfm_register(pdev, drv_data);
	}else
	{
		return 0;
	}
#else
	return dw_mci_pltfm_register(pdev, drv_data);
#endif
}

int dw_mci_pltfm_remove(struct platform_device *pdev)
{
	struct dw_mci *host = platform_get_drvdata(pdev);

#ifdef CONFIG_ARCH_ZX297510
	iounmap(host->regs);
#endif
	dw_mci_remove(host);
	return 0;
}
EXPORT_SYMBOL_GPL(dw_mci_pltfm_remove);

static struct platform_driver dw_mci_pltfm_driver = {
	.probe		= dw_mci_pltfm_probe,
	.remove		= dw_mci_pltfm_remove,
	.driver		= {
#if (defined CONFIG_ARCH_ZX297520V2)||(defined CONFIG_ARCH_ZX297520V3)
		.name		= "zx29_sd",
#if 0
		.of_match_table	= of_match_ptr(dw_mci_pltfm_match),
#endif
#endif
#ifdef CONFIG_ARCH_ZX297510
		.name		= "zx297510_sd",
#endif
		.pm		= &dw_mci_pltfm_pmops,
	},
};

module_platform_driver(dw_mci_pltfm_driver);

MODULE_DESCRIPTION("DW Multimedia Card Interface driver");
MODULE_AUTHOR("NXP Semiconductor VietNam");
MODULE_AUTHOR("Imagination Technologies Ltd");
MODULE_LICENSE("GPL v2");
