/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spi_nand.c
* File Mark:
* Description:
* Others:
* Version:
* Author:
* Date:

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/dma-mapping.h>
#include <linux/wait.h>
#include <linux/mutex.h>
#include <linux/slab.h>
#include <linux/mtd/mtd.h>
#include <linux/module.h>
#include <linux/clk.h>
#include <linux/err.h>
#include <linux/io.h>
#include <linux/ioport.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/wakelock.h>
//#include <linux/dev_info.h>
#include <linux/gpio.h>
//#include <mach/clk.h>
#include <mach/gpio.h>
#include <mach/spinlock.h>
#include <linux/soc/zte/pm/drv_idle.h>

#include "spi_nand.h"

struct mtd_info *mtd_fota;

static struct wake_lock nand_wake_lock;

extern struct mutex otpMutex;

#if SPI_NAND_DEBUG
#define spi_nand_debug(fmt,args...)    printk (fmt ,##args)
#else
#define spi_nand_debug(fmt,args...)
#endif
#define mtd_to_spi_nand(m) 		(struct spi_nand_info *)(((struct nand_chip *)(m->priv))->priv)

static int spi_nand_read_oob(struct mtd_info *mtd, struct nand_chip *chip,
                          int page, int sndcmd);

int g_cur_ecc_page_addr = 0;

#define __ECC_CHECK_SUPPORT__

#ifdef __ECC_CHECK_SUPPORT__
static void spi_nand_enable_ecc(struct mtd_info *mtd, int enable)
{
    int ret = 0;
    uint8_t feature = 0x0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;		

	ret = ctrl->get_feature(REG_FEATURE, &feature);
	if ( ret != 0 )
	{
		printk("[SPI-NAND][spi_fc_get_feature]\n");
		
	}

	if(enable)
		feature |= ECC_EN;
	else
		feature &= ~ECC_EN;		
	ret = ctrl->set_feature(REG_FEATURE, &feature);
	if ( ret != 0 )
	{
		printk("[SPI-NAND][spi_fc_set_feature]\n");
		
	}
}
#else
static void spi_nand_enable_ecc(struct mtd_info *mtd, int enable){}
#endif

/*******************************************************************************
 * Function:    spi_nand_read_byte
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint8_t spi_nand_read_byte(struct mtd_info *mtd)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
    uint8_t result = 0xff;

    if (spi_nand->buf.head < spi_nand->buf.tail)
    {
        result = spi_nand->buf.buf[spi_nand->buf.head++];
    }

    return result;
}

/*******************************************************************************
 * Function:    reset_buf
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void reset_buf(struct spi_nand_info *spi_nand)
{
    spi_nand->buf.head = spi_nand->buf.tail = 0;
}


/*******************************************************************************
 * Function:    write_byte_to_buf
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void write_byte_to_buf(struct spi_nand_info *spi_nand, uint8_t byte)
{
    BUG_ON(spi_nand->buf.tail >= SPI_NAND_BUF_SIZE);//sizeof(spi_nand->buf.buf));
    spi_nand->buf.buf[spi_nand->buf.tail++] = byte;
}


/*******************************************************************************
 * Function:    read_status
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void read_status(struct spi_nand_info *spi_nand)
{
    uint32_t status;
    status = 0X80;
    spi_nand_debug("[SPI-NAND][read_status]\n");
    write_byte_to_buf(spi_nand, status);
}

/*******************************************************************************
 * Function:    spi_nand_read_word
 * Description: nand_block_badУȡoobϢ(nand_chip->oob_poi)ǰ2ֽ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint16_t spi_nand_read_word(struct mtd_info *mtd)
{
    struct nand_chip *chip = mtd->priv;
    uint16_t result = 0x0;

    result = (uint16_t)(*(chip->oob_poi));
    result = result << 8;
    result |= (uint16_t)(*(chip->oob_poi + 1));

    return result;
}


/*******************************************************************************
 * Function:    spi_nand_select_chip
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_select_chip(struct mtd_info *mtd, int chip)
{
}


/*******************************************************************************
 * Function:    spi_nand_waitfunc
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_waitfunc(struct mtd_info *mtd, struct nand_chip *chip)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);

    int status = spi_nand->status;
    spi_nand->status = 0;

    return status;
}

/*******************************************************************************
 * Function:    spi_nand_get_real_page
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_get_real_page(struct mtd_info *mtd, int page)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;
	int die;

	if(spi_nand->para->die_num == 1)
		return page;

	die = page/spi_nand->pages_per_die;
	if(ctrl->switch_die(die))
		return -1;

	return (page-die*spi_nand->pages_per_die);
}

/*******************************************************************************
 * Function:    spi_nand_erase
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_erase(struct mtd_info *mtd, int page)
{
    int ret = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;	
	int real_page = spi_nand_get_real_page(mtd, page);

    spi_nand_debug("\n[SPI-NAND][spi_nand_erase][page] = 0x%0x\n", page);

	ret = ctrl->write_enable();
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_write_enable][ERROR]\n");
        
    }

    ret = ctrl->erase(real_page);
    if ( ret != 0 )
    {
        spi_nand->status = NAND_STATUS_FAIL;
        printk("[SPI-NAND][spi_nand_erase][NAND_STATUS_FAIL][ret] = %d\n", ret);
    }
    else
    {
        spi_nand->status = 0;
        spi_nand_debug("[SPI-NAND][spi_nand_erase][PASS]\n");
    }

	ret = ctrl->write_disable();
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_write_disable][ERROR]\n");
        
    }
}

/*******************************************************************************
 * Function:    spi_nand_cmdfunc
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_cmdfunc(struct mtd_info *mtd, unsigned int cmd, int col,
                          int page)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;

    switch (cmd)
    {
        case NAND_CMD_PAGEPROG:
            break;
        case NAND_CMD_STATUS:
            reset_buf(spi_nand);
            read_status(spi_nand);
            break;
        case NAND_CMD_READID:
        case NAND_CMD_PARAM:
			
            reset_buf(spi_nand);
            write_byte_to_buf(spi_nand, spi_nand->maf_id);
			printk("[SPI-NAND]:  maf_id = 0x%0x\n", spi_nand->maf_id);
            write_byte_to_buf(spi_nand, spi_nand->dev_id);
			printk("[SPI-NAND]:  dev_id = 0x%0x\n", spi_nand->dev_id);

            break;
        case NAND_CMD_READ0:
        case NAND_CMD_SEQIN:
            spi_nand->page = page;
            break;
        case NAND_CMD_RESET:
			ctrl->reset();
            break;
        case NAND_CMD_READOOB:
            reset_buf(spi_nand);      //zhouqi
            spi_nand_read_oob(mtd, mtd->priv, page, 0);
            /* TODO: Read OOB data */
            break;
        default:
            printk(": unsupported command"
                  " received 0x%x\n", cmd);
            break;
    }
}

/*******************************************************************************
 * Function:    spi_nand_ecc_calculate
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_ecc_calculate(struct mtd_info *mtd, const uint8_t *data,
                               uint8_t *ecc_code)
{
    printk("spi_nand_ecc_calculate called unexpectedly\n");
    
    return -1;
}


/*******************************************************************************
 * Function:    spi_nand_ecc_correct
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_ecc_correct(struct mtd_info *mtd, uint8_t *data,
                             uint8_t *read_ecc, uint8_t *calc_ecc)
{
    printk("spi_nand_ecc_correct called unexpectedly\n");
    
    return -1;
}


/*******************************************************************************
 * Function:    spi_nand_ecc_hwctl
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_ecc_hwctl(struct mtd_info *mtd, int mode)
{
    printk("spi_nand_ecc_hwctl called unexpectedly\n");
    
}


/*******************************************************************************
 * Function:    spi_nand_check_ecc
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_check_ecc(struct spi_nand_info *spi_nand, uint32_t *ecc)
{
    int ret = 0;
    uint8_t feature = 0x0;

    ret = spi_nand->ctrl->get_feature(REG_STATUS, &feature);

    spi_nand_debug("[SPI-NAND][check_ecc][feature] = 0x%0x (%d)\n", feature, ret);

    if ( ((feature>>ECC_ERR_BIT) & 0x3) == 2 )
    {
        /* printk("[SPI-NAND][REG_STATUS][ECC-ERROR]\n");*/
        *ecc = 1;		/* ecc error detect and no correct */
    }
    else
    {
        *ecc = 0;
    }

    return ret;
}

static int spi_nand_write(struct mtd_info *mtd, int raw, 
							const unsigned char *buf, unsigned char *oob_buf) 
{
	int ret = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;
	int page = spi_nand_get_real_page(mtd, spi_nand->page);
	unsigned int  column_offset = 0;
	
	ret = ctrl->write_enable();
	if ( ret != 0 )
	{
		printk("[SPI-NAND][spi_fc_write_enable][ERROR]\n");
		
	}

	if(buf)
    		memcpy((void*)spi_nand->buf.buf, buf, mtd->writesize);				
	else /* write oob */
		memset((uint8_t *)spi_nand->buf.buf, 0xFF, mtd->writesize);

	memcpy((void*)(spi_nand->buf.buf + mtd->writesize), oob_buf, mtd->oobsize);

	if((spi_nand->para->planes == 2) && (((page >> 6)%2) != 0))
	{
		column_offset |= (0x1 << 12);
	}
		
	dma_sync_single_for_device(spi_nand->dev, spi_nand->buf.dma_buf, (mtd->writesize + mtd->oobsize), DMA_BIDIRECTIONAL);	
	ret = ctrl->page_load(column_offset, (uint8_t *)spi_nand->buf.dma_buf, mtd->writesize, oob_buf, mtd->oobsize);	
	if ( ret != 0 )
	{
		printk("[SPI-NAND][spifc_page_load][ERROR]\n");
		
	}
	dma_sync_single_for_cpu(spi_nand->dev, spi_nand->buf.dma_buf, mtd->oobsize, DMA_BIDIRECTIONAL);

	ret = ctrl->program_exec(page);
	if ( ret != 0 )
	{
		spi_nand->status = NAND_STATUS_FAIL;
		printk("[SPI-NAND][spi_fc_program_exec][NAND_STATUS_FAIL][ret] = %d\n", ret);
		
	}
	else
	{
		spi_nand->status = 0;
		spi_nand_debug("[SPI-NAND][write_page][PASS]\n");
	}

	ret = ctrl->write_disable();
	if ( ret != 0 )
	{
		printk("[SPI-NAND][spi_fc_write_disable][ERROR]\n");
		
	}
	
	return ret;
}

/*******************************************************************************
 * Function:    spi_nand_write_page
 * Description:
 *
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_write_page(struct mtd_info *mtd, struct nand_chip *chip,
                             const uint8_t *buf, struct mtd_oob_ops *ops)
{
	spi_nand_write(mtd, false, buf, chip->oob_poi);
}

/*******************************************************************************
 * Function:    spi_nand_write_page_raw
 * Description: MTD Interface ʹ ECC, д MAIN + OOB
 *
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_nand_write_page_raw(struct mtd_info *mtd, struct nand_chip *chip,
                                 const uint8_t *buf)
{
	spi_nand_enable_ecc(mtd, false);
	spi_nand_write(mtd, true, buf, chip->oob_poi);
	spi_nand_enable_ecc(mtd, true);	
}

/*******************************************************************************
 * Function:    spi_nand_write_oob
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_write_oob(struct mtd_info *mtd, struct nand_chip *chip,
                           int page)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);

    spi_nand->page=page;
    
	return spi_nand_write(mtd, false, NULL, chip->oob_poi);
}

/*******************************************************************************
 * Function:    spi_nand_read_oob
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_read_oob(struct mtd_info *mtd, struct nand_chip *chip,
                          int page, int sndcmd)
{
    int ret = 0;
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;
	int real_page = spi_nand_get_real_page(mtd, page);
	unsigned int  column_offset = mtd->writesize;
	
    spi_nand_debug("[SPI-NAND][spi_nand_read_oob][page] = 0x%0x\n", page);

    ret = ctrl->read_page_to_cache(real_page);
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_read_page_to_cache]\n");
        
    }
	if((spi_nand->para->planes == 2) && (((real_page >> 6)%2) != 0))
	{
		column_offset |= (0x1 << 12);
	}
	
	dma_sync_single_for_device(spi_nand->dev, spi_nand->buf.dma_buf, mtd->oobsize, DMA_BIDIRECTIONAL);	
    ret = ctrl->read_from_cache(column_offset, mtd->oobsize, (uint8_t *)spi_nand->buf.dma_buf);
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_read_page_to_cache]\n");
        
    }

	dma_sync_single_for_cpu(spi_nand->dev, spi_nand->buf.dma_buf, mtd->oobsize, DMA_BIDIRECTIONAL);	
    memcpy(chip->oob_poi, (void*)(spi_nand->buf.buf), mtd->oobsize);

    return 0;
}


/*******************************************************************************
 * Function:    spi_nand_read_page
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_read_page(struct mtd_info *mtd, struct nand_chip *chip,
                           uint8_t *buf, /*int oob_required,*/int page, struct mtd_oob_ops *ops)
{
    int ret = 0;
    uint32_t ecc = 0;
	uint8_t feature = (ECC_EN|QE);
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;
	int real_page; 
	unsigned int  column_offset = 0;
	
    spi_nand_debug("[SPI-NAND][spi_nand_read_page][page] = 0x%0x\n", page);

    if (page != spi_nand->page)
    {
        printk("IN %s: page %d is not"
              " equal to denali->page %d, investigate!!",
              __func__, page, spi_nand->page);
        
    }

	/*check ecc enable*/
	/*
	ctrl->get_feature(REG_FEATURE, &feature);
	if(!(feature & ECC_EN))
	{
		printk("[SPI-NAND] read page 0x%x while ecc is disable!,feature is 0x%x\n",page,feature);
		//BUG_ON(1);
	}*/

	real_page = spi_nand_get_real_page(mtd, page);

    ret = ctrl->read_page_to_cache(real_page);
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_read_page_to_cache]\n");
        
    }

    ret = spi_nand_check_ecc(spi_nand, &ecc);
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_nand_check_ecc]\n");
        
    }
	
    if ( ecc != 0 && (chip->ops.mode != MTD_OPS_RAW))
    {
		g_cur_ecc_page_addr = real_page*mtd->writesize;
#ifdef __ECC_CHECK_SUPPORT__
		mtd->ecc_stats.failed++;
        printk("ecc_stats.failed++\n");
#endif
    }
	if((spi_nand->para->planes == 2) && (((real_page >> 6)%2) != 0))
	{
		column_offset |= (0x1 << 12);
	}
	
	dma_sync_single_for_device(spi_nand->dev, spi_nand->buf.dma_buf, (mtd->writesize + mtd->oobsize), DMA_BIDIRECTIONAL);
    ret = ctrl->read_from_cache(column_offset, (mtd->writesize + mtd->oobsize), (uint8_t *)spi_nand->buf.dma_buf);
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_read_page_to_cache]\n");
        
    }

	dma_sync_single_for_cpu(spi_nand->dev, spi_nand->buf.dma_buf, (mtd->writesize + mtd->oobsize), DMA_BIDIRECTIONAL);
    memcpy(buf, (void*)spi_nand->buf.buf, mtd->writesize);
    memcpy(chip->oob_poi, (void*)(spi_nand->buf.buf + mtd->writesize), mtd->oobsize);

    return 0;
}

/*******************************************************************************
 * Function:    spi_nand_read_page_raw
 * Description: ʹECCȡ MAIN + OOB
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spi_nand_read_page_raw(struct mtd_info *mtd, struct nand_chip *chip,
				uint8_t *buf, int page)
{
	int ret = 0;
	
	spi_nand_enable_ecc(mtd, false);
	ret =  spi_nand_read_page(mtd, chip, buf, page, NULL);
	spi_nand_enable_ecc(mtd, true);

	return ret;
}

#define ECC_4BITS   32
static uint8_t bbt_pattern[] = {'B', 'b', 't', '0' };
static uint8_t mirror_pattern[] = {'1', 't', 'b', 'B' };

static struct nand_bbt_descr bbt_main_descr =
{
    .options = NAND_BBT_LASTBLOCK | NAND_BBT_CREATE | NAND_BBT_WRITE
    | NAND_BBT_2BIT | NAND_BBT_VERSION | NAND_BBT_PERCHIP,
    .offs = 4,
    .len = 4,
    .veroffs = 20,
    .maxblocks = 12,
    .pattern = bbt_pattern,
};


static struct nand_bbt_descr bbt_mirror_descr =
{
    .options = NAND_BBT_LASTBLOCK | NAND_BBT_CREATE | NAND_BBT_WRITE
    | NAND_BBT_2BIT | NAND_BBT_VERSION | NAND_BBT_PERCHIP,
    .offs = 4,
    .len = 4,
    .veroffs = 20,
    .maxblocks = 12,
    .pattern = mirror_pattern,
};

int spi_nand_common_init(struct spi_nand_info *spi_nand)//SUNZHAOXING
{   
    int ret = SUCCESS;
    char feature = 0x0;
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;		

    feature = 0x0;
    ret = ctrl->set_feature(REG_PROTECTION, &feature);
    if( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_set_feature]\n");
        
    }

    ctrl->get_feature(REG_PROTECTION, &feature);
    
    printk("[SPI-NAND][A0] = 0x%0x\n", feature);

    /*
    * enable ecc nand Quad mode
    */

	feature= 0;
    feature = (ECC_EN|QE);
	//feature = ECC_EN;
	
	/*micron 4G flash*/
    if((spi_nand->maf_id == 0x2c) && (spi_nand->dev_id == 0x35))
    {
        /*continute_readλ0*/
		feature &= ~(1<<0);
	}
	
    ret = ctrl->set_feature(REG_FEATURE, &feature);
    if ( ret != 0 )
    {
        printk("[SPI-NAND][spi_fc_set_feature]\n");
        
    }

	ctrl->get_feature(REG_FEATURE, &feature);
    
    printk("[SPI-NAND][B0] = 0x%0x\n", feature);

	return 0;
}

void zx_denali_nand_lock(void)
{    	
	mutex_lock(&otpMutex);	
	soft_spin_lock(NAND_SFLOCK);
}

void zx_denali_nand_unlock(void)
{   	
	soft_spin_unlock(NAND_SFLOCK); 	
	mutex_unlock(&otpMutex);
}

void denali_nand_lock(struct mtd_info *mtd)
{    
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;

    wake_lock(&nand_wake_lock);
	zx_cpuidle_set_busy(IDLE_FLAG_FLASH);
	soft_spin_lock(NAND_SFLOCK);
	mutex_lock(&otpMutex);

	ctrl->lock();
}
void denali_nand_unlock(struct mtd_info *mtd)
{
    struct spi_nand_info *spi_nand = mtd_to_spi_nand(mtd);
	struct spi_nand_ctrl_ops *ctrl = spi_nand->ctrl;

	ctrl->unlock();	

	mutex_unlock(&otpMutex);
    soft_spin_unlock(NAND_SFLOCK);
	zx_cpuidle_set_free(IDLE_FLAG_FLASH);
	wake_unlock(&nand_wake_lock);//NEED CHECK
}

int spi_nand_register(struct spi_nand_info *spi_nand, struct spi_nand_ctrl_ops *ctrl)
{
	int ret = 0;
	struct mtd_info *	mtd;
	struct nand_chip *	chip;

	mtd  = &spi_nand->mtd;
	chip = &spi_nand->nand;

	mtd->name = "spi-nand";
	mtd->owner = THIS_MODULE;
	mtd->priv = chip;
	
	chip->priv = spi_nand;
	spi_nand->ctrl = ctrl;

	/* register the driver with the NAND core subsystem */
	chip->select_chip 	= spi_nand_select_chip;
	chip->cmdfunc 		= spi_nand_cmdfunc;
	chip->read_byte 	= spi_nand_read_byte;
	chip->read_word 	= spi_nand_read_word;
	chip->waitfunc 		= spi_nand_waitfunc;

	/* scan for NAND devices attached to the controller
	 * this is the first stage in a two step process to register
	 * with the nand subsystem */
	wake_lock_init(&nand_wake_lock, WAKE_LOCK_SUSPEND, "nand");
	printk("spi_nand wakelock ok\n");
	if (nand_scan_ident(mtd, spi_nand->max_banks, NULL))
	{
		return -ENXIO;
	}

	/* MTD supported page sizes vary by kernel. We validate our
	 * kernel supports the device here.
	 */
	if (mtd->writesize > NAND_MAX_PAGESIZE) {
		printk(KERN_ERR "Spectra: device size not supported by this "
			"version of MTD.");
		return -ENODEV;
		
	}

	spi_nand->devnum = 1;
	chip->pagemask = ((chip->chipsize) >> chip->page_shift) - 1;
	spi_nand->bbtskipbytes = 0x2;

	chip->chipsize <<= (spi_nand->devnum - 1);
	chip->page_shift += (spi_nand->devnum - 1);
	/*chip->pagemask = (chip->chipsize >> chip->page_shift) - 1;*/
	chip->bbt_erase_shift += (spi_nand->devnum - 1);
	chip->phys_erase_shift = chip->bbt_erase_shift;
	chip->chip_shift += (spi_nand->devnum - 1);
	mtd->writesize <<= (spi_nand->devnum - 1);
	mtd->oobsize <<= (spi_nand->devnum - 1);
	mtd->erasesize <<= (spi_nand->devnum - 1);
	mtd->size = chip->numchips * chip->chipsize;
	spi_nand->bbtskipbytes *= spi_nand->devnum;

	/* Bad block management */
	chip->bbt_td = &bbt_main_descr;
	chip->bbt_md = &bbt_mirror_descr;

	/* skip the scan for now until we have OOB read and write support */
	chip->bbt_options |= NAND_BBT_USE_FLASH;
	chip->ecc.mode = NAND_ECC_HW_SYNDROME;
	
	/* Denali Controller only support 15bit and 8bit ECC in MRST,
	 * so just let controller do 15bit ECC for MLC and 8bit ECC for
	 * SLC if possible.
	 * */

	chip->ecc.strength = 4;
	chip->ecc.bytes = ECC_4BITS;
	chip->ecc.bytes *= spi_nand->devnum;
	chip->ecc.strength *= spi_nand->devnum;

	/* Let driver know the total blocks number and
	 * how many blocks contained by each nand chip.
	 * blksperchip will help driver to know how many
	 * blocks is taken by FW.
	 * */
	spi_nand->totalblks = mtd->size >> chip->phys_erase_shift;
	spi_nand->blksperchip = spi_nand->totalblks / chip->numchips;

	/* These functions are required by the NAND core framework, otherwise,
	 * the NAND core will assert. However, we don't need them, so we'll stub
	 * them out. */
	chip->ecc.calculate = spi_nand_ecc_calculate;
	chip->ecc.correct = spi_nand_ecc_correct;
	chip->ecc.hwctl = spi_nand_ecc_hwctl;

	/* override the default read operations */
	chip->ecc.size 			= 512;
	chip->ecc.read_page 	= spi_nand_read_page;
	chip->ecc.read_page_raw = spi_nand_read_page_raw;
	chip->ecc.write_page 	= spi_nand_write_page;
	chip->ecc.write_page_raw = spi_nand_write_page_raw;
	chip->ecc.read_oob 		= spi_nand_read_oob;
	chip->ecc.write_oob 	= spi_nand_write_oob;
	chip->erase_cmd 		= spi_nand_erase;

	/* remove spi nand chip write protection  */
	spi_nand_common_init(spi_nand);
	spi_nand_special_init(spi_nand);

	if (nand_scan_tail(mtd)) {
		return -ENXIO;
	}
	
	mtd_fota = mtd;
	
	ret = mtd_device_register(mtd, NULL, 0);
	if (ret) {
		dev_err(spi_nand->dev, "Spectra: Failed to register MTD: %d\n",
				ret);
	}

	return ret;
}

