/*
 * Copyright (C) 2016-2017 ZXIC
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING. If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Get MTD device info.
 *
 */

#include <linux/init.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/err.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <linux/mtd/nand.h>
#include <linux/slab.h>
#include <linux/sched.h>

#define PRINT_PREF KERN_INFO "mtd_zftltest: "

static int dev = -EINVAL;
module_param(dev, int, S_IRUGO);
MODULE_PARM_DESC(dev, "MTD device number to use");

static struct mtd_info *mtd;
static unsigned char *iobuf;
static unsigned char *iobuf1;
static unsigned char *bbt;
static int ebcnt;

#if 1
int nand_SmsRead(int dwStart, int dwLen, char* to){return 0;}
int nand_SmsProgram(int dwStart, int dwLen, char* from){return 0;}
#else
extern int nand_SmsRead(int dwStart, int dwLen, char* to);
extern int nand_SmsProgram(int dwStart, int dwLen, char* from);
#endif
/***
 ***	1. read
 ***	2. change and write
 ***	3. read and compare
 ***
 */
static int __init mtd_zftltest_init(void)
{
	int err = 0;
	int i;
	int block_cnt, block;
	int ecc_cap;
	uint64_t tmp;	
	
	pr_info("\n");
	pr_info("=================================================\n");

	printk(PRINT_PREF "MTD device: %d\n", dev); 

	mtd = get_mtd_device(NULL, dev);
	if (IS_ERR(mtd)) {
		err = PTR_ERR(mtd);
		printk(PRINT_PREF "error: Cannot get MTD device\n");
		return err;
	}

	if (mtd->writesize == 1) {
		printk(PRINT_PREF "not NAND flash, assume page size is 512 "
			   "bytes.\n");
	} 

	tmp = mtd->size;
	do_div(tmp, mtd->erasesize);
	ebcnt = tmp;

	err = -ENOMEM;
	iobuf = kmalloc(mtd->erasesize, GFP_KERNEL);
	if (!iobuf) {
		printk(PRINT_PREF "error: cannot allocate memory\n");
		goto out;
	}
	iobuf1 = kmalloc(mtd->erasesize, GFP_KERNEL);
	if (!iobuf1) {
		printk(PRINT_PREF "error: cannot allocate memory\n");
		goto out;
	}


	/* read zftl */
	err = nand_SmsRead(0, 0x100, iobuf);
	if(err)
	{
		pr_info("read zftl data error(%d)\n", err); 	
		goto out;
	}

	/* change and write */	
	memset(iobuf1, 0x5a, 0x100);
	err = nand_SmsProgram(0, 0x100, iobuf1);
	if(err)
	{
		pr_info("read zftl data error(%d)\n", err); 	
		goto out;
	}

	/* read and compare */	
	err = nand_SmsRead(0, 0x100, iobuf+0x100);
	if(err)
	{
		pr_info("read zftl data error(%d)\n", err); 	
		goto out;
	}
	
	if(0 != memcmp(iobuf+0x100, iobuf1, 0x100))
	{
		pr_info(" zftl data compare err!\n");
		goto out;
	}	
	else
		printk(PRINT_PREF "Compare data success!\n");
		
	if (err)
		printk(PRINT_PREF "finished with errors\n");
	else
		printk(PRINT_PREF "finished\n");

out:
	kfree(iobuf);
	kfree(iobuf1);
	kfree(bbt);
	put_mtd_device(mtd);
	if (err)
		printk(PRINT_PREF "error %d occurred\n", err);
	printk(KERN_INFO "=================================================\n");
	return err;

}

module_init(mtd_zftltest_init);

static void __exit mtd_zftltest_exit(void)
{
	return;
}
module_exit(mtd_zftltest_exit);

MODULE_DESCRIPTION("Nand ecc test module");
MODULE_AUTHOR("ZXIC");
MODULE_LICENSE("GPL");
