/*********************************************************************
 Copyright 2013 by  ZTE Corporation.
 *
 * FileName::    nand_interface.c
 * File Mark:
* Description:  
* Others:
* Version:  	v1.0
* Author:  	zhouqi
* Date:  	2013-3-12

* History 1:
**********************************************************************/
/**************************************************************************
 *                                Include files
 **************************************************************************/
 #include <linux/mtd/mtd.h>
 #include <linux/slab.h>
 #include <linux/module.h>
 #include <linux/mtd/nand_linux_interface.h>
#include <linux/cp_types.h>

/****************************************************************************
* 	                               Local Types
****************************************************************************/

/****************************************************************************
* 	                               Local Function Prototypes
****************************************************************************/
 extern int nand_NvProgram(int dwStart, int dwLen, char* from);
 extern int nand_NvRead(int dwStart, int dwLen, char* to);
 extern int zftl_wrapper_write(char *part_name, int dwStart, int dwLen, char* from);
 extern int zftl_wrapper_read(char *part_name, int dwStart, int dwLen, char* to);

#ifndef USE_CPPS_KO
extern UINT32 zOss_NvItemWrite(UINT32 NvItemID, UINT8 * NvItemData, UINT32 NvItemLen);
extern UINT32 zOss_NvItemRead(UINT32 NvItemID, UINT8 * NvItemData, UINT32 NvItemLen);
#endif
 
/****************************************************************************
* 	                               Global Constants
****************************************************************************/

/****************************************************************************
* 	                               Global Variables
****************************************************************************/
extern struct mtd_info *mtd_fota;
extern int g_zload_read_only_flag;


/****************************************************************************
* 	                               Function Definitions
****************************************************************************/

 /**************************************************************************
* Function: nand_nv_mid_nv_r_set_to_rw
* Description:  NV_RֻΪɶд
* Parameters:
*   Input:
*              
*   Output: None
* Returns:
*	        
*             
* Others:   ĬֵΪ    0x0  ֻ
                        0x1  д
**************************************************************************/
/*zdd need modify*/
int zDrvNand_ChangeNvrAttr( unsigned int rw )
{
    int ret = 0;
 //   ret = nand_nv_mid_r_set_to_rw(rw);
	return ret;
}
EXPORT_SYMBOL(zDrvNand_ChangeNvrAttr);

#ifndef CONFIG_SYSTEM_RECOVERY
 
/**************************************************************************
* Function: zDrvNand_Read
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: nv ȡӿڣdwStart ַΪ0~5Mַ
**************************************************************************/
int zDrvNand_Read(unsigned int dwStart, unsigned int dwLen, char* to)
{
    int ret = 0;

#ifdef USE_CPPS_KO
		ret = cpps_callbacks.zOss_NvItemRead(dwStart, to, dwLen);
#else
		ret = zOss_NvItemRead(dwStart, to, dwLen);
#endif

	return ret;
}
EXPORT_SYMBOL(zDrvNand_Read);

/**************************************************************************
* Function: zDrvNand_Program
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: nv дӿڣdwStart ַΪ1~5Mַ
**************************************************************************/
int zDrvNand_Program(unsigned int dwStart, unsigned int dwLen, char* from)
{
    int ret = 0;

#ifdef USE_CPPS_KO
	ret = cpps_callbacks.zOss_NvItemRead(dwStart, from, dwLen);
#else
	ret = zOss_NvItemRead(dwStart, from, dwLen);
#endif

	return ret;
}
EXPORT_SYMBOL(zDrvNand_Program);

#endif /* CONFIG_SYSTEM_RECOVERY */

/**************************************************************************
* Function: zDrvNand_SmsRead
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: nv ȡӿڣdwStart ַΪ0~1Mַ
**************************************************************************/
/*zdd need modify*/
int zDrvNand_SmsRead(unsigned int dwStart, unsigned int dwLen, char* to)
{
    int ret = 0;

	ret = zftl_wrapper_read((char *)"sms", dwStart, dwLen, to);
    
	return ret;
}
EXPORT_SYMBOL(zDrvNand_SmsRead);

/**************************************************************************
* Function: zDrvNand_SmsProgram
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: nv дӿڣdwStart ַΪ0~1Mַ
**************************************************************************/
/*zdd need modify*/
int zDrvNand_SmsProgram(unsigned int dwStart, unsigned int dwLen, char* from)
{
    int ret = 0;

	ret = zftl_wrapper_write((char *)"sms", dwStart, dwLen, from);

	return ret;
}
EXPORT_SYMBOL(zDrvNand_SmsProgram);

/**************************************************************************
* Function: zDrvNand_NvfacRead
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: nv ȡӿڣdwStart ַΪ0~1Mַ
**************************************************************************/
/*zdd need modify*/
int zDrvNand_NvfacRead(unsigned int dwStart, unsigned int dwLen, char* to)
{
    int ret = 0;

	ret = zftl_wrapper_read((char *)"nvfac", dwStart, dwLen, to);
    
	return ret;
}
EXPORT_SYMBOL(zDrvNand_NvfacRead);

/**************************************************************************
* Function: zDrvNand_NvfacProgram
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: nv дӿڣdwStart ַΪ0~1Mַ
**************************************************************************/
/*zdd need modify*/
int zDrvNand_NvfacProgram(unsigned int dwStart, unsigned int dwLen, char* from)
{
    int ret = 0;

	ret = zftl_wrapper_write((char *)"nvfac", dwStart, dwLen, from);

	return ret;
}
EXPORT_SYMBOL(zDrvNand_NvfacProgram);

/*zdd need modify*/
int zDrvNand_SimNvRead(unsigned int dwStart, unsigned int dwLen, char* to)
{
    int ret = 0;
#if 0//fyi  
    NAND_LOCK
	nand_clk_gate(SYSCLK_ENABLE);
    ret = nand_simnv_read(dwStart, dwLen, to);
	nand_clk_gate(SYSCLK_DISABLE);
	NAND_UNLOCK

	if(ret == -1)
	{
		zftl_res = 1;
		zDrvNand_SetSimNvFlag(dwStart);/*ECC REBOOT*/
		zftl_res = 0;
	}
#endif
	ret = zftl_wrapper_read((char *)"simnv", dwStart, dwLen, to);

	return ret;
}
EXPORT_SYMBOL(zDrvNand_SimNvRead);

/*zdd need modify*/
int zDrvNand_SimNvProgram(unsigned int dwStart, unsigned int dwLen, char* from)
{
    int ret = 0;
#if 0//fyi     
    NAND_LOCK
	nand_clk_gate(SYSCLK_ENABLE);
    ret = nand_simnv_program(dwStart, dwLen, from);
	nand_clk_gate(SYSCLK_DISABLE);
	NAND_UNLOCK
	if(ret == -1)
	{
		zftl_res = 1;
		zDrvNand_SetSimNvFlag(dwStart);/*ECC REBOOT*/
		zftl_res = 0;
	}
#endif
	ret = zftl_wrapper_write((char *)"simnv", dwStart, dwLen, from);

	return ret;
}
EXPORT_SYMBOL(zDrvNand_SimNvProgram);

/*zdd need modify*/
int zDrvNand_SimNvFacRead(unsigned int dwStart, unsigned int dwLen, char* to)
{
    int ret = 0;
#if 0//fyi     
    NAND_LOCK
	nand_clk_gate(SYSCLK_ENABLE);
    ret = nand_simnvfac_read(dwStart, dwLen, to);
	nand_clk_gate(SYSCLK_DISABLE);
	NAND_UNLOCK
#endif
	ret = zftl_wrapper_read((char *)"simnvfac", dwStart, dwLen, to);

	return ret;
}
EXPORT_SYMBOL(zDrvNand_SimNvFacRead);

/*zdd need modify*/
int zDrvNand_SimNvFacProgram(unsigned int dwStart, unsigned int dwLen, char* from)
{
    int ret = 0;
#if 0//fyi  
    NAND_LOCK
	nand_clk_gate(SYSCLK_ENABLE);
    ret = nand_simnvfac_program(dwStart, dwLen, from);
	nand_clk_gate(SYSCLK_DISABLE);
	NAND_UNLOCK
#endif
	ret = zftl_wrapper_write((char *)"simnvfac", dwStart, dwLen, from);

	return ret;
}
EXPORT_SYMBOL(zDrvNand_SimNvFacProgram);

/**************************************************************************
* Function: zDrvNand_NvRwEccMake
* Description: 
* Parameters:
*   Input:
*              
*   Output: None
* Returns:       0: ȷ
              : 
*	        
*             
* Others: 
**************************************************************************/
int zDrvNand_NvRwEccMake(unsigned int dwStart, unsigned int dwLen)
{
    char buffer[2048];
	
	//if( dwStart >= NVRW_SIZE||dwStart < 0 || (dwStart +dwLen)> NVRW_SIZE|| dwLen > 2048)
   //     return -1;
//fyi	nand_nvrw_mid_ecc_make(dwStart,dwLen,buffer);
	return 0;
}
EXPORT_SYMBOL(zDrvNand_NvRwEccMake);

int zDrvNand_EccMake(char* partName,unsigned int dwStart, unsigned int dwLen)
{
	return 0;
}
EXPORT_SYMBOL(zDrvNand_EccMake);

/**************************************************************************
* Function: nand_ReadID
* Description: get flash ID
* Parameters:
*   Input:
*              pbyDevice: pointer of flash ID structure
*   Output: None
* Returns:
*	        NAND_OK: success
*             1: error
* Others: ļϵͳӿڣʱȲʵ 2013.5.7
**************************************************************************/
int nand_ReadID(T_ZDrvNand_DeviceID *pbyDevice)
{
    return 0;
}
EXPORT_SYMBOL(nand_ReadID);

/**************************************************************************
* Function: zDrvNand_PartRead
* Description:read nand base partition.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
int zDrvNand_PartRead(char* part_name,unsigned int offset,unsigned int size,char* buffer)
{
	return 0;
}
EXPORT_SYMBOL(zDrvNand_PartRead);

/**************************************************************************
* Function: zDrvNand_PartGetSize
* Description:get nand partition size.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
unsigned int zDrvNand_PartGetSize(char* part_name)
{
	return 0;
}
EXPORT_SYMBOL(zDrvNand_PartGetSize);

/*******************************************************************************
 * Function:  zDrvNand_ReadBootflag
 * Description: read the bootflag of zx297510
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 0: open dl usb
 *          1: close dl usb
 *
 * Others: 0xffffffff_ffffffff: USB DL; 
 *         "ZTE7510\0"        : NO USB DL
 ********************************************************************************/
unsigned int zDrvNand_ReadBootflag( void )
{
    unsigned int bootflag = 0;
	
	char value = 0;
    int retlen = 0;
    
    unsigned char *buffer = kmalloc((mtd_fota->writesize + mtd_fota->oobsize), GFP_KERNEL);
    if( buffer == NULL )
        return -1;

    if(mtd_read(mtd_fota,0,mtd_fota->writesize,&retlen,buffer))/* BOOTFLAGnandĵ20~27ֽ */
    {
        kfree(buffer);
        return 1;
    }
	memcpy(&value, buffer+2, 1); 
	bootflag = value;
   
    if( bootflag == 0x5a)
    {
        bootflag = 1;
    }
	else
	{
        bootflag = 0;
	}
    kfree(buffer);

	return bootflag;
}
EXPORT_SYMBOL(zDrvNand_ReadBootflag);

/*******************************************************************************
 * Function:  zDrvNand_WriteBootflag
 * Description: write the bootflag of zx297510
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns:0 success
 *         1 fail
 *
 *
 * Others: 0xffffffff_ffffffff: USB DL; 
 *         "ZTE7510\0"        : NO USB DL
 ********************************************************************************/
unsigned int zDrvNand_WriteBootflag( unsigned int flag )
{

    unsigned int ret = 0;
    char oob[256];
	char value = 0;
	int bootflag = 0;
	int times = 0;
	int retlen = 0;
    struct erase_info ei;
	
    unsigned char *buffer = kmalloc(4*(mtd_fota->writesize + mtd_fota->oobsize), GFP_KERNEL);

    if( buffer == NULL )
        return -1;

    if(mtd_read(mtd_fota,0,6 * mtd_fota->writesize,&retlen,buffer))/* BOOTFLAGnandĵ20~27ֽ */
    {
        kfree(buffer);
        return -1;
    }
	if(flag == 0 )
	{
	    bootflag = 0x00;
        memset(&value, bootflag, 1);
	}
    else
    {
        bootflag = 0x5a;
        memset(&value, bootflag, 1);
    }
	
    memcpy(buffer+2, &value, 1);
    memset(&ei, 0, sizeof(struct erase_info));
    ei.mtd  = mtd_fota;
    ei.addr = 0;
    ei.len  = mtd_fota->erasesize;
	g_zload_read_only_flag = 1;
    ret = mtd_erase(mtd_fota, &ei);                  /*һ*/
	ret = mtd_write(mtd_fota,0,6* mtd_fota->writesize,&retlen,buffer);
	g_zload_read_only_flag = 0;
    kfree(buffer);

    return 0;

}
EXPORT_SYMBOL(zDrvNand_WriteBootflag);

/*******************************************************************************
 * Function:  zDrvNand_ReadUsbtimeout
 * Description: read the usbtimeout flag of zx297510
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: flag:usb time out (1~10)
 *
 *
 * Others: 
 ********************************************************************************/
unsigned int zDrvNand_ReadUsbtimeout( void )
{

    unsigned int usbtimeout = 0;
	char value = 0;
    int retlen = 0;
    
    unsigned char *buffer = kmalloc((mtd_fota->writesize + mtd_fota->oobsize), GFP_KERNEL);
    if( buffer == NULL )
        return -1;

    if(mtd_read(mtd_fota,0,mtd_fota->writesize,&retlen,buffer))/* BOOTFLAGnandĵ20~27ֽ */
    {
        kfree(buffer);
        return -1;
    }
	memcpy(&value, buffer+3, 1); 
	usbtimeout = value;
	
    kfree(buffer);
	return usbtimeout;   

}
EXPORT_SYMBOL(zDrvNand_ReadUsbtimeout);

/*******************************************************************************
 * Function:  zDrvNand_WriteUsbtimeout
 * Description: write the usbtimeout flag of zx297510
 * Parameters: 
 *   Input:flag (1~10)
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
unsigned int zDrvNand_WriteUsbtimeout( unsigned int flag )
{

    unsigned int ret = 0;
	char oob[256];
	int i =0;
	int times = 0;
	int retlen = 0;
	char value = 0;
	struct erase_info ei;
    unsigned char *buffer = kmalloc(4*(mtd_fota->writesize + mtd_fota->oobsize), GFP_KERNEL);  /* ZLOADERͷ8192BYTES */

	if( buffer == NULL )
        return -1;

    if(mtd_read(mtd_fota,0,6 * mtd_fota->writesize,&retlen,buffer))/* BOOTFLAGnandĵ20~27ֽ */
    {
        kfree(buffer);
        return -1;
    }
    
    memset(&value, flag, 1);
    memcpy(buffer+3, &value, 1);

	memset(&ei, 0, sizeof(struct erase_info));
    ei.mtd  = mtd_fota;
    ei.addr = 0;
    ei.len  = mtd_fota->erasesize;
	g_zload_read_only_flag = 1;
    ret = mtd_erase(mtd_fota, &ei);                  /*һ*/
	ret = mtd_write(mtd_fota,0,4 * mtd_fota->writesize,&retlen,buffer);
	g_zload_read_only_flag = 0;
    kfree(buffer);
   		
	return ret; 
}
EXPORT_SYMBOL(zDrvNand_WriteUsbtimeout);

#if 0

unsigned int zDrvNand_ReadZloaderAndPartition(char *buffer,unsigned int len)
{
    int retlen = 0;
    int data_len = 8*1024;//8K
    unsigned char *data_buffer = kmalloc(data_len, GFP_KERNEL);

    if( data_buffer == NULL )
        return -1;

    if(mtd_read(mtd_fota,0,data_len,&retlen,data_buffer))
    {
        kfree(data_buffer);
        return -1;
    }

     memcpy(buffer,data_buffer,data_len);
    kfree(data_buffer);
    
    return 0;
}

unsigned int zDrvNand_WriteZloaderAndPartition(char *buffer,unsigned int len)
{

    int retlen = 0;
    int ret = 0;
    struct erase_info ei;
    //clear zero is must
    memset(&ei, 0, sizeof(struct erase_info));
    ei.mtd  = mtd_fota;
    ei.addr = 0;
    ei.len  = mtd_fota->erasesize;
    ret = mtd_erase(mtd_fota, &ei);                  /*һ*/

    ret = mtd_write(mtd_fota,0,8*1024,&retlen,buffer);

    return ret;
	
}

 unsigned int zDrvNand_GetFlashId(char *bufer)
 {

       if(bufer==NULL)
       {
              return -1;
       }
	   
 //fyi        bufer[0] = get_maf_id();
//fyi	  bufer[1] = get_dev_id();
	  return 0;
 }
 
 unsigned int  zDrvNand_GetECOVer()
 {   
 //fyi    return get_eco_flag();
 }
 
 unsigned int  zDrvNand_IfSupport8bitECC()
 {
	int ecc_bits;
 //fyi      ecc_bits = get_ecc_bits();
	 if(ecc_bits == 8)
	 {
		 return 1;
	 }
	 else
	 {
		 return 0;
	 }
 }
#endif
/**************************************************************************
* Function: zDrvNand_PartMtdOpen
* Description:get nand parameters for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
int zDrvNand_PartMtdOpen(char* part_name, T_Nand_Part_Info *pNandPartInfo)
{
	return 0;
}
EXPORT_SYMBOL(zDrvNand_PartMtdOpen);

/**************************************************************************
* Function: zDrvNand_PartMtdRead
* Description:read data for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
int zDrvNand_PartMtdRead(T_Nand_Part_Info *pNandPartInfo,unsigned int	dwAddr, unsigned int	dwLen, char *pbyBuf)
{
	return 0;
}
EXPORT_SYMBOL(zDrvNand_PartMtdRead);

/**************************************************************************
* Function: zDrvNand_PartMtdWrite
* Description:read data for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
int zDrvNand_PartMtdWrite(T_Nand_Part_Info *pNandPartInfo,unsigned int	dwAddr, unsigned int	dwLen, char *pbyBuf)
{
	return 0;
}
EXPORT_SYMBOL(zDrvNand_PartMtdWrite);

/**************************************************************************
* Function: zDrvNand_PartMtdErase
* Description:erase data for FOTA.
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
int zDrvNand_PartMtdErase(T_Nand_Part_Info *pNandPartInfo,unsigned int dwAddr)
{
	return 0;
}
EXPORT_SYMBOL(zDrvNand_PartMtdErase);

/*FOTA UPDATE INTERFACE  END*/

/**************************************************************************
* Function: zDrvNand_Initiate
* Description:initialize nand for hal_init.c
* Parameters:
*   Input:None
* Output: None
* Returns:None
**************************************************************************/
int zDrvNand_Initiate(VOID)
{ 

    int ret = 0;
	
    //ret = zDrvNand_Initialize();
    //nand_SetInstance();

    return ret;
}

int nand_inter_read(unsigned int dwStart, unsigned int dwLen, char* to)
{
    int ret = 0;
	int retlen = 0;
	
	ret = mtd_read(mtd_fota,dwStart,dwLen,&retlen,to);

    return ret;
}
EXPORT_SYMBOL(nand_inter_read);

int nand_inter_program(unsigned int dwStart, unsigned int dwLen, char* from)
{
    int ret = 0;
	int retlen = 0;
	
	ret = mtd_write(mtd_fota,dwStart,dwLen,&retlen,from);

    return ret;
}
EXPORT_SYMBOL(nand_inter_program);

int nand_inter_erase(unsigned int dwStart)
{
    int ret = 0;
	struct erase_info ei;

	memset(&ei, 0, sizeof(struct erase_info));
    ei.mtd  = mtd_fota;
    ei.addr = dwStart;
    ei.len  = mtd_fota->erasesize;
	
	ret = mtd_erase(mtd_fota, &ei);

    return ret;
}
EXPORT_SYMBOL(nand_inter_erase);


