/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spifc.c
* File Mark:
* Description:
* Others:
* Version:
* Author:
* Date:

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/dma-mapping.h>
#include <linux/wait.h>
#include <linux/mutex.h>
#include <linux/slab.h>
#include <linux/mtd/mtd.h>
#include <linux/module.h>
#include <linux/clk.h>
#include <linux/err.h>
#include <linux/io.h>
#include <linux/ioport.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/wakelock.h>
//#include <linux/dev_info.h>
#include <linux/gpio.h>
#include <linux/dmaengine.h>
#include <mach/iomap.h>
#include <mach/gpio.h>
#include <mach/spinlock.h>
#include <mach/dma.h>
#include "zxic_spifc.h"
#include "spi_nand.h"


#define zDrv_ASSERT(_EXP)  printk("spifc error\n")


struct spifc_info g_spifc;
extern unsigned char  g_maf_id;
extern char *nor_cmdline;
static int spifc_get_feature( uint32_t reg_addr, uint8_t *value);
static uint32_t spi_fc_wait_cmd_end(void);
int winbond_dev_id2 = 0;
unsigned char g_nor_flag = 0;
struct mutex otpMutex;

/* SPI NAND FLASH COMMAND FORMAT TYPE */
/********************************************************************************
  [Instruction]                 |--write enable
                                |--write disable
                                |--reset

  [Instruction]                 |--addr width is 24 bit
  [addr]                        |--page read to cache
                                |--block erase
                                |--program execute

  [Instruction]                 |--addr width is 8 bit
  [addr]                        |--set feature
  [data_tx]                     |--addr width is 16 bit
                                |--program load(X1,X4)
                                |--program load random data(X1,X4)
                                |--program load random data quad IO

  [Instruction]                 |--addr width is 8 bit
  [addr]                        |--get feature
  [data_rx]                     |--read id

  [Instruction]                 |--addr width is 16 bit
  [addr]                        |--dummy cycel 8/4/2
  [dummy]                       |--read form cache(X1,X2,X4)
  [data_rx]                     |--read form cache(dual,quad)IO

********************************************************************************/
uint32_t spifc_get_reg_base(void)
{
	return (uint32_t)g_spifc.flash_reg;
}


/*******************************************************************************
 * Function:    spi_fc_enable
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_enable(void)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    if( spi->SFC_EN & FC_EN_BACK )
        return;
    
    spi->SFC_EN |= FC_EN;  
    spi->SFC_CTRL0 |= FC_SCLK_PAUSE_EN;
}

/*******************************************************************************
 * Function:    spi_fc_clear_fifo
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_clear_fifo( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    spi->SFC_CTRL0 |= (FC_RXFIFO_THRES | FC_TXFIFO_THRES | 
                       FC_RXFIFO_CLR | FC_TXFIFO_CLR);
}


/*******************************************************************************
 * Function:    spi_fc_config_ctrl
 * Description: FIFOݣǷʹDMA
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_config_ctrl( uint32_t dma )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    /* config DMA */
    if ( dma == FC_DMA_TX )
        spi->SFC_CTRL0 |= FC_TX_DMA_EN;
    else if( dma == FC_DMA_RX )
        spi->SFC_CTRL0 |= FC_RX_DMA_EN;
	else
		spi->SFC_CTRL0 &= ~(FC_RX_DMA_EN|FC_TX_DMA_EN);		
}

/*******************************************************************************
 * Function:    spi_fc_setup_cmd
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_setup_cmd( struct spiflash_cmd_t *cmd, 
                                                uint32_t addr, uint32_t len )
{   
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    uint32_t wrap = 0;	
    uint32_t tmp = 0;

    /*  */
    spi->SFC_INS = cmd->cmd;

    /* ݳ */
    if( len )
        spi->SFC_BYTE_NUM = len - 1;
    else
        spi->SFC_BYTE_NUM = 0;  

    switch ( len )
    {
        case 2048:
            wrap = WRAP_SIZE_MAIN;
            break;
        case 2112:
            wrap = WRAP_SIZE_MAIN_OOB;
            break;
        case 64:
            wrap = WRAP_SIZE_OOB;
            break;
        default:
            wrap = 0;
            break;
    }

    /* ַ */
    switch ( spi->SFC_INS )
    {
        case CMD_READ_FROM_CACHE:
        //  case CMD_READ_FROM_CACHE_X2:
        case CMD_READ_FROM_CACHE_X4:
        case CMD_READ_FROM_CACHE_QIO:
        case CMD_PROGRAM_LOAD:
        case CMD_PROGRAM_LOAD_X4:
            // case CMD_PROGRAM_LOAD_RANDOM:
            //  case CMD_PROGRAM_LOAD_RANDOM_X4:
            //case CMD_PROGRAM_LOAD_RANDOM_QIO:
            addr |= wrap;
            break;

        default:
            addr = addr;
            break;
    }
    spi->SFC_ADDR = addr;

    /* ַ롢ڡ/д ʹ */
    spi->SFC_CTRL1 = 0;
    spi->SFC_CTRL1 = ((cmd->addr_tx_en << FC_ADDR_TX_EN) |
                      (cmd->dumy_tx_en << FC_DUMMY_TX_EN) |
                      (cmd->data_rx_en << FC_READ_DAT_EN) |
                      (cmd->data_tx_en << FC_WRITE_DAT_EN));


    /* ַ(1234ֽ)ַ/߶ȡģʽ */
    tmp = spi->SFC_CTRL2;
	tmp &= ~(FC_DAT_MULTI_LINE_EN);
    tmp &= ~((0xf<<FC_DUMMY_BYTE_NUM) |
			 (0x7<<FC_DUMMY_BIT_NUM) |
			 (0x3<<FC_ADDR_BYTE_NUM));
    tmp |= ((cmd->dumy_bytes << FC_DUMMY_BYTE_NUM) |
            (cmd->dumy_bits << FC_DUMMY_BIT_NUM) |
            (cmd->addr_width << FC_ADDR_BYTE_NUM));
    spi->SFC_CTRL2 = tmp;
	
}


/*******************************************************************************
 * Function:    spi_fc_clear_int
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_clear_int( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

    if (spi->SFC_INT_RAW & 0x2)
        printk("Spi-Nand Int Format error!\n");

    spi->SFC_INT_SW_CLR = 0xFF; //clear int ?
    g_spifc.irq_status = 0x0;
}

/*******************************************************************************
 * Function:    spi_fc_read_fifo_one_byte
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  only for:
                [Instruction]                 |--addr width is 8 bit
                [addr]                        |--get feature
                [data_rx]
 ********************************************************************************/
static int spi_fc_read_fifo_one_byte( uint8_t *value )
{
    uint32_t sw = 0;
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

    sw = spi->SFC_SW;

    if ( ((sw >> FC_RX_FIFO_CNT) & FC_RX_FIFO_CNT_MASK) != 1 )
    {
        printk("[SPI-NAND][-ERROR-][spi_fc_read_fifo_one_byte][SFC_SW] = 0x%0x\n", sw );
        return -5;
    }

    *value = (uint8_t)spi->SFC_DATA;

    return 0;
}


/*******************************************************************************
 * Function:    spi_fc_read_fifo
 * Description:fifoݣֱĸ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint32_t spi_fc_read_fifo( uint32_t len, uint8_t *buf )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    uint32_t *p = (uint32_t *)buf;
    uint32_t cnt = 0;

    while (cnt < ((len +3)>> 2))
    {
        if (spi->SFC_SW & (FC_RX_FIFO_CNT_MASK << FC_RX_FIFO_CNT)) //rx fifo not empty
        {
            p[cnt++] = spi->SFC_DATA;
        }
    }

    return (cnt<<2);
}


/*******************************************************************************
 * Function:    spi_fc_write_fifo_one_byte
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static uint32_t spi_fc_write_fifo_one_byte(uint32_t len, uint8_t* value)
{
    uint32_t sw = 0;
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

    sw = spi->SFC_SW;

    if ( ((sw >> FC_TX_FIFO_CNT) & FC_TX_FIFO_CNT_MASK) != 0x10 ) /* Ϊ */
    {
        printk("[SPI-NAND][-ERROR-][spi_fc_write_fifo_one_byte][SFC_SW] = 0x%0x\n", sw );
        return -5;
    }

    spi->SFC_DATA = (uint32_t)(*value);

    return 0;
}


/*******************************************************************************
 * Function:    spi_fc_write_fifo
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_write_fifo(uint8_t* buf, uint32_t buf_len, uint8_t* oob, uint32_t oob_len)
{
    uint32_t *main_area = (uint32_t *)buf;
    uint32_t *spear_area = (uint32_t *)oob;
    uint32_t cnt = 0;
    uint32_t ret = 0;
    volatile struct spifc_reg_t* spi = (struct spifc_reg_t*)spifc_get_reg_base();

    while (cnt < (buf_len >> 2))
    {
        if (spi->SFC_SW & (FC_TX_FIFO_CNT_MASK << FC_TX_FIFO_CNT)) //tx fifo not full
        {
            spi->SFC_DATA = main_area[cnt++];
        }
    }
#if 0
    if (len % 4)
    {
        printk("[SPI-NAND][spi_fc_read_fifo][error]\n");
        BUG();
    }
#endif
    ret = cnt;
    cnt = 0;

    if ( oob != NULL )
    {
        while ( cnt < (oob_len >> 2))
        {
            if (spi->SFC_SW & (FC_TX_FIFO_CNT_MASK << FC_TX_FIFO_CNT)) //tx fifo not full
            {
                spi->SFC_DATA = spear_area[cnt++];
            }
        }
    }

#if 0
    ret += cnt;
    if ( (ret << 2) != len )
    {
        zDrv_ASSERT(0);
    }
#endif	
}
/*******************************************************************************
 * Function:    spi_fc_start
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static inline void spi_fc_start( void )
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

    spi->SFC_START |= FC_START;
}

/*******************************************************************************
 * Function:    spi_fc_setup_tansmod
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spi_fc_setup_tansmod(uint32_t mod)
{
    uint32_t tmpReg;
    volatile struct spifc_reg_t* spi  = (struct spifc_reg_t*)spifc_get_reg_base();

    tmpReg = spi->SFC_CTRL2;
    tmpReg &= 0xffffffe0;

    switch (mod)
    {
        case RDQIO_MODE:
            tmpReg |= FC_ADDR_MULTI_LINE_EN |
                      FC_DAT_MULTI_LINE_EN |
                      FC_TRANS_MOD;
            break;

        case PLX4_MODE:
        case RDX4_MODE:
            tmpReg |= FC_DAT_MULTI_LINE_EN | FC_TRANS_MOD;
            break;

        /* case DUAL_MODE:
             tmpReg |=FC_DAT_MULTI_LINE_EN;
          break; */

        default:   /*signle mode*/
            break;
    }

    spi->SFC_CTRL2 = tmpReg;
}



static void spifc_irq_enable(uint32_t int_mask)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

	spi->SFC_INT_EN = 0;
	spi->SFC_INT_EN |= int_mask;
}

static void spifc_irq_disable(void)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

	spi->SFC_INT_EN = 0;
}

/*******************************************************************************
 * Function:    spifc_set_timing
 * Description: 
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spifc_set_timing(uint32_t rd_delay, uint32_t cs_setup,
                      uint32_t cs_hold, uint32_t cs_desel)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    spi->SFC_TIMING = 0;
    spi->SFC_TIMING  |= ((rd_delay & 0x3) << 16) | ((cs_setup & 0x7) << 11) |
                        ((cs_hold & 0x7) << 6) | ((cs_desel & 0xf) << 0);
}

static int spifc_switch_die(unsigned char die)
{
	int ret = SUCCESS;
	uint8_t value = die;
	uint32_t retries = SPI_NAND_RETRIE;
		
	struct spiflash_cmd_t cmd = {	CMD_WINBOND_DIE_SWITCH, /* ????? */
									0,						/* ?????1? */
									0,						 /* ????3? */
									1,						/* ?y?Y1?---D */
									0,						/* ??y?Y1?---? */
									0,						/* ???D̨y??1? */
									0,						/* ???D̨y?? x8 */
									0						/* ???D̨y?? x1 */
								};

	
    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
        
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);       
		spi_fc_setup_cmd(&cmd, 0, 1);		/* ?????? */	  
        spi_fc_write_fifo_one_byte(1, &value);
        spi_fc_start();                             /* ?a??? */
        ret = spi_fc_wait_cmd_end();                /* ̨y???? */
        if( ret != SUCCESS )
        {
            continue;   /* ??㨹??????-?2??? */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
			
        break;        
    } while( --retries != 0 );

    return ret;
}
/*******************************************************************************
 * Function:    spifc_write_enable
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spifc_write_enable( void )
{
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
	uint8_t status = 0;
    struct spiflash_cmd_t cmd = {   CMD_WRITE_ENABLE,       /* ָ */
               0,                      /* ַ뷢ʹ */
               0,                      /* ַ볤 */
               0,                      /* ʹ---д */
               0,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
	while(1)
	{
	    if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp

		do
	    {
	        spi_fc_clear_fifo();
	        spi_fc_clear_int();
	        spi_fc_config_ctrl(FC_DMA_NONE);
	        spi_fc_setup_cmd(&cmd, 0x0, 0);          /*  */
	        spi_fc_start();                          /* ʼ */
	        ret = spi_fc_wait_cmd_end();             /* ȴ */
	        if ( ret != SUCCESS )
	        {
	            continue;   /* ʧܣѭش */
	        }

	        break;
	    }
	    while ( --retries != 0 );

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp

		udelay(5);
		
		/* ȴϴִ */
		do
		{
			spifc_get_feature(REG_STATUS, &status); 
		}
		while ( status & OIP); 
	
		if(status&WEL)//sunzhaoxing
			break;
	
		retries = SPI_NAND_RETRIE;
	}
    return ret;
}

/*******************************************************************************
 * Function:    spifc_write_disable
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spifc_write_disable( void )
{
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    struct spiflash_cmd_t cmd = {   CMD_WRITE_DISABLE,      /* ָ */
               0,                      /* ַ뷢ʹ */
               0,                      /* ַ볤 */
               0,                      /* ʹ---д */
               0,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
         
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);
        spi_fc_setup_cmd(&cmd, 0x0, 0);          /*  */
        spi_fc_start();                          /* ʼ */
        ret = spi_fc_wait_cmd_end();             /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		
        break;
    }
    while ( --retries != 0 );

    return ret;
}

/*******************************************************************************
 * Function:    spifc_reset
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int spifc_reset( void )
{
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;
    struct spiflash_cmd_t cmd = {   CMD_RESET,              /* ָ */
               0,                      /* ַ뷢ʹ */
               0,                      /* ַ볤 */
               0,                      /* ʹ---д */
               0,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
    do
    { 
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
        
		spi_fc_setup_cmd(&cmd, 0, 0); /*  */
		spi_fc_clear_int();
        spi_fc_start();                     /* ʼ */
        ret = spi_fc_wait_cmd_end();        /* ȴ */
		if ( ret != SUCCESS )
        {
            continue;    /* ʧܣѭش */
        }
		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		
		udelay(5);
		
		do
		{
			spifc_get_feature(REG_STATUS, &status); 
		}
		while ( status & OIP); 

        break;
    }
    while ( --retries != 0 );

    return ret;
}

/*******************************************************************************
 * Function:    spifc_get_feature
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:   [Instruction]                 |--addr width is 8 bit
             [addr]                        |--get feature
             [data_rx]                     |--read id

 ********************************************************************************/
static int spifc_get_feature( uint32_t reg_addr, uint8_t *value)
{
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;

    struct spiflash_cmd_t cmd = {   CMD_GET_FEATURE,        /* ָ */
               1,                      /* ַ뷢ʹ */
               FC_ADDR_BYTE_NUM_8,     /* ַ볤 */
               0,                      /* ʹ---д */
               1,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp		
		
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);
        spi_fc_setup_cmd(&cmd, reg_addr, 1);        /*  */
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

        ret = spi_fc_read_fifo_one_byte(value);          /* ȡ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp

        break;
    }
    while ( --retries != 0 );

    return ret;
}


/*******************************************************************************
 * Function:    spifc_set_feature
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:   [Instruction]                 |--addr width is 8 bit
             [addr]                        |--set feature
             [data_tx]

 ********************************************************************************/
static int spifc_set_feature( uint32_t reg_addr, uint8_t *value)
{
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;

    struct spiflash_cmd_t cmd = {   CMD_SET_FEATURE,        /* ָ */
               1,                      /* ַ뷢ʹ */
               FC_ADDR_BYTE_NUM_8,     /* ַ볤 */
               1,                      /* ʹ---д */
               0,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
        
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);
        spi_fc_setup_cmd(&cmd, reg_addr, 1);        /*  */
        spi_fc_write_fifo_one_byte(1, value);
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		
        break;
    }
    while ( --retries != 0 );

    return ret;
}

/*******************************************************************************
 * Function:    spifc_read_id
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]                 |--addr width is 8 bit
            [addr]                        |--get feature
            [data_rx]                     |--read id
 ********************************************************************************/

static int spifc_read_id(uint32_t reg_addr, uint8_t *value, uint8_t len)
{   
    int ret = 0;
    uint32_t retries = SPI_NAND_RETRIE;

    struct spiflash_cmd_t cmd = {   CMD_READ_ID,            /* ָ */
               1,                      /* ַ뷢ʹ */
               FC_ADDR_BYTE_NUM_8,     /* ַ볤 */
               0,                      /* ʹ---д */
               1,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };


    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
    	
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);        
        spi_fc_setup_cmd(&cmd, reg_addr, len);        /*  */      
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if( ret != SUCCESS )
        {
            //spi_fc_disable();
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		

        ret = spi_fc_read_fifo(len,value);     /* ȡ */
		
        if ( ret != SUCCESS )
        {
            //spi_fc_disable();
            continue;   /* ʧܣѭش */
        }
		
        break;
    }
    while ( --retries != 0 );

    return 0;
}


/*******************************************************************************
 * Function:    spifc_erase
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]       |--addr width is 24 bit(page/block addr!!!!)
            [addr]
                                |--block erase

 ********************************************************************************/
static int spifc_erase(uint32_t page_addr)
{   
    //volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
    
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;

    struct spiflash_cmd_t cmd = {   CMD_BLOCK_ERASE,        /* ָ */
               1,                      /* ַ뷢ʹ */
               FC_ADDR_BYTE_NUM_24,    /* ַ볤 */
               0,                      /* ʹ---д */
               0,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
    	
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);
        spi_fc_setup_cmd(&cmd, page_addr, 0);   /*  */
        spi_fc_start();                          /* ʼ */
        ret = spi_fc_wait_cmd_end();             /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
        udelay(5);
		
        /* ȴִ */
        do
        {	
        	msleep(1);
            ret = spifc_get_feature(REG_STATUS, &status);
        }while( status & OIP);
		
        if( status & E_FAIL )
        {   
			if((retries-1) !=0)
			{
				continue;
			}
            return NAND_STATUS_FAIL;
        }

        break;
    }
    while ( --retries != 0 );

    return ret;
}

/*******************************************************************************
 * Function:    spifc_read_page_to_cache
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]       |--addr width is 24 bit(page/block addr!!!!)
            [addr]              |--page read
                                |--block erase
                                |--program execute
 ********************************************************************************/
static int spifc_read_page_to_cache(uint32_t page_addr)
{
    //volatile struct spi_t* spi    = (struct spi_t*)SYS_SPI_NAND_BASE;

    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;

    struct spiflash_cmd_t cmd = {   CMD_READ_PAGE_TO_CACHE, /* ָ */
               1,                      /* ַ뷢ʹ */
               FC_ADDR_BYTE_NUM_24,    /* ַ볤 */
               0,                      /* ʹ---д */
               0,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
    	
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);
        spi_fc_setup_cmd(&cmd, page_addr, 0);   /*  */
        spi_fc_start();                          /* ʼ */
        ret = spi_fc_wait_cmd_end();             /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		udelay(5);
		
        /* ȴִ */
        do
        {
            spifc_get_feature(REG_STATUS, &status);
        }while( status & OIP);

        break;
    }
    while ( --retries != 0 );

    return ret;
}

#define	TRANS_USE_DMA	1

static void spifc_dma_callback(void *data)
{
	int dir = (int)data;

	if(dir == FC_DMA_RX)
		up(&g_spifc.rx_semaphore);
	else if(dir == FC_DMA_TX)
		up(&g_spifc.tx_semaphore);
	else
		BUG();
}

static int spifc_wait_dma_done(int dir)
{
	if(dir == FC_DMA_RX)
		down(&g_spifc.rx_semaphore);
	else if(dir == FC_DMA_TX)
		down(&g_spifc.tx_semaphore);
	else
		BUG();
	
	return 0;
}

static int spifc_config_dma(uint8_t *buf, uint32_t len, int dir)
{
	struct dma_chan *chan;
	struct dma_async_tx_descriptor *desc;
	int ret = 0;
    dma_channel_def dma_conf 	={
		.dma_control.irq_mode 		= DMA_ALL_IRQ_ENABLE,
		.dma_control.src_burst_size	= DMA_BURST_SIZE_32BIT,
		.dma_control.src_burst_len	= DMA_BURST_LEN_8,
		.dma_control.dest_burst_size= DMA_BURST_SIZE_32BIT,
		.dma_control.dest_burst_len	= DMA_BURST_LEN_8,
		.link_addr = 0,
		};

	if(dir == FC_DMA_RX)
	{
		dma_conf.src_addr = SF_DATA;
		dma_conf.dest_addr = (unsigned int)buf;
		chan	= g_spifc.rx_channel;	
		dma_conf.dma_control.tran_mode = TRAN_PERI_TO_MEM;		
	}
	else if(dir == FC_DMA_TX)
	{	
		dma_conf.src_addr = (unsigned int)buf;
		dma_conf.dest_addr = SF_DATA;
		chan	= g_spifc.tx_channel;
		dma_conf.dma_control.tran_mode = TRAN_MEM_TO_PERI;
	}
	else
		BUG();

	dma_conf.count = len;
	
	ret = dmaengine_slave_config(chan,(struct dma_slave_config*) &dma_conf);
	if(ret != 0)
	{
		pr_info("dmaengine_slave_config failed(%d)~~~~~~", ret);
		return ret;
	}

	desc = chan->device->device_prep_interleaved_dma(chan, NULL, 0);
	desc->callback 			= spifc_dma_callback;
	desc->callback_param 	= dir;
	dmaengine_submit(desc);
	dma_async_issue_pending(chan);

	return 0;
}

/*******************************************************************************
 * Function:    spifc_read_from_cache
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]                 |--addr width is 16 bit
            [addr]                        |--dummy cycel 8/4/2
            [dummy]                       |--read form cache(X1,X2,X4)
            [data_rx]                     |--read form cache(dual,quad)IO
 ********************************************************************************/
static int spifc_read_from_cache(uint32_t column_addr, uint32_t len, uint8_t *buf)
{   
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint32_t len_tmp = 0;
    struct spiflash_cmd_t cmd;
    uint32_t trans_mode = spi_nand_get_trans_mode(READ_TRANSFER_MODE);

    //spi_fc_setup_tansmod(trans_mode);

    switch (trans_mode)
    {
        case RDQIO_MODE:
            cmd.cmd = CMD_READ_FROM_CACHE_QIO;       /* ָ */
            cmd.dumy_bytes = 0;                      /* еȴ x8 */
            if(g_maf_id == 0xEF)
			{
				cmd.dumy_bits = 4;                      /* еȴ x1 */
			}
			else
			{
				cmd.dumy_bits = 2;						 /* еȴ x1 */
			}
            break;
        case RDX4_MODE: 
            cmd.cmd = CMD_READ_FROM_CACHE_X4;        /* ָ */
            cmd.dumy_bytes = 1;                      /* еȴ x8 */
            cmd.dumy_bits = 0;                       /* еȴ x1 */
            break;
        default:
            cmd.cmd = CMD_READ_FROM_CACHE;           /* ָ */
            cmd.dumy_bytes = 1;                      /* еȴ x8 */
            cmd.dumy_bits = 0;                       /* еȴ x1 */
            break;
    }
	
    cmd.addr_tx_en = 1;                      /* ַ뷢ʹ */
    cmd.addr_width = FC_ADDR_BYTE_NUM_16;    /* ַ볤 */
    cmd.data_tx_en = 0;                      /* ʹ---д */
    cmd.data_rx_en = 1;                      /* ʹ--- */
    cmd.dumy_tx_en = 1;                      /* еȴʹ */

    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
    	
        spi_fc_clear_fifo();
        spi_fc_clear_int();
		spi_fc_setup_cmd(&cmd, column_addr, len);		/*  */
#if	TRANS_USE_DMA
		spifc_config_dma(buf, len, FC_DMA_RX);		
		spi_fc_config_ctrl(FC_DMA_RX);
		spi_fc_setup_tansmod(trans_mode);
		spi_fc_start(); 								/* ʼ */		
#else
        spi_fc_config_ctrl(FC_DMA_NONE);
		spi_fc_setup_tansmod(trans_mode);
        spi_fc_start();                                 /* ʼ */

        len_tmp = spi_fc_read_fifo(len, buf);           /* ȡ */
        if ( len_tmp != len )
        {
            ret = -2;
            continue;   /* ʧܣѭش */
        }
#endif
        ret = spi_fc_wait_cmd_end();                    /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

#if TRANS_USE_DMA
		spifc_wait_dma_done(FC_DMA_RX);
		spi_fc_config_ctrl(FC_DMA_NONE); 
#endif
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		
        break;
    }
    while ( --retries != 0 );

    spi_fc_setup_tansmod(SINGLE_MODE);

    return ret;
}


/*******************************************************************************
 * Function:    spifc_page_load
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]
            [addr]
            [data_tx]                     |--addr width is 16 bit
                                          |--program load(X1,X4)
 ********************************************************************************/
static int spifc_page_load(uint32_t column_addr, uint8_t* buf, uint32_t page_len, 
						uint8_t *oob, uint32_t oob_len)
{   
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    struct spiflash_cmd_t cmd;
    uint32_t trans_mode = spi_nand_get_trans_mode(WRITE_TRANSFER_MODE);

    switch (trans_mode)
    {
        case PLX4_MODE:
             cmd.cmd = CMD_PROGRAM_LOAD_X4;  /* ָ */
            break;
        default:
             cmd.cmd = CMD_PROGRAM_LOAD;
            break;
    }
	
    cmd.addr_tx_en = 1;                      /* ַ뷢ʹ */
    cmd.addr_width = FC_ADDR_BYTE_NUM_16;    /* ַ볤 */
    cmd.data_tx_en = 1;                      /* ʹ---д */
    cmd.data_rx_en = 0;                      /* ʹ--- */
    cmd.dumy_tx_en = 0;                      /* еȴʹ */
    cmd.dumy_bytes = 0;                      /* еȴ x8 */
    cmd.dumy_bits = 0;                       /* еȴ x1 */

    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
    	
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_setup_cmd(&cmd, column_addr, page_len+oob_len);       /*  */
#if TRANS_USE_DMA
		if(oob)
			spifc_config_dma(buf, page_len+oob_len, FC_DMA_TX);
		else
			spifc_config_dma(buf, page_len, FC_DMA_TX);
		spi_fc_config_ctrl(FC_DMA_TX);
		spi_fc_setup_tansmod(trans_mode);		
		spi_fc_start(); 								/* ʼ */		
#else		
        spi_fc_config_ctrl(FC_DMA_NONE);
        spi_fc_setup_tansmod(trans_mode);
        spi_fc_start();                                 /* ʼ */
        spi_fc_write_fifo(buf, page_len, oob, oob_len);               /*֤*/
#endif		
        ret = spi_fc_wait_cmd_end();                    /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }
#if TRANS_USE_DMA
		spifc_wait_dma_done(FC_DMA_TX);
		spi_fc_config_ctrl(FC_DMA_NONE); 
#endif	
		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		
        break;
    }
    while ( --retries != 0 );

    spi_fc_setup_tansmod(SINGLE_MODE);

    return ret;
}


/*******************************************************************************
 * Function:    spifc_program_exec
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:  [Instruction]       |--addr width is 24 bit(page/block addr!!!!)
            [addr]              |--program execute

 ********************************************************************************/
static int spifc_program_exec(uint32_t page_addr)
{    
    int ret = SUCCESS;
    uint32_t retries = SPI_NAND_RETRIE;
    uint8_t status = 0;

    struct spiflash_cmd_t cmd = {   CMD_PROGRAM_EXECUTE,    /* ָ */
               1,                      /* ַ뷢ʹ */
               FC_ADDR_BYTE_NUM_24,    /* ַ볤 */
               0,                      /* ʹ---д */
               0,                      /* ʹ--- */
               0,                      /* еȴʹ */
               0,                      /* еȴ x8 */
               0                       /* еȴ x1 */
    };
    do
    {
        if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_LOW);//spp
    	
        spi_fc_clear_fifo();
        spi_fc_clear_int();
        spi_fc_config_ctrl(FC_DMA_NONE);
        spi_fc_setup_cmd(&cmd, page_addr, 0);       /*  */
        spi_fc_start();                             /* ʼ */
        ret = spi_fc_wait_cmd_end();                /* ȴ */
        if ( ret != SUCCESS )
        {
            continue;   /* ʧܣѭش */
        }

		if(g_nor_flag == 1)
			gpio_set_value(86,GPIO_HIGH);//spp
		udelay(5);
		
        /* ȴִ */
        do
        {
            spifc_get_feature(REG_STATUS, &status);
			if(!(status & OIP))
			{
				break;
			}
			usleep_range(50,50);
        }while(status & OIP);
		
        if( status & P_FAIL )
        {
            if((retries -1)!=0)
        	{
        		continue;
        	}        
            return NAND_STATUS_FAIL;
        }   
         break;  
    }
    while ( --retries != 0 );

    return ret;
}

static uint16_t spi_nand_timing_set(struct spi_nand_info *spifc)
{
	uint16_t status = PASS;
	uint8_t  id[4];

	/* Use read id method to get device ID and other
	 * params. For some NAND chips, controller can't
	 * report the correct device ID by reading from
	 * DEVICE_ID register
	 * */
	//spi_fc_enable();
	spifc_read_id(0x0, id, 3);

	spifc->maf_id = id[0];
	spifc->dev_id = id[1];
	winbond_dev_id2 = id[2];
	
	dev_info(spifc->dev,"maf = %x,dev = %x, dev2 = %x\n",id[0],id[1], id[2]);

	spi_nand_get_param(id[0], id[1]);

	spifc_set_timing(2,1,1,9);
	
	return status;
}

static uint32_t spifc_read_interrupt_status(void)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();
	uint32_t intr_status = 0;
	
	intr_status = spi->SFC_INT_SW_CLR;

	return intr_status;
}


static void spifc_set_intr_modes(struct spi_nand_info *spifc,
					uint16_t INT_ENABLE)
{
	if (INT_ENABLE)
		spifc_irq_enable(SPIFC_IRQ_ALL);
	else
		spifc_irq_disable();
}
static inline bool is_flash_bank_valid(int flash_bank)
{
	return 1;
}
#if 0
static void spifc_irq_init(struct spi_nand_info *spifc)
{
	uint32_t int_mask = 0;

	/* Disable global interrupts */
	spifc_set_intr_modes(spifc, false);
	int_mask = SPIFC_IRQ_ALL;
	spifc_irq_enable( int_mask);
}
#endif
static void spifc_irq_cleanup(int irqnum, struct spi_nand_info *spifc)
{
	spifc_set_intr_modes(spifc, false);
	free_irq(irqnum, spifc);
}

/* This function only returns when an interrupt that this driver cares about
 * occurs. This is to reduce the overhead of servicing interrupts
 */
static inline uint32_t spifc_irq_detected(void)
{
	return spifc_read_interrupt_status() & SPIFC_IRQ_ALL;
}
static inline void clear_interrupt(uint32_t irq_mask)
{
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

	spi->SFC_INT_SW_CLR = irq_mask;
}

static void clear_interrupts(void)
{
	uint32_t status = 0x0;
	unsigned long flags;
	
	raw_spin_lock_irqsave(&g_spifc.irq_lock, flags);

	status = spifc_read_interrupt_status();
	clear_interrupt(status);

	g_spifc.irq_status = 0x0;
	raw_spin_unlock_irqrestore(&g_spifc.irq_lock, flags);
}

/*******************************************************************************
 * Function:    spifc_hw_init
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spifc_hw_init(struct spi_nand_info *spifc)
{
    int ret;

	/*configure gpio12 to sfc_data3*/
	ret = gpio_request(98, "sfc_data3");
	if (ret)
	{	
		printk("gpio fail 1\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(98, 0x1);
	
	/*configure gpio11 to sfc_data2*/
	ret = gpio_request(97, "sfc_data2");
	if (ret)
	{	
		printk("gpio fail 2\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(97, 0x1);
	
	/*configure gpio10 to sfc_data2*/
	ret = gpio_request(96, "sfc_data1");
	if (ret)
	{	
		printk("gpio fail 3\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(96, 0x1);
	
	/*configure gpio9 to sfc_data0*/
	ret = gpio_request(95, "sfc_data0");
	if (ret)
	{	
		printk("gpio fail 4\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(95, 0x1);

/*configure gpio5 to sfc_cs*/

	ret = gpio_request(93, "sfc_cs");
	if (ret)
	{	
		printk("gpio fail 5\n");
		zDrv_ASSERT(0);
		return;
	}
	if(g_nor_flag == 1){
        zx29_gpio_config(93, GPIO93_GPIO93);
		gpio_direction_output(93,1);
		
		ret = gpio_request(ZX29_GPIO_86, "gpio");
		if (ret)
		{	
			printk("gpio86 fail\n");
			zDrv_ASSERT(0);
			return;
		}
		zx29_gpio_config(ZX29_GPIO_86, GPIO86_GPIO86);
		gpio_direction_output(ZX29_GPIO_86,1);
	}
	
/*configure gpio3 to sfc_sclk*/
	ret = gpio_request(94, "sfc_sclk");
	if (ret)
	{	
		printk("gpio fail 6\n");
		zDrv_ASSERT(0);
		return;
	}
	zx29_gpio_config(94, 0x1);

    spifc->max_banks = 1;	
	spi_fc_enable();	

	printk("gpio,clk ,spifc en ok\n");
}

/*******************************************************************************
 * Function:    spifc_lock/unlock
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void spifc_lock(void)
{
	if(!g_spifc.int_en_flag)
	{
		enable_irq(g_spifc.irq);
		g_spifc.int_en_flag =1;
	}	
}

static void spifc_unlock(void)
{
	clear_interrupts();
	if(g_spifc.int_en_flag)
	{
		disable_irq(g_spifc.irq);
		g_spifc.int_en_flag = 0;
	}
}

/*************************************add*****************/
static uint32_t spi_fc_wait_cmd_end(void)
{
	unsigned long comp_res, flags = 0;
	uint32_t intr_status = 0;
	bool retry = false;
	unsigned long timeout = msecs_to_jiffies(1000);
    volatile struct spifc_reg_t* spi	= (struct spifc_reg_t*)spifc_get_reg_base();

	while ( spi->SFC_START & FC_BUSY );
	
	do {
		//comp_res = wait_for_completion_timeout(&g_spifc.complete, timeout);
		comp_res = down_timeout(&g_spifc.cmd_done_sem, timeout);
		raw_spin_lock_irqsave(&g_spifc.irq_lock, flags);
		intr_status = g_spifc.irq_status;
		
		if (intr_status & FC_INT_RAW_CMD_END) {
			g_spifc.irq_status &= ~FC_INT_RAW_CMD_END;
			raw_spin_unlock_irqrestore(&g_spifc.irq_lock, flags);

			/* our interrupt was detected */
			break;
		} 
		else if(intr_status & FC_INT_RAW_ERR_MASK)
		{
            g_spifc.irq_status &= ~FC_INT_RAW_ERR_MASK;
			raw_spin_unlock_irqrestore(&g_spifc.irq_lock, flags);

			/* error interrupt was detected */
			break;
			return -5;
		}
		else {
			/* these are not the interrupts you are looking for -
			 * need to wait again */
			raw_spin_unlock_irqrestore(&g_spifc.irq_lock, flags);
			retry = true;
		}
	} while (comp_res == 0);

	if (comp_res != 0) {
		/* timeout */
		printk(KERN_ERR "spifc timeout occurred, status = 0x%x\n",
				intr_status);

		return -5;
	}
	return 0;
}

/* This is the interrupt service routine. It handles all interrupts
 * sent to this device. Note that on CE4100, this is a shared
 * interrupt. */
static irqreturn_t spifc_isr(int irq, void *dev_id)
{
	uint32_t irq_status = 0x0;
	irqreturn_t result = IRQ_NONE;
	unsigned long flags;

	raw_spin_lock_irqsave(&g_spifc.irq_lock, flags);

	/* check to see if a valid NAND chip has been selected. */
	if (is_flash_bank_valid(g_spifc.flash_bank)) {
		/* check to see if controller generated
		 * the interrupt, since this is a shared interrupt */
		irq_status = spifc_irq_detected();
		if (irq_status != 0) {
			/* handle interrupt */
			/* first acknowledge it */
			clear_interrupt(irq_status);
			
			/* store the status in the device context for someone
			   to read */
			g_spifc.irq_status |= irq_status;
			
			/* notify anyone who cares that it happened */
			//complete(&g_spifc.complete);
			up(&g_spifc.cmd_done_sem);
			
			/* tell the OS that we've handled this */
			result = IRQ_HANDLED;
		}
	}
	raw_spin_unlock_irqrestore(&g_spifc.irq_lock, flags);
	
	return result;
}

static int spifc_init_dma(struct spi_nand_info *spifc) 
{
	struct spifc_info *ctrl_info = (struct spifc_info *)spifc->ctrl_info;
	int ret = 0;
	dma_cap_mask_t mask;

	dma_cap_zero(mask);
	dma_cap_set(DMA_SLAVE, mask);

	ctrl_info->tx_channel = dma_request_channel(mask, zx29_dma_filter_fn, (void*)DMA_CH_SPIFC_TX);
	if (!ctrl_info->tx_channel) {
		dev_err(spifc->dev, "no TX DMA channel!\n");
		return -ENODEV;
	}

	ctrl_info->rx_channel = dma_request_channel(mask, zx29_dma_filter_fn, (void*)DMA_CH_SPIFC_RX);
	if (!ctrl_info->rx_channel) {
		dev_err(spifc->dev, "no RX DMA channel!\n");
		return -ENODEV;
	}	

	spifc->dev->dma_mask = &ctrl_info->dma_mask;
	
	/* Is 32-bit DMA supported? */
	ret = dma_set_mask(spifc->dev, DMA_BIT_MASK(32));
	if (ret) {
		pr_err("Spectra: no usable DMA configuration\n");
		return ret;
	}
/*	
	spifc->buf.buf = (dma_addr_t)kmalloc(SPI_NAND_BUF_SIZE, GFP_KERNEL);
	if(!spifc->buf.buf) 
		return -ENOMEM;
*/	
	spifc->buf.buf = (unsigned char *)ALIGN64((unsigned int)spifc->buf._buf);
	spifc->buf.dma_buf = dma_map_single(spifc->dev, spifc->buf.buf, 
						SPI_NAND_BUF_SIZE, DMA_BIDIRECTIONAL);
	
	spifc->mtd.dev.parent = spifc->dev; 
	printk("[SPIFC]dma ok addr is %x\n",spifc->buf.dma_buf);

	sema_init(&ctrl_info->rx_semaphore , 0);
	sema_init(&ctrl_info->tx_semaphore , 0);	

	return 0;
}

static int spifc_init_resource(struct platform_device *pdev, struct spi_nand_info *spifc)
{
	int ret = 0;
	struct resource *spifc_reg;

	spifc_reg = platform_get_resource_byname(pdev, IORESOURCE_MEM, "spifc_reg");
	if (!spifc_reg) 
	{
		dev_err(&pdev->dev, "resources not completely defined\n");
		return  -EINVAL;
	}
	
	spifc->platform = ZX7510;
	spifc->dev = &pdev->dev;
	spifc->ctrl_info = &g_spifc;
	g_spifc.irq = platform_get_irq(pdev, 0);
	if (g_spifc.irq < 0) 
	{
		dev_err(&pdev->dev, "no irq defined\n");
		return g_spifc.irq;
	}
	
	g_spifc.flash_reg = (void __iomem *)(spifc_reg->start);
	if (!g_spifc.flash_reg)
	{
		return -ENOMEM;
	}	

	ret = spifc_init_dma(spifc);	

	return ret;
}

/* initialize driver data structures */
void spifc_drv_init(struct spi_nand_info *spifc)
{
	spifc->idx = 0;

	sema_init(&g_spifc.cmd_done_sem, 0);
	raw_spin_lock_init(&g_spifc.irq_lock);

	/* indicate that MTD has not selected a valid bank yet */
	g_spifc.flash_bank = -1;

	/* initialize our irq_status variable to indicate no interrupts */
	g_spifc.irq_status = 0;

	g_spifc.int_en_flag = 1;
}

static struct spi_nand_ctrl_ops spifc_ops = 
{
	.reset		 		= spifc_reset,
	.switch_die			= spifc_switch_die,		
	.read_id	 		= spifc_read_id,
	.get_feature 		= spifc_get_feature,
	.set_feature 		= spifc_set_feature,
	.read_page_to_cache	= spifc_read_page_to_cache,
	.read_from_cache	= spifc_read_from_cache,
	.page_load 			= spifc_page_load,
	.program_exec		= spifc_program_exec,
	.write_enable		= spifc_write_enable,
	.write_disable		= spifc_write_disable,
	.erase 				= spifc_erase,
	.lock				= spifc_lock,
	.unlock				= spifc_unlock,
};

int spifc_drv_probe(struct platform_device *pdev)
{
	int ret = 0;
    struct spi_nand_info *spifc;

	/*жǷΪǿͰȫ*/
	if(nor_cmdline != NULL)
	{
		if (!strcmp(nor_cmdline, "1"))
		{
		    g_nor_flag = 1;
			//printk("----------EnhancedSecurity---------\n");
		}
	}


	pr_info("----------spi_nand_probe-----------\n");

	mutex_init(&otpMutex);

	spifc = kzalloc(sizeof(*spifc), GFP_KERNEL);
	if (!spifc)
		return -ENOMEM;
	
	soft_spin_lock(NAND_SFLOCK);

	ret = spifc_init_resource(pdev, spifc);
	if(ret)
	{
		pr_info("[SPIFC]get resource failed!\n");
		ret =  -EINVAL;
		goto failed_alloc_memery;		
	}

	spifc_hw_init(spifc);
	spifc_drv_init(spifc);

    spifc_irq_disable();
	if (request_irq(g_spifc.irq, spifc_isr, IRQF_ONESHOT,
			"spi-nand", spifc)) {
		pr_err("Spectra: Unable to allocate IRQ\n");
		ret = -ENODEV;
		goto failed_alloc_memery;
	}
    spifc_irq_enable(SPIFC_IRQ_ALL);
	printk("[SPIFC]request_irq ok\n");	
	spi_nand_timing_set(spifc);

	ret = spi_nand_register(spifc, &spifc_ops);
	if(ret)
	{
		printk("board_nand_init_spifc:(err=%d)", ret);
		soft_spin_unlock(NAND_SFLOCK);
		return ret;	
	}
	
	read_only_partitons_table_init();
    soft_spin_unlock(NAND_SFLOCK);

	platform_set_drvdata(pdev, spifc);
    printk("----------spi_nand_probe end!-----------\n");	

	return 0;
failed_alloc_memery:
	kfree(spifc);
	
	return ret;
}

static int spifc_drv_remove(struct platform_device *ofdev)
{
	struct spi_nand_info *spifc = platform_get_drvdata(ofdev);

	spifc_irq_cleanup(g_spifc.irq, spifc);
	dma_unmap_single(spifc->dev, spifc->buf.dma_buf, SPI_NAND_BUF_SIZE,
			DMA_BIDIRECTIONAL);

	kfree(spifc);

	return 0;
}

static const struct of_device_id spifc_nand_dt_ids[] = {
	{ .compatible = "spifc,spifc-nand-dt" },
	{ /* sentinel */ }
};

MODULE_DEVICE_TABLE(of, spifc_nand_dt_ids);

static struct platform_driver spifc_dt_driver = 
{

	.probe		= spifc_drv_probe,
	.remove		= spifc_drv_remove,
	.driver		= {
		.name	= "spi-nand-dt",
		.owner	= THIS_MODULE,
		.of_match_table	= spifc_nand_dt_ids,
	},
};

module_platform_driver(spifc_dt_driver);


