/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    zxic_spifc.h
* File Mark:
* Description:
* Others:
* Version:
* Author:
* Date:

* History 1:
*     Date: 2014.1.15
*     Version:
*     Author: zhouqi
*     Modification:
* History 2:
**********************************************************************/

#ifndef __ZXIC_SPIFC_H__
#define __ZXIC_SPIFC_H__

#include <linux/semaphore.h>

#define SF_DATA	  		(ZX29_SPIFC0_PHYS+0x38)

#define SPI_NAND_RETRIE 3
#define SUCCESS         0

/* ffsdefs.h */
#define CLEAR 			0                 /*use this to clear a field instead of "fail"*/
#define SET   			1                 /*use this to set a field instead of "pass"*/
#define FAIL 			1                  /*failed flag*/
#define PASS 			0                  /*success flag*/
#define ERR 			-1                  /*error flag*/

#define ZX7510 3

struct spifc_info
{
	void __iomem *		flash_reg;
	uint32_t 			irq;
	uint32_t 			irq_status;
	struct semaphore 	cmd_done_sem;
	raw_spinlock_t 		irq_lock;
	int 				int_en_flag;
	u64 				dma_mask;
	int 				flash_bank; /* currently selected chip */

	struct dma_chan		*rx_channel;
	struct dma_chan		*tx_channel;
	struct semaphore	rx_semaphore;
	struct semaphore	tx_semaphore;	
};

struct spifc_reg_t
{
    uint32_t     VER_REG;                        //0x00
    uint32_t     SFC_START;                      //0x04
    uint32_t     SFC_EN;                         //0x08
    uint32_t     SFC_CTRL0;                      //0x0c
    uint32_t     SFC_CTRL1;                      //0x10
    uint32_t     SFC_CTRL2;                      //0x14
    uint32_t     SFC_BYTE_NUM;                   //0x18
    uint32_t     SFC_ADDR;                       //0x1c
    uint32_t     SFC_INS;                        //0x20
    uint32_t     SFC_TIMING;                     //0x24
    uint32_t     SFC_INT_EN;                     //0x28
    uint32_t     SFC_INT_RAW;                    //0x2c
    uint32_t     SFC_INT_SW_CLR;                 //0x30
    uint32_t     SFC_SW;                         //0x34
    uint32_t     SFC_DATA;                       //0x38
};

/*spifc start 0x4*/
#define     FC_START            		(1<<0)
#define     FC_BUSY             		(1<<0)

/*spifc enable 0x8*/
#define     FC_EN_BACK          		(1<<1)
#define     FC_EN               		(1<<0)

/*spifc main ctr0 0xc*/
#define     FC_SCLK_PAUSE_CLR_ALLOW     (1<<17)
#define     FC_SCLK_PAUSE_EN            (1<<16)
#define     FC_TXFIFO_CLR               (1<<15)
#define     FC_RXFIFO_CLR               (1<<14)
#define     FC_TXFIFO_THRES             (1<<10)
#define     FC_RXFIFO_THRES             (1<<6)
#define     FC_TX_DMA_EN                (1<<5)
#define     FC_RX_DMA_EN                (1<<4)
#define     FC_WDOG_EN                  (1<<3)
#define     FC_SPI_MODE                 (1<<1)
#define     FC_WR_PROTECT               (1<<0)

/*spifc ctrl1 0x10  in the condition : SFC_EN = 1 SFC_BUSY = 0*/
#define     FC_ADDR_TX_EN           	(4)
#define     FC_DUMMY_TX_EN          	(2)
#define     FC_READ_DAT_EN          	(1)
#define     FC_WRITE_DAT_EN         	(0)

/*spifc ctrl2 0x14*/
#define     FC_DUMMY_BYTE_NUM           (12)  /* [12:15} */
#define     FC_DUMMY_BIT_NUM            (8)   /* [8:10] */
#define     FC_ADDR_BYTE_NUM            (5)   /* [5:6] */
#define     FC_ADDR_BYTE_NUM_8          (0)
#define     FC_ADDR_BYTE_NUM_16         (1)
#define     FC_ADDR_BYTE_NUM_24         (2)
#define     FC_ADDR_BYTE_NUM_32         (3)
#define     FC_ADDR_MULTI_LINE_EN       (1<<4)
#define     FC_DAT_MULTI_LINE_EN        (1<<2)
#define     FC_TRANS_MOD                (1<<0)

/*spifc timing 0x24*/
#define     FC_READ_DELAY           	(1<<16)   /* [17:16} */
#define     FC_T_CS_SETUP           	(1<<11)   /* [11:13} */
#define     FC_T_CS_HOLD            	(1<<6)    /* [8:6} */
#define     FC_T_CS_DESEL           	(1<<0)    /* [0:3} */


/*spifc int enable 0x28*/
#define     FC_INT_EN_TX_BYD_THES       (1<<7)
#define     FC_INT_EN_RX_BYD_THES       (1<<6)
#define     FC_INT_EN_TX_UNDERRUN       (1<<5)
#define     FC_INT_EN_RX_OVERRUN        (1<<4)
#define     FC_INT_EN_WDOG_OVERRUN      (1<<2)
#define     FC_INT_EN_FMT_ERR           (1<<1)
#define     FC_INT_EN_CMD_END           (1<<0)

/*spifc raw interrupt 0x2c*/
#define     FC_INT_RAW_TX_BYD_THES      (1<<7)
#define     FC_INT_RAW_RX_BYD_THES      (1<<6)
#define     FC_INT_RAW_TX_UNDERRUN      (1<<5)
#define     FC_INT_RAW_RX_OVERRUN       (1<<4)
#define     FC_INT_RAW_WDOG_OVERRUN     (1<<2)
#define     FC_INT_RAW_FMT_ERR          (1<<1)
#define     FC_INT_RAW_CMD_END          (1<<0)
#define     FC_INT_RAW_ERR_MASK         (FC_INT_RAW_TX_UNDERRUN|\
                                        FC_INT_RAW_RX_OVERRUN|\
                                        FC_INT_RAW_WDOG_OVERRUN|\
                                        FC_INT_RAW_FMT_ERR)

/*spifc int startus and clr 0x30*/
#define     FC_INT_CLR_TX_BYD_THES      (1<<7)
#define     FC_INT_CLR_RX_BYD_THES      (1<<6)
#define     FC_INT_CLR_TX_UNDERRUN      (1<<5)
#define     FC_INT_CLR_RX_OVERRUN       (1<<4)
#define     FC_INT_CLR_WDOG_OVERRUN     (1<<2)
#define     FC_INT_CLR_FMT_ERR          (1<<1)
#define     FC_INT_CLR_CMD_END          (1<<0)

/*spifc sw 0x34*/
#define     FC_TX_FIFO_CNT              (16)
#define     FC_TX_FIFO_CNT_MASK         (0x1F)      /* [16:20} */
#define     FC_RX_FIFO_CNT              (8)
#define     FC_RX_FIFO_CNT_MASK         (0x1F)      /* [8:12} */
#define     FC_TX_BYD_THRES             (1<<5)
#define     FC_RX_BYD_THRES             (1<<4)
#define     FC_SCLK_PAUSE_FLAG          (1<<3)
#define     FC_WAIT_FLAG                (1<<2)
#define     FC_FORMAT_ERR               (1<<1)


#define 	FC_DMA_NONE           		0
#define 	FC_DMA_TX             		1
#define 	FC_DMA_RX             		2

#define 	SPIFC_IRQ_ALL				(FC_INT_EN_CMD_END|\
	                     				FC_INT_EN_FMT_ERR|\
	                     				FC_INT_EN_RX_OVERRUN|\
	                     				FC_INT_EN_TX_UNDERRUN|\
	                     				FC_INT_EN_FMT_ERR)

#endif  /* __ZXIC_SPIFC_H__ */

