/*
** Copyright (c) 2012 Silicon Laboratories, Inc.
** 2013-01-09 11:25:33
**
** Si3226x ProSLIC API Configuration Tool Version 2.12.0
*/


#include "proslic.h"
#include "si3226x.h"

#include "si3217x.h"        /* added by wanghaolei to reduce the parameters */

Si3226x_General_Cfg Si3226x_General_Configuration  = {
0x65,     /* DEVICE_KEY */
BO_DCDC_BUCK_BOOST,    /* BOM_OPT BJT PNP Buck boost */
BO_DCDC_TRACKING,    /* BAT_RAIL_TYPE */
0x000AD000L,    /* bat_hyst */
0x070A3D3AL,    /* VBATR_EXPECT (110.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x01999A00L,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x00F00000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x00809D80L,    /* DCDC_VERR_HYST */
0x00000000L,    /* DCDC_OITHRESH_LO */
0x00D00000L,    /* DCDC_OITHRESH_HI */
0x00400000L,    /* PD_UVLO */
0x00400000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00500000L,    /* DCDC_UVHYST */
0x00000000L,    /* DCDC_UVTHRESH */
0x00D00000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x00000000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00000000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00300000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x00FFC000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00000000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_9P0_16P0,    /* VDC_RANGE_OPT */
0x3F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x10,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x01000000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04B80200L,    /* UVTHRESH_SCALE */
0x00823000L     /* UVTHRESH_BIAS */
};



#ifdef SIVOICE_MULTI_BOM_SUPPORT

int si3226x_genconf_multi_max_preset = 7;

Si3226x_General_Cfg Si3226x_General_Configuration_MultiBOM[] = {
{ /* SI3226X_GEN_PARAM_BJT_BUCK_BOOST_VDC_9P0_16P0 */ 
0x65,     /* DEVICE_KEY */
BO_DCDC_BUCK_BOOST,    /* BOM_OPT BJT PNP Buck boost */
BO_DCDC_TRACKING,    /* BAT_RAIL_TYPE */
0x000AD000L,    /* bat_hyst */
0x070A3D3AL,    /* VBATR_EXPECT (110.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x01999A00L,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x00F00000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x00809D80L,    /* DCDC_VERR_HYST */
0x00000000L,    /* DCDC_OITHRESH_LO */
0x00D00000L,    /* DCDC_OITHRESH_HI */
0x00400000L,    /* PD_UVLO */
0x00400000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00500000L,    /* DCDC_UVHYST */
0x00000000L,    /* DCDC_UVTHRESH */
0x00D00000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x00000000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00600000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00600000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x00FFC000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00100000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_9P0_16P0,    /* VDC_RANGE_OPT */
0x3F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x10,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x01000000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04B80200L,    /* UVTHRESH_SCALE */
0x00823000L     /* UVTHRESH_BIAS */
},
{ /* SI3226X_GEN_PARAM_TSS */ 
0x64,     /* DEVICE_KEY */
BO_DCDC_FLYBACK,    /* BOM_OPT */
BO_DCDC_TSS,    /* BAT_RAIL_TYPE */
0x0050C480L,    /* bat_hyst */
0x06666635L,    /* VBATR_EXPECT (100.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x00F5C28FL,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x02000000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x0080C480L,    /* DCDC_VERR_HYST */
0x00800000L,    /* DCDC_OITHRESH_LO */
0x01F00000L,    /* DCDC_OITHRESH_HI */
0x00200000L,    /* PD_UVLO */
0x00300000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00300000L,    /* DCDC_UVHYST */
0x02100000L,    /* DCDC_UVTHRESH */
0x00400000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x07700000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00000000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00300000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x00FFC000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00000000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_10P8_20P0,    /* VDC_RANGE_OPT */
0x2F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x10,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x02200000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04F80200L,    /* UVTHRESH_SCALE */
0x00A23000L     /* UVTHRESH_BIAS */
},
{ /* SI3226X_GEN_PARAM_TSS_ISO */ 
0x64,     /* DEVICE_KEY */
BO_DCDC_FLYBACK,    /* BOM_OPT */
BO_DCDC_TSS_ISO,    /* BAT_RAIL_TYPE */
0x0050C480L,    /* bat_hyst */
0x06666635L,    /* VBATR_EXPECT (100.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x00F5C28FL,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x03200000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x0080C480L,    /* DCDC_VERR_HYST */
0x00800000L,    /* DCDC_OITHRESH_LO */
0x01F00000L,    /* DCDC_OITHRESH_HI */
0x00200000L,    /* PD_UVLO */
0x00300000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00100000L,    /* DCDC_UVHYST */
0x02100000L,    /* DCDC_UVTHRESH */
0x00400000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x06F00000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00000000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00300000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x00FFC000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00000000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_10P8_20P0,    /* VDC_RANGE_OPT */
0x2F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x10,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x01B00000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04F80200L,    /* UVTHRESH_SCALE */
0x00A23000L     /* UVTHRESH_BIAS */
},
{ /* SI3226X_GEN_PARAM_QCUK */ 
0x65,     /* DEVICE_KEY */
BO_DCDC_QCUK,    /* BOM_OPT */
BO_DCDC_TRACKING,    /* BAT_RAIL_TYPE */
0x000AD000L,    /* bat_hyst */
0x08A3D6C8L,    /* VBATR_EXPECT (135.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x01999A00L,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x00F00000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x00809D80L,    /* DCDC_VERR_HYST */
0x00800000L,    /* DCDC_OITHRESH_LO */
0x01F00000L,    /* DCDC_OITHRESH_HI */
0x00400000L,    /* PD_UVLO */
0x00400000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00500000L,    /* DCDC_UVHYST */
0x00000000L,    /* DCDC_UVTHRESH */
0x01700000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x00000000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00000000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00300000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x00FFC000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00000000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_4P5_16P0,    /* VDC_RANGE_OPT */
0x3F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x10,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x01000000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04B80200L,    /* UVTHRESH_SCALE */
0x00823000L     /* UVTHRESH_BIAS */
},
{ /* SI3226X_GEN_PARAM_LCQCUK */ 
0x65,     /* DEVICE_KEY */
BO_DCDC_LCQCUK,    /* BOM_OPT */
BO_DCDC_TRACKING,    /* BAT_RAIL_TYPE */
0x000AD000L,    /* bat_hyst */
0x051EB82AL,    /* VBATR_EXPECT (80.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x01999A00L,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x00F00000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x00809D80L,    /* DCDC_VERR_HYST */
0x00000000L,    /* DCDC_OITHRESH_LO */
0x01C00000L,    /* DCDC_OITHRESH_HI */
0x00400000L,    /* PD_UVLO */
0x00400000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00500000L,    /* DCDC_UVHYST */
0x00000000L,    /* DCDC_UVTHRESH */
0x00500000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x00000000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00000000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00300000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x00FFC000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00000000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_4P5_16P0,    /* VDC_RANGE_OPT */
0x3F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x10,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x01000000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04B80200L,    /* UVTHRESH_SCALE */
0x00823000L     /* UVTHRESH_BIAS */
},
{ /* SI3226X_GEN_PARAM_CUK */ 
0x65,     /* DEVICE_KEY */
BO_DCDC_CUK,    /* BOM_OPT */
BO_DCDC_TRACKING,    /* BAT_RAIL_TYPE */
0x000AD000L,    /* bat_hyst */
0x0851EB45L,    /* VBATR_EXPECT (130.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x01999A00L,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x00F00000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x00809D80L,    /* DCDC_VERR_HYST */
0x01200000L,    /* DCDC_OITHRESH_LO */
0x02100000L,    /* DCDC_OITHRESH_HI */
0x00400000L,    /* PD_UVLO */
0x00400000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00500000L,    /* DCDC_UVHYST */
0x00000000L,    /* DCDC_UVTHRESH */
0x01400000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x00000000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00000000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00300000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x00FFC000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00000000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_27P0_42P0,    /* VDC_RANGE_OPT */
0x3F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x10,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x01000000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04B80200L,    /* UVTHRESH_SCALE */
0x00823000L     /* UVTHRESH_BIAS */
},
{ /* SI3226X_GEN_PARAM_PMOS_BUCK_BOOST_VDC_4P5_16P0 */ 
0x65,     /* DEVICE_KEY */
BO_DCDC_PMOS_BUCK_BOOST,    /* BOM_OPT */
BO_DCDC_TRACKING,    /* BAT_RAIL_TYPE */
0x000AD000L,    /* bat_hyst */
0x070A3D3AL,    /* VBATR_EXPECT (110.00) */
0x03D70A20L,    /* VBATH_EXPECT (60.00) */
0x0FFF0000L,    /* PWRSAVE_TIMER */
0x01999A00L,    /* OFFHOOK_THRESH */
0x00F00000L,    /* VBAT_TRACK_MIN */
0x00F00000L,    /* VBAT_TRACK_MIN_RNG */
0x00014000L,    /* PWRSAVE_DBI */
0x0ADD5500L,    /* DCDC_ANA_SCALE */
0x00312700L,    /* VOV_BAT_PWRSAVE_MIN */
0x00395800L,    /* VOV_BAT_PWRSAVE_MIN_RNG */
0x00800000L,    /* THERM_DBI */
0x00004000L,    /* CPUMP_DBI */
0x00F18900L,    /* DCDC_VERR */
0x00809D80L,    /* DCDC_VERR_HYST */
0x00000000L,    /* DCDC_OITHRESH_LO */
0x00D00000L,    /* DCDC_OITHRESH_HI */
0x00400000L,    /* PD_UVLO */
0x00400000L,    /* PD_OVLO */
0x00200000L,    /* PD_OCLO */
0x00400000L,    /* PD_SWDRV */
0x00500000L,    /* DCDC_UVHYST */
0x00000000L,    /* DCDC_UVTHRESH */
0x00D00000L,    /* DCDC_OVTHRESH */
0x00800000L,    /* DCDC_OITHRESH */
0x00000000L,    /* DCDC_SWDRV_POL */
0x00000000L,    /* DCDC_UVPOL */
0x00000000L,    /* DCDC_VREF_MAN */
0x00000000L,    /* DCDC_VREF_CTRL */
0x00200000L,    /* DCDC_RNGTYPE */
0x05B00000L,    /* DCDC_ANA_VREF */
0x00300000L,    /* DCDC_ANA_GAIN */
0x00300000L,    /* DCDC_ANA_TOFF */
0x00100000L,    /* DCDC_ANA_TONMIN */
0x01F00000L,    /* DCDC_ANA_TONMAX */
0x00F00000L,    /* DCDC_ANA_DSHIFT */
0x0FDA4000L,    /* DCDC_ANA_LPOLY */
0x00000000L,    /* DCDC_AUX_INVERT */
0x00400000L,    /* DCDC_CPUMP_LP */
0x00000000L,    /* DCDC_CPUMP_PULLDOWN */
0x00000000L,    /* DCDC_LIFT_EN */
0x07FEB800L,    /* COEF_P_HVIC */
0x005B05B2L,    /* P_TH_HVIC */
VDC_4P5_16P0,    /* VDC_RANGE_OPT */
0x3F,     /* AUTO */
0x00,     /* IRQEN1 */
0x00,     /* IRQEN2 */
0x03,     /* IRQEN3 */
0x00,     /* IRQEN4 */
0x20,     /* ENHANCE */
0x03A2E8BAL,    /* SCALE_KAUDIO */
0x04,    /* ZCAL_EN */
0x03000000L,    /* LKG_OFHK_OFFSET */
0x05000000L,    /* LKG_LB_OFFSET */
0x01000000L,    /* VBATH_DELTA */
0x03700000L,    /* UVTHRESH_MAX */
0x04B80200L,    /* UVTHRESH_SCALE */
0x00823000L     /* UVTHRESH_BIAS */
}
};
#endif

Si3226x_GPIO_Cfg Si3226x_GPIO_Configuration = {
0x00,     /* GPIO_OE */
0x06,     /* GPIO_ANA */
0x00,     /* GPIO_DIR */
0x00,     /* GPIO_MAN */
0x00,     /* GPIO_POL */
0x00,     /* GPIO_OD */
0x00     /* BATSELMAP */
};

Si3226x_CI_Cfg Si3226x_CI_Presets [] = {
{0}
};

Si3226x_audioGain_Cfg Si3226x_audioGain_Presets [] = {
{0x1377080L,0, 0x0L, 0x0L, 0x0L, 0x0L},
{0x80C3180L,0, 0x0L, 0x0L, 0x0L, 0x0L}
};

#if defined (SILAB_SUPPORT_BUCKBOOST)
Si3226x_Ring_Cfg Si3226x_Ring_Presets[] ={
/*
	Loop = 500.0 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x001BD000L,	/* RINGAMP (40.000 vrms)  57Vpk */ /* 0x001AE2A4L,RINGAMP (35.000 vrms)test 38.5vrms */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x0097397BL,	/* IRING_LIM (65.000 mA) */
0x005E0000L,	/* RTACTH (45.210 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x045494D2L,	/* VBATR_EXPECT (67.662 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x022A4A69L,	/* VCM_RING (30.831 v) */
0x022A4A69L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_40VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x001F2000L,	/* RINGAMP (45.000 vrms)  64Vpk */ /* 0x002198F8L,RINGAMP (45.000 vrms)test 48.5vrms */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x0097397BL,	/* IRING_LIM (65.000 mA) */
0x006E0000L,	/* RTACTH (56.498 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x053843FDL,	/* VBATR_EXPECT (81.559 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x029C21FEL,	/* VCM_RING (37.780 v) */
0x029C21FEL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_45VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x00229000L,	/* RINGAMP (50.000 vrms)  71Vpk */ /* 0x0022911CL,RINGAMP (45.000 vrms)test 50vrms */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x0097397BL,	/* IRING_LIM (65.000 mA) */
0x007E0000L,	/* RTACTH (58.128 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x0559252AL,	/* VBATR_EXPECT (83.566 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x02AC9295L,	/* VCM_RING (38.783 v) */
0x02AC9295L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_50VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x00261000L,	/* RINGAMP (55.000 vrms)  78Vpk */ /*0x00266858L, RINGAMP (50.000 vrms)test 55vrms  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00A2DB71L,	/* IRING_LIM (70.000 mA) */
0x007E0000L,	/* RTACTH (64.586 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x05DB6D55L,	/* VBATR_EXPECT (91.518 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x02EDB6AAL,	/* VCM_RING (42.759 v) */
0x02EDB6AAL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_55VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x00298000L,	/* RINGAMP (60.000 vrms)  85Vpk */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00A2DB71L,	/* IRING_LIM (70.000 mA) */
0x007F0000L,	/* RTACTH (64.586 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x06147AB2L,	/* VBATR_EXPECT (95 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x02EDB6AAL,	/* VCM_RING (42.759 v) */
0x02EDB6AAL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_60VRMS_0VDC_BAL */
};
#elif defined (SILAB_SUPPORT_LCQC)
Si3226x_Ring_Cfg Si3226x_Ring_Presets[] ={
/*
	Loop = 500.0 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x001BD000L,	/* RINGAMP (40.000 vrms)  57Vpk */ /* 0x001AE2A4L,RINGAMP (35.000 vrms)test 38.5vrms */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x0072B158L,	/* 0x0097397BL IRING_LIM (65.000 mA) to 0x0072B158L 49.3mA */
0x004470B0L,	/* 0x005E0000L RTACTH (45.210 mA) to 0x004470B0L 47.2 */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00000000L,	/* 0x00C49BA0L VOV_RING_BAT (12.000 v) to 0v */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x045494D2L,	/* VBATR_EXPECT (67.662 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x022A4A69L,	/* VCM_RING (30.831 v) */
0x022A4A69L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_40VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x001F2000L,	/* RINGAMP (45.000 vrms)  64Vpk */ /* 0x002198F8L,RINGAMP (45.000 vrms)test 48.5vrms */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x0072B158L,	/* 0x0097397BL IRING_LIM (65.000 mA) to 0x0072B158L 49.3mA */
0x004470B0L,	/* 0x006E0000L RTACTH (56.498 mA) to 0x004470B0L 47.2 */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00000000L,	/* 0x00C49BA0L VOV_RING_BAT (12.000 v) to 0x00000000L 0v */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x0494F990L,	/* 0x053843FDL VBATR_EXPECT (81.559 v) to 0x0494F990L 71.5v */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x029C21FEL,	/* VCM_RING (37.780 v) */
0x029C21FEL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_45VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x00229000L,	/* RINGAMP (50.000 vrms)  71Vpk */ /* 0x0022911CL,RINGAMP (45.000 vrms)test 50vrms */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x007F6FB7L,	/* 0x0097397BL IRING_LIM (65.000 mA) to 0x007F6FB7L 54.8mA */
0x004C0B6EL,	/* 0x007E0000L RTACTH (58.128 mA) to 0x004C0B6EL 52.5mA */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00000000L,	/* 0x00C49BA0L VOV_RING_BAT (12.000 v) to 0x00000000L 0v */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x0508D3C1L,	/* 0x0559252AL VBATR_EXPECT (83.566 v) to 0x0508D3C1L 78.6v */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x02AC9295L,	/* VCM_RING (38.783 v) */
0x02AC9295L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_50VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x00261000L,	/* RINGAMP (55.000 vrms)  78Vpk */ /*0x00266858L, RINGAMP (50.000 vrms)test 55vrms  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00726B40L,	/* 0x00A2DB71L IRING_LIM (70.000 mA) to 0x00726B40L 49.2mA */
0x004446DCL,	/* 0x007E0000L RTACTH (64.586 mA) to 0x004446DCL 47.2mA */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00000000L,	/* 0x00C49BA0L VOV_RING_BAT (12.000 v) to 0x00000000L 0v */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x057A6023L,	/* 0x05DB6D55L VBATR_EXPECT (91.518 v) to 0x057A6023L 85.6v */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x02EDB6AAL,	/* VCM_RING (42.759 v) */
0x02EDB6AAL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_55VRMS_0VDC_BAL */
{
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x00298000L,	/* RINGAMP (60.000 vrms)  85Vpk */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x007CD217L,	/* 0x00A2DB71L IRING_LIM (70.000 mA) to 0x007CD217L 53.7mA */
0x004A7BD9L,	/* 0x007F0000L RTACTH (64.586 mA) to 0x004A7BD9L 51.4mA */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00004000L,	/* RTACDB (40.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00000000L,	/* 0x00C49BA0L VOV_RING_BAT (12.000 v) to 0x00000000L 0v */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x05F08825L,	/* 0x06147AB2L VBATR_EXPECT (95 v) to 0x05F08825L 93v */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x02EDB6AAL,	/* VCM_RING (42.759 v) */
0x02EDB6AAL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},    /* RING_F25_60VRMS_0VDC_BAL */
};
#endif

Si3226x_DCfeed_Cfg Si3226x_DCfeed_Presets[] = {
{
0x1C8A024CL,	/* SLOPE_VLIM */
0x1F909679L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1D5B21A9L,	/* SLOPE_DELTA1 */
0x1DD87A3EL,	/* SLOPE_DELTA2 */
0x05A38633L,	/* V_VLIM (48.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x00B4F3C3L,	/* CONST_RFEED (15.000 mA) */
0x005D0FA6L,	/* CONST_ILIM (20.000 mA) */
0x002D8D96L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_48V_20MA */
{
0x1C8A024CL,	/* SLOPE_VLIM */
0x1F03C159L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1CC4B75DL,	/* SLOPE_DELTA1 */
0x1DD87A3EL,	/* SLOPE_DELTA2 */
0x05A38633L,	/* V_VLIM (48.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x010DE095L,	/* CONST_RFEED (15.000 mA) */
0x006FAC61L,	/* CONST_ILIM (24.000 mA) */
0x002D8D96L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_48V_24MA */
{
0x1C8A024CL,	/* SLOPE_VLIM */
0x1E76EC3AL,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1BD85977L,	/* SLOPE_DELTA1 */
0x1DD87A3EL,	/* SLOPE_DELTA2 */
0x05A38633L,	/* V_VLIM (48.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x0166CD67L,	/* CONST_RFEED (15.000 mA) */
0x0082491BL,	/* CONST_ILIM (28.000 mA) */
0x002D8D96L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_48V_28MA */
{
0x1C8A024CL,	/* SLOPE_VLIM */
0x1DEA171BL,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1A2EE3A7L,	/* SLOPE_DELTA1 */
0x1DD87A3EL,	/* SLOPE_DELTA2 */
0x05A38633L,	/* V_VLIM (48.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x01BFBA39L,	/* CONST_RFEED (15.000 mA) */
0x0094E5D6L,	/* CONST_ILIM (32.000 mA) */
0x002D8D96L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_48V_32MA */
{
0x1E3081AAL,	/* SLOPE_VLIM */
0x1F909679L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1A2EE3A7L,	/* SLOPE_DELTA1 */
0x1C1F426FL,	/* SLOPE_DELTA2 */
0x061BD162L,	/* V_VLIM (52.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x00B4F3C3L,	/* CONST_RFEED (15.000 mA) */
0x005D0FA6L,	/* CONST_ILIM (20.000 mA) */
0x00315962L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_52V_20MA */
{
0x1E3081AAL,	/* SLOPE_VLIM */
0x1F03C159L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0xF64E2617L,	/* SLOPE_DELTA1 */
0x1C1F426FL,	/* SLOPE_DELTA2 */
0x061BD162L,	/* V_VLIM (52.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x010DE095L,	/* CONST_RFEED (15.000 mA) */
0x006FAC61L,	/* CONST_ILIM (24.000 mA) */
0x00315962L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_52V_24MA */
{
0x1D28720FL,	/* SLOPE_VLIM */
0x1EE95963L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1B7011ECL,	/* SLOPE_DELTA1 */
0x1D6A2C4AL,	/* SLOPE_DELTA2 */
0x061BD162L,	/* V_VLIM (52.000 v) */
0x0567609CL,	/* V_RFEED (46.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x012DAC54L,	/* CONST_RFEED (15.000 mA) */
0x0082491BL,	/* CONST_ILIM (28.000 mA) */
0x00315962L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_52V_28MA */
{
0x1B9C5AA7L,	/* SLOPE_VLIM */
0x1EBFDA98L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1D737E98L,	/* SLOPE_DELTA1 */
0x1E46C831L,	/* SLOPE_DELTA2 */
0x061BD162L,	/* V_VLIM (52.000 v) */
0x05A38633L,	/* V_RFEED (48.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x015500A8L,	/* CONST_RFEED (15.000 mA) */
0x0094E5D6L,	/* CONST_ILIM (32.000 mA) */
0x00315962L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},    /* DCFEED_52V_32MA */
};

Si3226x_Impedance_Cfg Si3226x_Impedance_Presets[] ={
/* parameters: zref=200_680_100 rprot=20 rfuse=0 emi_cap=10*/
{
{0x0721FD00L, 0x1FD2AA80L, 0x00027E80L, 0x1FFD4300L,    /* TXACEQ */
 0x09B7CF80L, 0x1D33A080L, 0x006DD680L, 0x1FE08A00L},   /* RXACEQ */
{0x1FF93B80L, 0x00365F80L, 0x00DDBA00L, 0x0129A800L,    /* ECFIR/ECIIR */
 0x0311AA80L, 0x1E718200L, 0x02D3AB80L, 0x1E303E80L,
 0x01181C00L, 0x1EE22300L, 0x051CA700L, 0x02C7AE00L},
{0x01484900L, 0x1C91C280L, 0x0225C700L, 0x0A131400L,    /* ZSYNTH */
 0x1DEA8F80L, 0x8B}, 
 0x08000000L,   /* TXACGAIN */
 0x010ABA80L,   /* RXACGAIN */
 0x07BA3000L, 0x1845D080L, 0x07745F80L,    /* RXACHPF */
 0, 0  /* TXGAIN, RXGAIN */
 },   /*ZSYN_200_680_NOPTC*/
/* parameters: zref=200_680_100 rprot=30 rfuse=100 emi_cap=10 */
{
{0x085D0E80L, 0x1F748400L, 0x0004AD80L, 0x1FF9AA80L,    /* TXACEQ */
 0x09FCA680L, 0x1CB9A780L, 0x008BB680L, 0x1FD9FD00L},   /* RXACEQ */
{0x00056600L, 0x1FF5FB00L, 0x01879280L, 0x000A7200L,    /* ECFIR/ECIIR */
 0x0420E200L, 0x1DEC9600L, 0x02994D80L, 0x1EEF9600L,
 0x006D8E00L, 0x1F8EF300L, 0x07F34E80L, 0x1FF84B80L},
{0x00A95300L, 0x1D43E580L, 0x0212AD00L, 0x0A159100L,    /* ZSYNTH */
 0x1DE99980L, 0xC0}, 
 0x08012B00L,   /* TXACGAIN */
 0x01307B80L,   /* RXACGAIN */
 0x07B9A700L, 0x18465980L, 0x07734E80L,    /* RXACHPF */
 0, 0  /* TXGAIN, RXGAIN */
},    /* ZSYN_200_680_HAVEPTC */
/* parameters: zref=600_0_0 rprot=20 rfuse=0 emi_cap=10*/
{
{0x07F97D80L, 0x0006CC00L, 0x1FFC1480L, 0x1FFC7B80L,    /* TXACEQ */
 0x07F36B80L, 0x000A8E00L, 0x1FF90F00L, 0x1FFAE500L},   /* RXACEQ */
{0x001AF400L, 0x1FC86A80L, 0x01E9AE00L, 0x00652F00L,    /* ECFIR/ECIIR */
 0x01F4AF00L, 0x1F57E000L, 0x00485E00L, 0x1FF3A680L,
 0x1FF83700L, 0x00011D00L, 0x01706980L, 0x066A8480L},
{0x00920F00L, 0x1EE31980L, 0x008ADF00L, 0x0F92E500L,    /* ZSYNTH */
 0x186CE880L, 0x53}, 
 0x085C6880L,   /* TXACGAIN */
 0x013E3100L,   /* RXACGAIN */
 0x07AF6F80L, 0x18509100L, 0x075EDF00L,    /* RXACHPF */
 0, 0  /* TXGAIN, RXGAIN */
 },  /* ZSYN_600_NOPTC */
/* parameters: zref=600_0_0 rprot=30 rfuse=100 emi_cap=10*/
{
{0x07F53C00L, 0x000DD800L, 0x00010900L, 0x1FFDB880L,    /* TXACEQ */
 0x07EE0C80L, 0x0012CD80L, 0x1FFE5E80L, 0x1FFCBF00L},   /* RXACEQ */
{0x001E4E80L, 0x1FB8F500L, 0x01F8E080L, 0x0024BB80L,    /* ECFIR/ECIIR */
 0x021DEF00L, 0x1F249180L, 0x006C7580L, 0x1FD9A500L,
 0x0008B200L, 0x1FF2A680L, 0x02577380L, 0x0558D480L},
{0x007F8C00L, 0x1F01CE80L, 0x007EA600L, 0x0FF66D00L,    /* ZSYNTH */
 0x18099280L, 0x75}, 
 0x0A5DB400L,   /* TXACGAIN */
 0x018AC480L,   /* RXACGAIN */
 0x07B49980L, 0x184B6700L, 0x07693380L,    /* RXACHPF */
 0, 0  /* TXGAIN, RXGAIN */
 }    /* ZSYN_600_HAVEPTC */
};

Si3226x_FSK_Cfg Si3226x_FSK_Presets[] ={
{
0x02232000L,	 /* FSK01 */
0x077C2000L,	 /* FSK10 */
0x003C0000L,	 /* FSKAMP0 (0.220 vrms )*/
0x00200000L,	 /* FSKAMP1 (0.220 vrms) */
0x06B60000L,	 /* FSKFREQ0 (2200.0 Hz space) */
0x079C0000L,	 /* FSKFREQ1 (1200.0 Hz mark) */
0x00,			 /* FSK8 */
0x00,			 /* FSKDEPTH (1 deep fifo) */
}    /* DEFAULT_FSK */
};

Si3226x_PulseMeter_Cfg Si3226x_PulseMeter_Presets[] ={
{
0x007A2B6AL,  /* PM_AMP_THRESH (1.000) */
0,            /* Freq (12kHz) */ 
0,            /* PM_AUTO (off)*/
0x07D00000L,  /* PM_active (2000 ms) */
0x07D00000L   /* PM_inactive (2000 ms) */
}    /* DEFAULT_PULSE_METERING */
};

Si3226x_Tone_Cfg Si3226x_Tone_Presets[] = {
{
{
	0x07810000L,	 /* OSC1FREQ (450.000 Hz) */
	0x00100000L,	 /* OSC1AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC1PHAS (0.000 rad) */
	0x00,			 /* O1TALO (0 ms) */
	0x00,			 /* O1TAHI */
	0x00,			 /* O1TILO (0 ms) */
	0x00			 /* O1TIHI */
	},
	{
	0x07B30000L,	 /* OSC2FREQ (350.000 Hz) */
	0x000C6000L,	 /* OSC2AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC2PHAS (0.000 rad) */
	0x00,			 /* O2TALO (0 ms) */
	0x00,			 /* O2TAHI */
	0x00,			 /* O2TILO (0 ms) */
	0x00 			 /* O2TIHI */
	},
	0x66 			 /* OMODE */
},    /* TONEGEN_450_N18DB_350_N18DB */
};

Si3226x_PCM_Cfg Si3226x_PCM_Presets[] ={
	{
	0x01, 	 /* PCM_FMT - u-Law */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT EVEN */
	},  /* PCM_8ULAW */
	{
	0x00, 	 /* PCM_FMT - A-Law */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x01 	 /* A-LAW -  INVERT EVEN */
	},  /* PCM_8ALAW */
	{
	0x03, 	 /* PCM_FMT - 16-bit Linear */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT EVEN */
	},  /* PCM_16LIN */
	{
	0x03, 	 /* PCM_FMT - 16-bit Linear */
	0x01, 	 /* WIDEBAND - ENABLED (7kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT EVEN */
	}    /* PCM_16LIN_WB */
};


