/*
** $Id: dummy_spi.c 109 2008-10-22 19:45:09Z lajordan@SILABS.COM $
**
** spi.h
** SPI driver implementation file
**
** Author(s): 
** laj
**
** Distributed by: 
** Silicon Laboratories, Inc
**
** File Description:
** This is the implementation file for the SPI driver used 
** in the ProSLIC demonstration code. 
**
** Dependancies:
** 
**
*/

#include <linux/kernel.h> 
#include <linux/module.h>
#include <linux/param.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/version.h>
#include <linux/types.h>
#include <linux/delay.h>
#include <linux/spinlock.h>
#include <linux/mutex.h>
#include <linux/spi/spi.h>

#include "silicon_spi.h"
#include "si_voice_datatypes.h"
#include "si3217x_registers.h"
#define DELAY_CNT       10  

#define MAX_SPI_READ_TIMS       200
#undef DEBUG_SLIC_ON
uInt8 Si_shit[] = {0,16,8,24,4,20,12};
//#define USE_GPIO_SPI 1

static DEFINE_MUTEX(spi_lock);

extern unsigned char spi_gpio_read_single8(void);
extern void spi_gpio_write_single8(unsigned char data);
extern void spi_gpio_mode_start(void);
extern void spi_gpio_mode_stop(void);
extern struct spi_device *pslicSpi;
void SPI_BUS_LOCK(void)
{
	mutex_lock(&spi_lock);
}
void SPI_BUS_UNLOCK(void)
{
	mutex_unlock(&spi_lock);
}
int spi_chipid_get(unsigned char port, unsigned char *cs, unsigned char *ch)
{
	return 0;
}
int spi_readb(unsigned char chip_select, unsigned char *pdata)
{
	unsigned char read_byte;
	read_byte = spi_gpio_read_single8();
	memcpy(pdata, &read_byte, 1);
	return 0;
}
int spi_writeb(unsigned char chip_select, unsigned char data)
{
	spi_gpio_write_single8(data);
	return 0;
}


/*
** Function: SPI_Init
**
** Description: 
** Initializes the SPI interface
**
** Input Parameters: 
** none
**
** Return:
** none
*/
void SPI_Init (void){

#ifdef  USE_GPIO_SPI_SLIC

    spi_gpio_mode_start();
#endif
	return;
}

void SPI_Exit (void){
#ifdef  USE_GPIO_SPI_SLIC
    spi_gpio_mode_stop();
#endif
	return;
}

/*
** Function: SlicHardReset
**
** Description: 
** Input Parameters:
** none
**
** Return:
** none
*/
void SlicHardReset(void)
{
    
    return;
}


/*
** Function: spiGci_ResetWrapper
**
** Description: 
** Sets the reset pin of the ProSLIC
*/
int ctrl_ResetWrapper (void * hSpiGci, int status)
{
    ctrl_WriteRegisterWrapper(hSpiGci,0,1,status); /* bit1 */
    
    return 0;
}

 void ctrl_ReadRegister(uInt8 cs, uInt8 channel, uInt8 regAddr, uInt8 *prdata)
{
    uInt8 rctrl     = 0;
	uInt8 rctrlbuf[2];
	int ret = 0;
    rctrl = (((Si_shit[channel%CHIP_NUM_IN_DAISY]) & SPI_CID_MASK )| SPI_REG_BIT) | (SPI_READ_BIT);
	
#ifdef  USE_GPIO_SPI_SLIC

    spi_writeb(cs, rctrl); 
    udelay(DELAY_CNT);
    spi_writeb(cs, regAddr);
    udelay(DELAY_CNT);
    spi_readb(cs, prdata);
#elif defined USE_STD_SPI_SLIC

	rctrlbuf[0] = rctrl;
	rctrlbuf[1] = regAddr;
	ret += spi_write(pslicSpi, rctrlbuf, 1);
       udelay(10);
	ret += spi_write(pslicSpi, &rctrlbuf[1], 1);
       udelay(10);
	ret += spi_read(pslicSpi, prdata, 1);
	//printk("ctrl_ReadRegister fail rctrl: =%x,regAddr=%x\n",rctrl,regAddr);

	if(ret != 0)
	{
		printk("ctrl_ReadRegister fail ret =%d\n",ret);
	}
#endif
    return;
}

 void ctrl_WriteRegister(uInt8 cs, uInt8 channel,  uInt8 regAddr, uInt8 wdata)
{
    uInt8 wctrl     = 0;
	int ret =0;
	uInt8 wctrlbuf[3];
    wctrl = (((Si_shit[channel%CHIP_NUM_IN_DAISY]) & SPI_CID_MASK) | SPI_REG_BIT) & ~SPI_READ_BIT;
#ifdef  USE_GPIO_SPI_SLIC


    spi_writeb(cs, wctrl); 
    udelay(DELAY_CNT);
    spi_writeb(cs, regAddr);
    udelay(DELAY_CNT);
    spi_writeb(cs, wdata);
	
#elif defined USE_STD_SPI_SLIC

	wctrlbuf[0] = wctrl;
	wctrlbuf[1] = regAddr;
	wctrlbuf[2] = wdata;

	ret += spi_write(pslicSpi, wctrlbuf, 1);
       udelay(10);
	ret += spi_write(pslicSpi, &wctrlbuf[1], 1);
       udelay(10);
	ret += spi_write(pslicSpi, &wctrlbuf[2], 1);

	if(ret != 0)
	{
		printk("ctrl_WriteRegister fail ret =%d\n",ret);
	}
#endif
    return;
}

/*
** SPI/GCI register read 
**
** Description: 
** Reads a single ProSLIC register
**
** Input Parameters: 
** channel: ProSLIC channel to read from
** num: number of reads to perform
** regAddr: Address of register to read
** addr_inc: whether to increment address after each read
** data: data to read from register
**
** Return:
** none
*/

uInt8 ctrl_ReadRegisterWrapper (void * hSpiGci, uInt8 channel,uInt8 regAddr)
{
    uInt8 rdata = 0;

    SPI_BUS_LOCK();
    ctrl_ReadRegister(((ctrl_S *)hSpiGci)->port, channel, regAddr, &rdata);
    SPI_BUS_UNLOCK();

    return rdata;
}


/*
** Function: spiGci_WriteRegisterWrapper 
**
** Description: 
** Writes a single ProSLIC register
**
** Input Parameters: 
** channel: ProSLIC channel to write to
** address: Address of register to write
** data: data to write to register
**
** Return:
** none
*/
int ctrl_WriteRegisterWrapper (void * hSpiGci, uInt8 channel,  uInt8 regAddr, uInt8 data)
{
    SPI_BUS_LOCK();
    ctrl_WriteRegister(((ctrl_S *)hSpiGci)->port, channel, regAddr, data);
    SPI_BUS_UNLOCK();
    
    return 0;
}


/*
** Function: SPI_ReadRAMWrapper
**
** Description: 
** Reads a single ProSLIC RAM location
**
** Input Parameters: 
** channel: ProSLIC channel to read from
** address: Address of RAM location to read
** pData: data to read from RAM location
**
** Return:
** none
*/
uInt32 ctrl_ReadRAMWrapper (void * hSpiGci, uInt8 channel, uInt16 ramAddr)
{
    uInt8 TimCnt    = 0;
    uInt8 wdata     = 0;
    uInt8 rdata     = 0;
    uInt32 rx       = 0;
    ctrl_S *pSpi    = (ctrl_S *)hSpiGci;
    
    SPI_BUS_LOCK();
    /*1. Write REG5 (RAM_ADR_HI) to set up bits [10:8] of the desired RAM address. */
    wdata = ((ramAddr>>3) & 0xe0);
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_ADDR_HI, wdata);
    
    /* 2. Write REG10 (RAM_ADR_LO). This action initiates the READ transaction causing the RAM_STAT bit to set. */
    wdata = (uInt8)ramAddr;
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_ADDR_LO, wdata);

    /* 3. Wait for the RAM_STAT bit to clear.*/
    while(1)
    {
        ctrl_ReadRegister(pSpi->port, channel, SI3217X_COM_REG_RAMSTAT, &rdata);
        
        if( (rdata&1) == 0 ) break;
        
        TimCnt++;
        if( TimCnt > MAX_SPI_READ_TIMS )
        {
            /* The chip didn't ack, maybe broken. */
            printk("\nSLIC Read RAM error at channel %d, at ramAddr 0x%x!\n", channel, ramAddr);
            SPI_BUS_UNLOCK();
            return 0;
        }
    }
    
    /* 4. Read the 29-bit data from REG 6 through REG 9 (RAM_DATA_B0 through RAM_DATA_B3). */
    ctrl_ReadRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B0, &rdata);
    rx = rdata>>3;
    ctrl_ReadRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B1, &rdata);
    rx |= rdata<<5;
    ctrl_ReadRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B2, &rdata);
    rx |= rdata<<13;
    ctrl_ReadRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B3, &rdata);
    rx |= rdata<<21;
    SPI_BUS_UNLOCK();
    
    return rx;
}


/*
** Function: SPI_WriteRAMWrapper
**
** Description: 
** Writes a single ProSLIC RAM location
**
** Input Parameters: 
** channel: ProSLIC channel to write to
** address: Address of RAM location to write
** data: data to write to RAM location
**
** Return:
** none
*/
int ctrl_WriteRAMWrapper (void * hSpiGci, uInt8 channel, uInt16 ramAddr, ramData data)
{
    uInt8 TimCnt    = 0;
    uInt8 wdata     = 0;
    uInt8 rdata     = 0;
    ctrl_S *pSpi    = (ctrl_S *)hSpiGci;
    
    SPI_BUS_LOCK();
    /*1. Write REG5 (RAM_ADR_HI) to set up bits [10:8] of the desired RAM address.*/    
    wdata = ((ramAddr>>3) & 0xe0);
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_ADDR_HI, wdata);

    /*2. Write REG6 through REG9 (RAM_DATA_B0 through RAM_DATA_B3) with the desired 29-bit data to be written.*/
    wdata = (uInt8) (data<<3);
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B0, wdata);

    wdata = (uInt8) (data>>5);
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B1, wdata);
    
    wdata = (uInt8) (data>>13);
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B2, wdata);
    
    wdata = (uInt8) (data>>21);
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_DATA_B3, wdata);
    
    /*3. Write REG10 (RAM_ADR_LO). This action initiates the WRITE transaction causing the RAM_STAT bit in REG5
    (RAMSTAT) to set.*/  
    wdata = (uInt8)ramAddr;
    ctrl_WriteRegister(pSpi->port, channel, SI3217X_COM_REG_RAM_ADDR_LO, wdata);
    
    /*4. The WRITE transaction is complete when the RAM_STAT bit clears. */
    while(1)
    {
        ctrl_ReadRegister(pSpi->port, channel, SI3217X_COM_REG_RAMSTAT, &rdata);
        
        if( (rdata&1) == 0 ) break;
        
        TimCnt++;
        if( TimCnt > MAX_SPI_READ_TIMS )
        {
            /* The chip didn't ack, maybe broken. */
            printk("\nSLIC Write RAM error at channel %d, at ramAddr 0x%x!\n", channel, ramAddr);
            SPI_BUS_UNLOCK();
            return 0;
        }
    }
    SPI_BUS_UNLOCK();
    
    return 0;
}


