#ifndef _USR_LINE_H
#define _USR_LINE_H

#include <asm/types.h>
#include <linux/mutex.h>
#include "112.h"
#include "si_adt.h"
#include "silicon_spi.h"
#include "si3217x_registers.h"

#define USL_MAJOR               211         /* device num */
#define USL_NAME                "slic"   /* device name */

#define MSGMAX                  32
#define SLIC_PORT_TYPE          0
#define DAA_PORT_TYPE           1

/* if line is ok to be scaned or operated */
#define LINE_NOTINIT            0
#define LINE_INITOK             1
#define LINE_DISABLE            0
#define LINE_ENABLE             1

#define SLC_SUCCESS             (0)
#define SLC_FAIL                (-1)

typedef enum {
    SLIC_UNKNOWN_CMD           = -1, /* unknow cmd */

	/* modified cmd*/
    SLIC_DEV_INIT    = 0,         /* ʼSLICоƬ */
    SLIC_MSG_REV,                 /* ϱ¼*/
    SLIC_TEST,
    SLIC_SIGNAL_START,            /* ʼ */
    SLIC_SIGNAL_STOP,             /* ֹͣ */
    SLIC_PCM_OPEN  = 5,                /* PCMͨ· */  
    SLIC_PCM_CLOSE,               /* رPCMͨ· */
    SLIC_PCM_SET_NB,                 /* խƵ */
    SLIC_PCM_SET_WB,                 /* ÿƵ */

	/* original cmd*/
    /* below cmd is used for ulc or slctool */
    SLIC_INF_PRECFG = 9,                 /*  */
    SLIC_NOTUSED,                    /* for ioctl #define FIGETBSZ   _IO(0x00,2) */
    SLIC_PORT_RESET,                 /*  */
    SLIC_MSG_CLR,                    /*  */
    SLIC_DIAL_START,                 /*  */
    SLIC_DIAL_STOP,                  /*  */
    SLIC_TIMESLOT_SET,               /*  */
    SLIC_TIMESLOT_RELEASE,           /*  */
    SLIC_PORT_LOCK,                  /*  */
    SLIC_PORT_UNLOCK,                /*  */
    SLIC_FSK_START,                  /*  */
    SLIC_FSK_STO,                    /*  */
    SLIC_POLARITY_REVERSE,           /*  */
    SLIC_DTMFCID_START,              /*  */
    SLIC_LINE_TEST_START,            /* start line test */
    SLIC_LINE_TEST_ABORT,            /* stop line test */
    SLIC_LINE_TEST_READ,             /* read line test result */
    SLIC_TIMEPARA_CFG,               /* config the time para used for hookonhookoffpulse dial and flash */
    SLIC_ELECTRIC_CFG,               /*  */
    
    /* below cmd is only used for slctool for debug */
    SLIC_DEBUG_LEVEL = 28,                 /* set the message print level */
    SLIC_CFG_HOOK_LOWLEN,             /* config the hookon time */
    SLIC_CFG_HOOK_HIGLEN,             /*  */   
    SLIC_CFG_FLASH_LMIN,              /*  */    
    SLIC_CFG_FLASH_LMAX,              /*  */    
    SLIC_CFG_FLASH_HFIX,              /*  */    
    SLIC_CFG_DIAL_HMIN,               /*  */     
    SLIC_CFG_DIAL_HMAX,               /*  */     
    SLIC_CFG_DIAL_LMIN,               /*  */     
    SLIC_CFG_DIAL_LMAX,               /*  */     
    SLIC_CFG_RINGCEASE,               /*  */      
    SLIC_CFG_PREHOOK_HIGLEN,          /*  */
    SLIC_CFG_QUEUE_DELAY,             /*  */
    SLIC_CODEC_GET,                   /* read the content of reg xxx */
    SLIC_CODEC_SET,                   /* wrtie value X to reg xxx */
    SLIC_RAM_GET = 43,                     /* read the content of ram xxx */
    SLIC_RAM_SET,                     /* wrtie value X to ram xxx */ 
    SLIC_MUTE,
    SLIC_CODEC_GETALL,                /* read all the reg */
    SLIC_RAM_GETALL,                  /* read all the ram */      
    SLIC_GET_CHIP_NAME,               /*  */
    
    SLIC_IOCTL_CMD_MAX,     
} SLIC_IOCTL_CMD;

/* scan report event */  
typedef enum {
    EV_UNKONWN            = -1,
	EV_FXS_HOOKON,			  /*һ¼*/
	EV_FXS_HOOKOFF,			  /*ժ¼*/
	EV_FXS_COLLECT_DIG, 	  /*⵽ڲɼ*/
	EV_FXS_FLASH,			  /*Ĳ¼*/

    EV_FXS_FIRST_RING,
    EV_FXS_SIGNAL_CEASE,
    EV_FXO_RING_START,
    EV_FXO_RING_STOP,
    EV_FXS_PRE_HOOKOFF,
    EV_FXS_FIRST_TONE,
    EV_FXS_TEST_DONE,
    EV_FXS_TEST_ERROR
} SLIC_EVENT;

/* daa line status */                       
#define DAA_STATES                          3 /* all daa phone state */ 
#define DAA_RING_ON                         0 /* ring */ 
#define DAA_RING_OFF                        1 /* no ring */
#define DAA_REPORT                          2 /* report ring */


/* errno define */
#define MALLOC_ERR                          0x60
#define PORT_NOFOUND                        0x61
#define CODEC_HARDWARE_ERR                  0x63
#define MESSAGE_FULL                        0x64
#define NOT_SUPPORT                         0x65
#define PULSE_ERROR                         0x66


#define SIGNAL_PLAY_START                   1
#define SIGNAL_PLAY_STOP                    0

                                            
#define USL_RING_SIGNAL                     RING_SIGNAL
#define USL_TONE_SIGNAL                     TONE_SIGNAL

                                           
#define RING_SIGNAL_INIT                    49
#define RING_SIGNAL_ON                      50
#define RING_SIGNAL_OFF                     51
#define RING_SIGNAL_CLEAN_OFF               52
#define RING_SIGNAL_CLEAN_ON                53
#define RING_SIGNAL_OFF_REVERSED            54
#define TONE_SIGNAL_INIT                    60
#define TONE_SIGNAL_ON                      61
#define TONE_SIGNAL_OFF                     62
#define TONE_SIGNAL_CLEAN                   63

#define GET_EV_MASK(x)  (1<<x)
/* conver time format millisecond to system jiffies */
#define MS2JIFF(num, ms) ((num) * (ms) * HZ / 1000)

#if 0
#define DIAL_LOW_MAX_NORMAL     0
#define DIAL_LOW_MAX_BIGGER     1
#endif

#define EV_DIAL_STOP            0
#define EV_DIAL_START           1

extern u8 si_usl_debuglvl;


#define USLPUT0 printk
#define USLPUT1 printk
#define USLPUT2 printk
#define USLPUT3 printk


typedef struct
{
    u8 bTx;
    u8 bRx;
} TIME_SLOT;

typedef union
{
    u16         wTime;
    u16         wLevel;
    u16         wImpe;
    u16         wHighWay;
    TIME_SLOT   stTimeSlot;
} SLIC_PARA_UNION;

typedef struct
{   
#if 0
    u16             port; 
    u8              port_type;
    SLIC_PARA_UNION unPara;
#endif
    void            *data;
    u32             data_size;
} SLIC_IOCTL_DATA;

typedef struct
{
    //u16 port;    /* del by zhanghuan */
    u8  msgid;
    u32 payload; /* payload only 4 byte */
} MSG_DATA;

typedef struct
{
    MSG_DATA data[MSGMAX];
    u32 head;
    u32 tail;
} USL_MSG;

typedef struct
{
    u16     wCadence_rptcnt;
    u16     cadence_on;
    u16     cadence_off;
    u16     freq1;
    u16     freq2;
    u16     amp;
} CANDENCE_ATTR;

#if 0
typedef struct
{
    u16 dura;                   /* dura time */
    u16 signal_type;            /* tone type */
    u16 signal_id;              /* signal id */
    u16 tone_num;               /* Ring Tone counter */
    u32 tick_count;             /* passed tick */
    u32 next_time;              /* next time of ring tone toggle */

    /* Tone attrible struct */
    u32 cease_time;
    u8 cadence_num;
    u16 cadence_index;
    u16 wCurrentrptcnt;         /* repeat count on current cadence_index */
    CANDENCE_ATTR cadence[4];

} SIGNAL_DATA;
#endif

/* add by zhanghuan for new signal struct */
typedef enum {
    RING_SIGNAL = 0,
    TONE_SIGNAL = 1    
} SLIC_SIGNAL_TYPE;

typedef  enum
{
	TONE_DIAL,                /*  */
	TONE_BUSY,                /* æ */
	TONE_RINGBACK,            /*  */
	TONE_CONGESTION,          /* */
	TONE_CW,                  /* еȴ*/
	TONE_TKY,                 /* Х*/
	TONE_SERVICE_SUCCESS,     /* óɹ */
	TONE_SERVICE_FAIL,        /* ʧ */
	/* չ */
	TONE_MAX,

} TONE_TYPE; 

typedef struct
{
	SLIC_SIGNAL_TYPE	signal_type; 
	/* TONE_SIGNAL ʾTONE */
	/* RING_SIGNAL ʾ */
	char	   cid[32]; 			 /* ʾ */
	TONE_TYPE  tone_type;		  /* tone*/

} SIGNAL_DATA;
/* add by zhanghuan for new signal struct end*/


/* used for quene ring */
typedef struct
{
    u32 dwRingStop;        /*flag: add for dealingl the stop ringing conflit 0:noaction  1:stop ringing*/
    u32 dwNeedSort;	       /*flag: need the sort algorithm 0:no  1:need*/
    u32 dwOffCountStart;   /*during the ringing off time, we will start statistics*/
    u32 dwOffCount;        /*statistics time: ringing off time*/
    u32 dwOffMaxCount;     /*time: cadence_off - cadence_on - data->delay*2 */
    
    u32 RingQueneDelay;
} RING_QUENE_PARA;

struct codec_ops;

typedef struct
{
    struct codec_ops    *codec_ops;            /* chip adpter interface func struct pointer */
    
    u16                 port;
    u8                  port_type;
    u8                  flag;                  /* 0:disable 1:enable */
    u32                 dwInitOK;               /* 0:not init 1:init ok*/
    
    /* daa internal data */  
    u32                 ring_on_len;
    u32                 ring_off_len;
    
    /* used for setting fsk&dtmf transmit mode */
    u32                 dwIsRevPol;
    
    u16                 event_mask;            /* event mask flag */
    
    /* play signal data */
    u8                  signal_flag;           /* play signal start or stop */
    u8                  signal_on;             /* signal is on or off */
    SIGNAL_DATA         sig_data; 
    RING_QUENE_PARA     stRingQuenePara;
    
    Port_t              *pLine;                /*ָоƬָ*/

} USL_PORT;

typedef struct
{
    s8 (*pIoctlFunc) (USL_PORT *data, SLIC_IOCTL_DATA *pstCmd);
} USRLINE_IOCTL_FUNC_MAP;

typedef struct codec_ops
{
    s8 (*codec_signal_ctrl)       (Port_t *pPort, const void *signal_attr, const u8 flag);      
    s8 (*codec_timeslot_set)      (Port_t *pPort, const u8 tx, const u8 rx);
    s8 (*codec_timeslot_release)  (Port_t *pPort);    
    s8 (*codec_polarity_reverse)  (Port_t *pPort, const u16 port);
    s8 (*codec_reset)             (Port_t *pPort, const u16 port);
    s8 (*codec_parm_cfg)          (Port_t *pPort, u8 *parm, const u8 size);
    s8 (*codec_parm_get)          (Port_t *pPort, u8 *parm, const u8 size);
    s8 (*codec_ram_cfg)           (Port_t *pPort, u8 *parm, const u8 size);
    s8 (*codec_ram_get)           (Port_t *pPort, u8 *parm, const u8 size);
    s8 (*codec_time_cfg)          (Port_t *pPort, const USL_CONFIG *buf);
    s8 (*codec_slctool_time_cfg) (Port_t *pPort, SLIC_IOCTL_CMD cmd, u16 wTime);
    s8 (*codec_time_print)        (Port_t *pPort);
    s8 (*codec_dial_set)          (Port_t *pPort, u8 bDialEn);
    s8 (*codec_electric_cfg)      (Port_t *pPort, const u16 port, const ELECTRIC_CFG_CUSTOMIZED *buf);
    s8 (*codec_start_test)        (Port_t *pPort, const WriteCmd_t *Cmd);
    s8 (*codec_stop_test)         (Port_t *pPort);
    s8 (*codec_read_reslult)      (Port_t *pPort, TestResult_t *pstResult);
    s8 (*codec_power_ctrl)        (Port_t *pPort, u8 level);
    
    void (*codec_scan)            (USL_PORT *pUslPort);
} CODEC_OPS;

s8 usrline_report(const u16 port, const u8 event, const u32 payload, u16 mask);
s8 usrline_port_register( const u16 port, const u8 type, CODEC_OPS *ops, Port_t *pchip);
#endif /* _USR_LINE_H */
