#include <linux/slab.h>
#include <linux/kernel.h>
#include <linux/device.h>
#include <linux/etherdevice.h>
#include <linux/list.h>
#include <linux/atomic.h>
#include <linux/miscdevice.h>
#include <linux/vmalloc.h>
#include <linux/crc32.h>
#include <linux/if_vlan.h>
#include <linux/usb/gadget.h>
//#include <uapi/linux/sched.h>

#include <linux/android_notify.h>

#include <asm-generic/ioctl.h>

#include "u_ether.h"
#include "mbim.h"

//#include "multi_packet.h"
//#include "Sys-linux.c"
#include <mach/highspeed_debug.h>


#define  MBIM_CTRL_NAME  "android_mbim_ctrl"
#define  MBIM_DATA_NAME  "android_mbim_data"

#define MBIM_MAGIC  'M'
//ioctl
#define IOCTL_VNIC_SET_BLOCKTIME    _IOW(MBIM_MAGIC,0,unsigned int)
#define IOCTL_VNIC_FREE_READ_BUF    _IOW(MBIM_MAGIC,1,unsigned int)
#define IOCTL_VNIC_GET_WRITE_BUF    _IOR(MBIM_MAGIC,2,unsigned int)
#define IOCTL_VNIC_CONNECT          _IOW(MBIM_MAGIC,3,unsigned int)
#define IOCTL_VNIC_DISCONNECT       _IOW(MBIM_MAGIC,4,unsigned int)
#define IOCTL_VNIC_REG_CBK_XFER_STATISTICS      _IOR(MBIM_MAGIC,5,unsigned int)
#define IOCTL_VNIC_REG_CBK_NIC_DISABLE          _IOW(MBIM_MAGIC,6,unsigned int)
#define IOCTL_VNIC_FREE_UNREAD_BUF              _IOW(MBIM_MAGIC,7,unsigned int)
#define IOCTL_VNIC_GET_USB_STATUS               _IOR(MBIM_MAGIC,8,unsigned int)
#define IOCTL_VNIC_GET_CID_MAXTRANSFER_SIZE     _IOR(MBIM_MAGIC,9,unsigned int)

#define IOCTL_VNIC_SET_CID_SESSIONID            _IOW(MBIM_MAGIC,10,unsigned int)
#define IOCTL_VNIC_SET_CID_DSSSESSIONID         _IOW(MBIM_MAGIC,11,unsigned int)
#define IOCTL_VNIC_SET_NET_LOOP_TEST            _IOW(MBIM_MAGIC,12,unsigned int)
#define IOCTL_VNIC_GET_NET_STATUS               _IOR(MBIM_MAGIC,13,unsigned int)




#define MBIM_STATUS_BYTECOUNT		64    //16
#define LOG2_STATUS_INTERVAL_MSEC	5	/* 1 << 5 == 32 msec */
#define FORMATS_SUPPORTED_MBIM  	0x0001
#define NCM_NDP_HDR_CRC		0x01000000
#define NCM_NDP_HDR_NOCRC	0x00000000

#define MBIM_NTB_DEFAULT_IN_SIZE	   16384
#define MBIM_NTB_DEFAULT_OUT_SIZE		16384


#define MBIM_CTRL_NOCOPY
#define USB_MBIM_CTRL_MSG_NODE_CNT 32
#define MBIM_MAX_CONFIGS	1
#define MBIM_MAX_CTRL_MSG      0x200 //512 ,˴ʱҪ1024(compositereqСΪ1024)
#define MBIM_MAX_POOL_NUM    32
#define	MAX_TX_NONFIXED		(512 * 3)
#define MBIM_INPUT_DATAGRAM_MAX_COUNT  10 

//struct f_mbim	* g_mbim = NULL;

#define basic_connect_command 0
#define sms_command 1
//char *g_sent_buf = NULL;

#define USB_CDC_NCM_NDP16_LENGTH_MIN		0x10

#define MBIM_IP_MTU_EXTRA      20
#define MBIM_SMS_FALG  0x3F6CE523

struct mbim_pool_ctrl_s{
    struct list_head list;
    u16 max_size ;
    u16 real_size ;
    u8  buf[0] ;
};

struct mbim_pool_data_s{
    struct list_head list;
    void*  pdata ;
};

struct ndp_parser_opts {
	u32		nth_sign;
	u32		ndp_sign;
	u16	    nth_size;
	u16   	ndp_size;
	unsigned	ndplen_align;
	/* sizes in u16 units */
	u16 	dgram_item_len; /* index or length */
	u16 	block_length;
	u16  	fp_index;
	u16     	reserved1;
	u16     	reserved2;
	u16     	next_fp_index;
};


__packed typedef struct{
	u32	ntb_input_size;
	u16	ntb_max_datagrams;
	u16	reserved;
}T_MBIM_NTB_INPUT_SIZE;

typedef struct{
	struct usb_cdc_mbim_ntb_parameters ntbParam;
	T_MBIM_NTB_INPUT_SIZE ntbSetInputSize;
	T_MBIM_NTB_INPUT_SIZE ntbGetInputSize;
	u16			 	  ntbSetFormat;
	u16			 	  ntbGetFormat;
	u16				  ntbSetDataGramSize;
	u16				  ntbGetDataGramSize;
	bool				  ntbPortStatus;
}T_MBIM_STATUS_PARRAM;

typedef struct mbim_params {
	u8			confignr;
	u8			used;
	u16			saved_filter;
	enum rndis_state	state;
	u32			medium;
	u32			speed;
	u32			media_state;

	const u8		*host_mac;
	u16			*filter;
	struct net_device	*dev;

	u32			vendorID;
	const char		*vendorDescr;
	void			(*resp_avail)(void *v);
	void			*v;
	struct list_head		resp_queue;
}mbim_params;
static mbim_params mbim_per_dev_params[MBIM_MAX_CONFIGS];
static T_MBIM_STATUS_PARRAM s_mbimStatusParam;

enum mbim_notify_state {
	MBIM_NOTIFY_NONE,		/* don't notify */
	MBIM_NOTIFY_CONNECT,		/* issue CONNECT next */
	MBIM_NOTIFY_SPEED,		/* issue SPEED_CHANGE next */
};


struct f_mbim {
	struct gether			port;

	u8				ctrl_id, data_id;

	char				ethaddr[14];
	int				    config;
	struct usb_ep		*notify;
	struct usb_request	*notify_req;
	atomic_t			notify_count;
	u8				notify_state;
	bool				is_open;
	bool 				portOpenState;
	bool 				devResetState;
	struct ndp_parser_opts		*parser_opts;

    struct usb_cdc_mbim_ntb_parameters  ntb_params ;
    int             state;/*0 unbind;1 bind;2 open;3 close*/
	int 			trans_flag;		/*0 can not rea/write;1  read/write ok*/			
	/*
	 * for notification, it is accessed from both
	 * callback and ethernet open/close
	 */
	 
	spinlock_t			lock;

     //Ӧò㽻ͨ
    atomic_t ctrl_rx_cnt ;
    atomic_t ctrl_tx_cnt ;
    struct spinlock  ctrl_lock ;

    struct list_head ctrl_rx_list ;
    struct list_head ctrl_tx_list ;
    //struct list_head  ctrl_idle_list ;
    atomic_t idle_cnt ;
    struct list_head  idle_list ;

    wait_queue_head_t ctrl_read_wq ;
    wait_queue_head_t ctrl_write_wq ;
    bool ctrl_open_flag ;
    
    //Ӧòͨ
    atomic_t data_rx_cnt ;
    atomic_t data_tx_cnt ;
    spinlock_t   data_lock ;
    struct list_head  data_rx_list ;
    struct list_head  data_ilde_list ;
    atomic_t data_idle_cnt ;


    void * pool_mem ;  //CIDڴ׵ַ

    void * data_pool_mem ;

    wait_queue_head_t data_read_wq ;
    wait_queue_head_t data_write_wq ;
    struct spinlock   conn_lock ;
    bool data_open_flag ;
    atomic_t  netlink_path_status ;
    atomic_t  dss_session_id ;
    atomic_t  session_id ;
    uint32_t rx_max ;   //mbim յntb
    uint32_t tx_max ;   //mbim ܷ͵ntb
    uint16_t  rx_seq  ; //ntb rxк
    uint16_t  tx_seq  ; //ntb rxк
    uint8_t   loop_test_status ;

	wait_queue_head_t lp_wait;
	struct task_struct	*lp_thread;    
    atomic_t lb_flag ;

    
};



#define INIT_NDP16_OPTS {					\
		.nth_sign = USB_CDC_NCM_NTH16_SIGN,		\
		.ndp_sign = USB_CDC_MBIM_NDP16_IPS_SIGN,	\
		.nth_size = sizeof(struct usb_cdc_ncm_nth16),	\
		.ndp_size = sizeof(struct usb_cdc_ncm_ndp16),	\
		.ndplen_align = 4,				\
		.dgram_item_len = 1,				\
		.block_length = 1,				\
		.fp_index = 1,					\
		.reserved1 = 0,					\
		.reserved2 = 0,					\
		.next_fp_index = 1,				\
	}


#define INIT_NDP32_OPTS {					\
		.nth_sign = USB_CDC_NCM_NTH32_SIGN,		\
		.ndp_sign = USB_CDC_MBIM_NDP32_IPS_SIGN,	\
		.nth_size = sizeof(struct usb_cdc_ncm_nth32),	\
		.ndp_size = sizeof(struct usb_cdc_ncm_ndp32),	\
		.ndplen_align = 8,				\
		.dgram_item_len = 2,				\
		.block_length = 2,				\
		.fp_index = 2,					\
		.reserved1 = 1,					\
		.reserved2 = 2,					\
		.next_fp_index = 2,				\
	}

static struct ndp_parser_opts ndp16_opts = INIT_NDP16_OPTS;
static struct ndp_parser_opts ndp32_opts = INIT_NDP32_OPTS;
static u8 mbim_mac[6]= {0x84,0x8F,0xBD,0x5C,0x5B,0x5B};
static int mbim_conn_pool_init(struct f_mbim * dev);
void mbim_conn_pool_deinit(struct f_mbim * dev);

static inline void put_ncm(__le16 **p, unsigned size, unsigned val)
{
	switch (size) {
	case 1:
		put_unaligned_le16((u16)val, *p);
		break;
	case 2:
		put_unaligned_le32((u32)val, *p);

		break;
	default:
		BUG();
	}

	*p += size;
}

static inline unsigned get_ncm(__le16 **p, unsigned size)
{
	unsigned tmp;

	switch (size) {
	case 1:
		tmp = get_unaligned_le16(*p);
		break;
	case 2:
		tmp = get_unaligned_le32(*p);
		break;
	default:
		BUG();
	}

	*p += size;
	return tmp;
}

static inline struct f_mbim *func_to_mbim(struct usb_function *f)
{
	return container_of(f, struct f_mbim, port.func);
}

/* peak (theoretical) bulk transfer rate in bits-per-second */
static inline unsigned mbim_bitrate(struct usb_gadget *g)
{
	if (gadget_is_dualspeed(g) && g->speed == USB_SPEED_HIGH)
		return 13 * 512 * 8 * 1000 * 8;
	else
		return 19 *  64 * 1 * 1000 * 8;
}

static struct usb_cdc_mbim_ntb_parameters mbim_ntb_parameters = {
	.wLength = sizeof mbim_ntb_parameters,
	.bmNtbFormatsSupported = cpu_to_le16(FORMATS_SUPPORTED_MBIM),
	.dwNtbInMaxSize = cpu_to_le32(USB_CDC_MBIM_NTB_MIN_IN_SIZE),
	.wNdpInDivisor = cpu_to_le16(4),
	.wNdpInPayloadRemainder = cpu_to_le16(0),
	.wNdpInAlignment = cpu_to_le16(4),
	.wPadding1 = 0,
	.dwNtbOutMaxSize = cpu_to_le32(USB_CDC_MBIM_NTB_MIN_OUT_SIZE),
	.wNdpOutDivisor = cpu_to_le16(4),
	.wNdpOutPayloadRemainder = cpu_to_le16(0),
	.wNdpOutAlignment = cpu_to_le16(4),
	//.wNtbOutMaxDatagrams = 0,
	.wNtbOutMaxDatagrams = 10,
};

static struct usb_interface_assoc_descriptor mbim_iad_descriptor = {
	.bLength =		sizeof mbim_iad_descriptor,
	.bDescriptorType =	USB_DT_INTERFACE_ASSOCIATION,

	.bFirstInterface =		0, 
	.bInterfaceCount = 		2,	// control + data
	.bFunctionClass =		USB_CLASS_COMM,
	.bFunctionSubClass =	USB_CDC_SUBCLASS_MBIM,
	.bFunctionProtocol =		USB_CDC_PROTO_NONE,
	/* .iFunction = DYNAMIC */
};


/* interface descriptor: */
 /*MBIM communication class interface*/
static struct usb_interface_descriptor mbim_comm_intf = {
	.bLength =		sizeof mbim_comm_intf,
	.bDescriptorType =	USB_DT_INTERFACE,
	.bAlternateSetting =  0x00, //ЭΪ1testΪ0
	/* .bInterfaceNumber = DYNAMIC */
	/* status endpoint is optional; this could be patched later */
	.bNumEndpoints =	1,
	.bInterfaceClass =	USB_CLASS_COMM,
	.bInterfaceSubClass =  USB_CDC_SUBCLASS_MBIM,
	.bInterfaceProtocol =    USB_CDC_PROTO_NONE,
	/*.iInterface = DYNAMIC */
};

/* MBIM communication header descriptor */
static struct usb_cdc_header_desc mbim_header_desc = {
	.bLength =		sizeof mbim_header_desc,
	.bDescriptorType =	USB_DT_CS_INTERFACE,
	.bDescriptorSubType =	USB_CDC_HEADER_TYPE,
	.bcdCDC =	BCD_CDC,
};

static struct usb_cdc_union_desc mbim_union_desc = {
	.bLength =		sizeof(mbim_union_desc),
	.bDescriptorType =	USB_DT_CS_INTERFACE,
	.bDescriptorSubType =	USB_CDC_UNION_TYPE,
};


static struct usb_mbim_func_desc mbim_desc = {
	.bLength =		sizeof mbim_desc,
	.bDescriptorType =	USB_DT_CS_INTERFACE,
	.bDescriptorSubType =	 DSC_SUBTYPE_CS_MBIM,
	.bcdMBIMVersion=	0x0100,
	.wMaxControlMessage=MBIM_MAX_CTRL_MSG , //0x1000, //no smaller than 512
	.bNumberFilters=0x10, //no smaller than 16
	.bMaxFilterSize=0x80, //not exceed 192
	.wMaxSegmentSize= 0x0FE0, //no smaller than 2048
	.bmNetworkCapabilities= 0x20,
};

static struct usb_cdc_mbim_extended_desc mbim_extended_desc = {
	.bLength = 		sizeof(mbim_extended_desc),
	.bDescriptorType =	USB_DT_CS_INTERFACE,
	.bDescriptorSubType = DSC_SUBTYPE_CS_EXTENDED_MBIM, 
	.bcdMBIMExtendedVersion = 	0x0100,
	.bMaxOutstandingCommandMessages =	0x01,
	.wMTU =	0x05DC,
 };


 /*MBIM data class interface*/
static struct usb_interface_descriptor mbim_data_intf = {
	.bLength =		sizeof mbim_data_intf,
	.bDescriptorType =	USB_DT_INTERFACE,
	//.bInterfaceNumber =	1,
	.bAlternateSetting =  0,
	/* .bInterfaceNumber = DYNAMIC */
	/* status endpoint is optional; this could be patched later */
	.bNumEndpoints =	0,
	.bInterfaceClass =	USB_CLASS_CDC_DATA,
	.bInterfaceSubClass =  0,
	.bInterfaceProtocol =  USB_CDC_MBIM_PROTO_NTB,
	/* .iInterface = DYNAMIC */
};
static struct usb_interface_descriptor mbim_data_intf1= {
	.bLength =		sizeof mbim_data_intf1,
	.bDescriptorType =	USB_DT_INTERFACE,
	//.bInterfaceNumber =	1,
	.bAlternateSetting =  0x01,
	/* .bInterfaceNumber = DYNAMIC */
	/* status endpoint is optional; this could be patched later */
	.bNumEndpoints =	2,
	.bInterfaceClass =	USB_CLASS_CDC_DATA,
	.bInterfaceSubClass =   0,
	.bInterfaceProtocol =  USB_CDC_MBIM_PROTO_NTB,
	/* .iInterface = DYNAMIC */
};
static struct usb_interface_descriptor mbim_data_intf2= {
	.bLength =		sizeof mbim_data_intf2,
	.bDescriptorType =	USB_DT_INTERFACE,
	//.bInterfaceNumber =	1,
	.bAlternateSetting =  0x02,
	/* .bInterfaceNumber = DYNAMIC */
	/* status endpoint is optional; this could be patched later */
	.bNumEndpoints =	2,
	.bInterfaceClass =	USB_CLASS_CDC_DATA,
	.bInterfaceSubClass =  0,
	.bInterfaceProtocol =   USB_CDC_MBIM_PROTO_NTB,
	/* .iInterface = DYNAMIC */
};


static struct usb_endpoint_descriptor mbim_notify_desc = {
	.bLength =		USB_DT_ENDPOINT_SIZE,
	.bDescriptorType =	USB_DT_ENDPOINT,

	.bEndpointAddress =	USB_DIR_IN,
	.bmAttributes =		USB_ENDPOINT_XFER_INT,
	.wMaxPacketSize =	cpu_to_le16(MBIM_STATUS_BYTECOUNT),
	.bInterval =		1 << LOG2_STATUS_INTERVAL_MSEC,
};

static struct usb_endpoint_descriptor mbim_in_desc = {
	.bLength =		USB_DT_ENDPOINT_SIZE,
	.bDescriptorType =	USB_DT_ENDPOINT,

	.bEndpointAddress =	USB_DIR_IN,
	.bmAttributes =		USB_ENDPOINT_XFER_BULK,
	//.wMaxPacketSize =	64,
};

static struct usb_endpoint_descriptor mbim_out_desc = {
	.bLength =		USB_DT_ENDPOINT_SIZE,
	.bDescriptorType =	USB_DT_ENDPOINT,
	.bEndpointAddress =	USB_DIR_OUT,
	.bmAttributes =		USB_ENDPOINT_XFER_BULK,
	//.wMaxPacketSize =	64,
};

static struct usb_descriptor_header *mbim_descriptor_function[]  = {
	(struct usb_descriptor_header *) &mbim_iad_descriptor,
	/* CDC MBIM control descriptors */
	(struct usb_descriptor_header *) &mbim_comm_intf,
	(struct usb_descriptor_header *) &mbim_header_desc,
	(struct usb_descriptor_header *) &mbim_union_desc,
	(struct usb_descriptor_header *) &mbim_desc,
	(struct usb_descriptor_header *) &mbim_extended_desc,
	(struct usb_descriptor_header *) &mbim_notify_desc,
	/* data interface, altsettings 0 and 2 */
	(struct usb_descriptor_header *) &mbim_data_intf,
	(struct usb_descriptor_header *) &mbim_data_intf1,
	(struct usb_descriptor_header *) &mbim_in_desc,
	(struct usb_descriptor_header *) &mbim_out_desc,
	NULL,
};


static struct usb_endpoint_descriptor mbim_data_notify = {
	.bLength =		USB_DT_ENDPOINT_SIZE,
	.bDescriptorType =	USB_DT_ENDPOINT,

	.bEndpointAddress =	USB_DIR_IN,
	.bmAttributes =		USB_ENDPOINT_XFER_INT,
	.wMaxPacketSize =	cpu_to_le16(MBIM_STATUS_BYTECOUNT),
	.bInterval =		LOG2_STATUS_INTERVAL_MSEC + 4,
};
static struct usb_endpoint_descriptor mbim_data_in = {
	.bLength =		USB_DT_ENDPOINT_SIZE,
	.bDescriptorType =	USB_DT_ENDPOINT,

	.bEndpointAddress =	USB_DIR_IN,
	.bmAttributes =		USB_ENDPOINT_XFER_BULK,
	.wMaxPacketSize =	 cpu_to_le16(512),
};

static struct usb_endpoint_descriptor mbim_data_out = {
	.bLength =		USB_DT_ENDPOINT_SIZE,
	.bDescriptorType =	USB_DT_ENDPOINT,

	.bEndpointAddress =	USB_DIR_OUT,
	.bmAttributes =		USB_ENDPOINT_XFER_BULK,
	.wMaxPacketSize =	cpu_to_le16(512),
};



static struct usb_descriptor_header *mbim_data_descriptor_function[]  = {
	(struct usb_descriptor_header *) &mbim_iad_descriptor,
	/* CDC MBIM control descriptors */
	(struct usb_descriptor_header *) &mbim_comm_intf,
	(struct usb_descriptor_header *) &mbim_header_desc,
	(struct usb_descriptor_header *) &mbim_union_desc,
	(struct usb_descriptor_header *) &mbim_desc,
	(struct usb_descriptor_header *) &mbim_extended_desc,
	(struct usb_descriptor_header *) &mbim_data_notify,
	/* data interface, altsettings 0 and 2 */
	(struct usb_descriptor_header *) &mbim_data_intf,
	(struct usb_descriptor_header *) &mbim_data_intf1,
	(struct usb_descriptor_header *) &mbim_data_in,
	(struct usb_descriptor_header *) &mbim_data_out,
	NULL,
};

/* string descriptors: */

#define STRING_CTRL_IDX	0
#define STRING_MAC_IDX	1
#define STRING_DATA_IDX	2
#define STRING_IAD_IDX	3

static struct usb_string mbim_string_defs[] = {
	[STRING_CTRL_IDX].s = "CDC Network Control Model (MBIM)",
	[STRING_MAC_IDX].s = NULL /* DYNAMIC */,
	[STRING_DATA_IDX].s = "CDC Network Data",
	[STRING_IAD_IDX].s = "CDC MBIM",
	{  } /* end of list */
};

static struct usb_gadget_strings mbim_string_table = {
	.language =		0x0409,	/* en-us */
	.strings =		mbim_string_defs,
};

static struct usb_gadget_strings *mbim_strings[] = {
	&mbim_string_table,
	NULL,
};

#if 1
int got_sms_flag = 0;
int mbim_get_sms_flag(void)
{
	return got_sms_flag;
}

typedef struct __RX_DEBUG{
	int cmd;
	int msg_len;
	int txn_id;
	int real_len;
    struct list_head *list;	
}drv_rx_debug_info;
drv_rx_debug_info g_drv_mbim_rx_info[32] ={0};
int g_drv_mbim_rx_cnt = 0;
drv_rx_debug_info g_drv_mbim_tx_info[32] ={0};
int g_drv_mbim_tx_cnt = 0;


drv_rx_debug_info g_drv_mbim_rx_all[64] ={0};
int g_drv_mbim_rx_all_cnt = 0;

void drv_mbim_check_sms(__le32 *data, int rx_tx)
{
	__le32 *check_sms  = data;
	int tmp_flag = get_unaligned_le32(check_sms + 8);
	int tmp_cid = get_unaligned_le32(check_sms + 9);
	
	if(tmp_flag == MBIM_SMS_FALG){
		printk("\ndrv_mbim_check_sms , %s, got sms,tmp_cid:%08x\n", (rx_tx == 0 ? "read" : "write"), tmp_cid);
		got_sms_flag += 1;
	}

}
void drv_mbim_rx_static(struct mbim_pool_ctrl_s *pctrl)
{

	u8* databuf = pctrl->buf;
    __le32 *tmp = (__le32 *)databuf;
	drv_mbim_check_sms(tmp, 0);
	g_drv_mbim_rx_info[g_drv_mbim_rx_cnt].cmd = get_unaligned_le32(tmp++);
	g_drv_mbim_rx_info[g_drv_mbim_rx_cnt].msg_len = get_unaligned_le32(tmp++);
	g_drv_mbim_rx_info[g_drv_mbim_rx_cnt].txn_id = get_unaligned_le32(tmp++);
	g_drv_mbim_rx_info[g_drv_mbim_rx_cnt].real_len = pctrl->real_size;
	g_drv_mbim_rx_info[g_drv_mbim_rx_cnt].list= &pctrl->list;
	if(++g_drv_mbim_rx_cnt >= 32)
		g_drv_mbim_rx_cnt = 0;
	
}

void drv_mbim_tx_static(struct mbim_pool_ctrl_s *pctrl)
{
	u8* databuf = pctrl->buf;
    __le32 *tmp = (__le32 *)databuf;
	drv_mbim_check_sms(tmp, 1);
	g_drv_mbim_tx_info[g_drv_mbim_tx_cnt].cmd = get_unaligned_le32(tmp++);
	g_drv_mbim_tx_info[g_drv_mbim_tx_cnt].msg_len = get_unaligned_le32(tmp++);
	g_drv_mbim_tx_info[g_drv_mbim_tx_cnt].txn_id = get_unaligned_le32(tmp++);
	g_drv_mbim_tx_info[g_drv_mbim_tx_cnt].real_len = pctrl->real_size;
	g_drv_mbim_tx_info[g_drv_mbim_tx_cnt].list= &pctrl->list;
	if(++g_drv_mbim_tx_cnt >= 32)
		g_drv_mbim_tx_cnt = 0;
	
}

void drv_mbim_rx_all(u8 *buff, int len)
{

	//u8* databuf = pctrl->buf;
    __le32 *tmp = (__le32 *)buff;
	g_drv_mbim_rx_all[g_drv_mbim_rx_all_cnt].cmd = get_unaligned_le32(tmp++);
	g_drv_mbim_rx_all[g_drv_mbim_rx_all_cnt].msg_len = get_unaligned_le32(tmp++);
	g_drv_mbim_rx_all[g_drv_mbim_rx_all_cnt].txn_id = get_unaligned_le32(tmp++);
	g_drv_mbim_rx_all[g_drv_mbim_rx_all_cnt].real_len = len;
	if(++g_drv_mbim_rx_all_cnt >= 64)
		g_drv_mbim_rx_all_cnt = 0;
	
}

#endif 

static struct f_mbim* g_mbim = NULL ;
extern int get_vnic_multi_packet_num(void) ;
static inline void mbim_reset_values(struct f_mbim *mbim)
{
	mbim->parser_opts = &ndp16_opts;
	mbim->port.cdc_filter = DEFAULT_FILTER;

	/* doesn't make sense for ncm, fixed size used */
	mbim->port.header_len = 0;
	mbim->port.fixed_out_len = MBIM_NTB_DEFAULT_OUT_SIZE ;//  le32_to_cpu(mbim_ntb_parameters.dwNtbOutMaxSize);
	mbim->port.fixed_in_len = MBIM_NTB_DEFAULT_IN_SIZE ;
    mbim->ntb_params = mbim_ntb_parameters ;
    //out ֧İ
    mbim->ntb_params.dwNtbInMaxSize = cpu_to_le32(MBIM_NTB_DEFAULT_IN_SIZE);
     mbim->ntb_params.dwNtbOutMaxSize =  cpu_to_le32(MBIM_NTB_DEFAULT_OUT_SIZE);
    mbim->ntb_params.wNtbOutMaxDatagrams =  cpu_to_le16(get_vnic_multi_packet_num());
}
void gether_mbim_uevent(int ecm_switch);

#ifdef CONFIG_PM
unsigned int g_mbim_suspend_cnt = 0;
unsigned int g_mbim_resume_cnt = 0;

static void mbim_suspend(struct usb_function *f)
{
	struct f_mbim		*mbim = func_to_mbim(f);
	struct usb_composite_dev *cdev = f->config->cdev;
	
	if (!mbim->notify->driver_data)
		return;
    g_mbim_suspend_cnt++;
#if 0	

	usb_printk("%s, %u, suspendcnt:%d\n", __func__, __LINE__, g_mbim_suspend_cnt);
	USBSTACK_DBG("%s, %u suspendcnt:%d", __func__, __LINE__, g_mbim_suspend_cnt);
//	gether_disconnect(&mbim->port);
    mbim->port.suspend_state = 1;
    multi_packet_deactivate();
    usb_ep_disable((&mbim->port)->in_ep);
//  usb_ep_disable((&mbim->port)->out_ep);
#endif
	mbim->port.suspend_state = 1;
    printk("\n mbim_susp_cnt:%u, notify_cnt:%d, ctrl_txq:%d, \n\n", 
		g_mbim_suspend_cnt,atomic_read(&mbim->notify_count), atomic_read(&mbim->ctrl_tx_cnt));
    USBSTACK_DBG("mbim_susp_cnt:%u, notify_cnt:%d, ctrl_txq:%d\n", 
		g_mbim_suspend_cnt,atomic_read(&mbim->notify_count), atomic_read(&mbim->ctrl_tx_cnt));
    //gether_mbim_uevent(0);
}
static void mbim_resume(struct usb_function *f)
{
	struct f_mbim		*mbim = func_to_mbim(f);
	struct usb_composite_dev *cdev = f->config->cdev;

	if (!mbim->notify->driver_data){
		printk("\n\n#######%s, %u ,notify->driver_data is null\n\n", __func__, __LINE__);
		USBSTACK_DBG("#####%s, %u ,notify->driver_data is null\n", __func__, __LINE__);
		return;
	}	
    g_mbim_resume_cnt++;
#if 0
	usb_printk("%s, %u, resumecnt:%d\n", __func__, __LINE__, g_mbim_resume_cnt);
	USBSTACK_DBG("%s, %u resumecnt:%d", __func__, __LINE__, g_mbim_resume_cnt);
//	gether_connect(&mbim->port);
    usb_ep_resume_enable(mbim->notify);
    usb_ep_resume_enable((&mbim->port)->in_ep);
//  usb_ep_enable((&mbim->port)->out_ep);
#endif
	mbim->port.suspend_state = 0;
    printk("\n mbim_resume_cnt:%u\n\n", g_mbim_resume_cnt);
    USBSTACK_DBG("mbim_resume_cnt:%u\n", g_mbim_resume_cnt);
	//if(atomic_read(&mbim->lb_flag) == 0)
	//    gether_mbim_uevent(1);
    //multi_packet_activate();

}

#endif



static void mbim_do_notify(struct f_mbim *mbim)
{
	printk(" mbim_do_notify\n");
	struct usb_request		*req = mbim->notify_req;
	struct usb_cdc_notification	*event;
	struct usb_composite_dev	*cdev = mbim->port.func.config->cdev;
	__le32				*data;
	int				status;

	/* notification already in flight? */
	if (!req)
		return;

	event = req->buf;
	switch (mbim->notify_state) {
	case MBIM_NOTIFY_NONE:
		return;

	case MBIM_NOTIFY_CONNECT:
		event->bNotificationType = USB_CDC_NOTIFY_NETWORK_CONNECTION;
		if (mbim->is_open)
			event->wValue = cpu_to_le16(1);
		else
			event->wValue = cpu_to_le16(0);
		event->wLength = 0;
		req->length = sizeof *event;

		//USBSTACK_DBG (cdev, "notify connect %s\n",mbim->is_open ? "true" : "false");
		mbim->notify_state = MBIM_NOTIFY_NONE;
		break;

	case MBIM_NOTIFY_SPEED:
		event->bNotificationType = USB_CDC_NOTIFY_SPEED_CHANGE;
		event->wValue = cpu_to_le16(0);
		event->wLength = cpu_to_le16(8);
		req->length = MBIM_STATUS_BYTECOUNT;

		/* SPEED_CHANGE data is up/down speeds in bits/sec */
		data = req->buf + sizeof *event;
		data[0] = cpu_to_le32(mbim_bitrate(cdev->gadget));
		data[1] = data[0];

		//USBSTACK_DBG ( cdev, "notify speed %d\n", mbim_bitrate(cdev->gadget));
		mbim->notify_state = MBIM_NOTIFY_CONNECT;
		break;
	}
	event->bmRequestType = 0xA1;
	event->wIndex = cpu_to_le16(mbim->ctrl_id);
    printk("\n\n[file]: %s ,[][func]: %s ,[line] = %d \n\n",__FILE__,__func__,__LINE__);

	mbim->notify_req = NULL;
	/*
	 * In double buffering if there is a space in FIFO,
	 * completion callback can be called right after the call,
	 * so unlocking
	 */
	spin_unlock(&mbim->lock);
	status = usb_ep_queue(mbim->notify, req, GFP_ATOMIC);
	spin_lock(&mbim->lock);
	if (status < 0) {
		mbim->notify_req = req;
		//USBSTACK_DBG ( cdev, "notify --> %d\n", status);
	}
}

static void mbim_notify(struct f_mbim *mbim)
{
	/*
	 * NOTE on most versions of Linux, host side cdc-ethernet
	 * won't listen for notifications until its netdevice opens.
	 * The first notification then sits in the FIFO for a long
	 * time, and the second one is queued.
	 *
	 * If ncm_notify() is called before the second (CONNECT)
	 * notification is sent, then it will reset to send the SPEED
	 * notificaion again (and again, and again), but it's not a problem
	 */
	mbim->notify_state = MBIM_NOTIFY_SPEED;
	mbim_do_notify(mbim);
}

static void mbim_notify_complete(struct usb_ep *ep, struct usb_request *req)
{
	struct f_mbim			*mbim = req->context;
	struct usb_composite_dev	*cdev = mbim->port.func.config->cdev;
	//struct usb_cdc_notification	*event = req->buf;

	spin_lock(&mbim->lock);
	switch (req->status) {
	case 0:
		//USBSTACK_DBG(cdev, "Notification %02x sent\n",
		 //    event->bNotificationType);
		break;
	case -ECONNRESET:
	case -ESHUTDOWN:
		mbim->notify_state = MBIM_NOTIFY_NONE;
		break;
	default:
		//USBSTACK_DBG ( cdev, "event %02x --> %d\n",
		//	event->bNotificationType, req->status);
		break;
	}
	//mbim->notify_req = req;
	//mbim_do_notify(mbim);
	spin_unlock(&mbim->lock);
}



static void mbim_ep0out_complete(struct usb_ep *ep, struct usb_request *req)
{
	/* now for SET_NTB_INPUT_SIZE only */
	unsigned		in_size;
	struct usb_function	*f = req->context;
	struct f_mbim		*mbim = func_to_mbim(f);
	struct usb_composite_dev *cdev = ep->driver_data;

	req->context = NULL;
	if (req->status || req->actual != req->length) {
		//USBSTACK_DBG(cdev, "Bad control-OUT transfer\n");
		goto invalid;
	}

	in_size = get_unaligned_le32(req->buf);
	if (in_size < USB_CDC_MBIM_NTB_MIN_IN_SIZE ||
	    in_size > le32_to_cpu(mbim_ntb_parameters.dwNtbInMaxSize)) {
		//USBSTACK_DBG(cdev, "Got wrong INPUT SIZE (%d) from host\n", in_size);
		goto invalid;
	}

	mbim->port.fixed_in_len = in_size;
	//USBSTACK_DBG(cdev, "Set NTB INPUT SIZE %d\n", in_size);
	return;

invalid:
	usb_ep_set_halt(ep);
	return;
}


int mbim_set_param_dev(u8 configNr, struct net_device *dev, u16 *cdc_filter)
{	
	printk("mbim_set_param_dev\n");
	if (!dev)
		return -EINVAL;
	//if (configNr >= MBIM_MAX_CONFIGS) return -1;
	mbim_per_dev_params[configNr].dev = dev;
	mbim_per_dev_params[configNr].filter = cdc_filter;

	return 0;
}

int mbim_msg_patch(u8 *buf, int len)
{
	u8* temp_buf = NULL;
	__le32 *temp;
	temp_buf = (u8*)kmalloc(len, GFP_KERNEL);
	if(!temp_buf){
		printk("rndis_msg_patch malloc fail\n");
		return -1;
	}
	memset(temp_buf, 0 , len);
	temp = (__le32 *)temp_buf;
	*temp = cpu_to_le32(MBIM_COMMAND_MSG);
	memcpy(temp_buf+4, buf, len -4);
	memcpy(buf, temp_buf, len);
	kfree(temp_buf);
	temp_buf = NULL;
	return 0;
}


int mbim_cid_msg_filter(u8 *buf ,unsigned int len, int filter_type)
{
    __le32 *tmp;
    u32 MsgType, MsgLength, tx_id ;
    int ret = 0 ;
    if (!buf || len <= 0)
    {
         printk("[func]:%s,[line]:%d , param invalid\n",__func__,__LINE__) ;
         return -EINVAL;
    }
    tmp = (__le32 *)buf;
    MsgType   = get_unaligned_le32(tmp++);
    MsgLength = get_unaligned_le32(tmp++);
	tx_id = get_unaligned_le32(tmp);
	if(filter_type == 1){
		//printk("[func]:%s MsgType:%08x, MsgLength:%d, tx_id:%x, act_len%d\n",__func__, MsgType, MsgLength, tx_id, len) ;
		USBSTACK_DBG("[func]:%s MsgType:%08x, MsgLength:%d, tx_id:%x, act_len%d\n",__func__, MsgType, MsgLength, tx_id, len) ;
	}
	
    switch (MsgType) 
   {
    case MBIM_OPEN_MSG:
    {
         //printk("[func]:%s,[line]:%d , MBIM_OPEN_MSG \n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }
    case MBIM_CLOSE_MSG:
    {
         //printk("[func]:%s,[line]:%d , MBIM_CLOSE_MSG\n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }
    case MBIM_COMMAND_MSG:
    {
         //printk("[func]:%s,[line]:%d , MBIM_COMMAND_MSG ,len = %d \n",__func__,__LINE__,len) ;
         ret = 0 ;
         break;
    }
    case MBIM_OPEN_DONE:
    {
         //printk("[func]:%s,[line]:%d , MBIM_OPEN_DONE\n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }
    case MBIM_CLOSE_DONE:
    {
         //printk("[func]:%s,[line]:%d , MBIM_CLOSE_DONE\n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }
    case MBIM_COMMAND_DONE:
    {
         //printk("[func]:%s,[line]:%d , MBIM_COMMAND_DONE\n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }
    case MBIM_INDICATE_STATUS_MSG:
    {
         //printk("[func]:%s,[line]:%d ,MBIM_INDICATE_STATUS_MSG\n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }

    case MBIM_HOST_ERROR_MSG:
    {
         printk("[func]:%s,[line]:%d , MBIM_HOST_ERROR_MSG\n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }
    case MBIM_FUNCTION_ERROR_MSG:
    {
         printk("[func]:%s,[line]:%d , MBIM_FUNCTION_ERROR_MSG\n",__func__,__LINE__) ;
         ret = 0 ;
         break;
    }
    default:
    {
         printk("[func]:%s,[line]:%d , UNKNOWN CID :%d\n",__func__,__LINE__ ,MsgType) ;
         ret = -1 ;
         break;
    }

    }
    return ret;


}

int mbim_register(void (*resp_avail)(void *v), void *v)
{
	u8 i;

	if (!resp_avail)
		return -EINVAL;

	for (i = 0; i < MBIM_MAX_CONFIGS; i++) {
		if (!mbim_per_dev_params[i].used) {
			mbim_per_dev_params[i].used = 1;
			mbim_per_dev_params[i].resp_avail = resp_avail;
			mbim_per_dev_params[i].v = v;
			printk("-----%s: configNr = %d\n", __func__, i);
			return i;
		}
	}
	pr_debug("failed\n");

	return -ENODEV;
}

void mbim_deregister(int configNr)
{
	pr_debug("%s:\n", __func__);

	if (configNr >= RNDIS_MAX_CONFIGS) return;
	mbim_per_dev_params[configNr].used = 0;
}
int resp_cnt = 0;
int resp_cmplete_cnt = 0;
int mbim_response_available(void *_mbim)
{

	int				status;
	struct f_mbim			*mbim = (struct f_mbim	*)_mbim;
	struct usb_request		*req = mbim->notify_req;
	struct usb_composite_dev	*cdev = mbim->port.func.config->cdev;
    if(req ==NULL)
    {
        printk("\n\nreq is NULL \n\n\n") ;
        return -1;
    }
	if(mbim->trans_flag == 0){        
		printk("\n\n trans_flag is NULL \n\n\n") ;
        return -1;
		
	}
	__le32	*data = req->buf;

	if (atomic_inc_return(&mbim->notify_count) != 1){
		printk("---mbim_response_available,notify_count error, notify_count:%d, excet reset usb\n", atomic_read(&mbim->notify_count)) ;
		USBSTACK_DBG("%s notify_count error, notify_count:%d, excet reset usb",__func__, atomic_read(&mbim->notify_count));
		//usb_notify_up(USB_DEVICE_EXCEPT_RESET, NULL);
		return 0;
	}
	/* Send RNDIS RESPONSE_AVAILABLE notification; a
	 * USB_CDC_NOTIFY_RESPONSE_AVAILABLE "should" work too
	 *
	 * This is the only notification defined by RNDIS.
	 */
	data[0] = cpu_to_le32(0x000001A1);
	data[1] = cpu_to_le32(0);
	//printk("--response_available-ep_queue\n");
	resp_cnt += 1;
	status = usb_ep_queue(mbim->notify, req, GFP_ATOMIC);
	if (status) {
		printk("--response_available-ep queue fail, status:%d\n", status);
		USBSTACK_DBG("--response_available-ep queue fail, status:%d\n", status);
		atomic_dec(&mbim->notify_count);
		//DBG(cdev, "notify/0 --> %d\n", status);
		return -1;
	}

	return 0;
}

static void mbim_response_complete(struct usb_ep *ep, struct usb_request *req)
{
	struct f_mbim			*mbim = req->context;
	struct usb_composite_dev	*cdev = mbim->port.func.config->cdev;
	int				status = req->status;

	/* after TX:
	 *  - USB_CDC_GET_ENCAPSULATED_RESPONSE (ep0/control)
	 *  -MBIM_RESPONSE_AVAILABLE (status/irq)
	 */
	 char * g_sent_buf = (char *)req->buf;
	//printk("-----response_complete, status:%d\n", req->status);
	USBSTACK_DBG("%s ret: %d, req:0x%p, buf:0x%p",__func__, status, req, g_sent_buf);
//    USBSTACK_DBG("%s, %u", __func__, __LINE__);
//    usb_dbg_ep0reg();
	switch (status) {
	case -ECONNRESET:
	case -ESHUTDOWN:
		/* connection gone */
		atomic_set(&mbim->notify_count, 0);
		break;
	default:
		printk( "mbim %s response error %d, %d/%d\n",
			ep->name, status,
			req->actual, req->length);
		/* FALLTHROUGH */
	case 0:
		if (ep != mbim->notify){
			//printk("-----ctrl response_complete\n");
			break;
		}
		resp_cmplete_cnt += 1;
		/* handle multiple pending MBIM_RESPONSE_AVAILABLE
		 * notifications by resending until we're done
		 */
		if(atomic_read(&mbim->notify_count) == 0){
			break;
		}
		if (atomic_dec_and_test(&mbim->notify_count))
			break;
		resp_cnt += 1;
		status = usb_ep_queue(mbim->notify, req, GFP_ATOMIC);
		if (status) {
			//atomic_dec(&mbim->notify_count);
			printk( "notify usb_ep_queue fail --> %d\n", status);
		}
		break;
	}
}

static int mbim_ctrl_send_command_handle(struct f_mbim * mbim_dev ,char *buf,int len)
{
    if(mbim_dev == NULL || buf ==NULL || len <0)
    {
        printk("[func]:%s,[line]:%d ,param is invaild \n",__func__,__LINE__) ;
        return -EINVAL ;

    }
    unsigned long flags;
    //printk("\n\n########[func]:%s,[line]:%d ,start send to app CID msg \n\n\n",__func__,__LINE__) ;
    spin_lock_irqsave(&mbim_dev->ctrl_lock,flags) ;
    if(list_empty(&mbim_dev->idle_list))
    {
        spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags) ;
        printk("\n\n##############[func]:%s,[line]:%d ,idle is empty,idle num =%d,rx num = %d \n\n\n",__func__,__LINE__ ,
            atomic_read(&mbim_dev->idle_cnt), atomic_read(&mbim_dev->ctrl_rx_cnt) ) ;
        return -1 ;
    }
    struct mbim_pool_ctrl_s *ctrp = list_first_entry(&mbim_dev->idle_list,  struct mbim_pool_ctrl_s, list) ;

    list_del_init(&ctrp->list) ;
#if 0
    if(ctrp == NULL)
    {
        spin_unlock(&mbim_dev->ctrl_lock) ;
        printk("[func]:%s,[line]:%d ,pointer ctrp is NULL ,idle num =%d \n",__func__,__LINE__ ,
            atomic_read(&mbim_dev->idle_cnt) );
           printk("[func]:%s,[line]:%d  p = 0x%p ,next = 0x%p\n", 
            container_of(mbim_dev->idle_list.next, struct mbim_pool_ctrl_s, list),
            mbim_dev->idle_list.next) ;
        return -1 ;

    }
#endif
    atomic_dec(&mbim_dev->idle_cnt);
    spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags) ;
    if(len > ctrp->max_size)
    {
        printk("[func]:%s,[line]:%d ,cid payload real num = %d ,buffer max num = %d \n",__func__,__LINE__,len ,ctrp->max_size) ;
    }
    ctrp->real_size = ((len > ctrp->max_size) ? ctrp->max_size: len );
    memcpy(ctrp->buf, buf, ctrp->real_size) ;
    //˵
    spin_lock_irqsave(&mbim_dev->ctrl_lock,flags) ;
    list_add_tail(&ctrp->list, &mbim_dev->ctrl_rx_list) ;
    atomic_inc(&mbim_dev->ctrl_rx_cnt) ;
    spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags) ;
    //
    wake_up(&mbim_dev->ctrl_read_wq);
    return 0 ;

}

static int mbim_ctrl_get_command_handle(struct f_mbim* mbim_dev ,struct usb_request * req )
{
    if(mbim_dev == NULL  || req == NULL)
    {
        printk("[func]:%s,[line]:%d ,param is invaild \n",__func__,__LINE__) ;
        return -EINVAL ;
    }
    unsigned long flags ;
    spin_lock_irqsave(&mbim_dev->ctrl_lock,flags) ;
    if(list_empty(&mbim_dev->ctrl_tx_list))
    {
        spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags) ;
        printk("[func]:%s,[line]:%d ,tx list is empty, resp_cnt:%d, resp_cmplete_cnt:%d\n",__func__,__LINE__, resp_cnt, resp_cmplete_cnt) ;
		//panic("tx list is empty\n");
        return -1 ;
    }
    struct mbim_pool_ctrl_s *ctrp = list_first_entry(&mbim_dev->ctrl_tx_list,  struct mbim_pool_ctrl_s, list) ;
    list_del_init(&ctrp->list) ;
    atomic_dec(&mbim_dev->ctrl_tx_cnt);
    spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags) ;

    memcpy(req->buf, ctrp->buf ,ctrp->real_size) ;
    //˵
    
    spin_lock_irqsave(&mbim_dev->ctrl_lock,flags) ;
    list_add_tail(&ctrp->list, &mbim_dev->idle_list) ;
    atomic_inc(&mbim_dev->idle_cnt) ;
    spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags) ;
    wake_up(&mbim_dev->ctrl_write_wq);
    return  ctrp->real_size ;

}

static void mbim_command_complete(struct usb_ep *ep, struct usb_request *req)
{
	struct f_mbim			*mbim = req->context;
	struct usb_composite_dev	*cdev = mbim->port.func.config->cdev;
	int				status, ret;

	drv_mbim_rx_all(req->buf, req->actual);
	if(req->status == -ECONNRESET){
		USBSTACK_DBG("mbim_command_complete, status error\n");
		return;
	}
	
	//printk("$$$$mbim_command_complete, config:%d\n", mbim->config);
	//status = mbim_msg_parser(mbim->config, (u8 *) req->buf);
	status = mbim_cid_msg_filter(req->buf,req->actual, 1) ;
    if(status)
    {
        printk("[func]:%s,[line]:%d , cid msg is intercepted \n",__func__,__LINE__) ;
		//panic("mbim_command_complete unknown cid\n");
		//here we patch for this cmd
		if(status == -1){			
			ret = mbim_msg_patch(req->buf, req->actual);
			if(ret){
				printk("mbim_command_complete, fail for mbim_msg_patch, replugin\n");
				USBSTACK_DBG("mbim_command_complete, fail for mbim_msg_patch, replugin\n");
				usb_notify_up(USB_DEVICE_EXCEPT_RESET, NULL);
		        return ;
			}
			USBSTACK_DBG("mbim_command_complete, mbim_msg_patch ok continue\n");
	        printk("[func]:%s,[line]:%d , mbim_command_complete, mbim_msg_patch ok continue\n",__func__,__LINE__) ;			
		}
    }
	status  = mbim_ctrl_send_command_handle(mbim, req->buf,req->actual) ;
	USBSTACK_DBG("%s %u, ret: %d, len:%d",__func__, __LINE__, status, req->actual);

	if (status < 0){
		//ERROR(cdev, "mbim command error %d, %d/%d\n",
		//	status, req->actual, req->length);
		USBSTACK_DBG("MBIM command error %d, actual:%d,length:%d\n",status, req->actual, req->length);	
	}
}

int got_ntb_param_flag = 0;

void mbim_clean_ntb_param_flag(void)
{
	got_ntb_param_flag = 0;
}

static int mbim_setup(struct usb_function *f, const struct usb_ctrlrequest *ctrl)
{
	struct f_mbim		*mbim = func_to_mbim(f);
	struct usb_composite_dev *cdev = f->config->cdev;
	struct usb_request	*req = cdev->req;
	int			value = -EOPNOTSUPP;
	u16			w_index = le16_to_cpu(ctrl->wIndex);
	u16			w_value = le16_to_cpu(ctrl->wValue);
	u16			w_length = le16_to_cpu(ctrl->wLength);
	//printk("---mbim_setup, bRequestType:0x%x, bRequest:0x%x, w_index:%02x, w_value:%04x, w_length:%02x\n", 
	//	ctrl->bRequestType,  ctrl->bRequest,w_index,w_value, w_length);

	/*
	 * composite driver infrastructure handles everything except
	 * CDC class messages; interface activation uses set_alt().
	 */	
	switch ((ctrl->bRequestType << 8) | ctrl->bRequest) {
	case ((USB_DIR_OUT | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)
			| USB_CDC_SET_ETHERNET_PACKET_FILTER:
		/*
		 * see 6.2.30: no data, wIndex = interface,
		 * wValue = packet filter bitmap
		 */
		if (w_length != 0 || w_index != mbim->ctrl_id)
			goto invalid;
		//USBSTACK_DBG(cdev, "packet filter %02x\n", w_value);
		/*
		 * REVISIT locking of cdc_filter.  This assumes the UDC
		 * driver won't have a concurrent packet TX irq running on
		 * another CPU; or that if it does, this write is atomic...
		 */
		//printk("\n@@@@@@@@@@@@@@[func]:%s,[line]:%d,w_value = %d@@@@@@@@@@@@@@ \n\n",w_value);
		mbim->port.cdc_filter = w_value;
		value = 0;
		break;
	/*
	 * and optionally:
	 * case USB_CDC_SEND_ENCAPSULATED_COMMAND:
	 * case USB_CDC_GET_ENCAPSULATED_RESPONSE:
	 * case USB_CDC_SET_ETHERNET_MULTICAST_FILTERS:
	 * case USB_CDC_SET_ETHERNET_PM_PATTERN_FILTER:
	 * case USB_CDC_GET_ETHERNET_PM_PATTERN_FILTER:
	 * case USB_CDC_GET_ETHERNET_STATISTIC:
	 */

	case ((USB_DIR_IN | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)
		| USB_CDC_GET_NTB_PARAMETERS:

		if (w_length == 0 || w_value != 0 || w_index != mbim->ctrl_id)
			goto invalid;
		value = w_length > sizeof (g_mbim->ntb_params) ?
			sizeof (g_mbim->ntb_params) : w_length;
		memcpy(req->buf, &(g_mbim->ntb_params), value);
		printk("mbim_setup, GET_NTB_PARAMETERS, mbim_uevent_1\r\n");
        gether_mbim_uevent(1);
		got_ntb_param_flag = 1;
		//USBSTACK_DBG(cdev, "Host asked NTB parameters\n");
		break;
		
	case ((USB_DIR_OUT | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)
			| USB_CDC_RESET_FUNCTION:
#if 1
		mbim->devResetState = 1;
		mbim->portOpenState = 0;
		s_mbimStatusParam.ntbPortStatus = 0;
		value = 0;
		if(got_ntb_param_flag == 0){
			printk("mbim_setup, RESET_FUNCTION, mbim_uevent_1\r\n");			
			gether_mbim_uevent(1);
		}
		printk("mbim_setup, RESET_FUNCTION, mbim_uevent_2\r\n");
        gether_mbim_uevent(2) ;
#endif
		break;

	case ((USB_DIR_OUT | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)
			| USB_CDC_SEND_ENCAPSULATED_COMMAND:
#if 1
		if(w_length > cdev->bufsiz ||w_value || w_index != mbim->ctrl_id)
			goto invalid;		
		/* read the request; process it later */
		value = w_length;
		req->complete = mbim_command_complete;
		req->context = mbim;
#endif		
		break;

	case ((USB_DIR_IN | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)
			| USB_CDC_GET_ENCAPSULATED_RESPONSE:
	//printk("---,mbim_setup, GET_ENCAPSULATED_RESPONSE\n" );
#if 1
		if (w_value || w_index != mbim->ctrl_id)
			goto invalid;
		else {
            
			u8 *buf;
			int n;
			u32 MsgType;
			__le32 *tmp;

			/* return the result */
            n= mbim_ctrl_get_command_handle(mbim,  req) ;
            if(n>=0)
            {
                req->complete = mbim_response_complete;
                req->context = mbim;
                value = n ;
            }
            else
            {
                printk("mbim_setup, resp buf is NULL,error\n");

            }

			/* else stalls ... spec says to avoid that */
		}
#endif
		break;

	case ((USB_DIR_IN | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)
		| USB_CDC_GET_NTB_INPUT_SIZE:

		if (w_length < 4 || w_value != 0 || w_index != mbim->ctrl_id)
			goto invalid;
		put_unaligned_le32(mbim->port.fixed_in_len, req->buf);
		value = 4;
		//USBSTACK_DBG(cdev, "Host asked INPUT SIZE, sending %d\n",
		//     mbim->port.fixed_in_len);
		break;

	case ((USB_DIR_OUT | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)
		| USB_CDC_SET_NTB_INPUT_SIZE:
	{
		if (w_length != 4 || w_value != 0 || w_index != mbim->ctrl_id)
			goto invalid;
		req->complete = mbim_ep0out_complete;
		req->length = w_length;
		req->context = f;

		value = req->length;
		break;
	}

	
	//case ((USB_DIR_IN | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)| USB_CDC_GET_CRC_MODE:
	//case ((USB_DIR_OUT | USB_TYPE_CLASS | USB_RECIP_INTERFACE) << 8)| USB_CDC_SET_CRC_MODE:

	/* and disabled in ncm descriptor: */
	/* case USB_CDC_GET_NET_ADDRESS: */
	/* case USB_CDC_SET_NET_ADDRESS: */
	/* case USB_CDC_GET_MAX_DATAGRAM_SIZE: */
	/* case USB_CDC_SET_MAX_DATAGRAM_SIZE: */

	default:
invalid:
		NULL;
		//USBSTACK_DBG(cdev, "invalid control req%02x.%02x v%04x i%04x l%d\n",
		//	ctrl->bRequestType, ctrl->bRequest,
		//	w_value, w_index, w_length);
	}

	/* respond with data transfer or status phase? */
	if (value >= 0) {
		//USBSTACK_DBG(cdev, "ncm req%02x.%02x v%04x i%04x l%d\n",
		//	ctrl->bRequestType, ctrl->bRequest,
		//	w_value, w_index, w_length);

		req->zero = (value % 64)? 0:1;
		req->length = value;
		value = usb_ep_queue(cdev->gadget->ep0, req, GFP_ATOMIC);
		if (value < 0)
			USB_ASSERT(cdev, "ncm req %02x.%02x response err %d\n",ctrl->bRequestType, ctrl->bRequest,value);
	}

	/* device either stalls (value < 0) or reports success */
	return value;
}

static int mbim_set_alt(struct usb_function *f, unsigned intf, unsigned alt)
{

	struct f_mbim		*mbim = func_to_mbim(f);
	struct usb_composite_dev *cdev = f->config->cdev;
    unsigned long flags = 0 ;
    printk("########%s, %u ,mbim_set_alt ,alt = %d ,intf = %d \n\n",__func__, __LINE__ ,alt,intf );

	/* Control interface has only altsetting 0 */
	if (intf == mbim->ctrl_id ) {

		printk("$$$$ mbim->ctrl_id ==%d,%d\n",mbim->ctrl_id,mbim->ctrl_id);
		if (alt != 0)
		{
            goto fail;
        }
	
        if(mbim->notify->driver_data == NULL)
        {
            if (mbim->notify->driver_data) {
                printk("$$$$mbim->notify->driver_data\n");
                //USBSTACK_DBG(cdev, "reset mbim control %d\n", intf);
                usb_ep_disable(mbim->notify);
            }
            
            if (!(mbim->notify->desc)) {
                printk("$$$$mbim->notify->desc\n");
                //USBSTACK_DBG(cdev, "init mbim ctrl %d\n", intf);
                if (config_ep_by_speed(cdev->gadget, f, mbim->notify))
                    goto fail;
            }
            usb_ep_enable(mbim->notify);
            mbim->notify->driver_data = mbim;
			mbim->trans_flag = 1;
        }



	/* Data interface has two altsettings, 0 and 1 */
	} 
    else if (intf == mbim->data_id) {
        struct net_device	*net;
        if (alt > 1)
        {
			goto fail;
        }

        if(alt == 0)
        {
           
            mbim->tx_seq = 0 ;
            mbim->rx_seq = 0 ;
 #if 0
            struct list_head    *entry, *temp;
            mbim->port.suspend_state = 1;
            atomic_set(&mbim->notify_count, 0) ;
        
            spin_lock_irqsave(&mbim->ctrl_lock,flags);
            list_for_each_safe(entry, temp, &mbim->ctrl_rx_list) 
            {
                struct mbim_pool_ctrl_s *pctrl ;
                pctrl = list_entry (entry, struct mbim_pool_ctrl_s, list);
                list_del_init (&pctrl->list) ;
                pctrl->real_size = 0 ;
                list_add_tail(&pctrl->list,&mbim->idle_list);
                atomic_inc(&mbim->idle_cnt) ;
            }
            atomic_set(&mbim->ctrl_rx_cnt,0) ;
            list_for_each_safe(entry, temp, &mbim->ctrl_tx_list) 
            {
                struct mbim_pool_ctrl_s *pctrl ;
                pctrl = list_entry (entry, struct mbim_pool_ctrl_s, list);
                list_del_init (&pctrl->list) ;
                pctrl->real_size = 0 ;
                list_add_tail(&pctrl->list,&mbim->idle_list);
                atomic_inc(&mbim->idle_cnt) ;
            }
            atomic_set(&mbim->ctrl_tx_cnt,0) ;
            spin_unlock_irqrestore(&mbim->ctrl_lock,flags);

            wake_up(&mbim->ctrl_read_wq) ;
            wake_up(&mbim->ctrl_write_wq) ;
#endif
        }
        if (mbim->port.in_ep->driver_data) 
        {
        	printk("in_ep->driver_data, call gether_disconnect\n");
            gether_disconnect(&mbim->port);
            //mbim_reset_values(mbim);
        }
        if(mbim->port.in_ep->driver_data == NULL || mbim->port.out_ep->driver_data == NULL )
        {
            if (alt == 1)
            {
                if (!mbim->port.in_ep->desc || !mbim->port.out_ep->desc) 
                {   
                    if (config_ep_by_speed(cdev->gadget, f,
                                   mbim->port.in_ep) ||
                        config_ep_by_speed(cdev->gadget, f,
                                   mbim->port.out_ep)) 
                    {
                        printk("\n%s, line:%u ,config error \n\n\n", __func__, __LINE__);
                        mbim->port.in_ep->desc = NULL;
                        mbim->port.out_ep->desc = NULL;
                        goto fail;
                    }
                 }
                //mbim->port.is_zlp_ok = false;
                mbim->port.is_zlp_ok = true;
                mbim->port.cdc_filter = DEFAULT_FILTER;
                net = gether_connect(&mbim->port);
                if (IS_ERR(net))
                {
                    return PTR_ERR(net);
                }
                //gether_mbim_uevent(1);
                mbim_set_param_dev(mbim->config, net,&mbim->port.cdc_filter);
            }
        }

	} else
		goto fail;

	return 0;
fail:
	return -EINVAL;
}


static int mbim_get_alt(struct usb_function *f, unsigned intf)
{
	struct f_mbim		*mbim = func_to_mbim(f);
    printk("\n%s, line:%u  \n\n\n", __func__, __LINE__);
	if (intf == mbim->ctrl_id)
		return 0;
	return mbim->port.in_ep->driver_data ? 1 : 0;
}

/* verify that the ethernet protocol is IPv4 or IPv6 */
static bool is_ip_proto(__be16 proto)
{
	switch (proto) {
	case htons(ETH_P_IP):
	case htons(ETH_P_IPV6):
		return true;
	}
	return false;
}

/* verify NTB header and return offset of first NDP, or negative error */
static int cdc_ncm_rx_verify_nth16(struct usb_request *req)
{
	struct usb_cdc_ncm_nth16 *nth16;
    struct usb_cdc_ncm_nth16 tmp_nth16;
	int len;
	int ret = -EINVAL;
    struct f_mbim *ctx = g_mbim ;
    unsigned long mask = 3;
    bool is_aligned = 0 ;

	if (ctx == NULL)
		goto error;
    
    if(req == NULL || req->buf== NULL || req->actual == 0)
    {
		USBSTACK_DBG( "[%s]:invalid input param \n",__func__);
		goto error;
    }
    
	if (req->actual < (sizeof(struct usb_cdc_ncm_nth16) +sizeof(struct usb_cdc_ncm_ndp16))) 
    {
		USBSTACK_DBG("[%s]:frame too short\n",__func__);
		goto error;
	}
    //4ֽǷ
    is_aligned = ((unsigned long)(req->buf) & mask) ? 0: 1 ;
    if(likely(is_aligned))
    {
        nth16 = (struct usb_cdc_ncm_nth16 *)req->buf;
    }
    else
    {
        memcpy(&tmp_nth16,req->buf,sizeof(struct usb_cdc_ncm_nth16)) ;
        nth16 = &tmp_nth16;
    }


	if (nth16->dwSignature != cpu_to_le32(USB_CDC_NCM_NTH16_SIGN)) 
    {
		 USBSTACK_DBG( "[%s]:invalid NTH16 signature <%#010x>\n",__func__,le32_to_cpu(nth16->dwSignature));
		goto error;
	}

	len = le16_to_cpu(nth16->wBlockLength);
	if (len > ctx->port.fixed_out_len) 
    {
			 USBSTACK_DBG( "[%s]:unsupported NTB block length %u/%u\n", __func__,len,ctx->port.fixed_out_len);
		goto error;
	}

	if ((ctx->rx_seq + 1) != le16_to_cpu(nth16->wSequence) &&
	    (ctx->rx_seq || le16_to_cpu(nth16->wSequence)) &&
	    !((ctx->rx_seq == 0xffff) && !le16_to_cpu(nth16->wSequence)))
	{
		 USBSTACK_DBG( "[%s]:sequence number glitch prev=%d curr=%d\n",__func__,ctx->rx_seq, le16_to_cpu(nth16->wSequence));
	}
	ctx->rx_seq = le16_to_cpu(nth16->wSequence);

	ret = le16_to_cpu(nth16->wNdpIndex);
error:
	return ret;
}


/* verify NDP header and return number of datagrams, or negative error */
static int cdc_ncm_rx_verify_ndp16(struct usb_request *req, int ndpoffset )
{
	struct usb_cdc_ncm_ndp16 *ndp16;
    struct usb_cdc_ncm_ndp16 ndp16_tmp;
    unsigned long mask = 3;
    bool is_aligned = 0 ;
	int ret = -EINVAL;
    if(req == NULL || req->buf== NULL || req->actual == 0 || ndpoffset == 0 || ndpoffset %4 != 0 )
    {
		USBSTACK_DBG( "[%s]:invalid input param ,ndpoffset = %d\n",__func__,ndpoffset);
		goto error;
    }
	if ((ndpoffset + sizeof(struct usb_cdc_ncm_ndp16)) > req->actual) {
		USBSTACK_DBG( "[%s]:invalid NDP offset  <%u>\n",__func__,ndpoffset);
		goto error;
	}
    
    is_aligned = ((unsigned long)req->buf & mask) ? 0: 1 ;
    if(likely(is_aligned))
    {
        ndp16 = (struct usb_cdc_ncm_ndp16 *)(req->buf + ndpoffset);
    }
    else
    {
        memcpy(&ndp16_tmp,req->buf + ndpoffset,sizeof(struct usb_cdc_ncm_ndp16)) ;
        ndp16 = &ndp16_tmp;
    }

	if (le16_to_cpu(ndp16->wLength) < USB_CDC_NCM_NDP16_LENGTH_MIN) {
		USBSTACK_DBG( "[%s]:invalid DPT16 length <%u>\n",__func__, le16_to_cpu(ndp16->wLength));
		goto error;
	}

	ret = ((le16_to_cpu(ndp16->wLength) -
					sizeof(struct usb_cdc_ncm_ndp16)) /
					sizeof(struct usb_cdc_ncm_dpe16));
	ret--; /* we process NDP entries except for the last one */

	if ((sizeof(struct usb_cdc_ncm_ndp16) +
	     ret * (sizeof(struct usb_cdc_ncm_dpe16))) > req->actual) {
		USBSTACK_DBG( "[%s]:Invalid nframes = %d\n", __func__,ret);
		ret = -EINVAL;
	}

error:
	return ret;
}
/*
*  type 0:ȡ룬1ȡ 
*/
int mbim_get_ntb_aligned_offset(unsigned long offset)
{
    if(g_mbim == NULL)
    {
        return -ENODEV ;
    }
    struct f_mbim *mbim = g_mbim ;

    le16_to_cpu(mbim_ntb_parameters.wNdpInDivisor);
    le16_to_cpu(mbim_ntb_parameters.wNdpInPayloadRemainder);
    le16_to_cpu(mbim_ntb_parameters.wNdpInAlignment) ;
    return 0;

}

#define MBIM_EXTRA_PADDING   1

int mbim_get_nth16_and_ndp16_size(void)
{
    int cnt = get_vnic_multi_packet_num() + MBIM_EXTRA_PADDING + 1 ;
    return sizeof(struct usb_cdc_ncm_nth16)+sizeof(struct usb_cdc_ncm_ndp16)+ sizeof(struct usb_cdc_ncm_dpe16)*cnt ;
}
int mbim_ncm16_and_ndp16_init(char * buf ,int len)
{
    struct f_mbim *mbim= g_mbim ;
    int siz = mbim_get_nth16_and_ndp16_size() ;
    if(buf== NULL ||  len < siz || mbim == NULL)
    {
        return -EINVAL ;
    }

    void *tmp ;
    memset(buf,0,siz);
    tmp = (void*)buf ;

    put_unaligned_le32(mbim->parser_opts->nth_sign, tmp);
    tmp += sizeof(mbim->parser_opts->nth_sign) ;
    //len
    put_unaligned_le16(mbim->parser_opts->nth_size, tmp);
    tmp += sizeof(mbim->parser_opts->nth_size) ;
    //seq
    put_unaligned_le16(mbim->tx_seq++, tmp);
    tmp += sizeof(mbim->tx_seq) ;
    //block_len
    
    put_unaligned_le16(siz, tmp);
    tmp += sizeof(mbim->parser_opts->block_length);
    
    //index
    uint16_t  index = sizeof(struct usb_cdc_ncm_nth16) ;
    put_unaligned_le16(index, tmp);
    tmp += sizeof(index) ;

    //ndp
    //sig޸Ϊips
    uint8_t sess_id = atomic_read(&mbim->session_id) ;
    u32 sig = USB_CDC_MBIM_NDP16_IPS_SIGN | (sess_id << 24) ;
    put_unaligned_le32(sig, tmp);
    tmp += sizeof(mbim->parser_opts->ndp_sign) ;
    //len
    put_unaligned_le16(sizeof(struct usb_cdc_ncm_ndp16)+sizeof(struct usb_cdc_ncm_dpe16), tmp);
	return 0 ;
}


int mbim_fill_ncm16_vary_head_info(char *buf ,struct mbim_ncm_info *info)
{
    //nthС,ndp index
    if(buf== NULL || info == NULL)
    {
        return -EINVAL ;
    }

    char *nth16;
    char *ndp16;
    char *datagram_cur_buf ;
    uint16_t ndp16_len;
    char *ndp16_buf = NULL ;
#if 0
    unsigned long mask = 3;
    bool is_aligned = ((unsigned long)buf & mask) ? 0: 1 ;
    if(likely(is_aligned))
    {
        nth16 = (struct usb_cdc_ncm_nth16 *)(buf);
        nth16->wBlockLength = cpu_to_le16(info->nth_block_len);
        ndp16_buf = buf + cpu_to_le16(ndp16->wNextNdpIndex);
        ndp16  =  (struct usb_cdc_ncm_ndp16 *)(ndp16_buf );
        ndp16_len = cpu_to_le16(ndp16->wLength);
        //datagram offset
        datagram_cur_buf = (struct usb_cdc_ncm_dpe16  *)(ndp16_buf + ndp16_len - sizeof(struct usb_cdc_ncm_dpe16)) ;
        datagram_cur_buf->wDatagramIndex =  cpu_to_le16(info->ndp_datagram_off);
        datagram_cur_buf->wDatagramLength =  cpu_to_le16(info->ndp_datagram_len);
        ndp16->wLength =  cpu_to_le16(ndp16_len+sizeof(struct usb_cdc_ncm_dpe16));
    }
    else
 #endif       
    {

		char *ptmp = buf+offsetof(struct usb_cdc_ncm_nth16, wBlockLength);
		//printk("\nwBlockLength :0x%02x-0x%02x\n",ptmp[0],ptmp[1]);
        put_unaligned_le16(info->nth_block_len,ptmp) ;
		//printk("[func]:%s,[line]:%d, val = %d \n",__func__,__LINE__,get_unaligned_le16(ptmp));
		ptmp = buf+offsetof(struct usb_cdc_ncm_nth16, wNdpIndex);
		//printk("\nwNdpIndex:0x%02x-0x%02x\n",ptmp[0],ptmp[1]);
        ndp16_buf = buf + get_unaligned_le16(ptmp) ;
        ndp16_len  = get_unaligned_le16(ndp16_buf + 4) ;
		//printk("[func]:%s,[line]:%d, val = %d \n",__func__,__LINE__,ndp16_len);
        datagram_cur_buf = ndp16_buf + ndp16_len - sizeof(struct usb_cdc_ncm_dpe16);
        put_unaligned_le16(info->ndp_datagram_off,datagram_cur_buf+offsetof(struct usb_cdc_ncm_dpe16, wDatagramIndex));
        put_unaligned_le16(info->ndp_datagram_len,datagram_cur_buf+offsetof(struct usb_cdc_ncm_dpe16, wDatagramLength));
        put_unaligned_le16(ndp16_len+sizeof(struct usb_cdc_ncm_dpe16),ndp16_buf + 4);

    }

 	return 0 ; 


}

int mbim_get_first_ndp16_offset(struct            usb_request *req)
{
     if(req == NULL)
    {
        printk("[%s]:input param invalid \n",__func__)  ;
        return -EINVAL ;
    }
    return cdc_ncm_rx_verify_nth16(req);
}

int mbim_get_trans_buffer_size(void)
{
    //
    if (!g_mbim)
    {
        return -1;
    }
    return   max_t( u32 ,g_mbim->port.fixed_out_len, g_mbim->port.fixed_in_len);

}


/*
 *ȡƫ
*/
int mbim_get_next_datagram_fragment(struct           usb_request *req ,int prev_ndp_off, int* cur_first_datagram ,int *next_ndp)
{
    int nframes = 0;
    int ret = -EINVAL ;
    uint32_t	Signature;
	int i = 0 ;
	char* pbuf ;

    if(req == NULL || req->buf == NULL || prev_ndp_off <= 0 || cur_first_datagram == NULL || next_ndp ==NULL )
    {
        printk("[%s]:input param invalid \n",__func__)  ;
        goto ERR ;
    }
 

    nframes = cdc_ncm_rx_verify_ndp16(req, prev_ndp_off);
    if(nframes < 0)
    {
        goto ERR ;
    }
    
    Signature = get_unaligned_le32(req->buf + prev_ndp_off +offsetof(struct usb_cdc_ncm_ndp16,dwSignature)) ;
    //printk("dwSignature = 0x%x",dwSignature) ;
	switch (Signature & 0x00ffffff) {
	case USB_CDC_MBIM_NDP16_IPS_SIGN:
		break;
	case USB_CDC_MBIM_NDP16_DSS_SIGN:
        USBSTACK_DBG("[%s]: packet type is DSS",__func__) ;
        goto ERR ;
		break;
	default:
		USBSTACK_DBG( "[%s] : unsupported NDP signature <0x%08x>\n",__func__,Signature);
		goto ERR;
        break ;
	}
    *cur_first_datagram =  prev_ndp_off + sizeof(struct usb_cdc_ncm_ndp16) ;
    *next_ndp = get_unaligned_le16(req->buf + prev_ndp_off+offsetof(struct usb_cdc_ncm_ndp16,wNextNdpIndex)) ;
    return  nframes ;
ERR:
    return ret ;
}

int mbim_get_reverse_head_size()
{
    //ݲvlanʱҪճĴС
    return ETH_HLEN ;
}

static struct sk_buff *mbim_wrap_ntb(struct gether *port,struct sk_buff *skb)
{
    //δעvlanصĻص˲֧vlanصĴ
    
    bool is_ip = false;
	int i = 0 ;
    skb_reset_mac_header(skb) ;
    is_ip = is_ip_proto(eth_hdr(skb)->h_proto);
    //printk("%s: mac frame is 802.3 ,start exe mbim_wrap_ntb ......\n",__func__) ;	
    //<=1500802.3֡>=1536Ethernet II֡
    //mbimֻipip
    if(is_ip == false)
    {
         USBSTACK_DBG("%s: mac frame is 802.3 ,system is unsupported mac type ,mac type (be) is 0x%04x\n"
            ,__func__,eth_hdr(skb)->h_proto) ;	 
         dev_kfree_skb_any(skb);
         return NULL;
    }
    skb_pull(skb, ETH_HLEN);
	return skb;
}


static int mbim_unwrap_ntb(struct gether *port,struct sk_buff *skb,struct sk_buff_head *list)
{
    //ͷ
    if(port == NULL || skb == NULL || list == NULL )
    {
        printk("[%s]:input param invalid \n",__func__)  ;
        return -EINVAL ;
    }

    char *ipth = skb->data + ETH_HLEN ;
	//printk("[%s] :before skb->lenth = %d!!!!",__func__,skb->len);
    skb_put(skb, ETH_HLEN);
	//printk("[%s] :after skb->lenth= %d!!!!",__func__,skb->len);
    //macͷݲvlan
	__be16 proto = htons(ETH_P_802_3);
    switch (*ipth & 0xf0)
     {
        case 0x40:
            proto = htons(ETH_P_IP);
			skb->protocol = ETH_P_IP ;
            break;
        case 0x60:
            proto = htons(ETH_P_IPV6);
			skb->protocol = ETH_P_IPV6 ;
            break;
        default:
            dev_kfree_skb_any(skb) ;
            USBSTACK_DBG("[%s] :ip type is unknown:0x%x !!!!\n",__func__,proto);
            return -1 ;
   }

    
    //skb_push(skb, ETH_HLEN);
    skb_reset_mac_header(skb) ;
    //Դ/Ŀmacַ
    struct ethhdr *ehdr =eth_hdr(skb) ; //(struct ethhdr *)skb->data;  // 
	memcpy(ehdr->h_source,mbim_mac,sizeof(mbim_mac));
    memcpy(ehdr->h_dest,port->ioport->net->dev_addr,sizeof(ehdr->h_dest));
    skb_queue_tail(list,skb) ;
    //ip
    ehdr->h_proto = proto ;
    return 0 ;
}

void mbim_release_pool(struct f_mbim *mbim)
{
	if(!mbim){
		printk("mbim_release_pool, mbim is null\n");
	}
 
	 mbim_conn_pool_deinit(mbim);
}

static void mbim_disable(struct usb_function *f)
{
	struct f_mbim		*mbim = func_to_mbim(f);
	struct usb_composite_dev *cdev = f->config->cdev;
	//gether_mbim_uevent(0);
     unsigned long flags ;
	 struct mbim_pool_ctrl_s *pctrl = NULL ;
    printk("\n%s, line:%u \n\n\n", __func__, __LINE__);
	mbim->trans_flag = 0;
	atomic_set(&mbim->notify_count, 0);
	//USBSTACK_DBG(cdev, "mbim deactivated\n");
	if (mbim->port.in_ep->driver_data)
		gether_disconnect(&mbim->port);

	if (mbim->notify->driver_data) {
		usb_ep_disable(mbim->notify);
		mbim->notify->driver_data = NULL;
		mbim->notify->desc = NULL;
	}
	
     spin_lock_irqsave(&mbim->ctrl_lock,flags);	
	//check ctrl rx/tx list
	if(!list_empty(&mbim->ctrl_tx_list)){
		printk("mbim_disable, clean ctrl_tx_list, cnt:%u\n", atomic_read(&mbim->ctrl_tx_cnt));
		while(!list_empty(&mbim->ctrl_tx_list)){
		     pctrl = list_first_entry(&mbim->ctrl_tx_list, struct mbim_pool_ctrl_s, list) ;
			list_del_init(&pctrl->list);
			atomic_dec(&mbim->ctrl_tx_cnt) ;
			pctrl->real_size = 0;
			list_add_tail(&pctrl->list,&mbim->idle_list);
			atomic_inc(&mbim->idle_cnt) ;			
		}
	}
	if(!list_empty(&mbim->ctrl_rx_list)){
		printk("mbim_disable, clean ctrl_rx_list, cnt:%u\n", atomic_read(&mbim->ctrl_rx_cnt));
		while(!list_empty(&mbim->ctrl_rx_list)){
		     pctrl = list_first_entry(&mbim->ctrl_rx_list, struct mbim_pool_ctrl_s, list) ;
			list_del_init(&pctrl->list);
			atomic_dec(&mbim->ctrl_rx_cnt) ;
			pctrl->real_size = 0;
			list_add_tail(&pctrl->list,&mbim->idle_list);
			atomic_inc(&mbim->idle_cnt) ;			
		}
	}
	 spin_unlock_irqrestore(&mbim->ctrl_lock,flags);		
}

static void mbim_open(struct gether *geth)
{
	printk("mbim_open\n");
	struct f_mbim		*mbim = func_to_mbim(&geth->func);
	spin_lock(&mbim->lock);
	mbim->is_open = true;
	//mbim_notify(mbim);
	spin_unlock(&mbim->lock);
}

static void mbim_close(struct gether *geth)
{
	printk("mbim_close\n");
	struct f_mbim		*mbim = func_to_mbim(&geth->func);
    if(mbim->is_open == false)
    {
        printk("mbim net card has been closed !!! \n") ;
        return  ;
    }
	//USBSTACK_DBG(mbim->port.func.config->cdev, "%s\n", __func__);

	spin_lock(&mbim->lock);
	mbim->is_open = false;
	//mbim_notify(mbim);
	spin_unlock(&mbim->lock);
}

int mbim_set_param_medium(u8 configNr, u32 medium)
{
	printk("$$$$mbim_set_param_medium\n");
	//pr_debug("%s: %u %u\n", __func__, medium, speed);
	//if (configNr >= RNDIS_MAX_CONFIGS) return -1;
	mbim_per_dev_params[configNr].medium = medium;

	return 0;
}

void mbim_set_host_mac(int configNr, const u8 *addr)
{
	mbim_per_dev_params[configNr].host_mac = addr;
}


static int 
mbim_bind(struct usb_configuration *c, struct usb_function *f)
{
	printk("$$$$mbim_bind\n");
	struct usb_composite_dev *cdev = c->cdev;
	struct f_mbim		*mbim = func_to_mbim(f);
	int			status;
	struct usb_ep		*ep;

	/* allocate instance-specific interface IDs */
	status = usb_interface_id(c, f);
	if (status < 0)
		goto fail;
	mbim->ctrl_id = status;
	mbim_iad_descriptor.bFirstInterface = status;

	mbim_comm_intf.bInterfaceNumber = status;
	mbim_union_desc.bMasterInterface0 = status;

	status = usb_interface_id(c, f);
	if (status < 0)
		goto fail;
	mbim->data_id = status;

	mbim_data_intf.bInterfaceNumber = status;
	mbim_data_intf1.bInterfaceNumber = status;
	mbim_union_desc.bSlaveInterface0 = status;

	status = -ENODEV;

	/* allocate instance-specific endpoints */
	ep = usb_ep_autoconfig(cdev->gadget, &mbim_in_desc);
	if (!ep)
		goto fail;
	mbim->port.in_ep = ep;
	printk("$$$$mbim->port.in_ep->desc = %p\n",mbim->port.in_ep->desc);
	ep->driver_data = cdev;	/* claim */

	ep = usb_ep_autoconfig(cdev->gadget, &mbim_out_desc);
	if (!ep)
		goto fail;
	mbim->port.out_ep = ep;
	printk("$$$$mbim->port.out_ep->desc = %p\n",mbim->port.out_ep->desc);
	ep->driver_data = cdev;	/* claim */

	ep = usb_ep_autoconfig(cdev->gadget, &mbim_notify_desc);
	if (!ep)
		goto fail;
	mbim->notify = ep;
	printk("$$$$mbim->notify->desc = %p\n",mbim->notify->desc);
	ep->driver_data =   cdev;	/* claim */


	status = -ENOMEM;

	/* allocate notification request and buffer */
	mbim->notify_req = usb_ep_alloc_request(ep, GFP_KERNEL);
	if (!mbim->notify_req)
		goto fail;
	mbim->notify_req->buf = kmalloc(8, GFP_KERNEL);
	if (!mbim->notify_req->buf)
		goto fail;
	mbim->notify_req->length = 8;//MBIM_STATUS_BYTECOUNT;
	mbim->notify_req->context = mbim;
	mbim->notify_req->complete = mbim_response_complete;//mbim_notify_complete;
#if 1
	/* copy descriptors, and track endpoint copies */
	f->descriptors = usb_copy_descriptors(mbim_descriptor_function);
	if (!f->descriptors)
		goto fail;
#endif
	if (gadget_is_dualspeed(c->cdev->gadget)) {
		mbim_data_in.bEndpointAddress =
				mbim_in_desc.bEndpointAddress;
		mbim_data_out.bEndpointAddress =
				mbim_out_desc.bEndpointAddress;
		mbim_data_notify.bEndpointAddress =
				mbim_notify_desc.bEndpointAddress;

		/* copy descriptors, and track endpoint copies */
		f->hs_descriptors = usb_copy_descriptors(mbim_data_descriptor_function);
		if (!f->hs_descriptors)
			goto fail;
	}
	

	/*
	 * NOTE:  all that is done without knowing or caring about
	 * the network link ... which is unavailable to this code
	 * until we're activated via set_alt().
	 */

	mbim->port.open = mbim_open;
	mbim->port.close = mbim_close;
	
	status = mbim_register(mbim_response_available, mbim);
	if (status < 0)
		goto fail;

	mbim->config = status;

	//mbim_set_param_medium(mbim->config, NDIS_MEDIUM_802_3);
	mbim_set_host_mac(mbim->config, mbim->ethaddr);

	//
	multi_packet_handle_init(&mbim->port, cdev->gadget);
#if MULTIPACKET_BUF_ALLOC
	mbim->state = 1;
#endif     

	//USBSTACK_DBG(cdev, "CDC Network: %s speed IN/%s OUT/%s NOTIFY/%s\n",
	//		gadget_is_dualspeed(c->cdev->gadget) ? "dual" : "full",
	//		mbim->port.in_ep->name, mbim->port.out_ep->name,
	//		mbim->notify->name);
	return 0;

fail:
     printk("\n\n[file]: %s ,[][func]: %s ,[line] = %d \n\n",__FILE__,__func__,__LINE__);
	if (f->descriptors)
		usb_free_descriptors(f->descriptors);

	if (mbim->notify_req) {
		kfree(mbim->notify_req->buf);
		usb_ep_free_request(mbim->notify, mbim->notify_req);
	}

	/* we might as well release our claims on endpoints */
	if (mbim->notify)
		mbim->notify->driver_data = NULL;
	if (mbim->port.out_ep)
		mbim->port.out_ep->driver_data = NULL;
	if (mbim->port.in_ep)
		mbim->port.in_ep->driver_data = NULL;

	USB_ASSERT(cdev, "%s: can't bind, err %d\n", f->name, status);

	return status;
}

static void mbim_unbind(struct usb_configuration *c, struct usb_function *f)
{
	struct f_mbim		*mbim = func_to_mbim(f);
	mbim->trans_flag = 0;

	mbim_release_pool(mbim);
	
    multi_packet_handle_exit();
    rndis_deregister(mbim->config);
	//USBSTACK_DBG(c->cdev, "mbim unbind\n");

	if (gadget_is_dualspeed(c->cdev->gadget))
		usb_free_descriptors(f->hs_descriptors);
	usb_free_descriptors(f->descriptors);


	kfree(mbim->notify_req->buf);
	mbim->notify_req->buf = NULL;
	usb_ep_free_request(mbim->notify, mbim->notify_req);

#if MULTIPACKET_BUF_ALLOC
	mbim->state = 0;
#endif 
	mbim_string_defs[1].s = NULL;
	//kfree(mbim);
}

/**
 * mbim_bind_config - add CDC Network link to a configuration
 * @c: the configuration to support the network link
 * @ethaddr: a buffer in which the ethernet address of the host side
 *	side of the link was recorded
 * Context: single threaded during gadget setup
 *
 * Returns zero on success, else negative errno.
 *
 * Caller must have called @gether_setup().  Caller is also responsible
 * for calling @gether_cleanup() before module unload.
 */
 int mbim_init(void)
{
	u8 i;


	for (i = 0; i < MBIM_MAX_CONFIGS; i++) {


		mbim_per_dev_params[i].confignr = i;
		mbim_per_dev_params[i].used = 0;
		mbim_per_dev_params[i].state = 0;
		mbim_per_dev_params[i].media_state
				= 0;
		INIT_LIST_HEAD(&(mbim_per_dev_params[i].resp_queue));
	}

	//rndis_initialized = true;
	return 0;
}
 
#define Z_IPV4_FLAG           0x40
#define Z_IPV6_FLAG           0x60
 void mbim_mac_exchange(u8 *buff)
 {
	 
	 //mbim_ReversIpAddr(inBufData->node.pNodeBuf);
	 u8 tempbuff[16] = {0};
	 BUG_ON(buff == NULL);
	 //zOss_Printf(1, PRINT_LEVEL_NORMAL, "\r\n mbim_TransIpLoopback eeeeeeeeeeeeeeeeeeee\r\n");
	 if(((*buff) & 0xF0) == Z_IPV4_FLAG)
	 {
	 	//printk("mbim_mac_exchange v4\r\n");
		 memcpy(tempbuff, buff+12, 4);
		 memcpy(buff+12, buff+16, 4);
		 memcpy(buff+16, tempbuff, 4);
	 }
	 else if(((*buff) & 0xF0) == Z_IPV6_FLAG)
	 {
		// printk("mbim_mac_exchange v6\r\n");
		 memcpy(tempbuff, buff+8, 16);
		 memcpy(buff+8, buff+24, 16);
		 memcpy(buff+24, tempbuff, 16);
	 }
	 else
	 {
		 panic("mac_exchange unknown type\n");
	 }
 }
int loop_rcv_packet=0;
 int loop_rcv_byte=0;
 
 struct sk_buff  *t_skb = NULL;
 void mbim_lp_test_th(void *ptr)
 {
 
	unsigned long flags;
	int	retval = -ENOMEM;
	int wait_event_ret = 0;
	struct usb_request	*req = NULL;
	
    struct list_head  *rx_list_head ;	
    struct list_head  *rx_node ;
    struct mbim_pool_data_s * data_chan;
//       struct gether *port = container_of(ep, struct gether, out_ep);
//	struct eth_dev	*dev = container_of(port, struct eth_dev, port_usb);
	 struct sk_buff  *skb = NULL;

	 struct f_mbim	 *mbim = (struct f_mbim	*)ptr ;
	 
	while(!kthread_should_stop())
	{
		wait_event_ret = wait_event_interruptible(mbim->lp_wait,  
			atomic_read(&mbim->data_rx_cnt)||kthread_should_stop());
		
		if(kthread_should_stop())
		{
			printk("lp test thread stop");
			break;
		}

		if(atomic_read(&mbim->lb_flag) == 0)
			continue;
	//printk("lp_test_th, datalock:%x, cnt:%d\n", &mbim->data_lock, atomic_read(&mbim->data_rx_cnt));	
 spin_lock_irqsave(&mbim->data_lock,flags);

    if(list_empty(&mbim->data_rx_list))
    {
        atomic_set(&mbim->data_rx_cnt,0) ;
        spin_unlock_irqrestore(&mbim->data_lock,flags);
        printk("[func]:%s,[line]:%d ,data rx list is empty \n",__func__,__LINE__) ;
       continue ;
    }
	
	while(!list_empty(&mbim->data_rx_list)){			
		rx_list_head = &mbim->data_rx_list;
		
		if((rx_list_head == NULL) || (rx_list_head->next == rx_list_head)){
			spin_unlock_irqrestore(&mbim->data_lock,flags);
			break;
		}
		data_chan =  list_first_entry(rx_list_head, struct mbim_pool_data_s, list) ;
		list_del_init(&data_chan->list) ;
		atomic_dec(&mbim->data_rx_cnt);
		spin_unlock_irqrestore(&mbim->data_lock,flags);

		skb = (struct sk_buff	*)(data_chan->pdata) ;
		if(skb == NULL){		
			printk("mbim_data_read, skb is null\r\n");
			spin_lock_irqsave(&mbim->data_lock,flags);
			
			continue;
		}	
		t_skb = skb;
		skb_pull(skb, ETH_HLEN);
		wmb();
		mbim_mac_exchange(skb->data);

		if(atomic_read(&g_mbim->lb_flag) == 0)
			break;		
		if(mbim_loop_test_xmit(mbim->port.ioport,skb)) 
		{
			printk( "%s :send skb failed \n",__func__);
		}
		spin_lock_irqsave(&mbim->data_lock,flags);
		list_add_tail(&data_chan->list,&mbim->data_ilde_list);
		atomic_inc(&mbim->data_idle_cnt) ;		
		
	}//while rx_list_head
	spin_unlock_irqrestore(&mbim->data_lock,flags);
	
	}
 
 }

 int  mbim_bind_config(struct usb_configuration *c, u8 ethaddr[ETH_ALEN])
{
	printk("mbim_bind_config\n");
	struct f_mbim	*mbim ;
	int		status;
    if(g_mbim == NULL)
    {
         printk("[func]:%s,[line]:%d ,no function mbim  \n",__func__,__LINE__) ;
        return -ENODEV;
    }
    mbim = g_mbim ;
    if(mbim_conn_pool_init(mbim))
    {
        printk("[func]:%s,[line]:%d ,init pool failed\n",__func__,__LINE__) ;
        return -ENOMEM ;
    }

//	if (!can_support_ecm(c->cdev->gadget) || !ethaddr)
//		return -EINVAL;
	mbim_init();
	/* maybe allocate device-global string IDs */
	if (mbim_string_defs[0].id == 0) {

		/* control interface label */
		status = usb_string_id(c->cdev);
		if (status < 0)
			return status;
		mbim_string_defs[STRING_CTRL_IDX].id = status;
		mbim_comm_intf.iInterface = status;

		/* data interface label */
		status = usb_string_id(c->cdev);
		if (status < 0)
			return status;
		mbim_string_defs[STRING_DATA_IDX].id = status;
		mbim_data_intf.iInterface = status;
		mbim_data_intf1.iInterface = status;

		/* MAC address */
		status = usb_string_id(c->cdev);
		if (status < 0)
			return status;
		mbim_string_defs[STRING_MAC_IDX].id = status;
		ecm_desc.iMACAddress = status;

		/* IAD */
		status = usb_string_id(c->cdev);
		if (status < 0)
			return status;
		mbim_string_defs[STRING_IAD_IDX].id = status;
		mbim_iad_descriptor.iFunction = status;
	}

	/* export host's Ethernet address in CDC format */
	snprintf(mbim->ethaddr, sizeof mbim->ethaddr,
		"%02X%02X%02X%02X%02X%02X",
		ethaddr[0], ethaddr[1], ethaddr[2],
		ethaddr[3], ethaddr[4], ethaddr[5]);
	mbim_string_defs[1].s = mbim->ethaddr;

	spin_lock_init(&mbim->lock);
	mbim_reset_values(mbim);
    //mbim->port.is_fixed = true;
	mbim->port.func.name = "mbim";
	mbim->port.func.strings = mbim_strings;
	/* descriptors are per-instance copies */
	mbim->port.func.bind = mbim_bind;
	mbim->port.func.unbind = mbim_unbind;
	mbim->port.func.set_alt = mbim_set_alt;
	mbim->port.func.get_alt = mbim_get_alt;
	mbim->port.func.setup = mbim_setup;
	mbim->port.func.disable = mbim_disable;
    
#ifdef CONFIG_PM
    mbim->port.func.suspend = mbim_suspend;
    mbim->port.func.resume = mbim_resume;
	atomic_set(&mbim->port.wake_state, 0);
#endif

	mbim->port.wrap = mbim_wrap_ntb;
	mbim->port.unwrap = mbim_unwrap_ntb;
	printk("$$$$MBIM usb_add_function\n");
	status = usb_add_function(c, &mbim->port.func);
	return status;
}


/*==========================================================================*/
/*==========================================================================*/

 int mbim_loop_test_xmit( struct eth_dev      *dev ,struct sk_buff* skb) ;
 int mbim_switch_network_mode(struct gether *link ,int type);
 
 static int mbim_ctrl_open(struct inode *ip, struct file *fp)
 {

    if (!g_mbim)
    {
        return -ENODEV;
    }
    printk("\n\n [func]:%s,[line]:%d  \n\n",__func__,__LINE__) ;
    fp->private_data = (void *)g_mbim ;
    return 0;
 }
 
 static int mbim_ctrl_release(struct inode *ip, struct file *fp)
 {
     printk("\n\n [func]:%s,[line]:%d  \n\n",__func__,__LINE__) ;
     return 0;
 }

static ssize_t mbim_ctrl_read(struct file *fp, char __user *buf,size_t count, loff_t *pos)
{

	int rn_cnt = 0 ;
	unsigned long flags;
	struct mbim_pool_ctrl_s *pctrl = NULL ;
	if (count < MBIM_MAX_CTRL_MSG) 
	{
	  printk("[func]:%s,[line]:%d ,rx list is empty \n",__func__,__LINE__) ;
	  return -EINVAL;
	}

	struct f_mbim* mbim_dev = (struct f_mbim *)fp->private_data;

	if(fp->f_flags& O_NONBLOCK  && atomic_read(&mbim_dev->ctrl_rx_cnt) == 0)
	{
	 return -EAGAIN ;
	}
	if(wait_event_interruptible(mbim_dev->ctrl_read_wq, atomic_read(&mbim_dev->ctrl_rx_cnt)))
	 return -ERESTARTSYS ;


	//ȡݣϱȥ
	spin_lock_irqsave(&mbim_dev->ctrl_lock,flags);
	if(list_empty(&mbim_dev->ctrl_rx_list))
	{
		atomic_set(&mbim_dev->ctrl_rx_cnt,0) ;
		spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);
		printk("[func]:%s,[line]:%d ,rx list is empty ,ctrl_rx_cnt = %d \n",__func__,__LINE__,atomic_read(&mbim_dev->ctrl_rx_cnt)) ;
		return -EAGAIN ;
	}
	pctrl = list_first_entry(&mbim_dev->ctrl_rx_list, struct mbim_pool_ctrl_s, list) ;
	list_del_init(&pctrl->list);
	atomic_dec(&mbim_dev->ctrl_rx_cnt) ;
	spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);

	if(copy_to_user(buf, pctrl->buf,pctrl->real_size)) 
	{
		spin_lock_irqsave(&mbim_dev->ctrl_lock,flags);
		list_add(&pctrl->list,&mbim_dev->ctrl_rx_list);
		atomic_inc(&mbim_dev->ctrl_rx_cnt) ;
		spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);
		printk("\n\n##########[func]:%s,[line]:%d ,copy_to_user failed \n\n\n",__func__,__LINE__) ;
		return -EFAULT ;
	}
	rn_cnt = pctrl->real_size ;
	drv_mbim_rx_static(pctrl);
	pctrl->real_size = 0 ;
	spin_lock_irqsave(&mbim_dev->ctrl_lock,flags);
	//list_del_init(&pctrl->list);
	//atomic_dec(&mbim_dev->ctrl_rx_cnt) ;
	list_add_tail(&pctrl->list,&mbim_dev->idle_list);
	atomic_inc(&mbim_dev->idle_cnt) ;
	spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);

	return  rn_cnt;
}

static ssize_t mbim_ctrl_write(struct file *fp, const char __user *buf, size_t count, loff_t *pos)
{
	int rn_cnt = 0 ;
	unsigned long flags ;
	int status = 0;
	struct f_mbim* mbim_dev = (struct f_mbim *)fp->private_data;
	struct mbim_pool_ctrl_s *pctrl = NULL ;
	
	if (count > MBIM_MAX_CTRL_MSG || count <= 12) 
	{
		printk("[func]:%s,[line]:%d ,param invalid \n",__func__,__LINE__) ;
		return -EINVAL;
	}

	if(mbim_dev->trans_flag == 0){
		USBSTACK_DBG("ctrl_write, ep not enabled, send nothing\n");
		printk("ctrl_write, ep not enabled, send nothing\n");
		return count;
	}
	u8 cid_buf_head[12] ;
	if(copy_from_user(cid_buf_head , buf,12))
	{
		 printk("[func]:%s,[line]:%d , copy data from user is error \n",__func__,__LINE__) ;
		 return -EFAULT ;
	}
	if(mbim_cid_msg_filter(cid_buf_head, 12, 0))
	{
		 printk("[func]:%s,[line]:%d , cid msg is intercepted \n",__func__,__LINE__) ;
		 return count;
	}

	if(fp->f_flags& O_NONBLOCK && atomic_read(&mbim_dev->idle_cnt) == 0)
	{
		 printk("[func]:%s,[line]:%d ,idle list is empty \n",__func__,__LINE__) ;
		 return -EAGAIN ;
	}

	if(wait_event_interruptible(mbim_dev->ctrl_write_wq, atomic_read(&mbim_dev->idle_cnt)))
	{
		 return -ERESTARTSYS ;
	}
	if(mbim_dev->trans_flag == 0){
		USBSTACK_DBG("ctrl_write, ep not enabled, send nothing\n");
		printk("ctrl_write, ep not enabled, send nothing\n");
		return count;
	}
	
	spin_lock_irqsave(&mbim_dev->ctrl_lock,flags);
	if(list_empty(&mbim_dev->idle_list))
	{
		atomic_set(&mbim_dev->idle_cnt,0) ;
		spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);
		printk("[func]:%s,[line]:%d ,idle list is empty \n",__func__,__LINE__) ;
		return -EAGAIN ;

	}
	pctrl = list_first_entry(&mbim_dev->idle_list, struct mbim_pool_ctrl_s, list) ;
	list_del_init(&pctrl->list);
	atomic_dec(&mbim_dev->idle_cnt) ;
	spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);

	if(copy_from_user(pctrl->buf,buf,count) )
	{
		spin_lock_irqsave(&mbim_dev->ctrl_lock,flags);
		list_add_tail(&pctrl->list,&mbim_dev->idle_list);
		atomic_inc(&mbim_dev->idle_cnt) ;
		spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);
		printk("[func]:%s,[line]:%d ,copy_from_user failed \n",__func__,__LINE__) ;
		return -EFAULT ;
	}
	pctrl->real_size = count ;
	spin_lock_irqsave(&mbim_dev->ctrl_lock,flags);
	//list_del_init(&pctrl->list);
	//atomic_dec(&mbim_dev->idle_cnt);
	list_add_tail(&pctrl->list, &mbim_dev->ctrl_tx_list);
	atomic_inc(&mbim_dev->ctrl_tx_cnt) ;
	drv_mbim_tx_static(pctrl);
	spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);
	//now first check is suspend
 	
#ifdef CONFIG_PM
	struct gether *port = &mbim_dev->port; 	
	if(port && port->suspend_state && atomic_read(&port->wake_state) == 0){
		if(port->func.config && port->func.config->cdev && port->func.config->cdev->gadget) {
			printk("-----mbim_ctrl_write, call usb_gadget_wakeup\n");
			if(mbim_dev->trans_flag == 0){
				//now check trans_flag, maybe had been disabled
				USBSTACK_DBG("ctrl_write, trans_flag is 0, don't wakeup\n");
				printk("ctrl_write,  trans_flag is 0, don't wakeup\n");
				return count;
			}
			atomic_set(&port->wake_state, 1);
		    usb_gadget_wakeup(port->func.config->cdev->gadget);
			//do{
				//msleep(1);
			//}while(port->suspend_state==1);
			atomic_set(&port->wake_state, 0);
		}
	} 
#endif

	//notify host to get data !!!
	if(mbim_response_available(mbim_dev)){
		printk("response_available delete tx\n");
		spin_lock_irqsave(&mbim_dev->ctrl_lock,flags);
		//maybe ctrl_tx_list has been clean up at this time while mbim_disable
		if(!list_empty(&mbim_dev->ctrl_tx_list)){
			list_del_init(&pctrl->list);
			atomic_dec(&mbim_dev->ctrl_tx_cnt);
			list_add_tail(&pctrl->list, &mbim_dev->idle_list);
			atomic_inc(&mbim_dev->idle_cnt) ;
		}
		spin_unlock_irqrestore(&mbim_dev->ctrl_lock,flags);		
	}
	//printk("\n\n########%s, %u ,end \n\n", __func__, __LINE__ );
	return count;
}

int mbim_get_work_mode(void)
{
	if(g_mbim == NULL)		
		return -ENODEV ;
	
	struct gether *link = &g_mbim->port;
 	struct eth_dev *dev = link->ioport;
	return  atomic_read(&dev->work_mode);

}

static long mbim_ctrl_ioctl(struct file *filp, unsigned int cmd, unsigned long arg)
{
    if(_IOC_TYPE(cmd) != MBIM_MAGIC)
    {
        return -ENOTTY ;
    }
     //ָ.......
            //Ͽ
    if(g_mbim == NULL)
    {
        printk("[func]:%s,[line]:%d ,mbim function  do not  init \n",__func__,__LINE__) ;
        return -ENODEV ;
    }
    switch(cmd)
    {
    case IOCTL_VNIC_SET_BLOCKTIME:
    {
        break;
    }

    case IOCTL_VNIC_FREE_READ_BUF:
    {
        break;
    }

    case IOCTL_VNIC_GET_WRITE_BUF:
    {

        break;
    }

    case IOCTL_VNIC_CONNECT:
    {
        //
        if(atomic_read(&g_mbim->netlink_path_status ) == 0 )
        {
            atomic_inc(&g_mbim->netlink_path_status);
            //bulkת
        }
        break;
    }

    case IOCTL_VNIC_DISCONNECT:
    {
        //Ͽ
        if(atomic_read(&g_mbim->netlink_path_status ) == 1 )
        {
            atomic_dec(&g_mbim->netlink_path_status);
            //Ͽת
        }

        break;
    }

    case IOCTL_VNIC_REG_CBK_XFER_STATISTICS:
    {

        break;
    }

    case IOCTL_VNIC_REG_CBK_NIC_DISABLE:
    {

        break;
    }

    case IOCTL_VNIC_FREE_UNREAD_BUF:
    {
        break;
    }
    case IOCTL_VNIC_GET_USB_STATUS:
    {
        break;
    }
    case IOCTL_VNIC_GET_CID_MAXTRANSFER_SIZE :
    {
        //ȡCIDƬֵ
        unsigned int val = MBIM_MAX_CTRL_MSG ;
        if(copy_to_user((unsigned __user *)arg ,&val,sizeof(val))) 
        {
            return -EFAULT ;
        }
        break ;
    }
    case IOCTL_VNIC_SET_CID_SESSIONID:  //session_id
    {
         unsigned int sess_id ;
        if(copy_from_user(&sess_id, arg ,sizeof(sess_id))) 
        {
            return -EFAULT ;
        }
        printk("[func]:%s ,[line]:%d ,invalid param,sess_id = %d\n",__func__,__LINE__,sess_id);
        if(sess_id >255)
        {
          
            return -EINVAL ;

        }
        atomic_set(&g_mbim->session_id,0) ;
        break ;
    }
    case IOCTL_VNIC_SET_CID_DSSSESSIONID:  //session_id
    {
        unsigned int sess_id ;
        if(copy_from_user(&sess_id, arg ,sizeof(sess_id))) 
        {
            return -EFAULT ;
        }
        printk("[func]:%s ,[line]:%d ,invalid param,sess_id = %d\n",__func__,__LINE__,sess_id);
        if(sess_id >255)
        {
            return -EINVAL ;
        }
        atomic_set(&g_mbim->dss_session_id,0) ;
        break ;
    }
    case IOCTL_VNIC_SET_NET_LOOP_TEST:
    {
        //òԻػ
        
       #if 0 
        if(g_mbim->is_open != 0 )
        {
            printk("[func]: %s  ,[line]:%d ,please turn off net device \n",__func__,__LINE__) ;
            return -1 ;
        }
		#endif
        //ûػԷ
         unsigned int val ;
        if(copy_from_user(&val, arg ,sizeof(val))) 
        {
            return -EFAULT ;
        }
        printk("[func]:%s ,[line]:%d ,IOCTL_VNIC_SET_NET_LOOP_TEST,cmd:%d \n",__func__,__LINE__, val);

			
        if(mbim_switch_network_mode(&g_mbim->port ,val))
        {
            return -ENODEV ;
        }
    
       // msleep(20) ;
        break ;
    }
    case IOCTL_VNIC_GET_NET_STATUS :
    {
        //ȡ״̬
        unsigned int val = g_mbim->is_open ;
        if(copy_to_user((unsigned __user *)arg ,&val,sizeof(val))) 
        {
            return -EFAULT ;
        }
        break;
    }
    default: 
    {
        return -ENOTTY ;
    }
    
    }
    return 0 ;
}
 


static int mbim_data_open(struct inode *ip, struct file *fp)
{
 	//mbim_per_dev_params[0].dev
 	int rtv = 0;
	printk("----mbim_data_open enter, g_mbim:%p\r\n", g_mbim);
//	panic("mbim_data_open enter\n");
     if (!g_mbim)
     {
         return -ENODEV;
     }
	 
	 printk("----mbim_data_open enter\r\n");
	g_mbim->lp_thread = kthread_run(mbim_lp_test_th, (unsigned long)g_mbim, "mbim_lptest_thread");
	BUG_ON(IS_ERR(g_mbim->lp_thread));	
	
	 atomic_set(&g_mbim->lb_flag,1);
     fp->private_data = (void *)g_mbim ;
	struct gether *link = &g_mbim->port;
 	struct eth_dev *dev = link->ioport;
	if(g_mbim->state != 2)
    {	
		rtv = multi_packet_buf_alloc();
		if(rtv < 0)
        {
			printk("eth_open, net is mbim and req alloc faild with no memory\n");
			return rtv;
		}
		g_mbim->state = 2;
	}	
	multi_packet_activate();

	/* fill the rx queue */
	rx_fill(dev, GFP_KERNEL);

	/* and open the tx floodgates */
	atomic_set(&dev->tx_qlen, 0);	 
	
	if (link->open)
		link->open(link);
    return 0 ;
 }
 
 static int mbim_data_release(struct inode *ip, struct file *fp)
 { 
	 unsigned long	 flags;
	 printk("----mbim_data_release enter,g_mbim:%p\r\n",g_mbim);
	// panic("mbim_data_release enter\n");
     fp->private_data = NULL;
     if (!g_mbim)
     {
         return -ENODEV;
     }
	 atomic_set(&g_mbim->lb_flag,0);

	kthread_stop(g_mbim->lp_thread);	 
	// wake_up(&g_mbim->data_read_wq);
	// wake_up(&g_mbim->data_write_wq);
	 printk("----mbim_data_release enter,wakeup rx/tx queue 2 end\r\n");

	struct gether *link = &g_mbim->port;
	 struct eth_dev *dev = link->ioport;

	 spin_lock_irqsave(&dev->lock, flags);
	 
	if (link->close)
		link->close(link);
	printk("----mbim_data_release enter,closed link\r\n");
	
	u_ether_tx_vnic_packet_list();
	
	printk("----mbim_data_release enter,clean tx\r\n");
	spin_unlock_irqrestore(&dev->lock, flags);
	
     return 0;
 }



 static ssize_t mbim_data_read(struct file *fp, char __user *buf,size_t count, loff_t *pos)
 {
     int rn_cnt = 0 ;
     unsigned long flags;
     struct f_mbim* mbim_dev = (struct f_mbim *)fp->private_data;
     long copy_ret = 0 ;
    //  printk("\n\n----[func]:%s,[line]:%d .buf:%x\n\n",__func__,__LINE__,buf) ;
     if(mbim_dev == NULL ||  mbim_dev->port.ioport == NULL )
     {
        printk("[func]:%s,[line]:%d no dev \n",__func__,__LINE__) ;
        return -ENODEV ;

     }
     if(count < mbim_dev->port.ioport->net->mtu)
     {
         printk("[func]:%s,[line]:%d param inval \n",__func__,__LINE__) ;
         return -EINVAL ;
     }
     
     if(atomic_read(&mbim_dev->data_rx_cnt) == 0)
     {
        if(fp->f_flags& O_NONBLOCK)
        {
			printk("[func]:%s,[line]:%d f_flags& O_NONBLOCK return \n",__func__,__LINE__) ;
            return -EAGAIN ;
        }
		
		//printk("\r\n-----[func]:%s,[line]:%d now wait \r\n",__func__,__LINE__) ;
        if(wait_event_interruptible(mbim_dev->data_read_wq, atomic_read(&mbim_dev->data_rx_cnt))){
			printk("[func]:%s,[line]:%d afterwait \n",__func__,__LINE__) ;
            return -ERESTARTSYS ;
        }
     }
	// printk("mbim_data_read,wakeup \r\n") ;
	 
    if(atomic_read(&mbim_dev->lb_flag) == 0){
		//this means loopback test end
		return -EINVAL;
    }
     spin_lock_irqsave(&mbim_dev->data_lock,flags);

    if(list_empty(&mbim_dev->data_rx_list))
    {
        atomic_set(&mbim_dev->data_rx_cnt,0) ;
        spin_unlock_irqrestore(&mbim_dev->data_lock,flags);
        printk("[func]:%s,[line]:%d ,data rx list is empty \n",__func__,__LINE__) ;
        return -EAGAIN ;
    }
    struct mbim_pool_data_s * data_chan =  list_first_entry(&mbim_dev->data_rx_list, struct mbim_pool_data_s, list) ;
    list_del_init(&data_chan->list) ;
    atomic_dec(&mbim_dev->data_rx_cnt);
    spin_unlock_irqrestore(&mbim_dev->data_lock,flags);
    struct sk_buff	*skb = (struct sk_buff	*)(data_chan->pdata) ;
	if(skb == NULL){
		
	printk("mbim_data_read, skb is null\r\n");
		goto enqueu_idle;
	}
    skb_pull(skb, ETH_HLEN);
	
	//printk("mbim_data_read, ready read cout = %d ,skb->len:%d \r\n",count , skb->len) ;
	if(count < skb->len)
	{
		printk("\n#####[%s]: notice !!!!!!, ready read cout = %d ,skb->len:%d \r\n",__func__,count , skb->len) ;

	}
	//printk("mbim_data_read, buf len:%d, skb len:%d, data len:%d, buf:%x\r\n", count, 
	//skb->len, skb->data_len, buf);

	 rn_cnt = (skb->len > count) ? count : skb->len;
	// rn_cnt = skb->data_len >count ? count : skb->data_len;
	copy_ret = copy_to_user(buf, skb->data ,rn_cnt);
    if(copy_ret)
    {
         spin_lock_irqsave(&mbim_dev->data_lock,flags);
         list_add(&data_chan->list,&mbim_dev->data_rx_list);
         atomic_inc(&mbim_dev->data_rx_cnt) ;
         spin_unlock_irqrestore(&mbim_dev->data_lock,flags);
         dev_kfree_skb_any(skb);
         printk("[func]:%s,[line]:%d ,copy_to_user failed,ret:%ld \n",__func__,__LINE__,copy_ret ) ;
         return -EFAULT ;
    }

    dev_kfree_skb_any(skb);
enqueu_idle:	
	data_chan->pdata = NULL;
	spin_lock_irqsave(&mbim_dev->data_lock,flags);
	list_add_tail(&data_chan->list,&mbim_dev->data_ilde_list);
	atomic_inc(&mbim_dev->data_idle_cnt) ;
	spin_unlock_irqrestore(&mbim_dev->data_lock,flags);
    return rn_cnt;
  }

  static ssize_t mbim_data_write(struct file *fp, const char __user *buf,size_t count, loff_t *pos)
  {
    //жmbim豸Ƿ
    int cnt = 0;
    unsigned long       flags;
	
    //printk("\n\n--------[func]:%s,[line]:%d write len:%d \n\n",__func__,__LINE__, count) ;
    struct f_mbim* mbim_dev = (struct f_mbim *)fp->private_data;

	struct gether *link = &mbim_dev->port;
 	struct eth_dev *dev = link->ioport;	
    if(mbim_dev == NULL)
    {
         printk("[func]:%s,[line]:%d no dev \n",__func__,__LINE__) ;
         return -ENODEV ;
    }
	
    
  //  if(atomic_read(&mbim_dev->data_tx_cnt) >=  32 )
  //  {
       if(fp->f_flags& O_NONBLOCK)
       {
		   printk("[func]:%s,[line]:%d f_flags& O_NONBLOCK return\n",__func__,__LINE__) ;
           return -EAGAIN ;
       }
	   
       if(wait_event_interruptible(mbim_dev->data_write_wq, atomic_read(&dev->tx_qlen) == 0)){
           return -ERESTARTSYS ;
	    }
	
    if(atomic_read(&mbim_dev->lb_flag) == 0){
		//this means loopback test end
	printk("[func]:%s,[line]:%d lb_flag is 0 return\n",__func__,__LINE__) ;
		return 0;
    }
    spin_lock_irqsave(&dev->lock, flags);
	
    if (list_empty(&dev->tx_reqs))
    {		
	    spin_unlock_irqrestore(&dev->lock, flags);
		printk("[func]:%s,[line]:%d tx_reqs is empty return\n",__func__,__LINE__) ;
		return -ENOMEM;
	}
    spin_unlock_irqrestore(&dev->lock, flags);
    size_t size = sizeof(struct ethhdr) + mbim_dev->port.ioport->net->mtu + 2 + MBIM_IP_MTU_EXTRA ;
    struct sk_buff *skb = dev_alloc_skb(size);
	if (skb == NULL) {
		printk( "%s :no tx skb\n",__func__);
		return -ENOMEM;
	}
    skb_reserve(skb, 2);
    skb_pull(skb,sizeof(struct ethhdr));
    skb_put(skb,count);
    if(copy_from_user(skb->data,buf,count))
    {
        dev_kfree_skb_any(skb);
        printk( "%s :copy_fom_user failed \n",__func__);
        return -EFAULT ;
    }
	
    
	//printk( "%s :now mbim_loop_test_xmit, skb len:%d\r\n",__func__, skb->len);
    if(mbim_loop_test_xmit(mbim_dev->port.ioport,skb)) 
    {
        printk( "%s :send skb failed \n",__func__);
        return -EFAULT ;
    }
    
    return count ;
  }
  


   /* file operations for mbim control device /dev/android_mbim_ctrl */
 static const struct file_operations mbim_ctrl_fops = {
     .owner = THIS_MODULE,
     .read = mbim_ctrl_read,
     .write = mbim_ctrl_write,
     .open = mbim_ctrl_open,
     .release = mbim_ctrl_release,
     .unlocked_ioctl = mbim_ctrl_ioctl ,
 };
 
 static struct miscdevice mbim_ctrl_device = {
     .minor = MISC_DYNAMIC_MINOR,
     .name = MBIM_CTRL_NAME,
     .fops = &mbim_ctrl_fops,
 };

 
  /* file operations for mbim data  device /dev/android_mbim_data */
  static const struct file_operations mbim_data_fops = {
      .owner = THIS_MODULE,
      .read = mbim_data_read,
      .write = mbim_data_write,
      .open = mbim_data_open,
      .release = mbim_data_release,
  };
  
  static struct miscdevice mbim_data_device = {
      .minor = MISC_DYNAMIC_MINOR,
      .name = MBIM_DATA_NAME,
      .fops = &mbim_data_fops,
  };

static int mbim_conn_pool_init(struct f_mbim * dev)
{

	unsigned long flags;
	
    if(dev ==NULL)
    {
        return -1 ;
    }
	if(dev->pool_mem){
		printk("mbim_conn_pool_init, pool_mem already alloced\n");
		//panic("pool_mem already alloced\n");
	}
    //ͨ
    void* pbuf = NULL ;
    
    int i = 0 ;
    printk("[func]:%s,[line]:%d  \n",__func__,__LINE__) ;
    unsigned int element_aligned_max_size = ((sizeof (struct mbim_pool_ctrl_s)+ MBIM_MAX_CTRL_MSG+7)>>3)<<3; //8ֽڶ
    //element_aligned_max_size = sizeof (struct mbim_pool_ctrl_s)+ MBIM_MAX_CTRL_MSG;

    pbuf =  kzalloc(element_aligned_max_size * MBIM_MAX_POOL_NUM*2, GFP_KERNEL);
    if(pbuf == NULL)
    {
        printk("[func]:%s,[line]:%d ,alloc mbim_pool_ctrl_s ,no mem \n",__func__,__LINE__) ;
        return -ENOMEM;
    }
	spin_lock_irqsave(&dev->ctrl_lock,flags);
	
    struct mbim_pool_ctrl_s* pentry = ( struct mbim_pool_ctrl_s* )pbuf;
    for(i = 0 ;i < MBIM_MAX_POOL_NUM*2 ;i++)
    {
        pentry->max_size = MBIM_MAX_CTRL_MSG ;
        list_add_tail(&pentry->list, &dev->idle_list) ;
        pentry = (struct mbim_pool_ctrl_s* ) ((u8 *)pentry + element_aligned_max_size);
        atomic_inc(&dev->idle_cnt);
    }
    dev->pool_mem = pbuf ;
	spin_unlock_irqrestore(&dev->ctrl_lock,flags);
	printk("mbim_conn_pool_init, idle_cnt:%u\n", atomic_read(&dev->idle_cnt));
    //ͨ,ֻrx
    
    pbuf =  kzalloc(sizeof(struct mbim_pool_data_s) * MBIM_MAX_POOL_NUM, GFP_KERNEL);
    if(pbuf == NULL)
    {
        printk("[func]:%s,[line]:%d ,alloc mbim_pool_data_s ,no mem \n",__func__,__LINE__) ;
        INIT_LIST_HEAD(&dev->idle_list );
        atomic_set(&dev->idle_cnt,0);
        kfree(dev->pool_mem) ;
         dev->pool_mem = NULL ;
        return -ENOMEM;
    }

	spin_lock_irqsave(&dev->data_lock,flags);	
    struct mbim_pool_data_s*  data_channel_p =  (struct mbim_pool_data_s*) pbuf ;
    for(i = 0 ;i < MBIM_MAX_POOL_NUM;i++)
    {
        data_channel_p->pdata = NULL;
        list_add_tail(&data_channel_p->list, &dev->data_ilde_list) ;
        data_channel_p++ ;
        atomic_inc(&dev->data_idle_cnt);
    }
    dev->data_pool_mem = pbuf ;
	spin_unlock_irqrestore(&dev->data_lock,flags);
	   
    return 0 ;
}

void mbim_conn_pool_deinit(struct f_mbim * dev)
{
	if(dev ==NULL)
	{
		return ;
	}
	printk("\r\n----------mbim_conn_pool_deinit\r\n");
	//ͷskb_buf ;
	//.......
	if(dev->data_pool_mem){
		kfree(dev->data_pool_mem) ;
		dev->data_pool_mem = NULL;
	}
	if(dev->pool_mem){
		kfree(dev->pool_mem) ;
		dev->pool_mem = NULL ;
	}
	atomic_set(&dev->data_tx_cnt,0) ;
	atomic_set(&dev->data_rx_cnt,0) ;
	atomic_set(&dev->data_idle_cnt,0) ;

	atomic_set(&dev->ctrl_tx_cnt,0) ;
	atomic_set(&dev->ctrl_rx_cnt,0) ;
	atomic_set(&dev->idle_cnt,0) ;
    INIT_LIST_HEAD(&dev->idle_list );
    INIT_LIST_HEAD(&dev->ctrl_tx_list );
    INIT_LIST_HEAD(&dev->ctrl_rx_list );
	INIT_LIST_HEAD(&dev->data_ilde_list);
	INIT_LIST_HEAD(&dev->data_rx_list);
}

 static void mbim_conn_channel_cleanup(void)
 {
     //ȥʼڴ
     
     misc_deregister(&mbim_ctrl_device);
     misc_deregister(&mbim_data_device);
     
     g_mbim = NULL;
 }

int mbim_conn_chanel_init(void)
 {
     int ret;
     
     struct f_mbim* mbim = kzalloc(sizeof *mbim, GFP_KERNEL);
	if (!mbim)
	{
        printk("[func]:%s,[line]:%d ,alloc struct mbim ,no mem \n",__func__,__LINE__) ;
        return -ENOMEM;
    }


    //Ӧò㽻ͨ
    atomic_set(&mbim->ctrl_rx_cnt,0) ;
    atomic_set(&mbim->ctrl_tx_cnt,0) ;
    atomic_set(&mbim->idle_cnt ,0);
    spin_lock_init(&mbim->ctrl_lock) ;
    
    INIT_LIST_HEAD(&mbim->ctrl_rx_list)  ;
    INIT_LIST_HEAD(&mbim->ctrl_tx_list)  ;
    //INIT_LIST_HEAD(&mbim->ctrl_idle_list );

    init_waitqueue_head(&mbim->ctrl_read_wq) ;
    init_waitqueue_head(&mbim->ctrl_write_wq) ;
    
    //Ӧòͨ
    atomic_set(&mbim->data_rx_cnt,0) ;
    atomic_set(&mbim->data_tx_cnt,0) ;
	atomic_set(&mbim->data_idle_cnt,0) ;
    spin_lock_init(&mbim->data_lock) ;
    INIT_LIST_HEAD(&mbim->data_rx_list) ; 
    INIT_LIST_HEAD(&mbim->data_ilde_list);

    init_waitqueue_head(&mbim->data_read_wq) ;
    init_waitqueue_head(&mbim->data_write_wq) ;
    spin_lock_init(&mbim->conn_lock );
    INIT_LIST_HEAD(&mbim->idle_list );
	init_waitqueue_head(&mbim->lp_wait);
    atomic_set(&mbim->lb_flag,0);

    atomic_set(&mbim->netlink_path_status ,0);
    atomic_set(&mbim->dss_session_id ,0);
    atomic_set(&mbim->session_id ,0);
	mbim->trans_flag = 0;
		
    //ʼڴ 
#if 0
    ret = mbim_conn_pool_init(mbim) ;
    if(ret)
    {
        printk("[func]:%s,[line]:%d ,init pool failed\n",__func__,__LINE__) ;
        kfree(mbim);
        return -ENOMEM ;
    }
#endif
     g_mbim = mbim;
     ret = misc_register(&mbim_ctrl_device);
     if (ret)
     {
         printk("[func]:%s,[line]:%d ,mbim_ctrl_device failed,return %d\n",__func__,__LINE__ ,ret) ;
         goto err;
     }

     ret = misc_register(&mbim_data_device);
     if(ret)
     {
         printk("[func]:%s,[line]:%d ,mbim_ctrl_device failed,return %d\n",__func__,__LINE__ ,ret) ;
         goto dereg_err;
     }
     return 0;

 dereg_err:
    misc_deregister(&mbim_ctrl_device);
err:
    return ret;
 }





