/*
 * Copyright (c) 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Lennart Augustsson (lennart@augustsson.net) at
 * Carlstedt Research & Technology.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Modified by Synopsys, Inc, 12/12/2007 */


#ifndef _POLL_USB_DESC_H_
#define _POLL_USB_DESC_H_

#include <linux/types.h>	/* __u8 etc */
#include <asm/byteorder.h>	/* le16_to_cpu */


#ifdef __cplusplus
extern "C" {
#endif


/* USBƴ*/
typedef struct  {
	__u8 bRequestType;
	__u8 bRequest;
	__le16 wValue;
	__le16 wIndex;
	__le16 wLength;
} __attribute__ ((packed)) T_CTRL_COMMAND;


// CLEAR_FEATURE, SET_FEATURE
#define FEATURE_DEVICE_REMOTE_WAKEUP		(0x1)
#define FEATURE_ENDPOINT_HALT				(0x0)
#define FEATURE_TEST_MODE					(0x2)


#define VERDOR_SPECIFIC			(0xff)

#define EP0_PACKET_SIZE CONTROL_64
#define EP1_PACKET_SIZE 64
#define EPX_PACKET_SIZE 64

#define EP_FOR_IN 2
#define EP_FOR_OUT 3

// ˵ݰС
typedef enum
{
	CONTROL_8		=8,
	CONTROL_16		=16,
	CONTROL_32		=32,
	CONTROL_64		=64,

	BULK_512		=512,
}T_EP_PKT_SIZE;



/*usb豸߸״̬*/
typedef enum
{
	eUSB_ATTACHED = 0,
	eUSB_POWERED,
	eUSB_DEFAULT,
	eUSB_SUSPEND,
	eUSB_RUSUME,
	eUSB_ADDRESS,    
	eUSB_CONFIG
}E_USB_STATE;



#define EP_ADDRESS_DIRECTION_MASK	        (0x01 <<7)	//Direction, ignored for control endpoints
#define EP_ADDRESS_DIRECTION_IN		 (0x01 <<7)
#define EP_ADDRESS_DIRECTION_OUT	         (0x0   <<7)


//bmAttributes
//#define EP_ATTR_TRANSFER_TYPE_MASK		 (0x03 <<0)
#define EP_ATTR_TRANSFER_TYPE_CONTROL	 (0     <<0)
#define EP_ATTR_TRANSFER_TYPE_ISO		        (1     <<0)
#define EP_ATTR_TRANSFER_TYPE_BULK		 (2     <<0)
#define EP_ATTR_TRANSFER_TYPE_INTERRUPT	 (3     <<0)

//ͬ˵, 1023ֽ, ѯ---2^(bInterval -1)֡
#define MAX_ISO_PKT			(256)	//1023ֽ
#define MAX_ISO_R_INTERVAL	(1)		//ѯ---2^(bInterval -1)֡
#define MAX_ISO_T_INTERVAL	(1)		//ѯ---2^(bInterval -1)֡


/**************************************************************************/

#define UT_GET_TYPE(a) ((a) & 0x60)
#define UT_STANDARD		0x00
#define UT_CLASS		0x20
#define UT_VENDOR		0x40

#define UT_GET_RECIPIENT(a) ((a) & 0x1f)
#define UT_DEVICE		0x00
#define UT_INTERFACE		0x01
#define UT_ENDPOINT		0x02
#define UT_OTHER		0x03
/* Requests */
#define  UR_GET_STATUS		0x00
#define  USTAT_STANDARD_STATUS  0x00
#define  UR_CLEAR_FEATURE	0x01
#define  UR_SET_FEATURE		0x03
#define  UR_SET_ADDRESS		0x05
#define  UR_GET_DESCRIPTOR	0x06
#define UR_SET_CONFIG		0x09
/* Feature numbers */
#define UF_ENDPOINT_HALT	0





#define UE_GET_DIR(a)	((a) & 0x80)
#define UE_SET_DIR(a,d)	((a) | (((d)&1) << 7))
#define UE_DIR_IN	0x80
#define UE_DIR_OUT	0x00
#define UE_ADDR		0x0f
#define UE_GET_ADDR(a)	((a) & UE_ADDR)


#define USB_MAX_STRING_LEN 128

#define UES_HALT			0x0001


#define USB_MIN_POWER		100 /* mA */
#define USB_MAX_POWER		500 /* mA */


#define USB_MAX_DEVNAMES 4
#define USB_MAX_DEVNAMELEN 16
#define USB_SPEED_UNKNOWN	0
#define USB_SPEED_LOW		1
#define USB_SPEED_FULL		2
#define USB_SPEED_HIGH		3
/*
 * USB directions
 *
 * This bit flag is used in endpoint descriptors' bEndpointAddress field.
 * It's also one of three fields in control requests bRequestType.
 */
#define USB_DIR_OUT			0		/* to device */
#define USB_DIR_IN			0x80		/* to host */


// 
typedef enum
{
	DEVICE_DESCRIPTOR   = 0x01,
	CONFIG_DESCRIPTOR   = 0x02,
	STRING_DESCRIPTOR   = 0x03,
	INTERFACE_DESCRIPTOR= 0x04,
	ENDPOINT_DESCRIPTOR = 0x05,
	DEVICE_QUALIFIER_DESCRIPTOR =0x06
} T_DESCRIPTORS_TYPE;


/***************************************************/

// 豸
typedef struct usb_device_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;

	__le16 bcdUSB;
	__u8  bDeviceClass;
	__u8  bDeviceSubClass;
	__u8  bDeviceProtocol;
	__u8  bMaxPacketSize0;
	__le16 idVendor;
	__le16 idProduct;
	__le16 bcdDevice;
	__u8  iManufacturer;
	__u8  iProduct;
	__u8  iSerialNumber;
	__u8  bNumConfigurations;
} __attribute__ ((packed)) poll_device_descriptor_t;




//device qualifier
typedef struct
{
    __u8    bLength;
    __u8    bDescriptorType;
    __le16		bcdUSB;
    __u8    bDeviceClass;
    __u8    bDeviceSubClass;
    __u8    bDeviceProtocol;
    __u8    bMaxPacketSize0;
    __u8    bNumConfigurations;
    __u8    Reserved;
} __attribute__ ((packed)) poll_dev_qual_descriptor_t;


// ׼
typedef struct
{
	__u8 	bLength;
	__u8 	bDescriptorType;
	__le16 	wTotalLength;
	__u8 	bNumInterfaces;
	__u8 	bConfigurationValue;
	__u8 	iConfiguration;
	__u8 	bmAttributes;
	__u8 	bMaxPower;
} __attribute__ ((packed)) poll_config_descriptor_t;

// bmAttributes
#define ATTR_D7							(1 <<7)		// Ϊ1
#define ATTR_SELF_POWERED				(1 <<6)		// Թ
#define ATTR_SUPPORT_REMOTE_WAKEUP	(1 <<5)		// Զ̻

// bMaxPower
#define POWER_MA(power)				(power>>1)		// λ: 2mA



// ׼ӿ
typedef struct 
{
	__u8 	bLength;
	__u8 	bDescriptorType;
	__u8 	bInterfaceNumber;
	__u8 	bAlternateSetting;
	__u8 	bNumEndpoints;
	__u8 	bInterfaceClass;
	__u8 	bInterfaceSubClass;
	__u8 	bInterfaceProtocol;
	__u8 	iInterface;
} __attribute__ ((packed)) poll_interface_descriptor_t;



// ׼˵
typedef struct
{
	__u8 	bLength;
	__u8 	bDescriptorType;
	__u8 	bEndpointAddress;
	__u8 	bmAttributes;
	__le16	wMaxPacketSize;
	__u8 	bInterval;
} __attribute__ ((packed)) poll_ep_descriptor_t;


// ַ
typedef struct
{
	__u8	bLength;
	__u8 	bDescriptorType;
	__le16	wLANGID0;

} __attribute__ ((packed)) poll_langid_descriptor_t;

#define LANGID_US_ENGLISH					(0x0409)


typedef struct
{
	__u8	bLength;
	__u8 	bDescriptorType;
	__u8	bString[32];

} __attribute__ ((packed)) poll_string_descriptor_t;

//T_STRING_DESCRIPTOR, ascii to unicode---*2, length,type--+2
#define STRING_DESCRIPTOR_SIZE(size)    	((size*2)+2)
//תasciiַΪunicodeַ
#define UNICODE(ascii)							ascii,0x00


typedef struct
{
	poll_config_descriptor_t		tConfig;
	poll_interface_descriptor_t	tInterface;
	poll_ep_descriptor_t			atTxEP[1];	//Ͷ˵(ep0)
	poll_ep_descriptor_t			atRxEP[1];	//ն˵(ep0)
	poll_interface_descriptor_t	tInterface1;
	poll_ep_descriptor_t			atTxEP1[1];	//Ͷ˵(ep0)
	poll_ep_descriptor_t			atRxEP1[1];	//ն˵(ep0)
}__attribute__ ((packed)) trap_config_all_t;


extern  const poll_string_descriptor_t * const pollStrDescIdx[];
extern  const poll_dev_qual_descriptor_t  dev_qual_desc;
extern  const trap_config_all_t  poll_config_desc;
extern  const poll_device_descriptor_t  poll_device_desc;

#define MIN(x,y)		  		((x) < (y) ? (x) : (y))


#ifdef __cplusplus
}
#endif

#endif /* _USB_H_ */
