#ifndef _LINUX_USBPROXY_ICP_H
#define _LINUX_USBPROXY_ICP_H

/****************************************************************************
* 	                        Include files
****************************************************************************/
#include <linux/wait.h>
#include <linux/completion.h>
/****************************************************************************
* 	                         Macros
****************************************************************************/

/****************************************************************************
* 	                         Types
****************************************************************************/
typedef enum _T_Usbproxy_Sharemem_Type{
    USBPROXY_TYPE_READ=0,
    USBPROXY_TYPE_WRITE
}Usbproxy_Sharemem_Type;

typedef struct _T_Usbproxy_sharemem_icpmsg{
		void *addr;/*ݴŵĵַ*/
		int len;/*ݳ*/
		int msgtype;/*readwrite*/
		int packet_end;/*һݽ*/
}Usbproxy_sharemem_icpmsg;
	
typedef struct _T_Usbproxy_Sharemem{
//    wait_queue_head_t read_wq;
//    wait_queue_head_t write_wq;
    int read_busy;
    int write_busy;
    void __iomem* mem_read;/*out ep*/
    int len_read;
    struct completion read_done;
    void __iomem*  mem_write;/*in ep*/
    int len_write;
    struct completion write_done;
    
}UsbProxy_Sharemem;

/****************************************************************************
* 	                Function Prototypes                                    *
****************************************************************************/
void *usbproxy_sharemem_get(Usbproxy_Sharemem_Type memtype);

int usbproxy_sharemem_write(void* destbuf, void* srcbuf,  unsigned int len);

int usbproxy_sharemem_read(void* destbuf, void* srcbuf,  unsigned int len);

void usbproxy_sharemem_put(void * buf);

void usbproxy_sharemem_icpmsg_init(void);

void usbproxy_sharemem_init(void);

#define PROXY_DEBUG 1

#if PROXY_DEBUG
#define PROXY_INFO(s...)	printk(KERN_INFO s)
#define PROXY_ERR(s...)  printk(KERN_ERR s)
#else
#define PROXY_INFO(s...)	
#define PROXY_ERR(s...)  printk(KERN_ERR s)
#endif

#endif  /* _LINUX_USBPROXY_ICP_H*/
