#ifndef __LINUX_TOUCHSCREEN_TS_H__ 
#define __LINUX_TOUCHSCREEN_TS_H__ 

#include <linux/input.h> 

/* -- dirver configure -- */ 
#define CFG_MAX_TOUCH_POINTS	2 

#define PRESS_MAX				0xFF 
#define FT_PRESS				0x7F 

#define TOUCHSCREEN_NAME 	       "touchscreen" 
 
/*tp register address*/ 
#define TP_REG_THGROUP			0x80 
#define TP_REG_POINT_RATE		0x88 
#define TP_REG_ID_PMODE		0xA5 
#define TP_REG_FW_VER			0xA6 

#define TP_REG_CHIP_VENDOR_ID   0xA3 
#define TP_REG_CTPM_VENDOR_ID	 0xA8 

struct ts_event { 
	u16 x; 
	u16 y; 
	u8 event; /* 0 -- down; 1-- contact; 2 -- contact */ 
	u8 id; 
	u16 pressure; 
}; 

/* ts_event values */ 
#define FTS_POINT_UP		0x01 
#define FTS_POINT_DOWN		0x00 
#define FTS_POINT_CONTACT	0x02 

enum ts_pwr_mode {
	TP_SLEEP_ON = 0,
	TP_SLEEP_OFF
};

enum touchscreen_type {
 #ifdef CONFIG_TOUCHSCREEN_FT6X06
    TOUCHSCREEN_FT6X06,
#endif
#ifdef CONFIG_TOUCHSCREEN_CST716
    TOUCHSCREEN_CST716,
 #endif
    MAX_TOUCHSCREEN_DEV_TYPE
};

struct ts_data { 
	unsigned int irq; 
	unsigned int x_max; 
	unsigned int y_max; 
	struct i2c_client *client; 
	struct input_dev *input_dev; 
	struct ts_event events[CFG_MAX_TOUCH_POINTS]; 
	int touch_points; 
	enum ts_pwr_mode pmode;
       u8 touch_point_num;
	//const char *name;
};

struct touchscreen_operations 
{
    int (*ts_read_touchdata)(struct ts_data *data) ;
};

struct touchscreen_register {
	int (*ts_id_detect)(struct i2c_client *client);
};

int tp_i2c_read(struct i2c_client *client, char *writebuf, int writelen, char *readbuf,  int readlen);
int tp_i2c_write(struct i2c_client *client, char *writebuf, int writelen);
int tp_read(struct i2c_client *client, u8 regaddr, u8 len, u8 *regvalue);
int tp_write(struct i2c_client *client, u8 regaddr, u8 regvalue) ;

void touchscreen_set_operations(enum touchscreen_type id, struct touchscreen_operations *pt_operations);
void touchscreen_register(enum touchscreen_type id,  struct touchscreen_register *pt_register);

#endif 
