/*********************************************************************
* Ȩ (C)2017, ͨѶɷ޹˾
*
* ļƣ 7520_5x6_keypad.h
* ժҪ ֲͶ
**********************************************************************/
#ifndef _7520_5x6_KEYPAD_H
#define _7520_5x6_KEYPAD_H

#ifdef __CPLUSPLUS
extern "C"
{
#endif

#include <linux/types.h>

/*define keypad register*/
#define KEY_BASE_ADDR	(0x00130000)
#define KEY_VERSION		(0x00)
#define KEY_INTERVAL    (0x04)
#define KEY_DEBOUNCE    (0x08)
#define KEY_INT_EN      (0x0c)
#define KEY_CFG_UPT     (0x10)
#define KEY_INDEX       (0x20)
#define KEY_STATE1      (0x24)
#define KEY_STATE2      (0x28)
#define KEY_STATE3      (0x2C)
#define KEY_REG_TOTAL	(0x30)

/*RMģ鸴λĴ1*/
#define RM_MOD_RST1_REG (0x0013b000+0x078)
/* RMģſؼĴ2 10x06C RM_MOD_CLKEN2   */
//#define RM_MOD_CLKEN2_REG (0x0013b000+0x06C)
/* PMM_REG_13 PIN MUX CONFIG REGISTER 0X34   */
//#define  PIN_MUX_CTRLREG13_REG (0x00143000+0x34)

/* HAL λ */
#define BW24                ((unsigned)0x00ffffff)

/* Ĵλ */

/** ΪĳֶĳֵֶΪ0 (the Field MaKe macro) */
#define HAL_FMK(PER_REG_FIELD, val)                                         \
    (((val) << PER_REG_FIELD##_POS) & PER_REG_FIELD##_MASK)

/** ȡĴĳֶεֵ(the Field EXTract macro) */
#define HAL_FEXT(reg, PER_REG_FIELD)                                        \
    (((reg) & PER_REG_FIELD##_MASK) >> PER_REG_FIELD##_POS)

/** ڼĴĳֶβĳֵֶεֲֵ(the Field INSert macro) */
#define HAL_FINS(reg, PER_REG_FIELD, val)                                   \
    ((reg) = ((reg) & ~PER_REG_FIELD##_MASK)                                \
             | HAL_FMK(PER_REG_FIELD, val))


/* Ĵbitλ */

/** ĳbitλbit */
#define HAL_BIT_SET(reg, bit) ((reg) = ((reg) | (1u << (bit))))

/** ĳbit㣬bit */
#define HAL_BIT_CLR(reg, bit) ((reg) = ((reg) & (~(1u << (bit)))))

/** ȡĳbitֵ (0/1) */
#define HAL_GET_BIT_VAL(reg, bit) (((reg)>> (bit)) & 1u)

/** жĳbitֵǷΪ1 */
#define HAL_IS_BIT_SET(reg, pos) (((reg) & (1u << (pos))) != 0x0u)

/** жĳbitֵǷΪ0 */
#define HAL_IS_BIT_CLR(reg, pos) (((reg) & (1u << (pos))) == 0x0u)

/** ĳbitλдֵval,bit */
#define HAL_BIT_INSR(reg, bit, val)                                       \
    ((reg) = (((reg) & (~(1u << (bit)))) | (((val) & 1u) << (bit))))

/* bit pos 15 RM KEY apb sw reset 0 on,1off*/
#define RM_MODRST1_KEY_SWPRST_POS                                        (0)

/* bit pos 14 RM KEY work sw reset 0 on,1off*/
#define RM_MODRST1_KEY_SWWRST_POS                                        (1)
#if 0
/* bit pos 23 RM KEY apb clock auto gate enable  1 en,0 disable*/
#define RM_MODCLKEN2_KEY_PCLK_AUTOGEN_POS                                        (23)

/* bit pos 22 RM KEY work clock auto gate enable  1 en,0 disable*/
#define RM_MODCLKEN2_KEY_WCLK_AUTOGEN_POS                                        (22)

/* bit pos 21 RM KEY apb clock gate enable  1 en,0 disable*/
#define RM_MODCLKEN2_KEY_PCLKEN_POS                                        (21)

/* bit pos 20 RM KEY apb clock gate enable  1 en,0 disable*/
#define RM_MODCLKEN2_KEY_WCLKEN_POS                                        (20)
#endif


/* PMM_REG_13 PIN MUX CONFIG REGISTER 0X34   */
//#define KEY_PINMUX_CTRL                                            KEY_PINMUX_CTRL
#define KEY_PINMUX_CTRL_POS                                        (0)
#define KEY_PINMUX_CTRL_MASK                                       (BW24 << KEY_PINMUX_CTRL_POS)

/*para*/
#define KEY_SCAN_INTERVAL    540
#define KEY_DEBOUNCE_TIME    4
#define KEY_INTERRUPUT_EN    (0x1)   //just can be 0 or 1 !!

/*keypad matrix define*/
/* under 7520, use 8*9 matrix, row[1]~row[3] & colume[0]~column[2];
   under 7520v2, use 8*9 matrix, row[0]~row[3] & colume[0]~column[3]
   under 7520v3, use 8*9 matrix, row[0]~row[4] & colume[0]~column[5]
*/
#define KPD_TOTAL_COLUMN    9
#define KPD_TOTAL_ROW       8

#define KPD_MAX_COLUMN      6
#define KPD_MAX_ROW         5

#define KPD_START_COLUMN    0
#define KPD_START_ROW       0 // 1

typedef volatile struct
{
    unsigned VERSION;           //0X00
    union                     //0x04
    {
        unsigned Val;
		struct
		{
            unsigned interval : 16; // this register plus a const produce the scan period
			unsigned rsved    : 16;
		}Bit;
	}INTERVAL;

	union                      //0x08
	{
        unsigned Val;
		struct
		{
            unsigned debounce : 8; // debounce time = scan period *debounce;
			unsigned rsved    : 24;
		}Bit;
	}DEBOUNCE;

	union                        //0x0c
	{
        unsigned Val;
		struct
		{
            unsigned int_en   : 1; //keypad interrupt enable;
			unsigned rsved    : 31;
		}Bit;
	}Int_En;

	union                        //0x10
	{
        unsigned Val;
		struct
		{
            unsigned cfg_upt  : 1;//when write 1, the configuration updated;
			unsigned rsved    : 1;
		}Bit;
	}Cfg_Upt;

	unsigned reserved[3];           //0X14--0X1C

	union                         //0x20
	{
        unsigned val;
		struct
		{
            unsigned key1     : 7; //bit0~6: first key detected;
			unsigned rsved0   : 1;
			unsigned key2     : 7; //bit8~14: second key detected;
			unsigned rsved1    : 1;
			unsigned key_count: 7; //bit16~22 number of keys pressed;
			unsigned rsved2    : 9;
		}Bit;
	}Key_Index;

    unsigned keystate[3];   //0x24--0x2c: key state1, key state2

} T_KeyType; //

struct zx29_5x6_keypad_platform_data {
	unsigned int key_map[KPD_MAX_ROW][KPD_MAX_COLUMN];
	unsigned int pin_col_row[KPD_MAX_COLUMN + KPD_MAX_ROW];
};

struct zx29_5x6_kpd {
	struct input_dev *input;
	int irq;
	struct platform_device *pdev;
//	unsigned key_map[KPD_MAX_COLUMN*KPD_MAX_ROW];
};


#ifdef __CPLUSPLUS
}
#endif

#endif

