/*
 * Linux driver for NAND NV Flash Translation Layer
 * Copyright (C) 2013, ZTE Corporation.
 */


#ifndef __MTD_NV_FTL_H__
#define __MTD_NV_FTL_H__

#include <linux/mtd/mtd.h>
#include <linux/mtd/blktrans.h>
#include <linux/mtd/zftl_ecc.h>


/* error define */
#define CAN_NOT_FIND_FREE_BLOCK  5  /* Ҳп飬ZFTLĴС */
#define NAND_READ_WRITE_ERROR    6

/*
 * zftl partition
 */
#define CONFIG_CMD_ZFTL                 1 //zhouqi
#define CONFIG_ZFTL_MAX_PARTITIONS      10
#define CONFIG_ZFLT_HEAD                "zftl" 
#define CONFIG_ZFLT_HEAD_BYTE           4
#define CONFIG_ZFLT_VERSION_THRESHOLD   0x78


/* these info are used in blockRepTable */
#define BLOCK_NIL         0xFFFF    /* ˿ûӳϵ */


/* these info are used in BlockTable */
#define BLOCK_FREE         0x00 
#define BLOCK_USED         0x55 
#define BLOCK_BAD          0xAA 
#define BLOCK_DIRTY        0x11 

typedef struct mtd_info nand_info_t;

struct ZFTLrecord {
    nand_info_t *nand;
	struct mtd_blktrans_dev mbd;    /* mbd */
    unsigned char *blockbuf;        /* 黺 */
    unsigned char *oobbuf;          /* OOB */
    unsigned char *blockTable; 
	unsigned short *blockRepTable; 
    unsigned short *versionTable;   /* ֻڿصʱ */	
    uint32_t erasesize;
    uint32_t writesize;
    unsigned int erasesize_shift;
	unsigned int writesize_shift;
    uint32_t oobsize;
    uint32_t firstBlock;            /* һĿ */
    uint32_t numBlocks;             /* ܵĿ */
	uint32_t lastFreeBlock;
	uint32_t is_writed;
};

struct zftl_oob {
    __u8 head[CONFIG_ZFLT_HEAD_BYTE];           /* zftlͷ */
    __u8 used;
    __u8 version;
	__u16 logicBlockID;    /* ڵƫƿ */
}__attribute__((packed));




struct zftl_packed_tags {
	struct zftl_oob t;
	struct zftl_ecc_other ecc;
};

int zftl_write(struct ZFTLrecord *zftl, uint32_t to, uint32_t len, u_char *buf);
int zftl_read(struct ZFTLrecord *zftl, uint32_t from, uint32_t len, u_char *buffer);

#endif /* __MTD_NFTL_H__ */
