/*
 *  Copyright (C) 2010, Lars-Peter Clausen <lars@metafoo.de>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under  the terms of the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __LINUX_POWER_BQ24165_BATTERY_H__
#define __LINUX_POWER_BQ24165_BATTERY_H__

#include <linux/power_supply.h>
#include <linux/types.h>
#include<mach/gpio-names.h>


/**
 * struct bq24165_platform_data - platform_data for gpio_charger devices
 * @name:		Name for the chargers power_supply device
 * @type:		Type of the charger
 * @gpio:		GPIO which is used to indicate the chargers status
 * @gpio_active_low:	Should be set to 1 if the GPIO is active low otherwise 0
 * @supplied_to:	Array of battery names to which this chargers supplies power
 * @num_supplicants:	Number of entries in the supplied_to array
 */
struct bq24165_platform_data{
	const char *name;
	enum power_supply_type type;
	
	unsigned int max_charger_currentmA;
	unsigned int max_charger_violtagemV;
	int iusb1;
	int iusb2;
	int iusb3;
	int ce1;
	int ce2;
	int pg;
	int chg;
	int gpio_active_low;
	
	char **supplied_to;
	size_t num_supplicants;
	int pg_irq;
};


enum bq24165_chg_current{
	CHG_CURRENT_100 	= 0,	// 000  IUSB3 IUSB2 IUSB1
	CHG_CURRENT_500 	= 1, 	
	CHG_CURRENT_1500,		// 2 010
	CHG_CURRENT_USB_SUSPEND,
	CHG_CURRENT_150,		//
	CHG_CURRENT_900,		// 5 101
	CHG_CURRENT_800,		// 6 - 110
	CHG_CURRENT_HIGH_IMPEDANCE,  // 111 - 7
	MAX_CURRENT_SET       /* 12 */
};


enum bq24165_chg_mode{
	CHG_MODE_NORMAL	= 0,
	CHG_MODE_HALF_CURRENT,	// Сһ
	CHG_MODE_VBAT_4_06,		// VBAT(REG)ٵ 4.06v
	CHG_MODE_SUSPENDED,
	MAX_CHG_MODE
};

#endif
