/*
 * zx29_voice.c  --  ZX29_voice ALSA SoC Audio platform driver
 *
 * Copyright (C) 2018, ZTE Corporation.
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/slab.h>
#include <linux/module.h>

#include <sound/soc.h>
#include <sound/pcm_params.h>
#include "i2s.h"

#ifdef  CONFIG_PREEMPT_RT_FULL
#include <linux/cp_types.h>
#include "drvs_volte.h"
#endif
#include <linux/wakelock.h>
#include <linux/soc/zte/pm/drv_idle.h>

#ifdef  CONFIG_PREEMPT_RT_FULL
typedef enum {
    CODEC_OUTPUT_RECEIVER	 = 0,				/*output path in receiver*/
    CODEC_OUTPUT_SPEAKER,						  /*output path in speaker*/
    CODEC_OUTPUT_HEADSET,						  /*output path in headset*/
    CODEC_OUTPUT_BLUETOOTH, 					/*output path in bluetooth*/
    CODEC_OUTPUT_HSANDSPK,					   /*output path in both headset and speaker*/

    MAX_CODEC_OUTPUT_PATH
} T_ZDrv_CodecOutputPath;

typedef enum {
    CODEC_INPUT_MICPHONE	= 0, 					/*input path in earphone mic*/
    CODEC_INPUT_HEADSET,							   /*input path in headset*/
    CODEC_INPUT_BLUETOOTH,							 /*input path in bluetooth*/
    CODEC_INPUT_HANDSFREE,							 /*input path in mic(handsfree)*/

    MAX_CODEC_INPUT_PATH
} T_ZDrv_CodecInputPath;

typedef enum {
    VOICE_OUTPUT_VOL_LEVEL_0 = 0,
    VOICE_OUTPUT_VOL_LEVEL_1    ,
    VOICE_OUTPUT_VOL_LEVEL_2    ,
    VOICE_OUTPUT_VOL_LEVEL_3    ,
    VOICE_OUTPUT_VOL_LEVEL_4    ,
    VOICE_OUTPUT_VOL_LEVEL_5    ,
    VOICE_OUTPUT_VOL_LEVEL_6    ,
    VOICE_OUTPUT_VOL_LEVEL_7    ,
    VOICE_OUTPUT_VOL_LEVEL_8    ,
    VOICE_OUTPUT_VOL_LEVEL_9    ,
    VOICE_OUTPUT_VOL_LEVEL_10   ,
    VOICE_OUTPUT_VOL_LEVEL_11   ,

    MAX_VOICE_OUTPUT_VOL_LEVEL
} T_ZDrvVoice_OutputVolLevel;

typedef enum {
    VOICE_INPUT_VOL_LEVEL_0 = 0,
    VOICE_INPUT_VOL_LEVEL_1    ,
    VOICE_INPUT_VOL_LEVEL_2    ,
    VOICE_INPUT_VOL_LEVEL_3    ,
    VOICE_INPUT_VOL_LEVEL_4    ,
    VOICE_INPUT_VOL_LEVEL_5    ,

    MAX_VOICE_INPUT_VOL_LEVEL
} T_ZDrvVoice_InputVolLevel;

typedef enum {
    VOICE_SAMPLE_8K    = 0, /* voice sample rate 8K. */
    VOICE_SAMPLE_16K     ,  /* voice sample rate 16K. */

    MAX_VOICE_SAMPLE
} T_ZDrvVoice_Sample;

typedef enum {
    VOICE_MUTE_DISABLE = 0,
    VOICE_MUTE_ENABLE,
    MAX_VOICE_MUTE_SWITCH
} T_ZDrvVoice_mute_Switch;

typedef enum {
    VOICE_UPLINK = 0,
    VOICE_DOWNLINK,
    VOICE_UPLINK_AND_DOWNLINK,
    MAX_VOICE_MUTE_CHANNEL
} T_ZDrvVoice_MuteChannel;

typedef struct {
	T_ZDrvVoice_mute_Switch enable;
	T_ZDrvVoice_MuteChannel channel;    /* input & output function */
} T_ZDrvVoice_MuteInfo;

typedef struct {
	T_ZDrvVoice_Sample         sample;    /* voice sample rate selection. */
	T_ZDrv_CodecInputPath      pathin;    /* Voice input channel selection. */
	T_ZDrv_CodecOutputPath     pathout;   /* Voice output channel selection. */
	T_ZDrvVoice_InputVolLevel  volin;     /* Voice input channel volum level selection.*/
	T_ZDrvVoice_OutputVolLevel volout;    /* Audio output channel volum level selection.*/
	T_ZDrvVoice_MuteInfo       muteInfo;  /* voice mute control information */
} T_HalVoice_Block;

extern int halVoice_Open(void);
extern int halVoice_Close(void);
extern int halVoice_SetPathIn(T_HalVoice_Block* pVoiceBlock);
extern int halVoice_SetPathOut(T_HalVoice_Block* pVoiceBlock);
extern int halVoice_SetVolOut(T_HalVoice_Block* pVoiceBlock);
extern int halVoice_Enable(void);
extern int halVoice_Disable(void);
extern SINT32 halVoice_Open3G(VOID);
extern SINT32 halVoice_Close3G(VOID);

//extern T_DrvVoice_3G_Opt  gDrvVoice_3G_Obj;
#endif

struct zx29_voice {

	struct mutex         mutex;
	struct wake_lock     pm_lock;

};

static struct zx29_voice voice = {0};

static const struct snd_pcm_hardware dma_hardware = {
	.info			= SNDRV_PCM_INFO_INTERLEAVED |
	SNDRV_PCM_INFO_BLOCK_TRANSFER |
	SNDRV_PCM_INFO_MMAP |
	SNDRV_PCM_INFO_MMAP_VALID,
	.formats		= SNDRV_PCM_FMTBIT_S16_LE |
	SNDRV_PCM_FMTBIT_U16_LE |
	SNDRV_PCM_FMTBIT_U8 |
	SNDRV_PCM_FMTBIT_S8,
	.channels_min		= 1,
	.channels_max	= 2,
	.buffer_bytes_max	= 8 * 1024,
	.period_bytes_min	= 160,     //PAGE_SIZE
	.period_bytes_max	= PAGE_SIZE, //PAGE_SIZE * 2
	.periods_min		= 2,
	.periods_max		= 128,
	.fifo_size		    = 32,
};


static int voice_hw_params(struct snd_pcm_substream *substream,
                           struct snd_pcm_hw_params *params)
{
	struct snd_pcm_runtime *runtime = substream->runtime;
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	if (rtd->dai_link->name != NULL && (!strcmp(rtd->dai_link->name, "3g_voice"))) {

		print_audio("Alsa Entered func %s  3g soft amr !\n", __func__);
		return 0;
	}

	return 0;
}

static int voice_hw_free(struct snd_pcm_substream *substream)
{
	int ret = 0;
//	print_audio("Alsa Entered func %s\n", __func__);
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	if (rtd->dai_link->name != NULL && (!strcmp(rtd->dai_link->name, "3g_voice"))) {

		print_audio("Alsa Entered func %s  3g soft amr !\n", __func__);
		return 0;
	}
	return ret;
}

static int voice_prepare(struct snd_pcm_substream *substream)
{
	int ret = 0;
//	print_audio("Alsa Entered func %s\n", __func__);

#ifdef CONFIG_PREEMPT_RT_FULL
	struct snd_soc_pcm_runtime *rtd = substream->private_data;

	if (rtd->dai_link->name != NULL && (!strcmp(rtd->dai_link->name, "3g_voice"))) {

		print_audio("Alsa Entered func %s  3g soft amr !\n", __func__);
		return 0;
	}
	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
		T_ZDrv_CodecOutputPath OutputPath     = CODEC_OUTPUT_RECEIVER;    /*Ͳ*/
		T_ZDrv_CodecInputPath  InputPath      = CODEC_INPUT_MICPHONE;     /**/
		T_ZDrvVoice_OutputVolLevel OutputVal  = VOICE_OUTPUT_VOL_LEVEL_5; /**/
		T_HalVoice_Block ddvoice_block = {
			VOICE_SAMPLE_8K,
			CODEC_INPUT_MICPHONE,
			CODEC_OUTPUT_RECEIVER,
			VOICE_INPUT_VOL_LEVEL_3,
			VOICE_OUTPUT_VOL_LEVEL_3,
			{
				VOICE_MUTE_DISABLE,
				VOICE_UPLINK_AND_DOWNLINK
			}
		};

		ddvoice_block.pathin = InputPath;
		ret = CPPS_FUNC(cpps_callbacks, halVoice_SetPathIn)(&ddvoice_block);
//			print_audio("Alsa halVoice_SetPathIn ret=%d\n", ret);

		if (ret < 0)
			return ret;
		ddvoice_block.pathout = OutputPath;
		ret = CPPS_FUNC(cpps_callbacks, halVoice_SetPathOut)(&ddvoice_block);
//				print_audio("Alsa halVoice_SetPathOut ret=%d\n", ret);

		if (ret < 0)
			return ret;
		ddvoice_block.volout = OutputVal;
		ret = CPPS_FUNC(cpps_callbacks, halVoice_SetVolOut)(&ddvoice_block);
//					print_audio("Alsa halVoice_SetVolOut ret=%d\n", ret);

		if (ret < 0)
			return ret;
		ret = CPPS_FUNC(cpps_callbacks, halVoice_Enable)();
//			print_audio("Alsa halVoice_Enable ret=%d\n", ret);
		if (ret < 0)
			return ret;
	}
#endif

	return ret;
}

static int voice_trigger(struct snd_pcm_substream *substream, int cmd)
{
	int ret = 0;
//	print_audio("Alsa Entered func %s, cmd=%d\n", __func__, cmd);
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: %s start,rtd->dai_link->name=%s,cmd=%d\n", __func__, rtd->dai_link->name,cmd);

	if (rtd->dai_link->name != NULL && (!strcmp(rtd->dai_link->name, "3g_voice"))) {

		print_audio("Alsa Entered func %s  3g soft amr !\n", __func__);
		//return 0;
	}
	switch (cmd) {
	case SNDRV_PCM_TRIGGER_START:
		zx_cpuidle_set_busy(IDLE_FLAG_VOICE);
		wake_lock(&voice.pm_lock);
		break;
	case SNDRV_PCM_TRIGGER_STOP:
		zx_cpuidle_set_free(IDLE_FLAG_VOICE);
		wake_unlock(&voice.pm_lock);
		break;
	default:
		ret = -EINVAL;
		break;
	}
	return ret;
}

static int voice_open(struct snd_pcm_substream *substream)
{
	struct snd_pcm_runtime *runtime = substream->runtime;
//	print_audio("Alsa Entered func %s\n", __func__);
	int ret = 0;
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	snd_soc_set_runtime_hwparams(substream, &dma_hardware);
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: %s start,rtd->dai_link->name=%s\n", __func__, rtd->dai_link->name);

#ifdef CONFIG_PREEMPT_RT_FULL
	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
		if ((rtd->dai_link->name != NULL) && (!strcmp(rtd->dai_link->name, "3g_voice"))) {


			ret = CPPS_FUNC(cpps_callbacks, halVoice_Open3G)();
			print_audio("Alsa Entered func %s  3g soft amr  ret=%d!\n", __func__, ret);
		    CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa Entered func %s  3g soft amr  ret=%d!\n", __func__, ret);
		

		} else {
			ret = CPPS_FUNC(cpps_callbacks, halVoice_Open)();
			print_audio("Alsa Entered func %s  2/3G teaklit  ret=%d!\n", __func__, ret);
		    CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa Entered func %s  2/3G teaklit  ret=%d!\n", __func__, ret);

		}
	}
#endif
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: %s end,rtd->dai_link->name=%s\n", __func__, rtd->dai_link->name);

	return ret;
}

static int voice_close(struct snd_pcm_substream *substream)
{
	struct snd_pcm_runtime *runtime = substream->runtime;
//	print_audio("Alsa Entered func %s\n", __func__);
	int ret = 0;
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: %s start,rtd->dai_link->name=%s\n", __func__, rtd->dai_link->name);

	//dump_stack();	
	WARN_ON(1);
#ifdef CONFIG_PREEMPT_RT_FULL
	if (substream->stream == SNDRV_PCM_STREAM_PLAYBACK) {
		if ((rtd->dai_link->name != NULL) && (!strcmp(rtd->dai_link->name, "3g_voice"))) {
			ret = CPPS_FUNC(cpps_callbacks, halVoice_Close3G)();
			print_audio("Alsa Entered func %s  3g soft amr  ret=%d!\n", __func__, ret);
			CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa Entered func %s  3g soft amr  ret=%d!\n", __func__, ret);

		} else {

			ret = CPPS_FUNC(cpps_callbacks, halVoice_Disable)();
			if (ret < 0){
				print_audio("Alsa Entered func %s  2/3G teakl disable err ret=%d\n", __func__, ret);
				
		   		CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa Entered func %s  2/3G teakl disable err ret=%d\n", __func__, ret);
			}
			ret += CPPS_FUNC(cpps_callbacks, halVoice_Close)();
			
		    CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa Entered func %s  2/3G teaklit close end ret=%d!\n", __func__, ret);
		}


	}
#endif
	CPPS_FUNC(cpps_callbacks, zDrv_Audio_Printf)("Alsa: %s end,rtd->dai_link->name=%s\n", __func__, rtd->dai_link->name);

	return ret;
}


static struct snd_pcm_ops voice_ops = {
	.open		= voice_open,
	.close		= voice_close,
	.ioctl		= snd_pcm_lib_ioctl,
//	.hw_params	= voice_hw_params,
//	.hw_free	= voice_hw_free,
	.prepare	= voice_prepare,
//	.trigger	= voice_trigger,
};


static struct snd_soc_platform_driver voice_asoc_platform = {
	.ops		= &voice_ops,
};

static int __devinit voice_asoc_platform_probe(struct platform_device *pdev)
{
//	print_audio("Alsa voice_asoc_platform_probe start\n");
	mutex_init(&voice.mutex);
	wake_lock_init(&voice.pm_lock, WAKE_LOCK_SUSPEND, "zx29-voice");

	return snd_soc_register_platform(&pdev->dev, &voice_asoc_platform);
}

static int __devexit voice_asoc_platform_remove(struct platform_device *pdev)
{
	snd_soc_unregister_platform(&pdev->dev);
//	print_audio("Alsa voice_asoc_platform_remove end\n");

	return 0;
}

static struct platform_driver asoc_voice_driver = {
	.driver = {
		.name = "voice_audio",
		.owner = THIS_MODULE,
	},

	.probe = voice_asoc_platform_probe,
	.remove = __devexit_p(voice_asoc_platform_remove),
};

module_platform_driver(asoc_voice_driver);

MODULE_DESCRIPTION("voice ASoC audio Driver");
MODULE_LICENSE("GPL");
MODULE_ALIAS("platform:voice-audio");
