/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:   drvs_rtt.h 
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       1.0
 * Author:        wangxia
 * Date:          2010-4-29
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_RTT_H
#define _DRVS_RTT_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "os_ose.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define RTT_INT_LEVEL_USER_0       0x5
#define RTT_INT_LEVEL_USER_1       0x5
#define RTT_INT_LEVEL_USER_2       0x5
#define RTT_INT_LEVEL_USER_3       0x5
#define RTT_INT_LEVEL_USER_4       0x5
#define RTT_INT_LEVEL_USER_COMMON  0x7

/*The RTT Clock resolution on creation. RTT Clock is available only for predefined users.
	   The resolution can be modified at runtime using RTT_set_clock_resolution
 */
#define RTT_DEFAULT_CLOCK_RESOLUTION rtt_clock_100_microseconds

/****************************************************************************
* 	                                        Types
****************************************************************************/
	typedef enum				 
	{
	  rtt_uicc, 				 /*   Reserved timer : GPT0T1 */
	  rtt_free1,				 /*   Reserved timer : GPT0T0 */
	  rtt_meas, 				 /*   Reserved timer : GPT1T0 */
	  rtt_mmci, 				 /*   Reserved timer : GPT1T1 */
	  rtt_free2,				 /*   Reserved timer : GPT1T2 */
	  rtt_common = 5,			 /*   Reserved timer : GPT0T2 */
	  rtt_with_clock = 15,		 /* !!! use MSB special exception for turning of powersave !!!*/
	  rtt_max_nof_timers = 40
	} rtt_timer_user_id_enum;
	
	typedef enum
	{
	  rtt_one_shot,
	  rtt_repetitive,
	  rtt_one_shot_timer_with_clock,
	  rtt_repetitive_timer_with_clock
	} rtt_timer_mode_enum;
	
	typedef enum
	{
		rtt_clock_1_microsecond,
		rtt_clock_10_microseconds,
		rtt_clock_100_microseconds,
		rtt_clock_5_milliseconds,
		rtt_clock_10_milliseconds,
		rtt_clock_100_milliseconds
	}rtt_clock_resolution_type;
	
	/*---------------------------------------------*/
	/* Typedefinition  .						   */
	/*---------------------------------------------*/
	typedef struct
	{
	  VOID (*timeout_func)(VOID );		 /* Callback function on timeout */
	  VOID *arg;						 /* Argument list to the above callback function */
	  rtt_timer_user_id_enum user_id;
	  rtt_timer_mode_enum timer_mode;
	  UINT32 created;
	  UINT32 started;
	  UINT32 duration;
	  UINT32 restart_duration;
	  UINT32 hw_timer_id;
	  UINT32 process_id;
	} rtt_timer_list_type;
	/* end of UICC_Driver_2007_11_2_dcm */
	
	typedef struct
	{
		unsigned int creation_time[2];			  //64 bit creation timestamp
		unsigned int scaled_creation_time;		  //scaled to current resolution
		unsigned long		 resolution;
	}rtt_clock_data_type;


/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

/*******************************************************************************
 * Function: RTT_create_timer
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
extern rtt_timer_list_type *RTT_create_timer(VOID (*timeout_func)(VOID ), 
										 VOID *arg, 
										 rtt_timer_user_id_enum user_id, 
											   rtt_timer_mode_enum timer_mode);

/*******************************************************************************
 * Function: RTT_remove_timer
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
extern SINT32 RTT_remove_timer(rtt_timer_list_type *timer);
	

/*******************************************************************************
 * Function: RTT_start_timer
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
extern SINT32 RTT_start_timer(rtt_timer_list_type *timer, UINT32 duration);
	

/*******************************************************************************
 * Function: RTT_stop_timer
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
extern SINT32 RTT_stop_timer(volatile rtt_timer_list_type * volatile timer);
#endif/*_DRVS_RTT_H*/

