#ifndef _CORE_ARM1
//#include "zctrm_common.h"
//#include "zctrm_ext.h"
#include "drvs_voiceprocess.h"
#include "drvs_assert.h"      		/*  for driver assert function  */
#include "drvs_general.h"
#if 0
#ifdef _CONFIG_USE_CODEC

extern SINT32 halAudioConfig_ReadReg(UINT8 regPage, UINT8 regAddress, UINT8 *regValue);
extern SINT32 halAudioConfig_WriteReg(UINT8 regPage,UINT8 regAddress, UINT8 regValue, UINT8 regMask);
extern SINT32 halAudioConfig_DumpReg(VOID);

static SINT32 zCtrm_ExtAT_WRCODEC(UINT8 chID, const UINT8 *buff, UINT16 len, T_zAti2_CtrmChInd chInd)
{
    UINT32 ret = DRV_SUCCESS;
    UINT8 pPtr[40] = {0};
    CHAR *pStrAt = NULL;
    CHAR *pStrValue	= NULL;
    CHAR a[6]= {0};
    CHAR b[6]= {0};
    CHAR c[6]= {0};
    CHAR d[6]= {0};

    UINT16 reg_page = 0;
    UINT16 reg_index = 0;
    UINT16 write_value = 0;
    UINT16 write_mask = 0;

    pStrAt = (CHAR *)zctrm_strcasestr((const char *)buff, "AT+WRCODEC=");
    //zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"zCtrm_ExtAT_WRCODEC buff=%s, pStrAt=%s\r",buff,pStrAt);
    if(pStrAt != 0)
    {
        pStrValue = pStrAt + strlen("AT+WRCODEC=");

        ret = sscanf(pStrValue, "%[0-9],%[0-9],%[0-9],%[0-9]", a, b, c, d);
        reg_page = atoi(a);
        reg_index = atoi(b);
        write_value = atoi(c);
        write_mask = atoi(d);
        zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"zCtrm_ExtAT_WRCODEC %d,%d,%d,%d", reg_page,reg_index,write_value,write_mask);

        if(ret == 4)
        {
            ret = halAudioConfig_WriteReg(reg_page, reg_index, write_value, write_mask);
            if (ret != DRV_SUCCESS)
            {
                zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"zCtrm_ExtAT_WRCODEC zDrvCodecWrite err ret=%d\r",ret);
                sprintf((char *)pPtr,"\r\n%s\r\n","+CME ERROR: 6004");
                zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
                return -1;
            }

        }
        else
        {
            sprintf((char *)pPtr,"\r\n%s\r\n","+CME ERROR: 6004");
            zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
            return -1;
        }
        strcat((char *)pPtr,"\r\nOK\r\n");
        zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
        return -1;
    }
	
    return 0;
	
}

static SINT32 zCtrm_ExtAT_RDCODEC(UINT8 chID, const UINT8 *buff, UINT16 len, T_zAti2_CtrmChInd chInd)
{
    UINT32 ret = DRV_SUCCESS;
    UINT8 pPtr[40] = {0};
    CHAR *pStrAt = NULL;
    CHAR *pStrValue = NULL;
    CHAR a[6]= {0};
    CHAR b[6]= {0};
    UINT16 reg_page = 0;
    UINT16 reg_index = 0;
    UINT16 read_value = 0;
    pStrAt = (CHAR *)zctrm_strcasestr((const char *)buff, "AT+RDCODEC=");
    //  zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"zCtrm_ExtAT_RDCODEC buff=%s, pStrAt=%s\r",buff,pStrAt);

    if(pStrAt != 0)
    {
        pStrValue = pStrAt + strlen("AT+RDCODEC=");
        ret = sscanf(pStrValue, "%[0-9],%[0-9]", a, b);
        reg_page = atoi(a);
        reg_index = atoi(b);
        //  zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"zCtrm_ExtAT_RDCODEC %d,%d", reg_page, reg_index);

        if(ret == 2)
        {
            ret = halAudioConfig_ReadReg(reg_page, reg_index, &read_value);
            if (ret != DRV_SUCCESS)
            {
                zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"zCtrm_ExtAT_RDCODEC zDrvCodecRead err ret=%d\r",ret);
                sprintf((char *)pPtr,"\r\n%s\r\n","+CME ERROR: 6004");
                zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
                return -1;
            }

            //  zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zCtrm_ExtAT_RDCODEC page %d reg %d = (0x%x)", reg_page, reg_index ,read_value);
        }
        else
        {
            sprintf((char *)pPtr,"\r\n%s\r\n","+CME ERROR: 6004");
            zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
            return -1;
        }
		
        strcat((char *)pPtr,"\r\nOK\r\n");
        zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
		
        return -1;
		
    }

    return 0;
}

static SINT32 zCtrm_ExtAT_DUMPCODECREG(UINT8 chID, const UINT8 *buff, UINT16 len, T_zAti2_CtrmChInd chInd)
{
    UINT32 ret = DRV_SUCCESS;
    UINT8 pPtr[40] = {0};
    CHAR *pStrAt = NULL;
    CHAR *pStrValue = NULL;

    pStrAt = (CHAR *)zctrm_strcasestr((const char *)buff, "AT+DUMPCODECREG=");
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zCtrm_ExtAT_DUMPCODECREG buff=%s, pStrAt=%s\r",buff,pStrAt);
    if(pStrAt != 0)
    {
        pStrValue = pStrAt + strlen("AT+DUMPCODECREG=");

        if(((*(pStrValue ) == '1') && *(pStrValue + 1) == '\r'))
        {
            ret = halAudioConfig_DumpReg();
            if (ret != DRV_SUCCESS)
            {
                zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zCtrm_ExtAT_DUMPCODECREG zDrvCodecDumpReg err ret=%d\r",ret);
                sprintf((char *)pPtr,"\r\n%s\r\n","+CME ERROR: 6004");
                zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
                return -1;
            }
        }
        else
        {
            sprintf((char *)pPtr,"\r\n%s\r\n","+CME ERROR: 6004");
            zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
            return -1;
        }
        strcat((char *)pPtr,"\r\nOK\r\n");
        zCtrm_PsCallbackEntry(chID, pPtr, strlen((const char *)pPtr), chInd);
        return -1;
    }

    return 0;
}

#endif
#endif

VOID zCtrm_InitAudioAt(VOID)
{
#if 0
#ifdef _CONFIG_USE_CODEC
    zCtrm_ExtRegisterAT((UINT8 *)"AT+WRCODEC=", strlen("AT+WRCODEC="), zCtrm_ExtAT_WRCODEC);
    zCtrm_ExtRegisterAT((UINT8 *)"AT+RDCODEC=", strlen("AT+RDCODEC="), zCtrm_ExtAT_RDCODEC);
    zCtrm_ExtRegisterAT((UINT8 *)"AT+DUMPCODECREG=", strlen("AT+DUMPCODECREG="), zCtrm_ExtAT_DUMPCODECREG);
#endif
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "[AT]zCtrm_InitAudioAt\n");
#endif
}

#endif

