/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       1.0
 * Author:        LvWenhua
 * Date:          2008-5-12
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
//#include "drv_pub.h"
#include "drvs_general.h"
#include "earpiece_api.h"
#include "hal_earpiece.h"


/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
T_HalEarp_Opt*  gHalEarp_ObjPtr = NULL;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function: halEarp_Init
 * Description: This function is used to init earpiece device
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: 0:success
 *              -1:fail
 *
 * Others: 
 ********************************************************************************/
SINT32 halEarp_Open(VOID)
{
    if ((NULL != gHalEarp_ObjPtr) && (NULL != gHalEarp_ObjPtr->hal_earp_Open))
        return gHalEarp_ObjPtr->hal_earp_Open();
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halEarp_Exit
 * Description: This function is used to exit earpiece device
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: 0:success
 *              -1:fail
 *
 * Others: 
 ********************************************************************************/
SINT32 halEarp_Close(VOID)
{
    if ((NULL != gHalEarp_ObjPtr) && (NULL != gHalEarp_ObjPtr->hal_earp_Close))
        return gHalEarp_ObjPtr->hal_earp_Close();
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halEarp_Exit
 * Description: This function is used to exit earpiece device
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: 0:success
 *              -1:fail
 *
 * Others: 
 ********************************************************************************/
SINT32 halEarp_GetPlugStatus(T_ZDrvEarp_State* plug_status)
{
    if ((NULL != gHalEarp_ObjPtr) && (NULL != gHalEarp_ObjPtr->hal_earp_get_plug_status))
        return gHalEarp_ObjPtr->hal_earp_get_plug_status(plug_status);
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}
/*******************************************************************************
* Function: halEarp_SetCallbackFunc
* Description: This function is used to set the callback function.
* Parameters: 
*   Input:
*           callbackFunc: the pointer to the callback function
*   Output:None
*
* Returns: None
*
* Others: 
********************************************************************************/
SINT32 halEarp_SetCallbackFunc(T_ZDrvEarp_CallbackFunc callbackFunc)
{
    if ((NULL != gHalEarp_ObjPtr) && (NULL != gHalEarp_ObjPtr->hal_earp_set_callback_func))
        return gHalEarp_ObjPtr->hal_earp_set_callback_func(callbackFunc);
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }

}

SINT32 halEarp_SetHookEnable(VOID)
{
    if ((NULL != gHalEarp_ObjPtr) && (NULL != gHalEarp_ObjPtr->hal_earp_set_hook_enable))
        return gHalEarp_ObjPtr->hal_earp_set_hook_enable();
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

SINT32 halEarp_SetHookDisable(VOID)
{
    if ((NULL != gHalEarp_ObjPtr) && (NULL != gHalEarp_ObjPtr->hal_earp_set_hook_disable))
        return gHalEarp_ObjPtr->hal_earp_set_hook_disable();
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: zDrvEarp_SetOperations
 * Description: This function is used to set the earpiece instance of hal layer.
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: The pointer to earpiece function block of hal layer
 *
 * Others: 
 ********************************************************************************/
VOID zDrvEarp_SetOperations(T_HalEarp_Opt* EarpObjPtr)
{
	gHalEarp_ObjPtr = EarpObjPtr;
}




