/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Contains definitions of audio data parameters
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_data.h
 *   Version: \main\78
 *   Date: 2007-09-18 09:14:42
 *   Responsible: johansek
 *   Comment:
 *     Merged EEP cleanup.
 */
#if !defined (_AUD_DATA)
#define _AUD_DATA

#include "drvs_teak.h"
/*******************************************************************************
*
*                    Defines for hardware dependency list
*
*******************************************************************************/
/* control RX part of AFE */
#define AUD_HW_DEP_DAC1_EPP1EPN1             0x00000001 /* Bit 0 - RX S10 */
#define AUD_HW_DEP_DAC1_EPPA1                0x00000002 /* Bit 1 - RX S11 */
#define AUD_HW_DEP_LNA3_EPP1EPN1             0x00000004 /* Bit 2 - RX S5 */
#define AUD_HW_DEP_LNA3_EPPA1                0x00000008 /* Bit 3 - RX S7 */
#define AUD_HW_DEP_DAC2_EPPA2                0x00000010 /* Bit 4 - RX S12 */
#define AUD_HW_DEP_DAC2_EPPA1                0x00000020 /* Bit 5 - RX S6 */
#define AUD_HW_DEP_LNA4_EPPA2                0x00000040 /* Bit 6 - RX S8 */
#define AUD_HW_DEP_OUTPUT_BOOST              0x00000080 /* Bit 7 - 18 dB extra gain in EPp1/n1 and EPpa1/pa2 (maingain) */
#define AUD_HW_DEP_AFE_OUTPUT_STEREO         0x00000100 /* Bit 8 - OUT_MODE parameter of VB_ON */
/* controls Switch parameter to VB_ON in firmware */
#define AUD_HW_DEP_SG_AFE                    0x00000200 /* Bit 9  - AFE on/off */
#define AUD_HW_DEP_SG_I2S1                   0x00000400 /* Bit 10 - I2S1 on/off */
/* control TX part of AFE - choose at most one left and at most one right */
#define AUD_HW_DEP_AUX_MONO_TO_LEFT          0x00001000 /* Bit 12 - AUX1+2 mono */
#define AUD_HW_DEP_AUX_STEREO_TO_LEFT        0x00002000 /* Bit 13 */
#define AUD_HW_DEP_MIC1_TO_LEFT              0x00004000 /* Bit 14 */
#define AUD_HW_DEP_AUX_STEREO_TO_RIGHT       0x00008000 /* Bit 15 */
#define AUD_HW_DEP_MIC2_TO_RIGHT             0x00010000 /* Bit 16 */
#define AUD_HW_DEP_INPUT_BOOST               0x00020000 /* Bit 17 - 18 dB extra (digital) gain in LNA1 and LNA2 */
/* control AUX external analog inputs */
#define AUD_HW_DEP_AUX_STEREO1_SINGLE_ENDED  0x00100000 /* Bit 20 - AUX1P=left, AUX2P=right - single-ended stereo */
#define AUD_HW_DEP_AUX_STEREO2_SINGLE_ENDED  0x00200000 /* Bit 21 - AUX1N=left, AUX2N=right - single-ended stereo */
#define AUD_HW_DEP_AUX_STEREO_DIFFERENTIAL   0x00400000 /* Bit 22 - AUX1P+N=left_mono, AUX2P+N=right_mono - differential stereo */
#define AUD_HW_DEP_AUX_STEREO_TO_MONO        0x00800000 /* Bit 23 - RX Stereo to mono_minus_6db */

/* Bluetooth inband on/off */
#define AUD_HW_DEP_SG_I2S1_INBAND_AFE_ON     0x08000000 /*Bit 27 - I2S1 inband on/off - AFE on */

/********############################################################################**********/
/*[Begin]add for controlling afeiis. [lvwenhua-2010/11/4]*/
#define AUD_HW_DEP_SG_AFEIIS_UL                    0x10000000 /* Bit 28  - AFEIIS uplink on/off */
#define AUD_HW_DEP_SG_AFEIIS_DL                    0x20000000 /* Bit 29  - AFEIIS downlink on/off */
/*[End] [lvwenhua-2010/11/4]*/
/********############################################################################**********/
/* Following defines are used for MA3 and changed to bits */
#define AUD_MA_HW_DEP_DP0_DP2                0x01
#define AUD_MA_HW_DEP_DP3                    0x02
#define AUD_MA_HW_DEP_AP0_AP3                0x04
#define AUD_MA_HW_DEP_AP4R                   0x08
#define AUD_MA_HW_DEP_AP4L                   0x10
#define AUD_MA_HW_DEP_AP1                    0x20
#define AUD_MA_HW_DEP_AP2                    0x40
#define AUD_HW_DEP_STEREO_HEADSET_AMP_CTRL   0x00080000 /* Little special WHY IS EXT HW STARTED IN MA3 */
#define AUD_MA_HW_DEP_BASIC_MASK    (AUD_MA_HW_DEP_DP0_DP2 | AUD_MA_HW_DEP_DP3)
#define AUD_MA_HW_DEP_ANALOG_MASK   (AUD_MA_HW_DEP_AP0_AP3 | AUD_MA_HW_DEP_AP4R | AUD_MA_HW_DEP_AP4L | AUD_MA_HW_DEP_AP1 | AUD_MA_HW_DEP_AP2)

/*** Defines for control of VB_ON ratesw parameter ***/
#define AUD_SAMPLE_RATE_8KHZ_MONO            0x01 /* Bit 1 - 8 kHz mono */
#define AUD_SAMPLE_RATE_16KHZ_MONO           0x02 /* Bit 2 - 16 kHz mono */
#define AUD_SAMPLE_RATE_48KHZ_STEREO         0x04 /* Bit 3 - 48 kHz stereo */

/*[Begin] no use[lvwenhua-2012/4/11]*/
#if 0
/*******************************************************************************
*
*                 Defines for action functions for path control
*
*******************************************************************************/
#if defined (AUD_DEF_ACTION)
#undef AUD_DEF_ACTION
#endif
/* maps the order of AUD_DEF_ACTIONs into an enumeration */
#define AUD_DEF_ACTION(_actionid) _actionid##_BN,
typedef enum aud_action_bit_tag {
#include "aud_action_defs.h"
    AUD_LAST_ACTION_BN
} aud_action_bit_enum;

#if (AUD_LAST_ACTION_BN > 32)
#error "Too many audio actions."
#endif

#undef AUD_DEF_ACTION
/* action bits - one bit for each AUD_DEF_ACTION in aud_action_defs.h - used by aud_path_configure_audio_path */
#define AUD_DEF_ACTION(_actionid) _actionid = (1<<_actionid##_BN),
typedef enum aud_action_bitmask_tag {
#include "aud_action_defs.h"
} aud_action_bitmask_enum;

/* action function defined in aud_data.c, e.g. AUD_HEADSET_AMP_FUNC(U32 ACTION_PARAM) */
typedef void (*aud_action_function)(U32);

/* associates an action bitmask value with an action function */
typedef struct aud_action_definition_tag {
    U32                 bitmask;   /* value in aud_action_bitmask_enum - each bit means a particular action */
    aud_action_function action;    /* the aud_action_function associated with this bit */
} aud_action_definition_type;

/* which actions should be taken in a particular exception, e.g. power-on FM radio */
typedef struct aud_action_table_entry_tag {
    U32                  param;    /* power on/off or user defined parameter to the action function */
    aud_action_bit_enum  action;   /* defines which action function to call with this parameter */
} aud_exception_action_table_type;

/* for which state transitions should exception functionality be executed */
typedef struct aud_exception_entry_tag {
    U32                              current_state; /* the current state */
    U32                              new_state;     /* the state after the transition */
    aud_exception_action_table_type *p_table;       /* the exception that should be executed in this transition */
} aud_exception_type;

/* the action function associated with each action definition */
extern const aud_action_definition_type      aud_actions[];
/* state transitions that should be handled differently compared to the order defined in aud_action_defs.h */
extern const aud_exception_type              aud_exception_table[];
#endif
/*[End] [lvwenhua-2012/4/11]*/

/*******************************************************************************
*
*                              Type definitions
*
*******************************************************************************/
typedef struct {
    U16 scal_mic;
    U16 scal_mic_use;
    U16 lambda0;
    U16 lambda0_use;
    U16 gamma0;
    U16 gamma0_use;
    U16 scal_afe;       /* Used from ES2 */
    U16 scal_afe_use;   /* Used from ES2 */
    U16 scal_mic2;      /* Used from ES2 */
    U16 scal_mic2_use;  /* Used from ES2 */
    U16 afe_tone;       /* Used from ES2 */  
    U16 afe_tone_use;   /* Used from ES2 */
    U16 mix_pcmrec;     /* media to uplink */
} aud_uplink_gain_cells_type;

typedef struct {
    U16 gain_out;
    U16 gain_out_use;
    U16 kappa0;
    U16 kappa0_use;
    U16 mix_afe;     /* media to downlink */
    U16 mix_afe_use; /* media to downlink */
} aud_downlink_gain_cells_type;

typedef struct {
    S16 hf_algorithm_init;
    S16 hf_algorithm_restart;
    U16 step_width;
    U16 lms_length;
    U16 lms_offset;
    U16 block_length;
    S16 rxtx_relation;
    U16 add_atten;
    U16 min_atten;
    U16 max_atten;
    U16 nr_sw_2;
    U16 nr_u_fak_0;
    U16 nr_u_fak;
} aud_hf_type;

typedef struct {
    U16 h[65];	/* coefficients */
} aud_fir_filter_type;

typedef struct {
    S16 attennuation_dbfs;  /* [-1, -900] * 0.1 dB          */
    U16 attack_time;        /* [1, 10000] * 0.1 ms          */
    U16 release_time;       /* [1, 10000] * 0.1 ms          */
    U16 mode;               /* 0 (energy limiter), 1 (gain) */
    U16 ul_speech_gain;     /* 0 (0 dB), 1 (18 dB)          */
} aud_asp_ul_type; /* acoustic shock protection in the uplink path */

typedef struct {
    U16 nr_sw_2;
    U16 nr_u_fak_0;
    U16 nr_u_fak;
} aud_dl_nr_type; /* noise reduction in the downlink path */

#define AUD_UPDOWNLINK_PATH_NAME_LENGTH 22 /* names should not be too long (for PhoneTool reasons) */
typedef struct {
    char name[AUD_UPDOWNLINK_PATH_NAME_LENGTH];
    aud_uplink_gain_cells_type*   p_uplink_gain_cells;
    T_DSP_CMD_VB_SET_BIQUAD_PAR*  p_filter_8kHz;  /* Uplink biquad parameters */
    T_DSP_CMD_VB_SET_BIQUAD_PAR*  p_filter_16kHz; /* Uplink biquad parameters */
    T_DSP_CMD_VB_SET_BIQUAD_PAR*  p_filter_48kHz; /* Uplink biquad parameters */
    aud_fir_filter_type*		  p_fir_filter_ul;
    aud_hf_type*                  p_hf;
    aud_asp_ul_type*              p_asp_ul;       /* Acoustic shock protection */
    U16                           mic_gain;
    U16                           mic_gain_use;
    U16                           tx_dither;
    U16                           tx_dither_use;
    unsigned long                 afe_dsp_blocks;
    unsigned long                 ext_hw_blocks;
    U8                            required_sample_rate; /* does this path require a particular sample rate (and which)? */
    U8                            allowed_sample_rates; /* in which sample rates is the path allowed to be added */
} aud_uplink_parms_type;

typedef struct {
    char name[AUD_UPDOWNLINK_PATH_NAME_LENGTH];
    aud_downlink_gain_cells_type* p_downlink_gain_cells;
    T_DSP_CMD_VB_SET_BIQUAD_PAR*  p_filter_8kHz;
    T_DSP_CMD_VB_SET_BIQUAD_PAR*  p_filter_16kHz;
    T_DSP_CMD_VB_SET_BIQUAD_PAR*  p_cbuf_filter;
    aud_fir_filter_type*		  p_fir_filter_dl;
    aud_fir_filter_type*		  p_fir_filter_cbuf;
    aud_dl_nr_type*               p_dl_nr; /* downlink noise reduction */
    U16                           side_tone_fact;
    U16                           side_tone_fact_use;
    U16                           sm_pwer_gain;
    U16                           sm_pwer_gain_use;
    unsigned long                 afe_dsp_blocks;
    unsigned long                 ext_hw_blocks;
    unsigned long                 ma_hw_blocks;
    U8                            allowed_sample_rates; /* at which sample rates is the path allowed to be added */
} aud_downlink_parms_type;
#undef AUD_UPDOWNLINK_PATH_NAME_LENGTH

extern U32 aud_Parallel_Uplink_Paths[];
extern U32 aud_Parallel_Downlink_Paths[];

typedef struct {
    /* constant data, non-constant pointers (should however only be modified by aud_resize_AUD_setting) */
    aud_uplink_parms_type   *p_aud_audio_uplink_parms[aud_uplink_source_end + 1];     /* +1 is to make room for aud_uplink_source_end */
    aud_downlink_parms_type *p_aud_audio_downlink_parms[aud_downlink_source_end + 1]; /* +1 is to make room for aud_downlink_source_end */
} aud_setting_type;

typedef struct {
    U32 audio_hw;
} aud_hw_parms_type;

extern const U16 aud_number_of_i2s1_modes;

/* Structure containing the I2S1 configuration */
typedef struct {
    U16 I2S_mode_enum;
    U16 csel;
    U16 den0;
    U16 den1;
    U16 num0;
    U16 num1;
    U16 rxconf;
    U16 txconf;
    U16 hwmode;
    U16 channel_mode;
} aud_i2s1_configuration_type;

/*[Begin] [lvwenhua-2010/11/9]*/
extern const U16 aud_number_of_afei2s_modes;

/* Structure containing the AFEI2S configuration */
typedef struct {
    U16 I2S_mode_enum;
    U16 csel;
    U16 den0;
    U16 den1;
    U16 num0;
    U16 num1;
    U16 rxconf;
    U16 txconf;
    U16 hwmode;
    U16 channel_mode;
    aud_I2S_samplerate_enum sample;
} aud_afei2s_configuration_type;

/*[End] [lvwenhua-2010/11/9]*/
#if defined (aud_old_I2S_interface)
extern const U16 aud_number_of_temp_i2s2_modes;

/* Structure containing the I2S2 configuration */
typedef struct {
    aud_I2Sx_mode_enum              Enum;
    aud_I2S_Master_Slave_enum       Master_Slave;
    aud_I2S_samplerate_enum         samplerate;
    aud_I2S_sample_width_enum       sample_width;
    aud_I2S_transmission_mode_emum  transmission_mode;
    aud_I2S_setting_enum            settings;
    aud_I2S_mode_enum               I2S_mode;
    aud_I2S_entry_point_enum        entry_point;
    aud_I2S_clk_enum                clock;
} aud_i2s2_temp_configuration_type;

#endif /* aud_old_I2S_interface */

/* Structure for gain cells that are not controlled by paths/resources and/or should only be muted/unmuted */
typedef struct {
    U16 alpha0;        /* unmute value for uplink to Voice Memo */
    U16 alpha1;        /* unmute value for downlink to Voice Memo */
    U16 beta0;         /* fixed gain value when TTY is enabled */
    U16 gamma1;        /* unmute value for Voice Memo to uplink */
    U16 delta0;        /* unmute value for uplink to I2S2 */
    U16 delta1;        /* unmute value for downlink to I2S2 */
    U16 lambda1;       /* unmute value for I2S2 to uplink */
    U16 speech_mix_ul; /* fixed value for speech when tone generator is active */
    U16 speech_mix_dl; /* fixed value for speech when tone generator is active */
    U16 ton_mix_ul;    /* unmute value for tone generator uplink */
    U16 ton_mix_dl;    /* unmute value for tone generator downlink */
    U16 mix_pcmrec;    /* unmute value for media to uplink */
} aud_constant_gain_values_type;

/*******************************************************************************
*
*                           External declarations
*
*******************************************************************************/
extern aud_setting_type                       aud_setting;
extern aud_uplink_parms_type            aud_uplink_source_default_data;
extern aud_downlink_parms_type          aud_downlink_source_default_data;
extern const aud_hw_parms_type                aud_hw_parms;
extern const aud_constant_gain_values_type    aud_constant_gain_values;
extern aud_i2s1_configuration_type      aud_i2s1_configuration[];
/*[Begin] [lvwenhua-2010/11/9]*/
extern  aud_afei2s_configuration_type      aud_afei2s_configuration[];
/*[End] [lvwenhua-2010/11/9]*/
extern const aud_i2s2_temp_configuration_type aud_i2s2_temp_configuration[];
#if defined (INTERNAL_POLYRINGER)
/* select sample rate for internal polyringer 16/32kHz */
extern const U16 aud_int_poly_instrument_sample_rate;
#endif

#endif /* _AUD_DATA */

