/*
v_memmove( void *dest, void *src, size_t len);
src,dest 4ֽڶ
src>dest
len >=32
*/
#include "oscl_base_macros.h"
#if (PV_CPU_ARCH_VERSION >= 6)
	.text
	.align	5
	.word	0
	.global memmove_asm
	.type   memmove_asm, function


dest    .req  r0
src     .req  r1
len     .req  r2

s_0     .req  r3
s_1     .req  r4
s_2     .req  r5
s_3     .req  r6
s_4     .req  r7
s_5     .req  r8
s_6     .req  r9
s_7     .req  r10

memmove_asm:
        STMFD   sp!, {r4-r10, lr}
        
        SUB     len, len, #32
        
LOOP:
        LDM     src!,  {s_0-s_7}
        SUBS    len, len, #32
        STM     dest!, {s_0-s_7}

//LOOP END
        BGE       LOOP
       
        ADDS      len, len, #32
        BEQ       END        
        
        TST       len, #16
        LDMNE     src!,  {s_0-s_3}
        STMNE     dest!, {s_0-s_3}        
        TST       len, #8
        LDMNE     src!,  {s_4-s_5}
        STMNE     dest!, {s_4-s_5}
        TST       len, #4
        LDMNE     src,  {s_6}
        STMNE     dest, {s_6}                   
             

END:
        LDMFD   sp!, {r4-r10, pc}

#endif

