/*
void Pred_lt_3or6 (
    Word16 exc[],  
    Word16 T0,    
    Word16 frac,  
    Word16 L_subfr,  
    Word16 flag3     
)
{
    Word16 i, j, k;
    Word16 *x0, *x1, *x2;
    const Word16 *c1, *c2;
    Word32 s;

    x0 = &exc[-T0];             move16 (); 

    frac = negate (frac);
    test();
    if (flag3 != 0)
    {
      frac = shl (frac, 1);   
    }
    
    test (); 
    if (frac < 0)
    {
        frac = add (frac, UP_SAMP_MAX);
        x0--;
    }

    for (j = 0; j < L_subfr; j++)
    {
        x1 = x0++;              move16 (); 
        x2 = x0;                move16 (); 
        c1 = &inter_6[frac];
        c2 = &inter_6[sub (UP_SAMP_MAX, frac)];

        s = 0;                  move32 (); 
        for (i = 0, k = 0; i < L_INTER10; i++, k += UP_SAMP_MAX)
        {
            s = L_mac (s, x1[-i], c1[k]);
            s = L_mac (s, x2[i], c2[k]);
        }

        exc[j] = round (s);     move16 (); 
    }

    return;
}

*/
#include "oscl_base_macros.h"
#include "pred_lt.h"

#if (PV_CPU_ARCH_VERSION >= 6 && PV_COMPILER == EPV_ARM_RVCT)
__asm    OSCL_IMPORT_REF void Pred_lt_3or6_asm(
        Word16 exc[],     /* in/out: excitation buffer                          */
        Word16 T0,        /* input : integer pitch lag                          */
        Word16 frac,      /* input : fraction of lag                            */
        Word16 L_subfr,   /* input : subframe size                              */
        Word16 flag3     /* input : if set, upsampling rate = 3 (6 otherwise)  */
    )
{
        PRESERVE8
            
//ֲƫ
P_C0     EQU 0
P_C1     EQU 4
P_EXC    EQU 8
I        EQU 12
LOC_SIZE EQU 16
FLAG3    EQU  (LOC_SIZE+10*4)
INFO     EQU  (LOC_SIZE+10*4 + 4)

c_0      RN  0
c_1      RN  1
c_2      RN  2
c_3      RN  3
c_4      RN  4

x_0      RN  5
x_1      RN  6
x_2      RN  7
x_3      RN  8
x_4      RN  9

s_0      RN  10
s_1      RN  11

p_x      RN  12
p_exc    RN  14


//¸ļĴ

p_c     RN  14
i       RN  5

    MACRO
    LOAD $reg, $off
    LDR  $reg, [sp, #$off]
    MEND

    MACRO
    STORE $reg, $off
    STR   $reg, [sp, #$off]
    MEND

    MACRO
    LOG $s1, $s2
    LOAD    r14, INFO
    STM     r14!, {$s1, $s2}
    STORE   r14, INFO
    MEND

        STMFD   sp!, {r4-r12, lr}
        SUB     sp, sp, #LOC_SIZE   //ֲ

//ʼ
        STORE  r0, P_EXC

        MOV    r4, #20
        STORE  r4, I

//      x0 = &exc[-T0];             move16 ();
//      frac = negate (frac);        
//      if (flag3 != 0)
//      {
//          frac = shl (frac, 1);
//      }
        LOAD    r14, FLAG3
        RSB     r2, r2, #0
        SUB     r0, r0, r1, LSL #1
        CMP     r14, #0
        LSLNE   r2, r2, #1
        
//      if (frac < 0)
//      {
//          frac = add (frac, UP_SAMP_MAX);
//          x0--;
//      }        
        LDR       r14, =INTER_6_0
        
        CMP       r2, #0
        ADDLT     r2, r2, #6
        SUBLT     r0, r0, #2

        ADD       r4, r14, r2, LSL #4  //r14+r2*20
        ADD       r4, r4, r2, LSL #2 
        STORE     r4, P_C0
        PLD       [r4]
        
        LDR       r14, =INTER_6_1
        
        RSB       r2, r2, #6
        ADD       r5, r14, r2, LSL #4  //r14+r2*20
        ADD       r5, r5, r2, LSL #2 
        STORE     r5, P_C1
        PLD       [r5]
       
        SUB       p_x, r0, #18
        TST       p_x, #2
        BNE       X_NOT_ALIGN
        
        
LOOP1
        LOAD      p_c, P_C0
        LDM       p_x!, {x_0-x_4}        
        LDM       p_c, {c_0-c_4}

        MOV       s_0, #0x4000
        MOV       s_1, #0x4000

        SMLAD     s_0, x_0, c_0, s_0
        SMLATB    s_1, x_0, c_0, s_1
        SMLABT    s_1, x_1, c_0, s_1
        SMLAD     s_0, x_1, c_1, s_0
        SMLATB    s_1, x_1, c_1, s_1
        SMLABT    s_1, x_2, c_1, s_1
        SMLAD     s_0, x_2, c_2, s_0
        SMLATB    s_1, x_2, c_2, s_1
        SMLABT    s_1, x_3, c_2, s_1
        SMLAD     s_0, x_3, c_3, s_0                
        SMLATB    s_1, x_3, c_3, s_1
        SMLABT    s_1, x_4, c_3, s_1
        SMLAD     s_0, x_4, c_4, s_0    
        SMLATB    s_1, x_4, c_4, s_1
        
        LOAD      p_c, P_C1        
        LDM       p_x!, {x_0-x_4}        
        SMLABT    s_1, x_0, c_4, s_1                    

        LDM       p_c, {c_0-c_4}

        SMLAD     s_0, x_0, c_0, s_0
        SMLATB    s_1, x_0, c_0, s_1
        SMLABT    s_1, x_1, c_0, s_1
        SMLAD     s_0, x_1, c_1, s_0
        SMLATB    s_1, x_1, c_1, s_1        
        SMLABT    s_1, x_2, c_1, s_1
        SMLAD     s_0, x_2, c_2, s_0
        SMLATB    s_1, x_2, c_2, s_1 
        SMLABT    s_1, x_3, c_2, s_1
        SMLAD     s_0, x_3, c_3, s_0                
        SMLATB    s_1, x_3, c_3, s_1         
        SMLABT    s_1, x_4, c_3, s_1
        SMLAD     s_0, x_4, c_4, s_0    
        LDRSH     x_0, [p_x]
        SMLATB    s_1, x_4, c_4, s_1    

        SUB       p_x, #36
        SMLABT    s_1, x_0, c_4, s_1

//LOG s_0, s_1

        LOAD      p_exc, P_EXC
        ASR       s_0, s_0, #15
        ASR       s_1, s_1, #15
        LOAD      i, I
        STRH      s_0, [p_exc], #2
        STRH      s_1, [p_exc], #2
        STORE     p_exc, P_EXC

        SUBS      i, #1
        STORE     i, I
        BNE       LOOP1

END
        ADD     sp, sp, #(LOC_SIZE)   //ֲͷ
        LDMFD   sp!, {r4-r12, pc}
        
        
//xĴ        

X_NOT_ALIGN

LOOP_2
        LOAD      p_c, P_C0
        LDRSH     x_0, [p_x], #2        
        LDM       p_x!, {x_1-x_4}        
        LDM       p_c, {c_0-c_4}
        
        MOV       s_0, #0x4000
        MOV       s_1, #0x4000

        SMLAD     s_1, x_1, c_0, s_1

        SMLABB    s_0, x_0, c_0, s_0
        SMLABT    s_0, x_1, c_0, s_0        
        
        SMLAD     s_1, x_2, c_1, s_1 
        
        SMLATB    s_0, x_1, c_1, s_0      
        SMLABT    s_0, x_2, c_1, s_0        

        SMLAD     s_1, x_3, c_2, s_1                

        SMLATB    s_0, x_2, c_2, s_0
        SMLABT    s_0, x_3, c_2, s_0        

        SMLAD     s_1, x_4, c_3, s_1  

        SMLATB    s_0, x_3, c_3, s_0        
        SMLABT    s_0, x_4, c_3, s_0        
        SMLATB    s_0, x_4, c_4, s_0        
        
        
        LDM       p_x!, {x_0-x_4}        
        
        LOAD      p_c, P_C1
        
        SMLABT    s_0, x_0, c_4, s_0                
        SMLAD     s_1, x_0, c_4, s_1             


        LDM       p_c, {c_0-c_4}

        SMLATB    s_0, x_0, c_0, s_0
        SMLABT    s_0, x_1, c_0, s_0        

        SMLAD     s_1, x_1, c_0, s_1
         
        SMLATB    s_0, x_1, c_1, s_0      
        SMLABT    s_0, x_2, c_1, s_0        
        
        SMLAD     s_1, x_2, c_1, s_1        
        
        SMLATB    s_0, x_2, c_2, s_0
        SMLABT    s_0, x_3, c_2, s_0        

        SMLAD     s_1, x_3, c_2, s_1    

        SMLATB    s_0, x_3, c_3, s_0        
        SMLABT    s_0, x_4, c_3, s_0        

        LDM       p_x, {x_0}

        SMLAD     s_1, x_4, c_3, s_1   
        
        SMLATB    s_0, x_4, c_4, s_0        

        SMLABT    s_0, x_0, c_4, s_0        
        SMLAD     s_1, x_0, c_4, s_1   

//LOG s_0, s_1

        SUB       p_x, p_x, #34


        LOAD      p_exc, P_EXC
        ASR       s_0, s_0, #15
        ASR       s_1, s_1, #15

        LOAD      i, I
        STRH      s_0, [p_exc], #2
        STRH      s_1, [p_exc], #2
        STORE     p_exc, P_EXC


        SUBS      i, #1
        STORE     i, I
        BNE       LOOP_2


        B END

INTER_6_0
  DCW 34, -120, 308, -634, 1099, -1666,  2259, -2783,  3143, 29443
  DCW 73, -163, 340, -602,  904, -1147,  1170, -672,  -1352, 28346
  DCW 91, -165, 296, -451,  550,  -464,     0,  1211, -4402, 25207
  DCW 89, -132, 198, -231,  135,   218, -1001,  2536, -5865, 20449
  DCW 70, -79,   78,    0, -245,   756, -1652,  3130, -5850, 14701
  DCW 38, -19,  -36,  191, -514,  1060, -1868,  2991, -4673,  8693
  DCW 0,   34, -120,  308, -634,  1099, -1666,  2259, -2783,  3143

INTER_6_1
  DCW 29443,  3143, -2783,  2259, -1666, 1099, -634,  308, -120, 34
  DCW 28346, -1352,  -672,  1170, -1147,  904, -602,  340, -163, 73
  DCW 25207, -4402,  1211,     0,  -464,  550, -451,  296, -165, 91
  DCW 20449, -5865,  2536, -1001,   218,  135, -231,  198, -132, 89
  DCW 14701, -5850,  3130, -1652,   756, -245,    0,   78,  -79, 70
  DCW  8693, -4673,  2991, -1868,  1060, -514,  191,  -36,  -19, 38
  DCW  3143, -2783,  2259, -1666,  1099, -634,  308, -120,   34,  0        
}
#endif
