/************************************************************************
 * Ȩ (C)2010,ͨѶɷ޹˾
 * ģ  
 * ļƣ os_thread.c
 * ļʶ Zcoreļزӿ
 * ժҪ
 *
 * ޸    汾       ޸ı        ޸        ޸
 * ----------------------------------------------------------------------
 *
 ************************************************************************/

/**************************************************************************
 *                        ͷļ                                                                         *
 **************************************************************************/
#include <signal.h>
#include <time.h>
#include "zcore_type.h"
#include "os_type.h"
#include "os_pub.h"
#include "os_timer.h"
#include "os_list.h"
#include "os_mutex.h"
/****************************************************************************
 *                          غ
 ****************************************************************************/
#define timer_context(id)   ((OS_TIMER_CONTEXT *)id)
#define timer_info(id)      (timer_context(id)->info)
/****************************************************************************
*                          
****************************************************************************/
typedef struct
{
    OS_LIST_NODE    node;
    OS_FUNC_ENTRY   func;
    VOID            *func_param;
    OS_TIMER_INFO   info;
} OS_TIMER_CONTEXT;
/****************************************************************************
 *                         ر
 ****************************************************************************/
static OS_TIMER_ID  s_timer_id = OS_TIMER_INVALID_ID;
static timer_t      s_main_timer;
/****************************************************************************
*                          غԭ
****************************************************************************/
static OS_STATUS tp_os_timer_handle();
static SINT32 timer_context_add( OS_TIMER_CONTEXT **p_context );
static VOID timer_context_remove( OS_TIMER_CONTEXT *p_context );
/****************************************************************************
*                          ȫֺʵ
****************************************************************************/
/**************************************************************************
* ƣ tp_os_timer_create
* һʱ
* ˵nameĶʱ
                   expir_funcʱʱõĻص
                   intervalʱʱλΪ
                   flagֵΪOS_AUTO_ACTIVATEڴʱ
                   ֵΪOS_AUTO_LOADʱʱԶֵΪߵĺϼ

*   ֵ    ɹ򷵻Ķʱıʶţ򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/

OS_TIMER_ID tp_os_timer_create( CHAR *name, OS_FUNC_ENTRY expir_func, VOID*expire_para, UINT32 interval, UINT32 flag )
{
    OS_TIMER_CONTEXT    *p_context = NULL;

    TP_OS_ASSERTEx( NULL != name, OS_TIMER_INVALID_ID );
    TP_OS_ASSERTEx( NULL != expir_func, OS_TIMER_INVALID_ID );

    if ( OS_SUCCESS != timer_context_add( &p_context ) )
    {
        return OS_TIMER_INVALID_ID;
    }
    p_context->func                = expir_func;
    p_context->func_param          = expire_para;
    p_context->info.timer_state    = OS_TIMER_STOP;
    strncpy( p_context->info.name, name, OS_MAX_NAME_LEN-1 );
    p_context->info.interval       = interval;
    p_context->info.remaining_time = interval;
    p_context->info.attr_flag      = flag;
    s_timer_id = p_context->info.id;
    //ϵͳtimer
    if (timer_create (CLOCK_REALTIME, NULL, &s_main_timer) < 0)
    {
        printf ("timer_create failed");
        return OS_FAILURE;
    }

    //עtimerص
    signal(SIGALRM,(void*)tp_os_timer_handle);

    if ( OS_AUTO_ACTIVATE & flag )
    {
        tp_os_timer_start(p_context->info.id);
    }
    return p_context->info.id;
}
/**************************************************************************
* ƣ tp_os_timer_delete
* ɾָĶʱ
* ˵idʱıʶ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS   tp_os_timer_delete( OS_TIMER_ID id )
{
    TP_OS_ASSERTEx( OS_TIMER_INVALID_ID != id, OS_FAILURE );
    timer_context_remove( timer_context(id) );
    timer_delete(s_main_timer);
}
/**************************************************************************
* ƣ tp_os_timer_start
* һѴĶʱ
* ˵idʱıʶ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS   tp_os_timer_start( OS_TIMER_ID id )
{
    struct itimerspec timer;

    TP_OS_ASSERTEx( OS_TIMER_INVALID_ID != id, OS_FAILURE );

    timer_info(id).timer_state = OS_TIMER_ACTIVE;//ʱ״̬Ϊactive

    timer.it_interval.tv_sec = timer_info(id).interval/1000;
    timer.it_interval.tv_nsec = (timer_info(id).interval % 1000)* 1000 * 1000;
    timer.it_value = timer.it_interval;
    //ϵͳtimer
    if (timer_settime (s_main_timer, 0, &timer, NULL) < 0)
    {
        printf ("timer_settime failed");
        return OS_FAILURE;
    }
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_timer_stop
* ֹͣʱʱ
* ˵idʱıʶ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS   tp_os_timer_stop( OS_TIMER_ID id )
{
    TP_OS_ASSERTEx( OS_TIMER_INVALID_ID != id, OS_FAILURE );

    timer_info(id).timer_state = OS_TIMER_STOP;//ʱ״̬ΪSTOP
    timer_delete(s_main_timer);
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_timer_restart
* µʱĶʱ
* ˵idʱıʶ
                               intervalʱʱλΪ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS   tp_os_timer_restart( OS_TIMER_ID id, UINT32 interval )
{
    TP_OS_ASSERTEx( OS_TIMER_INVALID_ID != id, OS_FAILURE );
    TP_OS_ASSERTEx( 0 != interval, OS_FAILURE );

    tp_os_timer_stop(id);
    timer_info(id).interval = interval;
    if (timer_create (CLOCK_REALTIME, NULL, &s_main_timer) < 0)
    {
        printf ("timer_create failed");
        return OS_FAILURE;
    }

    tp_os_timer_start(id);
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_timer_info_get
* ȡָʱϢ
* ˵idʱıʶ
                               info_ptrʱϢĴŵַָ
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS   tp_os_timer_info_get( OS_TIMER_ID id, OS_TIMER_INFO *info_ptr )
{
    TP_OS_ASSERTEx( OS_TIMER_INVALID_ID != id, OS_FAILURE );

    tp_os_mem_cpy( info_ptr, &timer_info(id), sizeof(OS_TIMER_INFO) );
    return OS_SUCCESS;
}
/*******************************************************************************
* Function	 : tp_os_abs_timer_create												   	   
* Description: This function is used to create an absolute application timer                                                 
* Relation	 : used after tp_os_timer_init
* Params	 : 						     									
* 																			   
*   Name		    Type		In/Out 		Description							   
* -------- 		    ---- 		------   	----------- 				       
* name              CHAR *         In        the identifier of a timer
* expir_func        OS_FUNC_ENTRY  In        the entry when the timer is expired
* expire_para_ptr   VOID *         In        the param for the entry when the timer is expired
* interval	        UINT32 	       In        give the timer interval from the timer is actived to the timer is expired
* flag 		        UINT32		   In		AUTO_ACTIVE|AUTO_LOAD,if AUTO_ACTIVE set, then when the timer is created
*										it will actived at the same time else it should be start followly.
*										if AUTO_LOAD set, the timer will be restart when the timer is expired.
*
* Return:  if success, return timer id,else return OS_FAILURE,and exactly error 
*                                       number store in errno.
* Note:    NA
*******************************************************************************/
OS_TIMER_ID tp_os_abs_timer_create(CHAR *name,OS_FUNC_ENTRY expir_func,VOID* expire_para_ptr,UINT32 interval,UINT32 flag)
{    
    OS_TIMER_ID tmid;   

    tmid = tp_os_timer_create(name, expir_func, expire_para_ptr, interval, flag);
    return tmid;
}
/**************************************************************************
* ƣ tp_os_timer_handle
*  timerĴ
* ˵
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static OS_STATUS tp_os_timer_handle()
{
    timer_context(s_timer_id)->func(timer_context(s_timer_id)->func_param);
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ timer_context_add
* 
* ˵
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static SINT32 timer_context_add( OS_TIMER_CONTEXT **p_context )
{
    OS_TIMER_CONTEXT   *p_timer_context = NULL;

    p_timer_context = (OS_TIMER_CONTEXT *)tp_os_mem_malloc( sizeof(OS_TIMER_CONTEXT) );
    if ( NULL == p_timer_context )
    {
        return OS_FAILURE;
    }
    tp_os_mem_set( p_timer_context, 0, sizeof(OS_TIMER_CONTEXT) );

    p_timer_context->info.id = (OS_TIMER_ID)p_timer_context;
    *p_context = p_timer_context;
    return OS_SUCCESS;
}
/**************************************************************************
* ƣ timer_context_remove
* 
* ˵
*   ֵ     ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static VOID timer_context_remove( OS_TIMER_CONTEXT *p_context )
{
    TP_OS_ASSERTEx( p_context != NULL, OS_FAILURE );

    tp_os_mem_free(p_context);
    p_context = NULL;
}
