
/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:
 *   State machine for the voice memo service (vms). Everything concerning 
the vms is
 *              controlled from this code.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_ext_def.h
 *   Version: \main\21
 *   Date: 2007-04-30 15:16:48
 */

#ifndef _AUD_EXT_DEF_H
#define _AUD_EXT_DEF_H

#include "aud_drv.h"
/*changed by wangjun for NV change.[20090214]*/
#include "aud_nv.h"  //#include "eep.h"

//#include"atctstif.h"

#ifdef LIS_TRACE
#include "los_log.h"
#endif 

#ifdef FFS_PRESENT
//#define AUD_FFS_PRESENT   huojishan 2007.12.28
#endif 

#if defined(FAT_FS_PRESENT)
#if  defined(MMCI_PRESENT) || defined (NAND_PRESENT)
//#define AUD_FAT_FS_PRESENT  huojishan 2007.12.28
#endif
#if defined(NAND_PRESENT)
#define AUD_NANDDEVICE_SUPPORT
#endif
#endif /* FAT_FS_PRESENT */

#if defined (AUD_FFS_PRESENT)
#include "ffs.h"
#include "ssal.h"
#include "ffs_opcodes.h"
#endif /* (AUD_FFS_PRESENT)*/

#if defined (AUD_FAT_FS_PRESENT)
#include "ssal.h"
#include "fs.h"
#include "fs_opcodes.h"
#endif /* (AUD_FAT_FS_PRESENT)*/

/*** SSAL functions*******/
#if defined(AUD_FFS_PRESENT) || defined(AUD_FAT_FS_PRESENT)

/** SSAL_USER_TYPES ****/
/* Contains an element for each process using the SSAL. */
typedef enum {
    AUD_SSAL_MP3          = SSAL_MP3,
    AUD_SSAL_VR_WRITE     = SSAL_VR_WRITE,
    AUD_SSAL_VR_READ      = SSAL_VR_READ,
    AUD_SSAL_VR           = SSAL_VR,
    AUD_SSAL_NOF_USERS    = SSAL_NOF_USERS  //Dummy element
} aud_ssal_user_type;

typedef enum {
    AUD_SSAL_FFS_MEDIA    = SSAL_FFS_MEDIA, //Used when communicating with the outside world (PC DLL or EasyGSM)
    AUD_SSAL_FS_MEDIA     = SSAL_FS_MEDIA,
    AUD_SSAL_NOF_MEDIAS   = SSAL_NOF_MEDIAS //Dummy element
} aud_ssal_media_type;

/******** SSAL Functions ******************/
#ifdef FFS_EXTENDED_CALLBACK
#define Aud_SSAL_write(media,user_id,handle,src,nof,cb,client_arg)  SSAL_write(media,user_id,handle,src,nof,cb,client_arg)
#define Aud_SSAL_read(media,user_id,handle,dst,nof,cb,client_arg)   SSAL_read(media,user_id,handle,dst,nof,cb,client_arg)
#define Aud_SSAL_set_file_pos(media,user_id,handle,pos,cb,client_arg) SSAL_set_file_pos(media,user_id,handle,pos,cb,client_arg)
#else
#define Aud_SSAL_write(media,user_id,handle,src,nof,cb)             SSAL_write(media,user_id,handle,src,nof,cb)
#define Aud_SSAL_read(media,user_id,handle,dst,nof,cb)              SSAL_read(media,user_id,handle,dst,nof,cb)
#define Aud_SSAL_set_file_pos(media,user_id,handle,pos,cb)       SSAL_set_file_pos(media,user_id,handle,pos,cb)
#endif
#define Aud_SSAL_get_file_pos(media,user_id,handle,pos,cb)          SSAL_get_file_pos(media,user_id,handle,pos,cb)
#define Aud_SSAL_get_file_length(media,user_id,handle)             SSAL_get_file_length(media,user_id,handle)
#define Aud_SSAL_result_ok(media,result)                        SSAL_result_ok(media,  result)

#define  aud_ssal_media_type ssal_media_type 
#define  aud_ssal_user_type  ssal_user_type

#else  /* defined(AUD_FFS_PRESENT) || defined(AUD_FAT_FS_PRESENT) */

/************Enums ************/
/* Contains an element for each process using the SSAL. */
typedef enum {
    AUD_SSAL_MP3 ,
    AUD_SSAL_VR_WRITE,
    AUD_SSAL_VR_READ,
    AUD_SSAL_VR,
    AUD_SSAL_NOF_USERS
} aud_ssal_user_type;

typedef enum {
    AUD_SSAL_FFS_MEDIA, //Used when communicating with the outside world (PC DLL or EasyGSM)
    AUD_SSAL_FS_MEDIA ,
    AUD_SSAL_NOF_MEDIAS
} aud_ssal_media_type;

/******** SSAL Functions ******************/
#ifdef FFS_EXTENDED_CALLBACK
#define Aud_SSAL_write(media,user_id,handle,src,nof,cb,client_arg)  aud_trap_FFS_FS()
#define Aud_SSAL_read(media,user_id,handle,dst,nof,cb,client_arg)   aud_trap_FFS_FS()
#define Aud_SSAL_set_file_pos(media,user_id,handle,pos,cb,client_arg) aud_trap_FFS_FS()
#else
#define Aud_SSAL_write(media,user_id,handle,src,nof,cb)             aud_trap_FFS_FS()
#define Aud_SSAL_read(media,user_id,handle,dst,nof,cb)              aud_trap_FFS_FS()
#define Aud_SSAL_set_file_pos(media,user_id,handle,pos,cb)       aud_trap_FFS_FS()
#endif
#define Aud_SSAL_get_file_pos(media,user_id,handle,pos,cb)          aud_trap_FFS_FS()
#define Aud_SSAL_get_file_length(media,user_id,handle)             aud_trap_FFS_FS()
#define Aud_SSAL_result_ok(media,result)                     aud_trap_FFS_FS()

#endif /* defined(AUD_FFS_PRESENT) || defined(AUD_FAT_FS_PRESENT) */

#ifdef AUD_FFS_PRESENT
typedef word* aud_ffs_handle_type;
#define AUD_FFS_STREAMING  FFS_STREAMING //Used as the "size" parameter when creating "streaming files"

typedef enum {
    AUD_atctst_create      = atctst_create,
    AUD_atctst_open        = atctst_open,
    AUD_atctst_close       = atctst_close,
    AUD_atctst_write       = atctst_write ,  
    AUD_atctst_delete      = atctst_delete,
    AUD_atctst_file_exists = atctst_file_exists
}aud_ffs_opcode;

typedef enum {
    AUD_FFS_FILETYPE_MP3     = FFS_FILETYPE_MP3,
    AUD_FFS_FILETYPE_WAV     = FFS_FILETYPE_WAV,
    AUD_FFS_FILETYPE_AMR     = FFS_FILETYPE_AMR,
    AUD_FFS_FILETYPE_FR      = FFS_FILETYPE_FR,
    AUD_FFS_NOF_FILETYPES    = FFS_NOF_FILETYPES,
    AUD_FFS_FILETYPE_GARBAGE = FFS_FILETYPE_GARBAGE, // Special filetype for garbage collector ONLY.
    AUD_FFS_ALL_FILETYPES    = 0xFF
} aud_ffs_filetype_type;

/* Open File Modes */
typedef enum {
    AUD_FFS_FILE_OPEN_READ           = FFS_FILE_OPEN_READ,
    AUD_FFS_FILE_OPEN_APPEND         = FFS_FILE_OPEN_APPEND,
    AUD_FFS_FILE_OPEN_MODIFY         = FFS_FILE_OPEN_MODIFY,
    AUD_FFS_FILE_OPEN_READ_STREAMING = FFS_FILE_OPEN_READ_STREAMING
} aud_ffs_open_file_mode_type;

typedef enum {
    AUD_FFS_MP3      = FFS_MP3,
    AUD_FFS_VR_WRITE = FFS_VR_WRITE,
    AUD_FFS_VR_READ  = FFS_VR_READ,
    AUD_FFS_VR       = FFS_VR,
    AUD_FFS_AUDIO    = FFS_AUDIO,
}aud_ffs_user_type;

/* FFS error codes: */
typedef enum {
    AUD_FFS_FALSE                                = FFS_FALSE,
    AUD_FFS_TRUE                                 = FFS_TRUE,
    AUD_FFS_SUCCESS                              = FFS_SUCCESS,
    AUD_FFS_INITIALIZING                         = FFS_INITIALIZING,
    AUD_FFS_ALREADY_OPEN                         = FFS_ALREADY_OPEN,
    AUD_FFS_NOT_OPEN                             = FFS_NOT_OPEN,
    AUD_FFS_FILE_NOT_FOUND                       = FFS_FILE_NOT_FOUND,
    AUD_FFS_EXISTS                               = FFS_EXISTS,
    AUD_FFS_ILLIGAL_ID                           = FFS_ILLIGAL_ID,
    AUD_FFS_ILLIGAL_FILE_HANDLE                  = FFS_ILLIGAL_FILE_HANDLE,
    AUD_FFS_ILLIGAL_TYPE                         = FFS_ILLIGAL_TYPE,
    AUD_FFS_ILLIGAL_MODE                         = FFS_ILLIGAL_MODE,
    AUD_FFS_FILE_RANGE_ERROR                     = FFS_FILE_RANGE_ERROR,
    AUD_FFS_OPERATION_NOT_POSSIBLE               = FFS_OPERATION_NOT_POSSIBLE,
    AUD_FFS_WRITE_ERROR                          = FFS_WRITE_ERROR,
    AUD_FFS_USER_ID_ERROR                        = FFS_USER_ID_ERROR,
    AUD_FFS_INTERNAL_FATAL_ERROR                 = FFS_INTERNAL_FATAL_ERROR,
    AUD_FFS_MEMORY_RES_ERROR                     = FFS_MEMORY_RES_ERROR,
    AUD_FFS_MAX_NOF_FILES_EXCEEDED               = FFS_MAX_NOF_FILES_EXCEEDED,
    AUD_FFS_REQUESTED_MEM_NOT_AVAILABLE          = FFS_REQUESTED_MEM_NOT_AVAILABLE,
    AUD_FFS_INVALID_NAME                         = FFS_INVALID_NAME,
    AUD_FFS_STREAMING_NOT_ENABLED                = FFS_STREAMING_NOT_ENABLED,
    AUD_FFS_OPERATION_NOT_ALLOWED_ON_STATIC_FILE = FFS_OPERATION_NOT_ALLOWED_ON_STATIC_FILE,
    AUD_FFS_MEM_TABLES_INCONSISTENCY             = FFS_MEM_TABLES_INCONSISTENCY,
    AUD_FFS_NOT_A_FACTORY_DEFAULT_FILE           = FFS_NOT_A_FACTORY_DEFAULT_FILE,
    AUD_FFS_REQUESTED_MEM_TEMP_NOT_AVAILABLE     = FFS_REQUESTED_MEM_TEMP_NOT_AVAILABLE,
    AUD_FFS_ILLIGAL_DIR_OPERATION                = FFS_ILLIGAL_DIR_OPERATION,
    AUD_FFS_DIR_SPACE_NOT_AVAILABLE              = FFS_DIR_SPACE_NOT_AVAILABLE,
    AUD_FFS_TOO_MANY_OPEN_STREAMING_FILES        = FFS_TOO_MANY_OPEN_STREAMING_FILES
}aud_ffs_error_code_type;

/* File info type */
typedef struct {
    ffs_filetype_type     type;  
    ulong                 size; 
    ffs_time_record_type  timestamp;  
    byte                  dynamic;  
    byte                  reserved;  
    ffs_drm_attrib_type   drm_attrib;
} aud_ffs_file_info_type;

/************ FFS Functions **************************/
#ifdef FFS_EXTENDED_CALLBACK
#define Aud_FFS_read(user_id,id,handle,dst,offset,nof,cb,client_arg) (aud_ffs_error_code_type)FFS_read((ffs_user_type)user_id,id,handle,dst,offset,nof,cb,client_arg)
#define Aud_FFS_close(user_id,id,handle,cb,client_arg)              (aud_ffs_error_code_type)FFS_close((ffs_user_type)user_id,id,handle,cb,client_arg)
#else
#define Aud_FFS_read(user_id,id,handle,dst,offset,nof,cb)           (aud_ffs_error_code_type)FFS_read((ffs_user_type)user_id,id,handle,dst,offset,nof,cb)
#define Aud_FFS_close(user_id,id,handle,cb)                         (aud_ffs_error_code_type)FFS_close((ffs_user_type)user_id,id,handle,cb)
#endif
#define Aud_FFS_open(user_id,filename,handle,mode)                  (aud_ffs_error_code_type)FFS_open((ffs_user_type)user_id,filename,handle,(ffs_open_file_mode_type)mode)
#define Aud_FFS_get_file_info(user_id,handle,info)                  (aud_ffs_error_code_type)FFS_get_file_info((ffs_user_type)user_id,handle,info)
#define Aud_FFS_get_file_pos(user_id,handle,file_pos,cb)            (aud_ffs_error_code_type)FFS_get_file_pos((ffs_user_type)user_id,handle,file_pos,cb)
#define Aud_FFS_set_file_pos(user_id,handle,file_pos,cb)            (aud_ffs_error_code_type)FFS_set_file_pos((ffs_user_type)user_id,handle,file_pos,cb)
#define Aud_FFS_get_file_id_from_handle(user_id, handle,file_id)    (aud_ffs_error_code_type)FFS_get_file_id_from_handle((ffs_user_type)user_id, handle,file_id)

#else

#define FFS_STREAMING      (0xFEFEFEFE) //Used as the "size" parameter when creating "streaming files"
#define AUD_FFS_STREAMING  FFS_STREAMING

typedef enum {
    AUD_atctst_create       = 3,
    AUD_atctst_open         = 5,
    AUD_atctst_close        = 6,
    AUD_atctst_write        = 8,  
    AUD_atctst_delete       = 9,
    AUD_atctst_file_exists  = 10
} aud_ffs_opcode;

typedef enum {
    AUD_FFS_FILETYPE_MP3     = 17,
    AUD_FFS_FILETYPE_WAV     = 28,
    AUD_FFS_FILETYPE_AMR     = 37,
    AUD_FFS_FILETYPE_FR      = 38,
    AUD_FFS_NOF_FILETYPES    = 73,
    AUD_FFS_FILETYPE_GARBAGE = 74, // Special filetype for garbage collector ONLY.
    AUD_FFS_ALL_FILETYPES    = 0xFF
} aud_ffs_filetype_type;

typedef word* aud_ffs_handle_type;

/***********FFS enums*************/

/* Open File Modes */
typedef enum {
    AUD_FFS_FILE_OPEN_READ,
    AUD_FFS_FILE_OPEN_APPEND,
    AUD_FFS_FILE_OPEN_MODIFY,
    AUD_FFS_FILE_OPEN_READ_STREAMING
} aud_ffs_open_file_mode_type;

typedef enum {
    AUD_FFS_MP3,
    AUD_FFS_VR_WRITE,
    AUD_FFS_VR_READ,
    AUD_FFS_VR,
    AUD_FFS_AUDIO
} aud_ffs_user_type;

/* FFS error codes: */
typedef enum {
    AUD_FFS_FALSE,
    AUD_FFS_TRUE,
    AUD_FFS_SUCCESS,
    AUD_FFS_INITIALIZING,
    AUD_FFS_ALREADY_OPEN,
    AUD_FFS_NOT_OPEN,
    AUD_FFS_FILE_NOT_FOUND,
    AUD_FFS_EXISTS,
    AUD_FFS_ILLIGAL_ID,
    AUD_FFS_ILLIGAL_FILE_HANDLE,
    AUD_FFS_ILLIGAL_TYPE,
    AUD_FFS_ILLIGAL_MODE,
    AUD_FFS_FILE_RANGE_ERROR,
    AUD_FFS_OPERATION_NOT_POSSIBLE,
    AUD_FFS_WRITE_ERROR,
    AUD_FFS_USER_ID_ERROR,
    AUD_FFS_INTERNAL_FATAL_ERROR,
    AUD_FFS_MEMORY_RES_ERROR,
    AUD_FFS_MAX_NOF_FILES_EXCEEDED,
    AUD_FFS_REQUESTED_MEM_NOT_AVAILABLE,
    AUD_FFS_INVALID_NAME,
    AUD_FFS_STREAMING_NOT_ENABLED,
    AUD_FFS_OPERATION_NOT_ALLOWED_ON_STATIC_FILE,
    AUD_FFS_MEM_TABLES_INCONSISTENCY,
    AUD_FFS_NOT_A_FACTORY_DEFAULT_FILE,
    AUD_FFS_REQUESTED_MEM_TEMP_NOT_AVAILABLE,
    AUD_FFS_ILLIGAL_DIR_OPERATION,
    AUD_FFS_DIR_SPACE_NOT_AVAILABLE,
    AUD_FFS_TOO_MANY_OPEN_STREAMING_FILES
}aud_ffs_error_code_type;

/* File info type */
typedef struct {
    word    type;
    ulong   size;  
    word    timestamp;
    byte    dynamic;  
    byte    reserved; 
    word    drm_attrib;  
} aud_ffs_file_info_type;

/************ FFS Functions **************************/
#ifdef FFS_EXTENDED_CALLBACK
#define Aud_FFS_read(user_id,id,handle,dst,offset,nof,cb,client_arg) aud_trap_FFS_FS()
#define Aud_FFS_close(user_id,id,handle,cb,client_arg)              aud_trap_FFS_FS()
#else
#define Aud_FFS_read(user_id,id,handle,dst,offset,nof,cb)           aud_trap_FFS_FS()
#define Aud_FFS_close(user_id,id,handle,cb)                         aud_trap_FFS_FS()
#endif
#define Aud_FFS_open(user_id,filename,handle,mode)              aud_trap_FFS_FS()
#define Aud_FFS_get_file_info(user_id,handle,info)              aud_trap_FFS_FS()       
#define Aud_FFS_get_file_pos(user_id,handle,file_pos,cb)        aud_trap_FFS_FS()     
#define Aud_FFS_set_file_pos(user_id,handle,file_pos,cb)        aud_trap_FFS_FS()    
#define Aud_FFS_get_file_id_from_handle(user_id,handle,file_id) aud_trap_FFS_FS()
#endif /* AUD_FFS_PRESENT */

/****************** FS Functions *******************************/
#ifdef AUD_FAT_FS_PRESENT
#define AUD_FS_CREAT  FS_CREAT
#define AUD_FS_BINARY FS_BINARY
#define AUD_FS_WRONLY FS_WRONLY
#define AUD_FS_RDWR   FS_RDWR
#define AUD_FS_TRUNC  FS_TRUNC
#define AUD_FS_IREAD  FS_IREAD
#define AUD_FS_IWRITE FS_IWRITE

typedef sshort aud_fs_fd_type; 
typedef enum {
    AUD_atctst_fs_open           = atctst_fs_open,
    AUD_atctst_fs_write          = atctst_fs_write,
    AUD_atctst_fs_close          = atctst_fs_close,
    AUD_atctst_fs_delete         = atctst_fs_delete,
    AUD_atctst_fs_diskopen       = atctst_fs_diskopen,
    AUD_atctst_fs_diskclose      = atctst_fs_diskclose,
    AUD_atctst_fs_set_default_device = atctst_fs_set_default_device,

}aud_fs_opcode;

typedef enum {
    // Zero is a reserved value;
    AUD_FS_MMCSD_DEV    = FS_MMCSD_DEV, /* A */
    AUD_FS_FTL_DEVICE1  = FS_FTL_DEVICE1, /* C */
    AUD_FS_FFS_DEVICE   = FS_FFS_DEVICE,   /* D*/
    AUD_FS_FTL_DEVICE2  = FS_FTL_DEVICE2,   /* E: */
    AUD_FS_FTL_DEVICE3  = FS_FTL_DEVICE3,  /* F:  */
    
    AUD_FS_TEST_DEVICE1 = FS_TEST_DEVICE1, 
    AUD_FS_TEST_DEVICE2 = FS_TEST_DEVICE2,
    AUD_FS_TEST_DEVICE3 = FS_TEST_DEVICE3
} aud_fs_device_type;

typedef struct
{
  void           (*notification_func)(aud_fs_device_type device, BOOL media_present, void *client_arg);
  void           *client_arg;
  ushort         auto_mount;
  ushort         PLP_feature;
  aud_fs_device_type device;
  char           drive_letter;
  BOOL           removable;
  BOOL           indication;
  BOOL           media_present;
  BOOL           read_only;
}  aud_fs_registered_info_type;

// FS error codes:
#define AUD_FS_FAILURE                          FS_FAILURE                   
#define AUD_FS_SUCCESS                          FS_SUCCESS
#define AUD_FS_ERR_OPERATION_NOT_POSSIBLE       FS_ERR_OPERATION_NOT_POSSIBLE
#define AUD_FS_ERR_USER_ID_ERROR                FS_ERR_USER_ID_ERROR

/* Arguments to SEEK */
#define AUD_FS_SEEK_SET                         FS_SEEK_SET      /* offset from begining of file */
#define AUD_FS_SEEK_CUR                         FS_SEEK_CUR      /* offset from current file pointer */
#define AUD_FS_SEEK_END                         FS_SEEK_END      /* offset from end of file */

/************ FS Functions **************************/
#define Aud_FS_seek(handle,pos,start_pos,error)   FS_seek(handle,pos,start_pos,error)
#define Aud_FS_read(handle,dst,offset)            FS_read(handle,dst,offset)

#else /* #ifdef AUD_FAT_FS_PRESENT */
#define AUD_FS_CREAT  0x0100 /* File creation permissions for open */
#define AUD_FS_BINARY 0x8000 /* File creation permissions for open */
#define AUD_FS_WRONLY 0x0001 /* File creation permissions for open */
#define AUD_FS_RDWR   0x0002 /* File creation permissions for open */
#define AUD_FS_TRUNC  0x0200 /* File creation permissions for open */
#define AUD_FS_IREAD  0x0080 /* File open mode */
#define AUD_FS_IWRITE 0x0100 /* File open mode */

typedef enum {
    AUD_atctst_fs_open      = 0,
    AUD_atctst_fs_write     = 3,  
    AUD_atctst_fs_close     = 6,
    AUD_atctst_fs_delete    = 15,
    AUD_atctst_fs_diskopen  = 21,
    AUD_atctst_fs_diskclose = 22,
    AUD_atctst_fs_set_default_device = 28,

}aud_fs_opcode; 
typedef enum {
    // Zero is a reserved value;
    AUD_FS_MMCSD_DEV    = 1, /* A */
    AUD_FS_FTL_DEVICE1,
    AUD_FS_FFS_DEVICE ,
    AUD_FS_FTL_DEVICE2,
    AUD_FS_FTL_DEVICE3, 
    
    AUD_FS_TEST_DEVICE1 = 240, 
    AUD_FS_TEST_DEVICE2 = 241,
    AUD_FS_TEST_DEVICE3 = 242
} aud_fs_device_type;
typedef sshort aud_fs_fd_type; 

typedef struct
{
  void           (*notification_func)(aud_fs_device_type device, BOOL media_present, void *client_arg);
  void           *client_arg;
  ushort         auto_mount;
  ushort         PLP_feature;
  aud_fs_device_type device;
  char           drive_letter;
  BOOL           removable;
  BOOL           indication;
  BOOL           media_present;
  BOOL           read_only;
}  aud_fs_registered_info_type;

/* FS error codes: */
#define AUD_FS_FAILURE                          0                   
#define AUD_FS_SUCCESS                          1
#define AUD_FS_ERR_OPERATION_NOT_POSSIBLE       2
#define AUD_FS_ERR_USER_ID_ERROR                3

/* Arguments to SEEK */
#define AUD_FS_SEEK_SET                         1      /* offset from begining of file */
#define AUD_FS_SEEK_CUR                         1      /* offset from current  file pointer */
#define AUD_FS_SEEK_END                         1      /* offset from end of file */

/************ FS Functions **************************/
#define Aud_FS_seek(handle,pos,start_pos,error)    aud_trap_FFS_FS()
#define Aud_FS_read(handle,dst,offset)             aud_trap_FFS_FS()
#endif /* #ifdef AUD_FAT_FS_PRESENT */
extern aud_ssal_media_type aud_media_type_to_ssal_type(aud_media_enum type);
extern unsigned short aud_trap_FFS_FS(void);
#endif /*_AUD_EXT_DEF_H*/

