/**************************************************************************
*
*                  Copyright (c) 2014 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : NandFlash.h
* ļ : 
* ʵֹ : 
*      : 
*      : 
*  : 
* ˵ :         
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/

#ifndef _NAND_FLASH_H
#define _NAND_FLASH_H

/* 7520汾ʹ÷ */
#ifdef _CHIP_ZX2804
/**************************************************************************
* 
**************************************************************************/
#define FLASH_BASE_ADDR                             0x3C000000

/*physical addr of HLS exception save area */
#define OS_FLASH_ABSOLUTE_HLS_EXCE_BASE_ADDR        (FLASH_BASE_ADDR + 0x100000)
#define OS_FLASH_ABSOLUTE_HLS_EXCE_SIZE             0x80000

/*physical addr of plat exception save area */
#define OS_FLASH_ABSOLUTE_PLAT_EXCE_BASE_ADDR       (FLASH_BASE_ADDR + 0x180000)
#define OS_FLASH_ABSOLUTE_PLAT_EXCE_SIZE            0x80000

/*physical addr of AMT data*/
#define OS_FLASH_ABSOLUTE_AMT_DATA_BASE_ADDR        (FLASH_BASE_ADDR + 0x200000)
#define OS_FLASH_ABSOLUTE_AMT_DATA_SIZE             0x80000

/* DSP code */
#define OS_FLASH_TEAK_DSP_BASE_ADDR                 (FLASH_BASE_ADDR + 0x280000)
#define OS_FLASH_TEAK_DSP_SIZE                      0x80000

#define OS_FLASH_ZSP_LTE_BASE_ADDR                  (FLASH_BASE_ADDR + 0x300000)
#define OS_FLASH_ZSP_LTE_VERSION_LEN_ADDR           (FLASH_BASE_ADDR + 0x37FFFC)

#define OS_FLASH_ZSP_TD_BASE_ADDR                   (FLASH_BASE_ADDR + 0x1700000)
#define OS_FLASH_ZSP_TD_VERSION_LEN_ADDR            (FLASH_BASE_ADDR + 0x177FFFC)  

#define OS_FLASH_ZSP_DSP_SIZE                       0x80000
#define OS_FLASH_ZSP_DSP_VERSION_LEN_SIZE           0x4

/*logo*/
#define OS_LOGO_BASE_ADDR                           (FLASH_BASE_ADDR + 0x380000)
#define OS_LOGO_SIZE                                0x80000

/* physical address of code */
#define OS_FLASH_CODE_BASE_ADDR                     (FLASH_BASE_ADDR + 0x400000)
#define OS_FLASH_CODE_SIZE                          0x2000000

/* physical addr of workarea nvram */
#define OS_FLASH_ABSOLUTE_WORKAREA_NVRAM_BASE_ADDR  (FLASH_BASE_ADDR + 0x2A80000)
#define OS_FLASH_ABSOLUTE_WORKAREA_NVRAM_SIZE       0x300000

/*  physical addr of backup nvram    */
#define OS_FLASH_ABSOLUTE_BACKUP_NVRAM_BASE_ADDR    (FLASH_BASE_ADDR + 0x2D80000)
#define OS_FLASH_ABSOLUTE_BACKUP_NVRAM_SIZE         0x200000

/*  physical addr of  work area symbol   */
#define OS_FLASH_ABSOLUTE_WORK_AREA_SYMBOL_ADDR     (FLASH_BASE_ADDR + 0x3000000)

/*  physical addr of backup area symbol */
#define OS_FLASH_ABSOLUTE_BACKUP_AREA_SYMBOL_ADDR   (FLASH_BASE_ADDR + 0x3020000)

#ifdef _USE_DATACARD
/*for cdrom*/
#define OS_FLASH_ABSOLUTE_USB_CDROM_BASE_ADDR       (FLASH_BASE_ADDR + 0x3100000)
#define OS_FLASH_ABSOLUTE_USB_CDROM_SIZE            0xC00000

/*for udisk*/
#define OS_FLASH_ABSOLUTE_USB_UDISK_BASE_ADDR       (FLASH_BASE_ADDR + 0x3D00000)
#define OS_FLASH_ABSOLUTE_USB_UDISK_SIZE            0x4000000


/*physical addr of system FS*/
#define OS_FLASH_ABSOLUTE_SYS_FS_BASE_ADDR          (FLASH_BASE_ADDR + 0x7E00000)
#define OS_FLASH_ABSOLUTE_SYS_FS_SIZE               0x200000

/*physical addr of user FS*/
#define OS_FLASH_ABSOLUTE_USER_FS_BASE_ADDR         (FLASH_BASE_ADDR + 0x8000000)
#define OS_FLASH_ABSOLUTE_USER_FS_SIZE              0x0
#else
/*for cdrom*/
#define OS_FLASH_ABSOLUTE_USB_CDROM_BASE_ADDR       (FLASH_BASE_ADDR + 0x3100000)
#define OS_FLASH_ABSOLUTE_USB_CDROM_SIZE            0x1D00000

/*for udisk*/
#define OS_FLASH_ABSOLUTE_USB_UDISK_BASE_ADDR       (FLASH_BASE_ADDR + 0x3100000)
#define OS_FLASH_ABSOLUTE_USB_UDISK_SIZE            0x1D00000

/*physical addr of system FS*/
#define OS_FLASH_ABSOLUTE_SYS_FS_BASE_ADDR          (FLASH_BASE_ADDR + 0x5100000)
#define OS_FLASH_ABSOLUTE_SYS_FS_SIZE               0x2800000

/*physical addr of user FS*/
#define OS_FLASH_ABSOLUTE_USER_FS_BASE_ADDR         (FLASH_BASE_ADDR + 0x7900000)
#define OS_FLASH_ABSOLUTE_USER_FS_SIZE              0x700000
#endif
#endif

#endif/*_NAND_FLASH_H*/

