/*********************************************************************
 Copyright 2007 by  ZTE Corporation.  
 *
 * FileName::    version.h
 * File Mark:  	
* Description:  
* Others:  	
* Version:  	v0.5
* Author:  	huji
* Date:  	2011-09-06
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  
* History 2: 
**********************************************************************/

#ifndef    _TSP_CONFIG_H
#define    _TSP_CONFIG_H

#include "oss_api.h"

/* 汾ŵĳȴ20չ40 */
#define TSP_VERSION_NUMBER_MAX_LEN   40


typedef  enum
{
    ON_STATE=0xFF,                
    OFF_STATE=0x0,
    ERR_STATE=0x55
}T_SYS_NV_FUN_CTRL_FLAG;

typedef  enum
{
    SHORT_INTERVAL=0x00,                
    LONG_INTERVAL=0x36,
    ERR_INTERVAL=0x55
}T_SYS_NV_DL_INTERVAL_CTRL_FLAG;

/************************************************************************/
/*                          Ƶʼ˿ں궨                        */
/************************************************************************/


typedef struct
{	
    UINT8 bootmode[2];
    /********************************************************************************
     ܣ    ϵͳģʽ
     ȡֵΧ{0x54,0x4D}(AMTģʽ){0x54,0x4D}(汾ģʽ)
     ֵ0xFFFF
    *********************************************************************************/
   
    CHAR   tspVersion[TSP_VERSION_NUMBER_MAX_LEN];
    /********************************************************************************
    ܣ   TSP    汾
    ȡֵΧַ,'\0'ʾ
    ֵɳ̾
    *********************************************************************************/
     CHAR   devName[TSP_VERSION_NUMBER_MAX_LEN];
    /********************************************************************************
    ܣ   豸
    ȡֵΧַ,'\0'ʾ
    ֵɳ̾
    *********************************************************************************/
     CHAR   hardwareVersion[TSP_VERSION_NUMBER_MAX_LEN];
    /********************************************************************************
    ܣ   Ӳ汾
    ȡֵΧַ,'\0'ʾ
    ֵɳ̾
    *********************************************************************************/
     T_SYS_NV_DL_INTERVAL_CTRL_FLAG    DLIntervalFlag; 
   /********************************************************************************
    ܣ    bootؿڿʱ־
    ȡֵΧ0x0(ʱ)0x36(ʱ)
    ֵ0xFF
    *********************************************************************************/

    /* ݶõԤλNVλΪ124ֽ */
    CHAR    reserve;

    T_ZOss_NvEccLog tEccLog;
    /********************************************************************************
    ܣ    ECC logϢ¼
    ȡֵΧʱ̬
    ֵ0x0
    *********************************************************************************/

	 //UINT8 atMode[2];
    /********************************************************************************
     1024ֽڿʼ2ֽڱʶAMTģʽǷAT
     ܣ ʾAMTģʽǷAT,bootmodeһжAMTģʽǷҪAT
     ȡֵΧ{0x41,0x54}(AMTģʽAT){0x41,0x54}(AMTģʽ½AMT)
     ֵ0xFFFF
    *********************************************************************************/
   
}T_SYS_NV_TSP_CONFIG;

/**************************************************************************
* Function: zSys_NvGetBootMode
* Description: get boot mode
* Parameters:
*   Input: bootmode
*   Output: bootmode
* Returns:  ZOSS_SUCCESS or ZOSS_ERROR
*
* Others: None
**************************************************************************/
UINT32 zSys_NvGetBootMode(UINT8 bootmode[]);

/**************************************************************************
* Function: zSys_NvSetBootMode
* Description: set boot mode
* Parameters:
*   Input:  bootmode
*   Output: None
* Returns:  ZOSS_SUCCESS or ZOSS_ERROR
*
* Others: None
**************************************************************************/
UINT32 zSys_NvSetBootMode(UINT8 bootmode[]);

/**************************************************************************
* Function: zSys_NvGetTspVersion
* Description: get the TSP software version number
* Parameters:
*   Input:
*              the buffer pointer to store the version number
*   Output: None
* Returns:  err code
*	        
* Others: None
**************************************************************************/
UINT32 zSys_NvGetTspVersion(CHAR * pVersion);

/**************************************************************************
* Function: zSys_NvSetTspVersion
* Description: set version number
* Parameters: the pointer to the version number
*   Input:  pVersion
*              None
*   Output: None
* Returns:  err code
*	        
* Others: None
**************************************************************************/
UINT32 zSys_NvSetTspVersion(CHAR * pVersion);

/**************************************************************************
* Function: zSys_NvGetBootFlag
* Description: get the bootflag to on/off the download ports
* Parameters:
*   Input:
*              None
*   Output: None
* Returns:  the value of bootflag or err code 
*	        
* Others: None
**************************************************************************/
T_SYS_NV_FUN_CTRL_FLAG  zSys_NvGetBootFlag(VOID);

/**************************************************************************
* Function: zSys_NvSetBootGlag
* Description:set  the bootflag to on/off the download ports
* Parameters:
*   Input:
*              boot funciton control flag
*   Output: None
* Returns:  err code 
*	        
* Others: None
**************************************************************************/
UINT32 zSys_NvSetBootFlag(T_SYS_NV_FUN_CTRL_FLAG flag);


/**************************************************************************
* Function: zSys_NvGetCdromFlag
* Description: get the flag to on/off the CDROM function
* Parameters:
*   Input:
*              None
*   Output: None
* Returns:  the value of bootflag
*	        
* Others: None
**************************************************************************/
T_SYS_NV_FUN_CTRL_FLAG  zSys_NvGetCdromFlag(VOID);

/**************************************************************************
* Function: zSys_NvSetCdromFlag
* Description: set the flag to on/off the CDROM function
* Parameters:
*   Input:
*              cdrom function control flag
*   Output: None
* Returns:  errcode
*	        
* Others: None
**************************************************************************/
UINT32 zSys_NvSetCdromFlag(T_SYS_NV_FUN_CTRL_FLAG flag);
/**************************************************************************
* Function: zSys_NvSetDevName
* Description: set device namer
* Parameters: the pointer to the device name
*   Input:  pDevName
*              None
*   Output: None
* Returns:  err code
*
* Others: None
**************************************************************************/
UINT32 zSys_NvSetDevName(CHAR * pDevName);
/**************************************************************************
* Function: zSys_NvGetDevName
* Description: get device name
* Parameters:
*   Input:
*              None
*   Output: None
* Returns:  the pointer to the version number
*
* Others: None
**************************************************************************/
UINT32 zSys_NvGetDevName(CHAR * pDevName);
/**************************************************************************
* Function: zSys_NvSetHardwareVersion
* Description: set HardwareVersion
* Parameters: the pointer to the device name
*   Input:  pDevName
*              None
*   Output: None
* Returns:  err code
*
* Others: None
**************************************************************************/
UINT32 zSys_NvSetHardwareVersion(CHAR * pHardwareVersion);
/**************************************************************************
* Function: zSys_NvGetHardwareVersion
* Description: get HardwareVersion
* Parameters:
*   Input:
*              None
*   Output: None
* Returns:  the pointer to the version number
*
* Others: None
**************************************************************************/
UINT32 zSys_NvGetHardwareVersion(CHAR * pHardwareVersion);
/**************************************************************************
* Function: zSys_NvGetDLIntervalGlag
* Description:get  the flag to short/long  download intervals
* Parameters:
*   Input:
*              none
*   Output: None
* Returns:  err code 
*	        
* Others: None
**************************************************************************/
UINT32 zSys_NvGetDLIntervalFlag (void);


/**************************************************************************
* Function: zSys_NvSetDLIntervalGlag
* Description:set  the flag to short/long  download intervals
* Parameters:
*   Input:
*              DL Interval funciton control flag
*   Output: None
* Returns:  err code 
*	        
* Others: None
**************************************************************************/

UINT32  zSys_NvSetDLIntervalFlag (UINT32 flag);
#endif  /* _TSP_CONFIG_H*/
