

#ifndef MS_CONFIG_H
#define MS_CONFIG_H


/* ---------------------------------------------------------------------------
 *  SNDCP - compression parameters
 * ---------------------------------------------------------------------------
 */

/* data compression capabilities V.42 bis
 */
#ifdef SNP_DC_COMPR_V42_BIS

#ifdef SDTENV

#define MS_SN_XID_DC_P0   3     /* compress directions : 0 - (3) */
#define MS_SN_XID_DC_P1   2048  /* maximum number of codewords : 512 - (2048) - ... */
#define MS_SN_XID_DC_P2   20    /* maximum number of chars : 6 - (20) - 250 */

#else

#define MS_SN_XID_DC_P0   3     /* compress directions : 0 - (3) */
#define MS_SN_XID_DC_P1   512   /* maximum number of codewords : 512 - (2048) - ... */
#define MS_SN_XID_DC_P2   6     /* maximum number of chars : 6 - (20) - 250 */

#endif /* SDTENV */

#else

#define MS_SN_XID_DC_P0   0
#define MS_SN_XID_DC_P1   0
#define MS_SN_XID_DC_P2   0

#endif /* SNP_DC_COMPR_V42_BIS */


/* TCP/IP header compression capabilities RFC1144 
 */
#ifdef TCP_HEADER_COMPR

#define MS_SN_XID_PC_S0_1 15   /* number of state slots : 0 - 15 */

#else

#define MS_SN_XID_PC_S0_1 0

#endif /* TCP_HEADER_COMPR */


/* ---------------------------------------------------------------------------
 *  SNDCP - LLC - IP-Relay contstants
 * ---------------------------------------------------------------------------
 */
#ifndef MS_OS_PP_DYNAMIC
#define MS_OS_PP_DYNAMIC 1
#endif

/* number of times to try SNDCP XID negotiation after invalid XID response
 */
#ifdef SDTENV

#define SN_XID_REQ_REPEAT_NO                     2
#define SN_XID_REQ_REPEAT_NO_SUSP               15

#else

#define SN_XID_REQ_REPEAT_NO                    10
#define SN_XID_REQ_REPEAT_NO_SUSP              360

#endif /* SDTENV */

/* pool sizes
 */
#ifdef SDTENV

#define MS_OS_POOL_BLOCK_SIZE                  5500

#if MS_OS_PP_DYNAMIC == 1

#define MS_OS_NSAPI_UL_GROUP_POOL_SIZE        15500
#define MS_OS_NSAPI_DL_GROUP_POOL_SIZE        14000
#define MS_OS_SAPI_UL_GROUP_POOL_SIZE         10030
#define MS_OS_SAPI_DL_GROUP_POOL_SIZE          7850

#else

#define MS_OS_NSAPI_UL_POOL_SIZE              15500
#define MS_OS_NSAPI_DL_POOL_SIZE              14000
#define MS_OS_SAPI_UL_POOL_SIZE               10030 
#define MS_OS_SAPI_DL_POOL_SIZE                7850 

#endif /* MS_OS_PP_DYNAMIC == 1 */

#else

#define MS_OS_POOL_BLOCK_SIZE                 5300 

#if MS_OS_PP_DYNAMIC == 1

#define MS_OS_NSAPI_UL_GROUP_POOL_SIZE        (1 * MS_OS_POOL_BLOCK_SIZE)
#define MS_OS_NSAPI_DL_GROUP_POOL_SIZE        (1 * MS_OS_POOL_BLOCK_SIZE)
#define MS_OS_SAPI_UL_GROUP_POOL_SIZE         (3 * MS_OS_POOL_BLOCK_SIZE)
#define MS_OS_SAPI_DL_GROUP_POOL_SIZE         (7 * MS_OS_POOL_BLOCK_SIZE)

#else

#define MS_OS_NSAPI_UL_POOL_SIZE              (1 * MS_OS_POOL_BLOCK_SIZE)
#define MS_OS_NSAPI_DL_POOL_SIZE              (1 * MS_OS_POOL_BLOCK_SIZE)
#define MS_OS_SAPI_UL_POOL_SIZE               (2 * MS_OS_POOL_BLOCK_SIZE)
#define MS_OS_SAPI_DL_POOL_SIZE               (3 * MS_OS_POOL_BLOCK_SIZE)

#endif /* MS_OS_PP_DYNAMIC == 1 */


#endif /* SDTENV */

/* ---------------------------------------------------------------------------
 *  Multislot Capabilities of the MS, used for configuration at compile time.
 * ---------------------------------------------------------------------------
 */

#if defined (MULTISLOT_CLASS)
/* special definition for L1 issues win */
#undef MULTISLOT_CLASS
#endif

/* Handling of MULTISLOT_CLASS:
 *
 * SMS00133857: ms_conifg.h: MULTISLOT_CLASS wrong defined
 *  The MULTISLOT_CLASS has to be set to 12 always if TU_CLASS12 is defined,
 *  independent to what MULTI_SLOT_CLASS_EGPRS and MULTI_SLOT_CLASS_GPRS are set !!!
 *  This is due the RF-driver implementation. Otherwise wrong PowerRamps will be used !!!
 *
 * SMS00134296: Differing GPRS and EGPRS classes are not supported by ms_config.h
 *  Tthe following configuration is not handled correctly:
 *  SYSTEM_DEFS += MULTI_SLOT_CLASS_EGPRS=5
 *  SYSTEM_DEFS += MULTI_SLOT_CLASS_GPRS=10
 *  Currently ms_config.h will set MAX_RX_TS to 2 in this case, which is obviously 
 *  incorrect for GPRS class 10. (Note that when EGPRS and GPRS classes differ, 
 *  usually the EGPRS class will be lower.)
 *  ms_config.h should be changed to use the maximum of the GPRS and EGPRS 
 *  classes for MULTISLOT_CLASS.
 */

#if defined (TU_CLASS12)

#define MULTISLOT_CLASS 12

#elif defined (MULTI_SLOT_CLASS_EGPRS) && defined (MULTI_SLOT_CLASS_GPRS)

#if MULTI_SLOT_CLASS_EGPRS > MULTI_SLOT_CLASS_GPRS
#define MULTISLOT_CLASS MULTI_SLOT_CLASS_EGPRS
#else
#define MULTISLOT_CLASS MULTI_SLOT_CLASS_GPRS
#endif

#elif defined (MULTI_SLOT_CLASS_EGPRS)

#define MULTISLOT_CLASS MULTI_SLOT_CLASS_EGPRS

#elif defined (MULTI_SLOT_CLASS_GPRS)

#define MULTISLOT_CLASS MULTI_SLOT_CLASS_GPRS

#else

#define MULTISLOT_CLASS 12

#endif

/* SMS-322015: max supported multislot classes for SGOLD-2 based platforms */
#define DTM_GPRS_MULTISLOT_CLASS  9
#define DTM_EGPRS_MULTISLOT_CLASS 9


#if MULTISLOT_CLASS >= 13 && MULTISLOT_CLASS <= 18
#  define MULTISLOT_CLASS_TYPE 2
#else
#  define MULTISLOT_CLASS_TYPE 1
#endif

#if   MULTISLOT_CLASS == 1
#  define MAX_RX_TS 1
#  define MAX_TX_TS 1
#  define SUM_RX_TX_TS 2
#  define TTA 3
#  define TTB 2
#  define TRA 4
#  define TRB 2
#elif MULTISLOT_CLASS == 2
#  define MAX_RX_TS 2
#  define MAX_TX_TS 1
#  define SUM_RX_TX_TS 3
#  define TTA 3
#  define TTB 2
#  define TRA 3
#  define TRB 1
#elif MULTISLOT_CLASS == 3
#  define MAX_RX_TS 2
#  define MAX_TX_TS 2
#  define SUM_RX_TX_TS 3
#  define TTA 3
#  define TTB 2
#  define TRA 3
#  define TRB 1
#elif MULTISLOT_CLASS == 4
#  define MAX_RX_TS 3
#  define MAX_TX_TS 1
#  define SUM_RX_TX_TS 4
#  define TTA 3
#  define TTB 1
#  define TRA 3
#  define TRB 1
#elif MULTISLOT_CLASS == 5
#  define MAX_RX_TS 2
#  define MAX_TX_TS 2
#  define SUM_RX_TX_TS 4
#  define TTA 3
#  define TTB 1
#  define TRA 3
#  define TRB 1
#elif MULTISLOT_CLASS == 6
#  define MAX_RX_TS 3
#  define MAX_TX_TS 2
#  define SUM_RX_TX_TS 4
#  define TTA 3
#  define TTB 1
#  define TRA 3
#  define TRB 1
#elif MULTISLOT_CLASS == 7
#  define MAX_RX_TS 3
#  define MAX_TX_TS 3
#  define SUM_RX_TX_TS 4
#  define TTA 3
#  define TTB 1
#  define TRA 3
#  define TRB 1
#elif MULTISLOT_CLASS == 8
#  define MAX_RX_TS 4
#  define MAX_TX_TS 1
#  define SUM_RX_TX_TS 5
#  define TTA 3
#  define TTB 1
#  define TRA 2
#  define TRB 1
#elif MULTISLOT_CLASS == 9
#  define MAX_RX_TS 3
#  define MAX_TX_TS 2
#  define SUM_RX_TX_TS 5
#  define TTA 3
#  define TTB 1
#  define TRA 2
#  define TRB 1
#elif MULTISLOT_CLASS == 10
#  define MAX_RX_TS 4
#  define MAX_TX_TS 2
#  define SUM_RX_TX_TS 5
#  define TTA 3
#  define TTB 1
#  define TRA 2
#  define TRB 1
#elif MULTISLOT_CLASS == 11
#  define MAX_RX_TS 4
#  define MAX_TX_TS 3
#  define SUM_RX_TX_TS 5
#  define TTA 3
#  define TTB 1
#  define TRA 2
#  define TRB 1
#elif MULTISLOT_CLASS == 12
#  define MAX_RX_TS 4
#  define MAX_TX_TS 4
#  define SUM_RX_TX_TS 5
#  define TTA 2
#  define TTB 1
#  define TRA 2
#  define TRB 1

/* etc. pp. */
#endif

/* ---------------------------------------------------------------------------
 * Settings of default context
 * ---------------------------------------------------------------------------
 */

#define MS_CONTEXT_DEFAULT 0  /* No longer supported. */

#endif /* MS_CONFIG_H */

