/*****************************************************************************
*  汾 (C)2013ͨѶɷ޹˾
*
*  ģ  uiccmng
*  ļ  uiccmain.h
*  ļʶ
*  ļ
*  ʵֹܣغݽṹ
*      
*  汾    
*  ڣ
*  ˵
 *****************************************************************************/

#ifndef    _UICCVCARD_H
#define    _UICCVCARD_H

/**************************************************************************
 *                        ͷļ                                      *
**************************************************************************/


/**************************************************************************
 *                        ݽṹ                                    *
**************************************************************************/
#ifdef Z_SIM_UICC
#include "src/nas/test/uiccnvdata/inc/uiccdrv.h"
#else
#include "drv_api.h"
#endif

/* Function used to exchange APDU with a card. The function will not return 
 * before the response APDU has beed received from the card or until the 
 * appropriate Working Timer has expired.
 *
 * \param   card_selector      (I)   Indicates which card the requested command is meant for.
 * \param   command_case    (I)   Indicates which of the four command cases the current 
 *                                command belongs to.
 * \param   extended_length (I)   Indicates the card support of the use of extended Lc/Le. 
 *                          The caller of this function has the responsibility of 
 *                          allocating the apdu_data store correcesponding to the 
 *                          larger of Lc and Le.\n
 *                          TRUE:  extended Lc/Le is supported. The max. Tx and Rx  
 *                                 data sizes are 65,535 and 65,536 bytes respectively.\n
 *                          FALSE: extended Lc/Le is NOT supported. The max. Tx and Rx  
 *                                 data sizes are 255 and 256 bytes respectively.
 * \param   c_apdu          (I)   The Command APDU containing: CLA, INS, P1, P2, Lc & Le.
 * \param   r_apdu          (O)   The Response APDU containing: Luicc, SW1 & SW2.
 * \param   apdu_data       (I/O) I: Holds Lc Tx-data to be sent to the card. 
 *                              O: Holds Luicc Rx-data received from the card.
 * return The result of the APDU command execution*/
typedef  T_ZDrvUicc_ApduReselt  (*T_PsVsim_ApduFunc) ( T_ZDrvUicc_CardSelector card_selector,
                                                                                                T_ZDrvUicc_CommandCase     tCmdCase, 
                                                                                                BOOL                         bExtLen,                  
                                                                                                T_ZDrvUicc_ApduHeader        tCApdu,  
                                                                                                T_ZDrvUicc_ApduFooter        *ptRApdu,                  
                                                                                                UINT8                        *pApduData);


/* Function used to reset the card. The function will not return until the reset
 * has been successfully carried out i.e. ATR string has been received or if no 
 * response to the reset is received i.e. IWT times out.
 * \param      card_selector       (I) Indicates which card needs to be activated/reset.
 * \return     The outcome of the activation handling.
 */
typedef  T_ZDrvUicc_ResetResult (*T_PsVsim_ResetFunc) (T_ZDrvUicc_CardSelector  tCardNum);

/*Function used to deactivat a given card.
 * \param    card_selector       (I) Indicates which card needs to be deactivated.
 * \return   The deactivation result.
 */
typedef  T_ZDrvUicc_CloseResult (*T_PsVsim_ColseFunc) (T_ZDrvUicc_CardSelector  tCardNum);

/* Function used to obtain the ATR string of the current operated card. If no card 
 * is active (or if data is not available) the number of characters returned will 
 * be set to zero.
 * \param  atr    Pointer to the store in which the ATR string should be located.
 * \return        Number of ATR characters.
 */
typedef  UINT8  (*T_PsVsim_GetAtr) (T_ZDrvUicc_CardSelector  tCardNum, UINT8 *atr);

/**************************************************************************
 *                                                            *
**************************************************************************/
VOID zPs_VsimRegTransPortApdu (T_PsVsim_ApduFunc  ApduFunc);
VOID zPs_VsimRegResetCard (T_PsVsim_ResetFunc ResetCardFunc);
VOID zPs_VsimRegClose (T_PsVsim_ColseFunc  ColseFunc);
VOID zPs_VsimRegGetAtr (T_PsVsim_GetAtr GetAtrFunc);

#endif
