/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 : ͨѶɷ޹˾ ֻҵ ƽ̨ܹ
*   ģ   : ATI2ģͷļ
*      : zati2_fnc.h
*   ļʶ : 
*   ļ : 
*   ʵֹ :   
*        : ChenYun
*        : 2.0
*    : 2008/02/25
*   ˵ : 
*
*   ޸ļ¼ : 
*        : 
*     ޸ĺ : 
*     ޸ : 
*        : 
*
***************************************************************************
*
*   ļ
*   ----------------
*   ATI2漰ͺͽӿڶ
*
*
**************************************************************************/
#ifndef ZATI2_FNC_H
#define ZATI2_FNC_H

#include "atipsint.h"
#include "ps/src/nas/ati/inc/zati_def.h"
#include "ps/src/nas/ati/inc/zat_api.h"
#include "drv_api.h"
#include "net_api.h"

#define ZATI2_BUFFER_LENGTH     1024
#define ZATI2_INVALID_CALL_ID   0xff  /* 0xffΪЧֵ */
#define ZATI2_INVAL_MMIA_INDEX  0xff  /* ЧIndex */
#define ZATI2_MUTI_VALID_CMD_MAX_NUM  9  
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
#define Z_ATI_INSTANCE_MAX_NUM  (BYTE)2
#define Z_ATI_INSNO_1              (BYTE)0
#define Z_ATI_INSNO_2              (BYTE)1
#else
#define Z_ATI_INSTANCE_MAX_NUM  (BYTE)1
#define Z_ATI_INSNO_1              (BYTE)0
#define Z_ATI_INSNO_2              (BYTE)Z_ATI_INSNO_1
#endif

#define ZATI_INVALID_MSGID   0xFFFFFFFF
typedef enum
{
    ZATI2_CHANNEL_TYPE_INVALID = 0,
    ZATI2_CHANNEL_TYPE_ATI1,
    ZATI2_CHANNEL_TYPE_ATI2,
    ZATI2_CHANNEL_TYPE_COUNT
}
T_ZAti_ChannelType;


typedef enum 
{
    ZATI2_CHANNEL_MODE_INVAL = 0,
    ZATI2_CHANNEL_MODE_CMD,
    ZATI2_CHANNEL_MODE_DATA,
    ZATI2_CHANNEL_MODE_COUNTT
}
T_ZAti_ChannelMode;

typedef enum 
{
    ZATI2_CHANNEL_DATA_TYPE_INVAL = 0,
    ZATI2_CHANNEL_DATA_TYPE_CSD, /* CS */
    ZATI2_CHANNEL_DATA_TYPE_PS,  /* PS */
    ZATI2_CHANNEL_DATA_TYPE_COUNTT
}
T_ZAti_DataType;

typedef enum 
{
    ZATI2_CMCC_DATACARD_MODE = 0,
    ZATI2_TSP_DATACARD_MODE,
    ZATI2_TSP_HANDSET_MODE,
    ZATI2__MODE_COUNT
}
T_ZAti_VersionMode;

typedef struct
{
    CHAR                      strData[ZATI2_BUFFER_LENGTH];
    UINT16                    iDataLen;
    UINT8                     iChannel;
}
T_ZAti_ChannelDataBuf;

typedef struct
{
    UINT8                     result;
}T_ZAti_NotifyApModemReady;  /* 617001591411 ܻ- ܻV3汾ͬʵ*/

typedef struct
{
    UINT8                      bTotalNum;
    UINT8                      bCurnum; /*ǰĸ */
    BYTE                       bPadding;
    UINT8                      bDtmf[ZAT2_MAX_VTS_LEN];
    DWORD                      dwDuration;
}
T_ZAti_CMCCVTS;

typedef struct 
{
    BYTE                arrData[ZATI2_BUFFER_LENGTH];
    UINT16              iLength;         /* T_ZAti_Buffer Ч */
}
T_ZAti_Buffer;

typedef struct T_zAti_ATCmdNode{
    BYTE * pbAtCmd;                                // '\0' β
    struct T_zAti_ATCmdNode * ptNext;
}T_zAti_ATCmdNode;


typedef struct {
    BYTE bAtCmdNum;
    T_zAti_ATCmdNode * ptAtCmdNode;
}T_zAti_ATCmdList;

typedef struct ChnelInfoNodeTag
{
    UINT8                        iChnelId;       /* ͨID */  //Ǽ뵽T_ZAti_ChannelInfoΪ򿪵ͨʲҪǷ򿪱־bOpen
    T_ZAt2_CmdIdType             cmd_id;         /* ǰ   */
    T_ZAt2_CmdOpType             cmd_op;         /* ״̬     */
    T_ZAt2_CmdInputInfo          cmdInputInfo;   /* ϢʽǷڵȴռݵı־ */

    UINT32                       iEvId;          /* ¼ǰϢID */
    UINT8                        server_id;      /* Ӧͨʶ */
    UINT8                        iSrcIndex;      /* ԴţȡֵΪͨ */
    UINT8                        iDestIndex;     /* Ŀ */
    BOOL                         checkAtOutLimit; /* atBuffǷ*/
    BOOL                         bIsCardIniting;
    BOOL                         IsPpp;
    BOOL                         IsCmdStored;/*ǨǷѾ*/
    T_ZAti_ChannelMode          server_mode;    /* ͨģʽģʽ */
    T_ZAti_DataType             dataType;       /* server_modeΪ̬ʱЧ */
    
    T_ZAti_Buffer               atBuff;         /* AT */
    T_zAti_ATCmdList         tAtCmdList;
    struct ChnelInfoNodeTag     *pNextCnNode;
}
T_ZAti_ChannelInfo;


typedef enum 
{
    ZATI2_TASK_STATUS_NULL = 0,
    ZATI2_TASK_STATUS_INIT,
    ZATI2_TASK_STATUS_READY,
    ZATI2_TASK_STATUS_BUSY
}
T_ZAti_TaskStatus;

typedef struct 
{
    UINT8                            iTaskInitTimes; /* ʼ */
    ZOSS_TASK_ID                taskIdMy;     /* ID */
    T_ZAti_TaskStatus          taskStatus;
    
    ZOSS_MUTEX_ID               mutexOpenChnel;    /* ͨҪȴ迼رգͨδر */
    T_ZAti2_AtRecvFunc          sendFnc;    
    T_zAti_AtChannelFunc        pUsolChannelFunc;  // עܻϱͨ
    ZOSS_MUTEX_ID               mutexGetOplPnn;   /*ȡеϢ*/
    T_zAti_AtChannelFunc pAlwaysReportChnel; /*עϱǷ/Ӱ죬ϱͨ*/
#ifdef DSDS_VSIM
    ZOSS_MUTEX_ID               mutexCrdStat;
#endif
}
T_ZAti_Context;

typedef struct 
{
    UINT8   iCount; /* ѾͨȡֵΪ1~180 */
    T_ZAti_ChannelInfo  *pChnelNode;
}
T_ZAti_ChanelList; /* Ѿ򿪵ͨͨбб */


typedef enum
{
    ZATI2_CALL_STATE_ACTIVE     = Z_APMMIA_CALLSTATE_ACTIVE, // 0,  
    ZATI2_CALL_STATE_HELD       = Z_APMMIA_CALLSTATE_HELD,   //1,  
    ZATI2_CALL_STATE_DIALING    = Z_APMMIA_CALLSTATE_DIALING, //2, 
    ZATI2_CALL_STATE_ALERTING   = Z_APMMIA_CALLSTATE_ALERTING, //3,
    ZATI2_CALL_STATE_INCOMING   = Z_APMMIA_CALLSTATE_INCOMING, //4,
    ZATI2_CALL_STATE_WAITING    = Z_APMMIA_CALLSTATE_WAITING, //5,
    ZATI2_CALL_STATE_NULL       = Z_APMMIA_CALLSTATE_END //ZPS_APMMIA_CALLSTATE_NULL //6,
}
T_ZAti_CallState; /* һ·绰ǰ״̬ */

//#define ZATI2_CHANNEL_ID_FOR_CC_MAN     (ZATI2_CHANNEL_ID_COUNT + 40)  /* iSrcCcManIndex ʼֵ */
#define ZATI2_INVAL_EXC_EV_ID           0xffffffff /* ЧiExcEvId */
#define ZATI2_INVAL_EVID                0xffffffff /* ЧiEvId */

typedef struct
{
    UINT8                       iSrcIndex; /* ൱ڱͨţiSrcCcManIndexӳ䣬ЭջCCֱӳϵ */
    //UINT8                       iSrcCcManIndex; /* CallControlManagement CALL IDЭջCCĿiDestIndexӳ */
    UINT8                       iDestIndex;
    UINT8                       iXid; /* ʼΪZATI2_INVAL_MMIA_INDEX,ɴCIDжǴ·ͨ */
    UINT8                       callState;
}
T_ZAti_CallInfo;

#define ZATI2_MAX_CALL_NUM          7   /* 7·绰 */

#define ZATI2_CALL_ID_BEGIN        241    /* ܹ7·241247Էֹͨsrcindexͻ */


typedef struct
{
    T_ZAti_CallInfo            callInfo[ZATI2_MAX_CALL_NUM]; /* ĵ绰7·8Ϊʱ֮ */
}
T_ZAti_CallControlManagement;

#define ZATI2_SMQRY_STATUS_ACT      Z_APMMIA_SM_PDP_ACTIVATE
#define ZATI2_SMQRY_STATUS_DEACT    Z_APMMIA_SM_PDP_DEACTIVATE
#ifdef R9_SUPPORT
typedef struct
{
    UINT8                    iType;  /* Primary-DNS-Address 0x81 Secondary-DNS-Address 0x83 */
    UINT8                    iLen;   /* DNSַ */
    UINT8                    arrDnsAddr[ZATI2_SM_IPV6_PDPADDR_LEN];  /* DNSַ */
}
T_ZAti_ExtIpcpOptionV6; /* reference RFC 1877, by cheny */

typedef struct
{
    UINT8                    iCodeFile;      /* 1~7 Configure-Request, Configure-Ack,Configure-Nak, Configure-Reject, Terminate-Request, Terminate-Ack, Code-Reject, by RFC1332*/
    UINT8                    iprotocolId;    /* protocol identifier, 24008 p418 */
    UINT16                   iContentLen;   /* PCO packet */
    T_ZAti_ExtIpcpOptionV6 PriDnsAddr;
    T_ZAti_ExtIpcpOptionV6 SecDnsAddr;
}
T_ZAti_ProtocolCfgOptV6;  /* Protocol configuration options; 24008-960 p510 */
#endif

typedef struct
{
    UINT8                    iType;  /* Primary-DNS-Address 0x81 Secondary-DNS-Address 0x83 */
    UINT8                    iLen;   /* DNSַ */
    UINT8                    arrDnsAddr[4];  /* DNSַ */
}
T_ZAti_ExtIpcpOption; /* reference RFC 1877, by cheny */

typedef struct
{
    UINT8                    iCodeFile;      /* 1~7 Configure-Request, Configure-Ack,Configure-Nak, Configure-Reject, Terminate-Request, Terminate-Ack, Code-Reject, by RFC1332*/
    UINT8                    iprotocolId;    /* protocol identifier, 24008 p418 */
    UINT16                   iContentLen;   /* PCO packet */
    T_ZAti_ExtIpcpOption    PriDnsAddr;
    T_ZAti_ExtIpcpOption    SecDnsAddr;
}
T_ZAti_ProtocolCfgOpt;  /* Protocol configuration options; 24008 p418 */

#ifndef IP_TYPE
#define IP_TYPE 0
#endif

#ifndef PPP_TYPE
#define PPP_TYPE 1
#endif
/**/
#define ZATI2_DATA_STATUS_NDIS     0
#define ZATI2_DATA_STATUS_PPP     1

#define ZATI2_PDPTYPE_PPP   Z_APMMIA_SM_PPP  
#define ZATI2_PDPTYPE_IPV4   Z_APMMIA_SM_IPV4 
#define ZATI2_PDPTYPE_IPV6   Z_APMMIA_SM_IPV6 

/* ṹ嶨 */
typedef struct {
    UINT8   iCid;
    UINT8   chnelId; /* ϴν̬ͨ */
    UINT8   extPdpType;
    BYTE    extActCid;/*ĸCID*/
    BOOL    isUsed;
    BOOL    isNdis;
    BOOL    isPpp;
    BOOL    isPppActCmplete;/*pppŵļǷ*/
    BYTE    bMastCidState;/*˫ջȥʱCID״̬0:ʾûյȥ1:յȥ*/
}T_ZAti_LastCidTab;

typedef struct 
{
//--    UINT8                                   DataReqchnelId; 
    BYTE                                    bDualStackActResult;/*¼˫ջݴCID*/
    T_ZAti_LastCidTab                       lastCidTab[ZATI2_SM_MAX_SMCID_NUM]; /* ¼ϴν̬ͨ CID */
}T_ZAti_SmContext;

typedef struct 
{
    T_zEM_EmInfo_Ind *ptEmInfo;
    DWORD dwReqCount;/**/
}T_ZAti_EmInfo;

typedef struct 
{
    ZOSS_SEMAPHORE_ID semaphoreEmInfo;/*ӿڻȡģʽϢź*/
}T_ZAti_EmInfoSemaphore;

typedef struct 
{
    ZOSS_MUTEX_ID mutexEmInfo;   /*ӿڻȡģʽϢĻ*/
}T_ZAti_EmInfoMutex;

typedef struct
{
    UINT32                    iEvId;
    BOOL  (* HandleFun)(UINT8 *pDataPtr, UINT16 iDataLen); 
}
T_ZAti_HandleMmiaMsgWithoutChnelNode;

typedef struct
{
    UINT32                    iEvId;
    BOOL  (* HandleFun)(UINT8 *pDataPtr, UINT16 iDataLen, T_ZAti_ChannelInfo *pChnelNode); 
}
T_ZAti_HandleMmiaMsgWithChnelNode;

typedef struct
{
    UINT32                    iEvId;
    SINT32  (* HandleFun)(UINT8 *pDataPtr, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen, T_ZAti_ChannelInfo *pChnelNode, T_ZAti_ChannelId channelId); 
}
T_ZAti_HandleMmiaMsgSendAtCnf;
typedef enum /* ָʾŷͷ */
{
    ZATI2_TO_SERIAL = 0,
    ZATI2_TO_MMIA = 1
}
T_ZAti_DERECTION;

typedef struct
{
    DWORD dwMsgId; //ϢID
    BYTE bDestTak; //Ŀģ
   /* BYTE bDestTakFg; */     /*ΪZ_INVALIDdestTask ΪzAti_GetTaskIndexȡģ
                                              ΪVALIDdestTaskΪеbDestTak*/
}
T_ZAti_MsgTrnsprncy;

typedef struct
{
    UINT32 iDecEvId;
    UINT8 *pDecEvBody;
    UINT16 iDecEvBodyLen;
    T_ZAti_ChannelInfo *pChnelNode;
}
T_ZAti_CmccStart;


/*⴦Ϣ */
typedef struct  
{
    DWORD  dwMsgId;                                            /* Ϣʶ */
    DWORD (* pPreHandleMsg)(VOID *pbMsgData, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);                         /* Ӻָ */
}
T_zAti_PreOuterMsgTab;

typedef struct  /* Ԫؽṹ */
{
    UINT32  iMsgId;                                            /* Ϣʶ */
    VOID (* pEndFnc)( VOID* pBuff );                         /* Ӻָ */
}
T_zAti_NonReportMsg;

typedef struct
{
  UINT32    i[2];          
  UINT32    buf[4];        
  UINT8     in[64];        
  UINT8     digest[16];    
}T_zAti_Md5Ctx;

/******************************************************************************************************************************************/
/**************************************************************************
* ƣ zAti_TaskEntry
*  ATI2ں
* ˵ (IN) 
*            state          ״̬
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ ͨ/ݣ͸
             շ㷢Ϣ/ݣ͸ͨ
**************************************************************************/
VOID zAti_TaskEntry(UINT8 iState, UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData);

/**************************************************************************
* ƣ zAti_TaskInit
*  ڳʼ״̬Ĵ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_TaskInit(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData);

/**************************************************************************
* ƣ zAti_TaskWork
*  ڹ״̬Ĵ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_TaskWork(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData);

/**************************************************************************
* ƣ zAti_InitQueryReq
*  ѯSMSģʽ
* ˵ (IN) 
*            (OUT)
*   ֵ ɹTRUEʧܷFALSE
* ˵ 
*            ʼʱʹ, +CMGF? 
**************************************************************************/
BOOL zAti_InitQueryReq(VOID);

/**************************************************************************
* ƣ zAti_InitQueryCnf
*  ZATI2ʼʱMMIAϢѯAT2ҪȫʹõNVӦ
* ˵ (IN):
*             iQryCnfEvId:       ѯӦϢ
*             pQryCnfEvBody:     ѯӦϢṹ
*            (OUT):
*   ֵ 
* ˵ ʼʱʹ
**************************************************************************/
VOID zAti_InitQueryCnf(UINT32 iQryCnfEvId, VOID *pQryCnfEvBody, UINT16 iDataLen);


/**************************************************************************
*  : zAti_RecvCommandInd
*  : յϱϢ
* ˵ (IN) 
*            taskId         ID
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_RecvCommandInd(UINT8 *pDataPtr, UINT16 iDataLen);

/**************************************************************************
* ƣ zAti_RecvServerHandlerSlaver
*  ΪATI2(ЭջATI)Ϣ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_RecvServerHandlerSlaver(DWORD iEvId, UINT8 *pDataPtr, UINT16 iDataLen);
#ifdef Z_DUALCARD_ADAPT 
VOID zAti_HandleDualCardSelfAdapt(VOID);
#endif
/**************************************************************************
* ƣ zAti_DecMultiCmd
*  ͨеڵ
* ˵ (IN) 
*            pChnelNode          ͨڵ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_DecMultiCmd(T_ZAti_ChannelInfo * pChnelNode);

/**************************************************************************
*  : zAti_Switch
*  : лͨ״̬CS̬лΪ̬
* ˵ : (IN)
*            iChnelId     ͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ṩûӿ,֧CS̬л
*            ܽͨ
*            ͬһܹͨر
**************************************************************************/
SINT32 zAti_Switch(T_ZAti_ChannelInfo *pChnelNode, T_zAti2_CtrmChInd iFlag);


/**************************************************************************
*  : zAti_GetChannelIdByIndex
*  : ͨŻͨ
* ˵ (IN) 
*            iEvId          ϢID
*            iMmiaSrcIndex       mmiaԴ
*            iMmiaDestIndex      mmiaĿ
*            (OUT)
*            pChannelId         ҵͨ
*   ֵ : ɹָͨ룬ʧܷNULL
* ˵ : 1) Ҫƽ̨ATI֤ͨʹõȷ  
*            2) ͨţҵͷЧͨţΪЧͨ 
*            3) MMIAԴſܷЧֵ0xffCCϢʱ
*            4) PS_CCԴŲǹ̶ӳ䣬ǰ˳ѡԴŵ
*            5) ҪMMIAԴЧԽжϣ򵱲䷵0xffΪԴ
**************************************************************************/
T_ZAti_ChannelInfo * zAti_GetChannelIdByIndex(UINT32 iEvId, const BYTE iMmiaSrcIndex, BYTE iMmiaDestIndex, UINT8 *pChannelId);

/**************************************************************************
* ƣ zAti_ZpodwReqProc
*  ûAT+ZPODWPPPǷ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_ZgdataTestSetReq
**************************************************************************/  
DWORD zAti_ZpodwReqProc(VOID *pDataPtr);

/**************************************************************************
* ƣ zAti_BoardnumReqProc
*  ûAT+BOARDNUMPPPǷ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_BoardnumSetReq
**************************************************************************/  
DWORD zAti_BoardnumReqProc(VOID *pDataPtr);

/**************************************************************************
* ƣ zAti_BoardnumQueryReqProc
*  ûAT+BOARDNUMPPPǷ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_BoardnumQuerySetReq
**************************************************************************/  
DWORD zAti_BoardnumQueryReqProc(VOID *pDataPtr);

/**************************************************************************
* ƣ zAti_ProdtestReqProc
*  ûAT+PRODTESTûȡԱ־λ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_ProdtestReq
**************************************************************************/  
DWORD zAti_ProdtestReqProc(VOID *pDataPtr);

/**************************************************************************
* ƣ zAti_ZflagSetReqProc
*  ûAT+ZFLAGӦ豸Ƿ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_Zflag_Req
**************************************************************************/  
DWORD zAti_ZflagSetReqProc(VOID *pDataPtr);
VOID zAti_ZflagSetReqProcContent(PBYTE pbResult, BYTE bFac, BYTE  bValue);

/**************************************************************************
* ƣ zAti_ZflagQueryReqProc
*  ûAT+ZFLAGѯӦ豸Ƿ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_ZflagQueryReq
**************************************************************************/  
DWORD zAti_ZflagQueryReqProc(VOID *pDataPtr);

/**************************************************************************
* ƣ zAti_ZmodeswitchSetReqProc
*  ûAT+ZMODESWITCHõǰ汾ģʽ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/  
DWORD zAti_ZmodeswitchSetReqProc(VOID *pDataPtr);

/**************************************************************************
* ƣ zAti_ZsetactSetReqProc
*  ûAT+ZSETACTõǰ汾ģʽ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/  

/**************************************************************************
* ƣ zAti_ZsetSetReqProc
*  ûAT+ZSETõǰ汾ģʽ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/  
DWORD zAti_ZsetSetReqProc(VOID *pDataPtr);

VOID zAti_ZsetSendCnf(T_ZAti_Zset_Req * pZSetReq);
#ifdef USE_VOICE_SUPPORT
BOOL zAti_CcMsgProc(DWORD *pEvId, UINT8 *pEvData, WORD *pDataLen, T_ZAti_ChannelInfo *pChnelNode);
#endif
/**************************************************************************
*  : zAti_GetServerIndex
*  : ͨͨŻȡϢ
* ˵ (IN) 
*            iEvId          ϢID
*            pEvData        Ϣ
*            iDataLen        Ϣ峤
*            iChnnel        ͨ
*            (OUT)
*            pEvData        Ϣ
*   ֵ : ɹZATI2_SUCCESSʧܷشͣ
* ˵ : Ҫ㱣֤ŵȷ  
*            ATI2--->MMIA ֻXXX_REQ  Ϣ  
*            ӦյCCͨSMʱͷ()ͨiDestIndexֵ
**************************************************************************/
VOID zAti_GetServerIndex(UINT32 iEvId, UINT8 *pEvData, T_ZAti_ChannelInfo *pChnelNode);
#ifdef USE_VOICE_SUPPORT
/**************************************************************************
*  : zAti_UsbSioGetCcManIndex
*  : USBתģʽ£ͨͨŻȡпϢ
* ˵ (IN) 
*            iSrcIndex      Դţͨ
*            iEvId          ϢID
*            pEvData        Ϣ
*            iDataLen        Ϣ峤
*            pChnelNode      ͨڵ
*            (OUT)
*            pDestIndex     Ŀ
*            pSrcCcManIndex     CC
*   ֵ : ɹZATI2_SUCCESSʧܷشͣ
* ˵ : 
*            ע·ʱ
*            1ZATI2_SUCCESSſԼִУϢЭջ
*            2ZATI2_FALSEӦֹϢЭջ
*            3 pChnelNodeʹýеcmd_idabortӰ
**************************************************************************/
SINT32 zAti_UsbSioGetCcManIndex( const UINT32 iEvId, UINT8 *pDestIndex, const T_ZAti_ChannelInfo *pChnelNode);
#endif

/**************************************************************************
* ƣ zAti_StoreAtCmd
*  յAT浽ATIĻ
* ˵ (IN) 
*            recvCmdInd       յATĽṹ
*            chnelNode        ͨ
*            (OUT)
*   ֵ : ɹ/ʧ
* ˵ ̽
**************************************************************************/
BYTE zAti_StoreAtCmd(const T_ZAti_ChannelDataBuf *recvCmdInd, T_ZAti_ChannelInfo *pChnelNode);


/******************************************************PDP************************************************************************************/

/**************************************************************************
* ƣ zAti_UsbSioGetChange
*  8λIPַʽΪ32λַ
* ˵ (IN) 
*            pSrcAddr       8λʽ
*            (OUT)
*   ֵ 32λʽֵ
* ˵ 
*            Ҫע
**************************************************************************/  
UINT16 zAti_UsbSioGetChange(UINT8 *pSrcAddr);

/**************************************************************************
* ƣ zAti_UsbSioSmIpPdpActReq
*  PDPATI2
* ˵ (IN) 
*            iCid   輤CIDֵȡֵͬAT+CGDCONT
*            (OUT)
*   ֵ ɹZATI2_SUCCESS򷵻ش
* ˵ 
*            ӦCONNECT֮ǰв
*            ṹT_zPS_ApMmia_SmHandle_Req
**************************************************************************/   
//UINT32 zAti_UsbSioSmIpPdpActReq(const UINT8 iCid);
VOID  zAti_GetIpcpOptionsInfo(T_ZAti_ProtocolCfgOpt * pIpcpOptions, UINT16 IpcpLen);
VOID zAti_GetIpcpPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE bNum, T_ZAti_ProtocolCfgOpt * pIpcpOptions,
            UINT16 IpcpLen,T_zMmiaSm_GetPco_Rsp   *pSmGetPcoRsp);
VOID zAti_GetPapPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE bNum,T_zMmiaSm_GetPco_Rsp   *pSmGetPcoRsp, PBYTE pbIndex);
/**************************************************************************
* ƣ zAti_UsbSioAddPcoPacketRsp
*  PDP󼤻ʱҪPCO
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģ
**************************************************************************/  
//--VOID zAti_UsbSioAddPcoPacketRsp(UINT8 *pDataPtr, UINT16 iDataLen);

/**************************************************************************
* ƣ zAti_UsbSioGetAddr
*  8λIPַʽΪ32λַ
* ˵ (IN) 
*            pSrcAddr       8λʽ
*            (OUT)
*   ֵ 32λʽֵ
* ˵ 
*            Ҫע
*            úֻڴģʽµ
**************************************************************************/  
UINT32 zAti_UsbSioGetAddr(UINT8 *pSrcAddr);

/**************************************************************************
* ƣ zAti_UsbSioSmZgipdnsInd
*  IP/DNSַָ֪ͨʾϢ
* ˵ (IN) 
*            iAtiIndex       ATI2
*            iMmiaIndex       MMIA 
*            (OUT)
*   ֵ 
* ˵ 
*            ӦCONNECT֮ǰв
*            ûҪãΪATI2Ҫ
**************************************************************************/   
VOID zAti_UsbSioSmZgipdnsInd(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf, UINT8* pSrc);
/**************************************************************************
* ƣ zAti_PppTransCidAndSendActReq
*  ATD/CGDATAAct_ReqϢת
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
**************************************************************************/  
DWORD zAti_PppTransCidAndSendActReq(VOID *pDataPtr);

DWORD zAti_SmDisconnectReq(VOID* pBuff);
DWORD zAti_ZepcgReq(VOID* pBuff);
/***************************************************************************************
:zAti_PppTransCid
:ATD/CGDATAAct_ReqϢCIDϢת
***************************************************************************************/
BOOL zAti_PppTransCid(T_zApMmia_SmActDeact_Req* pAct, 
T_zMmiaSm_DataState_Req* pDataStateReq, PBYTE pbPdpType);
/**************************************************************************************
:zAti_GetMoIdelCid
:ATD/CGDATAЯCIDתCGACTӿȥ
**************************************************************************************/
BOOL zAti_GetMoIdelCid(T_zApMmia_SmActDeact_Req* pAct, PBYTE pbPdpType);
BOOL zAti_GetMtIdleCid(BYTE bType, PBYTE pbCid);
BOOL zAti_SaveCidTab(UINT8 iCid, UINT8 chnelId);
/***********************************************************************************
:zAti_SaveContextInfoAndSendActReq
:άCIDͨϢ,ͼ
***********************************************************************************/
VOID zAti_HandleNoCarrierCnf(BYTE bSrcIndex, BYTE bDesIndex);
VOID zAti_HandleConnInd(BYTE bSourceIndex, BYTE bDestIndex);
BOOL zAti_CheakCidAndGetPdpType(BYTE bCid, PBYTE pbPdpType);
BOOL zAti_SaveContextInfoAndSendActReq(T_zApMmia_SmActDeact_Req* pAct, BYTE bPdpType);
VOID zAti_CgevMtConnect(BYTE bCid);


BOOL zAti_IsDataStatus(BYTE bCid);
BOOL zAti_IsRelatSecContxDataStat(BYTE bPreCid, PBYTE pbChnelId, PBYTE pbType);
VOID zAti_CrInd (BYTE bSrcIndex, BYTE bDesIndex, BYTE bServ, BYTE bCallId);

/**************************************************************************
* ƣ zAti_UsbSioSmDataStateReq
*  ̬ʹAT+CGDATA
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            ӦCONNECT֮ǰвҪ鵱ǰǷѾ
*            ṹzPS_ApMmia_SmDataState_Req
**************************************************************************/  
//-- BOOL zAti_UsbSioSmDataStateReq(UINT8 *pDataPtr);
/**************************************************************************
* ƣ zAti_UsbSioSmSetParamReq
*  PDPģ¼ָʾCID
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            עCIDӳϵ
*            ṹT_zPS_ApMmia_SmSetParam_Req
**************************************************************************/  
VOID zAti_UsbSioSmSetParamReq(UINT8 *pDataPtr, UINT16 iDataLen);

/**************************************************************************
* ƣ zAti_UsbSioSmMtActAnsReq
*  AT+CGANSӦMTPDP
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            עCIDӳϵṹT_zPS_ApMmia_SmMtActAns_Req
**************************************************************************/  
BOOL zAti_UsbSioSmMtActAnsReq(VOID *pDataPtr);

/**************************************************************************
* ƣ zAti_UsbSioSmActiveReqVirtueChnel
*  ڵǰģʽΪͨʱʹ
* ˵ (IN) 
*            (OUT)
*   ֵ 
* ˵ 
*            ӦCONNECT֮ǰв
*            ṹT_zPS_ApMmia_SmHandle_Req
**************************************************************************/  
VOID zAti_UsbSioSmActiveReqVirtueChnel(VOID);

/**************************************************************************
* ƣ zAti_UsbSioSmHandleCnfProcVirtueChnel
*  ͨ£ûмĴ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            ϱIP/DNSַ֪ͨϱCONNECTӦ
**************************************************************************/  
VOID zAti_UsbSioSmHandleCnfProcVirtueChnel(UINT8 *pDataPtr, UINT16 iDataLen);


/**************************************************************************
* ƣ zAti_UsbSioSmMtQueryIdleChInd
*  SM/MMIAATI2ѯͨ״ָ̬ʾ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            һ˵(MT)󼤻ʱŻдϢϱ
*            ZPS_ApMmia_SmQueryIdleChInd_EvΪϢ
**************************************************************************/  
VOID zAti_UsbSioSmMtQueryIdleChInd(VOID *pDataPtr); /* 0107 */

/**************************************************************************
* ƣ zAti_UsbSioSmOpenChInd
*  ָͨʾ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            T_zPS_ApMmia_SmOpenCh_Ind
**************************************************************************/  
//--UINT8 zAti_UsbSioSmOpenChInd(VOID *pDataPtr); /* 0514 */

/**************************************************************************
* ƣ zAti_UsbSioDeactiveByAti2Req
*  ͨATI2ȥ̡
* ˵ (IN) 
*            iChnelId     ͨID
*            (OUT)
*   ֵ 
* ˵ 
*            ֻڳɹ̬󣬶Ͽ̬ȥͨ
*            עĸʽ֮ģT_zPS_ApMmia_SmActDeact_Req
**************************************************************************/  
VOID zAti_UsbSioDeactiveByAtiReq(UINT8 iChnelId);

/**************************************************************************
*  : zAti_GetChannelNodePtr
*  : ȡͨͬĽ㣬ͬʱؽָ
* ˵ : (IN)
*            iChnelId     ҪҵĿͨID
*            (OUT)
*   ֵ : ɹظýָ룬ʧܷNULL
* ˵ : ͨţеĽָ
**************************************************************************/
T_ZAti_ChannelInfo * zAti_GetChannelNodePtr(UINT8 iChnelId);

/**************************************************************************
*  : zAti_GetChannelNodePtrByMmiaSrcIndex
*  : ȡͨͬĽ㣬ͬʱؽָ룬ͨMMIAԴвҵ
* ˵ : (IN)
*            iMmiaSrcChnelId     ҪҵMMIAԴ
*            (OUT)
*   ֵ : ɹؽָ룻ʧܷNULL
* ˵ : ͨţеĽָ
*            һ˵ͨMMIAĿŲҲˣŵúв
**************************************************************************/
T_ZAti_ChannelInfo * zAti_GetChannelNodePtrByMmiaSrcIndex(UINT16 iMmiaSrcChnelId);


/**************************************************************************
*  : zAti_GetChannelNodePtrByMmiaDestIndex
*  : ȡͨͬĽ㣬ͬʱؽָ,ͨMMIAĿвҵ
* ˵ : (IN)
*            iMmiaDestChnelId     ҪҵMMIAĿ
*            (OUT)
*   ֵ : ɹؽָ룻ʧܷNULL
* ˵ : ͨţеĽָ
*            βΪջ255
*            Ŀ൱ATI2ͨ
**************************************************************************/
T_ZAti_ChannelInfo * zAti_GetChannelNodePtrByMmiaDestIndex(BYTE iMmiaDestChnelId);

/**************************************************************************
*  : zAti_GetChannelNodePtrBystate
*  : ͨͬĽ㣬ͬʱؽָ룬ͨͨ״̬
* ˵ : (IN)
*            iChnelId     ҪҵĿͨID
*            (OUT)
*   ֵ : ɹظýָ룬ʧܷNULL
* ˵ : ͨţеĽָ
**************************************************************************/
T_ZAti_ChannelInfo * zAti_GetChannelNodePtrByState(T_ZAti_DataType dataType);

/**************************************************************************
*  : zAti_GetChannelNode
*  : ȡͨͬĽ
* ˵ : (IN)
*            iChnelId     ҪҵĿͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ͨţ
**************************************************************************/
SINT32 zAti_GetChannelNode(UINT8 iChnelId);


/**************************************************************************
*  : zAti_AddChannelToList
*  : رͨ
* ˵ : (IN)
*            iChnelId     ҪӵĿͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ͨţ
**************************************************************************/
SINT32 zAti_AddChannelToList(UINT8 iChnelId);

/**************************************************************************
*  : zAti_DelChannelInList
*  : ͨɾ
* ˵ : (IN)
*            iChnelId     ҪɾĿͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ͨţɾرͨʱʹ
**************************************************************************/
SINT32 zAti_DelChannelInList(UINT8 iChnelId);
VOID zAti_DeliverAllMsg(UINT32 iEvId, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen);
VOID zAti_Init_CmdInfo(T_ZAt2_CmdInputInfo * pCmdInputInfo);
#ifdef USE_VOICE_SUPPORT
VOID zAti_DeliverCendInd(VOID);
#endif
BYTE zAti_GetTaskInstantByChnlId(BYTE bChnlId);
BYTE zAti_GetTaskInstantIndexByTaskId(UINT32 iEvId, UINT8 *pDataPtr, ZOSS_TASK_ID tSendTaskId);
BOOL zAti_IsExCid(BYTE extActCid,PBYTE pbCid);
BOOL zAti_IsLastCidOfChnnel(BYTE bCid, BYTE iChannel);
BOOL zAti_IsAllExCid(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf);
BOOL zAti_IsMastCid(BYTE bMastCid,PBYTE pbExtCid);
BOOL zAti_IsSingleCard(VOID);
void zAti_ProcError(T_ZAti_ChannelInfo *pChnelNode, DWORD dwErrorCause);
/**************************************************************************
* ƣ zAti_LteZconstatInd
*  RNDISӶϿʱϱ
* ˵ (IN) 
*            iResult       ״̬

*   ֵ 
* ˵ 
*            
**************************************************************************/  
VOID zAti_ClearCidInfobyChnel(UINT8 ChnelId);
VOID zAti_LteZconstatInd(UINT8 iResult,UINT8 channelId);
BOOL zAti_SmIpPdpActReq(UINT8 iChnelId, T_ZAti_SmIpDnsInfo* pAddr);
BOOL zAti_GetPdpInfoByCid(UINT8 bCid,T_zMmiaSm_PdpAddr * pPdpAddr,T_zMmiaSm_PcoInfo * pPcoInfo, BYTE bInsNo);
BOOL zAti_IsTheCidActived(UINT8 bInsNo, UINT8 bCid);
BOOL zAti_SmGetPdpAddrByCid(UINT8 iCid, T_ZAti_SmIpDnsInfo* pAddr, BYTE bExtActCid, BYTE bInsNo);
VOID zAti_SendCgactDeactReq(T_zApMmia_SmActDeact_Req *ptDeactReq, BYTE bInsNo);
#ifdef CXT_MOV
DWORD zAti_SendContextInd(T_zMmiaSm_Context_Cnf* ptContextCnf, BYTE bInsNo);
VOID zAti_GetUmmPsContext(T_zMmiaSm_Context_Cnf  *ptContextCnf);
#endif
T_ZAti_ChannelInfo * zAti_GetFirstChannelNodePtrByInstance (BYTE bInstance);
BYTE zAti_GetChnelIndState(BYTE bChnelId);
BOOL zAti_IsLastUsedCid(BYTE bUsedCid);
VOID zAti_ClearPcoChapByCid(BYTE bCid);
VOID zAti_GetMd5Hash(CHAR id, CHAR* secret, UINT8 secretLen, CHAR* challenge, UINT8 challengeLen, CHAR* hashOut);
VOID zAti_SmSaveIpAddr(T_ZAti_SmIpDnsInfo* pAddr, T_zMmiaSm_PdpAddr *pdpAddr, T_zMmiaSm_PcoInfo *pcoInfo);
VOID zAti_SendEncData(T_ZAti_ChannelInfo *pChnelNode, BYTE* pStrCmd, DWORD dwMsgId, VOID* pBuff);
/******************************************************************************************************************************************/
 
#endif

