#ifndef _SCTTYPES_H
#define _SCTTYPES_H

#ifdef _OS_LINUX
#include <linux/string.h>
#else
#include <string.h>
#endif
#include "oss_api.h"  /* ƽ̨ܹOSϵͳ */
#ifdef _OS_OSE
#include "ose.h"         /* ose API set_pri() */
#endif

#include "pub.h"  
#include "base_api.h"
#include "proc_id.h"
#include "sig_code.h"
//#include "ms_cfg.h"


extern VOID * ps_calloc ( size_t, size_t );
extern VOID * ps_malloc ( size_t );
extern VOID * zrealloc( void *, size_t );
extern VOID   ps_free   ( void * );

#define xAlloc(_size)   ps_malloc( (_size) )
#define xFreeBlock(_mem)     ps_free( (_mem) )
#define xFree(_mem)                                                         \
    {                                                                       \
        barrier();                                                          \
        ps_free( *((void **)(_mem)) );                                      \
        *((void **)(_mem)) = NULL;                                          \
    }
#define xCAlloc(_size)  ps_calloc( 1, (_size) )
#define xReAlloc(_mem, _size)  zrealloc( ((void *)_mem), (_size) )

/*Name:KangShuJie Date:2007.01.28 Reason:ϵͳ*/
#ifdef _OS_WIN
#define set_pri(pri) zOss_SetThreadPri(zOss_GetCurThreadID(),pri)
#endif
/*End KangShuJie*/


#define ICU_set_current_prio(pri)    zDrv_MaskIntByPri(pri)   /*set_pri(pri)*/


#ifndef MAX
#define MAX(A,B) ( (A) > (B) ? (A) : (B) )
#endif

#define UNSIGNED_PER_PTR ( sizeof ( UNSIGNED ) / sizeof ( void * ) )
#ifndef NULL
#define NULL ( (void *) 0 )
#endif

#ifndef Null
#define Null()  0
#endif


#define Ref2VStarStar(P)  ((VoidStarStar)P)
#define XXMALLOC(_size)  xAlloc(_size)

#define XALLOC(SIZE,SORTIDNODE)  xAlloc(SIZE)
#define XFREE(P,SIZE)            xFree(P)
#define XCALLOC(SIZE,SORTIDNODE) xCAlloc(SIZE)

#if defined(NEAR)
#undef NEAR
#endif

#if defined(FAR)
#undef FAR
#endif

//#if defined(_C166)
//#define NEAR near
//#define FAR  far
//#else
#define NEAR
#define FAR

#define huge
#define shuge
#define stackparm
#define _at(A)
#ifdef _USE_CMPL_GCC
#define _nop()  asm("nop"); 
#else
#define _nop() __asm{ NOP }
#endif
//#endif



#define SDL_TIMER_WITH_PARA

#define XNOSTATICSTRUCTURE
#define XNOUSEOFREAL
#define XNOUSEOFSERVICE

#define X_COMPACT_BOOL


/*----------------------------------------------------------------------------
 * MACRO: DEBUG
 * USGAE: ENABLE DEBUGGING PRINTING FROM EACH SDL CONCEPT MAPPING ENTITY
 * DATE:  9-1-93
 *--------------------------------------------------------------------------*/
/* #define XOS_TRACE  */
#define XOS_INCLUDE


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *      General macros
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*---------------------------------------------------------------------------
 * If ANSI function prototypes
 *      then XPP(x) defined as x
 * else If old style functions
 *      then define XPP(X) as () and
 *      XNOPROTO should be defined
 *--------------------------------------------------------------------------*/
/* #define XPP(x) () */
/* #define XNOPROTO */
#define XPP(x)  x
#define XPQ(x)

#define XCONST const
#define XCONST_NOPART const
#define XCONST_COMP const
#define COMMENT(COMMENT)

/*---------------------------------------------------------------------------
 * xptrint should be the same length as a pointer
 * xint32 should be 32-bits int type
 * xIdNode is a dummy type
 *--------------------------------------------------------------------------*/
#define xptrint unsigned
#define xint32  unsigned long

typedef struct xPrsStruct  *xPrsNode;
typedef struct xIdStruct   *xIdNode;


/*---------------------------------------------------------------------------
 *  Define following macros to strip off all debugging code
 *  Note: 9-9-93/
 *        XNOSIGNALIDNODE NEEDS TO BE REMOVED FOR GUARDED IDNODE VARIABLES
 *--------------------------------------------------------------------------*/
#ifdef XNOSTATICSTRUCTURE
#define XNOBLOCKIDNODE
#define XNOSUBSTRIDNODE
#define XOPTCHAN
#define XNOPRSIDNODE
#endif

#define XNOPRDIDNODE
#define XNOSIGNALIDNODE
#define XNOSTARTUPIDNODE
#define XNOIMPORTEDIDNODE
#define XNOEXPORTEDIDNODE
#define XNOSTATEIDNODE
#define XOPTSIGPARA
#define XOPTDCL
#define XOPTFPAR
#define XOPTSTRUCT
#define XOPTLIT
#define XOPTSORT

#define XNOPROCATSTARTUP
#define XNOCONTSIGFUNC
#define XNOENABCONDFUNC

#define XNOMAIN


#define xPrsPrioPar(p) p,
#define xPrsPrioParS(p) p;
#define xSigPrioPar(p) p,
#define xSigPrioParS(p) p;
#define xReent(p)
#define xReentE(p)
#define xReentS(p)

#define xTestF(p)
#define xTestFS(p)
#define xRaWF(p)
#define xRaWFS(p)
#define xFreF(p)
#define xFreFS(p)
#define xFreS(p)
#define xFreSS(p)
#define xAssF(p)
#define xEqF(p)
#ifdef XIDNAMES
#define xIdNames(p) p,
#define xIdNamesS(p) p;
#else
#define xIdNames(p)
#define xIdNamesS(p)
#endif
#define xeView(p)
#define xeViewS(p)
#define xCTrace(p)
#define xCTraceS(p)
#ifndef XOPTCHAN
#define xOptChan(p)  p,
#define xOptChanS(p) p;
#else
#define xOptChan(p)
#define xOptChanS(p)
#endif
#define xGRTrace(p)
#define xGRTraceS(p)

#ifndef xDefaultPrioProcess
#define xDefaultPrioProcess      128
#endif

#ifndef xDefaultPrioSignal
#define xDefaultPrioSignal       1
#endif

#ifndef xDefaultPrioTimerSignal
#define xDefaultPrioTimerSignal  1
#endif

#ifndef xDefaultPrioContSignal
#define xDefaultPrioContSignal   1
#endif

#ifndef xDefaultPrioCreate
#define xDefaultPrioCreate       1
#endif

#define xbool int
#define XASS        0
#define XASSMAKE    1
#define XASS2MAKE   2


/*---------------------------------------------------------------------------
 * Execution Trace Info
 *
 *-------------------------------------------------------------------------*/

#define YPRSNAME_VAR(PRS_NAME_STRING)
#define YPRDNAME_VAR(PRD_NAME_STRING)
#define XOS_TRACE_OUTPUT(SIG_NAME_STRING)
#define XOS_TRACE_CREATE(PROC_NAME_STRING)
#define XOS_TRACE_STATIC_CREATE(PROC_NAME_STRING)
#define XOS_TRACE_STOP
#define XOS_TRACE_CALL
#define XOS_TRACE_RETURN
#define XOS_TRACE_SET(TIMER_NAME_STRING, DUR_EXPR)
#define XOS_TRACE_SET_TICKS(TIMER_NAME_STRING, DUR_EXPR)
#define XOS_TRACE_SET_DELTA_TIMER(TIMERPTR)
#define XOS_TRACE_RESET(TIMER_NAME_STRING)
#define XOS_TRACE_ACTIVE(TIMER_IDNODE)
#define XOS_TRACE_REMOVE_TIMER(TIMERPTR)
#define XOS_TRACE_NEXTSTATE(STATE_NAME_STRING)
#define XOS_TRACE_DASH_NEXTSTATE
#define XOS_TRACE_INPUT(SIG_NAME_STRING)
#define XOS_TRACE_SAVE(SIG_NAME_STRING)
#define XOS_TRACE_SAVE_ENABLING_C
#define XOS_TRACE_DISCARD
#define XOS_TRACE_DISCARD_SIG(SIG_CODE)
#define XOS_TRACE_TIMER_TIMEOUTSIG(TIMERPTR)
#define XOS_TRACE_CHECK_TIMER(SYS_TICKS)


#define XAT_FIRST_SYMBOL(SYMB_NO)
#define XBETWEEN_SYMBOLS(SYMB_NO, C_LINE_NO)
#define XBETWEEN_SYMBOLS_PRD(SYMB_NO, C_LINE_NO)
#define XAT_LAST_SYMBOL

#define XDEBUG_LABEL(L)

#define XBETWEEN_STMTS(SYMB_NO, C_LINE_NO)
#define XBETWEEN_STMTS_PRD(SYMB_NO, C_LINE_NO)


/* msala 27.06.01 */
#define XCHECK_REF(VALUE,REF_SORTIDNODE,REF_SORT)
#define XCHECK_CHOICE_USAGE(TAG,VALUE,NEQTAG,COMPNAME,CURR_VALUE)
#define XSET_CHOICE_TAG(TAG,VALUE,ASSTAG,NEQTAG,COMPNAME,CURR_VALUE,TYPEINFO) \
TAG = (VALUE);


#define XAFTER_VALUE_RET_PRDCALL(A)
/* end msala 27.06.01 */

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *      Macros to Implement SDL
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#ifdef NOT_INCLUDE_SDL_HEAD
#define SIGNAL_VARS
#else
#define SIGNAL_VARS \
    xSignalHeader pred; \
    xSignalHeader succ; \
    SIGREFTYPE    SignalCode; \
    unsigned int  sender_id;\
   SDL_PId       Sender; 
#endif

#ifdef UNITEST
#define HEADER_REC(REC_TYPE) \
   x##REC_TYPE##Header pred; \
   x##REC_TYPE##Header succ; \
   SIGREFTYPE     SignalCode; \
   unsigned char  sender_id; \
   SDL_PId        Sender;
#endif
/*
 *  soft timers implementation:
 *  ee_succ: earliest expiry (single linked list)
 *  le_succ: latest expiry (single linked list)
 */

#define TIMER_VARS \
    xTimerHeader ee_succ; \
    xTimerHeader le_succ; \
    SIGREFTYPE   SignalCode; \
    SDL_PId      Sender; \
    SdlTimeSpec  ee_time; \
SdlTimeSpec      le_time;

#define TIMER_PARA_VARS TIMER_VARS /*add by gongyi 080203*/

/*---------------------------------------------------------------------------
 *   PId
 *   SDL_PId <-> QID
 *   9-8-93 : Define xDef_SDL_PId() for default PId variable
 *--------------------------------------------------------------------------*/









/* hba 25-05-94 */



#define xDef_SDL_PId(V)       (*(V) = SDL_NULL)
#define yDef_SDL_PId(V)       xDef_SDL_PId(V)
#define xEq_SDL_PId(A,B)      ((A)==(B))
#define yAssF_SDL_PId(V,E,A)  (V = E)
#define yEqF_SDL_PId(E1,E2)   xEq_SDL_PId(E1,E2)
#define yNEqF_SDL_PId(E1,E2)  (! xEq_SDL_PId(E1,E2))

#define xNotDefPId            0

#define XPID_LIT1(A)          &queue_table[P_##A]
#define XPID_LIT2(A,I)        &queue_table[P_##A+I]
#define XPID_LIT3(A)          &queue_table[P_##A]
#define XASS_PIDLIST(V,E,A)
#define XEXTR_PIDLIST(v,i) &queue_table[P_##v+i-1]

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * Signal implementation and SDL Save
 *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/









/****+***************************************************************
10   Signal Set
********************************************************************/







/*--------------------------------------------------------------------------
 *  SDL Timers and Now
 *------------------------------------------------------------------------*/
//typedef struct process_vars t_process_vars;


/* Message header of timer signals is the same as for ordinary signals */





/*--------------------------------------------------------------------------
 * Pointer to signal parameters
 *------------------------------------------------------------------------*/

#define SIGNAL_DATA_PTR(SIGNAL_PTR) \
   (void NEAR *)(SIGNAL_PTR)

#define INSIGNAL_DATA_PTR SIGNAL_DATA_PTR(yVarP->yInSignalPtr)
#define OUTSIGNAL_DATA_PTR SIGNAL_DATA_PTR(yOutputSignalPtr)
#define STARTUP_DATA_PTR OUTSIGNAL_DATA_PTR


/*--------------------------------------------------------------------------
 * SDL-trace
 *------------------------------------------------------------------------*/

/* moved to mk_inc.h
#define EXTERNAL_SDL_DEBUG */

#ifdef EXTERNAL_SDL_DEBUG  /*change by gongyi 080203*/

extern void  hwtrc_putsig_ext  (xSignalHeader  yInSignalPtr, 
		unsigned       xState,
		unsigned char  sender_id,
		unsigned char sender_instance,
		unsigned char receiver_id,
		unsigned char receiver_instance,
		unsigned char xInputAction);

#endif /*#ifdef EXTERNAL_SDL_DEBUG*/

#define CLEAR_BUF_ALLOC_SIG(SIG_PAR_SIZE) /*add by gongyi 080203*/
#define CLEAR_BUF_TRANSFER(SIG_PAR_SIZE)  /*add by gongyi 080203*/


/****+***************************************************************
08   SDL predefined types (except SDL_PId)
********************************************************************/

/*#include "sctpred.h"*/
/*
#ifndef UNITEST
#include "nu_os.h"
#else
#include "er_os.h"
#endif*/

/*---------------------------------------------------------------------------
 *      Variables in the PAD function
 *--------------------------------------------------------------------------*/
#ifdef XNOSTATICSTRUCTURE
#define PROCESS_VARS \
    SDL_PId           Offspring; \
    SDL_PId           Parent; \
    SDL_PId           Self; \
    SDL_PId           Sender; \
    xSignalHeaderRec  NEAR *yInSignalPtr; \
    xSignalHeaderRec  SaveQ; \
    xSignalHeader     CurrentInSaveQ; \
    unsigned char     xState; \
    XINPUTREFTYPE     RestartAddress; \
unsigned char     SelfId;
#else
#define PROCESS_VARS \
    SDL_PId           Offspring; \
    SDL_PId           Parent; \
    SDL_PId           Self; \
    SDL_PId           Sender; \
    xSignalHeader     yInSignalPtr; \
    xSignalHeaderRec  SaveQ; \
    xSignalHeader     CurrentInSaveQ; \
    xPrsNode          PrsNode; \
    int               xState; \
int RestartAddress;
#endif

/* #define PROCEDURE_VARS byte dummy; */
#define PROCEDURE_VARS void *yvarp;

typedef struct procedure_vars t_procedure_vars;


#define XSYSTEMVARS
#define XSYSTEMVARS_H
#define XPROCESSDEF_C(PROC_NAME, PROC_NAME_STRING, PREFIX_PROC_NAME, PAD_FUNCTION, VDEF_TYPE) \
static XCONST XSIGTYPE * const insig_table = yPrsS_##PREFIX_PROC_NAME;

#define XPROCESSDEF_H(PROC_NAME, PROC_NAME_STRING, PREFIX_PROC_NAME, PAD_FUNCTION, VDEF_TYPE)

#define XSIGTYPE  SIGREFTYPE /*add by gongyi 080203*/

#define xSigCode(P)
#define XTHISPRS 0
#define SIGCODE(P)
#define STARTUPSIGNAL   0

#define YINITPARAMDEF(P) void
#define YINITPARAM(P)
#define XPROCESSMAIN(PAD)
#define SDL_Charstring_Lit(P1, P2)   P1



/* #define PROCEDURE_VARS byte dummy; */
#define PROCEDURE_VARS void *yvarp;



struct procedure_vars
{
    PROCEDURE_VARS
};

#if 0
#define YPAD_TEMP_VARS \
   SIGREFTYPE     SignalCode; \
   xSignalHeader  ySVarP;

#define YPRD_TEMP_VARS \
   xSignalHeaderRec NEAR *yOutputSignalPtr; \
   struct { prd_u prd; } yVarPVar;

#else /* __BORLANDC__ */

#define YPAD_TEMP_VARS \
   xSignalHeaderRec NEAR *yOutputSignalPtr; \
   SIGREFTYPE     SignalCode[2]; \
	xSignalHeaderRec NEAR *ySVarP[2];

#define YPRD_TEMP_VARS \
   xSignalHeaderRec NEAR *yOutputSignalPtr; \
   struct { prd_u prd; } yVarPVar[2];

#endif /* __BORLANDC__ */

#define YPAD_YSVARP

#define YPAD_YVARP(VDEF_TYPE) \
   VDEF_TYPE yVarPVar[2]; \
   VDEF_TYPE *yVarP[2] = {&yVarPVar[0],&yVarPVar[1]};


/*--------------------------------------------------------------------------
 * Timer variables
 * 9-10-1993 :
 *        (1) typedef TMID in Nucleus Environment
 *------------------------------------------------------------------------*/

#define DEF_TIMER_VAR(NAME)
#define INIT_TIMER_VAR(NAME)
#define RELEASE_TIMER_VAR(NAME)

/* EMPTY in Nucleus */
#define INPUT_TIMER_VAR(NAME)

#define DEF_TIMER_VAR_PARA(TIMER_VAR)
#define INIT_TIMER_VAR_PARA(TIMER_VAR)
#define INPUT_TIMER_VAR_PARA(TIMER_VAR)
#define RELEASE_TIMER_VAR_PARA(TIMER_VAR)

/* Now */
#define SDL_NOW(sample_id)           SDL_Now(sample_id)
#define SDL_Now(sample_id)         (RetrieveClock (sample_id))


/*
** MHO 13.03.00
*/
#ifdef NUCLEUS_HISR
#define SDL_SELF(index)                0
#endif

#ifndef SDL_SELF
#define SDL_SELF(index)                (yVarP[index]->Self)
#endif

#undef SDL_VARS

#define SDL_UNKNOWN_SENDER      255

#define SDL_PARENT              yVarP->Parent
#define SDL_OFFSPRING           yVarP->Offspring
#define SDL_SENDER              yVarP->Sender
#define CURRENT_STATE           yVarP->xState
#define CURRENT_STATE_PRD       0
#define XSTATEDEF(STATE_IDNODE, STATE_NUMBER)


/* -------------------------------------------------------------------------
 * Structure of PAD function
 *-------------------------------------------------------------------------*/
#ifndef UNITEST
#define YPAD_RESULT_TYPE        extern VOID
#else
#define YPAD_RESULT_TYPE        extern void
#endif

/* Process args */
#ifndef UNITEST
#define YPAD_ANSI_PARAM         UNSIGNED argc, VOID *argv
#else
#define YPAD_ANSI_PARAM         long argc, void *argv
#endif 

#define YPAD_KR_PARAM           argc, argv
#define YPAD_KR_DEF             UNSIGNED argc; VOID *argv;


#define YPRD_RESULT_TYPE        extern VOID

#define YPRD_ANSI_PARAM         (void *P)

#define YPRD_KR_PARAM           P

#define YPRD_KR_DEF             void *P;


#define YPAD_PROTOTYPE(PAD) \
   YPAD_RESULT_TYPE PAD XPP((YPAD_ANSI_PARAM));
#define YPRD_PROTOTYPE(PRD) \
   YPRD_RESULT_TYPE PRD XPP((YPRD_ANSI_PARAM));

#define YPAD_FUNCTION(PAD)      YPAD_RESULT_TYPE PAD XPP((YPAD_ANSI_PARAM))
#define YPRD_FUNCTION(PAD)      YPAD_RESULT_TYPE PAD XPP((YPRD_ANSI_PARAM))

#define YPRD_YVARP(VDEF_TYPE) \
   VDEF_TYPE *yVarP = (VDEF_TYPE *) ( (t_procedure_vars *) P ) -> yvarp;

#ifdef INIT_PRD_YVARP
#define ASSIGN_PRD_YVARP(sample_id) yVarPVar[sample_id].prd.dummy.yvarp = yVarP[sample_id];
#else
#define ASSIGN_PRD_YVARP
#endif

/*-------------------------------------------------------------------------
 * MACRO: BEGIN_PAD
 *
 *        Process startup and initialisation of SDL runtime system
 *-------------------------------------------------------------------------*/

#define BEGIN_PAD(VDEF_TYPE,sample_id) \
	   memset ( (void *) yVarP[sample_id], 0, sizeof ( VDEF_TYPE ) ); \
	   yVarP[sample_id]->Self = ( (struct args *) argv ) -> self; \
	   yVarP[sample_id]->SelfId = (unsigned char)( ( (struct args *) argv ) -> self_id ); \
	   yVarP[sample_id]->Offspring = SDL_NULL; \
	   yVarP[sample_id]->SaveQ.succ = &(yVarP[sample_id]->SaveQ); \
	   yVarP[sample_id]->SaveQ.pred = &(yVarP[sample_id]->SaveQ); \
	   yVarP[sample_id]->CurrentInSaveQ = &(yVarP[sample_id]->SaveQ); \
	   yVarP[sample_id]->yInSignalPtr = 0; \
	   ASSIGN_PRD_YVARP(sample_id)

/*---------------------------------------------------------------------------
 * MACRO: LOOP_LABEL
 *
 *        SDL loop; waiting for input signals, consumption of input signals,
 *        consumption of saved signals
 *--------------------------------------------------------------------------*/

#define LOOP_LABEL(sample_id)     \
   Label_New_Transition : \
     ySVarP[sample_id] = SDL_Loop ( insig_table, trans_table, \
                         (t_process_vars *) yVarP[sample_id], \
	                 __FILE__, __LINE__ ); \
     SignalCode[sample_id] = SIGNAL_NAME ( ySVarP[sample_id] -> SignalCode, 0 );

#define LOOP_LABEL_PRD_NOSTATE \
     XOS_TRACE_CALL

#define BEGIN_START_TRANSITION(STARTUP_PAR_TYPE,sample_id) \
   yVarP[sample_id]->Parent = yVarP[sample_id]->Sender; \
   yVarP[sample_id]->Sender = SDL_NULL;

#define STATE_NAME(STATE_NAME, STATE_IDNODE) STATE_NAME

/*----------------------------------------------------------------------------
 * MACRO: SIGNAL_NAME ( )
 *--------------------------------------------------------------------------*/





#define START_STATE                                0

#define START_STATE_PRD                            0

#define INSIGNAL_NAME           ( SignalCode )


/*---------------------------------------------------------------------------
 * ENABLING CONDITION
 *-------------------------------------------------------------------------*/
#define ENABL_COND(EXPR) \
   ERROR_Enabling_Condition_not_implemented


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *      Actions within transitions
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


/*---------------------------------------------------------------------------
 *     Outputs
 *--------------------------------------------------------------------------*/

#define XSIGNALHEADERTYPE xSignalHeaderRec

extern t_queue queue_table[];

#define TO_PROCESS(PROC_NAME, PROC_IDNODE) XEXTR_PIDLIST(PROC_NAME,1)

#if !defined(_OS_WIN) && !defined(__arm) && !defined(_USE_CMPL_GCC) && !defined(UNITEST)

#define DEF_OUTSIG_PTR

#define ALLOC_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
  xSignalHeader yOutputSignalPtr = \
       alloc_sig( sizeof (SIG_PAR_TYPE) ); \
   yOutputSignalPtr->Sender = SDL_SELF(sample_id); \
   CLEAR_BUF_ALLOC_SIG(SIG_PAR_TYPE)

#define TRANSFER_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
   xSignalHeader yOutputSignalPtr = yVarP[sample_id]->yInSignalPtr; \
   yVarP[sample_id]->yInSignalPtr = 0; \
   yOutputSignalPtr->Sender = SDL_SELF(sample_id); \
   CLEAR_BUF_TRANSFER(SIG_PAR_TYPE)

#else /* __BORLANDC__ */

#define DEF_OUTSIG_PTR xSignalHeaderRec *yOutputSignalPtr;

#ifdef SDL_VARS

#define ALLOC_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
   yOutputSignalPtr = \
       alloc_sig( sizeof (SIG_PAR_TYPE) ); \
   yOutputSignalPtr->Sender = SDL_SELF(sample_id); \
       yOutputSignalPtr -> sender_id = SDL_VARS->SelfId; \
   CLEAR_BUF_ALLOC_SIG(SIG_PAR_TYPE)


#define TRANSFER_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
   yOutputSignalPtr = yVarP[sample_id]->yInSignalPtr; \
   yVarP[sample_id]->yInSignalPtr = 0; \
   yOutputSignalPtr->Sender = SDL_SELF(sample_id); \
       yOutputSignalPtr -> sender_id = SDL_VARS->SelfId; \
   CLEAR_BUF_TRANSFER(SIG_PAR_TYPE)


#else

#define ALLOC_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
   yOutputSignalPtr = \
       alloc_sig( sizeof (SIG_PAR_TYPE) ); \
   yOutputSignalPtr->Sender = SDL_SELF(sample_id); \
       yOutputSignalPtr -> sender_id = SDL_UNKNOWN_SENDER; \
   CLEAR_BUF_ALLOC_SIG(SIG_PAR_TYPE)

#define TRANSFER_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
   yOutputSignalPtr = yVarP[sample_id]->yInSignalPtr; \
   yVarP[sample_id]->yInSignalPtr = 0; \
   yOutputSignalPtr->Sender = SDL_SELF(sample_id); \
       yOutputSignalPtr -> sender_id = SDL_UNKNOWN_SENDER; \
   CLEAR_BUF_TRANSFER(SIG_PAR_TYPE)

#endif /* ! __BORLANDC__ */


#define ALLOC_SIGNAL_PAR(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
   ALLOC_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id)

#define TRANSFER_SIGNAL_PAR(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id) \
   TRANSFER_SIGNAL(SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_TYPE,sample_id)

#define SIGNAL_ALLOC_ERROR

#define SIGNAL_ALLOC_ERROR_END

/* #ifdef NUCLEUS_HISR */
#if 0
#define SEND_SIG send_sig_no_susp
#define SEND_SIG_NO_TO send_sig_no_to_no_susp
#else
#define SEND_SIG send_sig
#define SEND_SIG_NO_TO send_sig_no_to
#endif


#define SDL_2OUTPUT_COMPUTED_TO(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   SDL_2OUTPUT(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING)

#if !defined(_OS_WIN) && !defined(__arm) && !defined(_USE_CMPL_GCC) &&  !defined(UNITEST)


#define SDL_2OUTPUT(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   XOS_TRACE_OUTPUT(SIG_NAME_STRING) \
   yOutputSignalPtr->SignalCode = SIG_NAME; \
   SEND_SIG ( yOutputSignalPtr, RECEIVER ); }

#define SDL_2OUTPUT_NO_TO(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   XOS_TRACE_OUTPUT(SIG_NAME_STRING) \
   SEND_SIG_NO_TO ( yOutputSignalPtr, SIG_NAME ); }


#define SDL_ALT2OUTPUT(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   build_##SIG_NAME ( OUTSIGNAL_DATA_PTR ); \
   yOutputSignalPtr->SignalCode = SIG_NAME; \
   SEND_SIG ( yOutputSignalPtr, RECEIVER ); }

#define SDL_ALT2OUTPUT_NO_TO(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   build_##SIG_NAME ( OUTSIGNAL_DATA_PTR ); \
   SEND_SIG_NO_TO ( yOutputSignalPtr, SIG_NAME ); }

#else /* __BORLANDC__ */

#define SDL_2OUTPUT(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   XOS_TRACE_OUTPUT(SIG_NAME_STRING) \
   yOutputSignalPtr->SignalCode = SIG_NAME; \
   SEND_SIG ( yOutputSignalPtr, RECEIVER, SIG_NAME_STRING );

#define SDL_2OUTPUT_NO_TO(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   XOS_TRACE_OUTPUT(SIG_NAME_STRING) \
   SEND_SIG_NO_TO ( yOutputSignalPtr, SIG_NAME, SIG_NAME_STRING );

#define SDL_ALT2OUTPUT(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   build_##SIG_NAME ( OUTSIGNAL_DATA_PTR ); \
   yOutputSignalPtr->SignalCode = SIG_NAME; \
   SEND_SIG ( yOutputSignalPtr, RECEIVER, SIG_NAME_STRING );

#define SDL_ALT2OUTPUT_NO_TO(PRIO, VIA, SIG_NAME, SIG_IDNODE, RECEIVER, SIG_PAR_SIZE, SIG_NAME_STRING) \
   build_##SIG_NAME ( OUTSIGNAL_DATA_PTR ); \
   SEND_SIG_NO_TO ( yOutputSignalPtr, SIG_NAME, SIG_NAME_STRING );

#endif /* __BORLANDC__ */



/*----------------------------------------------------------------------------
 *      SDL Process Create
 *---------------------------------------------------------------------------*/

#ifdef XNOSTATICSTRUCTURE
#define STARTUP_VARS
#else
#define STARTUP_VARS \
   xPrsNode PrsNode;
#endif

/*
** msges 7.10.97: inserted "(SIGREFTYPE)".
*/

#define ALLOC_STARTUP(PROC_NAME, STARTUP_IDNODE, STARTUP_PAR_TYPE) \
   { xSignalHeader yOutputSignalPtr = alloc_sig( sizeof (STARTUP_PAR_TYPE) ); \
   yOutputSignalPtr->SignalCode = STARTUP_SIGNAL_NAME; \
   yOutputSignalPtr->Sender = yVarP->Self;

#define ALLOC_STARTUP_PAR(PROC_NAME, STARTUP_IDNODE, STARTUP_PAR_TYPE) \
  ALLOC_STARTUP(PROC_NAME, STARTUP_IDNODE, STARTUP_PAR_TYPE)

#define STARTUP_ALLOC_ERROR
#define STARTUP_ALLOC_ERROR_END

#ifdef XNOSTATICSTRUCTURE
#define SDL_CREATE(PROC_NAME, PROC_IDNODE, PROC_NAME_STRING) \
    yVarP -> Offspring = \
      SDL_Create ( yPAD_##PROC_NAME, PROC_NAME##_STACK_SIZE, P_##PROC_NAME, \
                   PROC_NAME##_PRIO, PROC_NAME_STRING, yOutputSignalPtr ); }
#else
#define SDL_CREATE(PROC_NAME, PROC_IDNODE, PROC_NAME_STRING, STARTUP_IDNODE, STARTUP_PAR_TYPE, VDEF_TYPE, PRIO, PAD_FUNCTION) \
   SDL_CREATE STATIC STRUCTURE not implemented
#endif


#define YINIT_TEMP_VARS
#define EnvPId Temp
#define xEnv_Var 0
#define XSYSD


/*---------------------------------------------------------------------------
 *      MACRO: BEGIN_YINIT
 *      USAGE: INITIALIZE SDL SYSTEM, I.E. INIT_TIMERS FOR NOW.
 *      DATE:  8-29-93
 *-------------------------------------------------------------------------*/
#define BEGIN_YINIT

#define XINIT_SYSTEMIDNODE(A)
#define XCREATE_ENV_PROCESS


/*---------------------------------------------------------------------------
 *      MACRO: END_YINIT
 *      USAGE: None
 *-------------------------------------------------------------------------*/
#define END_YINIT


/*----------------------------------------------------------------------------
 * MACRO: INIT_PROCESS_TYPE ( )
 *
 * USAGE: NOTIFY THE OS ABOUT THE PROCESS TYPE AND STATIC INSTANCE INFORMATION
 *        SUCH AS STATIC PROCESS PAD FUNCTION NAME, PROCESS TYPE NAME, AND ETC.
 *
 *        (not used)
 *
 *---------------------------------------------------------------------------*/

#define INIT_PROCESS_TYPE(PROC_NAME, PREFIX_PROC_NAME, PROC_IDNODE, PROC_NAME_STRING, MAX_NO_OF_INST, STATIC_INST, PRIV_DATA_TYPE, PRIO, PAD_FUNCTION)


/*----------------------------------------------------------------------------
 * MACRO: SDL_STATIC_CREATE
 *--------------------------------------------------------------------------*/
#define SDL_STATIC_CREATE(PROC_NAME, PREFIX_PROC_NAME, PROC_IDNODE, PROC_NAME_STRING, STARTUP_IDNODE, STARTUP_PAR_TYPE, PRIV_DATA_TYPE, PRIO, PAD_FUNCTION, BLOCK_INST_NUMBER) \
   send_startup_sig( queue_table + P_##PROC_NAME );


/*---------------------------------------------------------------------------
 * MACRO: SDL_STOP
 *--------------------------------------------------------------------------*/
#define SDL_STOP \
   XOS_TRACE_STOP \
   SDL_Stop ( (t_process_vars *) yVarP, yVarP->yInSignalPtr, SelfId );



/*---------------------------------------------------------------------------
 *  Timers
 *--------------------------------------------------------------------------*/


/* Disable clock ticking while manipulating timer queue */
/* Mask out all interrupts lower than or eq to this level */
/*#define ENABLE_INTERRUPTS 0
#define DISABLE_NEARLY_ALL_INTERRUPTS 12
#define DISABLE_ALL_INTERRUPTS 15  !!! ??? */

#define ENABLE_INTERRUPTS 0
#define DISABLE_NEARLY_ALL_INTERRUPTS  8  //12//0         //32
#define DISABLE_ALL_INTERRUPTS         0  //15         //32
//#define DISABLE_ALL_PROCCESS           0




/*  en/disable all interrupt defined ICU_funct.h */
/*#define ICU_Disable_IRQ()            unsigned long msr;\
	                                 LOCK_SAVE(msr)
#define ICU_Enable_IRQ               LOCK_RESTORE(msr)*/
#if 0
#define DISABLE_CLOCK { unsigned long msr;\
                        ushort old_level = get_pri(current_process ());\
	                    set_pri(0);\
	                    LOCK_SAVE(msr);
                        
#define ENABLE_CLOCK   LOCK_RESTORE(msr);\
                       set_pri(old_level); }

#define ATOMIC_BEGIN   status = zOss_GetMutex( timer_mutex,  ZOSS_WAIT_FOREVER);\
		                     if( status == ZOSS_ERROR ) return 0;
#define ATOMIC_END     status = zOss_PutMutex( timer_mutex);\
		                     if( status == ZOSS_ERROR ) return 0;               
			               
#endif
#ifdef _OS_WIN
#define DISABLE_CLOCK 
#define ENABLE_CLOCK 

#define ATOMIC_BEGIN  
#define ATOMIC_END  
#else
#define DISABLE_CLOCK   ZOSS_DISABLE_IRQ();
#define ENABLE_CLOCK    ZOSS_ENABLE_IRQ();

#define ATOMIC_BEGIN    ZOSS_DISABLE_IRQ();
#define ATOMIC_END      ZOSS_ENABLE_IRQ();
#endif

/* Suspension and resumption of timers (not SDL standard) */

#define SDL_DISABLE_TIMER(TIMER_ID) \
  disable_timer ( TIMER_ID, 0, yVarP -> Self,sample_id );

#define SDL_ENABLE_TIMER(TIMER_ID) \
  enable_timer ( TIMER_ID, 0, yVarP -> Self,sample_id );

/* SET without parameters */

#define SDL_SET_DUR(TIME_EXPR, DUR_EXPR, TIMER_NAME, TIMER_IDNODE, TIMER_VAR, TIMER_NAME_STRING,sample_id) \
do { \
    SDL_Duration soft_time_offset; /* time offset */ \
    \
    SDL_Duration latest_time;      /* latest time */ \
    SDL_Duration early_time;       /* early time := latest time - time offset */ \
    \
    /* soft time offset := 0 */ \
    xDef_SDL_Duration (&soft_time_offset); \
    \
    /* latest time := soft_time (time, offset, &soft_time_offset) */ \
    yAssF_SDL_Duration (latest_time, (DUR_EXPR), XASS); \
    \
    /* early time := latest time - time offset */ \
    yAssF_SDL_Duration (early_time, xMinus_SDL_Duration (latest_time, soft_time_offset), XASS); \
    \
    SDL_Set_Dur_Ex(early_time, latest_time, TIMER_NAME, 0, (t_process_vars *) yVarP[sample_id],sample_id ); \
} while (0);

#define SDL_SET_TICKS(TIME_EXPR, DUR_EXPR, TIMER_NAME, TIMER_IDNODE, TIMER_VAR, TIMER_NAME_STRING) \
   SDL_SET_DUR(TIME_EXPR, DUR_EXPR, TIMER_NAME, TIMER_IDNODE, TIMER_VAR, TIMER_NAME_STRING,sample_id)

/* Soft SET without parameters */

#define SDL_SET_DUR_EX(EARLIEST_TIME_EXPR, LATEST_TIME_EXPR, EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, \
                       TIMER_NAME, TIMER_IDNODE, TIMER_VAR, TIMER_NAME_STRING,sample_id) \
   SDL_Set_Dur_Ex( EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, TIMER_NAME, 0, (t_process_vars *) yVarP,sample_id );

#define SDL_SET_TICKS_EX(EARLIEST_TIME_EXPR, LATEST_TIME_EXPR, EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, \
                         TIMER_NAME, TIMER_IDNODE, TIMER_VAR, TIMER_NAME_STRING,sample_id) \
   SDL_SET_DUR_EX(EARLIEST_TIME_EXPR, LATEST_TIME_EXPR, EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, \
                  TIMER_NAME, TIMER_IDNODE, TIMER_VAR, TIMER_NAME_STRING,sample_id)

/* SET with parameters */

#define ALLOC_TIMER_SIGNAL_PAR(TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE) \
  { t_timer_param timer_param = 0; \
    SIGREFTYPE timer_name = TIMER_NAME;

#define ALLOC_TIMER_SIGNAL(TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE)

#define TIMER_SIGNAL_ALLOC_ERROR
#define TIMER_SIGNAL_ALLOC_ERROR_END
#define TIMER_DATA_PTR \
  ( (char *) &timer_param - (int)( &( (xTimerHeader) 0 ) -> param ) )

#define SDL_SET_DUR_WITH_PARA(TIME_EXPR, DUR_EXPR, TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE, EQ_FUNC, TIMER_VAR, TIMER_NAME_STRING) \
do { \
    SDL_Duration soft_time_offset; /* time offset */ \
    \
    SDL_Duration latest_time;      /* latest time */ \
    SDL_Duration early_time;       /* early time := latest time - time offset */ \
    \
    /* soft time offset := 0 */ \
    xDef_SDL_Duration (&soft_time_offset); \
    \
    /* latest time := soft_time (time, offset, &soft_time_offset) */ \
    yAssF_SDL_Duration (latest_time, (DUR_EXPR), XASS); \
    \
    /* early time := latest time - time offset */ \
    yAssF_SDL_Duration (early_time, xMinus_SDL_Duration (latest_time, soft_time_offset), XASS); \
    \
    SDL_Set_Dur_Ex(early_time, latest_time, TIMER_NAME, timer_param, (t_process_vars *) yVarP,sample_id); \
} while (0); }

#define SDL_SET_TICKS_WITH_PARA(TIME_EXPR, DUR_EXPR, TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE, EQ_FUNC, TIMER_VAR, TIMER_NAME_STRING) \
   SDL_SET_DUR_WITH_PARA(TIME_EXPR, DUR_EXPR, TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE, EQ_FUNC, TIMER_VAR, TIMER_NAME_STRING) \

/* Soft SET with parameters */

#define SDL_SET_DUR_WITH_PARA_EX(EARLIEST_TIME_EXPR, LATEST_TIME_EXPR, EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, \
                                 TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE, EQ_FUNC, TIMER_VAR, TIMER_NAME_STRING) \
   SDL_Set_Dur_Ex( EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, TIMER_NAME, timer_param, (t_process_vars *) yVarP,sample_id); }

#define SDL_SET_TICKS_WITH_PARA_EX(EARLIEST_TIME_EXPR, LATEST_TIME_EXPR, EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, \
                                   TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE, EQ_FUNC, TIMER_VAR, TIMER_NAME_STRING) \
   SDL_SET_DUR_WITH_PARA_EX(EARLIEST_TIME_EXPR, LATEST_TIME_EXPR, EARLIEST_DUR_EXPR, LATEST_DUR_EXPR, \
                            TIMER_NAME, TIMER_IDNODE, TIMER_PAR_TYPE, EQ_FUNC, TIMER_VAR, TIMER_NAME_STRING) \


/* Reset without parameters */
#define SDL_RESET(TIMER_NAME, TIMER_IDNODE, TIMER_VAR, TIMER_NAME_STRING)\
   XOS_TRACE_RESET(TIMER_NAME_STRING)\
   SDL_Reset(TIMER_NAME, 0, (t_process_vars *) yVarP,sample_id);

/* Reset with parameters */
#define SDL_RESET_WITH_PARA(EQ_FUNC, TIMER_VAR, TIMER_NAME_STRING) \
   XOS_TRACE_RESET(TIMER_NAME_STRING)\
   SDL_Reset( timer_name, timer_param, (t_process_vars *) yVarP,sample_id); }


/* Active (timer active) */

/*--------------------------------------------------------------------------
 *  Procedure call
 *-------------------------------------------------------------------------*/
#define ALLOC_PROCEDURE(PROC_NAME, PROC_IDNODE, VAR_SIZE) \


#define PROCEDURE_ALLOC_ERROR
#define PROCEDURE_ALLOC_ERROR_END

#define PROC_DATA_PTR \
   ( &yVarPVar.prd )

#define CALL_PROCEDURE(PRD_NAME, PRD_IDNODE, LEVELS, RESTARTADDR) \
   PRD_NAME( (void *) &yVarPVar.prd.##PRD_NAME );

#define CALL_PROCEDURE_IN_PRD(PRD_NAME, PRD_IDNODE, LEVELS, RESTARTADDR) \
   yVarPVar.prd.dummy.yvarp = yVarP; \
   PRD_NAME( (void *) &yVarPVar.prd.##PRD_NAME );


#define CALL_PROCEDURE_STARTUP


/*----------------------------------------------------------------------------
 *      Procedure return
 *--------------------------------------------------------------------------*/

#define SDL_RETURN \
   XOS_TRACE_RETURN \
   return;

#define XEND_PRD


/*----------------------------------------------------------------------------
 *      NextState
 *--------------------------------------------------------------------------*/

#define SDL_NEXTSTATE(STATE_NAME, STATE_IDNODE, STATE_NAME_STRING,sample_id) \
   yVarPVar[sample_id].xState = STATE_IDNODE; \
   goto Label_New_Transition;

#define SDL_DASH_NEXTSTATE \
   XOS_TRACE_DASH_NEXTSTATE \
   goto Label_New_Transition;

#define SDL_NEXTSTATE_PRD(STATE_NAME, STATE_IDNODE, STATE_NAME_STRING) \
   xState = STATE_IDNODE; \
   XOS_TRACE_NEXTSTATE(STATE_NAME_STRING) \
   goto Label_New_Transition;

#define SDL_DASH_NEXTSTATE_PRD \
   XOS_TRACE_DASH_NEXTSTATE \
   goto Label_New_Transition;


/*---------------------------------------------------------------------------
 *      View
 *-------------------------------------------------------------------------*/

#define XCHECKVIEW(PID_EXPR, VAR_NAME_STRING, PROCESS_IDNODE, PROCESS_NAME) \
   ERROR__View_not_implemented
#define XGETVARP(PID_EXPR) \
   ERROR__View_not_implemented


/*---------------------------------------------------------------------------
 * Error Messaging
 * 9-9-93 : Change Return code format as hex value instead of decimal!!
 *-------------------------------------------------------------------------*/
#define XOS_ERROR(STRING1, STRING2, RETCODE)


/*--------------------------------------------------------------------------
 * Forward declaration of functions
 *------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------
 * General Timer Interfaces
 *-----------------------------------------------------------------------*/
 



/*extern void SDL_Stop ( t_process_vars *yVarP, xSignalHeaderRec near *yInSignalPtr, int self_id );
!!*/

#include "sctpred.h"

#endif 

#endif /* _SCTTYPES_H */



