/* ============================================================================
** Copyright (C) 2002-2006 COMNEON GmbH & Co. OHG. All rights reserved.
** ============================================================================
**
** ============================================================================
**
** This document contains proprietary information belonging to COMNEON.
** Passing on and copying of this document, use and communication of its
** contents is not permitted without prior written authorisation.
**
** ============================================================================
** Revision Information :
**    File name: tic.h
**    Version: /main/6
**    Date: 2006-01-11    9:53:32
**
** ============================================================================
** Project:              Mobile Station (MS)
** Block:                -
** Process:              TIC
**
** ============================================================================
** Contents:    This file contains the interfaces for the timer management
**              component.
**
** ============================================================================
** History: 
** 
** Date      Author  Comment
**
** 13.02.02  ges   created.
**
** ============================================================================
*/

#ifndef TIC_H
#define TIC_H

/*============================================================================
Exported Type Declarations
============================================================================*/

/* External representation of the timer control block data type.*/
typedef struct tic_timer_s *tic_timer_t;


/* TIC control ids.
 *
 * TIC_INFO:
 *    Get timer information.
 *
 * TIC_TRACE: 0/1 = disable/enable the tic trace.
 * tic_ctrl_trace_t  trace;
 * trace.stat = 1;
 * tic_timer_control (TIC_CTRL_TRACE, &trace, sizeof (tic_ctrl_trace_t));
 */
typedef enum
{
    TIC_CTRL_INFO,
    TIC_CTRL_TRACE    
}tic_req_t;

typedef struct tic_ctrl_info_s
{
    UINT16  max_number;  /* Max. number of available timers. */
    UINT16  installed;   /* Number of installed timers. */    
} tic_ctrl_info_t;


typedef struct tic_ctrl_trace_s
{
    UINT8  stat;  /* 0/1 = disable/enable the tic trace. */    
} tic_ctrl_trace_t;


/*============================================================================
Exported Function Declarations
============================================================================*/
/**B**************************************************************************
 * Function:     tic_timer_create
 *----------------------------------------------------------------------------
 * Purpose:      This function creates a timer and places it on the
 *               list of created timers. The timer is activated by
 *               tic_timer_start(). Upon timer expiration the
 *               expiration_routine is called.
 *
 * Parameters:   expfunc: timer expiration routine.
 *               arg: argument of the expiration routine.
 *
 * Returns:      Timer handle.
 ***E*************************************************************************/
extern  tic_timer_t  tic_timer_create(VOID (*expfunc)(VOID *arg), VOID *arg);


/**B**************************************************************************
 * Function:     tic_timer_free
 *----------------------------------------------------------------------------
 * Purpose:      This function is responsible for freeing a timer.
 *
 * Parameters:   timer: timer handle.
 *
 * Returns:      1 means during dealloction the timer handler was executed,
 *               otherwise 0.
 ***E*************************************************************************/
extern  SINT32 tic_timer_free(tic_timer_t timer);


/**B**************************************************************************
 * Function:     tic_timer_start
 *----------------------------------------------------------------------------
 * Purpose:      This function is responsible for starting a timer.
 *
 * Parameters:   timer: timer handle.
 *               secs: number of seconds.
 *               nano_secs: nano seconds.
 *
 * Returns:      None.
 ***E*************************************************************************/
extern  VOID tic_timer_start(tic_timer_t timer, UNSIGNED secs, UNSIGNED nano_secs);


/**B**************************************************************************
 * Function:     tic_timer_stop
 *----------------------------------------------------------------------------
 * Purpose:      This function is responsible for stopping a timer.
 *
 * Parameters:   timer: timer handle.
 *
 * Returns:      1 means during stopping the timer handler was executed,
 *               otherwise 0.
 ***E*************************************************************************/
extern  SINT32  tic_timer_stop(tic_timer_t timer);

#endif /* TIC_H */

