/*********************************************************************
 Ȩ (C)2003, ͨѶɷ޹˾
 
 ļƣ zx2802.a
 ժҪ init.sʹõĳ
     ߣ ͨѶ ٻ
 ڣ 20060402
**********************************************************************/

/*޸ʷ
2003-06-30: hbguan,
2003-12-22: hbguan,SDRAMĴַĶ塣
2006.04.02  hbguan, ޸ģ֧zx2802ĲԹ
2007.04.02  hbguan, ޸ģ֧zx2802 nor flashboot
*/



/*------- Stacks config ------------------------------------
TOTAL_STACK_LEN                EQU        0x10000            ; stack length in bytes

STACK_SIZE_UNDEF                EQU        24
STACK_SIZE_ABORT                EQU        48
STACK_SIZE_IRQ                    EQU        0x1000
STACK_SIZE_FIQ                    EQU        0x1000
STACK_SIZE_SVC                    EQU        (TOTAL_STACK_LEN -STACK_SIZE_UNDEF -STACK_SIZE_ABORT -STACK_SIZE_IRQ -STACK_SIZE_FIQ)



ARM926E-J CP15 control register 1
Register    Function
bit
----------------------------------------------------------
[31:19] -     Reserved.
            When read returns an UNPREDICTABLE value.
            When written SHOULD BE ZERO, or a value read from bits [31:19] on
            the same processor.Using a read-modify-write sequence when modifying 
            this register provides the greatest future compatibility.
[18]     -     Reserved, SBO. Read = 1, write = 1.
[17]     -     Reserved, SBZ. Read = 0, write = 0.
[16]     -     Reserved, SBO. Read = 1, write = 1.
[15] L4 bit Determines if the T bit is set when load instructions change the PC:
            0 = loads to PC set the T bit
            1 = loads to PC do not set T bit (ARMv4 behavior).
            For more details see the ARM Architecture Reference Manual.
[14] RR bit Replacement strategy for ICache and DCache:
            0 = Random replacement
            1 = Round-robin replacement.
[13] V bit Location of exception vectors:
            0 = Normal exception vectors selected, address range = 0x0000 0000 to
                0x0000 001C
            1 = High exception vectors selected, address range = 0xFFFF 0000 to
                0xFFFF 001C.
            Set to the value of VINITHI on reset.
[12] I bit ICache enable/disable:
            0 = ICache disabled
            1 = ICache enabled.
[11:10] - SBZ.
[9] R bit ROM protection.
            This bit modifies the ROM protection system. See Domain access
            control on page 3-23.
[8] S bit System protection.
            This bit modifies the MMU protection system. See Domain access
            control register r3 on page 2-17.
[7] B bit Endianness: 0 = Little-endian operation 1 = Big-endian operation. Set to
            the value of BIGENDINIT on reset.
[6:3] - Reserved. SBO.
[2] C bit DCache enable/disable: 0 = Cache disabled 1 = Cache enabled.
[1] A bit Alignment fault enable/disable: 0 = Data address alignment fault
            checking disabled 1 = Data address alignment fault checking enabled.
[0] M bit MMU enable/disable: 0 = disabled 1 = enabled.
*/

#ifndef _ZX2802_H
#define _ZX2802_H

#define DONT_SET_T              (0x1<<15)
#define ROUND_ROBIN             (0x1<<14)
#define HIGH_VECTOR             (0x1<<13)
#define ICACHE_ENABLE           (0x1<<12)
#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN           (0x0<<7)
#endif
#define BIG_ENDIAN              (0x1<<7)

#define DCACHE_ENABLE           (0x1<<2)    /*bit2*/
#define MMU_ENABLE              (0x1)    /*bit0*/


/*Pre-defined constants*/
#define MODEMASK                0x1f
#define USERMODE                0x10
#define FIQMODE                 0x11
#define IRQMODE                 0x12
#define SVCMODE                 0x13
#define ABORTMODE               0x17
#define UNDEFMODE               0x1b
#define SYSMODE                 0x1f
#define NOINT                   0xc0
#define I_BIT                   0x80
#define F_BIT                   0x40
#define MMU_I                   0x1000            /*I-cache enable/disable*/

/*Clock configure regs*/
#define    ARM_CONTROL_BASE     (0x6000C000)

#define ARM_CLK_CONFIG          (ARM_CONTROL_BASE +4)
#define ARM_PLL_CONFIG          (ARM_CONTROL_BASE +8)
#define ARM_RST_CONFIG          (ARM_CONTROL_BASE +0x18)
#define ZSP_SVT_ADDRESS         (ARM_CONTROL_BASE +0x20)

/*ARM_CLK_CONFIG*/
#define CORE_CLOCK_DIV_MASK     (0x3 <<6)
#define CORE_CLOCK_DIV_1        (0x0 <<6)
#define CORE_CLOCK_DIV_2        (0x1 <<6)
#define CORE_CLOCK_DIV_3        (0x2 <<6)
#define CORE_CLOCK_DIV_4        (0x3 <<6)

#define BUS_CLOCK_DIV_MASK      (0x3 <<4)
#define BUS_CLOCK_DIV_1         (0x0 <<4)
#define BUS_CLOCK_DIV_2         (0x1 <<4)
#define BUS_CLOCK_DIV_3         (0x2 <<4)
#define BUS_CLOCK_DIV_4         (0x3 <<4)

#define CORE_CLOCK_SELECT_MASK  (0x1 <<2)
#define CORE_CLOCK_SELECT_MAIN  (0x0 <<2)
#define CORE_CLOCK_SELECT_32KHZ (0x1 <<2)
#define CORE_CLOCK_SELECT_PLL   (0x2 <<2)
#define CORE_CLOCK_SELECT_RESERVED  (0x3 <<2)

#define UART_CLOCK_MASK         (0x1 <<1)
#define UART_CLOCK_MAIN_CLOCK   (0x0 <<1)
#define UART_CLOCK_BUS_CLOCK    (0x1 <<1)

#define TC_CLOCK_MASK           (0x1 <<0)
#define TC_CLOCK_MAIN_CLOCK     (0x0 <<0)
#define TC_CLOCK_BUS_CLOCK      (0x1 <<0)


/*interrupt controller register*/
#define IC_BASE                 (0x60005000)
#define INT_REQ_REG_ADDR        (IC_BASE +0x00)    /*жĴ*/
#define INT_VEC_REG_ADDR        (IC_BASE +0x04)    /*ͨжĴ*/
#define INT_FIQ_VEC_REG_ADDR    (IC_BASE +0x08)    /*жֳĴ*/

#define INT_STA_REG_ADDR        (IC_BASE +0x10)    /*ж״̬Ĵ*/
#define INT_MASK_REG_ADDR       (IC_BASE +0x14)    /*жμĴ(1:жϣ0ж)*/
#define INT_TEST_REG_ADDR       (IC_BASE +0x18)    /*жϲԼĴ*/
#define INT_EN_REG_ADDR         (IC_BASE +0x1c)    /*жʹܼĴ*/

#define INT_DIS_EN_REG_ADDR     (IC_BASE +0x20)    /*жȥʹܼĴ*/
#define INT_SET_REG_ADDR        (IC_BASE +0x24)        /*жλĴ*/
#define INT_CLEAR_REG_ADDR      (IC_BASE +0x28)        /*жλĴ*/

#define NEST_BIT                (0x1 <<10)

/*CS configure*/
#define SMC_BASE                (0x40000000)
#define SMC_CS0                 (SMC_BASE + 0x200)
#define SMC_CS1                 (SMC_BASE + 0x220)    
#define SMC_CS2                 (SMC_BASE + 0x240)

/*nand flash*/
#define SMC_CS0_VALUE           (0x00)        /* write enable &8bits*/
/*nor flash*/
#define SMC_CS1_VALUE           (0x81)        /* write enable &8 bits*/
/*SDRAM*/
#define SMC_CS2_VALUE           (0x0081)    /*write enable &16 bits*/

#define SDRAM0_BASEADDR         (0x10000000)

#define REMAP_ADDR              (0x40000000)
#define REMAP_DEFAULT_VALUE     (0x11)
#define REMAP_SDRAM_TO_0x0      (0x31)


/*GPIO regs*/
#define ARMIO_BASE              (0x60007000)
#define GPIOADATA               (ARMIO_BASE +0x0)    /*0xc002ec00*/
#define GPIOBDATA               (ARMIO_BASE +0x4)    /*0xc002ec04*/
#define GPIODIRECTA             (ARMIO_BASE +0x8)    /*0xC002EC08*/
#define GPIODIRECTB             (ARMIO_BASE +0xc)    /*0xC002EC0c*/


/*watchdog configure*/
#define WD_BASE                 0x60000000  
#define WD_CTRL_REG             (WD_BASE + 0x00000000)    /* watchdog timer Control register */
#define WD_LOAD_REG             (WD_BASE + 0x00000004)   /* Watchdog timer load register */ 
#define WD_COUNTER_REG          (WD_BASE + 0x00000008)   /* Watchdog timer counter register */ 
#define WD_STATE_REG            (WD_BASE + 0x0000000C)   /* Watchdog timer state register */

#define WD_ST_FILL              (0x01<<0)   /*ʱ*/
#define WD_PTV_FILL             (0xff<<8)  /* ⲿʱӷƵϵ*/

/*write key:ƼĴĸ16λΪ16'h1234ԸüĴдЧʱΪ0 */
#define WD_WRITE_KEY            (0x1234<<16)   

#define WD_ST_POS               0   /* ʱ*/
#define WD_PTV_POS              8   /* ⲿʱӷƵ*/


/*Ÿ*/
#define ARM_PMM_IOCONF1         (0x6000b000)
#define ARM_PMM_IOCONF2         (0x6000b004)

/*ARM_PMM_IOCONF1*/
#define USED_ARM_UART2_PINS     (0x3 <<14)
#define USED_ARM_UART1_PINS     (0xf <<10)
/*ARM_PMM_IOCONF2*/
#define USED_DSP_UART_PINS      (0x3 <<14)


/*Mode_Stack_Area                EQU        (0x100000)*/

#define reg(addr)               (*(volatile unsigned *)(addr))
#define reg8(addr)              (*(volatile unsigned char*)(addr))
#define reg16(addr)             (*(volatile unsigned short*)(addr))
#define reg32(addr)             (*(volatile unsigned long*)(addr))

#ifndef ERROR
#define ERROR                   (-1)
#endif


#define READ_DEFAULT_WORDS      8

#endif/*_ZX2802_H*/

