/**
 * 
 * @file      ringbuf_ex.h
 * @brief     
 *            This file is part of tools.
 *            ߻λģ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2013/01/21  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/04/08  1.2      jiang.fenglin  ȥöԣringbuf empty״̬
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef RINGBUF_EX_H
#define RINGBUF_EX_H


#define RINGBUF_PAD_CHAR 0xaa
#define kLastBlock       -1
#define kMinChunkSize    16

enum
{
    kBlockNotUsed,      // ãԷ䣬һĩβԷĿ
    kBlockFree,         // УԽз
    kBlockAllocated,    // ãԴ
    kBlockReady,        // ׼ãȡ
    kBlockEmpty,        // ȡͷ
};


typedef void (*mem_lock_fnc_type)(void * ptr);
typedef void (*mem_free_fnc_type)(void * ptr);

typedef struct
{
    unsigned long forw_offset;  /**< Forward offset. The value of the offset
                                                  includes the size of the header and the allocated block. */
    char          free_flag;    /**< Flag to indicate if this memory block  is free. */
    char          last_flag;    /**< Flag to indicate if this is the last block  in the allocated section. */
    unsigned char extra;        /**< Extra bytes at the end of a block. */
    unsigned char pad1;         /**< Padding at the end of a block. */
} ringbuf_ex_header_type;

typedef struct
{
    ringbuf_ex_header_type         *first_block;
    /**< First block in the ringbuf. */
    ringbuf_ex_header_type         *next_free_block;
    /**< Next free block in the ringbuf. */
    ringbuf_ex_header_type         *next_used_block;
    /**< Next used block in the ringbuf. */
    unsigned long                  total_bytes;
    void                           *base;
    /**< Total bytes available in the ringbuf. */
    // 
    mem_lock_fnc_type              lock_fnc_ptr;
    mem_free_fnc_type              free_fnc_ptr;
} ringbuf_ex_type;

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * @brief ringbufʼ
 * @param[in] ringbuf_ex_mem_ptr һblockָ
 * @param[in] ringbuf_ex_mem_size һblockĴС
 * @return ringbuf_ex_ptr λָ
 * @note
 * @see 
 */
ringbuf_ex_type *ringbuf_ex_init(void *ringbuf_ex_mem_ptr, UINT32 ringbuf_ex_mem_size);

/**
 * @brief ringbufڴ
 * @param[out] ringbuf_ex_ptr λָ
 * @param[in] size ڴС
 * @return ڴָ
 * @note
 * @see 
 */
void *ringbuf_ex_malloc(ringbuf_ex_type *ringbuf_ex_ptr, int size);

/**
 * @brief ringbufͷڴ
 * @param[in] ringbuf_ex_ptr λָ
 * @param[in] ptr ڴָ
 * @return void
 * @note
 * @see 
 */
void ringbuf_ex_free(ringbuf_ex_type *ringbuf_ex_ptr, void *ptr);

/**
 * @brief ringbufһڴΪnotused̬
 * @param[in] ringbuf_ex_ptr λָ
 * @param[in] ptr ڴָ
 * @return 1 sucess, 0 fail
 * @note
 * @see 
 */
int ringbuf_ex_set_notused(ringbuf_ex_type *ringbuf_ex_ptr, void *ptr);

/**
 * @brief ringbufһڴΪready̬
 * @param[in] ringbuf_ex_ptr λָ
 * @param[in] ptr ڴָ
 * @return 1 sucess, 0 fail
 * @note
 * @see 
 */
int ringbuf_ex_set_ready(ringbuf_ex_type *ringbuf_ex_ptr, void *ptr);

/**
 * @brief ringbufһڴΪempty̬
 * @param[in] ringbuf_ex_ptr λָ
 * @param[in] ptr ڴָ
 * @return 1 sucess, 0 fail
 * @note
 * @see 
 */
int ringbuf_ex_set_empty(ringbuf_ex_type *ringbuf_ex_ptr, void *ptr);

/**
 * @brief ringbufȡһready buf
 * @param[in] ringbuf_ex_ptr λָ
 * @param[in] ptr ڴָ
 * @param[in] size ڴС
 * @return 1 sucess, 0 fail
 * @note
 * @see 
 */
int ringbuf_ex_get_first_ready(ringbuf_ex_type *ringbuf_ex_ptr, void **ptr, UINT32 *size);

/**
 * @brief жringbufĵһblockǷѾ׼
 * @param[in] ringbuf_ex_ptr λָ
 * @return 1 sucess, 0 fail
 * @note
 * @see 
 */
int ringbuf_ex_first_block_is_ready(ringbuf_ex_type *ringbuf_ex_ptr);

/**
 * @brief ex2͵Ļλ
 * @param[in] size ûָĴСעûʵʿÿռsizeС8
 * @return λָ
 * @note
 * @see 
 */
void *ringbuf_ex2_create(unsigned int size);

/**
 * @brief ex2͵Ļλд
 * @param[in] ringbuf_ex λָ
 * @param[in] buf ݵַ
 * @param[in] len ݳ
 * @return void
 * @note
 * @see 
 */
void ringbuf_ex2_write(void *ringbuf_ex, void *buf, unsigned int len);

#ifdef __cplusplus
}
#endif


#endif /* MEMHEAP_H */

