#define _POSIX_C_SOURCE 199309
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/syscall.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <syslog.h>
#include <stdarg.h>
#include <pthread.h>
#include "softap_log.h"
#include "softap_api.h"

#define ON 1
#define OFF -1

int slog_printlevel  = SLOG_ERR;
int slog_sysloglevel = SLOG_OFF;
int soctime_sw       = SLOG_SOCTIME_OFF;

int log_switch = LOG_ON;
long long time_us;

void log_sig_hdl(int sig, siginfo_t *siginfo, void *ptr)
{
	int level = 0;
	int printlog = 0, syslog = 0, soctime = 0;

	if (sig == SIGUSR2) {
		slog(NET_PRINT, SLOG_ERR, "prelevels(printlog:%d,syslog:%d,soctime:%d), setlevel:%d \n",
		     slog_printlevel, slog_sysloglevel, soctime_sw, siginfo->si_value.sival_int);

		level = siginfo->si_value.sival_int;

		soctime  = (level % 1000) / 100;         //ȡλǧλϲ֧
		syslog   = (level - soctime * 100) / 10; //ȡʮλ
		printlog = level - soctime * 100 - syslog * 10; //ȡλ

		slog(NET_PRINT, SLOG_ERR, "printlog:%d, syslog:%d, soctime:%d \n", printlog, syslog, soctime);

		if (printlog > 0 && printlog <= SLOG_OFF)
			slog_printlevel = printlog;
		else
			slog(NET_PRINT, SLOG_ERR, "slog_printlevel only support %d~%d \n", SLOG_DEBUG, SLOG_OFF);

		if (syslog > 0 && syslog <= SLOG_OFF)
			slog_sysloglevel = syslog;
		else
			slog(NET_PRINT, SLOG_ERR, "slog_sysloglevel only support %d~%d \n", SLOG_DEBUG, SLOG_OFF);

		if (soctime == 0 || soctime == 1)
			soctime_sw = soctime;
		else
			slog(NET_PRINT, SLOG_ERR, "soctime_sw only support 0~1 \n");
	}
}

//עᶯ̬ӡź
void register_sig_logswitch(void)
{
	struct sigaction st;

	memset(&st, 0, sizeof(st));
	st.sa_flags = SA_SIGINFO;
	st.sa_sigaction = log_sig_hdl;
	sigaction(SIGUSR2, &st, NULL);
}

//NVʼӡ
void loglevel_init(void)
{
	char nv_print_level[32]    = {0};
	char nv_syslog_level[32]   = {0};
	char nv_soctime_switch[32] = {0};

	sc_cfg_get("print_level", nv_print_level, sizeof(nv_print_level));
	sc_cfg_get("syslog_level", nv_syslog_level, sizeof(nv_syslog_level));
	sc_cfg_get("soctime_switch", nv_soctime_switch, sizeof(nv_soctime_switch));

	//loglevelЧֵʱĬϴӡΪoffرմӡ
	slog_printlevel = atoi(nv_print_level);
	if((slog_printlevel < SLOG_DEBUG) || (slog_printlevel > SLOG_OFF)) { 
		slog_printlevel = SLOG_OFF;
	}	

	slog_sysloglevel = atoi(nv_syslog_level);
	if((slog_sysloglevel < SLOG_DEBUG) || (slog_sysloglevel > SLOG_OFF)) { 
		slog_sysloglevel = SLOG_OFF;
	}

	soctime_sw = atoi(nv_soctime_switch);
	if((soctime_sw > SLOG_SOCTIME_ON) || (soctime_sw < SLOG_SOCTIME_OFF)) { 
		soctime_sw = SLOG_SOCTIME_OFF;
	}	

	register_sig_logswitch();

	slog(NET_PRINT, SLOG_DEBUG, "loglevel_init, print:%d, syslog:%d, soctime:%d \n",
	     slog_printlevel, slog_sysloglevel, soctime_sw);
}

int sys_log(char *ident, int prio, const char * fmt, va_list arg)
{
	vsyslog(prio, fmt, arg);
	return 0;
}

inline void output_syslog_time(char *mod, int prio)
{
	if (SLOG_SOCTIME_ON == soctime_sw)
		syslog(prio, "[%lld.%llds]: ", time_us / 1000000, time_us % 1000000);
}

#define put_to_console(mod, fmt, arg) do {\
	char buf[1024]; \
	if(SLOG_SOCTIME_ON == soctime_sw) \
		snprintf(buf, 1023, "%s[%d][%lld.%llds]: ", mod, syscall(SYS_gettid), time_us/1000000, time_us%1000000); \
	else \
		snprintf(buf, 1023, "%s[%d]: ", mod, syscall(SYS_gettid)); \
	int n = strlen(buf); \
	va_start(arg, fmt); \
	vsnprintf(buf+n, 1023-n, fmt, arg); \
	va_end(arg); \
	printf("%s",buf); \
}while(0)


//output_syslog_time(mod, LOG_##LEVEL, &t);
#define put_to_syslog(LEVEL) do { \
	openlog(mod, LOG_PID, LOG_MAIL); \
	output_syslog_time(mod, LOG_##LEVEL); \
	va_start(arg, fmt); \
	ret = sys_log(mod, LOG_##LEVEL, fmt, arg); \
	va_end(arg); \
	closelog(); \
}while(0)

#define SYSLOG_LVL_PATH "/proc/sys/slog/syslog_level"
#define PRINT_LVL_PATH "/proc/sys/slog/print_level"
#define LOG_SOC_TIME_SWITCH "/proc/sys/slog/soctime_sw"
static void set_log_level(int* loglevel, char* filepath)
{
	int fd;
	char buf[4] = {0};
    int len  = 0;
	fd = open(filepath, O_RDWR);
	if (fd < 0) {
		printf("fail to open\n");
		return;
	}

    len = read(fd, buf, 3);

	if (len > 0 )
		*loglevel = atoi(buf);
	else {
		close(fd);
		return;
	}
	close(fd);
}

int slog(char *mod, int prio, const char *fmt, ...)
{
	va_list arg = {0};
	int ret = 0;

	if (SLOG_SOCTIME_ON == soctime_sw)
		time_us = get_time_us();

	if (slog_sysloglevel > 0 && slog_sysloglevel <= prio) {
		switch (prio) {
		case SLOG_NORMAL: {
			put_to_syslog(NOTICE);
		}
		break;

		case SLOG_DEBUG: {
			put_to_syslog(DEBUG);
		}
		break;

		case SLOG_ERR: {
			put_to_syslog(ERR);
		}
		break;

		default:
			break;
		}
	}

	if (slog_printlevel > 0 && slog_printlevel <= prio) {
		put_to_console(mod, fmt, arg);
	}

	return ret;
}

void security_log(int mod,const char *fmt, ...)
{
	char buf[512] = {0};
	va_list arg = {0};
	int n = 0;

	snprintf(buf, sizeof(buf), "[%X][%d]", mod, syscall(SYS_gettid));
	n = strlen(buf);
	va_start(arg, fmt);
	vsnprintf(buf+n, sizeof(buf)-n, fmt, arg); 
	va_end(arg);
	ipc_send_message(mod, MODULE_ID_SECURITY_LOG, MSG_CMD_SECURITY_LOG_SAVE, sizeof(buf), (unsigned char *)buf, IPC_NOWAIT);
}

