/**
 * GPLԼ
 * һڵĺ
 * Beneboy 2003-5-16
 */

#ifndef _PORT_COM_H
#define _PORT_COM_H


typedef struct
{
    char prompt;    // prompt after reciving data
    int  baudrate;  // baudrate
    char databit;   // data bits, 5, 6, 7, 8
    char debug;     // debug mode, 0: none, 1: debug
    char echo;      // echo mode, 0: none, 1: echo
    char fctl;      // flow control, 0: none, 1: hardware, 2: software
    char tty;       // tty: 0, 1, 2, 3, 4, 5, 6, 7
    char parity;    // parity 0: none, 1: odd, 2: even
    char stopbit;   // stop bits, 1, 2
    int  reserved;  // reserved, must be zero
} portinfo_t, *pportinfo_t;


typedef enum
{
    NO_WAIT = 0,
    WAIT_ALL
} WAIT_FLAG;

/**
 *  򿪴, ļ
 *  pportinfo: õĴϢ
 */
int PortOpen(pportinfo_t pportinfo,int mode);

/**
 *  ˿ڳʼ
 */
int PortInit(int mode);
/**
 *  ô
 *  fdcom: ļ, pportinfo: õĴϢ
 */
int PortSet(int fd);
/**
 *  رմ
 *  fdcom: ļ
 */
void PortClose(int fd);

/**
 * PortSend
 *  fd: ,
 *  data: ָ
 *  datalen: ݳ
 *  ʵʷͳ
 */
int PortSend(int fd, unsigned char* data, int datalen, int flag);

/**
 * PortRecv
 *  
 *  fd: ,
 *  data: ָ
 *  datalen: ݳ
 *  ʵʶֽ
 */
int PortRecv(int fd, unsigned char* data, int datalen, int flag);

/**
 *  ڲʱô
 *  fdcom: ļ, pportinfo: õĴϢ
 */
int uart_set(int fd);


#endif

