/**
 * @file at_portmng.c
 * @brief at_ctlUSBȲ¼Ĵʵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *							 Include header files							   *
 ******************************************************************************/
#include "at_context.h"
#include "at_register.h"
#include "at_msg.h"
#include "softap_api.h"
#include "at_netdog.h"
#include "at_zephyr.h"
#include <semaphore.h>

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/* farpsͨϢݽṹ*/
struct farps_port_info
{
    char name[AT_PORT_NAME_LEN];
    int fd;
    //int type;//com=0,msg=1
    int state;//closed=0 ready=1;
};
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static int update_at_port_fd(int fd, int new_fd, int index);
USHORT get_timerID_by_fd(int fd);
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/* farpsͨϢ*/
static struct farps_port_info g_farps_port_info[FAR_PS_FD_MAX] = { 0 };
static struct farps_port_info g_farps_hotplug_msg[FAR_PS_FD_MAX] = { 0 };
static char g_farps_hotplug_flag = 0;
pthread_mutex_t g_hotplug_mutex = PTHREAD_MUTEX_INITIALIZER;

/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
extern int g_auto_fd;
/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/

/* ָͨfd*/
static int update_at_port_fd(int fd, int new_fd, int index)
{
    FD_FAR_PS[index] = new_fd;
    if(fd <= 0)
    {
        at_print(AT_ERR,"ERR: update_at_port_fd error\n");
        return -1;
    }
    {
        struct at_channel_info* node = at_channel_head[FAR_PS];

        for(;node; node = node->next)
        {
            if (node->at_fd == fd)
            {
                node->at_fd = new_fd;
            }
        }
    }
    return 0;
}
/*******************************************************************************
*                      Global function implementations                        *
******************************************************************************/
#ifdef USE_CAP_SUPPORT
int at_cap_set_state_proc(const char * name, int state, int fd)
{
	int i = 0;
	int at_fd;
	int ilde_idx = -1; 
	struct at_channel_info* node= NULL;
	
	if(name == NULL || strlen(name) == 0 || strlen(name) >= AT_PORT_NAME_LEN)
	{
		at_print(AT_ERR,"ERR: port name error\n");
		return -1;
	}
	
	if(1 == state)	
	{
		for(i = 0; i < FAR_PS_FD_MAX; i ++)
		{
			if(0 == strlen(g_farps_port_info[i].name))
			{
				ilde_idx = i;
				break;
			}		
		}
		//iСFAR_PS_FD_MAX˵ǰͨѾ򿪹ٴ
		if(i >= FAR_PS_FD_MAX)
		{
			at_print(AT_ERR,"ERR: at_cap_set_state_proc there isn't a free farps channel!\n");
			return -1;
		}
		FD_FAR_PS[ilde_idx] = fd;

		if(FD_FAR_PS[ilde_idx] >= 0)
		{
			node = add_new_channel(FD_FAR_PS[ilde_idx],FAR_PS);
			if(0 == at_strncmp(name, "/dev/rpmsg35", strlen(name)) ||
				0 == at_strncmp(name, "/dev/rpmsg37", strlen(name)) ||
				0 == at_strncmp(name, "/dev/rpmsg38", strlen(name)) ||
				0 == at_strncmp(name, "/dev/rpmsg39", strlen(name))) {
				node->attribution |= 1<<CH_AUTOIND;
			}
			//if(node != NULL &&(strstr(name, "/dev/ttyGS0") != NULL || strstr(name, "/dev/ttyGS1") != NULL))
				node->reserved = 0;//ΪԤͨѡfarpsʱ򣬻ѡ
			memcpy(g_farps_port_info[ilde_idx].name,name,strlen(name));
			g_farps_port_info[ilde_idx].fd = FD_FAR_PS[ilde_idx];
			g_farps_port_info[ilde_idx].state = 1;
			at_print(AT_ERR,"at_cap_set_state_proc new_open %s fd=%d index=%d\n", name, g_farps_port_info[ilde_idx].fd, ilde_idx);
			return 0;
		}
		else
		{
			at_print(AT_ERR,"ERR: at_cap_set_state_proc new_open %s fail,errno: %d\n", name,errno);
			return -1;
		}
	}
	return -1;

}
#endif

/**
 * @brief ͻAPPͨ״̬á
 * @param name ģ
 * @param state Ҫõ״̬
 * @return 
 * @note  ǰδ򿪣Ϊ״̬ʱ
 * @note  ǰΪ򿪣Ϊرʱֻµǰ״̬
 * @warning 
 */
 /*ָ״̬򿪻߹رʵat豸ͨ*/
int at_portmng_set_state_proc(const char * name, int state, int fd)
{

    int i = 0;
	int at_fd;
	int ilde_idx = -1; 
    if(name == NULL || strlen(name) == 0 || strlen(name) >= AT_PORT_NAME_LEN)
    {
        at_print(AT_ERR,"ERR: port name error\n");
        return -1;
    }

	for(i=0; i<FAR_PS_FD_MAX; i++)
	{
		if(0 == strlen(g_farps_port_info[i].name))
		{
			if(ilde_idx < 0)
			{
				ilde_idx = i;
			}
			continue;
		}
		
        if(!strcmp(g_farps_port_info[i].name, name))
        {
        	at_fd = g_farps_port_info[i].fd;
        	break;
        }
	}

	if(0 == state)
	{
		//iFAR_PS_FD_MAX˵ǰͨûд򿪹ֱӷ
		if(i == FAR_PS_FD_MAX)
		{
			at_print(AT_ERR,"ERR: %s is not opened\n",name);
			return -1;
		}
		#if (APP_OS_TYPE == APP_OS_LINUX)
		if(get_timerID_by_fd(at_fd)>0)
			sc_timer_delete(get_timerID_by_fd(at_fd));//ɾʱ
		#endif
		del_channel_info(at_fd, FAR_PS);
		memset(&g_farps_port_info[i], 0x00, sizeof(g_farps_port_info[i]));
		FD_FAR_PS[i] = -1;
		/*
		if(at_close(at_fd))
        {
            at_print(AT_ERR,"ERR: close %s ===> fd: %d error\n", name, at_fd);
            return -1;
        }
		at_print(AT_ERR,"close %s ===> fd: %d success\n", name, at_fd);
		*/
		at_print(AT_ERR,"at_port_state_proc close %s fd=%d\n", name, at_fd);
		return 0;
	}
	else
	{
		//iСFAR_PS_FD_MAX˵ǰͨѾ򿪹ٴ
		if(i < FAR_PS_FD_MAX || ilde_idx < 0)
		{
			at_print(AT_ERR,"ERR: %s is opened\n",name);
			//softap_assert("");
			return -1;
		}
		FD_FAR_PS[ilde_idx] = fd;//at_open(name,O_RDWR); 
		//ٸȷǷ⣬ΪʲôֱӴ򿪵ҪãͨϢ̬򿪵ģҪ
		//ioctl(FD_FAR_PS[ilde_idx], (('R'<<8)|1|(0x4004<<16)), 0x400);
		//ioctl(FD_FAR_PS[ilde_idx], (('R'<<8)|4|(0x4004<<16)), 0);
		if(FD_FAR_PS[ilde_idx] >= 0)
		{
			struct at_channel_info* node = add_new_channel(FD_FAR_PS[ilde_idx],FAR_PS);
			if(node != NULL &&(strstr(name, "/dev/ttyGS0") != NULL || strstr(name, "/dev/ttyGS1") != NULL))
				node->reserved = 1;//usb豸ΪԤͨѡfarpsʱֻѡuartڷ
			memcpy(g_farps_port_info[ilde_idx].name,name,strlen(name));
			g_farps_port_info[ilde_idx].fd = FD_FAR_PS[ilde_idx];
			g_farps_port_info[ilde_idx].state = 1;
			at_print(AT_ERR,"at_port_state_proc new_open %s fd=%d index=%d\n", name, g_farps_port_info[ilde_idx].fd, ilde_idx);
			return 0;
		}
		else
		{
			at_print(AT_ERR,"ERR: at_port_state_proc new_open %s fail,errno: %d\n", name,errno);
			return -1;
		}
	}
    return -1;

}

/**
 * @brief ͨfdȡͻAPPͨ״̬
 * @param 
 * @return 
 * @note   
 * @warning 
 */

int at_portmng_get_fd_by_name(char *name)
{
	int at_fd = -1;
	int i = 0;
	for(i=0; i<FAR_PS_FD_MAX; i++)
	{
		
        if(!strcmp(g_farps_port_info[i].name, name))
        {
        	at_fd = g_farps_port_info[i].fd;
        	break;
        }
	}
	return at_fd;
}

int at_portmng_get_state_by_fd(int fd)
{
    int i = 0;
    for(i = 0; i < FAR_PS_FD_MAX; i++)
    {
        if(g_farps_port_info[i].fd  == fd)
        {
            return g_farps_port_info[i].state;
        }
    }
    //CPȲμ
    return 1;
}

/**
 * @brief ͨfdȡͻAPPͨ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
char *at_portmng_get_name_by_fd(int fd)
{
    int i = 0;
    for(i = 0; i < FAR_PS_FD_MAX; i++)
    {
        if(g_farps_port_info[i].fd  == fd)
        {
            return g_farps_port_info[i].name;
        }
    }
    return NULL;
}

void at_hotplug_set_state(const char * name, int state)
{
	int i;
	int ilde_idx = -1;
	int fd = at_portmng_get_fd_by_name(name);
	
	for(i=0; i<FAR_PS_FD_MAX; i++)
	{
		if(0 == strlen(g_farps_hotplug_msg[i].name))
		{
			if(ilde_idx < 0)
			{
				ilde_idx = i;
			}
			continue;
		}
		
		if(!strcmp(g_farps_hotplug_msg[i].name, name))
		{
			g_farps_hotplug_msg[i].state = state;
			if(fd >= 0)
			g_farps_hotplug_msg[i].fd = fd;
			return;
		}
	}
	if(ilde_idx < 0)
	{
		at_print(AT_ERR,"ERR: g_farps_hotplug_msg is full\n");
		//softap_assert("");
		return;
	}
	strncpy(g_farps_hotplug_msg[ilde_idx].name,name,AT_PORT_NAME_LEN-1);
	g_farps_hotplug_msg[ilde_idx].state = state;
	g_farps_hotplug_msg[ilde_idx].fd = fd;
}

void at_hotplug_proc(void)
{
	if(g_farps_hotplug_flag == 0)
	{
		return;
	}
	struct farps_port_info msg[FAR_PS_FD_MAX];
	int i;
	int ret;
	pthread_mutex_lock(&g_hotplug_mutex);
	memcpy(msg, g_farps_hotplug_msg, sizeof(struct farps_port_info)*FAR_PS_FD_MAX);
	memset(g_farps_hotplug_msg, 0, sizeof(struct farps_port_info)*FAR_PS_FD_MAX);
	g_farps_hotplug_flag = 0;
	pthread_mutex_unlock(&g_hotplug_mutex);
	
	for(i=0; i<FAR_PS_FD_MAX; i++)
	{
		if(strlen(msg[i].name) > 0)
		{
			at_print(AT_ERR,"at_hotplug_proc fd=%d %s %d\n",msg[i].fd, msg[i].name,msg[i].state);
			if(msg[i].fd >= 0)
			{
				ret = at_close(msg[i].fd);
				at_print(AT_ERR,"close %s ===> fd: %d ret: %d er_no: %d\n", msg[i].name, msg[i].fd, ret, errno);
			}
			if(msg[i].state) 
			{
				int fd = at_open(msg[i].name,O_RDWR);
				at_print(AT_ERR,"open %s ===> fd: %d er_no: %d\n", msg[i].name, fd, errno);
				if(fd >= 0)
				{
					msg[i].fd = fd;
				}
			}
			ret = ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_INNER_AT_PORT_OPEN, sizeof(struct farps_port_info), (unsigned char *)&msg[i], 0);
			if(ret != 0)
			{
				softap_assert("send msg to at_ctl failed!!!");
			}
		}
	}	
}

//򿪹رʵͨϢĿǰڴzte_drvcommngӦ
//Ĵںcmux豸Ĵ򿪻߹ر
extern int cap_usb_hotplug(const char *name, int is_open);
int  proc_at_port_hotplug(MSG_BUF *msg_buf)
{
	switch (msg_buf->usMsgCmd)
    {
    case MSG_CMD_AT_PORT_OPEN:/* ͻAPPͨ״̬ʵatͨ*/
		at_print(AT_DEBUG,"PORT_OPEN: port name %s\n", msg_buf->aucDataBuf);
		if(strlen(msg_buf->aucDataBuf) >= AT_PORT_NAME_LEN)
		{
			at_print(AT_ERR,"PORT_OPEN: port name %s error\n", msg_buf->aucDataBuf);
			return 1;
		}
#ifdef USE_CAP_SUPPORT
		if(cap_usb_hotplug(msg_buf->aucDataBuf, 1))
			return 1;
#endif
		if(at_portmng_get_fd_by_name((msg_buf->aucDataBuf)) >= 0 && g_farps_hotplug_flag == 0)
		{
			at_print(AT_ERR,"PORT_OPEN: %s is opened\n", msg_buf->aucDataBuf);
			return 1;
		}
		pthread_mutex_lock(&g_hotplug_mutex);
        at_hotplug_set_state((const char *)(msg_buf->aucDataBuf),1);
		g_farps_hotplug_flag=1;
		pthread_mutex_unlock(&g_hotplug_mutex);
        return 1;
    case MSG_CMD_AT_PORT_CLOSE:/* ͻAPPͨ״̬رʵatͨ*/
		at_print(AT_DEBUG,"PORT_CLOSE: port name %s\n", msg_buf->aucDataBuf);
		if(strlen(msg_buf->aucDataBuf) >= AT_PORT_NAME_LEN)
		{
			at_print(AT_ERR,"PORT_CLOSE: port name %s error\n", msg_buf->aucDataBuf);
			return 1;
		}
#ifdef USE_CAP_SUPPORT
		if(cap_usb_hotplug(msg_buf->aucDataBuf, 0))
			return 1;
#endif
		pthread_mutex_lock(&g_hotplug_mutex);
        at_hotplug_set_state((const char *)(msg_buf->aucDataBuf),0);
		g_farps_hotplug_flag=1;
		pthread_mutex_unlock(&g_hotplug_mutex);
		at_portmng_set_state_proc((const char *)(msg_buf->aucDataBuf), 0, -1);
        return 1;
	case ATCTL_INNER_AT_PORT_OPEN:
		{
			struct farps_port_info *msg = (struct farps_port_info *)(msg_buf->aucDataBuf);
			if(msg->state == 0 && at_portmng_get_fd_by_name(msg->name) >= 0)
			{
				pthread_mutex_lock(&g_hotplug_mutex);
				at_hotplug_set_state((const char *)(msg->name),0);
				g_farps_hotplug_flag=1;
				pthread_mutex_unlock(&g_hotplug_mutex);
			}
			at_portmng_set_state_proc(msg->name, msg->state, msg->fd);
		}
        return 1;
	default:
		break;
	}
	return 0;
}

void channel_info_print()
{
	at_print(AT_ERR,"==============channel_info begin===============\n");
	int i = 0;
    for(i = 0; i < FAR_PS_FD_MAX; i++)
    {
    	if(g_farps_port_info[i].fd > 0)
        	at_print(AT_ERR,"[FAR_PS]fd: %d =====>device name: %s\n",g_farps_port_info[i].fd, g_farps_port_info[i].name);
    }
    for(i = 0; i < FAR_PS_FD_MAX; i++)
    {
    	if(strlen(g_farps_hotplug_msg[i].name) > 0)
        	at_print(AT_ERR,"[FAR_PS]hotplug_fd: %d stat: %d device name: %s\n",g_farps_hotplug_msg[i].fd, g_farps_hotplug_msg[i].state, g_farps_hotplug_msg[i].name);
    }
	at_print(AT_ERR,"==============channel_info end=================\n");
}

//ڼ⵱ǰfdǷFAR_PS
int check_is_farps(int fd)
{
	int i = 0;
	
	for(i=0;i<FAR_PS_FD_MAX;i++)
	{
		//if(FD_FAR_PS[i] == 0)
		//	break;
		if(FD_FAR_PS[i] == fd)
			return 1;
	}
	return 0;
}

//ͨȡʱʱid
USHORT get_timerID_by_fd(int fd)
{
	int i = 0;
	
	for(i=0;i<FAR_PS_FD_MAX;i++)
	{
		if(FD_FAR_PS[i] == fd)
			return (AtWaitCompleteStart+i);
	}
	return -1;
}


