#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <linux/types.h>
#include <linux/netlink.h>
#include <errno.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <syslog.h>
#include <sys/klog.h>
#include <signal.h>
#include "sd_httpshare.h"
#include "hotplug.h"


//#define UEVENT_BUFFER_SIZE 1024*6
//#define SD_ONLINE_MESSAGE "add@/devices/platform/zx297520_mmc.0/mmc_host/mmc0/mmc0"
//#define SD_OFFLINE_MESSAGE "remove@/devices/platform/zx297520_mmc.0/mmc_host/mmc0/mmc0"
#define SD_ONLINE_MESSAGE "add@/devices/platform/zx29_sd.1"
#define SD_OFFLINE_MESSAGE "remove@/devices/platform/zx29_sd.1"
#define PATH_LENGTH 256
char usb_lun_path[PATH_LENGTH] = {0};

/*дļزbegin*/
int filelength(FILE *fp)
{
    int num;
    fseek(fp,0,SEEK_END);
    num=ftell(fp);
    fseek(fp,0,SEEK_SET);
    return num;
}

static int readfile(char *path, char* buf, unsigned len)
{
    FILE *fp;
    unsigned int length;
    if((fp=fopen(path,"r"))==NULL)
    {
        slog(SDCARD_PRINT, SLOG_ERR, "open file %s error.\n",path);
        return -1;
    }
    length=filelength(fp);
    length = length > len? len: length;
    //ch=(char *)malloc(length+1);
    int read_len = fread(buf,length,1,fp);
    if(read_len < 1)  // cov M CHECKED_RETURN
    {
        slog(SDCARD_PRINT, SLOG_ERR, "fread %s error.\n",path); 
    }
    fclose(fp);
    *(buf+length)='\0';
    return (int)length;
}

int sd_get_cdrom()
{
	char cdrom0[8] = {0};
	char cdrom1[8] = {0};
	int rtv = 0;
	int cdrom_state0 = -1;
	int cdrom_state1 = -1;
	
	rtv = readfile("/sys/devices/platform/zx29_hsotg.0/gadget/lun0/cdrom", cdrom0, sizeof(cdrom0)-1);
	cdrom_state0 = atoi(cdrom0);
	rtv = readfile("/sys/devices/platform/zx29_hsotg.0/gadget/lun1/cdrom", cdrom1, sizeof(cdrom1)-1);
	cdrom_state1 = atoi(cdrom1);
	
	if (cdrom_state0 == 0)	//lun0Ϊu
	{
		return 0;
	}

	if (cdrom_state1 == 0)	//lun1Ϊu
	{
		return 1;
	}

	return -1;

}

static int init_hotplug_sock()
{
	int ret;

	struct sockaddr_nl snl;
	bzero(&snl, sizeof(struct sockaddr_nl));
	snl.nl_family = AF_NETLINK;
	snl.nl_pid = getpid();
	snl.nl_groups = 1;

	if (signal(SIGPIPE, SIG_IGN) == SIG_ERR)
		perror("signal");

	int s = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);
	if (s == -1) {
		perror("socket");
		return -1;
	}
//  setsockopt(s, SOL_SOCKET, SO_RCVBUF, &buffersize, sizeof(buffersize));

	ret = bind(s, (struct sockaddr *)&snl, sizeof(struct sockaddr_nl));
	if (ret < 0) {
		perror("bind");
		close(s);
		return -1;
	}

	return s;
}

int sd_app_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
	char sd_card_state[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	char cmd[MAX_CMD_LEN] = {0};

	if (strncmp(msg, SD_ONLINE_MESSAGE, strlen(SD_ONLINE_MESSAGE)) == 0) {
		memset(sd_card_state, 0, sizeof(sd_card_state));
		sc_cfg_get("sd_card_state", sd_card_state, sizeof(sd_card_state));
		
		slog(SDCARD_PRINT, SLOG_DEBUG, "[%s][%d], state:%s\n", __func__, __LINE__, sd_card_state);

		//0-γ 1-
		if (0 == strcmp("0", sd_card_state)) {
			zte_httpshare_init();
			slog(SDCARD_PRINT, SLOG_NORMAL, "[sdcard-hotplug]init sd mode!\n");
		} else
			slog(SDCARD_PRINT, SLOG_NORMAL, "[sdcard-hotplug]init sd ok!\n");
	} else if (strncmp(msg, SD_OFFLINE_MESSAGE, strlen(SD_OFFLINE_MESSAGE)) == 0) {
		slog(SDCARD_PRINT, SLOG_DEBUG, "[%s][%d]\n", __func__, __LINE__);
		sc_cfg_set("sd_card_state", "0");

#if 0
		zte_httpshare_call_system("umount /dev/mmcblk0");
		zte_httpshare_call_system("umount /mnt/jffs2/etc_rw/config/mmc2");
		zte_httpshare_call_system("umount /etc_rw/config/mmc2");
#endif
		zte_umount_dev();

		memset(cmd, 0, sizeof(cmd));
		snprintf(cmd, sizeof(cmd), "echo NULL > %s", usb_lun_path);
		soft_system(cmd);
		//zte_httpshare_call_system("echo NULL > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
		slog(SDCARD_PRINT, SLOG_NORMAL, "[sdcard-hotplug]remove sd!\n");
	}

	return 0;
}


int sd_hotplug_init(viod)
{
	int cdrom = -1;
	
	if (ZTE_HTTPSHARE_SUCCESS != zte_init_sdcard_path()) {
		slog(SDCARD_PRINT, SLOG_ERR, "%s does not exist.\n", SD_CARD_PATH_PR);
		return -1;
	}

	// ȡusb lun豸·
	cdrom = sd_get_cdrom();
	slog(SDCARD_PRINT, SLOG_ERR,"sd_hotplug:cdrom=%d\n",cdrom);
	if (cdrom == 0)
		memcpy(usb_lun_path, USB_HTTPSHARE_LUN0_PATH, strlen(USB_HTTPSHARE_LUN0_PATH));
	else if(cdrom == 1)
		memcpy(usb_lun_path, USB_HTTPSHARE_LUN1_PATH, strlen(USB_HTTPSHARE_LUN1_PATH));
	else
	{
		slog(SDCARD_PRINT, SLOG_ERR, "lun for usb not exsited.\n");
		return -1;
	}
	slog(SDCARD_PRINT, SLOG_ERR,"sd_hotplug usb_lun_path=%s\n", usb_lun_path);

	hotplug_parse_register(DEVICE_TYPE_APP_SDCARD, sd_app_msg_parse);

	return 0;
}

int sd_hotplug_main(int argc, char* argv[])
{
	int hotplug_sock = 0;
	char sd_card_state[ZTE_HTTPSHARE_DEFAULT_LEN] = {0};
	char buf[UEVENT_BUFFER_SIZE] = {0};
	char cmd[MAX_CMD_LEN] = {0};
	int len = 0;
	int cdrom = -1;
	prctl(PR_SET_NAME, "sd_hotplug", 0, 0, 0);
	
	//NVʼӡ𣬲עᶯ̬ӡź
	loglevel_init();
	
	hotplug_sock = init_hotplug_sock();
	if (hotplug_sock < 0) {
		slog(SDCARD_PRINT, SLOG_ERR, "[sdcard_hotplug]create netlink socket failed!\n");
		return -1;
	}

	if (ZTE_HTTPSHARE_SUCCESS != zte_init_sdcard_path()) {
		slog(SDCARD_PRINT, SLOG_ERR, "%s does not exist.\n", SD_CARD_PATH_PR);
		close(hotplug_sock);
		return -1;
	}

	// ȡusb lun豸·
	cdrom = sd_get_cdrom();
	slog(SDCARD_PRINT, SLOG_ERR,"sd_hotplug:cdrom=%d\n",cdrom);
	if(cdrom != 0 && cdrom != 1)
	{
		slog(SDCARD_PRINT, SLOG_ERR, "lun for usb not exsited.\n");
		close(hotplug_sock);
		return -1;
	}
	
	if (cdrom == 0){
		len = strlen(USB_HTTPSHARE_LUN0_PATH);
		memcpy(usb_lun_path, USB_HTTPSHARE_LUN0_PATH, len);
	}else if(cdrom == 1){
		len = strlen(USB_HTTPSHARE_LUN1_PATH);
		memcpy(usb_lun_path, USB_HTTPSHARE_LUN1_PATH, len);
	}
	
	if(len >= PATH_LENGTH){
		usb_lun_path[PATH_LENGTH -1] = '\0';
	} else{
		usb_lun_path[len] = '\0';
	}
	
	slog(SDCARD_PRINT, SLOG_ERR,"sd_hotplug usb_lun_path=%s\n", usb_lun_path);

	while (1) {
		/* Netlink message buffer */
		memset(buf, 0, sizeof(buf));
		len = recv(hotplug_sock, &buf, sizeof(buf)-1, 0);
		if (len <= 0) {
			continue;
		}

		if (strncmp(buf, SD_ONLINE_MESSAGE, strlen(SD_ONLINE_MESSAGE)) == 0) {
			memset(sd_card_state, 0, sizeof(sd_card_state));
			sc_cfg_get("sd_card_state", sd_card_state, sizeof(sd_card_state));
			
			slog(SDCARD_PRINT, SLOG_DEBUG, "[%s][%d], state:%s\n", __func__, __LINE__, sd_card_state);

			//0-γ 1-
			if (0 == strcmp("0", sd_card_state)) {
				zte_httpshare_init();
				slog(SDCARD_PRINT, SLOG_NORMAL, "[sdcard-hotplug]init sd mode!\n");
			} else
				slog(SDCARD_PRINT, SLOG_NORMAL, "[sdcard-hotplug]init sd ok!\n");
		} else if (strncmp(buf, SD_OFFLINE_MESSAGE, strlen(SD_OFFLINE_MESSAGE)) == 0) {
			slog(SDCARD_PRINT, SLOG_DEBUG, "[%s][%d]\n", __func__, __LINE__);
			sc_cfg_set("sd_card_state", "0");

#if 0
			zte_httpshare_call_system("umount /dev/mmcblk0");
			zte_httpshare_call_system("umount /mnt/jffs2/etc_rw/config/mmc2");
			zte_httpshare_call_system("umount /etc_rw/config/mmc2");
#endif
			zte_umount_dev();

			memset(cmd, 0, sizeof(cmd));
			snprintf(cmd, sizeof(cmd), "echo NULL > %s", usb_lun_path);
			soft_system(cmd);
			//zte_httpshare_call_system("echo NULL > /sys/devices/platform/zx29_hsotg.0/gadget/lun1/file");
			slog(SDCARD_PRINT, SLOG_NORMAL, "[sdcard-hotplug]remove sd!\n");
		}
	}

	//close(hotplug_sock);//klocwork
	return 0;
}
